'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    messageBarActionsClassNames: function() {
        return messageBarActionsClassNames;
    },
    useMessageBarActionsStyles_unstable: function() {
        return useMessageBarActionsStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const messageBarActionsClassNames = {
    root: 'fui-MessageBarActions',
    containerAction: 'fui-MessageBarActions__containerAction'
};
/**
 * Styles for the root slot
 */ const useRootBaseStyles = (0, _react.makeResetStyles)({
    gridArea: 'secondaryActions',
    display: 'flex',
    columnGap: _reacttheme.tokens.spacingHorizontalM,
    paddingRight: _reacttheme.tokens.spacingHorizontalM
});
const useContainerActionBaseStyles = (0, _react.makeResetStyles)({
    gridArea: 'actions',
    paddingRight: _reacttheme.tokens.spacingHorizontalM
});
const useMultilineStyles = (0, _react.makeStyles)({
    root: {
        justifyContent: 'end',
        marginTop: _reacttheme.tokens.spacingVerticalMNudge,
        marginBottom: _reacttheme.tokens.spacingVerticalS,
        marginRight: '0px',
        paddingRight: _reacttheme.tokens.spacingVerticalM
    },
    noActions: {
        display: 'none'
    }
});
const useMessageBarActionsStyles_unstable = (state)=>{
    'use no memo';
    const rootBaseStyles = useRootBaseStyles();
    const containerActionBaseStyles = useContainerActionBaseStyles();
    const multilineStyles = useMultilineStyles();
    state.root.className = (0, _react.mergeClasses)(messageBarActionsClassNames.root, rootBaseStyles, state.layout === 'multiline' && multilineStyles.root, !state.hasActions && multilineStyles.noActions, state.root.className);
    if (state.containerAction) {
        state.containerAction.className = (0, _react.mergeClasses)(messageBarActionsClassNames.containerAction, containerActionBaseStyles, state.containerAction.className);
    }
    return state;
};
