'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    messageBarClassNames: function() {
        return messageBarClassNames;
    },
    useMessageBarStyles_unstable: function() {
        return useMessageBarStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const messageBarClassNames = {
    root: 'fui-MessageBar',
    icon: 'fui-MessageBar__icon',
    bottomReflowSpacer: 'fui-MessageBar__bottomReflowSpacer'
};
const useRootBaseStyles = (0, _react.makeResetStyles)({
    whiteSpace: 'nowrap',
    display: 'grid',
    gridTemplateColumns: 'auto 1fr auto auto',
    gridTemplateRows: '1fr',
    gridTemplateAreas: '"icon body secondaryActions actions"',
    paddingLeft: _reacttheme.tokens.spacingHorizontalM,
    border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorNeutralStroke1}`,
    borderRadius: _reacttheme.tokens.borderRadiusMedium,
    alignItems: 'center',
    minHeight: '36px',
    boxSizing: 'border-box',
    backgroundColor: _reacttheme.tokens.colorNeutralBackground3
});
const useIconBaseStyles = (0, _react.makeResetStyles)({
    gridArea: 'icon',
    fontSize: _reacttheme.tokens.fontSizeBase500,
    marginRight: _reacttheme.tokens.spacingHorizontalS,
    color: _reacttheme.tokens.colorNeutralForeground3,
    display: 'flex',
    alignItems: 'center'
});
const useReflowSpacerBaseStyles = (0, _react.makeResetStyles)({
    marginBottom: _reacttheme.tokens.spacingVerticalS,
    gridArea: 'secondaryActions'
});
const useStyles = (0, _react.makeStyles)({
    rootMultiline: {
        whiteSpace: 'normal',
        alignItems: 'start',
        paddingTop: _reacttheme.tokens.spacingVerticalMNudge,
        gridTemplateColumns: 'auto 1fr auto',
        gridTemplateAreas: `
      "icon body actions"
      "secondaryActions secondaryActions secondaryActions"
    `
    },
    secondaryActionsMultiline: {
        justifyContent: 'end',
        marginTop: _reacttheme.tokens.spacingVerticalMNudge,
        marginBottom: _reacttheme.tokens.spacingVerticalS,
        marginRight: '0px'
    },
    square: {
        borderRadius: '0'
    }
});
const useIconIntentStyles = (0, _react.makeStyles)({
    info: {},
    error: {
        color: _reacttheme.tokens.colorStatusDangerForeground1
    },
    warning: {
        color: _reacttheme.tokens.colorStatusWarningForeground3
    },
    success: {
        color: _reacttheme.tokens.colorStatusSuccessForeground1
    }
});
const useRootIntentStyles = (0, _react.makeStyles)({
    info: {},
    error: {
        backgroundColor: _reacttheme.tokens.colorStatusDangerBackground1,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorStatusDangerBorder1)
    },
    warning: {
        backgroundColor: _reacttheme.tokens.colorStatusWarningBackground1,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorStatusWarningBorder1)
    },
    success: {
        backgroundColor: _reacttheme.tokens.colorStatusSuccessBackground1,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorStatusSuccessBorder1)
    }
});
const useMessageBarStyles_unstable = (state)=>{
    'use no memo';
    const rootBaseStyles = useRootBaseStyles();
    const iconBaseStyles = useIconBaseStyles();
    const iconIntentStyles = useIconIntentStyles();
    const rootIntentStyles = useRootIntentStyles();
    const reflowSpacerStyles = useReflowSpacerBaseStyles();
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(messageBarClassNames.root, rootBaseStyles, state.layout === 'multiline' && styles.rootMultiline, state.shape === 'square' && styles.square, rootIntentStyles[state.intent], state.root.className);
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(messageBarClassNames.icon, iconBaseStyles, iconIntentStyles[state.intent], state.icon.className);
    }
    if (state.bottomReflowSpacer) {
        state.bottomReflowSpacer.className = (0, _react.mergeClasses)(messageBarClassNames.bottomReflowSpacer, reflowSpacerStyles);
    }
    return state;
};
