'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    messageBarClassNames: function() {
        return messageBarClassNames;
    },
    useMessageBarStyles_unstable: function() {
        return useMessageBarStyles_unstable;
    }
});
const _react = require("@griffel/react");
const messageBarClassNames = {
    root: 'fui-MessageBar',
    icon: 'fui-MessageBar__icon',
    bottomReflowSpacer: 'fui-MessageBar__bottomReflowSpacer'
};
const useRootBaseStyles = /*#__PURE__*/ (0, _react.__resetStyles)("r2oyxsj", "r1wuyrhw", [
    ".r2oyxsj{white-space:nowrap;display:grid;grid-template-columns:auto 1fr auto auto;grid-template-rows:1fr;grid-template-areas:\"icon body secondaryActions actions\";padding-left:var(--spacingHorizontalM);border:var(--strokeWidthThin) solid var(--colorNeutralStroke1);border-radius:var(--borderRadiusMedium);align-items:center;min-height:36px;box-sizing:border-box;background-color:var(--colorNeutralBackground3);}",
    ".r1wuyrhw{white-space:nowrap;display:grid;grid-template-columns:auto 1fr auto auto;grid-template-rows:1fr;grid-template-areas:\"icon body secondaryActions actions\";padding-right:var(--spacingHorizontalM);border:var(--strokeWidthThin) solid var(--colorNeutralStroke1);border-radius:var(--borderRadiusMedium);align-items:center;min-height:36px;box-sizing:border-box;background-color:var(--colorNeutralBackground3);}"
]);
const useIconBaseStyles = /*#__PURE__*/ (0, _react.__resetStyles)("r1df1z33", "rivnfjc", [
    ".r1df1z33{grid-area:icon;font-size:var(--fontSizeBase500);margin-right:var(--spacingHorizontalS);color:var(--colorNeutralForeground3);display:flex;align-items:center;}",
    ".rivnfjc{grid-area:icon;font-size:var(--fontSizeBase500);margin-left:var(--spacingHorizontalS);color:var(--colorNeutralForeground3);display:flex;align-items:center;}"
]);
const useReflowSpacerBaseStyles = /*#__PURE__*/ (0, _react.__resetStyles)("r1vx593n", null, [
    ".r1vx593n{margin-bottom:var(--spacingVerticalS);grid-area:secondaryActions;}"
]);
const useStyles = /*#__PURE__*/ (0, _react.__styles)({
    rootMultiline: {
        Huce71: "f6juhto",
        Bt984gj: "f1s2louj",
        z8tnut: "f1ngh7ph",
        Budl1dq: "f17g0uqy",
        zoa1oz: "f1w7oly7"
    },
    secondaryActionsMultiline: {
        Brf1p80: "f1e8xxv9",
        B6of3ja: "f1gaxbfw",
        jrapky: "fqcjy3b",
        t21cq0: [
            "fibjyge",
            "f9yszdx"
        ]
    },
    square: {
        Beyfa6y: 0,
        Bbmb7ep: 0,
        Btl43ni: 0,
        B7oj6ja: 0,
        Dimara: "fokr779"
    }
}, {
    d: [
        ".f6juhto{white-space:normal;}",
        ".f1s2louj{align-items:start;}",
        ".f1ngh7ph{padding-top:var(--spacingVerticalMNudge);}",
        ".f17g0uqy{grid-template-columns:auto 1fr auto;}",
        ".f1w7oly7{grid-template-areas:\"icon body actions\" \"secondaryActions secondaryActions secondaryActions\";}",
        ".f1e8xxv9{justify-content:end;}",
        ".f1gaxbfw{margin-top:var(--spacingVerticalMNudge);}",
        ".fqcjy3b{margin-bottom:var(--spacingVerticalS);}",
        ".fibjyge{margin-right:0px;}",
        ".f9yszdx{margin-left:0px;}",
        [
            ".fokr779{border-radius:0;}",
            {
                p: -1
            }
        ]
    ]
});
const useIconIntentStyles = /*#__PURE__*/ (0, _react.__styles)({
    info: {},
    error: {
        sj55zd: "f1ca9wz"
    },
    warning: {
        sj55zd: "f14a4cve"
    },
    success: {
        sj55zd: "f36rra6"
    }
}, {
    d: [
        ".f1ca9wz{color:var(--colorStatusDangerForeground1);}",
        ".f14a4cve{color:var(--colorStatusWarningForeground3);}",
        ".f36rra6{color:var(--colorStatusSuccessForeground1);}"
    ]
});
const useRootIntentStyles = /*#__PURE__*/ (0, _react.__styles)({
    info: {},
    error: {
        De3pzq: "f1eon7jj",
        g2u3we: "f1f8dvr7",
        h3c5rm: [
            "f1g1ijmo",
            "f1nxacbt"
        ],
        B9xav0g: "fo25q1j",
        zhjwy3: [
            "f1nxacbt",
            "f1g1ijmo"
        ]
    },
    warning: {
        De3pzq: "f13ftzij",
        g2u3we: "frd1ypx",
        h3c5rm: [
            "f1gyjrma",
            "f18qd5xz"
        ],
        B9xav0g: "fqyqtrt",
        zhjwy3: [
            "f18qd5xz",
            "f1gyjrma"
        ]
    },
    success: {
        De3pzq: "f64thcm",
        g2u3we: "f1b4u7v",
        h3c5rm: [
            "f1nyd2b1",
            "f70v3om"
        ],
        B9xav0g: "fk173vo",
        zhjwy3: [
            "f70v3om",
            "f1nyd2b1"
        ]
    }
}, {
    d: [
        ".f1eon7jj{background-color:var(--colorStatusDangerBackground1);}",
        ".f1f8dvr7{border-top-color:var(--colorStatusDangerBorder1);}",
        ".f1g1ijmo{border-right-color:var(--colorStatusDangerBorder1);}",
        ".f1nxacbt{border-left-color:var(--colorStatusDangerBorder1);}",
        ".fo25q1j{border-bottom-color:var(--colorStatusDangerBorder1);}",
        ".f13ftzij{background-color:var(--colorStatusWarningBackground1);}",
        ".frd1ypx{border-top-color:var(--colorStatusWarningBorder1);}",
        ".f1gyjrma{border-right-color:var(--colorStatusWarningBorder1);}",
        ".f18qd5xz{border-left-color:var(--colorStatusWarningBorder1);}",
        ".fqyqtrt{border-bottom-color:var(--colorStatusWarningBorder1);}",
        ".f64thcm{background-color:var(--colorStatusSuccessBackground1);}",
        ".f1b4u7v{border-top-color:var(--colorStatusSuccessBorder1);}",
        ".f1nyd2b1{border-right-color:var(--colorStatusSuccessBorder1);}",
        ".f70v3om{border-left-color:var(--colorStatusSuccessBorder1);}",
        ".fk173vo{border-bottom-color:var(--colorStatusSuccessBorder1);}"
    ]
});
const useMessageBarStyles_unstable = (state)=>{
    'use no memo';
    const rootBaseStyles = useRootBaseStyles();
    const iconBaseStyles = useIconBaseStyles();
    const iconIntentStyles = useIconIntentStyles();
    const rootIntentStyles = useRootIntentStyles();
    const reflowSpacerStyles = useReflowSpacerBaseStyles();
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(messageBarClassNames.root, rootBaseStyles, state.layout === 'multiline' && styles.rootMultiline, state.shape === 'square' && styles.square, rootIntentStyles[state.intent], state.root.className);
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(messageBarClassNames.icon, iconBaseStyles, iconIntentStyles[state.intent], state.icon.className);
    }
    if (state.bottomReflowSpacer) {
        state.bottomReflowSpacer.className = (0, _react.mergeClasses)(messageBarClassNames.bottomReflowSpacer, reflowSpacerStyles);
    }
    return state;
};
