'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useMessageBar_unstable", {
    enumerable: true,
    get: function() {
        return useMessageBar_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _getIntentIcon = require("./getIntentIcon");
const _useMessageBarReflow = require("./useMessageBarReflow");
const _messageBarTransitionContext = require("../../contexts/messageBarTransitionContext");
const _MotionRefForwarder = require("../MotionRefForwarder");
const useMessageBar_unstable = (props, ref)=>{
    const { layout = 'auto', intent = 'info', politeness, shape = 'rounded' } = props;
    const computedPoliteness = (politeness !== null && politeness !== void 0 ? politeness : intent === 'info') ? 'polite' : 'assertive';
    const autoReflow = layout === 'auto';
    const { ref: reflowRef, reflowing } = (0, _useMessageBarReflow.useMessageBarReflow)(autoReflow);
    const computedLayout = autoReflow ? reflowing ? 'multiline' : 'singleline' : layout;
    // eslint-disable-next-line @typescript-eslint/no-deprecated
    const { className: transitionClassName, nodeRef } = (0, _messageBarTransitionContext.useMessageBarTransitionContext)();
    const motionRef = (0, _MotionRefForwarder.useMotionForwardedRef)();
    const actionsRef = _react.useRef(null);
    const bodyRef = _react.useRef(null);
    const { announce } = (0, _reactsharedcontexts.useAnnounce)();
    const titleId = (0, _reactutilities.useId)();
    _react.useEffect(()=>{
        var _bodyRef_current, _actionsRef_current;
        const bodyMessage = (_bodyRef_current = bodyRef.current) === null || _bodyRef_current === void 0 ? void 0 : _bodyRef_current.textContent;
        const actionsMessage = (_actionsRef_current = actionsRef.current) === null || _actionsRef_current === void 0 ? void 0 : _actionsRef_current.textContent;
        const message = [
            bodyMessage,
            actionsMessage
        ].filter(Boolean).join(',');
        announce(message, {
            polite: computedPoliteness === 'polite',
            alert: computedPoliteness === 'assertive'
        });
    }, [
        bodyRef,
        actionsRef,
        announce,
        computedPoliteness
    ]);
    return {
        components: {
            root: 'div',
            icon: 'div',
            bottomReflowSpacer: 'div'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            ref: (0, _reactutilities.useMergedRefs)(ref, reflowRef, nodeRef, motionRef),
            role: 'group',
            'aria-labelledby': titleId,
            ...props
        }), {
            elementType: 'div'
        }),
        icon: _reactutilities.slot.optional(props.icon, {
            renderByDefault: true,
            elementType: 'div',
            defaultProps: {
                children: (0, _getIntentIcon.getIntentIcon)(intent)
            }
        }),
        bottomReflowSpacer: _reactutilities.slot.optional(props.bottomReflowSpacer, {
            renderByDefault: computedLayout === 'multiline',
            elementType: 'div'
        }),
        layout: computedLayout,
        intent,
        transitionClassName,
        actionsRef,
        bodyRef,
        titleId,
        shape
    };
};
