import type { ButtonContextValue } from '@fluentui/react-button';
import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

/**
 * MessageBar component
 */
export declare const MessageBar: ForwardRefComponent<MessageBarProps>;

/**
 * MessageBarActions component
 */
export declare const MessageBarActions: ForwardRefComponent<MessageBarActionsProps>;

export declare const messageBarActionsClassNames: SlotClassNames<MessageBarActionsSlots>;

export declare type MessageBarActionsContextValues = {
    button: ButtonContextValue;
};

/**
 * MessageBarActions Props
 */
export declare type MessageBarActionsProps = ComponentProps<MessageBarActionsSlots>;

export declare type MessageBarActionsSlots = {
    root: Slot<'div'>;
    /**
     * Generally the 'Dismiss' button for the MessageBar
     */
    containerAction?: Slot<'div'>;
};

/**
 * State used in rendering MessageBarActions
 */
export declare type MessageBarActionsState = ComponentState<MessageBarActionsSlots> & Pick<Required<MessageBarContextValue>, 'layout'> & {
    /**
     * Whether there are actions as children of this component
     */
    hasActions: boolean;
};

/**
 * MessageBarBody component
 */
export declare const MessageBarBody: ForwardRefComponent<MessageBarBodyProps>;

export declare const messageBarBodyClassNames: SlotClassNames<MessageBarBodySlots>;

declare type MessageBarBodyContextValues = {
    link: {
        inline?: boolean;
    };
};

/**
 * MessageBarBody Props
 */
export declare type MessageBarBodyProps = ComponentProps<MessageBarBodySlots>;

export declare type MessageBarBodySlots = {
    root: Slot<'div'>;
};

/**
 * State used in rendering MessageBarBody
 */
export declare type MessageBarBodyState = ComponentState<MessageBarBodySlots>;

export declare const messageBarClassNames: SlotClassNames<MessageBarSlots>;

export declare const messageBarContextDefaultValue: MessageBarContextValue;

export declare const MessageBarContextProvider: React_2.Provider<MessageBarContextValue | undefined>;

export declare type MessageBarContextValue = {
    layout: 'multiline' | 'singleline' | 'auto';
    actionsRef: React_2.MutableRefObject<HTMLDivElement | null>;
    bodyRef: React_2.MutableRefObject<HTMLDivElement | null>;
    titleId: string;
};

export declare type MessageBarContextValues = {
    messageBar: MessageBarContextValue;
};

/**
 * MessageBarGroup component
 */
export declare const MessageBarGroup: ForwardRefComponent<MessageBarGroupProps>;

export declare const messageBarGroupClassNames: SlotClassNames<MessageBarGroupSlots>;

/**
 * MessageBarGroup Props
 */
export declare type MessageBarGroupProps = ComponentProps<MessageBarGroupSlots> & {
    children: React_2.ReactElement[] | React_2.ReactElement;
    animate?: 'exit-only' | 'both';
};

export declare type MessageBarGroupSlots = {
    root: Slot<'div'>;
};

/**
 * State used in rendering MessageBarGroup
 */
export declare type MessageBarGroupState = ComponentState<MessageBarGroupSlots> & Pick<MessageBarGroupProps, 'animate'> & {
    /** @deprecated property is unused; these CSS animations were replaced by motion components */
    enterStyles: string;
    /** @deprecated property is unused; these CSS animations were replaced by motion components */
    exitStyles: string;
    children: React_2.ReactElement[];
};

export declare type MessageBarIntent = 'info' | 'success' | 'warning' | 'error';

/**
 * MessageBar Props
 */
export declare type MessageBarProps = ComponentProps<MessageBarSlots> & Pick<Partial<MessageBarContextValue>, 'layout'> & {
    /**
     * Default designs announcement presets
     * @default info
     */
    intent?: MessageBarIntent;
    /**
     * @see https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Live_Regions
     */
    politeness?: 'assertive' | 'polite';
    /**
     * Use squal for page level messages and rounded for component level messages
     * @default rounded
     */
    shape?: 'square' | 'rounded';
};

export declare type MessageBarSlots = {
    root: Slot<'div'>;
    icon?: Slot<'div'>;
    /**
     * Rendered when the component is in multiline layout to guarantee correct spacing even
     * if no actions are rendered. When actions are rendered, the default actions grid area will render
     * over this element
     *
     * NOTE: If you are using this slot, this probably means that you are using the MessageBar without
     * actions, this is not recommended from an accesibility point of view
     */
    bottomReflowSpacer?: Slot<'div'>;
};

/**
 * State used in rendering MessageBar
 */
export declare type MessageBarState = ComponentState<MessageBarSlots> & Required<Pick<MessageBarProps, 'layout' | 'intent' | 'shape'>> & Pick<MessageBarContextValue, 'actionsRef' | 'bodyRef' | 'titleId'> & {
    /**
     * @deprecated Code is unused, replaced by motion components
     */
    transitionClassName: string;
};

/**
 * MessageBarTitle component
 */
export declare const MessageBarTitle: ForwardRefComponent<MessageBarTitleProps>;

export declare const messageBarTitleClassNames: SlotClassNames<MessageBarTitleSlots>;

/**
 * MessageBarTitle Props
 */
export declare type MessageBarTitleProps = ComponentProps<MessageBarTitleSlots>;

export declare type MessageBarTitleSlots = {
    root: Slot<'span'>;
};

/**
 * State used in rendering MessageBarTitle
 */
export declare type MessageBarTitleState = ComponentState<MessageBarTitleSlots>;

/**
 * @internal
 */
export declare const messageBarTransitionContextDefaultValue: MessageBarTransitionContextValue;

/**
 * Context to pass nodeRef for animation to MessageBar components
 * @internal
 */
export declare const MessageBarTransitionContextProvider: React_2.Provider<MessageBarTransitionContextValue | undefined>;

export declare type MessageBarTransitionContextValue = {
    /**
     * @deprecated CSS className is no longer used for this transition, replaced by motion components
     */
    className: string;
    nodeRef: React_2.Ref<HTMLDivElement | null>;
};

/**
 * Render the final JSX of MessageBar
 */
export declare const renderMessageBar_unstable: (state: MessageBarState, contexts: MessageBarContextValues) => JSXElement;

/**
 * Render the final JSX of MessageBarActions
 */
export declare const renderMessageBarActions_unstable: (state: MessageBarActionsState, contexts: MessageBarActionsContextValues) => JSXElement;

/**
 * Render the final JSX of MessageBarBody
 */
export declare const renderMessageBarBody_unstable: (state: MessageBarBodyState, contextValues: MessageBarBodyContextValues) => JSXElement;

/**
 * Render the final JSX of MessageBarGroup
 */
export declare const renderMessageBarGroup_unstable: (state: MessageBarGroupState) => JSXElement;

/**
 * Render the final JSX of MessageBarTitle
 */
export declare const renderMessageBarTitle_unstable: (state: MessageBarTitleState) => JSXElement;

/**
 * Create the state required to render MessageBar.
 *
 * The returned state can be modified with hooks such as useMessageBarStyles_unstable,
 * before being passed to renderMessageBar_unstable.
 *
 * @param props - props from this instance of MessageBar
 * @param ref - reference to root HTMLElement of MessageBar
 */
export declare const useMessageBar_unstable: (props: MessageBarProps, ref: React_2.Ref<HTMLDivElement>) => MessageBarState;

/**
 * Create the state required to render MessageBarActions.
 *
 * The returned state can be modified with hooks such as useMessageBarActionsStyles_unstable,
 * before being passed to renderMessageBarActions_unstable.
 *
 * @param props - props from this instance of MessageBarActions
 * @param ref - reference to root HTMLElement of MessageBarActions
 */
export declare const useMessageBarActions_unstable: (props: MessageBarActionsProps, ref: React_2.Ref<HTMLDivElement>) => MessageBarActionsState;

export declare function useMessageBarActionsContextValue_unstable(): MessageBarActionsContextValues;

/**
 * Apply styling to the MessageBarActions slots based on the state
 */
export declare const useMessageBarActionsStyles_unstable: (state: MessageBarActionsState) => MessageBarActionsState;

/**
 * Create the state required to render MessageBarBody.
 *
 * The returned state can be modified with hooks such as useMessageBarBodyStyles_unstable,
 * before being passed to renderMessageBarBody_unstable.
 *
 * @param props - props from this instance of MessageBarBody
 * @param ref - reference to root HTMLElement of MessageBarBody
 */
export declare const useMessageBarBody_unstable: (props: MessageBarBodyProps, ref: React_2.Ref<HTMLDivElement>) => MessageBarBodyState;

/**
 * Apply styling to the MessageBarBody slots based on the state
 */
export declare const useMessageBarBodyStyles_unstable: (state: MessageBarBodyState) => MessageBarBodyState;

export declare const useMessageBarContext: () => MessageBarContextValue;

export declare function useMessageBarContextValue_unstable(state: MessageBarState): MessageBarContextValues;

/**
 * Create the state required to render MessageBarGroup.
 *
 * The returned state can be modified with hooks such as useMessageBarGroupStyles_unstable,
 * before being passed to renderMessageBarGroup_unstable.
 *
 * @param props - props from this instance of MessageBarGroup
 * @param ref - reference to root HTMLElement of MessageBarGroup
 */
export declare const useMessageBarGroup_unstable: (props: MessageBarGroupProps, ref: React_2.Ref<HTMLDivElement>) => MessageBarGroupState;

/**
 * Apply styling to the MessageBarGroup slots based on the state
 */
export declare const useMessageBarGroupStyles_unstable: (state: MessageBarGroupState) => MessageBarGroupState;

/**
 * Apply styling to the MessageBar slots based on the state
 */
export declare const useMessageBarStyles_unstable: (state: MessageBarState) => MessageBarState;

/**
 * Create the state required to render MessageBarTitle.
 *
 * The returned state can be modified with hooks such as useMessageBarTitleStyles_unstable,
 * before being passed to renderMessageBarTitle_unstable.
 *
 * @param props - props from this instance of MessageBarTitle
 * @param ref - reference to root HTMLElement of MessageBarTitle
 */
export declare const useMessageBarTitle_unstable: (props: MessageBarTitleProps, ref: React_2.Ref<HTMLElement>) => MessageBarTitleState;

/**
 * Apply styling to the MessageBarTitle slots based on the state
 */
export declare const useMessageBarTitleStyles_unstable: (state: MessageBarTitleState) => MessageBarTitleState;

/**
 * @internal
 */
export declare const useMessageBarTransitionContext: () => MessageBarTransitionContextValue;

export { }
