'use client';
import * as React from 'react';
/**
 * Name of the custom event
 */ export const MENU_SAFEZONE_TIMEOUT_EVENT = 'fuimenusafezonetimeout';
/**
 * This hook listeners on a menu trigger for a custom event for an indication that a safe zone was closed over the
 * matching item.
 */ export const useOnMenuSafeZoneTimeout = (listener)=>{
    const elementRef = React.useRef(null);
    return React.useCallback((element)=>{
        var _elementRef_current;
        (_elementRef_current = elementRef.current) === null || _elementRef_current === void 0 ? void 0 : _elementRef_current.removeEventListener(MENU_SAFEZONE_TIMEOUT_EVENT, listener);
        element === null || element === void 0 ? void 0 : element.addEventListener(MENU_SAFEZONE_TIMEOUT_EVENT, listener);
        elementRef.current = element;
    }, [
        listener
    ]);
};
