'use client';

import { __styles, __resetStyles, mergeClasses, shorthands } from '@griffel/react';
import { tokens } from '@fluentui/react-theme';
import { useMenuItemStyles_unstable } from '../MenuItem/useMenuItemStyles.styles';
export const menuItemSwitchClassNames = {
  root: 'fui-MenuItemSwitch',
  icon: 'fui-MenuItemSwitch__icon',
  content: 'fui-MenuItemSwitch__content',
  secondaryContent: 'fui-MenuItemSwitch__secondaryContent',
  switchIndicator: 'fui-MenuItemSwitch__switchIndicator',
  subText: 'fui-MenuItemSwitch__subText'
};
export const circleFilledClassName = 'fui-MenuItemSwitch__switchIndicator__circleFilled';
// Thumb and track sizes used by the component.
const spaceBetweenThumbAndTrack = 2;
const trackHeight = 20;
const trackWidth = 40;
const thumbSize = trackHeight - spaceBetweenThumbAndTrack;
const useSwitchIndicatorBaseClassName = /*#__PURE__*/__resetStyles("r1x31n8g", "rsmcm5v", {
  r: [".r1x31n8g{border-radius:var(--borderRadiusCircular);border:var(--strokeWidthThin) solid var(--colorNeutralStrokeAccessible);line-height:0;box-sizing:border-box;fill:currentColor;flex-shrink:0;font-size:18px;height:20px;transition-duration:var(--durationNormal);transition-timing-function:var(--curveEasyEase);transition-property:background,border,color;width:40px;margin-right:var(--spacingHorizontalXS);color:var(--colorNeutralStrokeAccessible);}", ".r1x31n8g:hover{color:var(--colorNeutralStrokeAccessibleHover);border-color:var(--colorNeutralStrokeAccessibleHover);}", ".r1x31n8g:hover:active{color:var(--colorNeutralStrokeAccessiblePressed);border-color:var(--colorNeutralStrokeAccessiblePressed);}", ".r1x31n8g .fui-MenuItemSwitch__switchIndicator__circleFilled{transition-duration:var(--durationNormal);transition-timing-function:var(--curveEasyEase);transition-property:transform;}", ".rsmcm5v{border-radius:var(--borderRadiusCircular);border:var(--strokeWidthThin) solid var(--colorNeutralStrokeAccessible);line-height:0;box-sizing:border-box;fill:currentColor;flex-shrink:0;font-size:18px;height:20px;transition-duration:var(--durationNormal);transition-timing-function:var(--curveEasyEase);transition-property:background,border,color;width:40px;margin-left:var(--spacingHorizontalXS);color:var(--colorNeutralStrokeAccessible);}", ".rsmcm5v:hover{color:var(--colorNeutralStrokeAccessibleHover);border-color:var(--colorNeutralStrokeAccessibleHover);}", ".rsmcm5v:hover:active{color:var(--colorNeutralStrokeAccessiblePressed);border-color:var(--colorNeutralStrokeAccessiblePressed);}", ".rsmcm5v .fui-MenuItemSwitch__switchIndicator__circleFilled{transition-duration:var(--durationNormal);transition-timing-function:var(--curveEasyEase);transition-property:transform;}"],
  s: ["@media screen and (prefers-reduced-motion: reduce){.r1x31n8g{transition-duration:0.01ms;}}", "@media screen and (prefers-reduced-motion: reduce){.r1x31n8g .fui-MenuItemSwitch__switchIndicator__circleFilled{transition-duration:0.01ms;}}", "@media screen and (prefers-reduced-motion: reduce){.rsmcm5v{transition-duration:0.01ms;}}", "@media screen and (prefers-reduced-motion: reduce){.rsmcm5v .fui-MenuItemSwitch__switchIndicator__circleFilled{transition-duration:0.01ms;}}"]
});
const useSwitchIndicatorStyles = /*#__PURE__*/__styles({
  checked: {
    G4r02d: ["fdca5i2", "fk0rr1z"],
    De3pzq: "ftywsgz",
    sj55zd: "fqpbvvt",
    g2u3we: "fghlq4f",
    h3c5rm: ["f1gn591s", "fjscplz"],
    B9xav0g: "fb073pr",
    zhjwy3: ["fjscplz", "f1gn591s"],
    Bi91k9c: "fz46y8r",
    Jwef8y: "f1kjrvvj",
    Bgoe8wy: "fpa59ij",
    Bwzppfd: ["f1rhln42", "f1l1ogpg"],
    oetu4i: "fz67qlh",
    gg5e9n: ["f1l1ogpg", "f1rhln42"],
    B2d53fq: "frlnr8d",
    iro3zm: "fle2s0s",
    b661bw: "f1j8ziw4",
    Bk6r4ia: ["f1xzu9i0", "f1jlpvxk"],
    B9zn80p: "f1i1ccxp",
    Bpld233: ["f1jlpvxk", "f1xzu9i0"]
  }
}, {
  d: [".fdca5i2 .fui-MenuItemSwitch__switchIndicator__circleFilled{transform:translateX(20px);}", ".fk0rr1z .fui-MenuItemSwitch__switchIndicator__circleFilled{transform:translateX(-20px);}", ".ftywsgz{background-color:var(--colorCompoundBrandBackground);}", ".fqpbvvt{color:var(--colorNeutralForegroundInverted);}", ".fghlq4f{border-top-color:var(--colorTransparentStroke);}", ".f1gn591s{border-right-color:var(--colorTransparentStroke);}", ".fjscplz{border-left-color:var(--colorTransparentStroke);}", ".fb073pr{border-bottom-color:var(--colorTransparentStroke);}"],
  h: [".fz46y8r:hover{color:var(--colorNeutralForegroundInverted);}", ".f1kjrvvj:hover{background-color:var(--colorCompoundBrandBackgroundHover);}", ".fpa59ij:hover{border-top-color:var(--colorTransparentStrokeInteractive);}", ".f1rhln42:hover{border-right-color:var(--colorTransparentStrokeInteractive);}", ".f1l1ogpg:hover{border-left-color:var(--colorTransparentStrokeInteractive);}", ".fz67qlh:hover{border-bottom-color:var(--colorTransparentStrokeInteractive);}", ".frlnr8d:hover:active{color:var(--colorNeutralForegroundInverted);}", ".fle2s0s:hover:active{background-color:var(--colorCompoundBrandBackgroundPressed);}", ".f1j8ziw4:hover:active{border-top-color:var(--colorTransparentStrokeInteractive);}", ".f1xzu9i0:hover:active{border-right-color:var(--colorTransparentStrokeInteractive);}", ".f1jlpvxk:hover:active{border-left-color:var(--colorTransparentStrokeInteractive);}", ".f1i1ccxp:hover:active{border-bottom-color:var(--colorTransparentStrokeInteractive);}"]
});
const useMultilineStyles = /*#__PURE__*/__styles({
  "switch": {
    qb2dma: "f7nlbp4"
  }
}, {
  d: [".f7nlbp4{align-self:center;}"]
});
/**
 * Apply styling to the MenuItemSwitch slots based on the state
 */
export const useMenuItemSwitchStyles_unstable = state => {
  'use no memo';

  const {
    checked,
    subText
  } = state;
  const multiline = !!subText;
  const switchIndicatorStyles = useSwitchIndicatorStyles();
  const switchIndicatorBaseStyles = useSwitchIndicatorBaseClassName();
  const multilineStyles = useMultilineStyles();
  state.root.className = mergeClasses(menuItemSwitchClassNames.root, state.root.className);
  if (state.content) {
    state.content.className = mergeClasses(menuItemSwitchClassNames.content, state.content.className);
  }
  if (state.secondaryContent) {
    state.secondaryContent.className = mergeClasses(menuItemSwitchClassNames.secondaryContent, state.secondaryContent.className);
  }
  if (state.icon) {
    state.icon.className = mergeClasses(menuItemSwitchClassNames.icon, state.icon.className);
  }
  if (state.subText) {
    state.subText.className = mergeClasses(menuItemSwitchClassNames.subText, state.subText.className);
  }
  if (state.switchIndicator) {
    state.switchIndicator.className = mergeClasses(menuItemSwitchClassNames.switchIndicator, switchIndicatorBaseStyles, checked && switchIndicatorStyles.checked, state.switchIndicator.className, multiline && multilineStyles.switch);
  }
  useMenuItemStyles_unstable({
    ...state,
    components: {
      // eslint-disable-next-line @typescript-eslint/no-deprecated
      ...state.components,
      checkmark: 'span',
      submenuIndicator: 'span'
    },
    checkmark: undefined,
    submenuIndicator: undefined,
    hasSubmenu: false,
    persistOnClick: true
  });
  return state;
};