'use client';
import { mergeClasses } from '@griffel/react';
import { useCheckmarkStyles_unstable } from '../../selectable/index';
import { useMenuItemStyles_unstable } from '../MenuItem/useMenuItemStyles.styles';
export const menuItemCheckboxClassNames = {
    root: 'fui-MenuItemCheckbox',
    icon: 'fui-MenuItemCheckbox__icon',
    checkmark: 'fui-MenuItemCheckbox__checkmark',
    content: 'fui-MenuItemCheckbox__content',
    secondaryContent: 'fui-MenuItemCheckbox__secondaryContent',
    subText: 'fui-MenuItemCheckbox__subText'
};
export const useMenuItemCheckboxStyles_unstable = (state)=>{
    'use no memo';
    state.root.className = mergeClasses(menuItemCheckboxClassNames.root, state.root.className);
    if (state.content) {
        state.content.className = mergeClasses(menuItemCheckboxClassNames.content, state.content.className);
    }
    if (state.secondaryContent) {
        state.secondaryContent.className = mergeClasses(menuItemCheckboxClassNames.secondaryContent, state.secondaryContent.className);
    }
    if (state.icon) {
        state.icon.className = mergeClasses(menuItemCheckboxClassNames.icon, state.icon.className);
    }
    if (state.checkmark) {
        state.checkmark.className = mergeClasses(menuItemCheckboxClassNames.checkmark, state.checkmark.className);
    }
    if (state.subText) {
        state.subText.className = mergeClasses(menuItemCheckboxClassNames.subText, state.subText.className);
    }
    useMenuItemStyles_unstable(state);
    useCheckmarkStyles_unstable(state);
    return state;
};
