'use client';
import * as React from 'react';
import { slot } from '@fluentui/react-utilities';
import { Checkmark16Filled } from '@fluentui/react-icons';
import { useMenuListContext_unstable } from '../../contexts/menuListContext';
import { useMenuItem_unstable } from '../MenuItem/useMenuItem';
/** Returns the props and state required to render the component */ export const useMenuItemCheckbox_unstable = (props, ref)=>{
    const toggleCheckbox = useMenuListContext_unstable((context)=>context.toggleCheckbox);
    const { name, value } = props;
    const checked = useMenuListContext_unstable((context)=>{
        var _context_checkedValues;
        const checkedItems = ((_context_checkedValues = context.checkedValues) === null || _context_checkedValues === void 0 ? void 0 : _context_checkedValues[name]) || [];
        return checkedItems.indexOf(value) !== -1;
    });
    const state = {
        ...useMenuItem_unstable({
            role: 'menuitemcheckbox',
            persistOnClick: true,
            ...props,
            'aria-checked': checked,
            checkmark: slot.optional(props.checkmark, {
                defaultProps: {
                    children: /*#__PURE__*/ React.createElement(Checkmark16Filled, null)
                },
                renderByDefault: true,
                elementType: 'span'
            }),
            onClick: (e)=>{
                var _props_onClick;
                toggleCheckbox === null || toggleCheckbox === void 0 ? void 0 : toggleCheckbox(e, name, value, checked);
                (_props_onClick = props.onClick) === null || _props_onClick === void 0 ? void 0 : _props_onClick.call(props, e);
            }
        }, ref),
        name,
        value,
        checked
    };
    return state;
};
