'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    MENU_ENTER_EVENT: function() {
        return MENU_ENTER_EVENT;
    },
    dispatchMenuEnterEvent: function() {
        return dispatchMenuEnterEvent;
    },
    useOnMenuMouseEnter: function() {
        return useOnMenuMouseEnter;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const MENU_ENTER_EVENT = 'fuimenuenter';
const useOnMenuMouseEnter = (options)=>{
    const { refs, callback, element, disabled } = options;
    // Keep mouse event here because this is essentially a custom 'mouseenter' event
    const listener = (0, _reactutilities.useEventCallback)((ev)=>{
        const popoverRef = refs[0];
        const someMenuPopover = ev.target;
        var _popoverRef_current;
        // someMenu is a child -> will always be contained because of vParents
        // someMenu is a parent -> will always not be contained because no vParent
        // someMenu is the current popover -> it will contain itself
        const isOutsidePopover = !(0, _reactutilities.elementContains)((_popoverRef_current = popoverRef.current) !== null && _popoverRef_current !== void 0 ? _popoverRef_current : null, someMenuPopover);
        if (isOutsidePopover && !disabled) {
            callback(ev);
        }
    });
    _react.useEffect(()=>{
        // eslint-disable-next-line eqeqeq
        if (element == null) {
            return;
        }
        if (!disabled) {
            element.addEventListener(MENU_ENTER_EVENT, listener);
        }
        return ()=>{
            element.removeEventListener(MENU_ENTER_EVENT, listener);
        };
    }, [
        listener,
        element,
        disabled
    ]);
};
const dispatchMenuEnterEvent = (el, nativeEvent)=>{
    el.dispatchEvent(new CustomEvent(MENU_ENTER_EVENT, {
        bubbles: true,
        detail: {
            nativeEvent
        }
    }));
};
