'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    menuSplitGroupClassNames: function() {
        return menuSplitGroupClassNames;
    },
    menuSplitGroupMultilineAttr: function() {
        return menuSplitGroupMultilineAttr;
    },
    useMenuSplitGroupStyles_unstable: function() {
        return useMenuSplitGroupStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _useMenuItemStylesstyles = require("../MenuItem/useMenuItemStyles.styles");
const menuSplitGroupMultilineAttr = 'data-multiline';
const menuSplitGroupClassNames = {
    root: 'fui-MenuSplitGroup'
};
/**
 * Styles for the root slot
 * TODO - remove the use of nested combinators to style child menu items
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        [`[${menuSplitGroupMultilineAttr}]`]: {
            [`& > .${_useMenuItemStylesstyles.menuItemClassNames.root}:nth-of-type(2)`]: {
                alignSelf: 'center'
            }
        },
        display: 'flex',
        [`& > .${_useMenuItemStylesstyles.menuItemClassNames.root}:nth-of-type(1)`]: {
            flex: 1
        },
        [`& > .${_useMenuItemStylesstyles.menuItemClassNames.root}:nth-of-type(2)`]: {
            borderTopLeftRadius: 0,
            borderBottomLeftRadius: 0,
            paddingLeft: 0,
            '::before': {
                content: '""',
                width: _reacttheme.tokens.strokeWidthThin,
                height: '20px',
                backgroundColor: _reacttheme.tokens.colorNeutralStroke1
            }
        }
    }
});
const useMenuSplitGroupStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(menuSplitGroupClassNames.root, styles.root, state.root.className);
    return state;
};
