'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useMenuSplitGroup_unstable", {
    enumerable: true,
    get: function() {
        return useMenuSplitGroup_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reacttabster = require("@fluentui/react-tabster");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _keyboardkeys = require("@fluentui/keyboard-keys");
const _useMenuSplitGroupStylesstyles = require("./useMenuSplitGroupStyles.styles");
const useMenuSplitGroup_unstable = (props, ref)=>{
    const innerRef = _react.useRef(undefined);
    const { dir, targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const nextArrowKey = (0, _reactutilities.getRTLSafeKey)(_keyboardkeys.ArrowRight, dir);
    const prevArrowKey = (0, _reactutilities.getRTLSafeKey)(_keyboardkeys.ArrowLeft, dir);
    const { findNextFocusable, findPrevFocusable } = (0, _reacttabster.useFocusFinders)();
    const { multilineRef, setMultiline } = useHandleMultilineMenuItem();
    const onKeyDown = _react.useCallback((e)=>{
        var _innerRef_current;
        const activeElement = targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.activeElement;
        if (!activeElement) {
            return;
        }
        if (!((_innerRef_current = innerRef.current) === null || _innerRef_current === void 0 ? void 0 : _innerRef_current.contains(activeElement))) {
            return;
        }
        if (e.key === nextArrowKey) {
            const next = findNextFocusable(activeElement, {
                container: innerRef.current
            });
            next === null || next === void 0 ? void 0 : next.focus();
        }
        if (e.key === prevArrowKey) {
            const prev = findPrevFocusable(activeElement, {
                container: innerRef.current
            });
            prev === null || prev === void 0 ? void 0 : prev.focus();
        }
    }, [
        findNextFocusable,
        findPrevFocusable,
        targetDocument,
        nextArrowKey,
        prevArrowKey
    ]);
    return {
        components: {
            root: 'div'
        },
        setMultiline,
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            role: 'group',
            // FIXME:
            // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: (0, _reactutilities.useMergedRefs)(ref, innerRef, multilineRef),
            onKeyDown,
            ...props
        }), {
            elementType: 'div'
        })
    };
};
/**
 * Creates a callback that lets a multiline menu item child set an attribute on this component
 * Children can mount before parents so we need to store the value and apply it when the parent is mounted
 */ const useHandleMultilineMenuItem = ()=>{
    const [handle] = _react.useState(()=>{
        let isMultiline = false;
        let multilineNode = null;
        function applyAttr() {
            multilineNode === null || multilineNode === void 0 ? void 0 : multilineNode.toggleAttribute(_useMenuSplitGroupStylesstyles.menuSplitGroupMultilineAttr, isMultiline);
        }
        return {
            multilineRef: (node)=>{
                if (node) {
                    multilineNode = node;
                    applyAttr();
                } else {
                    multilineNode = null;
                }
            },
            setMultiline: (value)=>{
                isMultiline = value;
                applyAttr();
            }
        };
    });
    return handle;
};
