'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    menuPopoverClassNames: function() {
        return menuPopoverClassNames;
    },
    useMenuPopoverStyles_unstable: function() {
        return useMenuPopoverStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _reactpositioning = require("@fluentui/react-positioning");
const menuPopoverClassNames = {
    root: 'fui-MenuPopover'
};
const useStyles = (0, _react.makeStyles)({
    root: {
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        color: _reacttheme.tokens.colorNeutralForeground1,
        boxSizing: 'border-box',
        minWidth: '138px',
        maxWidth: '300px',
        overflowX: 'hidden',
        width: 'max-content',
        boxShadow: `${_reacttheme.tokens.shadow16}`,
        padding: '4px',
        border: `1px solid ${_reacttheme.tokens.colorTransparentStroke}`,
        ..._reacttheme.typographyStyles.body1,
        ...(0, _reactpositioning.createSlideStyles)(10)
    }
});
const useMenuPopoverStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(menuPopoverClassNames.root, styles.root, state.root.className);
    return state;
};
