'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useMenuPopover_unstable", {
    enumerable: true,
    get: function() {
        return useMenuPopover_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _keyboardkeys = require("@fluentui/keyboard-keys");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _reacttabster = require("@fluentui/react-tabster");
const _reactutilities = require("@fluentui/react-utilities");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _menuContext = require("../../contexts/menuContext");
const _index = require("../../utils/index");
const useMenuPopover_unstable = (props, ref)=>{
    'use no memo';
    const safeZone = (0, _menuContext.useMenuContext_unstable)((context)=>context.safeZone);
    const popoverRef = (0, _menuContext.useMenuContext_unstable)((context)=>context.menuPopoverRef);
    const setOpen = (0, _menuContext.useMenuContext_unstable)((context)=>context.setOpen);
    const open = (0, _menuContext.useMenuContext_unstable)((context)=>context.open);
    const openOnHover = (0, _menuContext.useMenuContext_unstable)((context)=>context.openOnHover);
    const triggerRef = (0, _menuContext.useMenuContext_unstable)((context)=>context.triggerRef);
    const isSubmenu = (0, _index.useIsSubmenu)();
    const canDispatchCustomEventRef = _react.useRef(true);
    const restoreFocusSourceAttributes = (0, _reacttabster.useRestoreFocusSource)();
    const [setThrottleTimeout, clearThrottleTimeout] = (0, _reactutilities.useTimeout)();
    const { dir } = (0, _reactsharedcontexts.useFluent_unstable)();
    const CloseArrowKey = dir === 'ltr' ? _keyboardkeys.ArrowLeft : _keyboardkeys.ArrowRight;
    // use DOM listener since react events propagate up the react tree
    // no need to do `contains` logic as menus are all positioned in different portals
    const mouseOverListenerCallbackRef = _react.useCallback((node)=>{
        if (node) {
            // Dispatches the custom menu mouse enter event with throttling
            // Needs to trigger on mouseover to support keyboard + mouse together
            // i.e. keyboard opens submenus while cursor is still on the parent
            node.addEventListener('mouseover', (e)=>{
                if (canDispatchCustomEventRef.current) {
                    canDispatchCustomEventRef.current = false;
                    (0, _index.dispatchMenuEnterEvent)(popoverRef.current, e);
                    setThrottleTimeout(()=>{
                        canDispatchCustomEventRef.current = true;
                    }, 250);
                }
            });
        }
    }, [
        popoverRef,
        setThrottleTimeout
    ]);
    _react.useEffect(()=>{
        return ()=>clearThrottleTimeout();
    }, [
        clearThrottleTimeout
    ]);
    var _useMenuContext_unstable;
    const inline = (_useMenuContext_unstable = (0, _menuContext.useMenuContext_unstable)((context)=>context.inline)) !== null && _useMenuContext_unstable !== void 0 ? _useMenuContext_unstable : false;
    const mountNode = (0, _menuContext.useMenuContext_unstable)((context)=>context.mountNode);
    const rootProps = _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
        role: 'presentation',
        ...restoreFocusSourceAttributes,
        ...props,
        // FIXME:
        // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
        // but since it would be a breaking change to fix it, we are casting ref to it's proper type
        ref: (0, _reactutilities.useMergedRefs)(ref, popoverRef, mouseOverListenerCallbackRef)
    }), {
        elementType: 'div'
    });
    const { onMouseEnter: onMouseEnterOriginal, onKeyDown: onKeyDownOriginal } = rootProps;
    rootProps.onMouseEnter = (0, _reactutilities.useEventCallback)((event)=>{
        if (openOnHover || isSubmenu) {
            setOpen(event, {
                open: true,
                keyboard: false,
                type: 'menuPopoverMouseEnter',
                event
            });
        }
        onMouseEnterOriginal === null || onMouseEnterOriginal === void 0 ? void 0 : onMouseEnterOriginal(event);
    });
    rootProps.onKeyDown = (0, _reactutilities.useEventCallback)((event)=>{
        const key = event.key;
        if (key === _keyboardkeys.Escape || isSubmenu && key === CloseArrowKey) {
            var _popoverRef_current;
            if (open && ((_popoverRef_current = popoverRef.current) === null || _popoverRef_current === void 0 ? void 0 : _popoverRef_current.contains(event.target)) && !event.isDefaultPrevented()) {
                setOpen(event, {
                    open: false,
                    keyboard: true,
                    type: 'menuPopoverKeyDown',
                    event
                });
                // stop propagation to avoid conflicting with other elements that listen for `Escape`
                // e,g: Dialog, Popover, Menu and Tooltip
                event.preventDefault();
            }
        }
        if (key === _keyboardkeys.Tab) {
            setOpen(event, {
                open: false,
                keyboard: true,
                type: 'menuPopoverKeyDown',
                event
            });
            if (!isSubmenu) {
                var _triggerRef_current;
                (_triggerRef_current = triggerRef.current) === null || _triggerRef_current === void 0 ? void 0 : _triggerRef_current.focus();
            }
        }
        onKeyDownOriginal === null || onKeyDownOriginal === void 0 ? void 0 : onKeyDownOriginal(event);
    });
    return {
        inline,
        mountNode,
        safeZone,
        components: {
            root: 'div'
        },
        root: rootProps
    };
};
