'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    circleFilledClassName: function() {
        return circleFilledClassName;
    },
    menuItemSwitchClassNames: function() {
        return menuItemSwitchClassNames;
    },
    useMenuItemSwitchStyles_unstable: function() {
        return useMenuItemSwitchStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _useMenuItemStylesstyles = require("../MenuItem/useMenuItemStyles.styles");
const menuItemSwitchClassNames = {
    root: 'fui-MenuItemSwitch',
    icon: 'fui-MenuItemSwitch__icon',
    content: 'fui-MenuItemSwitch__content',
    secondaryContent: 'fui-MenuItemSwitch__secondaryContent',
    switchIndicator: 'fui-MenuItemSwitch__switchIndicator',
    subText: 'fui-MenuItemSwitch__subText'
};
const circleFilledClassName = 'fui-MenuItemSwitch__switchIndicator__circleFilled';
// Thumb and track sizes used by the component.
const spaceBetweenThumbAndTrack = 2;
const trackHeight = 20;
const trackWidth = 40;
const thumbSize = trackHeight - spaceBetweenThumbAndTrack;
const useSwitchIndicatorBaseClassName = (0, _react.makeResetStyles)({
    borderRadius: _reacttheme.tokens.borderRadiusCircular,
    border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorNeutralStrokeAccessible}`,
    lineHeight: 0,
    boxSizing: 'border-box',
    fill: 'currentColor',
    flexShrink: 0,
    fontSize: `${thumbSize}px`,
    height: `${trackHeight}px`,
    transitionDuration: _reacttheme.tokens.durationNormal,
    transitionTimingFunction: _reacttheme.tokens.curveEasyEase,
    transitionProperty: 'background, border, color',
    width: `${trackWidth}px`,
    marginRight: _reacttheme.tokens.spacingHorizontalXS,
    '@media screen and (prefers-reduced-motion: reduce)': {
        transitionDuration: '0.01ms'
    },
    color: _reacttheme.tokens.colorNeutralStrokeAccessible,
    ':hover': {
        color: _reacttheme.tokens.colorNeutralStrokeAccessibleHover,
        borderColor: _reacttheme.tokens.colorNeutralStrokeAccessibleHover
    },
    ':hover:active': {
        color: _reacttheme.tokens.colorNeutralStrokeAccessiblePressed,
        borderColor: _reacttheme.tokens.colorNeutralStrokeAccessiblePressed
    },
    [`& .${circleFilledClassName}`]: {
        transitionDuration: _reacttheme.tokens.durationNormal,
        transitionTimingFunction: _reacttheme.tokens.curveEasyEase,
        transitionProperty: 'transform',
        '@media screen and (prefers-reduced-motion: reduce)': {
            transitionDuration: '0.01ms'
        }
    }
});
const useSwitchIndicatorStyles = (0, _react.makeStyles)({
    checked: {
        [`& .${circleFilledClassName}`]: {
            transform: `translateX(${trackWidth - thumbSize - spaceBetweenThumbAndTrack}px)`
        },
        backgroundColor: _reacttheme.tokens.colorCompoundBrandBackground,
        color: _reacttheme.tokens.colorNeutralForegroundInverted,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorTransparentStroke),
        ':hover': {
            color: _reacttheme.tokens.colorNeutralForegroundInverted,
            backgroundColor: _reacttheme.tokens.colorCompoundBrandBackgroundHover,
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorTransparentStrokeInteractive)
        },
        ':hover:active': {
            color: _reacttheme.tokens.colorNeutralForegroundInverted,
            backgroundColor: _reacttheme.tokens.colorCompoundBrandBackgroundPressed,
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorTransparentStrokeInteractive)
        }
    }
});
const useMultilineStyles = (0, _react.makeStyles)({
    switch: {
        alignSelf: 'center'
    }
});
const useMenuItemSwitchStyles_unstable = (state)=>{
    'use no memo';
    const { checked, subText } = state;
    const multiline = !!subText;
    const switchIndicatorStyles = useSwitchIndicatorStyles();
    const switchIndicatorBaseStyles = useSwitchIndicatorBaseClassName();
    const multilineStyles = useMultilineStyles();
    state.root.className = (0, _react.mergeClasses)(menuItemSwitchClassNames.root, state.root.className);
    if (state.content) {
        state.content.className = (0, _react.mergeClasses)(menuItemSwitchClassNames.content, state.content.className);
    }
    if (state.secondaryContent) {
        state.secondaryContent.className = (0, _react.mergeClasses)(menuItemSwitchClassNames.secondaryContent, state.secondaryContent.className);
    }
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(menuItemSwitchClassNames.icon, state.icon.className);
    }
    if (state.subText) {
        state.subText.className = (0, _react.mergeClasses)(menuItemSwitchClassNames.subText, state.subText.className);
    }
    if (state.switchIndicator) {
        state.switchIndicator.className = (0, _react.mergeClasses)(menuItemSwitchClassNames.switchIndicator, switchIndicatorBaseStyles, checked && switchIndicatorStyles.checked, state.switchIndicator.className, multiline && multilineStyles.switch);
    }
    (0, _useMenuItemStylesstyles.useMenuItemStyles_unstable)({
        ...state,
        components: {
            // eslint-disable-next-line @typescript-eslint/no-deprecated
            ...state.components,
            checkmark: 'span',
            submenuIndicator: 'span'
        },
        checkmark: undefined,
        submenuIndicator: undefined,
        hasSubmenu: false,
        persistOnClick: true
    });
    return state;
};
