'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    menuItemLinkClassNames: function() {
        return menuItemLinkClassNames;
    },
    useMenuItemLinkStyles_unstable: function() {
        return useMenuItemLinkStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _useMenuItemStylesstyles = require("../MenuItem/useMenuItemStyles.styles");
const menuItemLinkClassNames = {
    root: 'fui-MenuItemLink',
    icon: 'fui-MenuItemLink__icon',
    checkmark: 'fui-MenuItemLink__checkmark',
    content: 'fui-MenuItemLink__content',
    secondaryContent: 'fui-MenuItemLink__secondaryContent'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    resetLink: {
        textDecorationLine: 'none',
        textDecorationThickness: 'initial',
        textDecorationStyle: 'initial',
        textDecorationColor: 'initial'
    }
});
const useMenuItemLinkStyles_unstable = (state)=>{
    'use no memo';
    (0, _useMenuItemStylesstyles.useMenuItemStyles_unstable)(state);
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(menuItemLinkClassNames.root, styles.resetLink, state.root.className);
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(menuItemLinkClassNames.icon, state.icon.className);
    }
    if (state.content) {
        state.content.className = (0, _react.mergeClasses)(menuItemLinkClassNames.content, state.content.className);
    }
    if (state.secondaryContent) {
        state.secondaryContent.className = (0, _react.mergeClasses)(menuItemLinkClassNames.secondaryContent, state.secondaryContent.className);
    }
    if (state.checkmark) {
        state.checkmark.className = (0, _react.mergeClasses)(menuItemLinkClassNames.checkmark, state.checkmark.className);
    }
    return state;
};
