'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    menuItemClassNames: function() {
        return menuItemClassNames;
    },
    useMenuItemStyles_unstable: function() {
        return useMenuItemStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacticons = require("@fluentui/react-icons");
const _reacttabster = require("@fluentui/react-tabster");
const _reacttheme = require("@fluentui/react-theme");
const _index = require("../../selectable/index");
const menuItemClassNames = {
    root: 'fui-MenuItem',
    icon: 'fui-MenuItem__icon',
    checkmark: 'fui-MenuItem__checkmark',
    submenuIndicator: 'fui-MenuItem__submenuIndicator',
    content: 'fui-MenuItem__content',
    secondaryContent: 'fui-MenuItem__secondaryContent',
    subText: 'fui-MenuItem__subText'
};
const useRootBaseStyles = (0, _react.makeResetStyles)({
    borderRadius: _reacttheme.tokens.borderRadiusMedium,
    position: 'relative',
    color: _reacttheme.tokens.colorNeutralForeground2,
    backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
    paddingRight: _reacttheme.tokens.spacingVerticalSNudge,
    paddingLeft: _reacttheme.tokens.spacingVerticalSNudge,
    paddingTop: _reacttheme.tokens.spacingVerticalSNudge,
    paddingBottom: _reacttheme.tokens.spacingVerticalSNudge,
    boxSizing: 'border-box',
    maxWidth: '290px',
    minHeight: '32px',
    flexShrink: 0,
    display: 'flex',
    alignItems: 'start',
    fontSize: _reacttheme.tokens.fontSizeBase300,
    cursor: 'pointer',
    gap: '4px',
    ':hover': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1Hover,
        color: _reacttheme.tokens.colorNeutralForeground2Hover,
        [`& .${_reacticons.iconFilledClassName}`]: {
            display: 'inline'
        },
        [`& .${_reacticons.iconRegularClassName}`]: {
            display: 'none'
        },
        [`& .${menuItemClassNames.icon}`]: {
            color: _reacttheme.tokens.colorNeutralForeground2BrandSelected
        },
        [`& .${menuItemClassNames.subText}`]: {
            color: _reacttheme.tokens.colorNeutralForeground3Hover
        }
    },
    ':hover:active': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1Pressed,
        color: _reacttheme.tokens.colorNeutralForeground2Pressed,
        [`& .${menuItemClassNames.subText}`]: {
            color: _reacttheme.tokens.colorNeutralForeground3Pressed
        }
    },
    // High contrast styles
    '@media (forced-colors: active)': {
        ':hover': {
            backgroundColor: 'Canvas',
            borderColor: 'Highlight',
            color: 'Highlight'
        },
        ...(0, _reacttabster.createFocusOutlineStyle)({
            style: {
                outlineColor: 'Highlight'
            }
        })
    },
    userSelect: 'none',
    ...(0, _reacttabster.createFocusOutlineStyle)()
});
const useContentBaseStyles = (0, _react.makeResetStyles)({
    paddingLeft: '2px',
    paddingRight: '2px',
    backgroundColor: 'transparent',
    flexGrow: 1
});
const useSecondaryContentBaseStyles = (0, _react.makeResetStyles)({
    paddingLeft: '2px',
    paddingRight: '2px',
    ..._reacttheme.typographyStyles.caption1,
    lineHeight: _reacttheme.tokens.lineHeightBase300,
    color: _reacttheme.tokens.colorNeutralForeground3,
    ':hover': {
        color: _reacttheme.tokens.colorNeutralForeground3Hover
    },
    ':focus': {
        color: _reacttheme.tokens.colorNeutralForeground3Hover
    }
});
const useIconBaseStyles = (0, _react.makeResetStyles)({
    width: '20px',
    height: '20px',
    fontSize: '20px',
    lineHeight: 0,
    alignItems: 'center',
    display: 'inline-flex',
    justifyContent: 'center',
    flexShrink: 0
});
const useSubmenuIndicatorBaseStyles = (0, _react.makeResetStyles)({
    width: '20px',
    height: '20px',
    fontSize: '20px',
    lineHeight: 0,
    alignItems: 'center',
    display: 'inline-flex',
    justifyContent: 'center'
});
const useSubtextBaseStyles = (0, _react.makeResetStyles)({
    ..._reacttheme.typographyStyles.caption2,
    color: _reacttheme.tokens.colorNeutralForeground3
});
const useStyles = (0, _react.makeStyles)({
    checkmark: {
        marginTop: '2px'
    },
    splitItemMain: {
        flexGrow: 1
    },
    splitItemTrigger: {
        borderTopLeftRadius: 0,
        borderBottomLeftRadius: 0,
        paddingLeft: 0,
        '::before': {
            content: '""',
            width: _reacttheme.tokens.strokeWidthThin,
            height: '24px',
            backgroundColor: _reacttheme.tokens.colorNeutralStroke1
        }
    },
    disabled: {
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        ':hover': {
            color: _reacttheme.tokens.colorNeutralForegroundDisabled,
            backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
            cursor: 'not-allowed',
            [`& .${_reacticons.iconFilledClassName}`]: {
                display: 'none'
            },
            [`& .${_reacticons.iconRegularClassName}`]: {
                display: 'inline'
            },
            [`& .${menuItemClassNames.icon}`]: {
                color: _reacttheme.tokens.colorNeutralForegroundDisabled
            },
            [`& .${menuItemClassNames.subText}`]: {
                color: _reacttheme.tokens.colorNeutralForegroundDisabled
            }
        },
        ':hover:active': {
            color: _reacttheme.tokens.colorNeutralForegroundDisabled,
            backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
            [`& .${menuItemClassNames.subText}`]: {
                color: _reacttheme.tokens.colorNeutralForegroundDisabled
            }
        },
        ':focus': {
            color: _reacttheme.tokens.colorNeutralForegroundDisabled
        },
        '@media (forced-colors: active)': {
            color: 'GrayText',
            ':hover': {
                color: 'GrayText',
                backgroundColor: 'Canvas',
                [`& .${menuItemClassNames.icon}`]: {
                    color: 'GrayText',
                    backgroundColor: 'Canvas'
                },
                [`& .${menuItemClassNames.subText}`]: {
                    color: 'GrayText'
                }
            },
            ':hover:active': {
                color: 'GrayText',
                backgroundColor: 'Canvas',
                [`& .${menuItemClassNames.subText}`]: {
                    color: 'GrayText'
                }
            },
            ':focus': {
                color: 'GrayText',
                backgroundColor: 'Canvas'
            }
        }
    }
});
const useSubTextStyles = (0, _react.makeStyles)({
    disabled: {
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        '@media (forced-colors: active)': {
            color: 'GrayText'
        }
    }
});
const useMultilineStyles = (0, _react.makeStyles)({
    content: {
        display: 'flex',
        flexDirection: 'column'
    },
    secondaryContent: {
        alignSelf: 'center'
    },
    submenuIndicator: {
        alignSelf: 'center'
    }
});
const useMenuItemStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const rootBaseStyles = useRootBaseStyles();
    const contentBaseStyles = useContentBaseStyles();
    const secondaryContentBaseStyles = useSecondaryContentBaseStyles();
    const iconBaseStyles = useIconBaseStyles();
    const submenuIndicatorBaseStyles = useSubmenuIndicatorBaseStyles();
    const multilineStyles = useMultilineStyles();
    const subtextBaseStyles = useSubtextBaseStyles();
    const subTextStyles = useSubTextStyles();
    const multiline = !!state.subText;
    state.root.className = (0, _react.mergeClasses)(menuItemClassNames.root, rootBaseStyles, state.disabled && styles.disabled, state.root.className);
    if (state.content) {
        state.content.className = (0, _react.mergeClasses)(menuItemClassNames.content, contentBaseStyles, state.content.className, multiline && multilineStyles.content);
    }
    if (state.checkmark) {
        state.checkmark.className = (0, _react.mergeClasses)(menuItemClassNames.checkmark, styles.checkmark, state.checkmark.className);
    }
    if (state.secondaryContent) {
        state.secondaryContent.className = (0, _react.mergeClasses)(menuItemClassNames.secondaryContent, secondaryContentBaseStyles, state.disabled && styles.disabled, state.secondaryContent.className, multiline && multilineStyles.secondaryContent);
    }
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(menuItemClassNames.icon, iconBaseStyles, state.icon.className);
    }
    if (state.submenuIndicator) {
        state.submenuIndicator.className = (0, _react.mergeClasses)(menuItemClassNames.submenuIndicator, submenuIndicatorBaseStyles, state.submenuIndicator.className, multiline && multilineStyles.submenuIndicator);
    }
    if (state.subText) {
        state.subText.className = (0, _react.mergeClasses)(menuItemClassNames.subText, state.disabled && subTextStyles.disabled, state.subText.className, subtextBaseStyles);
    }
    (0, _index.useCheckmarkStyles_unstable)(state);
    return state;
};
