'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    menuItemClassNames: function() {
        return menuItemClassNames;
    },
    useMenuItemStyles_unstable: function() {
        return useMenuItemStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _index = require("../../selectable/index");
const menuItemClassNames = {
    root: 'fui-MenuItem',
    icon: 'fui-MenuItem__icon',
    checkmark: 'fui-MenuItem__checkmark',
    submenuIndicator: 'fui-MenuItem__submenuIndicator',
    content: 'fui-MenuItem__content',
    secondaryContent: 'fui-MenuItem__secondaryContent',
    subText: 'fui-MenuItem__subText'
};
const useRootBaseStyles = /*#__PURE__*/ (0, _react.__resetStyles)("rfoezjv", "r8lt3v0", {
    r: [
        ".rfoezjv{border-radius:var(--borderRadiusMedium);position:relative;color:var(--colorNeutralForeground2);background-color:var(--colorNeutralBackground1);padding-right:var(--spacingVerticalSNudge);padding-left:var(--spacingVerticalSNudge);padding-top:var(--spacingVerticalSNudge);padding-bottom:var(--spacingVerticalSNudge);box-sizing:border-box;max-width:290px;min-height:32px;flex-shrink:0;display:flex;align-items:start;font-size:var(--fontSizeBase300);cursor:pointer;gap:4px;-webkit-user-select:none;-moz-user-select:none;user-select:none;}",
        ".rfoezjv:hover{background-color:var(--colorNeutralBackground1Hover);color:var(--colorNeutralForeground2Hover);}",
        ".rfoezjv:hover .fui-Icon-filled{display:inline;}",
        ".rfoezjv:hover .fui-Icon-regular{display:none;}",
        ".rfoezjv:hover .fui-MenuItem__icon{color:var(--colorNeutralForeground2BrandSelected);}",
        ".rfoezjv:hover .fui-MenuItem__subText{color:var(--colorNeutralForeground3Hover);}",
        ".rfoezjv:hover:active{background-color:var(--colorNeutralBackground1Pressed);color:var(--colorNeutralForeground2Pressed);}",
        ".rfoezjv:hover:active .fui-MenuItem__subText{color:var(--colorNeutralForeground3Pressed);}",
        ".rfoezjv:focus{outline-style:none;}",
        ".rfoezjv:focus-visible{outline-style:none;}",
        ".rfoezjv[data-fui-focus-visible]{border-top-color:transparent;border-right-color:transparent;border-bottom-color:transparent;border-left-color:transparent;}",
        ".rfoezjv[data-fui-focus-visible]::after{content:\"\";position:absolute;pointer-events:none;z-index:1;border:2px solid var(--colorStrokeFocus2);border-radius:var(--borderRadiusMedium);top:calc(2px * -1);right:calc(2px * -1);bottom:calc(2px * -1);left:calc(2px * -1);}",
        ".r8lt3v0{border-radius:var(--borderRadiusMedium);position:relative;color:var(--colorNeutralForeground2);background-color:var(--colorNeutralBackground1);padding-left:var(--spacingVerticalSNudge);padding-right:var(--spacingVerticalSNudge);padding-top:var(--spacingVerticalSNudge);padding-bottom:var(--spacingVerticalSNudge);box-sizing:border-box;max-width:290px;min-height:32px;flex-shrink:0;display:flex;align-items:start;font-size:var(--fontSizeBase300);cursor:pointer;gap:4px;-webkit-user-select:none;-moz-user-select:none;user-select:none;}",
        ".r8lt3v0:hover{background-color:var(--colorNeutralBackground1Hover);color:var(--colorNeutralForeground2Hover);}",
        ".r8lt3v0:hover .fui-Icon-filled{display:inline;}",
        ".r8lt3v0:hover .fui-Icon-regular{display:none;}",
        ".r8lt3v0:hover .fui-MenuItem__icon{color:var(--colorNeutralForeground2BrandSelected);}",
        ".r8lt3v0:hover .fui-MenuItem__subText{color:var(--colorNeutralForeground3Hover);}",
        ".r8lt3v0:hover:active{background-color:var(--colorNeutralBackground1Pressed);color:var(--colorNeutralForeground2Pressed);}",
        ".r8lt3v0:hover:active .fui-MenuItem__subText{color:var(--colorNeutralForeground3Pressed);}",
        ".r8lt3v0:focus{outline-style:none;}",
        ".r8lt3v0:focus-visible{outline-style:none;}",
        ".r8lt3v0[data-fui-focus-visible]{border-top-color:transparent;border-left-color:transparent;border-bottom-color:transparent;border-right-color:transparent;}",
        ".r8lt3v0[data-fui-focus-visible]::after{content:\"\";position:absolute;pointer-events:none;z-index:1;border:2px solid var(--colorStrokeFocus2);border-radius:var(--borderRadiusMedium);top:calc(2px * -1);left:calc(2px * -1);bottom:calc(2px * -1);right:calc(2px * -1);}"
    ],
    s: [
        "@media (forced-colors: active){.rfoezjv:hover{background-color:Canvas;border-color:Highlight;color:Highlight;}.rfoezjv:focus{outline-style:none;}.rfoezjv:focus-visible{outline-style:none;}.rfoezjv[data-fui-focus-visible]{border-top-color:transparent;border-right-color:transparent;border-bottom-color:transparent;border-left-color:transparent;}@media (forced-colors: active){.rfoezjv[data-fui-focus-visible]::after{border-top-color:Highlight;border-right-color:Highlight;border-bottom-color:Highlight;border-left-color:Highlight;}}.rfoezjv[data-fui-focus-visible]::after{content:\"\";position:absolute;pointer-events:none;z-index:1;border:2px solid Highlight;border-radius:var(--borderRadiusMedium);top:calc(2px * -1);right:calc(2px * -1);bottom:calc(2px * -1);left:calc(2px * -1);}}",
        "@media (forced-colors: active){.rfoezjv[data-fui-focus-visible]::after{border-top-color:Highlight;border-right-color:Highlight;border-bottom-color:Highlight;border-left-color:Highlight;}}",
        "@media (forced-colors: active){.r8lt3v0:hover{background-color:Canvas;border-color:Highlight;color:Highlight;}.r8lt3v0:focus{outline-style:none;}.r8lt3v0:focus-visible{outline-style:none;}.r8lt3v0[data-fui-focus-visible]{border-top-color:transparent;border-left-color:transparent;border-bottom-color:transparent;border-right-color:transparent;}@media (forced-colors: active){.r8lt3v0[data-fui-focus-visible]::after{border-top-color:Highlight;border-left-color:Highlight;border-bottom-color:Highlight;border-right-color:Highlight;}}.r8lt3v0[data-fui-focus-visible]::after{content:\"\";position:absolute;pointer-events:none;z-index:1;border:2px solid Highlight;border-radius:var(--borderRadiusMedium);top:calc(2px * -1);left:calc(2px * -1);bottom:calc(2px * -1);right:calc(2px * -1);}}",
        "@media (forced-colors: active){.r8lt3v0[data-fui-focus-visible]::after{border-top-color:Highlight;border-left-color:Highlight;border-bottom-color:Highlight;border-right-color:Highlight;}}"
    ]
});
const useContentBaseStyles = /*#__PURE__*/ (0, _react.__resetStyles)("r1ls86vo", "rpbc5dr", [
    ".r1ls86vo{padding-left:2px;padding-right:2px;background-color:transparent;flex-grow:1;}",
    ".rpbc5dr{padding-right:2px;padding-left:2px;background-color:transparent;flex-grow:1;}"
]);
const useSecondaryContentBaseStyles = /*#__PURE__*/ (0, _react.__resetStyles)("r12mwwux", "r1ewgu5j", [
    ".r12mwwux{padding-left:2px;padding-right:2px;font-family:var(--fontFamilyBase);font-size:var(--fontSizeBase200);font-weight:var(--fontWeightRegular);line-height:var(--lineHeightBase300);color:var(--colorNeutralForeground3);}",
    ".r12mwwux:hover{color:var(--colorNeutralForeground3Hover);}",
    ".r12mwwux:focus{color:var(--colorNeutralForeground3Hover);}",
    ".r1ewgu5j{padding-right:2px;padding-left:2px;font-family:var(--fontFamilyBase);font-size:var(--fontSizeBase200);font-weight:var(--fontWeightRegular);line-height:var(--lineHeightBase300);color:var(--colorNeutralForeground3);}",
    ".r1ewgu5j:hover{color:var(--colorNeutralForeground3Hover);}",
    ".r1ewgu5j:focus{color:var(--colorNeutralForeground3Hover);}"
]);
const useIconBaseStyles = /*#__PURE__*/ (0, _react.__resetStyles)("ro9koqv", null, [
    ".ro9koqv{width:20px;height:20px;font-size:20px;line-height:0;align-items:center;display:inline-flex;justify-content:center;flex-shrink:0;}"
]);
const useSubmenuIndicatorBaseStyles = /*#__PURE__*/ (0, _react.__resetStyles)("r9c34qo", null, [
    ".r9c34qo{width:20px;height:20px;font-size:20px;line-height:0;align-items:center;display:inline-flex;justify-content:center;}"
]);
const useSubtextBaseStyles = /*#__PURE__*/ (0, _react.__resetStyles)("rk2ppru", null, [
    ".rk2ppru{font-family:var(--fontFamilyBase);font-size:var(--fontSizeBase100);font-weight:var(--fontWeightRegular);line-height:var(--lineHeightBase100);color:var(--colorNeutralForeground3);}"
]);
const useStyles = /*#__PURE__*/ (0, _react.__styles)({
    checkmark: {
        B6of3ja: "fmnzpld"
    },
    splitItemMain: {
        Bh6795r: "fqerorx"
    },
    splitItemTrigger: {
        Btl43ni: [
            "f1ozlkrg",
            "f10ostut"
        ],
        Beyfa6y: [
            "f1deotkl",
            "f1krrbdw"
        ],
        uwmqm3: [
            "f1cnd47f",
            "fhxju0i"
        ],
        Ftih45: "f1wl9k8s",
        Ccq8qp: "f1yn80uh",
        Baz25je: "f68mna0",
        cmx5o7: "f1p5zmk"
    },
    disabled: {
        sj55zd: "f1s2aq7o",
        Bi91k9c: "fvgxktp",
        Jwef8y: "f1ijtazh",
        eoavqd: "fphbwmw",
        Bk3fhr4: "f19vpps7",
        Bmfj8id: "fv5swzo",
        Bg7n49j: "f1q1x1ba",
        c7f7en: "ff3wrqt",
        B2d53fq: "fcvwxyo",
        iro3zm: "f1to34ca",
        Bumww26: "fszh5vc",
        t0hwav: "ft33916",
        Bbusuzp: "f1dcs8yz",
        ze5xyy: "f1kc2mi9",
        Bqrx1nm: "fkavljg",
        Bctn1xl: "fk56vqo",
        h5esng: "ff3wi9b",
        Bsk3rfj: "fduv4kr",
        pc6evw: "fb3rf2x",
        g2kj27: "f183y0b2",
        evg1t5: "f12is0ou",
        Bh6z0a4: "f1ikwg0d",
        Bh953qp: "f10l1t5h"
    }
}, {
    d: [
        ".fmnzpld{margin-top:2px;}",
        ".fqerorx{flex-grow:1;}",
        ".f1ozlkrg{border-top-left-radius:0;}",
        ".f10ostut{border-top-right-radius:0;}",
        ".f1deotkl{border-bottom-left-radius:0;}",
        ".f1krrbdw{border-bottom-right-radius:0;}",
        ".f1cnd47f{padding-left:0;}",
        ".fhxju0i{padding-right:0;}",
        ".f1wl9k8s::before{content:\"\";}",
        ".f1yn80uh::before{width:var(--strokeWidthThin);}",
        ".f68mna0::before{height:24px;}",
        ".f1p5zmk::before{background-color:var(--colorNeutralStroke1);}",
        ".f1s2aq7o{color:var(--colorNeutralForegroundDisabled);}"
    ],
    h: [
        ".fvgxktp:hover{color:var(--colorNeutralForegroundDisabled);}",
        ".f1ijtazh:hover{background-color:var(--colorNeutralBackground1);}",
        ".fphbwmw:hover{cursor:not-allowed;}",
        ".f19vpps7:hover .fui-Icon-filled{display:none;}",
        ".fv5swzo:hover .fui-Icon-regular{display:inline;}",
        ".f1q1x1ba:hover .fui-MenuItem__icon{color:var(--colorNeutralForegroundDisabled);}",
        ".ff3wrqt:hover .fui-MenuItem__subText{color:var(--colorNeutralForegroundDisabled);}",
        ".fcvwxyo:hover:active{color:var(--colorNeutralForegroundDisabled);}",
        ".f1to34ca:hover:active{background-color:var(--colorNeutralBackground1);}",
        ".fszh5vc:hover:active .fui-MenuItem__subText{color:var(--colorNeutralForegroundDisabled);}"
    ],
    f: [
        ".ft33916:focus{color:var(--colorNeutralForegroundDisabled);}"
    ],
    m: [
        [
            "@media (forced-colors: active){.f1dcs8yz{color:GrayText;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f1kc2mi9:hover{color:GrayText;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.fkavljg:hover{background-color:Canvas;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.fk56vqo:hover .fui-MenuItem__icon{color:GrayText;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.ff3wi9b:hover .fui-MenuItem__icon{background-color:Canvas;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.fduv4kr:hover .fui-MenuItem__subText{color:GrayText;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.fb3rf2x:hover:active{color:GrayText;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f183y0b2:hover:active{background-color:Canvas;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f12is0ou:hover:active .fui-MenuItem__subText{color:GrayText;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f1ikwg0d:focus{color:GrayText;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f10l1t5h:focus{background-color:Canvas;}}",
            {
                m: "(forced-colors: active)"
            }
        ]
    ]
});
const useSubTextStyles = /*#__PURE__*/ (0, _react.__styles)({
    disabled: {
        sj55zd: "f1s2aq7o",
        Bbusuzp: "f1dcs8yz"
    }
}, {
    d: [
        ".f1s2aq7o{color:var(--colorNeutralForegroundDisabled);}"
    ],
    m: [
        [
            "@media (forced-colors: active){.f1dcs8yz{color:GrayText;}}",
            {
                m: "(forced-colors: active)"
            }
        ]
    ]
});
const useMultilineStyles = /*#__PURE__*/ (0, _react.__styles)({
    content: {
        mc9l5x: "f22iagw",
        Beiy3e4: "f1vx9l62"
    },
    secondaryContent: {
        qb2dma: "f7nlbp4"
    },
    submenuIndicator: {
        qb2dma: "f7nlbp4"
    }
}, {
    d: [
        ".f22iagw{display:flex;}",
        ".f1vx9l62{flex-direction:column;}",
        ".f7nlbp4{align-self:center;}"
    ]
});
const useMenuItemStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const rootBaseStyles = useRootBaseStyles();
    const contentBaseStyles = useContentBaseStyles();
    const secondaryContentBaseStyles = useSecondaryContentBaseStyles();
    const iconBaseStyles = useIconBaseStyles();
    const submenuIndicatorBaseStyles = useSubmenuIndicatorBaseStyles();
    const multilineStyles = useMultilineStyles();
    const subtextBaseStyles = useSubtextBaseStyles();
    const subTextStyles = useSubTextStyles();
    const multiline = !!state.subText;
    state.root.className = (0, _react.mergeClasses)(menuItemClassNames.root, rootBaseStyles, state.disabled && styles.disabled, state.root.className);
    if (state.content) {
        state.content.className = (0, _react.mergeClasses)(menuItemClassNames.content, contentBaseStyles, state.content.className, multiline && multilineStyles.content);
    }
    if (state.checkmark) {
        state.checkmark.className = (0, _react.mergeClasses)(menuItemClassNames.checkmark, styles.checkmark, state.checkmark.className);
    }
    if (state.secondaryContent) {
        state.secondaryContent.className = (0, _react.mergeClasses)(menuItemClassNames.secondaryContent, secondaryContentBaseStyles, state.disabled && styles.disabled, state.secondaryContent.className, multiline && multilineStyles.secondaryContent);
    }
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(menuItemClassNames.icon, iconBaseStyles, state.icon.className);
    }
    if (state.submenuIndicator) {
        state.submenuIndicator.className = (0, _react.mergeClasses)(menuItemClassNames.submenuIndicator, submenuIndicatorBaseStyles, state.submenuIndicator.className, multiline && multilineStyles.submenuIndicator);
    }
    if (state.subText) {
        state.subText.className = (0, _react.mergeClasses)(menuItemClassNames.subText, state.disabled && subTextStyles.disabled, state.subText.className, subtextBaseStyles);
    }
    (0, _index.useCheckmarkStyles_unstable)(state);
    return state;
};
