'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useMenuItem_unstable", {
    enumerable: true,
    get: function() {
        return useMenuItem_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _useCharacterSearch = require("./useCharacterSearch");
const _menuTriggerContext = require("../../contexts/menuTriggerContext");
const _reacticons = require("@fluentui/react-icons");
const _menuListContext = require("../../contexts/menuListContext");
const _menuContext = require("../../contexts/menuContext");
const _reactaria = require("@fluentui/react-aria");
const _keyboardkeys = require("@fluentui/keyboard-keys");
const _menuSplitGroupContext = require("../../contexts/menuSplitGroupContext");
const _useValidateNesting = require("../../utils/useValidateNesting");
const ChevronRightIcon = (0, _reacticons.bundleIcon)(_reacticons.ChevronRightFilled, _reacticons.ChevronRightRegular);
const ChevronLeftIcon = (0, _reacticons.bundleIcon)(_reacticons.ChevronLeftFilled, _reacticons.ChevronLeftRegular);
const useMenuItem_unstable = (props, ref)=>{
    const isSubmenuTrigger = (0, _menuTriggerContext.useMenuTriggerContext_unstable)();
    const persistOnClickContext = (0, _menuContext.useMenuContext_unstable)((context)=>context.persistOnItemClick);
    const { as = 'div', disabled = false, hasSubmenu = isSubmenuTrigger, persistOnClick = persistOnClickContext, content: _content, ...rest } = props;
    const { hasIcons, hasCheckmarks } = useIconAndCheckmarkAlignment({
        hasSubmenu
    });
    const setOpen = (0, _menuContext.useMenuContext_unstable)((context)=>context.setOpen);
    useNotifySplitItemMultiline({
        multiline: !!props.subText,
        hasSubmenu
    });
    const { dir } = (0, _reactsharedcontexts.useFluent_unstable)();
    const innerRef = _react.useRef(null);
    const dismissedWithKeyboardRef = _react.useRef(false);
    const validateNestingRef = (0, _useValidateNesting.useValidateNesting)(getValidateNestingComponentName(props.role));
    const state = {
        hasSubmenu,
        disabled,
        persistOnClick,
        components: {
            root: 'div',
            icon: 'span',
            checkmark: 'span',
            submenuIndicator: 'span',
            content: 'span',
            secondaryContent: 'span',
            subText: 'span'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)(as, (0, _reactaria.useARIAButtonProps)(as, {
            role: 'menuitem',
            ...rest,
            disabled: false,
            disabledFocusable: disabled,
            ref: (0, _reactutilities.useMergedRefs)(ref, innerRef, validateNestingRef),
            onKeyDown: (0, _reactutilities.useEventCallback)((event)=>{
                var _props_onKeyDown;
                (_props_onKeyDown = props.onKeyDown) === null || _props_onKeyDown === void 0 ? void 0 : _props_onKeyDown.call(props, event);
                if (!event.isDefaultPrevented() && (event.key === _keyboardkeys.Space || event.key === _keyboardkeys.Enter)) {
                    dismissedWithKeyboardRef.current = true;
                }
            }),
            onMouseMove: (0, _reactutilities.useEventCallback)((event)=>{
                var _props_onMouseMove;
                if (event.currentTarget.ownerDocument.activeElement !== event.currentTarget) {
                    var _innerRef_current;
                    (_innerRef_current = innerRef.current) === null || _innerRef_current === void 0 ? void 0 : _innerRef_current.focus();
                }
                (_props_onMouseMove = props.onMouseMove) === null || _props_onMouseMove === void 0 ? void 0 : _props_onMouseMove.call(props, event);
            }),
            onClick: (0, _reactutilities.useEventCallback)((event)=>{
                var _props_onClick;
                if (!hasSubmenu && !persistOnClick) {
                    setOpen(event, {
                        open: false,
                        keyboard: dismissedWithKeyboardRef.current,
                        bubble: true,
                        type: 'menuItemClick',
                        event
                    });
                    dismissedWithKeyboardRef.current = false;
                }
                (_props_onClick = props.onClick) === null || _props_onClick === void 0 ? void 0 : _props_onClick.call(props, event);
            })
        })), {
            elementType: 'div'
        }),
        icon: _reactutilities.slot.optional(props.icon, {
            renderByDefault: hasIcons,
            elementType: 'span'
        }),
        checkmark: _reactutilities.slot.optional(props.checkmark, {
            renderByDefault: hasCheckmarks,
            elementType: 'span'
        }),
        submenuIndicator: _reactutilities.slot.optional(props.submenuIndicator, {
            renderByDefault: hasSubmenu,
            defaultProps: {
                children: dir === 'ltr' ? /*#__PURE__*/ _react.createElement(ChevronRightIcon, null) : /*#__PURE__*/ _react.createElement(ChevronLeftIcon, null)
            },
            elementType: 'span'
        }),
        content: _reactutilities.slot.optional(props.content, {
            renderByDefault: !!props.children,
            defaultProps: {
                children: props.children
            },
            elementType: 'span'
        }),
        secondaryContent: _reactutilities.slot.optional(props.secondaryContent, {
            elementType: 'span'
        }),
        subText: _reactutilities.slot.optional(props.subText, {
            elementType: 'span'
        })
    };
    (0, _useCharacterSearch.useCharacterSearch)(state, innerRef);
    return state;
};
/**
 * MenuSplitGroup needs to apply extra styles when its main item is in multiline layout mode
 * Notify the parent MenuSplitGroup so that it can handle this case
 */ const useNotifySplitItemMultiline = (options)=>{
    const { hasSubmenu, multiline } = options;
    const isSplitItemTrigger = (0, _menuSplitGroupContext.useIsInMenuSplitGroup)() && hasSubmenu;
    const { setMultiline } = (0, _menuSplitGroupContext.useMenuSplitGroupContext_unstable)();
    (0, _reactutilities.useIsomorphicLayoutEffect)(()=>{
        if (!isSplitItemTrigger) {
            setMultiline(multiline);
        }
    }, [
        setMultiline,
        multiline,
        isSplitItemTrigger
    ]);
};
const useIconAndCheckmarkAlignment = (options)=>{
    const { hasSubmenu } = options;
    const hasIcons = (0, _menuListContext.useMenuListContext_unstable)((context)=>context.hasIcons);
    const hasCheckmarks = (0, _menuListContext.useMenuListContext_unstable)((context)=>context.hasCheckmarks);
    const isSplitItemTrigger = (0, _menuSplitGroupContext.useIsInMenuSplitGroup)() && hasSubmenu;
    return {
        hasIcons: hasIcons && !isSplitItemTrigger,
        hasCheckmarks: hasCheckmarks && !isSplitItemTrigger
    };
};
const getValidateNestingComponentName = (role)=>{
    switch(role){
        case 'menuitemcheckbox':
            return 'MenuItemCheckbox';
        case 'menuitemradio':
            return 'MenuItemRadio';
    }
    return 'MenuItem';
};
