'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useMenu_unstable", {
    enumerable: true,
    get: function() {
        return useMenu_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactpositioning = require("@fluentui/react-positioning");
const _reactutilities = require("@fluentui/react-utilities");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _reacttabster = require("@fluentui/react-tabster");
const _menuContext = require("../../contexts/menuContext");
const _utils = require("../../utils");
const _useMenuItemStylesstyles = require("../MenuItem/useMenuItemStyles.styles");
// If it's not possible to position the submenu in smaller viewports, try
// and fallback to this order of positions
const submenuFallbackPositions = [
    'after',
    'after-bottom',
    'before-top',
    'before',
    'before-bottom',
    'above'
];
const useMenu_unstable = (props)=>{
    const isSubmenu = (0, _utils.useIsSubmenu)();
    const { hoverDelay = 500, inline = false, hasCheckmarks = false, hasIcons = false, closeOnScroll = false, openOnContext = false, persistOnItemClick = false, openOnHover = isSubmenu, defaultCheckedValues, mountNode = null, safeZone } = props;
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const triggerId = (0, _reactutilities.useId)('menu');
    const [contextTarget, setContextTarget] = (0, _reactpositioning.usePositioningMouseTarget)();
    const positioningOptions = {
        position: isSubmenu ? 'after' : 'below',
        align: isSubmenu ? 'top' : 'start',
        target: props.openOnContext ? contextTarget : undefined,
        fallbackPositions: isSubmenu ? submenuFallbackPositions : undefined,
        ...(0, _reactpositioning.resolvePositioningShorthand)(props.positioning)
    };
    const children = _react.Children.toArray(props.children);
    if (process.env.NODE_ENV !== 'production') {
        if (children.length === 0) {
            // eslint-disable-next-line no-console
            console.warn('Menu must contain at least one child');
        }
        if (children.length > 2) {
            // eslint-disable-next-line no-console
            console.warn('Menu must contain at most two children');
        }
    }
    let menuTrigger = undefined;
    let menuPopover = undefined;
    if (children.length === 2) {
        menuTrigger = children[0];
        menuPopover = children[1];
    } else if (children.length === 1) {
        menuPopover = children[0];
    }
    const { targetRef, containerRef } = (0, _reactpositioning.usePositioning)(positioningOptions);
    const enableSafeZone = safeZone && openOnHover;
    const safeZoneDescriptorRef = _react.useRef({
        isInside: false,
        mouseCoordinates: {
            x: 0,
            y: 0
        }
    });
    const safeZoneHandle = (0, _reactpositioning.useSafeZoneArea)({
        disabled: !enableSafeZone,
        timeout: typeof safeZone === 'object' ? safeZone.timeout : 300,
        onSafeZoneEnter: (e)=>{
            setOpen(e, {
                open: true,
                keyboard: false,
                type: 'menuSafeZoneMouseEnter',
                event: e
            });
            safeZoneDescriptorRef.current.isInside = true;
        },
        onSafeZoneLeave: ()=>{
            safeZoneDescriptorRef.current.isInside = false;
        },
        onSafeZoneMove: (e)=>{
            safeZoneDescriptorRef.current.mouseCoordinates = {
                x: e.clientX,
                y: e.clientY
            };
        },
        onSafeZoneTimeout: ()=>{
            const event = new CustomEvent(_utils.MENU_SAFEZONE_TIMEOUT_EVENT);
            setOpen(event, {
                open: false,
                keyboard: false,
                type: 'menuSafeZoneTimeout',
                event
            });
            if (safeZoneDescriptorRef.current.isInside && targetDocument) {
                const elementsInPoint = targetDocument.elementsFromPoint(safeZoneDescriptorRef.current.mouseCoordinates.x, safeZoneDescriptorRef.current.mouseCoordinates.y);
                const menuItemEl = elementsInPoint.find((el)=>{
                    return el.classList.contains(_useMenuItemStylesstyles.menuItemClassNames.root);
                });
                menuItemEl === null || menuItemEl === void 0 ? void 0 : menuItemEl.dispatchEvent(event);
            }
        }
    });
    const triggerRef = (0, _reactutilities.useMergedRefs)(targetRef, safeZoneHandle.targetRef);
    const menuPopoverRef = (0, _reactutilities.useMergedRefs)(containerRef, safeZoneHandle.containerRef);
    // TODO Better way to narrow types ?
    const [open, setOpen] = useMenuOpenState({
        hoverDelay,
        isSubmenu,
        setContextTarget,
        closeOnScroll,
        menuPopoverRef,
        triggerRef,
        open: props.open,
        defaultOpen: props.defaultOpen,
        onOpenChange: props.onOpenChange,
        openOnContext
    });
    const [checkedValues, onCheckedValueChange] = useMenuSelectableState({
        checkedValues: props.checkedValues,
        defaultCheckedValues,
        onCheckedValueChange: props.onCheckedValueChange
    });
    return {
        inline,
        hoverDelay,
        triggerId,
        isSubmenu,
        openOnHover,
        contextTarget,
        setContextTarget,
        hasCheckmarks,
        hasIcons,
        closeOnScroll,
        menuTrigger,
        menuPopover,
        mountNode,
        triggerRef,
        menuPopoverRef,
        components: {},
        openOnContext,
        open,
        setOpen,
        checkedValues,
        onCheckedValueChange,
        persistOnItemClick,
        safeZone: safeZoneHandle.elementToRender
    };
};
/**
 * Adds appropriate state values and handlers for selectable items
 * i.e checkboxes and radios
 */ const useMenuSelectableState = (props)=>{
    const [checkedValues, setCheckedValues] = (0, _reactutilities.useControllableState)({
        state: props.checkedValues,
        defaultState: props.defaultCheckedValues,
        initialState: {}
    });
    const onCheckedValueChange = (0, _reactutilities.useEventCallback)((e, { name, checkedItems })=>{
        var _props_onCheckedValueChange;
        (_props_onCheckedValueChange = props.onCheckedValueChange) === null || _props_onCheckedValueChange === void 0 ? void 0 : _props_onCheckedValueChange.call(props, e, {
            name,
            checkedItems
        });
        setCheckedValues((currentValue)=>({
                ...currentValue,
                [name]: checkedItems
            }));
    });
    return [
        checkedValues,
        onCheckedValueChange
    ];
};
const useMenuOpenState = (state)=>{
    'use no memo';
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const parentSetOpen = (0, _menuContext.useMenuContext_unstable)((context)=>context.setOpen);
    const onOpenChange = (0, _reactutilities.useEventCallback)((e, data)=>{
        var _state_onOpenChange;
        return (_state_onOpenChange = state.onOpenChange) === null || _state_onOpenChange === void 0 ? void 0 : _state_onOpenChange.call(state, e, data);
    });
    const enteringTriggerRef = _react.useRef(false);
    const [open, setOpenState] = (0, _reactutilities.useControllableState)({
        state: state.open,
        defaultState: state.defaultOpen,
        initialState: false
    });
    const trySetOpen = (0, _reactutilities.useEventCallback)((e, data)=>{
        const event = e instanceof CustomEvent && e.type === _utils.MENU_ENTER_EVENT ? e.detail.nativeEvent : e;
        onOpenChange === null || onOpenChange === void 0 ? void 0 : onOpenChange(event, {
            ...data
        });
        if (data.open && e.type === 'contextmenu') {
            state.setContextTarget(e);
        }
        if (!data.open) {
            state.setContextTarget(undefined);
        }
        if (data.bubble) {
            parentSetOpen(e, {
                ...data
            });
        }
        setOpenState(data.open);
    });
    const [setOpenTimeout, clearOpenTimeout] = (0, _reactutilities.useTimeout)();
    const setOpen = (0, _reactutilities.useEventCallback)((e, data)=>{
        clearOpenTimeout();
        if (!(e instanceof Event) && e.persist) {
            // < React 17 still uses pooled synthetic events
            e.persist();
        }
        const shouldUseDelay = !data.ignoreHoverDelay && (e.type === 'mouseleave' || e.type === 'mouseover' || e.type === 'mousemove' || e.type === _utils.MENU_ENTER_EVENT);
        if (shouldUseDelay) {
            var _state_triggerRef_current;
            if ((_state_triggerRef_current = state.triggerRef.current) === null || _state_triggerRef_current === void 0 ? void 0 : _state_triggerRef_current.contains(e.target)) {
                enteringTriggerRef.current = e.type === 'mouseover' || e.type === 'mousemove';
            }
            setOpenTimeout(()=>trySetOpen(e, data), state.hoverDelay);
        } else {
            trySetOpen(e, data);
        }
    });
    (0, _reactutilities.useOnClickOutside)({
        contains: _reactutilities.elementContains,
        disabled: !open,
        element: targetDocument,
        refs: [
            state.menuPopoverRef,
            !state.openOnContext && state.triggerRef
        ].filter(Boolean),
        callback: (event)=>setOpen(event, {
                open: false,
                type: 'clickOutside',
                event
            })
    });
    // only close on scroll for context, or when closeOnScroll is specified
    const closeOnScroll = state.openOnContext || state.closeOnScroll;
    (0, _reactutilities.useOnScrollOutside)({
        contains: _reactutilities.elementContains,
        element: targetDocument,
        callback: (event)=>setOpen(event, {
                open: false,
                type: 'scrollOutside',
                event
            }),
        refs: [
            state.menuPopoverRef,
            !state.openOnContext && state.triggerRef
        ].filter(Boolean),
        disabled: !open || !closeOnScroll
    });
    (0, _utils.useOnMenuMouseEnter)({
        element: targetDocument,
        callback: (event)=>{
            // When moving from a menu directly back to its trigger, this handler can close the menu
            // Explicitly check a flag to see if this situation happens
            if (!enteringTriggerRef.current) {
                setOpen(event, {
                    open: false,
                    type: 'menuMouseEnter',
                    event
                });
            }
        },
        disabled: !open,
        refs: [
            state.menuPopoverRef
        ]
    });
    // Manage focus for open state
    const { findFirstFocusable } = (0, _reacttabster.useFocusFinders)();
    const focusFirst = _react.useCallback(()=>{
        const firstFocusable = findFirstFocusable(state.menuPopoverRef.current);
        firstFocusable === null || firstFocusable === void 0 ? void 0 : firstFocusable.focus();
    }, [
        findFirstFocusable,
        state.menuPopoverRef
    ]);
    const firstMount = (0, _reactutilities.useFirstMount)();
    _react.useEffect(()=>{
        if (open) {
            focusFirst();
        } else {
            if (!firstMount) {
                if ((targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.activeElement) === (targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.body)) {
                    var // after any event handler (event handlers will update state and re-render).
                    // Since the browser only performs the default behaviour for the Tab key once
                    // keyboard events have fully bubbled up the window, the browser will move
                    // focus to the next tabbable element before/after the trigger if needed.
                    // If the Tab key was not pressed, focus will remain on the trigger as expected.
                    _state_triggerRef_current;
                    (_state_triggerRef_current = state.triggerRef.current) === null || _state_triggerRef_current === void 0 ? void 0 : _state_triggerRef_current.focus();
                }
            }
        }
    // firstMount change should not re-run this effect
    // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [
        state.triggerRef,
        state.isSubmenu,
        open,
        focusFirst,
        targetDocument,
        state.menuPopoverRef
    ]);
    return [
        open,
        setOpen
    ];
};
