import { ARIAButtonElement } from '@fluentui/react-aria';
import { ARIAButtonResultProps } from '@fluentui/react-aria';
import { ARIAButtonType } from '@fluentui/react-aria';
import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { ContextSelector } from '@fluentui/react-context-selector';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import type { PortalProps } from '@fluentui/react-portal';
import type { PositioningShorthand } from '@fluentui/react-positioning';
import { PositioningVirtualElement } from '@fluentui/react-positioning';
import * as React_2 from 'react';
import { SetVirtualMouseTarget } from '@fluentui/react-positioning';
import type { Slot } from '@fluentui/react-utilities';
import { SlotClassNames } from '@fluentui/react-utilities';
import type { TriggerProps } from '@fluentui/react-utilities';
import type { UseOnClickOrScrollOutsideOptions } from '@fluentui/react-utilities';

/**
 * Dispatches the custom MouseEvent enter event. Similar to calling `el.click()`
 * @param el - element for the event target
 * @param nativeEvent - the native mouse event this is mapped to
 */
export declare const dispatchMenuEnterEvent: (el: HTMLElement, nativeEvent: MouseEvent) => void;

/**
 * Wrapper component that manages state for a popup MenuList and a MenuTrigger
 */
export declare const Menu: React_2.FC<MenuProps>;

/**
 * Name of the custom event
 */
export declare const MENU_ENTER_EVENT = "fuimenuenter";

export declare type MenuCheckedValueChangeData = {
    /** The items for this value that are checked */
    checkedItems: string[];
    /** The name of the value */
    name: string;
};

export declare type MenuCheckedValueChangeEvent = React_2.MouseEvent | React_2.KeyboardEvent;

/**
 * Context shared between Menu and its children components
 *
 * Extends and drills down MenuList props to simplify API
 */
export declare type MenuContextValue = Pick<MenuState, 'openOnHover' | 'openOnContext' | 'triggerRef' | 'menuPopoverRef' | 'setOpen' | 'isSubmenu' | 'mountNode' | 'triggerId' | 'hasIcons' | 'hasCheckmarks' | 'persistOnItemClick' | 'inline' | 'checkedValues' | 'onCheckedValueChange' | 'safeZone'> & {
    open: boolean;
    triggerId: string;
    /**
     * Default values to be checked on mount
     * @deprecated this property is not used internally anymore,
     * the signature remains just to avoid breaking changes
     */
    defaultCheckedValues?: Record<string, string[]>;
};

export declare type MenuContextValues = {
    menu: MenuContextValue;
};

/**
 * Define a styled MenuDivider, using the `useMenuDivider_unstable` hook.
 */
export declare const MenuDivider: ForwardRefComponent<MenuDividerProps>;

export declare const menuDividerClassNames: SlotClassNames<MenuDividerSlots>;

export declare type MenuDividerProps = ComponentProps<MenuDividerSlots>;

export declare type MenuDividerSlots = {
    root: Slot<'div'>;
};

export declare type MenuDividerState = ComponentState<MenuDividerSlots>;

/**
 * Define a styled MenuGroup, using the `useMenuGroup_unstable` hook.
 */
export declare const MenuGroup: ForwardRefComponent<MenuGroupProps>;

export declare const menuGroupClassNames: SlotClassNames<MenuGroupSlots>;

export declare const MenuGroupContextProvider: React_2.Provider<MenuGroupContextValue>;

/**
 * Context used to guarantee correct aria-relationship between header
 * and group information
 */
export declare type MenuGroupContextValue = {
    /**
     * Element id applied to the `MenuGroupHeader` component
     */
    headerId: string;
};

export declare type MenuGroupContextValues = {
    menuGroup: MenuGroupContextValue;
};

/**
 * Define a styled MenuGroupHeader, using the `useMenuGroupHeader_unstable` hook.
 */
export declare const MenuGroupHeader: ForwardRefComponent<MenuGroupHeaderProps>;

export declare const menuGroupHeaderClassNames: SlotClassNames<MenuGroupHeaderSlots>;

export declare type MenuGroupHeaderProps = ComponentProps<MenuGroupHeaderSlots>;

export declare type MenuGroupHeaderSlots = {
    root: Slot<'div'>;
};

export declare type MenuGroupHeaderState = ComponentState<MenuGroupHeaderSlots>;

export declare type MenuGroupProps = ComponentProps<MenuGroupSlots>;

export declare type MenuGroupSlots = {
    root: Slot<'div'>;
};

export declare type MenuGroupState = ComponentState<MenuGroupSlots> & {
    /**
     * id applied to the DOM element of `MenuGroupHeader`
     */
    headerId: string;
};

/**
 * Define a styled MenuItem, using the `useMenuItem_unstable` and `useMenuItemStyles_unstable` hook.
 */
export declare const MenuItem: ForwardRefComponent<MenuItemProps>;

/**
 * Define a styled MenuItemCheckbox, using the `useMenuItemCheckbox_unstable` hook.
 */
export declare const MenuItemCheckbox: ForwardRefComponent<MenuItemCheckboxProps>;

export declare const menuItemCheckboxClassNames: SlotClassNames<Omit<MenuItemSlots, 'submenuIndicator'>>;

export declare type MenuItemCheckboxProps = MenuItemProps & MenuItemSelectableProps;

export declare type MenuItemCheckboxState = MenuItemState & MenuItemSelectableState;

export declare const menuItemClassNames: SlotClassNames<MenuItemSlots>;

/**
 * MenuItemLink component
 */
export declare const MenuItemLink: ForwardRefComponent<MenuItemLinkProps>;

export declare const menuItemLinkClassNames: SlotClassNames<MenuItemLinkSlots>;

/**
 * MenuItemLink Props
 */
export declare type MenuItemLinkProps = ComponentProps<MenuItemLinkSlots> & Pick<MenuItemProps, 'disabled'> & {
    href: string;
};

export declare type MenuItemLinkSlots = {
    root: Slot<'a'>;
} & Pick<MenuItemSlots, 'icon' | 'content' | 'secondaryContent' | 'checkmark'>;

/**
 * State used in rendering MenuItemLink
 */
export declare type MenuItemLinkState = ComponentState<MenuItemLinkSlots>;

export declare type MenuItemProps = Omit<ComponentProps<Partial<MenuItemSlots>>, 'content'> & Pick<Partial<MenuItemSlots>, 'content'> & {
    /**
     * If the menu item is a trigger for a submenu
     *
     * @default false
     */
    hasSubmenu?: boolean;
    /**
     * Clicking on the menu item will not dismiss an open menu
     *
     * @default false
     */
    persistOnClick?: boolean;
    disabled?: boolean;
    /**
     * @deprecated this property does nothing.
     * disabled focusable is by default by simply using `disabled` property
     */
    disabledFocusable?: boolean;
};

/**
 * Define a styled MenuItemRadio, using the `useMenuItemRadio_unstable` hook.
 */
export declare const MenuItemRadio: ForwardRefComponent<MenuItemRadioProps>;

export declare const menuItemRadioClassNames: SlotClassNames<Omit<MenuItemSlots, 'submenuIndicator'>>;

export declare type MenuItemRadioProps = MenuItemProps & MenuItemSelectableProps;

export declare type MenuItemRadioState = MenuItemState & MenuItemSelectableState;

/**
 * Props for selecatble menu items
 */
export declare type MenuItemSelectableProps = {
    /**
     * Follows input convention
     * https://www.w3schools.com/jsref/prop_checkbox_name.asp
     */
    name: string;
    /**
     * Follows input convention
     * https://www.w3schools.com/jsref/prop_checkbox_value.asp
     */
    value: string;
};

/**
 * State for selectable menu items
 */
export declare type MenuItemSelectableState = MenuItemSelectableProps & {
    /**
     * Selectable is checked
     */
    checked: boolean;
};

export declare type MenuItemSlots = {
    root: Slot<'div'>;
    /**
     * Icon slot rendered before children content
     */
    icon?: Slot<'span'>;
    /**
     * A helper slot for alignment when a menu item is used with selectable menuitems
     * Avoid using this slot as a replacement for MenuItemCheckbox and MenuItemRadio components
     */
    checkmark?: Slot<'span'>;
    /**
     * Icon slot that shows the indicator for a submenu
     */
    submenuIndicator?: Slot<'span'>;
    /**
     * Component children are placed in this slot
     * Avoid using the `children` property in this slot in favour of Component children whenever possible
     */
    content?: Slot<'span'>;
    /**
     * Secondary content rendered opposite the primary content (e.g Shortcut text)
     */
    secondaryContent?: Slot<'span'>;
    /**
     * Additional descriptor to main content that creates a multiline layout
     */
    subText?: Slot<'span'>;
};

export declare type MenuItemState = ComponentState<MenuItemSlots> & Required<Pick<MenuItemProps, 'disabled' | 'hasSubmenu' | 'persistOnClick'>>;

export declare const MenuItemSwitch: ForwardRefComponent<MenuItemSwitchProps>;

export declare const menuItemSwitchClassNames: SlotClassNames<MenuItemSwitchSlots>;

/**
 * MenuItemSwitch Props
 */
export declare type MenuItemSwitchProps = ComponentProps<MenuItemSwitchSlots> & Pick<MenuItemCheckboxProps, 'disabled' | 'persistOnClick' | 'name' | 'value'>;

export declare type MenuItemSwitchSlots = Pick<MenuItemSlots, 'root' | 'content' | 'secondaryContent' | 'icon' | 'subText'> & {
    switchIndicator?: Slot<'span'>;
};

/**
 * State used in rendering MenuItemSwitch
 */
export declare type MenuItemSwitchState = ComponentState<MenuItemSwitchSlots> & MenuItemSelectableState & Required<Pick<MenuItemSwitchProps, 'disabled'>>;

/**
 * Define a styled MenuList, using the `useMenuList_unstable` hook.
 */
export declare const MenuList: ForwardRefComponent<MenuListProps>;

export declare const menuListClassNames: SlotClassNames<MenuListSlots>;

/**
 * Context shared between MenuList and its children components
 */
export declare type MenuListContextValue = Pick<MenuListProps, 'checkedValues' | 'hasIcons' | 'hasCheckmarks'> & {
    setFocusByFirstCharacter?: (e: React_2.KeyboardEvent<HTMLElement>, itemEl: HTMLElement) => void;
    toggleCheckbox?: SelectableHandler;
    selectRadio?: SelectableHandler;
    /**
     * Callback when checked items change for value with a name
     *
     * @param event - React's original SyntheticEvent
     * @param data - A data object with relevant information
     *
     * @deprecated this property is not used internally anymore,
     * the signature remains just to avoid breaking changes
     */
    onCheckedValueChange?: (e: MenuCheckedValueChangeEvent, data: MenuCheckedValueChangeData) => void;
};

export declare type MenuListContextValues = {
    menuList: MenuListContextValue;
};

export declare type MenuListProps = ComponentProps<MenuListSlots> & {
    /**
     * Map of all checked values
     */
    checkedValues?: Record<string, string[]>;
    /**
     * Default values to be checked on mount
     */
    defaultCheckedValues?: Record<string, string[]>;
    /**
     * States that menu items can contain selectable items and reserve slots for item alignment
     */
    hasCheckmarks?: boolean;
    /**
     * States that menu items can contain icons and reserve slots for item alignment
     */
    hasIcons?: boolean;
    /**
     * Callback when checked items change for value with a name
     *
     * @param event - React's original SyntheticEvent
     * @param data - A data object with relevant information
     */
    onCheckedValueChange?: (e: MenuCheckedValueChangeEvent, data: MenuCheckedValueChangeData) => void;
};

export declare const MenuListProvider: React_2.Provider<MenuListContextValue> & React_2.FC<React_2.ProviderProps<MenuListContextValue>>;

export declare type MenuListSlots = {
    root: Slot<'div'>;
};

export declare type MenuListState = ComponentState<MenuListSlots> & Required<Pick<MenuListProps, 'checkedValues' | 'hasCheckmarks' | 'hasIcons'>> & Pick<MenuListProps, 'defaultCheckedValues' | 'onCheckedValueChange'> & {
    /**
     * Selects a radio item, will de-select the currently selected ratio item
     */
    selectRadio: SelectableHandler;
    /**
     * Callback to set focus on the next menu item by first character
     */
    setFocusByFirstCharacter: NonNullable<MenuListContextValue['setFocusByFirstCharacter']>;
    toggleCheckbox: SelectableHandler;
    /**
     * States if the MenuList is inside MenuContext
     */
    hasMenuContext?: boolean;
};

/**
 * Data attached to open/close events
 */
export declare type MenuOpenChangeData = {
    /**
     * indicates whether the request for the open state was bubbled from a nested menu
     */
    bubble?: boolean;
    /**
     * Indicates whether the change of state was a keyboard interaction
     * @deprecated
     * This should not be used, since `Enter`, `Space` and click should be interpreted as the same thing as a click
     */
    keyboard?: boolean;
    open: boolean;
} & ({
    type: 'menuTriggerContextMenu';
    event: React_2.MouseEvent<HTMLElement>;
} | {
    type: 'menuTriggerClick';
    event: React_2.MouseEvent<HTMLElement>;
} | {
    type: 'menuTriggerMouseEnter';
    event: React_2.MouseEvent<HTMLElement>;
} | {
    type: 'menuSafeZoneMouseEnter';
    event: React_2.MouseEvent;
} | {
    type: 'menuSafeZoneTimeout';
    event: Event;
} | {
    type: 'menuTriggerMouseLeave';
    event: React_2.MouseEvent<HTMLElement>;
} | {
    type: 'menuTriggerMouseMove';
    event: React_2.MouseEvent<HTMLElement>;
} | {
    type: 'menuTriggerKeyDown';
    event: React_2.KeyboardEvent<HTMLElement>;
} | {
    type: 'menuItemClick';
    event: React_2.MouseEvent<HTMLElement>;
} | {
    type: 'menuPopoverMouseEnter';
    event: React_2.MouseEvent<HTMLElement>;
} | {
    type: 'menuPopoverKeyDown';
    event: React_2.KeyboardEvent<HTMLElement>;
} | {
    type: 'clickOutside';
    event: MouseEvent | TouchEvent;
} | {
    type: 'scrollOutside';
    event: MouseEvent | TouchEvent;
} | {
    type: 'menuMouseEnter';
    event: MouseEvent | TouchEvent;
});

/**
 * The supported events that will trigger open/close of the menu
 */
export declare type MenuOpenEvent = MenuOpenChangeData['event'];

/**
 * @deprecated use MenuOpenEvent instead
 */
export declare type MenuOpenEvents = MenuOpenEvent;

/**
 * Popover intended to wrap `MenuList` and adds styling and interaction support specific to menus
 */
export declare const MenuPopover: ForwardRefComponent<MenuPopoverProps>;

export declare const menuPopoverClassNames: SlotClassNames<MenuPopoverSlots>;

/**
 * MenuPopover Props
 */
export declare type MenuPopoverProps = ComponentProps<MenuPopoverSlots>;

export declare type MenuPopoverSlots = {
    root: Slot<'div'>;
};

/**
 * State used in rendering MenuPopover
 */
export declare type MenuPopoverState = ComponentState<MenuPopoverSlots> & Pick<PortalProps, 'mountNode'> & {
    /**
     * Root menus are rendered out of DOM order on `document.body`, use this to render the menu in DOM order
     * This option is disregarded for submenus
     */
    inline: boolean;
    safeZone?: React_2.ReactElement | null;
};

/**
 * Extends and drills down Menulist props to simplify API
 */
export declare type MenuProps = ComponentProps<MenuSlots> & Pick<PortalProps, 'mountNode'> & Pick<MenuListProps, 'checkedValues' | 'defaultCheckedValues' | 'hasCheckmarks' | 'hasIcons' | 'onCheckedValueChange'> & {
    /**
     * Can contain two children including `MenuTrigger` and `MenuPopover`.
     * Alternatively can only contain `MenuPopover` if using a custom `target`.
     */
    children: [JSXElement, JSXElement] | JSXElement;
    /**
     * Sets the delay for mouse open/close for the popover one mouse enter/leave
     */
    hoverDelay?: number;
    /**
     * Root menus are rendered out of DOM order on `document.body`, use this to render the menu in DOM order
     * This option is disregarded for submenus
     *
     * @default false
     */
    inline?: boolean;
    /**
     * Call back when the component requests to change value
     * The `open` value is used as a hint when directly controlling the component
     */
    onOpenChange?: (e: MenuOpenEvent, data: MenuOpenChangeData) => void;
    /**
     * Whether the popup is open
     *
     * @default false
     */
    open?: boolean;
    /**
     * Whether the popup is open by default
     *
     * @default false
     */
    defaultOpen?: boolean;
    /**
     * Opens the menu on right click (context menu), removes all other menu open interactions
     *
     * @default false
     */
    openOnContext?: boolean;
    /**
     * Opens the menu on hover
     *
     * @default false
     */
    openOnHover?: boolean;
    /**
     * Do not dismiss the menu when a menu item is clicked
     *
     * @default false
     */
    persistOnItemClick?: boolean;
    /**
     * Configures the positioned menu
     */
    positioning?: PositioningShorthand;
    /**
     * Close when scroll outside of it
     *
     * @default false
     */
    closeOnScroll?: boolean;
};

export declare const MenuProvider: React_2.Provider<MenuContextValue> & React_2.FC<React_2.ProviderProps<MenuContextValue>>;

export declare type MenuSlots = {};

/**
 * Layout wrapper that provides extra keyboard navigation behavior for two `MenuItem` components.
 */
export declare const MenuSplitGroup: ForwardRefComponent<MenuSplitGroupProps>;

export declare const menuSplitGroupClassNames: SlotClassNames<MenuSplitGroupSlots>;

declare type MenuSplitGroupContextValue = {
    setMultiline: (multiline: boolean) => void;
};

declare type MenuSplitGroupContextValues = {
    menuSplitGroup: MenuSplitGroupContextValue;
};

/**
 * MenuSplitGroup Props
 */
export declare type MenuSplitGroupProps = ComponentProps<MenuSplitGroupSlots>;

export declare type MenuSplitGroupSlots = {
    root: Slot<'div'>;
};

/**
 * State used in rendering MenuSplitGroup
 */
export declare type MenuSplitGroupState = ComponentState<MenuSplitGroupSlots> & Pick<MenuSplitGroupContextValue, 'setMultiline'>;

export declare type MenuState = ComponentState<MenuSlots> & Required<Pick<MenuProps, 'hasCheckmarks' | 'hasIcons' | 'mountNode' | 'inline' | 'checkedValues' | 'onCheckedValueChange' | 'open' | 'openOnHover' | 'closeOnScroll' | 'hoverDelay' | 'openOnContext' | 'persistOnItemClick'>> & {
    /**
     * Anchors the popper to the mouse click for context events
     */
    contextTarget?: PositioningVirtualElement;
    /**
     * Whether this menu is a submenu
     */
    isSubmenu: boolean;
    /**
     * Internal react node that just simplifies handling children
     */
    menuPopover: React_2.ReactNode;
    /**
     * The ref for the popup
     */
    menuPopoverRef: React_2.MutableRefObject<HTMLElement | null>;
    /**
     * Internal react node that just simplifies handling children
     */
    menuTrigger: React_2.ReactNode;
    /**
     * A callback to set the target of the popper to the mouse click for context events
     */
    setContextTarget: SetVirtualMouseTarget;
    /**
     * Callback to open/close the popup
     */
    setOpen: (e: MenuOpenEvent, data: MenuOpenChangeData & {
        ignoreHoverDelay?: boolean;
    }) => void;
    /**
     * Id for the MenuTrigger element for aria relationship
     */
    triggerId: string;
    /**
     * The ref for the MenuTrigger, used for popup positioning
     */
    triggerRef: React_2.MutableRefObject<HTMLElement | null>;
    /**
     * Call back when the component requests to change value
     * The `open` value is used as a hint when directly controlling the component
     * @deprecated this property is not used internally anymore,
     * the signature remains just to avoid breaking changes
     */
    onOpenChange?: (e: MenuOpenEvent, data: MenuOpenChangeData) => void;
    /**
     * Default values to be checked on mount
     @deprecated this property is not used internally anymore,
     * the signature remains just to avoid breaking changes
     */
    defaultCheckedValues?: Record<string, string[]>;
    /**
     * An optional safe zone area to be rendered around the menu
     */
    safeZone?: React_2.ReactElement | null;
};

/**
 * Wraps a trigger element as an only child
 * and adds the necessary event handling to open a popup menu
 */
export declare const MenuTrigger: React_2.FC<MenuTriggerProps>;

/**
 * Props that are passed to the child of the MenuTrigger when cloned to ensure correct behaviour for the Menu
 */
export declare type MenuTriggerChildProps<Type extends ARIAButtonType = ARIAButtonType, Props = {}> = ARIAButtonResultProps<Type, Props & {
    'aria-haspopup'?: 'menu';
    'aria-expanded'?: boolean;
    id: string;
    ref: React_2.Ref<never>;
    onMouseEnter: React_2.MouseEventHandler<HTMLButtonElement & HTMLAnchorElement & HTMLDivElement>;
    onMouseLeave: React_2.MouseEventHandler<HTMLButtonElement & HTMLAnchorElement & HTMLDivElement>;
    onMouseMove: React_2.MouseEventHandler<HTMLButtonElement & HTMLAnchorElement & HTMLDivElement>;
    onMouseOver?: React_2.MouseEventHandler<HTMLButtonElement & HTMLAnchorElement & HTMLDivElement>;
    onContextMenu: React_2.MouseEventHandler<HTMLButtonElement & HTMLAnchorElement & HTMLDivElement>;
}>;

export declare const MenuTriggerContextProvider: React_2.Provider<boolean>;

export declare type MenuTriggerProps = TriggerProps<MenuTriggerChildProps> & {
    /**
     * Disables internal trigger mechanism that ensures a child provided will be a compliant ARIA button.
     * @default false
     */
    disableButtonEnhancement?: boolean;
};

export declare type MenuTriggerState = {
    children: React_2.ReactElement | null;
    isSubmenu: boolean;
};

/**
 * Render the final JSX of Menu
 */
export declare const renderMenu_unstable: (state: MenuState, contextValues: MenuContextValues) => JSXElement;

/**
 * Redefine the render function to add slots. Reuse the menudivider structure but add
 * slots to children.
 */
export declare const renderMenuDivider_unstable: (state: MenuDividerState) => JSXElement;

/**
 * Redefine the render function to add slots. Reuse the menugroup structure but add
 * slots to children.
 */
export declare const renderMenuGroup_unstable: (state: MenuGroupState, contextValues: MenuGroupContextValues) => JSXElement;

/**
 * Redefine the render function to add slots. Reuse the menugroupheader structure but add
 * slots to children.
 */
export declare const renderMenuGroupHeader_unstable: (state: MenuGroupHeaderState) => JSXElement;

/**
 * Function that renders the final JSX of the component
 */
export declare const renderMenuItem_unstable: (state: MenuItemState) => JSXElement;

/** Function that renders the final JSX of the component  */
export declare const renderMenuItemCheckbox_unstable: (state: MenuItemCheckboxState) => JSXElement;

/**
 * Render the final JSX of MenuItemLink
 */
export declare const renderMenuItemLink_unstable: (state: MenuItemLinkState) => JSXElement;

/**
 * Redefine the render function to add slots. Reuse the menuitemradio structure but add
 * slots to children.
 */
export declare const renderMenuItemRadio_unstable: (state: MenuItemRadioState) => JSXElement;

/**
 * Function that renders the final JSX of the component
 */
export declare const renderMenuItemSwitch_unstable: (state: MenuItemSwitchState) => JSXElement;

/**
 * Function that renders the final JSX of the component
 */
export declare const renderMenuList_unstable: (state: MenuListState, contextValues: MenuListContextValues) => JSXElement;

/**
 * Render the final JSX of MenuPopover
 */
export declare const renderMenuPopover_unstable: (state: MenuPopoverState) => JSXElement;

/**
 * Render the final JSX of MenuSplitGroup
 */
export declare const renderMenuSplitGroup_unstable: (state: MenuSplitGroupState, contexts?: MenuSplitGroupContextValues) => JSXElement;

/**
 * Render the final JSX of MenuTrigger
 *
 * Only renders children
 */
export declare const renderMenuTrigger_unstable: (state: MenuTriggerState) => JSXElement;

export declare type SelectableHandler = (e: React_2.MouseEvent | React_2.KeyboardEvent, name: string, value: string, checked: boolean) => void;

/**
 * @deprecated this type is not being used internally anymore
 */
export declare type UninitializedMenuListState = Omit<MenuListState, 'checkedValues' | 'selectRadio' | 'setFocusByFirstCharacter' | 'toggleCheckbox'> & Partial<Pick<MenuListState, 'checkedValues'>>;

/**
 * Applies styles to a checkmark slot for selectable menu items
 *
 * @param state - should contain a `checkmark` slot
 */
export declare const useCheckmarkStyles_unstable: (state: MenuItemSelectableState & Pick<MenuItemState, "checkmark">) => void;

/**
 * Create the state required to render Menu.
 *
 * The returned state can be modified with hooks such as useMenuStyles,
 * before being passed to renderMenu_unstable.
 *
 * @param props - props from this instance of Menu
 */
export declare const useMenu_unstable: (props: MenuProps & {
    safeZone?: boolean | {
        timeout?: number;
    };
}) => MenuState;

export declare const useMenuContext_unstable: <T>(selector: ContextSelector<MenuContextValue, T>) => T;

export declare function useMenuContextValues_unstable(state: MenuState): MenuContextValues;

/**
 * Given user props, returns state and render function for a MenuDivider.
 */
export declare const useMenuDivider_unstable: (props: MenuDividerProps, ref: React_2.Ref<HTMLElement>) => MenuDividerState;

export declare const useMenuDividerStyles_unstable: (state: MenuDividerState) => MenuDividerState;

/**
 * Given user props, returns state and render function for a MenuGroup.
 */
export declare function useMenuGroup_unstable(props: MenuGroupProps, ref: React_2.Ref<HTMLElement>): MenuGroupState;

export declare const useMenuGroupContext_unstable: () => MenuGroupContextValue;

export declare function useMenuGroupContextValues_unstable(state: MenuGroupState): MenuGroupContextValues;

/**
 * Given user props, returns state and render function for a MenuGroupHeader.
 */
export declare function useMenuGroupHeader_unstable(props: MenuGroupHeaderProps, ref: React_2.Ref<HTMLElement>): MenuGroupHeaderState;

export declare const useMenuGroupHeaderStyles_unstable: (state: MenuGroupHeaderState) => MenuGroupHeaderState;

export declare const useMenuGroupStyles_unstable: (state: MenuGroupState) => MenuGroupState;

/**
 * Returns the props and state required to render the component
 */
export declare const useMenuItem_unstable: (props: MenuItemProps, ref: React_2.Ref<ARIAButtonElement<"div">>) => MenuItemState;

/** Returns the props and state required to render the component */
export declare const useMenuItemCheckbox_unstable: (props: MenuItemCheckboxProps, ref: React_2.Ref<ARIAButtonElement<"div">>) => MenuItemCheckboxState;

export declare const useMenuItemCheckboxStyles_unstable: (state: MenuItemCheckboxState) => MenuItemCheckboxState;

/**
 * Create the state required to render MenuItemLink.
 *
 * The returned state can be modified with hooks such as useMenuItemLinkStyles_unstable,
 * before being passed to renderMenuItemLink_unstable.
 *
 * @param props - props from this instance of MenuItemLink
 * @param ref - reference to root HTMLElement of MenuItemLink
 */
export declare const useMenuItemLink_unstable: (props: MenuItemLinkProps, ref: React_2.Ref<HTMLAnchorElement>) => MenuItemLinkState;

/**
 * Apply styling to the MenuItemLink slots based on the state
 */
export declare const useMenuItemLinkStyles_unstable: (state: MenuItemLinkState) => MenuItemLinkState;

/**
 * Given user props, returns state and render function for a MenuItemRadio.
 */
export declare const useMenuItemRadio_unstable: (props: MenuItemRadioProps, ref: React_2.Ref<ARIAButtonElement<"div">>) => MenuItemRadioState;

export declare const useMenuItemRadioStyles_unstable: (state: MenuItemRadioState) => void;

/** Applies style classnames to slots */
export declare const useMenuItemStyles_unstable: (state: MenuItemState) => MenuItemState;

/**
 * Create the state required to render MenuItemSwitch.
 *
 * The returned state can be modified with hooks such as useMenuItemSwitchStyles_unstable,
 * before being passed to renderMenuItemSwitch_unstable.
 *
 * @param props - props from this instance of MenuItemSwitch
 * @param ref - reference to root HTMLDivElement of MenuItemSwitch
 */
export declare const useMenuItemSwitch_unstable: (props: MenuItemSwitchProps, ref: React_2.Ref<HTMLDivElement>) => MenuItemSwitchState;

/**
 * Apply styling to the MenuItemSwitch slots based on the state
 */
export declare const useMenuItemSwitchStyles_unstable: (state: MenuItemSwitchState) => MenuItemSwitchState;

/**
 * Returns the props and state required to render the component
 */
export declare const useMenuList_unstable: (props: MenuListProps, ref: React_2.Ref<HTMLElement>) => MenuListState;

export declare const useMenuListContext_unstable: <T>(selector: ContextSelector<MenuListContextValue, T>) => T;

export declare function useMenuListContextValues_unstable(state: MenuListState): MenuListContextValues;

/**
 * Apply styling to the Menu slots based on the state
 */
export declare const useMenuListStyles_unstable: (state: MenuListState) => MenuListState;

/**
 * Create the state required to render MenuPopover.
 *
 * The returned state can be modified with hooks such as useMenuPopoverStyles_unstable,
 * before being passed to renderMenuPopover_unstable.
 *
 * @param props - props from this instance of MenuPopover
 * @param ref - reference to root HTMLElement of MenuPopover
 */
export declare const useMenuPopover_unstable: (props: MenuPopoverProps, ref: React_2.Ref<HTMLElement>) => MenuPopoverState;

/**
 * Apply styling to the Menu slots based on the state
 */
export declare const useMenuPopoverStyles_unstable: (state: MenuPopoverState) => MenuPopoverState;

/**
 * Create the state required to render MenuSplitGroup.
 *
 * The returned state can be modified with hooks such as useMenuSplitGroupStyles_unstable,
 * before being passed to renderMenuSplitGroup_unstable.
 *
 * @param props - props from this instance of MenuSplitGroup
 * @param ref - reference to root HTMLElement of MenuSplitGroup
 */
export declare const useMenuSplitGroup_unstable: (props: MenuSplitGroupProps, ref: React_2.Ref<HTMLElement>) => MenuSplitGroupState;

/**
 * Apply styling to the MenuSplitGroup slots based on the state
 */
export declare const useMenuSplitGroupStyles_unstable: (state: MenuSplitGroupState) => MenuSplitGroupState;

/**
 * Create the state required to render MenuTrigger.
 * Clones the only child component and adds necessary event handling behaviours to open a popup menu
 *
 * @param props - props from this instance of MenuTrigger
 */
export declare const useMenuTrigger_unstable: (props: MenuTriggerProps) => MenuTriggerState;

export declare const useMenuTriggerContext_unstable: () => boolean;

/**
 * This hook works similarly to @see useOnClickOutside
 *
 * Problem: Trying to behave the same as system menus:
 * When the mouse leaves a stack of nested menus the stack should not dismiss.
 * However if the mouse leaves a stack of menus and enters a parent menu all its children menu should dismiss.
 *
 * We don't use the native mouseenter event because it would trigger too many times in the document
 * Instead, dispatch custom DOM event from the menu so that it can bubble
 * Each nested menu can use the listener to check if the event is from a child or parent menu
 */
export declare const useOnMenuMouseEnter: (options: UseOnClickOrScrollOutsideOptions) => void;

export { }
