'use client';
import { useControllableState, useEventCallback, useSelection } from '@fluentui/react-utilities';
import * as React from 'react';
export function useListSelection(options = {
    selectionMode: 'multiselect'
}) {
    const { selectionMode, defaultSelectedItems, onSelectionChange } = options;
    const [selectedItems, setSelectedItems] = useControllableState({
        state: options.selectedItems,
        defaultState: defaultSelectedItems,
        initialState: []
    });
    const [selected, selectionMethods] = useSelection({
        selectionMode,
        defaultSelectedItems,
        selectedItems,
        onSelectionChange: (e, data)=>{
            setSelectedItems(data.selectedItems);
            onSelectionChange === null || onSelectionChange === void 0 ? void 0 : onSelectionChange(e, data);
        }
    });
    const toggleItem = useEventCallback((e, itemId)=>selectionMethods.toggleItem(e, itemId));
    const toggleAllItems = useEventCallback((e, itemIds)=>{
        selectionMethods.toggleAllItems(e, itemIds);
    });
    const deselectItem = useEventCallback((e, itemId)=>selectionMethods.deselectItem(e, itemId));
    const selectItem = useEventCallback((e, itemId)=>selectionMethods.selectItem(e, itemId));
    const clearSelection = useEventCallback((e)=>selectionMethods.clearItems(e));
    const selectedArray = React.useMemo(()=>Array.from(selected), [
        selected
    ]);
    return {
        selectedItems: selectedArray,
        toggleItem,
        toggleAllItems,
        deselectItem,
        selectItem,
        setSelectedItems,
        isSelected: (id)=>selectionMethods.isSelected(id),
        clearSelection
    };
}
