'use client';

import { __styles, __resetStyles, mergeClasses } from '@griffel/react';
import { createCustomFocusIndicatorStyle } from '@fluentui/react-tabster';
import { tokens } from '@fluentui/react-theme';
export const listItemClassNames = {
  root: 'fui-ListItem',
  checkmark: 'fui-ListItem__checkmark'
};
const useRootBaseStyles = /*#__PURE__*/__resetStyles("rikgcmv", null, [".rikgcmv{padding:0;margin:0;text-indent:0;list-style-type:none;}", ".rikgcmv[data-fui-focus-visible]{outline:var(--strokeWidthThick) solid var(--colorStrokeFocus2);border-radius:var(--borderRadiusMedium);}"]);
const useCheckmarkBaseStyles = /*#__PURE__*/__styles({
  root: {
    qb2dma: "f7nlbp4",
    Bpb5tq4: 0,
    Biccaaf: 0,
    Gaeyjg: 0,
    ldoezw: 0,
    B6gmeee: "f1bgo3o3"
  }
}, {
  d: [".f7nlbp4{align-self:center;}", [".f1bgo3o3 .fui-Checkbox__indicator{margin:4px;}", {
    p: -1
  }]]
});
/**
 * Styles for the root slot
 */
const useStyles = /*#__PURE__*/__styles({
  rootClickableOrSelectable: {
    mc9l5x: "f22iagw",
    Bceei9c: "f1k6fduh"
  },
  disabled: {
    Bceei9c: "f158kwzp"
  }
}, {
  d: [".f22iagw{display:flex;}", ".f1k6fduh{cursor:pointer;}", ".f158kwzp{cursor:default;}"]
});
/**
 * Apply styling to the ListItem slots based on the state
 */
export const useListItemStyles_unstable = state => {
  'use no memo';

  const rootBaseStyles = useRootBaseStyles();
  const checkmarkBaseStyles = useCheckmarkBaseStyles();
  const styles = useStyles();
  state.root.className = mergeClasses(listItemClassNames.root, rootBaseStyles, (state.selectable || state.navigable) && styles.rootClickableOrSelectable, state.disabled && styles.disabled, state.root.className);
  if (state.checkmark) {
    state.checkmark.className = mergeClasses(listItemClassNames.checkmark, checkmarkBaseStyles.root, state.checkmark.className);
  }
  return state;
};