'use client';
import * as React from 'react';
import { GroupperMoveFocusEvent, MoverMoveFocusEvent, GroupperMoveFocusActions, MoverKeys, useArrowNavigationGroup, useFocusableGroup, useMergedTabsterAttributes_unstable } from '@fluentui/react-tabster';
import { elementContains, getIntrinsicElementProps, mergeCallbacks, slot, useEventCallback, useId, useMergedRefs } from '@fluentui/react-utilities';
import { useListSynchronousContext, useListContext_unstable } from '../List/listContext';
import { Enter, Space, ArrowUp, ArrowDown, ArrowRight, ArrowLeft } from '@fluentui/keyboard-keys';
import { Checkbox } from '@fluentui/react-checkbox';
import { createListItemActionEvent, ListItemActionEventName } from '../../events/ListItemActionEvent';
const DEFAULT_ROOT_EL_TYPE = 'li';
/**
 * Create the state required to render ListItem.
 *
 * The returned state can be modified with hooks such as useListItemStyles_unstable,
 * before being passed to renderListItem_unstable.
 *
 * @param props - props from this instance of ListItem
 * @param ref - reference to root HTMLLIElement | HTMLDivElementof ListItem
 */ export const useListItem_unstable = (props, ref)=>{
    const id = useId('listItem');
    const { value = id, onKeyDown, onClick, tabIndex, role, onAction, disabledSelection } = props;
    const toggleItem = useListContext_unstable((ctx)=>{
        var _ctx_selection;
        return (_ctx_selection = ctx.selection) === null || _ctx_selection === void 0 ? void 0 : _ctx_selection.toggleItem;
    });
    const { navigationMode, listItemRole } = useListSynchronousContext();
    const isSelectionModeEnabled = useListContext_unstable((ctx)=>!!ctx.selection);
    var _useListContext_unstable;
    const isSelected = (_useListContext_unstable = useListContext_unstable((ctx)=>{
        var _ctx_selection;
        return (_ctx_selection = ctx.selection) === null || _ctx_selection === void 0 ? void 0 : _ctx_selection.isSelected(value);
    })) !== null && _useListContext_unstable !== void 0 ? _useListContext_unstable : false;
    const validateListItem = useListContext_unstable((ctx)=>ctx.validateListItem);
    const as = props.as || navigationMode === 'composite' ? 'div' : DEFAULT_ROOT_EL_TYPE;
    const finalListItemRole = role || listItemRole;
    const focusableItems = Boolean(isSelectionModeEnabled || navigationMode || tabIndex === 0);
    const rootRef = React.useRef(null);
    const checkmarkRef = React.useRef(null);
    const handleAction = useEventCallback((event)=>{
        onAction === null || onAction === void 0 ? void 0 : onAction(event, {
            event,
            value,
            type: ListItemActionEventName
        });
        if (event.defaultPrevented) {
            return;
        }
        if (isSelectionModeEnabled && !disabledSelection) {
            toggleItem === null || toggleItem === void 0 ? void 0 : toggleItem(event.detail.originalEvent, value);
        }
    });
    React.useEffect(()=>{
        if (rootRef.current) {
            validateListItem(rootRef.current);
        }
    }, [
        validateListItem
    ]);
    const triggerAction = (e)=>{
        const actionEvent = createListItemActionEvent(e);
        handleAction(actionEvent);
        e.target.dispatchEvent(actionEvent);
    };
    const focusableGroupAttrs = useFocusableGroup({
        ignoreDefaultKeydown: {
            Enter: true
        },
        tabBehavior: 'limited-trap-focus'
    });
    const handleClick = useEventCallback((e)=>{
        onClick === null || onClick === void 0 ? void 0 : onClick(e);
        if (e.defaultPrevented) {
            return;
        }
        const isFromCheckbox = elementContains(checkmarkRef.current, e.target);
        if (isFromCheckbox) {
            return;
        }
        triggerAction(e);
    });
    const handleKeyDown = useEventCallback((e)=>{
        onKeyDown === null || onKeyDown === void 0 ? void 0 : onKeyDown(e);
        if (e.defaultPrevented) {
            return;
        }
        // If the event is fired from an element inside the list item
        if (e.target !== e.currentTarget) {
            if (focusableItems) {
                // If the items are focusable, we need to handle the arrow keys to move focus to them
                switch(e.key){
                    // If it's one of the Arrows defined, jump out of the list item to focus on the ListItem itself
                    // The ArrowLeft will only trigger if the target element is the leftmost, otherwise the
                    // arrowNavigationAttributes handles it and prevents it from bubbling here.
                    case ArrowLeft:
                        e.target.dispatchEvent(new GroupperMoveFocusEvent({
                            action: GroupperMoveFocusActions.Escape
                        }));
                        break;
                    case ArrowDown:
                    case ArrowUp:
                        e.preventDefault();
                        // Press ESC on the original target to get focus to the parent group (List)
                        e.target.dispatchEvent(new GroupperMoveFocusEvent({
                            action: GroupperMoveFocusActions.Escape
                        }));
                        // Now dispatch the original key to move up or down in the list
                        e.currentTarget.dispatchEvent(new MoverMoveFocusEvent({
                            key: MoverKeys[e.key]
                        }));
                }
                return;
            }
            return;
        }
        switch(e.key){
            case Space:
                // we have to prevent default here otherwise the space key will scroll the page
                e.preventDefault();
                // Space always toggles selection (if enabled)
                if (isSelectionModeEnabled) {
                    if (!disabledSelection) {
                        toggleItem === null || toggleItem === void 0 ? void 0 : toggleItem(e, value);
                    }
                } else {
                    triggerAction(e);
                }
                break;
            case Enter:
                triggerAction(e);
                break;
            case ArrowRight:
                if (navigationMode === 'composite') {
                    e.target.dispatchEvent(new GroupperMoveFocusEvent({
                        action: GroupperMoveFocusActions.Enter
                    }));
                }
                break;
        }
    });
    const onCheckboxChange = useEventCallback((e, data)=>{
        if (!isSelectionModeEnabled || e.defaultPrevented) {
            return;
        }
        toggleItem === null || toggleItem === void 0 ? void 0 : toggleItem(e, value);
    });
    const arrowNavigationAttributes = useArrowNavigationGroup({
        axis: 'horizontal'
    });
    const tabsterAttributes = useMergedTabsterAttributes_unstable(focusableItems ? arrowNavigationAttributes : {}, focusableGroupAttrs, props);
    const root = slot.always(getIntrinsicElementProps(as, {
        ref: useMergedRefs(rootRef, ref),
        tabIndex: focusableItems ? 0 : undefined,
        role: finalListItemRole,
        id: String(value),
        ...isSelectionModeEnabled && {
            'aria-selected': isSelected,
            'aria-disabled': disabledSelection && !onAction || undefined
        },
        ...props,
        ...tabsterAttributes,
        onKeyDown: handleKeyDown,
        onClick: isSelectionModeEnabled || onClick || onAction ? handleClick : undefined
    }), {
        elementType: as
    });
    const checkmark = slot.optional(props.checkmark, {
        defaultProps: {
            checked: isSelected,
            tabIndex: -1,
            disabled: disabledSelection
        },
        renderByDefault: isSelectionModeEnabled,
        elementType: Checkbox
    });
    const mergedCheckmarkRef = useMergedRefs(checkmark === null || checkmark === void 0 ? void 0 : checkmark.ref, checkmarkRef);
    if (checkmark) {
        checkmark.onChange = mergeCallbacks(checkmark.onChange, onCheckboxChange);
        checkmark.ref = mergedCheckmarkRef;
    }
    const state = {
        components: {
            root: as,
            checkmark: Checkbox
        },
        root,
        checkmark,
        disabled: disabledSelection && !onAction,
        selectable: isSelectionModeEnabled,
        navigable: focusableItems
    };
    return state;
};
