'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useListSelection", {
    enumerable: true,
    get: function() {
        return useListSelection;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _reactutilities = require("@fluentui/react-utilities");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
function useListSelection(options = {
    selectionMode: 'multiselect'
}) {
    const { selectionMode, defaultSelectedItems, onSelectionChange } = options;
    const [selectedItems, setSelectedItems] = (0, _reactutilities.useControllableState)({
        state: options.selectedItems,
        defaultState: defaultSelectedItems,
        initialState: []
    });
    const [selected, selectionMethods] = (0, _reactutilities.useSelection)({
        selectionMode,
        defaultSelectedItems,
        selectedItems,
        onSelectionChange: (e, data)=>{
            setSelectedItems(data.selectedItems);
            onSelectionChange === null || onSelectionChange === void 0 ? void 0 : onSelectionChange(e, data);
        }
    });
    const toggleItem = (0, _reactutilities.useEventCallback)((e, itemId)=>selectionMethods.toggleItem(e, itemId));
    const toggleAllItems = (0, _reactutilities.useEventCallback)((e, itemIds)=>{
        selectionMethods.toggleAllItems(e, itemIds);
    });
    const deselectItem = (0, _reactutilities.useEventCallback)((e, itemId)=>selectionMethods.deselectItem(e, itemId));
    const selectItem = (0, _reactutilities.useEventCallback)((e, itemId)=>selectionMethods.selectItem(e, itemId));
    const clearSelection = (0, _reactutilities.useEventCallback)((e)=>selectionMethods.clearItems(e));
    const selectedArray = _react.useMemo(()=>Array.from(selected), [
        selected
    ]);
    return {
        selectedItems: selectedArray,
        toggleItem,
        toggleAllItems,
        deselectItem,
        selectItem,
        setSelectedItems,
        isSelected: (id)=>selectionMethods.isSelected(id),
        clearSelection
    };
}
