'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    listItemClassNames: function() {
        return listItemClassNames;
    },
    useListItemStyles_unstable: function() {
        return useListItemStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttabster = require("@fluentui/react-tabster");
const _reacttheme = require("@fluentui/react-theme");
const listItemClassNames = {
    root: 'fui-ListItem',
    checkmark: 'fui-ListItem__checkmark'
};
const useRootBaseStyles = (0, _react.makeResetStyles)({
    padding: 0,
    margin: 0,
    textIndent: 0,
    listStyleType: 'none',
    ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
        outline: `${_reacttheme.tokens.strokeWidthThick} solid ${_reacttheme.tokens.colorStrokeFocus2}`,
        borderRadius: _reacttheme.tokens.borderRadiusMedium
    }, {
        selector: 'focus'
    })
});
const useCheckmarkBaseStyles = (0, _react.makeStyles)({
    root: {
        alignSelf: 'center',
        '& .fui-Checkbox__indicator': {
            margin: '4px'
        }
    }
});
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    rootClickableOrSelectable: {
        display: 'flex',
        cursor: 'pointer'
    },
    disabled: {
        cursor: 'default'
    }
});
const useListItemStyles_unstable = (state)=>{
    'use no memo';
    const rootBaseStyles = useRootBaseStyles();
    const checkmarkBaseStyles = useCheckmarkBaseStyles();
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(listItemClassNames.root, rootBaseStyles, (state.selectable || state.navigable) && styles.rootClickableOrSelectable, state.disabled && styles.disabled, state.root.className);
    if (state.checkmark) {
        state.checkmark.className = (0, _react.mergeClasses)(listItemClassNames.checkmark, checkmarkBaseStyles.root, state.checkmark.className);
    }
    return state;
};
