'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useListItem_unstable", {
    enumerable: true,
    get: function() {
        return useListItem_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reacttabster = require("@fluentui/react-tabster");
const _reactutilities = require("@fluentui/react-utilities");
const _listContext = require("../List/listContext");
const _keyboardkeys = require("@fluentui/keyboard-keys");
const _reactcheckbox = require("@fluentui/react-checkbox");
const _ListItemActionEvent = require("../../events/ListItemActionEvent");
const DEFAULT_ROOT_EL_TYPE = 'li';
const useListItem_unstable = (props, ref)=>{
    const id = (0, _reactutilities.useId)('listItem');
    const { value = id, onKeyDown, onClick, tabIndex, role, onAction, disabledSelection } = props;
    const toggleItem = (0, _listContext.useListContext_unstable)((ctx)=>{
        var _ctx_selection;
        return (_ctx_selection = ctx.selection) === null || _ctx_selection === void 0 ? void 0 : _ctx_selection.toggleItem;
    });
    const { navigationMode, listItemRole } = (0, _listContext.useListSynchronousContext)();
    const isSelectionModeEnabled = (0, _listContext.useListContext_unstable)((ctx)=>!!ctx.selection);
    var _useListContext_unstable;
    const isSelected = (_useListContext_unstable = (0, _listContext.useListContext_unstable)((ctx)=>{
        var _ctx_selection;
        return (_ctx_selection = ctx.selection) === null || _ctx_selection === void 0 ? void 0 : _ctx_selection.isSelected(value);
    })) !== null && _useListContext_unstable !== void 0 ? _useListContext_unstable : false;
    const validateListItem = (0, _listContext.useListContext_unstable)((ctx)=>ctx.validateListItem);
    const as = props.as || navigationMode === 'composite' ? 'div' : DEFAULT_ROOT_EL_TYPE;
    const finalListItemRole = role || listItemRole;
    const focusableItems = Boolean(isSelectionModeEnabled || navigationMode || tabIndex === 0);
    const rootRef = _react.useRef(null);
    const checkmarkRef = _react.useRef(null);
    const handleAction = (0, _reactutilities.useEventCallback)((event)=>{
        onAction === null || onAction === void 0 ? void 0 : onAction(event, {
            event,
            value,
            type: _ListItemActionEvent.ListItemActionEventName
        });
        if (event.defaultPrevented) {
            return;
        }
        if (isSelectionModeEnabled && !disabledSelection) {
            toggleItem === null || toggleItem === void 0 ? void 0 : toggleItem(event.detail.originalEvent, value);
        }
    });
    _react.useEffect(()=>{
        if (rootRef.current) {
            validateListItem(rootRef.current);
        }
    }, [
        validateListItem
    ]);
    const triggerAction = (e)=>{
        const actionEvent = (0, _ListItemActionEvent.createListItemActionEvent)(e);
        handleAction(actionEvent);
        e.target.dispatchEvent(actionEvent);
    };
    const focusableGroupAttrs = (0, _reacttabster.useFocusableGroup)({
        ignoreDefaultKeydown: {
            Enter: true
        },
        tabBehavior: 'limited-trap-focus'
    });
    const handleClick = (0, _reactutilities.useEventCallback)((e)=>{
        onClick === null || onClick === void 0 ? void 0 : onClick(e);
        if (e.defaultPrevented) {
            return;
        }
        const isFromCheckbox = (0, _reactutilities.elementContains)(checkmarkRef.current, e.target);
        if (isFromCheckbox) {
            return;
        }
        triggerAction(e);
    });
    const handleKeyDown = (0, _reactutilities.useEventCallback)((e)=>{
        onKeyDown === null || onKeyDown === void 0 ? void 0 : onKeyDown(e);
        if (e.defaultPrevented) {
            return;
        }
        // If the event is fired from an element inside the list item
        if (e.target !== e.currentTarget) {
            if (focusableItems) {
                // If the items are focusable, we need to handle the arrow keys to move focus to them
                switch(e.key){
                    // If it's one of the Arrows defined, jump out of the list item to focus on the ListItem itself
                    // The ArrowLeft will only trigger if the target element is the leftmost, otherwise the
                    // arrowNavigationAttributes handles it and prevents it from bubbling here.
                    case _keyboardkeys.ArrowLeft:
                        e.target.dispatchEvent(new _reacttabster.GroupperMoveFocusEvent({
                            action: _reacttabster.GroupperMoveFocusActions.Escape
                        }));
                        break;
                    case _keyboardkeys.ArrowDown:
                    case _keyboardkeys.ArrowUp:
                        e.preventDefault();
                        // Press ESC on the original target to get focus to the parent group (List)
                        e.target.dispatchEvent(new _reacttabster.GroupperMoveFocusEvent({
                            action: _reacttabster.GroupperMoveFocusActions.Escape
                        }));
                        // Now dispatch the original key to move up or down in the list
                        e.currentTarget.dispatchEvent(new _reacttabster.MoverMoveFocusEvent({
                            key: _reacttabster.MoverKeys[e.key]
                        }));
                }
                return;
            }
            return;
        }
        switch(e.key){
            case _keyboardkeys.Space:
                // we have to prevent default here otherwise the space key will scroll the page
                e.preventDefault();
                // Space always toggles selection (if enabled)
                if (isSelectionModeEnabled) {
                    if (!disabledSelection) {
                        toggleItem === null || toggleItem === void 0 ? void 0 : toggleItem(e, value);
                    }
                } else {
                    triggerAction(e);
                }
                break;
            case _keyboardkeys.Enter:
                triggerAction(e);
                break;
            case _keyboardkeys.ArrowRight:
                if (navigationMode === 'composite') {
                    e.target.dispatchEvent(new _reacttabster.GroupperMoveFocusEvent({
                        action: _reacttabster.GroupperMoveFocusActions.Enter
                    }));
                }
                break;
        }
    });
    const onCheckboxChange = (0, _reactutilities.useEventCallback)((e, data)=>{
        if (!isSelectionModeEnabled || e.defaultPrevented) {
            return;
        }
        toggleItem === null || toggleItem === void 0 ? void 0 : toggleItem(e, value);
    });
    const arrowNavigationAttributes = (0, _reacttabster.useArrowNavigationGroup)({
        axis: 'horizontal'
    });
    const tabsterAttributes = (0, _reacttabster.useMergedTabsterAttributes_unstable)(focusableItems ? arrowNavigationAttributes : {}, focusableGroupAttrs, props);
    const root = _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)(as, {
        ref: (0, _reactutilities.useMergedRefs)(rootRef, ref),
        tabIndex: focusableItems ? 0 : undefined,
        role: finalListItemRole,
        id: String(value),
        ...isSelectionModeEnabled && {
            'aria-selected': isSelected,
            'aria-disabled': disabledSelection && !onAction || undefined
        },
        ...props,
        ...tabsterAttributes,
        onKeyDown: handleKeyDown,
        onClick: isSelectionModeEnabled || onClick || onAction ? handleClick : undefined
    }), {
        elementType: as
    });
    const checkmark = _reactutilities.slot.optional(props.checkmark, {
        defaultProps: {
            checked: isSelected,
            tabIndex: -1,
            disabled: disabledSelection
        },
        renderByDefault: isSelectionModeEnabled,
        elementType: _reactcheckbox.Checkbox
    });
    const mergedCheckmarkRef = (0, _reactutilities.useMergedRefs)(checkmark === null || checkmark === void 0 ? void 0 : checkmark.ref, checkmarkRef);
    if (checkmark) {
        checkmark.onChange = (0, _reactutilities.mergeCallbacks)(checkmark.onChange, onCheckboxChange);
        checkmark.ref = mergedCheckmarkRef;
    }
    const state = {
        components: {
            root: as,
            checkmark: _reactcheckbox.Checkbox
        },
        root,
        checkmark,
        disabled: disabledSelection && !onAction,
        selectable: isSelectionModeEnabled,
        navigable: focusableItems
    };
    return state;
};
