'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    ListContextProvider: function() {
        return ListContextProvider;
    },
    ListSynchronousContextProvider: function() {
        return ListSynchronousContextProvider;
    },
    listContextDefaultValue: function() {
        return listContextDefaultValue;
    },
    useListContext_unstable: function() {
        return useListContext_unstable;
    },
    useListSynchronousContext: function() {
        return useListSynchronousContext;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _reactcontextselector = require("@fluentui/react-context-selector");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const listContextDefaultValue = {
    selection: undefined,
    validateListItem: ()=>{
    /* noop */ }
};
const listContext = (0, _reactcontextselector.createContext)(undefined);
const ListContextProvider = listContext.Provider;
const useListContext_unstable = (selector)=>(0, _reactcontextselector.useContextSelector)(listContext, (ctx = listContextDefaultValue)=>selector(ctx));
// This is a context that uses the standard, React Context API.
// The reason why this exists is that the Fluent UI Context Provider replaces the
// React Context Provider with a custom one that needs a layout effect to update the context value.
// This results in issues with element/role validation, as the ListItem component has not been updated yet
// when the validation happens.
// https://github.com/microsoft/fluentui/issues/34467
const ListSynchronousContext = /*#__PURE__*/ _react.createContext(undefined);
const ListSynchronousContextProvider = ListSynchronousContext.Provider;
const useListSynchronousContext = ()=>_react.useContext(ListSynchronousContext) || {
        navigationMode: undefined,
        listItemRole: 'listitem'
    };
