import { Checkbox } from '@fluentui/react-checkbox';
import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { EventData } from '@fluentui/react-utilities';
import type { EventHandler } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import * as React_2 from 'react';
import { SelectionItemId } from '@fluentui/react-utilities';
import type { SelectionMode as SelectionMode_2 } from '@fluentui/react-utilities';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

export declare const List: ForwardRefComponent<ListProps>;

export declare const listClassNames: SlotClassNames<ListSlots>;

declare type ListContextValue = {
    selection?: ListSelectionState;
    validateListItem: (listItemElement: HTMLElement) => void;
};

declare type ListContextValues = {
    listContext: ListContextValue;
    synchronousContext: ListSynchronousContextValue;
};

export declare const ListItem: ForwardRefComponent<ListItemProps>;

declare type ListItemActionEvent = CustomEvent<ListItemActionEventDetail>;

declare type ListItemActionEventData = EventData<typeof ListItemActionEventName, ListItemActionEvent> & {
    value: ListItemValue;
};

declare interface ListItemActionEventDetail {
    originalEvent: React_2.MouseEvent | React_2.KeyboardEvent;
}

declare const ListItemActionEventName = "ListItemAction";

export declare const listItemClassNames: SlotClassNames<ListItemSlots>;

/**
 * ListItem Props
 */
export declare type ListItemProps = ComponentProps<ListItemSlots> & {
    value?: ListItemValue;
    onAction?: EventHandler<ListItemActionEventData>;
    disabledSelection?: boolean;
};

export declare type ListItemSlots = {
    root: NonNullable<Slot<'li', 'div'>>;
    checkmark?: Slot<typeof Checkbox>;
};

/**
 * State used in rendering ListItem
 */
export declare type ListItemState = ComponentState<ListItemSlots> & {
    selectable: boolean;
    navigable: boolean;
    disabled?: boolean;
};

declare type ListItemValue = string | number;

declare type ListNavigationMode = 'items' | 'composite';

/**
 * List Props
 */
export declare type ListProps = ComponentProps<ListSlots> & {
    navigationMode?: ListNavigationMode;
    selectionMode?: SelectionMode_2;
    selectedItems?: SelectionItemId[];
    defaultSelectedItems?: SelectionItemId[];
    onSelectionChange?: EventHandler<OnListSelectionChangeData>;
};

declare type ListSelectionState = {
    isSelected: (item: string | number) => boolean;
    toggleItem: (e: React_2.SyntheticEvent, id: string | number) => void;
    deselectItem: (e: React_2.SyntheticEvent, id: string | number) => void;
    selectItem: (e: React_2.SyntheticEvent, id: string | number) => void;
    clearSelection: (e: React_2.SyntheticEvent) => void;
    toggleAllItems: (e: React_2.SyntheticEvent, itemIds: string[] | number[]) => void;
    setSelectedItems: React_2.Dispatch<React_2.SetStateAction<Iterable<SelectionItemId>>>;
    selectedItems: SelectionItemId[];
};

export declare type ListSlots = {
    root: NonNullable<Slot<'ul', 'div' | 'ol'>>;
};

/**
 * State used in rendering List
 */
export declare type ListState = ComponentState<ListSlots> & ListContextValue & ListSynchronousContextValue;

declare type ListSynchronousContextValue = {
    navigationMode: ListNavigationMode | undefined;
    listItemRole: string;
};

declare type OnListSelectionChangeData = EventData<'change', React_2.SyntheticEvent> & {
    selectedItems: SelectionItemId[];
};

/**
 * Render the final JSX of List
 */
export declare const renderList_unstable: (state: ListState, contextValues: ListContextValues) => JSXElement;

/**
 * Render the final JSX of ListItem
 */
export declare const renderListItem_unstable: (state: ListItemState) => JSXElement;

/**
 * Create the state required to render List.
 *
 * The returned state can be modified with hooks such as useListStyles_unstable,
 * before being passed to renderList_unstable.
 *
 * @param props - props from this instance of List
 * @param ref - reference to root HTMLElement of List
 */
export declare const useList_unstable: (props: ListProps, ref: React_2.Ref<HTMLDivElement | HTMLUListElement | HTMLOListElement>) => ListState;

/**
 * Create the state required to render ListItem.
 *
 * The returned state can be modified with hooks such as useListItemStyles_unstable,
 * before being passed to renderListItem_unstable.
 *
 * @param props - props from this instance of ListItem
 * @param ref - reference to root HTMLLIElement | HTMLDivElementof ListItem
 */
export declare const useListItem_unstable: (props: ListItemProps, ref: React_2.Ref<HTMLLIElement | HTMLDivElement>) => ListItemState;

/**
 * Apply styling to the ListItem slots based on the state
 */
export declare const useListItemStyles_unstable: (state: ListItemState) => ListItemState;

/**
 * Apply styling to the List slots based on the state
 */
export declare const useListStyles_unstable: (state: ListState) => ListState;

export { }
