'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    linkClassNames: function() {
        return linkClassNames;
    },
    useLinkStyles_unstable: function() {
        return useLinkStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttabster = require("@fluentui/react-tabster");
const _reacttheme = require("@fluentui/react-theme");
const linkClassNames = {
    root: 'fui-Link'
};
const useStyles = (0, _react.makeStyles)({
    focusIndicator: (0, _reacttabster.createCustomFocusIndicatorStyle)({
        textDecorationColor: _reacttheme.tokens.colorStrokeFocus2,
        textDecorationLine: 'underline',
        textDecorationStyle: 'double',
        outlineStyle: 'none'
    }),
    // Common styles.
    root: {
        ':focus-visible': {
            outlineStyle: 'none'
        },
        backgroundColor: 'transparent',
        boxSizing: 'border-box',
        color: _reacttheme.tokens.colorBrandForegroundLink,
        cursor: 'pointer',
        display: 'inline',
        fontFamily: _reacttheme.tokens.fontFamilyBase,
        fontSize: _reacttheme.tokens.fontSizeBase300,
        fontWeight: _reacttheme.tokens.fontWeightRegular,
        margin: '0',
        padding: '0',
        overflow: 'inherit',
        textAlign: 'left',
        textDecorationLine: 'none',
        textDecorationThickness: _reacttheme.tokens.strokeWidthThin,
        textOverflow: 'inherit',
        userSelect: 'text',
        ':hover': {
            textDecorationLine: 'underline',
            color: _reacttheme.tokens.colorBrandForegroundLinkHover
        },
        ':active': {
            textDecorationLine: 'underline',
            color: _reacttheme.tokens.colorBrandForegroundLinkPressed
        }
    },
    // Overrides when the Link renders as a button.
    button: {
        ..._react.shorthands.borderStyle('none')
    },
    // Overrides when an href is present so the Link renders as an anchor.
    href: {
        fontSize: 'inherit'
    },
    // Overrides when the Link appears subtle.
    subtle: {
        color: _reacttheme.tokens.colorNeutralForeground2,
        ':hover': {
            textDecorationLine: 'underline',
            color: _reacttheme.tokens.colorNeutralForeground2Hover
        },
        ':active': {
            textDecorationLine: 'underline',
            color: _reacttheme.tokens.colorNeutralForeground2Pressed
        }
    },
    // Overrides when the Link is rendered inline within text.
    inline: {
        textDecorationLine: 'underline'
    },
    // Overrides when the Link is disabled.
    disabled: {
        textDecorationLine: 'none',
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        cursor: 'not-allowed',
        ':hover': {
            textDecorationLine: 'none',
            color: _reacttheme.tokens.colorNeutralForegroundDisabled
        },
        ':active': {
            textDecorationLine: 'none',
            color: _reacttheme.tokens.colorNeutralForegroundDisabled
        }
    },
    inverted: {
        color: _reacttheme.tokens.colorNeutralForegroundInvertedLink,
        ':hover': {
            color: _reacttheme.tokens.colorNeutralForegroundInvertedLinkHover
        },
        ':active': {
            color: _reacttheme.tokens.colorNeutralForegroundInvertedLinkPressed
        }
    }
});
const useLinkStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const { appearance, disabled, inline, root, backgroundAppearance } = state;
    state.root.className = (0, _react.mergeClasses)(linkClassNames.root, styles.root, styles.focusIndicator, root.as === 'a' && root.href && styles.href, root.as === 'button' && styles.button, appearance === 'subtle' && styles.subtle, backgroundAppearance === 'inverted' && styles.inverted, inline && styles.inline, disabled && styles.disabled, state.root.className);
    return state;
};
