"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useLinkState_unstable", {
    enumerable: true,
    get: function() {
        return useLinkState_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _keyboardkeys = require("@fluentui/keyboard-keys");
const useLinkState_unstable = (state)=>{
    const { disabled, disabledFocusable } = state;
    const { onClick, onKeyDown, role, tabIndex } = state.root;
    // Add href for anchor elements.
    if (state.root.as === 'a') {
        state.root.href = disabled ? undefined : state.root.href;
        // Add role="link" for disabled and disabledFocusable links.
        if (disabled || disabledFocusable) {
            state.root.role = role || 'link';
        }
    }
    // Add tabIndex=0 for anchor and span elements.
    if (state.root.as === 'a' || state.root.as === 'span') {
        state.root.tabIndex = tabIndex !== null && tabIndex !== void 0 ? tabIndex : disabled && !disabledFocusable ? undefined : 0;
    }
    // Disallow click event when component is disabled and eat events when disabledFocusable is set to true.
    state.root.onClick = (ev)=>{
        if (disabled || disabledFocusable) {
            ev.preventDefault();
        } else {
            onClick === null || onClick === void 0 ? void 0 : onClick(ev);
        }
    };
    // Disallow keydown event when component is disabled and eat events when disabledFocusable is set to true.
    state.root.onKeyDown = (ev)=>{
        const keyPressed = ev.key === _keyboardkeys.Enter || ev.key === _keyboardkeys.Space;
        if ((disabled || disabledFocusable) && keyPressed) {
            ev.preventDefault();
            ev.stopPropagation();
        } else {
            onKeyDown === null || onKeyDown === void 0 ? void 0 : onKeyDown(ev);
            // if there is already onKeyDown provided - respect it
            if (state.root.as === 'span' && !!state.root.onClick && !onKeyDown && keyPressed) {
                ev.preventDefault();
                ev.currentTarget.click();
            }
        }
    };
    // Set the aria-disabled and disabled props correctly.
    state.disabled = disabled || disabledFocusable;
    state.root['aria-disabled'] = disabled || disabledFocusable || undefined;
    if (state.root.as === 'button') {
        state.root.disabled = disabled && !disabledFocusable;
    }
    return state;
};
