'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useLink_unstable", {
    enumerable: true,
    get: function() {
        return useLink_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _useLinkState = require("./useLinkState");
const _linkContext = require("../../contexts/linkContext");
const useLink_unstable = (props, ref)=>{
    const backgroundAppearance = (0, _reactsharedcontexts.useBackgroundAppearance)();
    const { inline: inlineContext } = (0, _linkContext.useLinkContext)();
    const { appearance = 'default', disabled = false, disabledFocusable = false, inline = false } = props;
    const elementType = props.as || (props.href ? 'a' : 'button');
    // Casting is required here as `as` prop would break the union between `a`, `button` and `span` types
    const propsWithAssignedAs = {
        role: elementType === 'span' ? 'button' : undefined,
        type: elementType === 'button' ? 'button' : undefined,
        ...props,
        as: elementType
    };
    const state = {
        // Props passed at the top-level
        appearance,
        disabled,
        disabledFocusable,
        inline: inline !== null && inline !== void 0 ? inline : !!inlineContext,
        // Slots definition
        components: {
            root: elementType
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)(elementType, {
            ref,
            ...propsWithAssignedAs
        }), {
            elementType
        }),
        backgroundAppearance
    };
    (0, _useLinkState.useLinkState_unstable)(state);
    return state;
};
