import { BackgroundAppearanceContextValue } from '@fluentui/react-shared-contexts';
import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

/**
 * A Link is a reference to data that a user can follow by clicking or tapping it.
 */
export declare const Link: ForwardRefComponent<LinkProps>;

export declare const linkClassNames: SlotClassNames<LinkSlots>;

export declare const linkContextDefaultValue: LinkContextValue;

export declare const LinkContextProvider: React_2.Provider<LinkContextValue | undefined>;

export declare type LinkContextValue = {
    inline?: boolean;
};

export declare type LinkProps = ComponentProps<LinkSlots> & {
    /**
     * A link can appear either with its default style or subtle.
     * If not specified, the link appears with its default styling.
     * @default 'default'
     */
    appearance?: 'default' | 'subtle';
    /**
     * Whether the link is disabled.
     * @default false
     */
    disabled?: boolean;
    /**
     * When set, allows the link to be focusable even when it has been disabled. This is used in scenarios where it is
     * important to keep a consistent tab order for screen reader and keyboard users.
     * @default false
     */
    disabledFocusable?: boolean;
    /**
     * If true, changes styling when the link is being used alongside other text content.
     * @default false
     */
    inline?: boolean;
};

export declare type LinkSlots = {
    /**
     * Root of the component that renders as either an <a> or a <button> tag.
     */
    root: Slot<'a', 'button' | 'span'>;
};

export declare type LinkState = ComponentState<LinkSlots> & Required<Pick<LinkProps, 'appearance' | 'disabled' | 'disabledFocusable' | 'inline'>> & {
    backgroundAppearance?: BackgroundAppearanceContextValue;
};

/**
 * Renders a Link component by passing the state defined props to the appropriate slots.
 */
export declare const renderLink_unstable: (state: LinkState) => JSXElement;

/**
 * Given user props, defines default props for the Link, calls useLinkState_unstable, and returns processed state.
 * @param props - User provided props to the Link component.
 * @param ref - User provided ref to be passed to the Link component.
 */
export declare const useLink_unstable: (props: LinkProps, ref: React_2.Ref<HTMLAnchorElement | HTMLButtonElement | HTMLSpanElement>) => LinkState;

export declare const useLinkContext: () => LinkContextValue;

/**
 * The useLinkState_unstable hook processes the Link state.
 * @param state - Link state to mutate.
 */
export declare const useLinkState_unstable: (state: LinkState) => LinkState;

export declare const useLinkStyles_unstable: (state: LinkState) => LinkState;

export { }
