'use client';
import * as React from 'react';
import { useLabel_unstable } from './useLabel';
import { renderLabel_unstable } from './renderLabel';
import { useLabelStyles_unstable } from './useLabelStyles.styles';
import { useCustomStyleHook_unstable } from '@fluentui/react-shared-contexts';
/**
 * A label component provides a title or name to a component.
 */ export const Label = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const state = useLabel_unstable(props, ref);
    useLabelStyles_unstable(state);
    useCustomStyleHook_unstable('useLabelStyles_unstable')(state);
    return renderLabel_unstable(state);
});
Label.displayName = 'Label';
