'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    labelClassNames: function() {
        return labelClassNames;
    },
    useLabelStyles_unstable: function() {
        return useLabelStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const labelClassNames = {
    root: 'fui-Label',
    required: 'fui-Label__required'
};
/**
 * Styles for the label
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        fontFamily: _reacttheme.tokens.fontFamilyBase,
        color: _reacttheme.tokens.colorNeutralForeground1
    },
    disabled: {
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        '@media (forced-colors: active)': {
            color: 'GrayText'
        }
    },
    required: {
        color: _reacttheme.tokens.colorPaletteRedForeground3,
        paddingLeft: _reacttheme.tokens.spacingHorizontalXS
    },
    small: {
        fontSize: _reacttheme.tokens.fontSizeBase200,
        lineHeight: _reacttheme.tokens.lineHeightBase200
    },
    medium: {
        fontSize: _reacttheme.tokens.fontSizeBase300,
        lineHeight: _reacttheme.tokens.lineHeightBase300
    },
    large: {
        fontSize: _reacttheme.tokens.fontSizeBase400,
        lineHeight: _reacttheme.tokens.lineHeightBase400,
        fontWeight: _reacttheme.tokens.fontWeightSemibold
    },
    semibold: {
        fontWeight: _reacttheme.tokens.fontWeightSemibold
    }
});
const useLabelStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(labelClassNames.root, styles.root, state.disabled && styles.disabled, styles[state.size], state.weight === 'semibold' && styles.semibold, state.root.className);
    if (state.required) {
        state.required.className = (0, _react.mergeClasses)(labelClassNames.required, styles.required, state.disabled && styles.disabled, state.required.className);
    }
    return state;
};
