import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

/**
 * A label component provides a title or name to a component.
 */
export declare const Label: ForwardRefComponent<LabelProps>;

export declare const labelClassNames: SlotClassNames<LabelSlots>;

/**
 * Label Props
 */
export declare type LabelProps = Omit<ComponentProps<LabelSlots>, 'required'> & {
    /**
     * Renders the label as disabled
     * @default false
     */
    disabled?: boolean;
    /**
     * Displays an indicator that the label is for a required field. The required prop can be set to true to display
     * an asterisk (*). Or it can be set to a string or jsx content to display a different indicator.
     * @default false
     */
    required?: boolean | Slot<'span'>;
    /**
     * A label supports different sizes.
     * @default 'medium'
     */
    size?: 'small' | 'medium' | 'large';
    /**
     * A label supports regular and semibold fontweight.
     * @default regular
     */
    weight?: 'regular' | 'semibold';
};

export declare type LabelSlots = {
    root: Slot<'label'>;
    required?: Slot<'span'>;
};

/**
 * State used in rendering Label
 */
export declare type LabelState = ComponentState<LabelSlots> & Required<Pick<LabelProps, 'disabled' | 'size' | 'weight'>>;

/**
 * Render the final JSX of Label
 */
export declare const renderLabel_unstable: (state: LabelState) => JSXElement;

/**
 * Create the state required to render Label.
 *
 * The returned state can be modified with hooks such as useLabelStyles_unstable,
 * before being passed to renderLabel_unstable.
 *
 * @param props - props from this instance of Label
 * @param ref - reference to root HTMLElement of Label
 */
export declare const useLabel_unstable: (props: LabelProps, ref: React_2.Ref<HTMLElement>) => LabelState;

/**
 * Apply styling to the Label slots based on the state
 */
export declare const useLabelStyles_unstable: (state: LabelState) => LabelState;

export { }
