"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createElementFromSlotComponent", {
    enumerable: true,
    get: function() {
        return createElementFromSlotComponent;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _getMetadataFromSlotComponent = require("../utils/getMetadataFromSlotComponent");
function createElementFromSlotComponent(type, overrideChildren) {
    const { elementType, renderFunction, props } = (0, _getMetadataFromSlotComponent.getMetadataFromSlotComponent)(type);
    if (renderFunction) {
        if (overrideChildren.length > 0) {
            props.children = _react.createElement(_react.Fragment, {}, ...overrideChildren);
        }
        return _react.createElement(_react.Fragment, {}, renderFunction(elementType, props));
    }
    return _react.createElement(elementType, props, ...overrideChildren);
}
