'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    inputClassNames: function() {
        return inputClassNames;
    },
    useInputStyles_unstable: function() {
        return useInputStyles_unstable;
    }
});
const _reacttheme = require("@fluentui/react-theme");
const _react = require("@griffel/react");
const inputClassNames = {
    root: 'fui-Input',
    input: 'fui-Input__input',
    contentBefore: 'fui-Input__contentBefore',
    contentAfter: 'fui-Input__contentAfter'
};
// TODO(sharing) should these be shared somewhere?
const fieldHeights = {
    small: '24px',
    medium: '32px',
    large: '40px'
};
// With no contentBefore or contentAfter, the input slot uses combined padding to increase its hit target.
// If there is contentBefore or contentAfter, then the root and input slots use their individual padding.
const horizontalPadding = {
    root: {
        small: _reacttheme.tokens.spacingHorizontalSNudge,
        medium: _reacttheme.tokens.spacingHorizontalMNudge,
        large: _reacttheme.tokens.spacingHorizontalM
    },
    input: {
        small: _reacttheme.tokens.spacingHorizontalXXS,
        medium: _reacttheme.tokens.spacingHorizontalXXS,
        large: _reacttheme.tokens.spacingHorizontalSNudge
    },
    combined: {
        small: _reacttheme.tokens.spacingHorizontalS,
        medium: _reacttheme.tokens.spacingHorizontalM,
        large: `calc(${_reacttheme.tokens.spacingHorizontalM} + ${_reacttheme.tokens.spacingHorizontalSNudge})`
    }
};
const useRootClassName = (0, _react.makeResetStyles)({
    display: 'inline-flex',
    alignItems: 'center',
    flexWrap: 'nowrap',
    gap: _reacttheme.tokens.spacingHorizontalXXS,
    borderRadius: _reacttheme.tokens.borderRadiusMedium,
    position: 'relative',
    boxSizing: 'border-box',
    verticalAlign: 'middle',
    // size: medium (default)
    minHeight: fieldHeights.medium,
    ..._reacttheme.typographyStyles.body1,
    // appearance: outline (default)
    backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
    border: `1px solid ${_reacttheme.tokens.colorNeutralStroke1}`,
    borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessible,
    // This is all for the bottom focus border.
    // It's supposed to be 2px flat all the way across and match the radius of the field's corners.
    '::after': {
        boxSizing: 'border-box',
        content: '""',
        position: 'absolute',
        left: '-1px',
        bottom: '-1px',
        right: '-1px',
        // Maintaining the correct corner radius:
        // Use the whole border-radius as the height and only put radii on the bottom corners.
        // (Otherwise the radius would be automatically reduced to fit available space.)
        // max() ensures the focus border still shows up even if someone sets tokens.borderRadiusMedium to 0.
        height: `max(2px, ${_reacttheme.tokens.borderRadiusMedium})`,
        borderBottomLeftRadius: _reacttheme.tokens.borderRadiusMedium,
        borderBottomRightRadius: _reacttheme.tokens.borderRadiusMedium,
        // Flat 2px border:
        // By default borderBottom will cause little "horns" on the ends. The clipPath trims them off.
        // (This could be done without trimming using `background: linear-gradient(...)`, but using
        // borderBottom makes it easier for people to override the color if needed.)
        borderBottom: `2px solid ${_reacttheme.tokens.colorCompoundBrandStroke}`,
        clipPath: 'inset(calc(100% - 2px) 0 0 0)',
        // Animation for focus OUT
        transform: 'scaleX(0)',
        transitionProperty: 'transform',
        transitionDuration: _reacttheme.tokens.durationUltraFast,
        transitionDelay: _reacttheme.tokens.curveAccelerateMid,
        '@media screen and (prefers-reduced-motion: reduce)': {
            transitionDuration: '0.01ms',
            transitionDelay: '0.01ms'
        }
    },
    ':focus-within::after': {
        // Animation for focus IN
        transform: 'scaleX(1)',
        transitionProperty: 'transform',
        transitionDuration: _reacttheme.tokens.durationNormal,
        transitionDelay: _reacttheme.tokens.curveDecelerateMid,
        '@media screen and (prefers-reduced-motion: reduce)': {
            transitionDuration: '0.01ms',
            transitionDelay: '0.01ms'
        }
    },
    ':focus-within:active::after': {
        // This is if the user clicks the field again while it's already focused
        borderBottomColor: _reacttheme.tokens.colorCompoundBrandStrokePressed
    },
    ':focus-within': {
        outline: '2px solid transparent'
    }
});
const useRootStyles = (0, _react.makeStyles)({
    small: {
        minHeight: fieldHeights.small,
        ..._reacttheme.typographyStyles.caption1
    },
    medium: {},
    large: {
        minHeight: fieldHeights.large,
        ..._reacttheme.typographyStyles.body2,
        gap: _reacttheme.tokens.spacingHorizontalSNudge
    },
    outline: {},
    outlineInteractive: {
        ':hover': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Hover),
            borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessibleHover
        },
        // DO NOT add a space between the selectors! It changes the behavior of make-styles.
        ':active,:focus-within': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Pressed),
            borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessiblePressed
        }
    },
    underline: {
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        borderRadius: '0',
        // border is specified in rootBaseStyles, but we only want a bottom border here
        borderTopStyle: 'none',
        borderRightStyle: 'none',
        borderLeftStyle: 'none',
        // Make the focus underline (::after) match the width of the bottom border
        '::after': {
            left: 0,
            right: 0
        }
    },
    underlineInteractive: {
        ':hover': {
            borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessibleHover
        },
        // DO NOT add a space between the selectors! It changes the behavior of make-styles.
        ':active,:focus-within': {
            borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessiblePressed
        },
        '::after': {
            // remove rounded corners from focus underline
            borderRadius: '0'
        }
    },
    filled: {
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorTransparentStroke)
    },
    filledInteractive: {
        // DO NOT add a space between the selectors! It changes the behavior of make-styles.
        ':hover,:focus-within': {
            // also handles pressed border color (:active)
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorTransparentStrokeInteractive)
        }
    },
    invalid: {
        ':not(:focus-within),:hover:not(:focus-within)': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorPaletteRedBorder2)
        }
    },
    'filled-darker': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground3
    },
    'filled-lighter': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1
    },
    // This shadow appearance is deprecated and will be removed in a future release.
    'filled-darker-shadow': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground3,
        boxShadow: _reacttheme.tokens.shadow2
    },
    // This shadow appearance is deprecated and will be removed in a future release.
    'filled-lighter-shadow': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        boxShadow: _reacttheme.tokens.shadow2
    },
    disabled: {
        cursor: 'not-allowed',
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStrokeDisabled),
        '@media (forced-colors: active)': {
            ..._react.shorthands.borderColor('GrayText')
        },
        // remove the focus border
        '::after': {
            content: 'unset'
        },
        // remove the focus outline
        ':focus-within': {
            outlineStyle: 'none'
        }
    },
    smallWithContentBefore: {
        paddingLeft: horizontalPadding.root.small
    },
    smallWithContentAfter: {
        paddingRight: horizontalPadding.root.small
    },
    mediumWithContentBefore: {
        paddingLeft: horizontalPadding.root.medium
    },
    mediumWithContentAfter: {
        paddingRight: horizontalPadding.root.medium
    },
    largeWithContentBefore: {
        paddingLeft: horizontalPadding.root.large
    },
    largeWithContentAfter: {
        paddingRight: horizontalPadding.root.large
    }
});
const useInputClassName = (0, _react.makeResetStyles)({
    alignSelf: 'stretch',
    boxSizing: 'border-box',
    flexGrow: 1,
    minWidth: 0,
    borderStyle: 'none',
    padding: `0 ${horizontalPadding.combined.medium}`,
    color: _reacttheme.tokens.colorNeutralForeground1,
    // Use literal "transparent" (not from the theme) to always let the color from the root show through
    backgroundColor: 'transparent',
    '::placeholder': {
        color: _reacttheme.tokens.colorNeutralForeground4,
        opacity: 1
    },
    outlineStyle: 'none',
    // Inherit typography styles from root
    fontFamily: 'inherit',
    fontSize: 'inherit',
    fontWeight: 'inherit',
    lineHeight: 'inherit'
});
const useInputElementStyles = (0, _react.makeStyles)({
    small: {
        paddingLeft: horizontalPadding.combined.small,
        paddingRight: horizontalPadding.combined.small
    },
    medium: {},
    large: {
        paddingLeft: horizontalPadding.combined.large,
        paddingRight: horizontalPadding.combined.large
    },
    smallWithContentBefore: {
        paddingLeft: horizontalPadding.input.small
    },
    smallWithContentAfter: {
        paddingRight: horizontalPadding.input.small
    },
    mediumWithContentBefore: {
        paddingLeft: horizontalPadding.input.medium
    },
    mediumWithContentAfter: {
        paddingRight: horizontalPadding.input.medium
    },
    largeWithContentBefore: {
        paddingLeft: horizontalPadding.input.large
    },
    largeWithContentAfter: {
        paddingRight: horizontalPadding.input.large
    },
    disabled: {
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        cursor: 'not-allowed',
        '::placeholder': {
            color: _reacttheme.tokens.colorNeutralForegroundDisabled
        }
    }
});
const useContentClassName = (0, _react.makeResetStyles)({
    boxSizing: 'border-box',
    color: _reacttheme.tokens.colorNeutralForeground3,
    display: 'flex',
    // special case styling for icons (most common case) to ensure they're centered vertically
    // size: medium (default)
    '> svg': {
        fontSize: '20px'
    }
});
const useContentStyles = (0, _react.makeStyles)({
    disabled: {
        color: _reacttheme.tokens.colorNeutralForegroundDisabled
    },
    // Ensure resizable icons show up with the proper font size
    small: {
        '> svg': {
            fontSize: '16px'
        }
    },
    medium: {},
    large: {
        '> svg': {
            fontSize: '24px'
        }
    }
});
const useInputStyles_unstable = (state)=>{
    'use no memo';
    const { size, appearance } = state;
    const disabled = state.input.disabled;
    const invalid = `${state.input['aria-invalid']}` === 'true';
    const filled = appearance.startsWith('filled');
    const rootStyles = useRootStyles();
    const inputStyles = useInputElementStyles();
    const contentStyles = useContentStyles();
    state.root.className = (0, _react.mergeClasses)(inputClassNames.root, useRootClassName(), rootStyles[size], state.contentBefore && rootStyles[`${size}WithContentBefore`], state.contentAfter && rootStyles[`${size}WithContentAfter`], rootStyles[appearance], !disabled && appearance === 'outline' && rootStyles.outlineInteractive, !disabled && appearance === 'underline' && rootStyles.underlineInteractive, !disabled && filled && rootStyles.filledInteractive, filled && rootStyles.filled, !disabled && invalid && rootStyles.invalid, disabled && rootStyles.disabled, state.root.className);
    state.input.className = (0, _react.mergeClasses)(inputClassNames.input, useInputClassName(), inputStyles[size], state.contentBefore && inputStyles[`${size}WithContentBefore`], state.contentAfter && inputStyles[`${size}WithContentAfter`], disabled && inputStyles.disabled, state.input.className);
    const contentClasses = [
        useContentClassName(),
        disabled && contentStyles.disabled,
        contentStyles[size]
    ];
    if (state.contentBefore) {
        state.contentBefore.className = (0, _react.mergeClasses)(inputClassNames.contentBefore, ...contentClasses, state.contentBefore.className);
    }
    if (state.contentAfter) {
        state.contentAfter.className = (0, _react.mergeClasses)(inputClassNames.contentAfter, ...contentClasses, state.contentAfter.className);
    }
    return state;
};
