'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    inputClassNames: function() {
        return inputClassNames;
    },
    useInputStyles_unstable: function() {
        return useInputStyles_unstable;
    }
});
const _reacttheme = require("@fluentui/react-theme");
const _react = require("@griffel/react");
const inputClassNames = {
    root: 'fui-Input',
    input: 'fui-Input__input',
    contentBefore: 'fui-Input__contentBefore',
    contentAfter: 'fui-Input__contentAfter'
};
// TODO(sharing) should these be shared somewhere?
const fieldHeights = {
    small: '24px',
    medium: '32px',
    large: '40px'
};
// With no contentBefore or contentAfter, the input slot uses combined padding to increase its hit target.
// If there is contentBefore or contentAfter, then the root and input slots use their individual padding.
const horizontalPadding = {
    root: {
        small: _reacttheme.tokens.spacingHorizontalSNudge,
        medium: _reacttheme.tokens.spacingHorizontalMNudge,
        large: _reacttheme.tokens.spacingHorizontalM
    },
    input: {
        small: _reacttheme.tokens.spacingHorizontalXXS,
        medium: _reacttheme.tokens.spacingHorizontalXXS,
        large: _reacttheme.tokens.spacingHorizontalSNudge
    },
    combined: {
        small: _reacttheme.tokens.spacingHorizontalS,
        medium: _reacttheme.tokens.spacingHorizontalM,
        large: `calc(${_reacttheme.tokens.spacingHorizontalM} + ${_reacttheme.tokens.spacingHorizontalSNudge})`
    }
};
const useRootClassName = /*#__PURE__*/ (0, _react.__resetStyles)("r1oeeo9n", "r9sxh5", {
    r: [
        ".r1oeeo9n{display:inline-flex;align-items:center;flex-wrap:nowrap;gap:var(--spacingHorizontalXXS);border-radius:var(--borderRadiusMedium);position:relative;box-sizing:border-box;vertical-align:middle;min-height:32px;font-family:var(--fontFamilyBase);font-size:var(--fontSizeBase300);font-weight:var(--fontWeightRegular);line-height:var(--lineHeightBase300);background-color:var(--colorNeutralBackground1);border:1px solid var(--colorNeutralStroke1);border-bottom-color:var(--colorNeutralStrokeAccessible);}",
        ".r1oeeo9n::after{box-sizing:border-box;content:\"\";position:absolute;left:-1px;bottom:-1px;right:-1px;height:max(2px, var(--borderRadiusMedium));border-bottom-left-radius:var(--borderRadiusMedium);border-bottom-right-radius:var(--borderRadiusMedium);border-bottom:2px solid var(--colorCompoundBrandStroke);clip-path:inset(calc(100% - 2px) 0 0 0);transform:scaleX(0);transition-property:transform;transition-duration:var(--durationUltraFast);transition-delay:var(--curveAccelerateMid);}",
        ".r1oeeo9n:focus-within::after{transform:scaleX(1);transition-property:transform;transition-duration:var(--durationNormal);transition-delay:var(--curveDecelerateMid);}",
        ".r1oeeo9n:focus-within:active::after{border-bottom-color:var(--colorCompoundBrandStrokePressed);}",
        ".r1oeeo9n:focus-within{outline:2px solid transparent;}",
        ".r9sxh5{display:inline-flex;align-items:center;flex-wrap:nowrap;gap:var(--spacingHorizontalXXS);border-radius:var(--borderRadiusMedium);position:relative;box-sizing:border-box;vertical-align:middle;min-height:32px;font-family:var(--fontFamilyBase);font-size:var(--fontSizeBase300);font-weight:var(--fontWeightRegular);line-height:var(--lineHeightBase300);background-color:var(--colorNeutralBackground1);border:1px solid var(--colorNeutralStroke1);border-bottom-color:var(--colorNeutralStrokeAccessible);}",
        ".r9sxh5::after{box-sizing:border-box;content:\"\";position:absolute;right:-1px;bottom:-1px;left:-1px;height:max(2px, var(--borderRadiusMedium));border-bottom-right-radius:var(--borderRadiusMedium);border-bottom-left-radius:var(--borderRadiusMedium);border-bottom:2px solid var(--colorCompoundBrandStroke);clip-path:inset(calc(100% - 2px) 0 0 0);transform:scaleX(0);transition-property:transform;transition-duration:var(--durationUltraFast);transition-delay:var(--curveAccelerateMid);}",
        ".r9sxh5:focus-within::after{transform:scaleX(1);transition-property:transform;transition-duration:var(--durationNormal);transition-delay:var(--curveDecelerateMid);}",
        ".r9sxh5:focus-within:active::after{border-bottom-color:var(--colorCompoundBrandStrokePressed);}",
        ".r9sxh5:focus-within{outline:2px solid transparent;}"
    ],
    s: [
        "@media screen and (prefers-reduced-motion: reduce){.r1oeeo9n::after{transition-duration:0.01ms;transition-delay:0.01ms;}}",
        "@media screen and (prefers-reduced-motion: reduce){.r1oeeo9n:focus-within::after{transition-duration:0.01ms;transition-delay:0.01ms;}}",
        "@media screen and (prefers-reduced-motion: reduce){.r9sxh5::after{transition-duration:0.01ms;transition-delay:0.01ms;}}",
        "@media screen and (prefers-reduced-motion: reduce){.r9sxh5:focus-within::after{transition-duration:0.01ms;transition-delay:0.01ms;}}"
    ]
});
const useRootStyles = /*#__PURE__*/ (0, _react.__styles)({
    small: {
        sshi5w: "f1pha7fy",
        Bahqtrf: "fk6fouc",
        Be2twd7: "fy9rknc",
        Bhrd7zp: "figsok6",
        Bg96gwp: "fwrc4pm"
    },
    medium: {},
    large: {
        sshi5w: "f1w5jphr",
        Bahqtrf: "fk6fouc",
        Be2twd7: "fod5ikn",
        Bhrd7zp: "figsok6",
        Bg96gwp: "faaz57k",
        i8kkvl: 0,
        Belr9w4: 0,
        rmohyg: "f1eyhf9v"
    },
    outline: {},
    outlineInteractive: {
        Bgoe8wy: "fvcxoqz",
        Bwzppfd: [
            "f1ub3y4t",
            "f1m52nbi"
        ],
        oetu4i: "f1l4zc64",
        gg5e9n: [
            "f1m52nbi",
            "f1ub3y4t"
        ],
        Drbcw7: "f8vnjqi",
        udz0bu: [
            "fz1etlk",
            "f1hc16gm"
        ],
        Be8ivqh: "f1klwx88",
        ofdepl: [
            "f1hc16gm",
            "fz1etlk"
        ]
    },
    underline: {
        De3pzq: "f1c21dwh",
        Beyfa6y: 0,
        Bbmb7ep: 0,
        Btl43ni: 0,
        B7oj6ja: 0,
        Dimara: "fokr779",
        icvyot: "f1ern45e",
        vrafjx: [
            "f1n71otn",
            "f1deefiw"
        ],
        wvpqe5: [
            "f1deefiw",
            "f1n71otn"
        ],
        Eqx8gd: [
            "f1n6gb5g",
            "f15yvnhg"
        ],
        B1piin3: [
            "f15yvnhg",
            "f1n6gb5g"
        ]
    },
    underlineInteractive: {
        oetu4i: "f1l4zc64",
        Be8ivqh: "f1klwx88",
        d9w3h3: 0,
        B3778ie: 0,
        B4j8arr: 0,
        Bl18szs: 0,
        Blrzh8d: "f2ale1x"
    },
    filled: {
        g2u3we: "fghlq4f",
        h3c5rm: [
            "f1gn591s",
            "fjscplz"
        ],
        B9xav0g: "fb073pr",
        zhjwy3: [
            "fjscplz",
            "f1gn591s"
        ]
    },
    filledInteractive: {
        q7v0qe: "ftmjh5b",
        kmh5ft: [
            "f17blpuu",
            "fsrcdbj"
        ],
        nagaa4: "f1tpwn32",
        B1yhkcb: [
            "fsrcdbj",
            "f17blpuu"
        ]
    },
    invalid: {
        tvckwq: "fs4k3qj",
        gk2u95: [
            "fcee079",
            "fmyw78r"
        ],
        hhx65j: "f1fgmyf4",
        Bxowmz0: [
            "fmyw78r",
            "fcee079"
        ]
    },
    "filled-darker": {
        De3pzq: "f16xq7d1"
    },
    "filled-lighter": {
        De3pzq: "fxugw4r"
    },
    "filled-darker-shadow": {
        De3pzq: "f16xq7d1",
        E5pizo: "fyed02w"
    },
    "filled-lighter-shadow": {
        De3pzq: "fxugw4r",
        E5pizo: "fyed02w"
    },
    disabled: {
        Bceei9c: "fdrzuqr",
        De3pzq: "f1c21dwh",
        g2u3we: "f1jj8ep1",
        h3c5rm: [
            "f15xbau",
            "fy0fskl"
        ],
        B9xav0g: "f4ikngz",
        zhjwy3: [
            "fy0fskl",
            "f15xbau"
        ],
        Bjwas2f: "fg455y9",
        Bn1d65q: [
            "f1rvyvqg",
            "f14g86mu"
        ],
        Bxeuatn: "f1cwzwz",
        n51gp8: [
            "f14g86mu",
            "f1rvyvqg"
        ],
        Bsft5z2: "fhr9occ",
        Bduesf4: "f99w1ws"
    },
    smallWithContentBefore: {
        uwmqm3: [
            "fk8j09s",
            "fdw0yi8"
        ]
    },
    smallWithContentAfter: {
        z189sj: [
            "fdw0yi8",
            "fk8j09s"
        ]
    },
    mediumWithContentBefore: {
        uwmqm3: [
            "f1ng84yb",
            "f11gcy0p"
        ]
    },
    mediumWithContentAfter: {
        z189sj: [
            "f11gcy0p",
            "f1ng84yb"
        ]
    },
    largeWithContentBefore: {
        uwmqm3: [
            "f1uw59to",
            "fw5db7e"
        ]
    },
    largeWithContentAfter: {
        z189sj: [
            "fw5db7e",
            "f1uw59to"
        ]
    }
}, {
    d: [
        ".f1pha7fy{min-height:24px;}",
        ".fk6fouc{font-family:var(--fontFamilyBase);}",
        ".fy9rknc{font-size:var(--fontSizeBase200);}",
        ".figsok6{font-weight:var(--fontWeightRegular);}",
        ".fwrc4pm{line-height:var(--lineHeightBase200);}",
        ".f1w5jphr{min-height:40px;}",
        ".fod5ikn{font-size:var(--fontSizeBase400);}",
        ".faaz57k{line-height:var(--lineHeightBase400);}",
        [
            ".f1eyhf9v{gap:var(--spacingHorizontalSNudge);}",
            {
                p: -1
            }
        ],
        ".f1c21dwh{background-color:var(--colorTransparentBackground);}",
        [
            ".fokr779{border-radius:0;}",
            {
                p: -1
            }
        ],
        ".f1ern45e{border-top-style:none;}",
        ".f1n71otn{border-right-style:none;}",
        ".f1deefiw{border-left-style:none;}",
        ".f1n6gb5g::after{left:0;}",
        ".f15yvnhg::after{right:0;}",
        [
            ".f2ale1x::after{border-radius:0;}",
            {
                p: -1
            }
        ],
        ".fghlq4f{border-top-color:var(--colorTransparentStroke);}",
        ".f1gn591s{border-right-color:var(--colorTransparentStroke);}",
        ".fjscplz{border-left-color:var(--colorTransparentStroke);}",
        ".fb073pr{border-bottom-color:var(--colorTransparentStroke);}",
        ".fs4k3qj:not(:focus-within),.fs4k3qj:hover:not(:focus-within){border-top-color:var(--colorPaletteRedBorder2);}",
        ".fcee079:not(:focus-within),.fcee079:hover:not(:focus-within){border-right-color:var(--colorPaletteRedBorder2);}",
        ".fmyw78r:not(:focus-within),.fmyw78r:hover:not(:focus-within){border-left-color:var(--colorPaletteRedBorder2);}",
        ".f1fgmyf4:not(:focus-within),.f1fgmyf4:hover:not(:focus-within){border-bottom-color:var(--colorPaletteRedBorder2);}",
        ".f16xq7d1{background-color:var(--colorNeutralBackground3);}",
        ".fxugw4r{background-color:var(--colorNeutralBackground1);}",
        ".fyed02w{box-shadow:var(--shadow2);}",
        ".fdrzuqr{cursor:not-allowed;}",
        ".f1jj8ep1{border-top-color:var(--colorNeutralStrokeDisabled);}",
        ".f15xbau{border-right-color:var(--colorNeutralStrokeDisabled);}",
        ".fy0fskl{border-left-color:var(--colorNeutralStrokeDisabled);}",
        ".f4ikngz{border-bottom-color:var(--colorNeutralStrokeDisabled);}",
        ".fhr9occ::after{content:unset;}",
        ".fk8j09s{padding-left:var(--spacingHorizontalSNudge);}",
        ".fdw0yi8{padding-right:var(--spacingHorizontalSNudge);}",
        ".f1ng84yb{padding-left:var(--spacingHorizontalMNudge);}",
        ".f11gcy0p{padding-right:var(--spacingHorizontalMNudge);}",
        ".f1uw59to{padding-left:var(--spacingHorizontalM);}",
        ".fw5db7e{padding-right:var(--spacingHorizontalM);}"
    ],
    h: [
        ".fvcxoqz:hover{border-top-color:var(--colorNeutralStroke1Hover);}",
        ".f1ub3y4t:hover{border-right-color:var(--colorNeutralStroke1Hover);}",
        ".f1m52nbi:hover{border-left-color:var(--colorNeutralStroke1Hover);}",
        ".f1l4zc64:hover{border-bottom-color:var(--colorNeutralStrokeAccessibleHover);}",
        ".ftmjh5b:hover,.ftmjh5b:focus-within{border-top-color:var(--colorTransparentStrokeInteractive);}",
        ".f17blpuu:hover,.f17blpuu:focus-within{border-right-color:var(--colorTransparentStrokeInteractive);}",
        ".fsrcdbj:hover,.fsrcdbj:focus-within{border-left-color:var(--colorTransparentStrokeInteractive);}",
        ".f1tpwn32:hover,.f1tpwn32:focus-within{border-bottom-color:var(--colorTransparentStrokeInteractive);}"
    ],
    a: [
        ".f8vnjqi:active,.f8vnjqi:focus-within{border-top-color:var(--colorNeutralStroke1Pressed);}",
        ".fz1etlk:active,.fz1etlk:focus-within{border-right-color:var(--colorNeutralStroke1Pressed);}",
        ".f1hc16gm:active,.f1hc16gm:focus-within{border-left-color:var(--colorNeutralStroke1Pressed);}",
        ".f1klwx88:active,.f1klwx88:focus-within{border-bottom-color:var(--colorNeutralStrokeAccessiblePressed);}"
    ],
    m: [
        [
            "@media (forced-colors: active){.fg455y9{border-top-color:GrayText;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f14g86mu{border-left-color:GrayText;}.f1rvyvqg{border-right-color:GrayText;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f1cwzwz{border-bottom-color:GrayText;}}",
            {
                m: "(forced-colors: active)"
            }
        ]
    ],
    w: [
        ".f99w1ws:focus-within{outline-style:none;}"
    ]
});
const useInputClassName = /*#__PURE__*/ (0, _react.__resetStyles)("r12stul0", null, [
    ".r12stul0{align-self:stretch;box-sizing:border-box;flex-grow:1;min-width:0;border-style:none;padding:0 var(--spacingHorizontalM);color:var(--colorNeutralForeground1);background-color:transparent;outline-style:none;font-family:inherit;font-size:inherit;font-weight:inherit;line-height:inherit;}",
    ".r12stul0::-webkit-input-placeholder{color:var(--colorNeutralForeground4);opacity:1;}",
    ".r12stul0::-moz-placeholder{color:var(--colorNeutralForeground4);opacity:1;}",
    ".r12stul0::placeholder{color:var(--colorNeutralForeground4);opacity:1;}"
]);
const useInputElementStyles = /*#__PURE__*/ (0, _react.__styles)({
    small: {
        uwmqm3: [
            "f1f5gg8d",
            "f1vdfbxk"
        ],
        z189sj: [
            "f1vdfbxk",
            "f1f5gg8d"
        ]
    },
    medium: {},
    large: {
        uwmqm3: [
            "fnphzt9",
            "flt1dlf"
        ],
        z189sj: [
            "flt1dlf",
            "fnphzt9"
        ]
    },
    smallWithContentBefore: {
        uwmqm3: [
            "fgiv446",
            "ffczdla"
        ]
    },
    smallWithContentAfter: {
        z189sj: [
            "ffczdla",
            "fgiv446"
        ]
    },
    mediumWithContentBefore: {
        uwmqm3: [
            "fgiv446",
            "ffczdla"
        ]
    },
    mediumWithContentAfter: {
        z189sj: [
            "ffczdla",
            "fgiv446"
        ]
    },
    largeWithContentBefore: {
        uwmqm3: [
            "fk8j09s",
            "fdw0yi8"
        ]
    },
    largeWithContentAfter: {
        z189sj: [
            "fdw0yi8",
            "fk8j09s"
        ]
    },
    disabled: {
        sj55zd: "f1s2aq7o",
        De3pzq: "f1c21dwh",
        Bceei9c: "fdrzuqr",
        yvdlaj: "fahhnxm"
    }
}, {
    d: [
        ".f1f5gg8d{padding-left:var(--spacingHorizontalS);}",
        ".f1vdfbxk{padding-right:var(--spacingHorizontalS);}",
        ".fnphzt9{padding-left:calc(var(--spacingHorizontalM) + var(--spacingHorizontalSNudge));}",
        ".flt1dlf{padding-right:calc(var(--spacingHorizontalM) + var(--spacingHorizontalSNudge));}",
        ".fgiv446{padding-left:var(--spacingHorizontalXXS);}",
        ".ffczdla{padding-right:var(--spacingHorizontalXXS);}",
        ".fk8j09s{padding-left:var(--spacingHorizontalSNudge);}",
        ".fdw0yi8{padding-right:var(--spacingHorizontalSNudge);}",
        ".f1s2aq7o{color:var(--colorNeutralForegroundDisabled);}",
        ".f1c21dwh{background-color:var(--colorTransparentBackground);}",
        ".fdrzuqr{cursor:not-allowed;}",
        ".fahhnxm::-webkit-input-placeholder{color:var(--colorNeutralForegroundDisabled);}",
        ".fahhnxm::-moz-placeholder{color:var(--colorNeutralForegroundDisabled);}"
    ]
});
const useContentClassName = /*#__PURE__*/ (0, _react.__resetStyles)("r1572tok", null, [
    ".r1572tok{box-sizing:border-box;color:var(--colorNeutralForeground3);display:flex;}",
    ".r1572tok>svg{font-size:20px;}"
]);
const useContentStyles = /*#__PURE__*/ (0, _react.__styles)({
    disabled: {
        sj55zd: "f1s2aq7o"
    },
    small: {
        Duoase: "f3qv9w"
    },
    medium: {},
    large: {
        Duoase: "f16u2scb"
    }
}, {
    d: [
        ".f1s2aq7o{color:var(--colorNeutralForegroundDisabled);}",
        ".f3qv9w>svg{font-size:16px;}",
        ".f16u2scb>svg{font-size:24px;}"
    ]
});
const useInputStyles_unstable = (state)=>{
    'use no memo';
    const { size, appearance } = state;
    const disabled = state.input.disabled;
    const invalid = `${state.input['aria-invalid']}` === 'true';
    const filled = appearance.startsWith('filled');
    const rootStyles = useRootStyles();
    const inputStyles = useInputElementStyles();
    const contentStyles = useContentStyles();
    state.root.className = (0, _react.mergeClasses)(inputClassNames.root, useRootClassName(), rootStyles[size], state.contentBefore && rootStyles[`${size}WithContentBefore`], state.contentAfter && rootStyles[`${size}WithContentAfter`], rootStyles[appearance], !disabled && appearance === 'outline' && rootStyles.outlineInteractive, !disabled && appearance === 'underline' && rootStyles.underlineInteractive, !disabled && filled && rootStyles.filledInteractive, filled && rootStyles.filled, !disabled && invalid && rootStyles.invalid, disabled && rootStyles.disabled, state.root.className);
    state.input.className = (0, _react.mergeClasses)(inputClassNames.input, useInputClassName(), inputStyles[size], state.contentBefore && inputStyles[`${size}WithContentBefore`], state.contentAfter && inputStyles[`${size}WithContentAfter`], disabled && inputStyles.disabled, state.input.className);
    const contentClasses = [
        useContentClassName(),
        disabled && contentStyles.disabled,
        contentStyles[size]
    ];
    if (state.contentBefore) {
        state.contentBefore.className = (0, _react.mergeClasses)(inputClassNames.contentBefore, ...contentClasses, state.contentBefore.className);
    }
    if (state.contentAfter) {
        state.contentAfter.className = (0, _react.mergeClasses)(inputClassNames.contentAfter, ...contentClasses, state.contentAfter.className);
    }
    return state;
};
