'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useInput_unstable", {
    enumerable: true,
    get: function() {
        return useInput_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactfield = require("@fluentui/react-field");
const _reactutilities = require("@fluentui/react-utilities");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const useInput_unstable = (props, ref)=>{
    props = (0, _reactfield.useFieldControlProps_unstable)(props, {
        supportsLabelFor: true,
        supportsRequired: true,
        supportsSize: true
    });
    const overrides = (0, _reactsharedcontexts.useOverrides_unstable)();
    var _overrides_inputDefaultAppearance;
    const { size = 'medium', appearance = (_overrides_inputDefaultAppearance = overrides.inputDefaultAppearance) !== null && _overrides_inputDefaultAppearance !== void 0 ? _overrides_inputDefaultAppearance : 'outline', onChange } = props;
    if (process.env.NODE_ENV !== 'production' && (appearance === 'filled-darker-shadow' || appearance === 'filled-lighter-shadow')) {
        // eslint-disable-next-line no-console
        console.error("The 'filled-darker-shadow' and 'filled-lighter-shadow' appearances are deprecated and will be removed in the" + ' future.');
    }
    const [value, setValue] = (0, _reactutilities.useControllableState)({
        state: props.value,
        defaultState: props.defaultValue,
        initialState: ''
    });
    const nativeProps = (0, _reactutilities.getPartitionedNativeProps)({
        props,
        primarySlotTagName: 'input',
        excludedPropNames: [
            'size',
            'onChange',
            'value',
            'defaultValue'
        ]
    });
    const state = {
        size,
        appearance,
        components: {
            root: 'span',
            input: 'input',
            contentBefore: 'span',
            contentAfter: 'span'
        },
        input: _reactutilities.slot.always(props.input, {
            defaultProps: {
                type: 'text',
                ref,
                ...nativeProps.primary
            },
            elementType: 'input'
        }),
        contentAfter: _reactutilities.slot.optional(props.contentAfter, {
            elementType: 'span'
        }),
        contentBefore: _reactutilities.slot.optional(props.contentBefore, {
            elementType: 'span'
        }),
        root: _reactutilities.slot.always(props.root, {
            defaultProps: nativeProps.root,
            elementType: 'span'
        })
    };
    state.input.value = value;
    state.input.onChange = (0, _reactutilities.useEventCallback)((ev)=>{
        const newValue = ev.target.value;
        onChange === null || onChange === void 0 ? void 0 : onChange(ev, {
            value: newValue
        });
        setValue(newValue);
    });
    return state;
};
