'use client';

import { tokens } from '@fluentui/react-theme';
import { __styles, mergeClasses } from '@griffel/react';
export const infoLabelClassNames = {
  root: 'fui-InfoLabel',
  label: 'fui-InfoLabel__label',
  infoButton: 'fui-InfoLabel__infoButton'
};
const useLabelStyles = /*#__PURE__*/__styles({
  base: {
    ha4doy: "f12kltsn",
    Bceei9c: "fpo1scq",
    sj55zd: "f1ym3bx4"
  }
}, {
  d: [".f12kltsn{vertical-align:top;}", ".fpo1scq{cursor:inherit;}", ".f1ym3bx4{color:inherit;}"]
});
const useInfoButtonStyles = /*#__PURE__*/__styles({
  base: {
    ha4doy: "f12kltsn",
    B6of3ja: "f1bmzb36",
    jrapky: "f1nyzk09"
  },
  large: {
    B6of3ja: "fkrn0sh",
    jrapky: "fmxx68s"
  }
}, {
  d: [".f12kltsn{vertical-align:top;}", ".f1bmzb36{margin-top:calc(0px - var(--spacingVerticalXXS));}", ".f1nyzk09{margin-bottom:calc(0px - var(--spacingVerticalXXS));}", ".fkrn0sh{margin-top:-1px;}", ".fmxx68s{margin-bottom:-1px;}"]
});
/**
 * Apply styling to the InfoLabel slots based on the state
 */
export const useInfoLabelStyles_unstable = state => {
  'use no memo';

  state.root.className = mergeClasses(infoLabelClassNames.root, state.root.className);
  const labelStyles = useLabelStyles();
  state.label.className = mergeClasses(infoLabelClassNames.label, labelStyles.base, state.label.className);
  const infoButtonStyles = useInfoButtonStyles();
  if (state.infoButton) {
    state.infoButton.className = mergeClasses(infoLabelClassNames.infoButton, infoButtonStyles.base, state.size === 'large' && infoButtonStyles.large, state.infoButton.className);
  }
  return state;
};