'use client';
import * as React from 'react';
import { useCustomStyleHook_unstable } from '@fluentui/react-shared-contexts';
import { renderInfoButton_unstable } from './renderInfoButton';
import { useInfoButton_unstable } from './useInfoButton';
import { useInfoButtonStyles_unstable } from './useInfoButtonStyles.styles';
/**
 * InfoButtons provide a way to display additional information about a form field or an area in the UI.
 */ export const InfoButton = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const state = useInfoButton_unstable(props, ref);
    useInfoButtonStyles_unstable(state);
    useCustomStyleHook_unstable('useInfoButtonStyles_unstable')(state);
    return renderInfoButton_unstable(state);
});
InfoButton.displayName = 'InfoButton';
