'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    infoButtonClassNames: function() {
        return infoButtonClassNames;
    },
    useInfoButtonStyles_unstable: function() {
        return useInfoButtonStyles_unstable;
    }
});
const _react = require("@griffel/react");
const infoButtonClassNames = {
    root: 'fui-InfoButton',
    // this className won't be used, but it's needed to satisfy the type checker
    popover: 'fui-InfoButton__popover',
    info: 'fui-InfoButton__info'
};
/**
 * Styles for the root slot
 */ const useButtonStyles = /*#__PURE__*/ (0, _react.__styles)({
    base: {
        Bt984gj: "f122n59",
        B7ck84d: "f1ewtqcl",
        mc9l5x: "ftuwxu6",
        Brf1p80: "f4d9j23",
        w71qe1: "f1iuv45f",
        ha4doy: "fmrv4ls",
        qhf8xq: "f10pi13n",
        De3pzq: "f1c21dwh",
        sj55zd: "fkfq4zb",
        icvyot: "f1ern45e",
        vrafjx: [
            "f1n71otn",
            "f1deefiw"
        ],
        oivjwe: "f1h8hb77",
        wvpqe5: [
            "f1deefiw",
            "f1n71otn"
        ],
        Beyfa6y: 0,
        Bbmb7ep: 0,
        Btl43ni: 0,
        B7oj6ja: 0,
        Dimara: "ft85np5",
        jrapky: 0,
        Frg6f3: 0,
        t21cq0: 0,
        B6of3ja: 0,
        B74szlk: "f1s184ao",
        Byoj8tv: 0,
        uwmqm3: 0,
        z189sj: 0,
        z8tnut: 0,
        B0ocmuz: "f16d74zd",
        D0sxk3: "f16u1re",
        t6yez3: "f1rw4040",
        Jwef8y: "fjxutwb",
        Bi91k9c: "f139oj5f",
        eoavqd: "f8491dx",
        Bk3fhr4: "f1jpd6y0",
        Bmfj8id: "fuxngvv",
        iro3zm: "fwiml72",
        B2d53fq: "f1fg1p5m"
    },
    selected: {
        De3pzq: "f1q9pm1r",
        sj55zd: "f1qj7y59",
        D0sxk3: "fgzdkf0",
        t6yez3: "f15q0o9g",
        Bsw6fvg: "f1rirnrt",
        Bbusuzp: "f1cg6951"
    },
    highContrast: {
        Bbusuzp: "fn0tkbb",
        Bs6v0vm: "f1rp3av6",
        B46dtvo: "f1u7gwqv",
        gh1jta: "fl6kagl"
    },
    focusIndicator: {
        Brovlpu: "ftqa4ok",
        B486eqv: "f2hkw1w",
        B8q5s1w: "f8hki3x",
        Bci5o5g: [
            "f1d2448m",
            "ffh67wi"
        ],
        n8qw10: "f1bjia2o",
        Bdrgwmp: [
            "ffh67wi",
            "f1d2448m"
        ],
        Bb7d1vk: "f226i61",
        zhwhgb: [
            "f13kzufm",
            "fsx75g8"
        ],
        dhy2o1: "flujwa2",
        Gfyso: [
            "fsx75g8",
            "f13kzufm"
        ],
        Bm4h7ae: "f15bsgw9",
        B7ys5i9: "f14e48fq",
        Busjfv9: "f18yb2kv",
        Bhk32uz: "fd6o370",
        f6g5ot: 0,
        Boxcth7: 0,
        Bhdgwq3: 0,
        hgwjuy: 0,
        Bshpdp8: 0,
        Bsom6fd: 0,
        Blkhhs4: 0,
        Bonggc9: 0,
        Ddfuxk: 0,
        i03rao: 0,
        kclons: 0,
        clg4pj: 0,
        Bpqj9nj: 0,
        B6dhp37: 0,
        Bf4ptjt: 0,
        Bqtpl0w: 0,
        i4rwgc: "ffwy5si",
        Dah5zi: 0,
        B1tsrr9: 0,
        qqdqy8: 0,
        Bkh64rk: 0,
        e3fwne: "f3znvyf",
        J0r882: "f57olzd",
        Bule8hv: [
            "f4stah7",
            "fs1por5"
        ],
        Bjwuhne: "f480a47",
        Ghsupd: [
            "fs1por5",
            "f4stah7"
        ]
    },
    large: {
        Byoj8tv: 0,
        uwmqm3: 0,
        z189sj: 0,
        z8tnut: 0,
        B0ocmuz: "f1kx978o"
    }
}, {
    d: [
        ".f122n59{align-items:center;}",
        ".f1ewtqcl{box-sizing:border-box;}",
        ".ftuwxu6{display:inline-flex;}",
        ".f4d9j23{justify-content:center;}",
        ".f1iuv45f{text-decoration-line:none;}",
        ".fmrv4ls{vertical-align:middle;}",
        ".f10pi13n{position:relative;}",
        ".f1c21dwh{background-color:var(--colorTransparentBackground);}",
        ".fkfq4zb{color:var(--colorNeutralForeground2);}",
        ".f1ern45e{border-top-style:none;}",
        ".f1n71otn{border-right-style:none;}",
        ".f1deefiw{border-left-style:none;}",
        ".f1h8hb77{border-bottom-style:none;}",
        [
            ".ft85np5{border-radius:var(--borderRadiusMedium);}",
            {
                p: -1
            }
        ],
        [
            ".f1s184ao{margin:0;}",
            {
                p: -1
            }
        ],
        [
            ".f16d74zd{padding:var(--spacingVerticalXS) var(--spacingHorizontalXS);}",
            {
                p: -1
            }
        ],
        ".f16u1re .fui-Icon-filled{display:none;}",
        ".f1rw4040 .fui-Icon-regular{display:inline-flex;}",
        ".f1q9pm1r{background-color:var(--colorTransparentBackgroundSelected);}",
        ".f1qj7y59{color:var(--colorNeutralForeground2BrandSelected);}",
        ".fgzdkf0 .fui-Icon-filled{display:inline-flex;}",
        ".f15q0o9g .fui-Icon-regular{display:none;}",
        ".f8hki3x[data-fui-focus-visible]{border-top-color:transparent;}",
        ".f1d2448m[data-fui-focus-visible]{border-right-color:transparent;}",
        ".ffh67wi[data-fui-focus-visible]{border-left-color:transparent;}",
        ".f1bjia2o[data-fui-focus-visible]{border-bottom-color:transparent;}",
        ".f15bsgw9[data-fui-focus-visible]::after{content:\"\";}",
        ".f14e48fq[data-fui-focus-visible]::after{position:absolute;}",
        ".f18yb2kv[data-fui-focus-visible]::after{pointer-events:none;}",
        ".fd6o370[data-fui-focus-visible]::after{z-index:1;}",
        [
            ".ffwy5si[data-fui-focus-visible]::after{border:2px solid var(--colorStrokeFocus2);}",
            {
                p: -2
            }
        ],
        [
            ".f3znvyf[data-fui-focus-visible]::after{border-radius:var(--borderRadiusMedium);}",
            {
                p: -1
            }
        ],
        ".f57olzd[data-fui-focus-visible]::after{top:calc(2px * -1);}",
        ".f4stah7[data-fui-focus-visible]::after{right:calc(2px * -1);}",
        ".fs1por5[data-fui-focus-visible]::after{left:calc(2px * -1);}",
        ".f480a47[data-fui-focus-visible]::after{bottom:calc(2px * -1);}",
        [
            ".f1kx978o{padding:var(--spacingVerticalXXS) var(--spacingVerticalXXS);}",
            {
                p: -1
            }
        ]
    ],
    h: [
        ".fjxutwb:hover{background-color:var(--colorTransparentBackgroundHover);}",
        ".f139oj5f:hover{color:var(--colorNeutralForeground2BrandHover);}",
        ".f8491dx:hover{cursor:pointer;}",
        ".f1jpd6y0:hover .fui-Icon-filled{display:inline-flex;}",
        ".fuxngvv:hover .fui-Icon-regular{display:none;}",
        ".fwiml72:hover:active{background-color:var(--colorTransparentBackgroundPressed);}",
        ".f1fg1p5m:hover:active{color:var(--colorNeutralForeground2BrandPressed);}"
    ],
    m: [
        [
            "@media (forced-colors: active){.f1rirnrt{background-color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f1cg6951{color:Canvas;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.fn0tkbb{color:CanvasText;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f1rp3av6:hover,.f1rp3av6:hover:active{forced-color-adjust:none;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f1u7gwqv:hover,.f1u7gwqv:hover:active{background-color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.fl6kagl:hover,.fl6kagl:hover:active{color:Canvas;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f226i61[data-fui-focus-visible]::after{border-top-color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f13kzufm[data-fui-focus-visible]::after{border-right-color:Highlight;}.fsx75g8[data-fui-focus-visible]::after{border-left-color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.flujwa2[data-fui-focus-visible]::after{border-bottom-color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ]
    ],
    f: [
        ".ftqa4ok:focus{outline-style:none;}"
    ],
    i: [
        ".f2hkw1w:focus-visible{outline-style:none;}"
    ]
});
const usePopoverSurfaceStyles = /*#__PURE__*/ (0, _react.__styles)({
    base: {
        B2u0y6b: "f1qmtlvf"
    },
    smallMedium: {
        Bahqtrf: "fk6fouc",
        Be2twd7: "fy9rknc",
        Bhrd7zp: "figsok6",
        Bg96gwp: "fwrc4pm"
    },
    large: {
        Bahqtrf: "fk6fouc",
        Be2twd7: "fkhj508",
        Bhrd7zp: "figsok6",
        Bg96gwp: "f1i3iumi"
    }
}, {
    d: [
        ".f1qmtlvf{max-width:264px;}",
        ".fk6fouc{font-family:var(--fontFamilyBase);}",
        ".fy9rknc{font-size:var(--fontSizeBase200);}",
        ".figsok6{font-weight:var(--fontWeightRegular);}",
        ".fwrc4pm{line-height:var(--lineHeightBase200);}",
        ".fkhj508{font-size:var(--fontSizeBase300);}",
        ".f1i3iumi{line-height:var(--lineHeightBase300);}"
    ]
});
const useInfoButtonStyles_unstable = (state)=>{
    'use no memo';
    const { size } = state;
    const { open } = state.popover;
    const buttonStyles = useButtonStyles();
    const popoverSurfaceStyles = usePopoverSurfaceStyles();
    state.info.className = (0, _react.mergeClasses)(infoButtonClassNames.info, popoverSurfaceStyles.base, size === 'large' ? popoverSurfaceStyles.large : popoverSurfaceStyles.smallMedium, state.info.className);
    state.root.className = (0, _react.mergeClasses)(infoButtonClassNames.root, buttonStyles.base, buttonStyles.highContrast, buttonStyles.focusIndicator, open && buttonStyles.selected, size === 'large' && buttonStyles.large, state.root.className);
    return state;
};
