'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useInfoButton_unstable", {
    enumerable: true,
    get: function() {
        return useInfoButton_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _DefaultInfoButtonIcons = require("./DefaultInfoButtonIcons");
const _reactutilities = require("@fluentui/react-utilities");
const _reactpopover = require("@fluentui/react-popover");
const infoButtonIconMap = {
    small: /*#__PURE__*/ _react.createElement(_DefaultInfoButtonIcons.DefaultInfoButtonIcon12, null),
    medium: /*#__PURE__*/ _react.createElement(_DefaultInfoButtonIcons.DefaultInfoButtonIcon16, null),
    large: /*#__PURE__*/ _react.createElement(_DefaultInfoButtonIcons.DefaultInfoButtonIcon20, null)
};
const popoverSizeMap = {
    small: 'small',
    medium: 'small',
    large: 'medium'
};
const useInfoButton_unstable = (props, ref)=>{
    const { size = 'medium', inline = true, popover, info, ...rest } = props;
    const rootRef = (0, _reactutilities.useMergedRefs)(ref);
    const state = {
        inline,
        size,
        components: {
            root: 'button',
            popover: _reactpopover.Popover,
            info: _reactpopover.PopoverSurface
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('button', {
            children: infoButtonIconMap[size],
            type: 'button',
            'aria-label': 'information',
            ...rest,
            ref: rootRef
        }), {
            elementType: 'button'
        }),
        popover: _reactutilities.slot.always(popover, {
            defaultProps: {
                inline,
                positioning: 'above-start',
                size: popoverSizeMap[size],
                withArrow: true
            },
            elementType: _reactpopover.Popover
        }),
        info: _reactutilities.slot.always(info, {
            defaultProps: {
                role: 'note',
                tabIndex: -1
            },
            elementType: _reactpopover.PopoverSurface
        })
    };
    const [popoverOpen, setPopoverOpen] = (0, _reactutilities.useControllableState)({
        state: state.popover.open,
        defaultState: state.popover.defaultOpen,
        initialState: false
    });
    state.popover.open = popoverOpen;
    state.popover.onOpenChange = (0, _reactutilities.mergeCallbacks)(state.popover.onOpenChange, (e, data)=>setPopoverOpen(data.open));
    const infoRef = (0, _reactutilities.useMergedRefs)(state.info.ref);
    state.info.ref = infoRef;
    // Hide the popover when focus moves out of the button and popover
    const onBlurButtonOrInfo = (e)=>{
        const nextFocused = e.relatedTarget;
        if (nextFocused && rootRef.current !== nextFocused && !(0, _reactutilities.elementContains)(infoRef.current, nextFocused)) {
            setPopoverOpen(false);
        }
    };
    state.root.onBlur = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(state.root.onBlur, onBlurButtonOrInfo));
    state.info.onBlurCapture = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(state.info.onBlurCapture, onBlurButtonOrInfo));
    return state;
};
