import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import { Label } from '@fluentui/react-label';
import type { PopoverProps } from '@fluentui/react-popover';
import type { PopoverSurface } from '@fluentui/react-popover';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

/**
 * InfoButtons provide a way to display additional information about a form field or an area in the UI.
 */
export declare const InfoButton: ForwardRefComponent<InfoButtonProps>;

export declare const infoButtonClassNames: SlotClassNames<InfoButtonSlots>;

/**
 * InfoButton Props
 */
export declare type InfoButtonProps = Omit<ComponentProps<Partial<InfoButtonSlots>>, 'disabled' | 'popover'> & {
    /**
     * Size of the InfoButton.
     *
     * @default medium
     */
    size?: 'small' | 'medium' | 'large';
    /**
     * Whether the InfoButton should be rendered inline or on a Portal.
     *
     * @default true
     */
    inline?: boolean;
    /**
     * The Popover element that wraps the info and root slots. Use this slot to pass props to the Popover.
     */
    popover?: InfoButtonSlots['popover'];
};

export declare type InfoButtonSlots = {
    root: NonNullable<Slot<'button'>>;
    /**
     * The Popover element that wraps the info and root slots. Use this slot to pass props to the Popover.
     */
    popover: NonNullable<Slot<Partial<Omit<PopoverProps, 'openOnHover'>>>>;
    /**
     * The information to be displayed in the PopoverSurface when the button is pressed.
     */
    info: NonNullable<Slot<typeof PopoverSurface>>;
};

/**
 * State used in rendering InfoButton
 */
export declare type InfoButtonState = ComponentState<InfoButtonSlots> & Required<Pick<InfoButtonProps, 'inline' | 'size'>>;

/**
 * InfoLabel component
 */
export declare const InfoLabel: ForwardRefComponent<InfoLabelProps>;

export declare const infoLabelClassNames: SlotClassNames<InfoLabelSlots>;

/**
 * InfoLabel Props
 */
export declare type InfoLabelProps = ComponentProps<Partial<InfoLabelSlots>, 'label'> & {
    /**
     * The content of the InfoButton's popover.
     */
    info?: InfoButtonProps['info'];
};

export declare type InfoLabelSlots = {
    root: NonNullable<Slot<'span'>>;
    /**
     * The Label component.
     *
     * It is not typically necessary to use this prop. The label text is the child of the `<InfoLabel>`, and other props
     * such as `size` and `required` should be set directly on the `InfoLabel`.
     *
     * This is the PRIMARY slot: all native properties specified directly on `<InfoLabel>` will be applied to this slot,
     * except `className` and `style`, which remain on the root slot.
     */
    label: NonNullable<Slot<typeof Label>>;
    /**
     * The InfoButton component.
     *
     * It is not typically necessary to use this prop. The content can be set using the `info` prop of the InfoLabel.
     */
    infoButton: Slot<typeof InfoButton>;
};

/**
 * State used in rendering InfoLabel
 */
export declare type InfoLabelState = ComponentState<InfoLabelSlots> & Pick<InfoLabelProps, 'size'>;

/**
 * Render the final JSX of InfoButton
 */
export declare const renderInfoButton_unstable: (state: InfoButtonState) => JSXElement;

/**
 * Render the final JSX of InfoLabel
 */
export declare const renderInfoLabel_unstable: (state: InfoLabelState) => JSXElement;

/**
 * Create the state required to render InfoButton.
 *
 * The returned state can be modified with hooks such as useInfoButtonStyles_unstable,
 * before being passed to renderInfoButton_unstable.
 *
 * @param props - props from this instance of InfoButton
 * @param ref - reference to root HTMLButtonElement of InfoButton
 */
export declare const useInfoButton_unstable: (props: InfoButtonProps, ref: React_2.Ref<HTMLButtonElement>) => InfoButtonState;

/**
 * Apply styling to the InfoButton slots based on the state
 */
export declare const useInfoButtonStyles_unstable: (state: InfoButtonState) => InfoButtonState;

/**
 * Create the state required to render InfoLabel.
 *
 * The returned state can be modified with hooks such as useInfoLabelStyles_unstable,
 * before being passed to renderInfoLabel_unstable.
 *
 * @param props - props from this instance of InfoLabel
 * @param ref - reference to label element of InfoLabel
 */
export declare const useInfoLabel_unstable: (props: InfoLabelProps, ref: React_2.Ref<HTMLLabelElement>) => InfoLabelState;

/**
 * Apply styling to the InfoLabel slots based on the state
 */
export declare const useInfoLabelStyles_unstable: (state: InfoLabelState) => InfoLabelState;

export { }
