/* eslint-disable @typescript-eslint/no-deprecated */ 'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    infoLabelClassNames: function() {
        return infoLabelClassNames;
    },
    useInfoLabelStyles_unstable: function() {
        return useInfoLabelStyles_unstable;
    }
});
const _reacttheme = require("@fluentui/react-theme");
const _react = require("@griffel/react");
const infoLabelClassNames = {
    root: 'fui-InfoLabel',
    label: 'fui-InfoLabel__label',
    infoButton: 'fui-InfoLabel__infoButton'
};
const useLabelStyles = (0, _react.makeStyles)({
    base: {
        verticalAlign: 'top',
        cursor: 'inherit',
        color: 'inherit'
    }
});
const useInfoButtonStyles = (0, _react.makeStyles)({
    base: {
        verticalAlign: 'top',
        // Negative margin to align with the text
        marginTop: `calc(0px - ${_reacttheme.tokens.spacingVerticalXXS})`,
        marginBottom: `calc(0px - ${_reacttheme.tokens.spacingVerticalXXS})`
    },
    large: {
        // Negative margin to align with the text
        marginTop: '-1px',
        marginBottom: '-1px'
    }
});
const useInfoLabelStyles_unstable = (state)=>{
    // eslint-disable-next-line react-compiler/react-compiler
    state.root.className = (0, _react.mergeClasses)(infoLabelClassNames.root, state.root.className);
    const labelStyles = useLabelStyles();
    state.label.className = (0, _react.mergeClasses)(infoLabelClassNames.label, labelStyles.base, state.label.className);
    const infoButtonStyles = useInfoButtonStyles();
    if (state.infoButton) {
        state.infoButton.className = (0, _react.mergeClasses)(infoLabelClassNames.infoButton, infoButtonStyles.base, state.size === 'large' && infoButtonStyles.large, state.infoButton.className);
    }
    return state;
};
