/* eslint-disable @typescript-eslint/no-deprecated */ 'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useInfoLabel_unstable", {
    enumerable: true,
    get: function() {
        return useInfoLabel_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactlabel = require("@fluentui/react-label");
const _reactutilities = require("@fluentui/react-utilities");
const _InfoButton = require("../InfoButton/InfoButton");
const useInfoLabel_unstable = (props, ref)=>{
    const { root: rootShorthand, label: labelShorthand, infoButton: infoButtonShorthand, info, size, className, style, ...labelProps } = props;
    const baseId = (0, _reactutilities.useId)('infolabel-');
    const [open, setOpen] = _react.useState(false);
    const root = _reactutilities.slot.always(rootShorthand, {
        defaultProps: {
            className,
            style
        },
        elementType: 'span'
    });
    const label = _reactutilities.slot.always(labelShorthand, {
        defaultProps: {
            id: baseId + '__label',
            ref,
            size,
            ...labelProps
        },
        elementType: _reactlabel.Label
    });
    const infoButton = _reactutilities.slot.optional(infoButtonShorthand, {
        renderByDefault: !!info,
        defaultProps: {
            id: baseId + '__infoButton',
            size,
            info
        },
        elementType: _InfoButton.InfoButton
    });
    const infoButtonPopover = _reactutilities.slot.always(infoButton === null || infoButton === void 0 ? void 0 : infoButton.popover, {
        elementType: 'div'
    });
    infoButtonPopover.onOpenChange = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(infoButtonPopover.onOpenChange, (e, data)=>{
        setOpen(data.open);
    }));
    if (infoButton) {
        var _infoButton, _arialabelledby;
        infoButton.popover = infoButtonPopover;
        infoButton.info = _reactutilities.slot.optional(infoButton === null || infoButton === void 0 ? void 0 : infoButton.info, {
            defaultProps: {
                id: baseId + '__info'
            },
            elementType: 'div'
        });
        var _;
        (_ = (_infoButton = infoButton)[_arialabelledby = 'aria-labelledby']) !== null && _ !== void 0 ? _ : _infoButton[_arialabelledby] = `${label.id} ${infoButton.id}`;
        if (open) {
            var _infoButton_info;
            var _root, _ariaowns;
            var _1;
            (_1 = (_root = root)[_ariaowns = 'aria-owns']) !== null && _1 !== void 0 ? _1 : _root[_ariaowns] = (_infoButton_info = infoButton.info) === null || _infoButton_info === void 0 ? void 0 : _infoButton_info.id;
        }
    }
    return {
        size,
        components: {
            root: 'span',
            label: _reactlabel.Label,
            infoButton: _InfoButton.InfoButton
        },
        root,
        label,
        infoButton
    };
};
