/* eslint-disable @typescript-eslint/no-deprecated */ 'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useInfoButton_unstable", {
    enumerable: true,
    get: function() {
        return useInfoButton_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _DefaultInfoButtonIcons = require("./DefaultInfoButtonIcons");
const _reactutilities = require("@fluentui/react-utilities");
const _reactpopover = require("@fluentui/react-popover");
const infoButtonIconMap = {
    small: /*#__PURE__*/ _react.createElement(_DefaultInfoButtonIcons.DefaultInfoButtonIcon12, null),
    medium: /*#__PURE__*/ _react.createElement(_DefaultInfoButtonIcons.DefaultInfoButtonIcon16, null),
    large: /*#__PURE__*/ _react.createElement(_DefaultInfoButtonIcons.DefaultInfoButtonIcon20, null)
};
const popoverSizeMap = {
    small: 'small',
    medium: 'small',
    large: 'medium'
};
const useInfoButton_unstable = (props, ref)=>{
    const { size = 'medium', inline = true } = props;
    const state = {
        inline,
        size,
        components: {
            root: 'button',
            popover: _reactpopover.Popover,
            info: _reactpopover.PopoverSurface
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('button', {
            children: infoButtonIconMap[size],
            type: 'button',
            'aria-label': 'information',
            ...props,
            // FIXME:
            // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLButtonElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: ref
        }), {
            elementType: 'button'
        }),
        popover: _reactutilities.slot.always(props.popover, {
            defaultProps: {
                inline,
                positioning: 'above-start',
                size: popoverSizeMap[size],
                withArrow: true
            },
            elementType: _reactpopover.Popover
        }),
        info: _reactutilities.slot.always(props.info, {
            defaultProps: {
                role: 'note',
                tabIndex: -1
            },
            elementType: _reactpopover.PopoverSurface
        })
    };
    const [popoverOpen, setPopoverOpen] = (0, _reactutilities.useControllableState)({
        state: state.popover.open,
        defaultState: state.popover.defaultOpen,
        initialState: false
    });
    state.popover.open = popoverOpen;
    state.popover.onOpenChange = (0, _reactutilities.mergeCallbacks)(state.popover.onOpenChange, (e, data)=>setPopoverOpen(data.open));
    const focusOutRef = _react.useCallback((el)=>{
        if (!el) {
            return;
        }
        el.addEventListener('focusout', (e)=>{
            const nextFocused = e.relatedTarget;
            if ((0, _reactutilities.isHTMLElement)(nextFocused) && !(0, _reactutilities.elementContains)(el, nextFocused)) {
                setPopoverOpen(false);
            }
        });
    }, [
        setPopoverOpen
    ]);
    state.info.ref = (0, _reactutilities.useMergedRefs)(state.info.ref, focusOutRef);
    return state;
};
