import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

/**
 * The Image component ensures the consistent styling of images.
 */
declare const Image_2: ForwardRefComponent<ImageProps>;
export { Image_2 as Image }

export declare const imageClassNames: SlotClassNames<ImageSlots>;

export declare type ImageProps = ComponentProps<ImageSlots> & {
    /**
     * An image can take up the width of its container.
     *
     * @default false
     */
    block?: boolean;
    /**
     * An image can appear with a rectangular border.
     *
     * @default false
     */
    bordered?: boolean;
    /**
     * An image can set how it should be resized to fit its container.
     *
     * @default 'default'
     */
    fit?: 'none' | 'center' | 'contain' | 'cover' | 'default';
    /**
     * An image can appear elevated with shadow.
     *
     * @default false
     */
    shadow?: boolean;
    /**
     * An image can appear square, circular, or rounded.
     *
     * @default 'square'
     */
    shape?: 'square' | 'circular' | 'rounded';
};

export declare type ImageSlots = {
    root: Slot<'img'>;
};

export declare type ImageState = ComponentState<ImageSlots> & Required<Pick<ImageProps, 'block' | 'bordered' | 'fit' | 'shadow' | 'shape'>>;

/**
 * Define the render function.
 * Given the state of an image, renders it.
 */
export declare const renderImage_unstable: (state: ImageState) => JSXElement;

/**
 * Given user props, returns state and render function for an Image.
 */
export declare const useImage_unstable: (props: ImageProps, ref: React_2.Ref<HTMLImageElement>) => ImageState;

export declare const useImageStyles_unstable: (state: ImageState) => ImageState;

export { }
