"use client";
import { createFluentIcon } from "../utils/createFluentIcon";
export const RulerFilled = ( /*#__PURE__*/createFluentIcon('RulerFilled', "1em", ["m13.97 3.2.03.3v13c0 .83-.67 1.5-1.5 1.5h-5A1.5 1.5 0 0 1 6 16.5v-13A1.5 1.5 0 0 1 7.5 2h5c.72 0 1.33.51 1.47 1.2ZM7 14.5v1h1.5a.5.5 0 0 0 0-1H7Zm0-10v1h1.5a.5.5 0 0 0 0-1H7ZM7 7v1h2.5a.5.5 0 0 0 0-1H7Zm0 2.5v1h1.5a.5.5 0 0 0 0-1H7ZM7 12v1h2.5a.5.5 0 1 0 0-1H7Z"]));
export const RulerRegular = ( /*#__PURE__*/createFluentIcon('RulerRegular', "1em", ["M14 3.5c0-.83-.67-1.5-1.5-1.5h-5C6.67 2 6 2.67 6 3.5v13c0 .83.67 1.5 1.5 1.5h5c.83 0 1.5-.67 1.5-1.5v-13ZM7 13h2.5a.5.5 0 0 0 0-1H7v-1.5h1.5a.5.5 0 0 0 0-1H7V8h2.5a.5.5 0 0 0 0-1H7V5.5h1.5a.5.5 0 0 0 0-1H7v-1c0-.28.22-.5.5-.5h5c.28 0 .5.22.5.5v13a.5.5 0 0 1-.5.5h-5a.5.5 0 0 1-.5-.5v-1h1.5a.5.5 0 0 0 0-1H7V13Z"]));
export const RunFilled = ( /*#__PURE__*/createFluentIcon('RunFilled', "1em", ["M7 2.4A.5.5 0 1 0 6 2.6v.04A5.63 5.63 0 0 0 2.7 5.15C2.13 6.15 2.01 7.2 2 8l-.67.84a1.5 1.5 0 0 0 .33 2.18l8.66 5.86A6.5 6.5 0 0 0 13.96 18h2.79a2.25 2.25 0 0 0 2.23-2.57c-.16-1.1-1.09-1.89-2.05-2.19a2.8 2.8 0 0 1-1.51-1l-3.02-5.2.18-.02a.5.5 0 1 0-.17-.99A4.65 4.65 0 0 1 7 2.41Zm-2.33 2 2.2 3.8a1 1 0 0 1-.37 1.38l-.87.5L3 8.3v-.13c0-.77.08-1.7.56-2.54.24-.43.6-.85 1.11-1.23Zm2.16 6.5 3.05-1.77a1 1 0 0 1 1.36.37l.6 1.04a1 1 0 0 1-.36 1.37l-1.7.98-2.95-2ZM14 16h3.99c-.12.57-.63 1-1.23 1h-2.79a5.5 5.5 0 0 1-3.08-.95L2.22 10.2a.5.5 0 0 1-.1-.72l.28-.36 9.07 6.12c.75.5 1.62.77 2.52.77ZM2.11 9.47l-.39-.32Z"]));
export const RunRegular = ( /*#__PURE__*/createFluentIcon('RunRegular', "1em", ["M7 2.41a.5.5 0 0 0-.59-.4.5.5 0 0 0-.4.57v.05A5.63 5.63 0 0 0 2.7 5.15C2.13 6.15 2.01 7.2 2 8l-.67.84a1.5 1.5 0 0 0 .33 2.18l8.66 5.86A6.5 6.5 0 0 0 13.96 18h2.79c1.24 0 2.25-1 2.25-2.25 0-1.26-1.02-2.18-2.07-2.51a2.8 2.8 0 0 1-1.51-1l-3.02-5.2.19-.02a.5.5 0 0 0 .4-.58.5.5 0 0 0-.58-.4A4.65 4.65 0 0 1 7 2.4Zm4.27 4.68 3.29 5.66.01.03a3.77 3.77 0 0 0 2.06 1.41c.48.16.89.45 1.13.81h-3.77c-.7 0-1.38-.2-1.96-.6l-1.69-1.14 1.03-.6c.6-.34.8-1.1.46-1.7l-.77-1.33c-.34-.6-1.1-.8-1.7-.46l-2.74 1.58-.95-.64.7-.41c.6-.35.81-1.11.46-1.71l-2.1-3.63a6 6 0 0 1 1.57-.77 5.68 5.68 0 0 0 4.97 3.5Zm-1.99 6.66.05.09.05-.02 2.1 1.41c.74.5 1.61.77 2.51.77h3.99c-.12.57-.63 1-1.23 1h-2.79a5.5 5.5 0 0 1-3.08-.95L2.22 10.2a.5.5 0 0 1-.1-.72l.28-.36 4.15 2.8.01.02h.02l2.7 1.82Zm.14-1.11-1.88-1.27 2.31-1.34a.25.25 0 0 1 .35.1l.76 1.33c.07.11.03.27-.09.34l-1.45.84Zm-5.86-7c.12-.2.25-.4.42-.6L5.97 8.5c.07.12.03.27-.1.34l-1.13.65L3 8.31v-.13c0-.77.08-1.7.56-2.54Z"]));
export const SanitizeFilled = ( /*#__PURE__*/createFluentIcon('SanitizeFilled', "1em", ["M2.77 5.23a2.5 2.5 0 0 0 0 3.54l3.46 3.46c.11.11.23.2.35.3.04-.13.1-.25.17-.36.4-.6.9-1.02 1.49-1.27.26-.1.51-.17.76-.2V7.5a1.5 1.5 0 0 1 2.05-1.4c.07-.25.2-.48.39-.66L8.77 2.77a2.5 2.5 0 0 0-3.54 0L2.77 5.23ZM12.5 6a.5.5 0 0 0-.5.5v5a.5.5 0 1 1-1 0v-4a.5.5 0 0 0-1 0v4.25a2.08 2.08 0 0 0-1.38.08c-.38.16-.74.44-1.04.9a.5.5 0 0 0 .22.73 5.26 5.26 0 0 1 2.71 2.37c.55 1.03 1.6 2.17 2.99 2.17h.26A2.5 2.5 0 0 0 16 16.62l.63-1.26a3.5 3.5 0 0 0 .37-1.57V7.5a.5.5 0 0 0-1 0v4a.5.5 0 1 1-1 0v-5a.5.5 0 0 0-1 0v5a.5.5 0 1 1-1 0v-5a.5.5 0 0 0-.5-.5Zm-9 6c.28 0 .5.22.5.5v.5h.5a.5.5 0 0 1 0 1H4v.5a.5.5 0 1 1-1 0V14h-.5a.5.5 0 1 1 0-1H3v-.5c0-.28.22-.5.5-.5Zm3 3c.28 0 .5.22.5.5v.5h.5a.5.5 0 0 1 0 1H7v.5a.5.5 0 1 1-1 0V17h-.5a.5.5 0 1 1 0-1H6v-.5c0-.28.22-.5.5-.5Z"]));
export const SanitizeRegular = ( /*#__PURE__*/createFluentIcon('SanitizeRegular', "1em", ["M5.94 3.47 3.47 5.94a1.5 1.5 0 0 0 0 2.12l2.97 2.96c-.25.24-.45.51-.6.82L2.77 8.77a2.5 2.5 0 0 1 0-3.54l2.46-2.46a2.5 2.5 0 0 1 3.54 0L11.3 5.3c-.3.17-.55.39-.76.65L8.06 3.47a1.5 1.5 0 0 0-2.12 0ZM15.9 7c-.2-.58-.76-1-1.41-1h-2c-.65 0-1.2.42-1.41 1H11a2 2 0 0 0-2 2v2.31a2.77 2.77 0 0 0-.56-.06c-.36 0-.77.08-1.13.35-.37.27-.65.69-.8 1.28a.5.5 0 0 0 .3.58c1.9.81 3 2.1 3.61 3.03A3.1 3.1 0 0 0 12.94 18h1.82A2.5 2.5 0 0 0 17 16.62l.63-1.26a3.5 3.5 0 0 0 .37-1.57V9a2 2 0 0 0-2-2h-.09ZM14 7h.5c.28 0 .5.22.5.5v4a.5.5 0 1 0 1 0V8a1 1 0 0 1 1 1v4.8c0 .38-.09.76-.26 1.1l-.63 1.27c-.26.5-.78.83-1.35.83h-1.82c-.64 0-1.27-.42-1.68-1.05a9.01 9.01 0 0 0-3.64-3.21.91.91 0 0 1 .28-.34.9.9 0 0 1 .54-.15 2 2 0 0 1 .83.2A.5.5 0 0 0 10 12V9a1 1 0 0 1 1-1v3.5a.5.5 0 1 0 1 0v-4c0-.28.22-.5.5-.5h.5v4.5a.5.5 0 1 0 1 0V7ZM3.5 12c.28 0 .5.22.5.5v.5h.5a.5.5 0 0 1 0 1H4v.5a.5.5 0 1 1-1 0V14h-.5a.5.5 0 1 1 0-1H3v-.5c0-.28.22-.5.5-.5ZM7 15.5a.5.5 0 0 0-1 0v.5h-.5a.5.5 0 0 0 0 1H6v.5a.5.5 0 1 0 1 0V17h.5a.5.5 0 1 0 0-1H7v-.5Z"]));
export const SaveFilled = ( /*#__PURE__*/createFluentIcon('SaveFilled', "1em", ["M3 5c0-1.1.9-2 2-2h1v3.5C6 7.33 6.67 8 7.5 8h4c.83 0 1.5-.67 1.5-1.5V3h.38a2 2 0 0 1 1.41.59l1.62 1.62A2 2 0 0 1 17 6.62V15a2 2 0 0 1-2 2v-5.5c0-.83-.67-1.5-1.5-1.5h-7c-.83 0-1.5.67-1.5 1.5V17a2 2 0 0 1-2-2V5Zm9-2H7v3.5c0 .28.22.5.5.5h4a.5.5 0 0 0 .5-.5V3Zm2 8.5V17H6v-5.5c0-.28.22-.5.5-.5h7c.28 0 .5.22.5.5Z"]));
export const SaveRegular = ( /*#__PURE__*/createFluentIcon('SaveRegular', "1em", ["M3 5c0-1.1.9-2 2-2h8.38a2 2 0 0 1 1.41.59l1.62 1.62A2 2 0 0 1 17 6.62V15a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5Zm2-1a1 1 0 0 0-1 1v10a1 1 0 0 0 1 1v-4.5c0-.83.67-1.5 1.5-1.5h7c.83 0 1.5.67 1.5 1.5V16a1 1 0 0 0 1-1V6.62a1 1 0 0 0-.3-.7L14.1 4.28a1 1 0 0 0-.71-.29H13v2.5c0 .83-.67 1.5-1.5 1.5h-4A1.5 1.5 0 0 1 6 6.5V4H5Zm2 0v2.5c0 .28.22.5.5.5h4a.5.5 0 0 0 .5-.5V4H7Zm7 12v-4.5a.5.5 0 0 0-.5-.5h-7a.5.5 0 0 0-.5.5V16h8Z"]));
export const SaveArrowRightFilled = ( /*#__PURE__*/createFluentIcon('SaveArrowRightFilled', "1em", ["M3 5c0-1.1.9-2 2-2h1v3.5C6 7.33 6.67 8 7.5 8h4c.83 0 1.5-.67 1.5-1.5V3h.38a2 2 0 0 1 1.41.59l1.62 1.62A2 2 0 0 1 17 6.62V9.6a5.48 5.48 0 0 0-5.66.4H6.5c-.83 0-1.5.67-1.5 1.5V17a2 2 0 0 1-2-2V5Zm6 9.5c0-1.33.47-2.55 1.26-3.5H6.5a.5.5 0 0 0-.5.5V17h3.6c-.38-.75-.6-1.6-.6-2.5ZM12 3H7v3.5c0 .28.22.5.5.5h4a.5.5 0 0 0 .5-.5V3Zm7 11.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15.35a.5.5 0 0 0 .15-.35.5.5 0 0 0-.15-.35l-2-2a.5.5 0 0 0-.7.7L15.29 14H12.5a.5.5 0 0 0 0 1h2.8l-1.15 1.15a.5.5 0 0 0 .7.7l2-2Z"]));
export const SaveArrowRightRegular = ( /*#__PURE__*/createFluentIcon('SaveArrowRightRegular', "1em", ["M3 5c0-1.1.9-2 2-2h8.38a2 2 0 0 1 1.41.59l1.62 1.62A2 2 0 0 1 17 6.62V9.6c-.32-.16-.65-.3-1-.4V6.63a1 1 0 0 0-.3-.7L14.1 4.28a1 1 0 0 0-.71-.29H13v2.5c0 .83-.67 1.5-1.5 1.5h-4A1.5 1.5 0 0 1 6 6.5V4H5a1 1 0 0 0-1 1v10a1 1 0 0 0 1 1v-4.5c0-.83.67-1.5 1.5-1.5h4.84c-.4.28-.77.62-1.08 1H6.5a.5.5 0 0 0-.5.5V16h3.2c.1.35.24.68.4 1H5a2 2 0 0 1-2-2V5Zm4-1v2.5c0 .28.22.5.5.5h4a.5.5 0 0 0 .5-.5V4H7Zm12 10.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15.35a.5.5 0 0 0 .15-.35.5.5 0 0 0-.15-.35l-2-2a.5.5 0 0 0-.7.7L15.29 14H12.5a.5.5 0 0 0 0 1h2.8l-1.15 1.15a.5.5 0 0 0 .7.7l2-2Z"]));
export const SaveCopyFilled = ( /*#__PURE__*/createFluentIcon('SaveCopyFilled', "1em", ["M4.5 2A2.5 2.5 0 0 0 2 4.5v9A2.5 2.5 0 0 0 4.5 16h9a2.5 2.5 0 0 0 2.5-2.5v-9A2.5 2.5 0 0 0 13.5 2h-9Zm5 4.5v2h2a.5.5 0 0 1 0 1h-2v2a.5.5 0 0 1-1 0v-2h-2a.5.5 0 0 1 0-1h2v-2a.5.5 0 0 1 1 0ZM7.5 18c-.95 0-1.82-.38-2.45-1h9.45a2.5 2.5 0 0 0 2.5-2.5V5.05c.62.63 1 1.5 1 2.45v7a3.5 3.5 0 0 1-3.5 3.5h-7Z"]));
export const SaveCopyRegular = ( /*#__PURE__*/createFluentIcon('SaveCopyRegular', "1em", ["M9.5 6.5a.5.5 0 0 0-1 0v2h-2a.5.5 0 0 0 0 1h2v2a.5.5 0 0 0 1 0v-2h2a.5.5 0 0 0 0-1h-2v-2ZM4.5 2A2.5 2.5 0 0 0 2 4.5v9A2.5 2.5 0 0 0 4.5 16h9a2.5 2.5 0 0 0 2.5-2.5v-9A2.5 2.5 0 0 0 13.5 2h-9ZM3 4.5C3 3.67 3.67 3 4.5 3h9c.83 0 1.5.67 1.5 1.5v9c0 .83-.67 1.5-1.5 1.5h-9A1.5 1.5 0 0 1 3 13.5v-9ZM7.5 18c-.95 0-1.82-.38-2.45-1h9.45a2.5 2.5 0 0 0 2.5-2.5V5.05c.62.63 1 1.5 1 2.45v7a3.5 3.5 0 0 1-3.5 3.5h-7Z"]));
export const SaveEditFilled = ( /*#__PURE__*/createFluentIcon('SaveEditFilled', "1em", ["M5 3a2 2 0 0 0-2 2v10c0 1.1.9 2 2 2v-5.5c0-.83.67-1.5 1.5-1.5h6.44l1.16-1.16a2.87 2.87 0 0 1 2.9-.7V6.61a2 2 0 0 0-.59-1.41L14.8 3.59A2 2 0 0 0 13.38 3H13v3.5c0 .83-.67 1.5-1.5 1.5h-4A1.5 1.5 0 0 1 6 6.5V3H5Zm6.94 8-2.67 2.67c-.4.41-.7.92-.84 1.49l-.37 1.5c-.03.11-.05.23-.06.34H6v-5.5c0-.28.22-.5.5-.5h5.44ZM7 3h5v3.5a.5.5 0 0 1-.5.5h-4a.5.5 0 0 1-.5-.5V3Zm7.8 6.55-4.82 4.83a2.2 2.2 0 0 0-.58 1.02l-.37 1.5a.89.89 0 0 0 1.08 1.07l1.5-.37c.38-.1.73-.3 1.01-.58l4.83-4.83a1.87 1.87 0 0 0-2.64-2.64Z"]));
export const SaveEditRegular = ( /*#__PURE__*/createFluentIcon('SaveEditRegular', "1em", ["M5 3a2 2 0 0 0-2 2v10c0 1.1.9 2 2 2h3l.06-.35.16-.65H6v-4.5c0-.28.22-.5.5-.5h5.44l1-1H6.5c-.83 0-1.5.67-1.5 1.5V16a1 1 0 0 1-1-1V5a1 1 0 0 1 1-1h1v2.5C6 7.33 6.67 8 7.5 8h4c.83 0 1.5-.67 1.5-1.5V4h.38a1 1 0 0 1 .7.3l1.63 1.61a1 1 0 0 1 .29.71V8c.34-.01.68.03 1 .13v-1.5a2 2 0 0 0-.59-1.42L14.8 3.59A2 2 0 0 0 13.38 3H5Zm2 3.5V4h5v2.5a.5.5 0 0 1-.5.5h-4a.5.5 0 0 1-.5-.5Zm7.8 3.05-4.82 4.83a2.2 2.2 0 0 0-.58 1.02l-.37 1.5a.89.89 0 0 0 1.08 1.07l1.5-.37c.38-.1.73-.3 1.01-.58l4.83-4.83a1.87 1.87 0 0 0-2.64-2.64Z"]));
export const SaveImageFilled = ( /*#__PURE__*/createFluentIcon('SaveImageFilled', "1em", ["M5 2a2 2 0 0 0-2 2v10c0 1.1.9 2 2 2v-5.5C5 9.67 5.67 9 6.5 9h10c.17 0 .34.01.5.04V5.62a2 2 0 0 0-.59-1.41L14.8 2.59A2 2 0 0 0 13.38 2H13v3.5c0 .83-.67 1.5-1.5 1.5h-4A1.5 1.5 0 0 1 6 5.5V2H5Zm5.05 8A3.49 3.49 0 0 0 9 12.5V16H6v-5.5c0-.28.22-.5.5-.5h3.55ZM12 2H7v3.5c0 .28.22.5.5.5h4a.5.5 0 0 0 .5-.5V2Zm-2 10.5a2.5 2.5 0 0 1 2.5-2.5h4a2.5 2.5 0 0 1 2.5 2.5v4c0 .5-.15.98-.41 1.38l-3.03-3.03a1.5 1.5 0 0 0-2.12 0l-3.03 3.03c-.26-.4-.41-.87-.41-1.38v-4Zm7 .25a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Zm-5.88 5.84c.4.26.87.41 1.38.41h4c.5 0 .98-.15 1.38-.41l-3.03-3.03a.5.5 0 0 0-.7 0l-3.03 3.03Z"]));
export const SaveImageRegular = ( /*#__PURE__*/createFluentIcon('SaveImageRegular', "1em", ["M17 6.13v2.9a3.53 3.53 0 0 0-.5-.03H16V6.13a.97.97 0 0 0-.29-.72L13.6 3.3A.96.96 0 0 0 13 3V5.5a1.45 1.45 0 0 1-.44 1.06c-.14.13-.3.24-.48.32-.18.08-.38.12-.58.12h-4a1.45 1.45 0 0 1-1.05-.44 1.6 1.6 0 0 1-.33-.48A1.33 1.33 0 0 1 6 5.5V3H5a.97.97 0 0 0-.7.29c-.1.1-.17.2-.22.32A.86.86 0 0 0 4 4v10c0 .13.03.27.08.4.05.1.12.22.2.31.1.1.2.17.32.21.13.05.26.08.4.08v-4.5a1.45 1.45 0 0 1 .44-1.05c.14-.14.3-.25.48-.33.18-.08.38-.12.58-.12h6c-.96 0-1.82.38-2.45 1H6.5a.5.5 0 0 0-.5.5V15h3v1H5c-.26 0-.52-.05-.76-.16a2.2 2.2 0 0 1-.64-.42 1.9 1.9 0 0 1-.6-1.38V4c0-.26.05-.52.16-.76.1-.24.24-.45.42-.64A1.9 1.9 0 0 1 4.96 2h7.92c.26 0 .52.05.76.15.25.1.47.25.65.44L16.4 4.7c.19.19.34.4.43.65.1.24.16.5.16.77ZM7 3v2.5a.5.5 0 0 0 .5.5h4a.5.5 0 0 0 .5-.5V3H7Zm3 9.5a2.5 2.5 0 0 1 2.5-2.5h4a2.5 2.5 0 0 1 2.5 2.5v4c0 .5-.15.98-.41 1.38l-3.03-3.03a1.5 1.5 0 0 0-2.12 0l-3.03 3.03c-.26-.4-.41-.87-.41-1.38v-4Zm7 .25a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Zm-5.88 5.84c.4.26.87.41 1.38.41h4c.5 0 .98-.15 1.38-.41l-3.03-3.03a.5.5 0 0 0-.7 0l-3.03 3.03Z"]));
export const SaveMultipleFilled = ( /*#__PURE__*/createFluentIcon('SaveMultipleFilled', "1em", ["M6 5.5V3H5a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2v-4.5C5 9.67 5.67 9 6.5 9h5c.83 0 1.5.67 1.5 1.5V15a2 2 0 0 0 2-2V6.62a2 2 0 0 0-.59-1.41L12.8 3.59A2 2 0 0 0 11.38 3H11v2.5c0 .83-.67 1.5-1.5 1.5h-2A1.5 1.5 0 0 1 6 5.5Zm1 0V3h3v2.5a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1-.5-.5Zm5 9.5H6v-4.5c0-.28.22-.5.5-.5h5c.28 0 .5.22.5.5V15Zm-3.5 2c-.95 0-1.82-.38-2.45-1h7.45a2.5 2.5 0 0 0 2.5-2.5V6.05c.62.63 1 1.5 1 2.45v5a3.5 3.5 0 0 1-3.5 3.5h-5Z"]));
export const SaveMultipleRegular = ( /*#__PURE__*/createFluentIcon('SaveMultipleRegular', "1em", ["M5 3a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V6.62a2 2 0 0 0-.59-1.41L12.8 3.59A2 2 0 0 0 11.38 3H5ZM4 5a1 1 0 0 1 1-1h1v1.5C6 6.33 6.67 7 7.5 7h2c.83 0 1.5-.67 1.5-1.5V4h.38a1 1 0 0 1 .7.3l1.63 1.61a1 1 0 0 1 .29.71V13a1 1 0 0 1-1 1v-3.5c0-.83-.67-1.5-1.5-1.5h-5C5.67 9 5 9.67 5 10.5V14a1 1 0 0 1-1-1V5Zm3 .5V4h3v1.5a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1-.5-.5Zm5 5V14H6v-3.5c0-.28.22-.5.5-.5h5c.28 0 .5.22.5.5ZM8.5 17c-.95 0-1.82-.38-2.45-1h7.45a2.5 2.5 0 0 0 2.5-2.5V6.05c.62.63 1 1.5 1 2.45v5a3.5 3.5 0 0 1-3.5 3.5h-5Z"]));
export const SaveSearchFilled = ( /*#__PURE__*/createFluentIcon('SaveSearchFilled', "1em", ["M3 5c0-1.1.9-2 2-2h1v3.5C6 7.33 6.67 8 7.5 8h4c.83 0 1.5-.67 1.5-1.5V3h.38a2 2 0 0 1 1.41.59l1.62 1.62A2 2 0 0 1 17 6.62V15a2 2 0 0 1-2 2v-5.5c0-.83-.67-1.5-1.5-1.5H9.33a4.5 4.5 0 0 0-6.33.67V5Zm7.56 10.44L12.12 17H14v-5.5a.5.5 0 0 0-.5-.5h-3.26a4.5 4.5 0 0 1 .32 4.44ZM12 3H7v3.5c0 .28.22.5.5.5h4a.5.5 0 0 0 .5-.5V3Zm-2 10.5c0 .79-.26 1.51-.7 2.1l2.55 2.55a.5.5 0 0 1-.7.7L8.6 16.3a3.5 3.5 0 1 1 1.4-2.8Zm-6 0a2.5 2.5 0 1 0 5 0 2.5 2.5 0 0 0-5 0Z"]));
export const SaveSearchRegular = ( /*#__PURE__*/createFluentIcon('SaveSearchRegular', "1em", ["M3 5c0-1.1.9-2 2-2h8.38a2 2 0 0 1 1.41.59l1.62 1.62A2 2 0 0 1 17 6.62V15a2 2 0 0 1-2 2h-2.88l-1-1H14v-4.5a.5.5 0 0 0-.5-.5h-3.26a4.53 4.53 0 0 0-.91-1h4.17c.83 0 1.5.67 1.5 1.5V16a1 1 0 0 0 1-1V6.62a1 1 0 0 0-.3-.7L14.1 4.28a1 1 0 0 0-.71-.29H13v2.5c0 .83-.67 1.5-1.5 1.5h-4A1.5 1.5 0 0 1 6 6.5V4H5a1 1 0 0 0-1 1v4.76a4.52 4.52 0 0 0-1 .91V5Zm4-1v2.5c0 .28.22.5.5.5h4a.5.5 0 0 0 .5-.5V4H7Zm3 9.5c0 .79-.26 1.51-.7 2.1l2.55 2.55a.5.5 0 0 1-.7.7L8.6 16.3a3.5 3.5 0 1 1 1.4-2.8Zm-6 0a2.5 2.5 0 1 0 5 0 2.5 2.5 0 0 0-5 0Z"]));
export const SaveSyncFilled = ( /*#__PURE__*/createFluentIcon('SaveSyncFilled', "1em", ["M3 5c0-1.1.9-2 2-2h1v3.5C6 7.33 6.67 8 7.5 8h4c.83 0 1.5-.67 1.5-1.5V3h.38a2 2 0 0 1 1.41.59l1.62 1.62A2 2 0 0 1 17 6.62V9.6a5.48 5.48 0 0 0-5.66.4H6.5c-.83 0-1.5.67-1.5 1.5V17a2 2 0 0 1-2-2V5Zm6 9.5c0-1.33.47-2.55 1.26-3.5H6.5a.5.5 0 0 0-.5.5V17h3.6c-.38-.75-.6-1.6-.6-2.5ZM12 3H7v3.5c0 .28.22.5.5.5h4a.5.5 0 0 0 .5-.5V3Zm-2 11.5a4.5 4.5 0 1 0 9 0 4.5 4.5 0 0 0-9 0Zm6.5-3c.28 0 .5.22.5.5v1.5a.5.5 0 0 1-.5.5H15a.5.5 0 0 1 0-1h.47a1.97 1.97 0 0 0-.94-.25 2 2 0 0 0-1.44.59.5.5 0 0 1-.71-.71 3 3 0 0 1 3.62-.48V12c0-.28.22-.5.5-.5Zm-.88 5.53a3 3 0 0 1-2.62-.18V17a.5.5 0 0 1-1 0v-1.5c0-.28.22-.5.5-.5H14a.5.5 0 0 1 0 1h-.47a1.97 1.97 0 0 0 .94.25 2 2 0 0 0 1.44-.59.5.5 0 0 1 .71.71 3 3 0 0 1-1 .66Z"]));
export const SaveSyncRegular = ( /*#__PURE__*/createFluentIcon('SaveSyncRegular', "1em", ["M3 5c0-1.1.9-2 2-2h8.38a2 2 0 0 1 1.41.59l1.62 1.62A2 2 0 0 1 17 6.62V9.6c-.32-.16-.65-.3-1-.4V6.63a1 1 0 0 0-.3-.7L14.1 4.28a1 1 0 0 0-.71-.29H13v2.5c0 .83-.67 1.5-1.5 1.5h-4A1.5 1.5 0 0 1 6 6.5V4H5a1 1 0 0 0-1 1v10a1 1 0 0 0 1 1v-4.5c0-.83.67-1.5 1.5-1.5h4.84c-.4.28-.77.62-1.08 1H6.5a.5.5 0 0 0-.5.5V16h3.2c.1.35.24.68.4 1H5a2 2 0 0 1-2-2V5Zm4-1v2.5c0 .28.22.5.5.5h4a.5.5 0 0 0 .5-.5V4H7Zm3 10.5a4.5 4.5 0 1 0 9 0 4.5 4.5 0 0 0-9 0Zm6.5-3c.28 0 .5.22.5.5v1.5a.5.5 0 0 1-.5.5H15a.5.5 0 0 1 0-1h.47a1.97 1.97 0 0 0-.94-.25 2 2 0 0 0-1.44.59.5.5 0 0 1-.71-.71 3 3 0 0 1 3.62-.48V12c0-.28.22-.5.5-.5Zm-.88 5.53a3 3 0 0 1-2.62-.18V17a.5.5 0 0 1-1 0v-1.5c0-.28.22-.5.5-.5H14a.5.5 0 0 1 0 1h-.47a1.97 1.97 0 0 0 .94.25 2 2 0 0 0 1.44-.59.5.5 0 0 1 .71.71 3 3 0 0 1-1 .66Z"]));
export const SavingsColor = ( /*#__PURE__*/createFluentIcon('SavingsColor', "1em", `<path d="M9.83 4.08c3.93 0 8.11 2.22 8.17 6.23a7.42 7.42 0 0 1-2 4.77v1.42c0 .83-.67 1.5-1.5 1.5h-1.38c-.62 0-1.12-.5-1.12-1.12a.12.12 0 0 0-.12-.11h-1.76a.12.12 0 0 0-.12.11C10 17.5 9.5 18 8.88 18H7.5A1.5 1.5 0 0 1 6 16.5v-.54a6.34 6.34 0 0 1-2.56-2.9c-.07-.17-.2-.27-.33-.3-.64-.1-1.11-.65-1.11-1.3V9.95c0-.63.45-1.17 1.08-1.27.11-.02.24-.13.3-.3A5.2 5.2 0 0 1 6 5.47V3.16c0-.35.23-.6.48-.7.25-.1.58-.08.83.15.7.67 1.52 1.36 2.52 1.47Z" fill="url(#ic_fluent_savings_20_color__a)"/><path d="M7.5 8.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Z" fill="url(#ic_fluent_savings_20_color__b)"/><path d="M8.83 6.33a.96.96 0 0 1 1.25-.52l6.37 2.64a.96.96 0 0 1-.73 1.76L9.35 7.58a.96.96 0 0 1-.52-1.25Z" fill="#9F1459"/><path d="M14.7 9.8a3.5 3.5 0 1 0-4.37-1.81l4.36 1.8Z" fill="url(#ic_fluent_savings_20_color__c)"/><path d="M14.7 9.8a3.5 3.5 0 1 0-4.37-1.81l4.36 1.8Z" fill="url(#ic_fluent_savings_20_color__d)" fill-opacity=".8"/><defs><radialGradient id="ic_fluent_savings_20_color__a" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(4.15011 14.67205 -15.06763 4.262 6.9 3.93)"><stop stop-color="#F08AF4"/><stop offset=".58" stop-color="#E869CE"/><stop offset="1" stop-color="#D7257D"/></radialGradient><radialGradient id="ic_fluent_savings_20_color__b" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(59.53 -4.12 9.84) scale(1.27093)"><stop stop-color="#B91D6B"/><stop offset="1" stop-color="#670938"/></radialGradient><linearGradient id="ic_fluent_savings_20_color__c" x1="15.78" y1="9.21" x2="10.27" y2="4.7" gradientUnits="userSpaceOnUse"><stop stop-color="#FF8A69"/><stop offset="1" stop-color="#FFCD0F"/></linearGradient><linearGradient id="ic_fluent_savings_20_color__d" x1="14.42" y1="3.4" x2="11.96" y2="9.08" gradientUnits="userSpaceOnUse"><stop offset=".67" stop-color="#FB5937" stop-opacity="0"/><stop offset="1" stop-color="#CD3E1D"/></linearGradient></defs>`, { color: true }));
export const SavingsFilled = ( /*#__PURE__*/createFluentIcon('SavingsFilled', "1em", ["m9.65 4.06.18.02a4.5 4.5 0 0 0-.7 3.2c.15.98.91 1.6 1.6 1.87l3.03 1.26c.68.29 1.65.39 2.46-.2a4.5 4.5 0 0 0 1.49-1.86c.19.58.29 1.23.29 1.96 0 1.75-.54 2.98-1.09 3.78a4.95 4.95 0 0 1-.91 1v1.41c0 .83-.67 1.5-1.5 1.5h-1.38c-.62 0-1.12-.5-1.12-1.12a.12.12 0 0 0-.12-.11h-1.76a.12.12 0 0 0-.12.11C10 17.5 9.5 18 8.88 18H7.5A1.5 1.5 0 0 1 6 16.5v-.54l-.16-.1c-.28-.18-.69-.5-1.2-1-.62-.64-1-1.34-1.2-1.8-.07-.17-.2-.27-.33-.3-.64-.1-1.11-.65-1.11-1.3V9.95c0-.63.45-1.17 1.08-1.27.11-.02.24-.13.3-.3a4.4 4.4 0 0 1 1-1.71A6.63 6.63 0 0 1 6 5.47v-2.3c0-.36.23-.61.48-.71.25-.1.58-.08.83.15.29.28.68.63 1.11.92.44.3.87.5 1.23.53ZM6.75 9.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm10.29-2.46a3.5 3.5 0 0 1-1.4 2.36c-.43.31-1 .3-1.5.09l-3.03-1.26c-.48-.2-.88-.56-.98-1.05l-.02-.07a3.5 3.5 0 1 1 6.93-.07Z"]));
export const SavingsRegular = ( /*#__PURE__*/createFluentIcon('SavingsRegular', "1em", ["M16.95 9.54c.03.24.05.5.05.77 0 1.53-.46 2.56-.91 3.2a3.96 3.96 0 0 1-.85.89.5.5 0 0 0-.24.43v1.67a.5.5 0 0 1-.5.5h-1.38a.12.12 0 0 1-.12-.12c0-.61-.5-1.11-1.12-1.11h-1.76c-.62 0-1.12.5-1.12 1.11 0 .07-.05.12-.12.12H7.5a.5.5 0 0 1-.5-.5v-.85a.5.5 0 0 0-.34-.47l-.04-.02a6.37 6.37 0 0 1-1.26-1.01 4.99 4.99 0 0 1-1-1.49c-.19-.42-.57-.8-1.09-.88a.33.33 0 0 1-.27-.32V9.95c0-.14.1-.26.24-.29.55-.09.94-.51 1.1-.97.12-.4.36-.93.75-1.32a5.64 5.64 0 0 1 1.58-1.1l.02-.02A.5.5 0 0 0 7 5.79v-2.1c.25.22.55.46.87.67.43.3.95.56 1.48.66.12-.33.28-.65.48-.94l-.18-.02a2.9 2.9 0 0 1-1.23-.53 8.47 8.47 0 0 1-1.11-.92.77.77 0 0 0-.83-.15.76.76 0 0 0-.48.7v2.32a6.9 6.9 0 0 0-1.63 1.19 4.4 4.4 0 0 0-.99 1.7c-.06.18-.19.29-.3.3A1.3 1.3 0 0 0 2 9.96v1.5c0 .66.47 1.2 1.1 1.32.13.02.27.12.34.3.2.45.58 1.15 1.2 1.78A7.34 7.34 0 0 0 6 15.96v.54c0 .83.67 1.5 1.5 1.5h1.38c.62 0 1.12-.5 1.12-1.12 0-.06.05-.11.12-.11h1.76c.07 0 .12.05.12.11 0 .62.5 1.12 1.12 1.12h1.38c.83 0 1.5-.67 1.5-1.5v-1.42c.04-.03.1-.07.14-.12.22-.2.5-.48.77-.87A6.48 6.48 0 0 0 18 10.3c0-.73-.1-1.38-.3-1.96-.18.43-.43.84-.75 1.2Zm-.15-4.3a3.5 3.5 0 0 1-1.17 4.16c-.43.31-1 .29-1.49.09L11.1 8.23c-.49-.2-.9-.6-.99-1.12a3.5 3.5 0 0 1 6.7-1.88Zm-1.76 3.35a2.5 2.5 0 1 0-3.94-1.63c0 .03.03.08.09.15.06.06.16.14.3.2l3.04 1.25c.13.06.26.08.35.08.09 0 .13-.03.16-.05Zm-8.29.91a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z"]));
export const ScaleFillFilled = ( /*#__PURE__*/createFluentIcon('ScaleFillFilled', "1em", ["M3 5c0-1.1.9-2 2-2h10a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5Zm3.3 1.04a.5.5 0 0 0-.3.46v2a.5.5 0 0 0 1 0v-.8l1.15 1.15a.5.5 0 1 0 .7-.7L7.71 7h.79a.5.5 0 0 0 0-1h-2a.5.5 0 0 0-.2.04ZM6 11.5v2a.5.5 0 0 0 .14.35.5.5 0 0 0 .36.15h2a.5.5 0 0 0 0-1h-.8l1.15-1.15a.5.5 0 0 0-.7-.7L7 12.29v-.79a.5.5 0 0 0-1 0Zm7.85-5.36A.5.5 0 0 0 13.5 6h-2a.5.5 0 0 0 0 1h.8l-1.15 1.15a.5.5 0 0 0 .7.7L13 7.71v.79a.5.5 0 0 0 1 0v-2a.5.5 0 0 0-.14-.35Zm-.16 7.82a.5.5 0 0 0 .3-.46v-2a.5.5 0 0 0-.99 0v.8l-1.15-1.15a.5.5 0 0 0-.7.7L12.29 13h-.79a.5.5 0 0 0 0 1h2a.5.5 0 0 0 .2-.04Z"]));
export const ScaleFillRegular = ( /*#__PURE__*/createFluentIcon('ScaleFillRegular', "1em", ["M6 6.5a.5.5 0 0 1 .14-.35A.5.5 0 0 1 6.5 6h2a.5.5 0 0 1 0 1h-.8l1.15 1.15a.5.5 0 1 1-.7.7L7 7.71v.79a.5.5 0 0 1-1 0v-2Zm.04 7.2a.5.5 0 0 1-.04-.2v-2a.5.5 0 0 1 1 0v.8l1.15-1.15a.5.5 0 0 1 .7.7L7.71 13h.79a.5.5 0 0 1 0 1h-2a.5.5 0 0 1-.46-.3Zm7.65-7.66a.5.5 0 0 1 .3.46v2a.5.5 0 0 1-.99 0v-.8l-1.15 1.15a.5.5 0 0 1-.7-.7L12.29 7h-.79a.5.5 0 0 1 0-1h2a.5.5 0 0 1 .2.04Zm.16 7.82a.5.5 0 0 1-.35.14h-2a.5.5 0 0 1 0-1h.8l-1.15-1.15a.5.5 0 0 1 .7-.7L13 12.29v-.79a.5.5 0 0 1 1 0v2a.5.5 0 0 1-.14.35ZM3 5c0-1.1.9-2 2-2h10a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5Zm2-1a1 1 0 0 0-1 1v10a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1H5Z"]));
export const ScaleFitFilled = ( /*#__PURE__*/createFluentIcon('ScaleFitFilled', "1em", ["M2 6v8c0 1.1.9 2 2 2h12a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2Zm11.12 6.08a.5.5 0 0 1 .05-.7l1-.88H11.5a.5.5 0 0 1 0-1h2.67l-1-.87a.5.5 0 0 1 .66-.76l2 1.75a.5.5 0 0 1 0 .76l-2 1.75a.5.5 0 0 1-.7-.05ZM6.88 7.92a.5.5 0 0 1-.05.7l-1 .88H8.5a.5.5 0 0 1 0 1H5.83l1 .87a.5.5 0 0 1-.66.76l-2-1.75a.5.5 0 0 1 0-.76l2-1.75a.5.5 0 0 1 .7.05Z"]));
export const ScaleFitRegular = ( /*#__PURE__*/createFluentIcon('ScaleFitRegular', "1em", ["M6.88 7.92a.5.5 0 0 1-.05.7l-1 .88H8.5a.5.5 0 0 1 0 1H5.83l1 .87a.5.5 0 1 1-.66.76l-2-1.75a.5.5 0 0 1 0-.76l2-1.75a.5.5 0 0 1 .7.05Zm7.29 2.58-1 .87a.5.5 0 0 0 .66.76l2-1.75a.5.5 0 0 0 0-.76l-2-1.75a.5.5 0 0 0-.66.76l1 .87H11.5a.5.5 0 0 0 0 1h2.67ZM2 6c0-1.1.9-2 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V6Zm2-1a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H4Z"]));
export const ScalesFilled = ( /*#__PURE__*/createFluentIcon('ScalesFilled', "1em", ["M3.5 3a.5.5 0 1 0 0 1h.75L2.08 9.22a.95.95 0 0 0-.08.4 3 3 0 0 0 6 0 .95.95 0 0 0-.08-.4L5.75 4H9.5v11h-4a1.5 1.5 0 0 0 0 3h9a1.5 1.5 0 0 0 0-3h-4V4h3.75l-2.17 5.22a.96.96 0 0 0-.08.4 3 3 0 0 0 6 0 .96.96 0 0 0-.08-.4L15.75 4h.75a.5.5 0 0 0 0-1h-13ZM5 4.8 6.75 9h-3.5L5 4.8ZM16.75 9h-3.5L15 4.8 16.75 9Z"]));
export const ScalesRegular = ( /*#__PURE__*/createFluentIcon('ScalesRegular', "1em", ["M3.5 3a.5.5 0 1 0 0 1h.75L2.08 9.22a.95.95 0 0 0-.08.4 3 3 0 0 0 6 0 .95.95 0 0 0-.08-.4L5.75 4H9.5v10H6a2 2 0 1 0 0 4h8a2 2 0 0 0 0-4h-3.5V4h3.75l-2.17 5.22a.96.96 0 0 0-.08.4 3 3 0 0 0 6 0 .96.96 0 0 0-.08-.4L15.75 4h.75a.5.5 0 0 0 0-1h-13ZM5 11.5A2 2 0 0 1 3.06 10h3.88A2 2 0 0 1 5 11.5Zm0-6.7L6.75 9h-3.5L5 4.8ZM6 15h8a1 1 0 0 1 0 2H6a1 1 0 1 1 0-2Zm10.75-6h-3.5L15 4.8 16.75 9Zm-3.69 1h3.88a2 2 0 0 1-3.88 0Z"]));
export const ScanFilled = ( /*#__PURE__*/createFluentIcon('ScanFilled', "1em", ["M9.7 3.5 7.02 8.19l-.18.33-1.65-2.87A6.48 6.48 0 0 1 9.7 3.51ZM8.28 9l.03-.05a2 2 0 0 1 3.43.05l.03.06a2 2 0 0 1-.03 1.94l-.03.05A2 2 0 0 1 8.27 11l-.03-.06A2 2 0 0 1 8.27 9Zm-1.35 2.67.2.33h-3.3a6.5 6.5 0 0 1 .41-5l2.7 4.67ZM10 13.5l.3-.01-1.66 2.87a6.5 6.5 0 0 1-4.12-2.86H10Zm2.99-1.68.18-.33 1.65 2.87a6.48 6.48 0 0 1-4.53 2.13l2.7-4.67Zm.09-3.49a3.52 3.52 0 0 0-.2-.33h3.3a6.5 6.5 0 0 1-.41 5l-2.7-4.67ZM10 6.5l-.3.01 1.66-2.87a6.5 6.5 0 0 1 4.12 2.86H10ZM10 2a8 8 0 1 0 0 16 8 8 0 0 0 0-16Z"]));
export const ScanRegular = ( /*#__PURE__*/createFluentIcon('ScanRegular', "1em", ["M4.91 5.19a6.98 6.98 0 0 1 5.65-2.17L7.4 8.5c-.1.18-.19.36-.25.56L4.91 5.2Zm-.67.83 3.12 5.4a3 3 0 0 0 .4.58H3.3a7 7 0 0 1 .95-5.98ZM8.27 11l-.04-.06A2 2 0 0 1 11.73 9l.04.06A2 2 0 0 1 8.27 11Zm1.12-3.94 2.23-3.87c2.08.5 3.8 1.92 4.7 3.81H10c-.21 0-.42.02-.61.06Zm2.85.94h4.47a7 7 0 0 1-.95 5.98l-3.12-5.4c-.1-.2-.25-.4-.4-.58Zm.61 2.94 2.24 3.87a6.98 6.98 0 0 1-5.65 2.17l3.16-5.48c.1-.18.19-.36.25-.56Zm-2.24 2L8.38 16.8A7.01 7.01 0 0 1 3.68 13H10c.21 0 .42-.02.61-.06ZM10 2a8 8 0 1 0 0 16 8 8 0 0 0 0-16Z"]));
export const ScanCameraFilled = ( /*#__PURE__*/createFluentIcon('ScanCameraFilled', "1em", ["M4.5 3.5a1 1 0 0 0-1 1v2.25a.75.75 0 0 1-1.5 0V4.5A2.5 2.5 0 0 1 4.5 2h2.25a.75.75 0 0 1 0 1.5H4.5Zm0 13a1 1 0 0 1-1-1v-2.25a.75.75 0 0 0-1.5 0v2.25A2.5 2.5 0 0 0 4.5 18h2.25a.75.75 0 0 0 0-1.5H4.5Zm12-12a1 1 0 0 0-1-1h-2.25a.75.75 0 0 1 0-1.5h2.25A2.5 2.5 0 0 1 18 4.5v2.25a.75.75 0 0 1-1.5 0V4.5Zm-1 12a1 1 0 0 0 1-1v-2.25a.75.75 0 0 1 1.5 0v2.25a2.5 2.5 0 0 1-2.5 2.5h-2.25a.75.75 0 0 1 0-1.5h2.25Zm-4.25-6.2c0 .69-.56 1.24-1.25 1.24s-1.25-.55-1.25-1.23c0-.68.56-1.23 1.25-1.23s1.25.55 1.25 1.23ZM5 9.09v3.69c0 .68.56 1.23 1.25 1.23h7.5c.69 0 1.25-.55 1.25-1.23v-3.7c0-.67-.56-1.22-1.25-1.22H12.5l-.88-1.3A1.26 1.26 0 0 0 10.58 6H9.42c-.42 0-.8.2-1.04.55l-.88 1.3H6.25C5.56 7.85 5 8.4 5 9.08Zm5-1.23c1.38 0 2.5 1.1 2.5 2.46a2.48 2.48 0 0 1-2.5 2.46c-1.38 0-2.5-1.1-2.5-2.46A2.48 2.48 0 0 1 10 7.85Z"]));
export const ScanCameraRegular = ( /*#__PURE__*/createFluentIcon('ScanCameraRegular', "1em", ["M4.5 3C3.67 3 3 3.67 3 4.5v2a.5.5 0 0 1-1 0v-2A2.5 2.5 0 0 1 4.5 2h2a.5.5 0 0 1 0 1h-2Zm0 14A1.5 1.5 0 0 1 3 15.5v-2a.5.5 0 0 0-1 0v2A2.5 2.5 0 0 0 4.5 18h2a.5.5 0 0 0 0-1h-2ZM17 4.5c0-.83-.67-1.5-1.5-1.5h-2a.5.5 0 0 1 0-1h2A2.5 2.5 0 0 1 18 4.5v2a.5.5 0 0 1-1 0v-2ZM15.5 17c.83 0 1.5-.67 1.5-1.5v-2a.5.5 0 0 1 1 0v2a2.5 2.5 0 0 1-2.5 2.5h-2a.5.5 0 0 1 0-1h2Zm-4.25-6.7c0 .69-.56 1.24-1.25 1.24s-1.25-.55-1.25-1.23c0-.68.56-1.23 1.25-1.23s1.25.55 1.25 1.23ZM5 9.09v3.69c0 .68.56 1.23 1.25 1.23h7.5c.69 0 1.25-.55 1.25-1.23v-3.7c0-.67-.56-1.22-1.25-1.22H12.5l-.88-1.3A1.26 1.26 0 0 0 10.58 6H9.42c-.42 0-.8.2-1.04.55l-.88 1.3H6.25C5.56 7.85 5 8.4 5 9.08Zm5-1.23c1.38 0 2.5 1.1 2.5 2.46a2.48 2.48 0 0 1-2.5 2.46c-1.38 0-2.5-1.1-2.5-2.46A2.48 2.48 0 0 1 10 7.85Z"]));
export const ScanDashFilled = ( /*#__PURE__*/createFluentIcon('ScanDashFilled', "1em", ["M4.5 3.5a1 1 0 0 0-1 1v2.25a.75.75 0 0 1-1.5 0V4.5A2.5 2.5 0 0 1 4.5 2h2.25a.75.75 0 0 1 0 1.5H4.5Zm0 13a1 1 0 0 1-1-1v-2.25a.75.75 0 0 0-1.5 0v2.25A2.5 2.5 0 0 0 4.5 18h2.25a.75.75 0 0 0 0-1.5H4.5Zm12-12a1 1 0 0 0-1-1h-2.25a.75.75 0 0 1 0-1.5h2.25A2.5 2.5 0 0 1 18 4.5v2.25a.75.75 0 0 1-1.5 0V4.5Zm-1 12a1 1 0 0 0 1-1v-2.25a.75.75 0 0 1 1.5 0v2.25a2.5 2.5 0 0 1-2.5 2.5h-2.25a.75.75 0 0 1 0-1.5h2.25ZM6 10c0-.41.34-.75.75-.75h6.5a.75.75 0 0 1 0 1.5h-6.5A.75.75 0 0 1 6 10Z"]));
export const ScanDashRegular = ( /*#__PURE__*/createFluentIcon('ScanDashRegular', "1em", ["M4.5 3C3.67 3 3 3.67 3 4.5v2a.5.5 0 0 1-1 0v-2A2.5 2.5 0 0 1 4.5 2h2a.5.5 0 0 1 0 1h-2Zm0 14A1.5 1.5 0 0 1 3 15.5v-2a.5.5 0 0 0-1 0v2A2.5 2.5 0 0 0 4.5 18h2a.5.5 0 0 0 0-1h-2ZM17 4.5c0-.83-.67-1.5-1.5-1.5h-2a.5.5 0 0 1 0-1h2A2.5 2.5 0 0 1 18 4.5v2a.5.5 0 0 1-1 0v-2ZM15.5 17c.83 0 1.5-.67 1.5-1.5v-2a.5.5 0 0 1 1 0v2a2.5 2.5 0 0 1-2.5 2.5h-2a.5.5 0 0 1 0-1h2ZM6 10c0-.28.22-.5.5-.5h7a.5.5 0 0 1 0 1h-7A.5.5 0 0 1 6 10Z"]));
export const ScanObjectFilled = ( /*#__PURE__*/createFluentIcon('ScanObjectFilled', "1em", ["M4.5 3C3.67 3 3 3.67 3 4.5v2a.5.5 0 0 1-1 0v-2A2.5 2.5 0 0 1 4.5 2h2a.5.5 0 0 1 0 1h-2Zm6.73 3.9a1.5 1.5 0 0 0-2.46 0l-2.6 3.75A1.5 1.5 0 0 0 7.42 13h5.18a1.5 1.5 0 0 0 1.23-2.35L11.23 6.9ZM3 15.5c0 .83.67 1.5 1.5 1.5h2a.5.5 0 0 1 0 1h-2A2.5 2.5 0 0 1 2 15.5v-2a.5.5 0 0 1 1 0v2ZM15.5 3c.83 0 1.5.67 1.5 1.5v2a.5.5 0 0 0 1 0v-2A2.5 2.5 0 0 0 15.5 2h-2a.5.5 0 0 0 0 1h2ZM17 15.5c0 .83-.67 1.5-1.5 1.5h-2a.5.5 0 0 0 0 1h2a2.5 2.5 0 0 0 2.5-2.5v-2a.5.5 0 0 0-1 0v2Z"]));
export const ScanObjectRegular = ( /*#__PURE__*/createFluentIcon('ScanObjectRegular', "1em", ["M4.5 3C3.67 3 3 3.67 3 4.5v2a.5.5 0 0 1-1 0v-2A2.5 2.5 0 0 1 4.5 2h2a.5.5 0 0 1 0 1h-2Zm0 14A1.5 1.5 0 0 1 3 15.5v-2a.5.5 0 0 0-1 0v2A2.5 2.5 0 0 0 4.5 18h2a.5.5 0 0 0 0-1h-2ZM17 4.5c0-.83-.67-1.5-1.5-1.5h-2a.5.5 0 0 1 0-1h2A2.5 2.5 0 0 1 18 4.5v2a.5.5 0 0 1-1 0v-2ZM15.5 17c.83 0 1.5-.67 1.5-1.5v-2a.5.5 0 0 1 1 0v2a2.5 2.5 0 0 1-2.5 2.5h-2a.5.5 0 0 1 0-1h2ZM8.77 6.9a1.5 1.5 0 0 1 2.46 0l2.6 3.75A1.5 1.5 0 0 1 12.58 13H7.41a1.5 1.5 0 0 1-1.23-2.35L8.77 6.9Zm1.64.57a.5.5 0 0 0-.82 0l-2.6 3.75a.5.5 0 0 0 .42.78h5.18a.5.5 0 0 0 .41-.78l-2.59-3.75Z"]));
export const ScanPersonColor = ( /*#__PURE__*/createFluentIcon('ScanPersonColor', "1em", `<path d="M4 16c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v1H4v-1Z" fill="url(#ic_fluent_scan_person_20_color__a)"/><path d="M4 16c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v1H4v-1Z" fill="url(#ic_fluent_scan_person_20_color__b)"/><path d="M10 12a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7Z" fill="url(#ic_fluent_scan_person_20_color__c)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M4.5 4a.5.5 0 0 0-.5.5V7a1 1 0 0 1-2 0V4.5A2.5 2.5 0 0 1 4.5 2H7a1 1 0 0 1 0 2H4.5ZM12 3a1 1 0 0 1 1-1h2.5A2.5 2.5 0 0 1 18 4.5V7a1 1 0 1 1-2 0V4.5a.5.5 0 0 0-.5-.5H13a1 1 0 0 1-1-1Zm-9 9a1 1 0 0 1 1 1v2.5c0 .28.22.5.5.5H7a1 1 0 1 1 0 2H4.5A2.5 2.5 0 0 1 2 15.5V13a1 1 0 0 1 1-1Zm14 0a1 1 0 0 1 1 1v2.5a2.5 2.5 0 0 1-2.5 2.5H13a1 1 0 1 1 0-2h2.5a.5.5 0 0 0 .5-.5V13a1 1 0 0 1 1-1Z" fill="url(#ic_fluent_scan_person_20_color__d)"/><defs><linearGradient id="ic_fluent_scan_person_20_color__a" x1="6.85" y1="14.4" x2="7.37" y2="17.72" gradientUnits="userSpaceOnUse"><stop offset=".13" stop-color="#9C6CFE"/><stop offset="1" stop-color="#7A41DC"/></linearGradient><linearGradient id="ic_fluent_scan_person_20_color__b" x1="10" y1="13.64" x2="10.71" y2="18.98" gradientUnits="userSpaceOnUse"><stop stop-color="#885EDB" stop-opacity="0"/><stop offset="1" stop-color="#E362F8"/></linearGradient><linearGradient id="ic_fluent_scan_person_20_color__c" x1="8.16" y1="5.93" x2="11.73" y2="11.63" gradientUnits="userSpaceOnUse"><stop offset=".13" stop-color="#9C6CFE"/><stop offset="1" stop-color="#7A41DC"/></linearGradient><linearGradient id="ic_fluent_scan_person_20_color__d" x1="1.37" y1=".66" x2="13.91" y2="20.93" gradientUnits="userSpaceOnUse"><stop offset=".02" stop-color="#3DCBFF"/><stop offset="1" stop-color="#0094F0"/></linearGradient></defs>`, { color: true }));
export const ScanPersonFilled = ( /*#__PURE__*/createFluentIcon('ScanPersonFilled', "1em", ["M4.5 3C3.67 3 3 3.67 3 4.5v2a.5.5 0 0 1-1 0v-2A2.5 2.5 0 0 1 4.5 2h2a.5.5 0 0 1 0 1h-2Zm0 14A1.5 1.5 0 0 1 3 15.5v-2a.5.5 0 0 0-1 0v2A2.5 2.5 0 0 0 4.5 18h2a.5.5 0 0 0 0-1h-2ZM17 4.5c0-.83-.67-1.5-1.5-1.5h-2a.5.5 0 0 1 0-1h2A2.5 2.5 0 0 1 18 4.5v2a.5.5 0 0 1-1 0v-2ZM15.5 17c.83 0 1.5-.67 1.5-1.5v-2a.5.5 0 0 1 1 0v2a2.5 2.5 0 0 1-2.5 2.5h-2a.5.5 0 0 1 0-1h2Zm-7.58 0c-.21-.58-.77-1-1.42-1h-2a.5.5 0 0 1-.47-.33A2 2 0 0 1 6 14h8a2 2 0 0 1 1.97 1.66.5.5 0 0 1-.47.34h-2c-.65 0-1.2.42-1.41 1H7.92ZM10 12a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7Z"]));
export const ScanPersonRegular = ( /*#__PURE__*/createFluentIcon('ScanPersonRegular', "1em", ["M4.5 3C3.67 3 3 3.67 3 4.5v2a.5.5 0 0 1-1 0v-2A2.5 2.5 0 0 1 4.5 2h2a.5.5 0 0 1 0 1h-2Zm0 14A1.5 1.5 0 0 1 3 15.5v-2a.5.5 0 0 0-1 0v2A2.5 2.5 0 0 0 4.5 18h2a.5.5 0 0 0 0-1h-2ZM17 4.5c0-.83-.67-1.5-1.5-1.5h-2a.5.5 0 0 1 0-1h2A2.5 2.5 0 0 1 18 4.5v2a.5.5 0 0 1-1 0v-2Zm-1.12 12.45a1.5 1.5 0 0 1-.38.05h-2a.5.5 0 0 0 0 1h2a2.5 2.5 0 0 0 2.5-2.5v-2a.5.5 0 0 0-1 0v2c0 .7-.47 1.28-1.12 1.45ZM5 16h-.5a.5.5 0 0 1-.47-.33A2 2 0 0 1 6 14h8a2 2 0 0 1 1.97 1.66.5.5 0 0 1-.47.34H15a1 1 0 0 0-1-1H6a1 1 0 0 0-1 1Zm7.5-7.5a2.5 2.5 0 1 0-5 0 2.5 2.5 0 0 0 5 0Zm1 0a3.5 3.5 0 1 1-7 0 3.5 3.5 0 0 1 7 0Z"]));
export const ScanTableFilled = ( /*#__PURE__*/createFluentIcon('ScanTableFilled', "1em", ["M4.5 3C3.67 3 3 3.67 3 4.5v2a.5.5 0 0 1-1 0v-2A2.5 2.5 0 0 1 4.5 2h2a.5.5 0 0 1 0 1h-2Zm0 14A1.5 1.5 0 0 1 3 15.5v-2a.5.5 0 0 0-1 0v2A2.5 2.5 0 0 0 4.5 18h2a.5.5 0 0 0 0-1h-2ZM17 4.5c0-.83-.67-1.5-1.5-1.5h-2a.5.5 0 0 1 0-1h2A2.5 2.5 0 0 1 18 4.5v2a.5.5 0 0 1-1 0v-2ZM15.5 17c.83 0 1.5-.67 1.5-1.5v-2a.5.5 0 0 1 1 0v2a2.5 2.5 0 0 1-2.5 2.5h-2a.5.5 0 0 1 0-1h2ZM7 5a2 2 0 0 0-2 2v1h10V7a2 2 0 0 0-2-2H7Zm-2 8V9h10v4a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2Z"]));
export const ScanTableRegular = ( /*#__PURE__*/createFluentIcon('ScanTableRegular', "1em", ["M4.5 3C3.67 3 3 3.67 3 4.5v2a.5.5 0 0 1-1 0v-2A2.5 2.5 0 0 1 4.5 2h2a.5.5 0 0 1 0 1h-2Zm0 14A1.5 1.5 0 0 1 3 15.5v-2a.5.5 0 0 0-1 0v2A2.5 2.5 0 0 0 4.5 18h2a.5.5 0 0 0 0-1h-2ZM17 4.5c0-.83-.67-1.5-1.5-1.5h-2a.5.5 0 0 1 0-1h2A2.5 2.5 0 0 1 18 4.5v2a.5.5 0 0 1-1 0v-2ZM15.5 17c.83 0 1.5-.67 1.5-1.5v-2a.5.5 0 0 1 1 0v2a2.5 2.5 0 0 1-2.5 2.5h-2a.5.5 0 0 1 0-1h2ZM5 7c0-1.1.9-2 2-2h6a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V7Zm2-1a1 1 0 0 0-1 1v1h8V7a1 1 0 0 0-1-1H7Zm-1 7a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V9H6v4Z"]));
export const ScanTextFilled = ( /*#__PURE__*/createFluentIcon('ScanTextFilled', "1em", ["M4.5 3.5a1 1 0 0 0-1 1v2.25a.75.75 0 0 1-1.5 0V4.5A2.5 2.5 0 0 1 4.5 2h2.25a.75.75 0 0 1 0 1.5H4.5Zm0 13a1 1 0 0 1-1-1v-2.25a.75.75 0 0 0-1.5 0v2.25A2.5 2.5 0 0 0 4.5 18h2.25a.75.75 0 0 0 0-1.5H4.5Zm12-12a1 1 0 0 0-1-1h-2.25a.75.75 0 0 1 0-1.5h2.25A2.5 2.5 0 0 1 18 4.5v2.25a.75.75 0 0 1-1.5 0V4.5Zm-1 12a1 1 0 0 0 1-1v-2.25a.75.75 0 0 1 1.5 0v2.25a2.5 2.5 0 0 1-2.5 2.5h-2.25a.75.75 0 0 1 0-1.5h2.25ZM6 6.75c0-.41.34-.75.75-.75h6.5a.75.75 0 0 1 0 1.5h-6.5A.75.75 0 0 1 6 6.75ZM6.75 9a.75.75 0 0 0 0 1.5h6.5a.75.75 0 0 0 0-1.5h-6.5ZM6 12.75c0-.41.34-.75.75-.75h3.5a.75.75 0 0 1 0 1.5h-3.5a.75.75 0 0 1-.75-.75Z"]));
export const ScanTextRegular = ( /*#__PURE__*/createFluentIcon('ScanTextRegular', "1em", ["M4.5 3C3.67 3 3 3.67 3 4.5v2a.5.5 0 0 1-1 0v-2A2.5 2.5 0 0 1 4.5 2h2a.5.5 0 0 1 0 1h-2Zm0 14A1.5 1.5 0 0 1 3 15.5v-2a.5.5 0 0 0-1 0v2A2.5 2.5 0 0 0 4.5 18h2a.5.5 0 0 0 0-1h-2ZM17 4.5c0-.83-.67-1.5-1.5-1.5h-2a.5.5 0 0 1 0-1h2A2.5 2.5 0 0 1 18 4.5v2a.5.5 0 0 1-1 0v-2ZM15.5 17c.83 0 1.5-.67 1.5-1.5v-2a.5.5 0 0 1 1 0v2a2.5 2.5 0 0 1-2.5 2.5h-2a.5.5 0 0 1 0-1h2Zm-9-11a.5.5 0 0 0 0 1h7a.5.5 0 0 0 0-1h-7Zm0 3a.5.5 0 0 0 0 1h7a.5.5 0 0 0 0-1h-7ZM6 12.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z"]));
export const ScanThumbUpFilled = ( /*#__PURE__*/createFluentIcon('ScanThumbUpFilled', "1em", ["M4.5 3C3.67 3 3 3.67 3 4.5v2a.5.5 0 0 1-1 0v-2A2.5 2.5 0 0 1 4.5 2h2a.5.5 0 0 1 0 1h-2Zm0 14A1.5 1.5 0 0 1 3 15.5v-2a.5.5 0 0 0-1 0v2A2.5 2.5 0 0 0 4.5 18h2a.5.5 0 0 0 0-1h-2ZM17 4.5c0-.83-.67-1.5-1.5-1.5h-2a.5.5 0 0 1 0-1h2A2.5 2.5 0 0 1 18 4.5v2a.5.5 0 0 1-1 0v-2ZM15.5 17c.83 0 1.5-.67 1.5-1.5v-2a.5.5 0 0 1 1 0v2a2.5 2.5 0 0 1-2.5 2.5h-2a.5.5 0 0 1 0-1h2ZM11.15 4.55c-.83-.23-1.43.38-1.63.85-.15.36-.28.61-.45.94l-.37.71a4.98 4.98 0 0 1-1.04 1.43l-1.24.7a1.76 1.76 0 0 0-.8 2.18l.35.9c.2.51.65.9 1.18 1.06l3.61 1.08A2.2 2.2 0 0 0 13.5 13l.92-3c.36-1.17-.56-2.3-1.77-2.3h-.28c.08-.34.14-.74.14-1.1-.01-.34-.04-.76-.23-1.15a1.68 1.68 0 0 0-1.13-.9Z"]));
export const ScanThumbUpRegular = ( /*#__PURE__*/createFluentIcon('ScanThumbUpRegular', "1em", ["M4.5 3C3.67 3 3 3.67 3 4.5v2a.5.5 0 0 1-1 0v-2A2.5 2.5 0 0 1 4.5 2h2a.5.5 0 0 1 0 1h-2Zm0 14A1.5 1.5 0 0 1 3 15.5v-2a.5.5 0 0 0-1 0v2A2.5 2.5 0 0 0 4.5 18h2a.5.5 0 0 0 0-1h-2ZM17 4.5c0-.83-.67-1.5-1.5-1.5h-2a.5.5 0 0 1 0-1h2A2.5 2.5 0 0 1 18 4.5v2a.5.5 0 0 1-1 0v-2ZM15.5 17c.83 0 1.5-.67 1.5-1.5v-2a.5.5 0 0 1 1 0v2a2.5 2.5 0 0 1-2.5 2.5h-2a.5.5 0 0 1 0-1h2ZM9.52 5.4c.2-.47.8-1.08 1.63-.85.54.14.92.46 1.13.9.19.39.22.81.23 1.15 0 .36-.06.76-.14 1.1h.28c1.2 0 2.13 1.13 1.77 2.3l-.92 3a2.2 2.2 0 0 1-2.74 1.4l-3.6-1.08a1.82 1.82 0 0 1-1.19-1.07l-.35-.89c-.32-.83.03-1.74.8-2.18l1.24-.7.03-.02c.04-.04.12-.1.22-.21.2-.22.5-.6.79-1.2l.36-.71c.18-.33.3-.58.46-.94ZM8.15 9.35l-1.24.7c-.36.2-.5.6-.36.94l.35.9c.09.22.28.4.54.47l3.6 1.09a1.2 1.2 0 0 0 1.5-.75l.93-3c.14-.46-.22-1-.82-1h-.93a.5.5 0 0 1-.48-.64l.12-.45c.09-.35.15-.71.15-.99 0-.3-.04-.55-.13-.73a.69.69 0 0 0-.48-.38.3.3 0 0 0-.26.04.53.53 0 0 0-.2.23c-.17.4-.32.7-.49 1.02l-.35.7a5.97 5.97 0 0 1-1.28 1.73l-.1.08H8.2l-.01.01a.5.5 0 0 1-.05.03Z"]));
export const ScanThumbUpOffFilled = ( /*#__PURE__*/createFluentIcon('ScanThumbUpOffFilled', "1em", ["M2.41 3.12C2.15 3.52 2 4 2 4.5v2a.5.5 0 0 0 1 0v-2c0-.23.05-.45.15-.65l4.57 4.58a1.42 1.42 0 0 1-.06.05l-1.24.7a1.76 1.76 0 0 0-.8 2.18l.35.9c.2.51.65.9 1.18 1.06l3.61 1.08c.85.26 1.75-.01 2.3-.63l3.09 3.08c-.2.1-.42.15-.65.15h-2a.5.5 0 0 0 0 1h2c.5 0 .98-.15 1.38-.41l.27.26a.5.5 0 0 0 .7-.7l-15-15a.5.5 0 1 0-.7.7l.26.27Zm6.45 3.62 5.02 5.02.54-1.76c.36-1.17-.56-2.3-1.77-2.3h-.28c.08-.34.14-.74.14-1.1-.01-.34-.04-.76-.23-1.15a1.68 1.68 0 0 0-1.13-.9c-.83-.23-1.43.38-1.63.85-.15.36-.28.61-.45.94a37 37 0 0 0-.21.4ZM17 14.88l.98.97.02-.35v-2a.5.5 0 0 0-1 0v1.38ZM4.15 2.02l.97.98H6.5a.5.5 0 0 0 0-1h-2c-.12 0-.24 0-.35.02ZM4.5 17A1.5 1.5 0 0 1 3 15.5v-2a.5.5 0 0 0-1 0v2A2.5 2.5 0 0 0 4.5 18h2a.5.5 0 0 0 0-1h-2ZM17 4.5c0-.83-.67-1.5-1.5-1.5h-2a.5.5 0 0 1 0-1h2A2.5 2.5 0 0 1 18 4.5v2a.5.5 0 0 1-1 0v-2Z"]));
export const ScanThumbUpOffRegular = ( /*#__PURE__*/createFluentIcon('ScanThumbUpOffRegular', "1em", ["M2.41 3.12C2.15 3.52 2 4 2 4.5v2a.5.5 0 0 0 1 0v-2c0-.23.05-.45.15-.65l4.57 4.58a1.42 1.42 0 0 1-.06.05l-1.24.7a1.76 1.76 0 0 0-.8 2.18l.35.9c.2.51.65.9 1.18 1.06l3.61 1.08c.85.26 1.75-.01 2.3-.63l3.09 3.08c-.2.1-.42.15-.65.15h-2a.5.5 0 0 0 0 1h2c.5 0 .98-.15 1.38-.41l.27.26a.5.5 0 0 0 .7-.7l-15-15a.5.5 0 1 0-.7.7l.26.27Zm9.94 9.94c-.29.36-.8.54-1.3.39l-3.61-1.09a.82.82 0 0 1-.54-.48L6.55 11a.76.76 0 0 1 .36-.94l1.24-.7a.5.5 0 0 0 .04-.02h.01v-.01l.02-.01a1.79 1.79 0 0 0 .21-.17l3.92 3.92Zm-3.5-6.32.75.74.35-.68c.17-.32.32-.61.5-1.02.03-.08.1-.17.19-.23a.3.3 0 0 1 .26-.04c.26.07.4.2.48.38.09.18.12.43.13.73 0 .28-.06.64-.15.99-.03.16-.08.31-.12.45a.5.5 0 0 0 .48.65h.93c.6 0 .96.53.82 1l-.39 1.25.8.8.54-1.76c.36-1.17-.56-2.3-1.77-2.3h-.28c.08-.34.14-.74.14-1.1-.01-.34-.04-.76-.23-1.15a1.68 1.68 0 0 0-1.13-.9c-.83-.23-1.43.38-1.63.85-.15.36-.28.61-.45.94l-.21.4ZM17 14.88l.98.97.02-.35v-2a.5.5 0 0 0-1 0v1.38ZM4.15 2.02l.97.98H6.5a.5.5 0 0 0 0-1h-2c-.12 0-.24 0-.35.02ZM4.5 17A1.5 1.5 0 0 1 3 15.5v-2a.5.5 0 0 0-1 0v2A2.5 2.5 0 0 0 4.5 18h2a.5.5 0 0 0 0-1h-2ZM17 4.5c0-.83-.67-1.5-1.5-1.5h-2a.5.5 0 0 1 0-1h2A2.5 2.5 0 0 1 18 4.5v2a.5.5 0 0 1-1 0v-2Z"]));
export const ScanTypeColor = ( /*#__PURE__*/createFluentIcon('ScanTypeColor', "1em", `<path fill-rule="evenodd" clip-rule="evenodd" d="M8 8a1 1 0 0 1-2 0v-.75C6 6.56 6.56 6 7.25 6h5.5c.69 0 1.25.56 1.25 1.25V8a1 1 0 1 1-2 0h-1v4h.5a1 1 0 1 1 0 2h-3a1 1 0 1 1 0-2H9V8H8Z" fill="url(#ic_fluent_scan_type_20_color__a)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M4.5 4a.5.5 0 0 0-.5.5V7a1 1 0 0 1-2 0V4.5A2.5 2.5 0 0 1 4.5 2H7a1 1 0 0 1 0 2H4.5ZM12 3a1 1 0 0 1 1-1h2.5A2.5 2.5 0 0 1 18 4.5V7a1 1 0 1 1-2 0V4.5a.5.5 0 0 0-.5-.5H13a1 1 0 0 1-1-1Zm-9 9a1 1 0 0 1 1 1v2.5c0 .28.22.5.5.5H7a1 1 0 1 1 0 2H4.5A2.5 2.5 0 0 1 2 15.5V13a1 1 0 0 1 1-1Zm14 0a1 1 0 0 1 1 1v2.5a2.5 2.5 0 0 1-2.5 2.5H13a1 1 0 1 1 0-2h2.5a.5.5 0 0 0 .5-.5V13a1 1 0 0 1 1-1Z" fill="url(#ic_fluent_scan_type_20_color__b)"/><defs><linearGradient id="ic_fluent_scan_type_20_color__a" x1="5.29" y1="5" x2="13.86" y2="14.49" gradientUnits="userSpaceOnUse"><stop stop-color="#0094F0"/><stop offset=".54" stop-color="#0078D4"/><stop offset="1" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_scan_type_20_color__b" x1="1.37" y1=".66" x2="13.91" y2="20.93" gradientUnits="userSpaceOnUse"><stop offset=".02" stop-color="#3DCBFF"/><stop offset="1" stop-color="#0094F0"/></linearGradient></defs>`, { color: true }));
export const ScanTypeFilled = ( /*#__PURE__*/createFluentIcon('ScanTypeFilled', "1em", ["M4.5 3.5a1 1 0 0 0-1 1v2.25a.75.75 0 0 1-1.5 0V4.5A2.5 2.5 0 0 1 4.5 2h2.25a.75.75 0 0 1 0 1.5H4.5Zm0 13a1 1 0 0 1-1-1v-2.25a.75.75 0 0 0-1.5 0v2.25A2.5 2.5 0 0 0 4.5 18h2.25a.75.75 0 0 0 0-1.5H4.5Zm12-12a1 1 0 0 0-1-1h-2.25a.75.75 0 0 1 0-1.5h2.25A2.5 2.5 0 0 1 18 4.5v2.25a.75.75 0 0 1-1.5 0V4.5Zm-1 12a1 1 0 0 0 1-1v-2.25a.75.75 0 0 1 1.5 0v2.25a2.5 2.5 0 0 1-2.5 2.5h-2.25a.75.75 0 0 1 0-1.5h2.25ZM5.75 6.75c0-.41.34-.75.75-.75h7c.41 0 .75.34.75.75v1a.75.75 0 0 1-1.5 0V7.5h-2v5H11a.75.75 0 0 1 0 1.5H9a.75.75 0 0 1 0-1.5h.25v-5h-2v.25a.75.75 0 0 1-1.5 0v-1Z"]));
export const ScanTypeRegular = ( /*#__PURE__*/createFluentIcon('ScanTypeRegular', "1em", ["M4.5 3C3.67 3 3 3.67 3 4.5v2a.5.5 0 0 1-1 0v-2A2.5 2.5 0 0 1 4.5 2h2a.5.5 0 0 1 0 1h-2Zm0 14A1.5 1.5 0 0 1 3 15.5v-2a.5.5 0 0 0-1 0v2A2.5 2.5 0 0 0 4.5 18h2a.5.5 0 0 0 0-1h-2ZM17 4.5c0-.83-.67-1.5-1.5-1.5h-2a.5.5 0 0 1 0-1h2A2.5 2.5 0 0 1 18 4.5v2a.5.5 0 0 1-1 0v-2ZM15.5 17c.83 0 1.5-.67 1.5-1.5v-2a.5.5 0 0 1 1 0v2a2.5 2.5 0 0 1-2.5 2.5h-2a.5.5 0 0 1 0-1h2ZM6 6.5c0-.28.22-.5.5-.5h7c.28 0 .5.22.5.5v1a.5.5 0 0 1-1 0V7h-2.5v6h.5a.5.5 0 0 1 0 1H9a.5.5 0 0 1 0-1h.5V7H7v.5a.5.5 0 0 1-1 0v-1Z"]));
export const ScanTypeCheckmarkFilled = ( /*#__PURE__*/createFluentIcon('ScanTypeCheckmarkFilled', "1em", ["M4.5 3.5a1 1 0 0 0-1 1v2.25a.75.75 0 0 1-1.5 0V4.5A2.5 2.5 0 0 1 4.5 2h2.25a.75.75 0 0 1 0 1.5H4.5Zm0 13a1 1 0 0 1-1-1v-2.25a.75.75 0 0 0-1.5 0v2.25A2.5 2.5 0 0 0 4.5 18h2.25a.75.75 0 0 0 0-1.5H4.5Zm12-12a1 1 0 0 0-1-1h-2.25a.75.75 0 0 1 0-1.5h2.25A2.5 2.5 0 0 1 18 4.5v2.25a.75.75 0 0 1-1.5 0V4.5ZM5.75 6.75c0-.41.34-.75.75-.75h7c.41 0 .75.34.75.75v1a.75.75 0 0 1-1.5 0V7.5h-2v5h.14c-.3.46-.53.96-.68 1.5H9a.75.75 0 0 1 0-1.5h.25v-5h-2v.25a.75.75 0 0 1-1.5 0v-1ZM20 15.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.85-1.85-2.65 2.64-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l3-3a.5.5 0 0 0-.7-.7Z"]));
export const ScanTypeCheckmarkRegular = ( /*#__PURE__*/createFluentIcon('ScanTypeCheckmarkRegular', "1em", ["M4.5 3C3.67 3 3 3.67 3 4.5v2a.5.5 0 0 1-1 0v-2A2.5 2.5 0 0 1 4.5 2h2a.5.5 0 0 1 0 1h-2Zm0 14A1.5 1.5 0 0 1 3 15.5v-2a.5.5 0 0 0-1 0v2A2.5 2.5 0 0 0 4.5 18h2a.5.5 0 0 0 0-1h-2ZM17 4.5c0-.83-.67-1.5-1.5-1.5h-2a.5.5 0 0 1 0-1h2A2.5 2.5 0 0 1 18 4.5v2a.5.5 0 0 1-1 0v-2Zm-11 2c0-.28.22-.5.5-.5h7c.28 0 .5.22.5.5v1a.5.5 0 0 1-1 0V7h-2.5v6h.1c-.16.32-.3.65-.4 1H9a.5.5 0 0 1 0-1h.5V7H7v.5a.5.5 0 0 1-1 0v-1Zm14 9a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-5.5.8-.65-.65a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l3-3a.5.5 0 0 0-.7-.7l-2.65 2.64Z"]));
export const ScanTypeOffFilled = ( /*#__PURE__*/createFluentIcon('ScanTypeOffFilled', "1em", ["M2.41 3.12C2.15 3.52 2 4 2 4.5v2.25a.75.75 0 0 0 1.5 0V4.5a1 1 0 0 1 .03-.26L5.8 6.5a.75.75 0 0 0-.04.25v1a.75.75 0 0 0 1.48.18l2.02 2.03v2.54H9A.75.75 0 0 0 9 14h2a.75.75 0 0 0 0-1.5h-.25v-1.04l5 5a1 1 0 0 1-.25.04h-2.25a.75.75 0 0 0 0 1.5h2.25c.5 0 .98-.15 1.38-.41l.27.26a.5.5 0 0 0 .7-.7l-15-15a.5.5 0 1 0-.7.7l.26.27ZM8.12 6l2.63 2.63V7.5h2v.25a.75.75 0 0 0 1.5 0v-1A.75.75 0 0 0 13.5 6H8.12Zm8.38 8.38 1.48 1.47.02-.35v-2.25a.75.75 0 0 0-1.5 0v1.13ZM4.15 2.02 5.62 3.5h1.13a.75.75 0 0 0 0-1.5H4.5c-.12 0-.24 0-.35.02ZM4.5 16.5a1 1 0 0 1-1-1v-2.25a.75.75 0 0 0-1.5 0v2.25A2.5 2.5 0 0 0 4.5 18h2.25a.75.75 0 0 0 0-1.5H4.5Zm12-12a1 1 0 0 0-1-1h-2.25a.75.75 0 0 1 0-1.5h2.25A2.5 2.5 0 0 1 18 4.5v2.25a.75.75 0 0 1-1.5 0V4.5Z"]));
export const ScanTypeOffRegular = ( /*#__PURE__*/createFluentIcon('ScanTypeOffRegular', "1em", ["M2.41 3.12C2.15 3.52 2 4 2 4.5v2a.5.5 0 0 0 1 0v-2c0-.23.05-.45.15-.65L6 6.71v.79a.5.5 0 0 0 .97.18L9.5 10.2V13H9a.5.5 0 0 0 0 1h2a.5.5 0 0 0 0-1h-.5v-1.8l5.65 5.65c-.2.1-.42.15-.65.15h-2a.5.5 0 0 0 0 1h2c.5 0 .98-.15 1.38-.41l.27.26a.5.5 0 0 0 .7-.7l-15-15a.5.5 0 1 0-.7.7l.26.27ZM8.12 6l1 1h.38v.38l1 1V7H13v.5a.5.5 0 0 0 1 0v-1a.5.5 0 0 0-.5-.5H8.12ZM18 15.5c0 .12 0 .24-.02.35l-.98-.97V13.5a.5.5 0 0 1 1 0v2ZM4.15 2.02l.97.98H6.5a.5.5 0 0 0 0-1h-2c-.12 0-.24 0-.35.02ZM4.5 17A1.5 1.5 0 0 1 3 15.5v-2a.5.5 0 0 0-1 0v2A2.5 2.5 0 0 0 4.5 18h2a.5.5 0 0 0 0-1h-2ZM17 4.5c0-.83-.67-1.5-1.5-1.5h-2a.5.5 0 0 1 0-1h2A2.5 2.5 0 0 1 18 4.5v2a.5.5 0 0 1-1 0v-2Z"]));
export const ScratchpadFilled = ( /*#__PURE__*/createFluentIcon('ScratchpadFilled', "1em", ["M4.5 2C3.67 2 3 2.67 3 3.5v13c0 .83.67 1.5 1.5 1.5H12v-.7A5.5 5.5 0 0 1 8 12H6.5a.5.5 0 0 1 0-1h1.59c.2-.58.76-1 1.41-1v-.5h-3a.5.5 0 0 1 0-1h3c0-.53.1-1.04.3-1.5H6.5a.5.5 0 0 1 0-1h3.88a4 4 0 0 1 6.62.56V3.5c0-.83-.67-1.5-1.5-1.5h-11Zm9 3.5a3 3 0 0 0-3 3v3a3 3 0 1 0 6 0v-3a3 3 0 0 0-3-3Zm-4 5.5c.28 0 .5.22.5.5v.5a3.5 3.5 0 1 0 7 0v-.5a.5.5 0 0 1 1 0v.5a4.5 4.5 0 0 1-4 4.47V18a.5.5 0 0 1-1 0v-1.53A4.5 4.5 0 0 1 9 12v-.5c0-.28.22-.5.5-.5Z"]));
export const ScratchpadRegular = ( /*#__PURE__*/createFluentIcon('ScratchpadRegular', "1em", ["M4.5 2C3.67 2 3 2.67 3 3.5v13c0 .83.67 1.5 1.5 1.5H12v-.7a5.46 5.46 0 0 1-.8-.3H4.5a.5.5 0 0 1-.5-.5v-13c0-.28.22-.5.5-.5h11c.28 0 .5.22.5.5v1.88c.4.32.75.72 1 1.18V3.5c0-.83-.67-1.5-1.5-1.5h-11ZM8 11.5c0-.18.03-.34.09-.5H6.5a.5.5 0 0 0 0 1H8v-.5Zm-1.5-3h3v1h-3a.5.5 0 0 1 0-1ZM9.8 7a4 4 0 0 1 .58-1H6.5a.5.5 0 0 0 0 1h3.3Zm3.7-1.5a3 3 0 0 0-3 3v3a3 3 0 1 0 6 0v-3a3 3 0 0 0-3-3Zm-2 3a2 2 0 1 1 4 0v3a2 2 0 1 1-4 0v-3Zm-1.5 3a.5.5 0 0 0-1 0v.5a4.5 4.5 0 0 0 4 4.47V18a.5.5 0 0 0 1 0v-1.53A4.5 4.5 0 0 0 18 12v-.5a.5.5 0 0 0-1 0v.5a3.5 3.5 0 1 1-7 0v-.5Z"]));
export const ScreenCutFilled = ( /*#__PURE__*/createFluentIcon('ScreenCutFilled', "1em", ["M3 6a1 1 0 0 1 1-1h.5a.5.5 0 1 0 0-1H4a2 2 0 0 0-2 2v.5a.5.5 0 1 0 1 0V6Z", "M4 14a1 1 0 0 1-1-1v-.5a.5.5 0 0 0-1 0v.5c0 1.1.9 2 2 2h.25a.5.5 0 0 0 0-1H4Z", "M2.5 8c.28 0 .5.22.5.5v2a.5.5 0 1 1-1 0v-2c0-.28.22-.5.5-.5Z", "M17 6a1 1 0 0 0-1-1h-.5a.5.5 0 0 1 0-1h.5a2 2 0 0 1 2 2v.5a.5.5 0 0 1-1 0V6Z", "M17 13a1 1 0 0 1-1 1h-.25a.5.5 0 0 0 0 1H16a2 2 0 0 0 2-2v-.5a.5.5 0 0 0-1 0v.5Z", "M17 8.5a.5.5 0 0 1 1 0v2a.5.5 0 1 1-1 0v-2Z", "M6 4.5c0-.28.22-.5.5-.5H9a.5.5 0 0 1 0 1H6.5a.5.5 0 0 1-.5-.5Z", "M11 4a.5.5 0 0 0 0 1h2.5a.5.5 0 0 0 0-1H11Z", "M5 6a1 1 0 0 0-1 1v5a1 1 0 0 0 1 1h2.7l.5-.74-1.96-2.93a1.5 1.5 0 1 1 2.5-1.66L10 9.55l1.25-1.88a1.5 1.5 0 0 1 2.5 1.66l-1.95 2.93.5.74H15a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1H5Z", "M7.22 8.09a.5.5 0 0 0-.14.69l2.31 3.48-1.23 1.85a2 2 0 0 0-2.51 2.64 2 2 0 1 0 3.34-2.08l1-1.51L11 14.67a2 2 0 1 0 .84-.55l-1.24-1.86-.6-.9L7.9 8.23a.5.5 0 0 0-.7-.14ZM12.5 17a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm-5 0a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z", "m10.6 10.45.6.9 1.72-2.57a.5.5 0 0 0-.14-.7.5.5 0 0 0-.7.15l-1.48 2.22Z"]));
export const ScreenCutRegular = ( /*#__PURE__*/createFluentIcon('ScreenCutRegular', "1em", ["M4 5a1 1 0 0 0-1 1v.5a.5.5 0 1 1-1 0V6c0-1.1.9-2 2-2h.5a.5.5 0 0 1 0 1H4Z", "M3 13a1 1 0 0 0 1 1h.25a.5.5 0 0 1 0 1H4a2 2 0 0 1-2-2v-.5a.5.5 0 0 1 1 0v.5Z", "M3 8.5a.5.5 0 0 0-1 0v2a.5.5 0 1 0 1 0v-2Z", "M16 5a1 1 0 0 1 1 1v.5a.5.5 0 0 0 1 0V6a2 2 0 0 0-2-2h-.5a.5.5 0 0 0 0 1h.5Z", "M16 14a1 1 0 0 0 1-1v-.5a.5.5 0 0 1 1 0v.5a2 2 0 0 1-2 2h-.25a.5.5 0 0 1 0-1H16Z", "M17.5 8a.5.5 0 0 0-.5.5v2a.5.5 0 1 0 1 0v-2a.5.5 0 0 0-.5-.5Z", "M6.5 4a.5.5 0 0 0 0 1H9a.5.5 0 1 0 0-1H6.5Z", "M10.5 4.5c0-.28.22-.5.5-.5h2.5a.5.5 0 0 1 0 1H11a.5.5 0 0 1-.5-.5Z", "M7.22 8.09a.5.5 0 0 0-.14.69l2.31 3.48-1.23 1.85a2 2 0 0 0-2.51 2.64 2 2 0 1 0 3.34-2.08l1-1.51L11 14.67a2 2 0 1 0 .84-.55l-1.24-1.86-.6-.9L7.9 8.23a.5.5 0 0 0-.7-.14ZM12.5 17a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm-5 0a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z", "m10.6 10.45.6.9 1.72-2.57a.5.5 0 0 0-.14-.7.5.5 0 0 0-.7.15l-1.48 2.22Z"]));
export const ScreenPersonFilled = ( /*#__PURE__*/createFluentIcon('ScreenPersonFilled', "1em", ["M5 4a3 3 0 0 0-3 3v6a3 3 0 0 0 3 3h6.05a2.5 2.5 0 0 1 2.22-1.99A2.99 2.99 0 0 1 15.5 9a3 3 0 0 1 2.5 1.34V7a3 3 0 0 0-3-3H5Zm12.5 8a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm1.5 4.5c0 1.25-1 2.5-3.5 2.5S12 17.75 12 16.5c0-.83.67-1.5 1.5-1.5h4c.83 0 1.5.67 1.5 1.5Z"]));
export const ScreenPersonRegular = ( /*#__PURE__*/createFluentIcon('ScreenPersonRegular', "1em", ["M4.75 4A2.75 2.75 0 0 0 2 6.75v6.5A2.75 2.75 0 0 0 4.75 16h6.3c.07-.37.23-.7.45-1H4.75C3.78 15 3 14.22 3 13.25v-6.5C3 5.78 3.78 5 4.75 5h10.5c.97 0 1.75.78 1.75 1.75V9.4c.4.23.74.56 1 .94V6.75A2.75 2.75 0 0 0 15.25 4H4.75Zm12.75 8a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm1.5 4.5c0 1.25-1 2.5-3.5 2.5S12 17.75 12 16.5c0-.83.67-1.5 1.5-1.5h4c.83 0 1.5.67 1.5 1.5Z"]));
export const ScreenSearchFilled = ( /*#__PURE__*/createFluentIcon('ScreenSearchFilled', "1em", ["M2 6.75A2.75 2.75 0 0 1 4.75 4h10.5A2.75 2.75 0 0 1 18 6.75v6.5A2.75 2.75 0 0 1 15.25 16h-5.13l-1.56-1.56A4.5 4.5 0 0 0 2 8.76V6.75ZM4.5 16c.79 0 1.51-.26 2.1-.7l2.55 2.55a.5.5 0 1 0 .7-.7L7.3 14.6A3.5 3.5 0 1 0 4.5 16Zm0-1a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5Z"]));
export const ScreenSearchRegular = ( /*#__PURE__*/createFluentIcon('ScreenSearchRegular', "1em", ["M2 6.75A2.75 2.75 0 0 1 4.75 4h10.5A2.75 2.75 0 0 1 18 6.75v6.5A2.75 2.75 0 0 1 15.25 16h-5.13l-1-1h6.13c.97 0 1.75-.78 1.75-1.75v-6.5C17 5.78 16.22 5 15.25 5H4.75C3.78 5 3 5.78 3 6.75v1.5c-.36.13-.7.3-1 .5v-2ZM4.5 16c.79 0 1.51-.26 2.1-.7l2.55 2.55a.5.5 0 1 0 .7-.7L7.3 14.6A3.5 3.5 0 1 0 4.5 16Zm0-1a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5Z"]));
export const ScreenshotFilled = ( /*#__PURE__*/createFluentIcon('ScreenshotFilled', "1em", ["M6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6Zm.5 3a.5.5 0 0 0-.5.5v2a.5.5 0 0 1-1 0v-2C5 5.67 5.67 5 6.5 5h2a.5.5 0 0 1 0 1h-2ZM6 13.5c0 .28.22.5.5.5h2a.5.5 0 0 1 0 1h-2A1.5 1.5 0 0 1 5 13.5v-2a.5.5 0 0 1 1 0v2ZM13.5 6h-2a.5.5 0 0 1 0-1h2c.83 0 1.5.67 1.5 1.5v2a.5.5 0 0 1-1 0v-2a.5.5 0 0 0-.5-.5Zm.5 7.5v-2a.5.5 0 0 1 1 0v2c0 .83-.67 1.5-1.5 1.5h-2a.5.5 0 0 1 0-1h2a.5.5 0 0 0 .5-.5Z"]));
export const ScreenshotRegular = ( /*#__PURE__*/createFluentIcon('ScreenshotRegular', "1em", ["M3 5.75A2.75 2.75 0 0 1 5.75 3h8.5A2.75 2.75 0 0 1 17 5.75v8.5A2.75 2.75 0 0 1 14.25 17h-8.5A2.75 2.75 0 0 1 3 14.25v-8.5ZM5.75 4C4.78 4 4 4.78 4 5.75v8.5c0 .97.78 1.75 1.75 1.75h8.5c.97 0 1.75-.78 1.75-1.75v-8.5C16 4.78 15.22 4 14.25 4h-8.5Zm.75 2a.5.5 0 0 0-.5.5v2a.5.5 0 0 1-1 0v-2C5 5.67 5.67 5 6.5 5h2a.5.5 0 0 1 0 1h-2ZM6 13.5c0 .28.22.5.5.5h2a.5.5 0 0 1 0 1h-2A1.5 1.5 0 0 1 5 13.5v-2a.5.5 0 0 1 1 0v2ZM13.5 6c.28 0 .5.22.5.5v2a.5.5 0 0 0 1 0v-2c0-.83-.67-1.5-1.5-1.5h-2a.5.5 0 0 0 0 1h2Zm.5 7.5a.5.5 0 0 1-.5.5h-2a.5.5 0 0 0 0 1h2c.83 0 1.5-.67 1.5-1.5v-2a.5.5 0 0 0-1 0v2Z"]));
export const ScreenshotRecordFilled = ( /*#__PURE__*/createFluentIcon('ScreenshotRecordFilled', "1em", ["M6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h3.6A5.5 5.5 0 0 1 17 9.6V6a3 3 0 0 0-3-3H6Zm8.5 6a.5.5 0 0 1-.5-.5v-2a.5.5 0 0 0-.5-.5h-2a.5.5 0 0 1 0-1h2c.83 0 1.5.67 1.5 1.5v2a.5.5 0 0 1-.5.5ZM9 14.5a.5.5 0 0 1-.5.5h-2A1.5 1.5 0 0 1 5 13.5v-2a.5.5 0 0 1 1 0v2c0 .28.22.5.5.5h2c.28 0 .5.22.5.5ZM6.5 6a.5.5 0 0 0-.5.5v2a.5.5 0 0 1-1 0v-2C5 5.67 5.67 5 6.5 5h2a.5.5 0 0 1 0 1h-2Zm8 5a3.5 3.5 0 1 1 0 7 3.5 3.5 0 0 1 0-7Zm0 8a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm2.5-4.5a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0Z"]));
export const ScreenshotRecordRegular = ( /*#__PURE__*/createFluentIcon('ScreenshotRecordRegular', "1em", ["M3 5.75A2.75 2.75 0 0 1 5.75 3h8.5A2.75 2.75 0 0 1 17 5.75V9.6c-.32-.16-.65-.3-1-.4V5.76C16 4.78 15.22 4 14.25 4h-8.5C4.78 4 4 4.78 4 5.75v8.5c0 .97.78 1.75 1.75 1.75h3.46c.1.35.23.68.39 1H5.75A2.75 2.75 0 0 1 3 14.25v-8.5ZM15 8.5a.5.5 0 0 1-1 0v-2a.5.5 0 0 0-.5-.5h-2a.5.5 0 0 1 0-1h2c.83 0 1.5.67 1.5 1.5v2ZM8.5 14a.5.5 0 0 1 0 1h-2A1.5 1.5 0 0 1 5 13.5v-2a.5.5 0 0 1 1 0v2c0 .28.22.5.5.5h2Zm-2-8a.5.5 0 0 0-.5.5v2a.5.5 0 0 1-1 0v-2C5 5.67 5.67 5 6.5 5h2a.5.5 0 0 1 0 1h-2Zm8 5a3.5 3.5 0 1 1 0 7 3.5 3.5 0 0 1 0-7Zm0 8a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm2.5-4.5a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0Z"]));
export const ScriptFilled = ( /*#__PURE__*/createFluentIcon('ScriptFilled', "1em", ["M16.56 2H6.5A2.5 2.5 0 0 0 4 4.5V13h6a1 1 0 0 1 1 1v2.1c0 1.1.9 1.9 2 1.9s1.99-.79 2-1.88V4.37a2.5 2.5 0 0 1 2-2.32 2.5 2.5 0 0 0-.44-.05Zm-5.88 16a2.99 2.99 0 0 1-.68-1.9V14H1.5a.5.5 0 0 0-.5.5v1.19A2.32 2.32 0 0 0 3.38 18h7.3ZM18 7a1 1 0 0 0 1-1V4.5a1.5 1.5 0 0 0-3 0V7h2Z"]));
export const ScriptRegular = ( /*#__PURE__*/createFluentIcon('ScriptRegular', "1em", ["M16.56 2H6.5A2.5 2.5 0 0 0 4 4.5V13H2a1 1 0 0 0-1 1v1.69A2.32 2.32 0 0 0 3.38 18h9.14A2.5 2.5 0 0 0 15 15.53V7h3a1 1 0 0 0 1-1V4.5A2.5 2.5 0 0 0 16.56 2ZM6.5 3h8c-.3.39-.47.86-.5 1.38V15.5a1.5 1.5 0 0 1-3 0V14a1 1 0 0 0-1-1H5V4.5C5 3.67 5.67 3 6.5 3Zm10 0c.83 0 1.5.67 1.5 1.5V6h-3V4.5c0-.83.67-1.5 1.5-1.5ZM2 14h8v1.5c0 .56.19 1.08.5 1.5H3.37C2.6 17 2 16.42 2 15.69V14Z"]));
export const SearchFilled = ( /*#__PURE__*/createFluentIcon('SearchFilled', "1em", ["M13.54 14.6a6.5 6.5 0 1 1 1.06-1.06l3.43 3.43a.75.75 0 0 1-.98 1.13l-.08-.07-3.43-3.43Zm.96-5.1a5 5 0 1 0-10 0 5 5 0 0 0 10 0Z"]));
export const SearchRegular = ( /*#__PURE__*/createFluentIcon('SearchRegular', "1em", ["M13.73 14.44a6.5 6.5 0 1 1 .7-.7l3.42 3.4a.5.5 0 0 1-.63.77l-.07-.06-3.42-3.41Zm-.71-.71A5.54 5.54 0 0 0 15 9.5a5.5 5.5 0 1 0-1.98 4.23Z"]));
export const SearchInfoFilled = ( /*#__PURE__*/createFluentIcon('SearchInfoFilled', "1em", ["M13.73 14.44a6.5 6.5 0 1 1 .7-.7l3.42 3.4a.5.5 0 0 1-.63.77l-.07-.06-3.42-3.41ZM9.5 8.5A.5.5 0 0 0 9 9v3a.5.5 0 0 0 1 0V9a.5.5 0 0 0-.5-.5Zm0-1a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z"]));
export const SearchInfoRegular = ( /*#__PURE__*/createFluentIcon('SearchInfoRegular', "1em", ["M13.73 14.44a6.5 6.5 0 1 1 .7-.7l3.42 3.4a.5.5 0 0 1-.63.77l-.07-.06-3.42-3.41Zm-.71-.71A5.54 5.54 0 0 0 15 9.5a5.5 5.5 0 1 0-1.98 4.23ZM9.5 8.5c.28 0 .5.22.5.5v3a.5.5 0 0 1-1 0V9c0-.28.22-.5.5-.5Zm0-1a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z"]));
export const SearchSettingsFilled = ( /*#__PURE__*/createFluentIcon('SearchSettingsFilled', "1em", ["M4.07 10.82a2 2 0 0 0 2.9 0l.33-.34c.3.14.58.31.84.52l-.13.42a2 2 0 0 0 1.46 2.52l.35.08a4.7 4.7 0 0 1 0 1.02l-.45.11a2 2 0 0 0-1.43 2.48l.15.56c-.25.2-.53.36-.82.5l-.34-.36a2 2 0 0 0-2.9 0l-.33.34c-.3-.14-.58-.32-.84-.52l.13-.42a2 2 0 0 0-1.46-2.52l-.35-.08a4.7 4.7 0 0 1 0-1.02l.46-.12a2 2 0 0 0 1.43-2.47l-.16-.56c.25-.2.53-.36.82-.5l.34.36ZM9.5 3a6.5 6.5 0 0 1 5.1 10.54l3.43 3.43a.75.75 0 0 1-.98 1.13l-.08-.07-3.43-3.43a6.47 6.47 0 0 1-2.7 1.26 5.51 5.51 0 0 0 .15-1.59 5 5 0 1 0-6.48-5.1c-.53.09-1.04.26-1.5.5L3 9.5A6.5 6.5 0 0 1 9.5 3Zm-4 10.57a1 1 0 1 0 0 2 1 1 0 0 0 0-2Z"]));
export const SearchSettingsRegular = ( /*#__PURE__*/createFluentIcon('SearchSettingsRegular', "1em", ["M4.07 10.82a2 2 0 0 0 2.9 0l.33-.34c.3.14.58.31.84.52l-.13.42a2 2 0 0 0 1.46 2.52l.35.08a4.7 4.7 0 0 1 0 1.02l-.45.11a2 2 0 0 0-1.43 2.48l.15.56c-.25.2-.53.36-.82.5l-.34-.36a2 2 0 0 0-2.9 0l-.33.34c-.3-.14-.58-.32-.84-.52l.13-.42a2 2 0 0 0-1.46-2.52l-.35-.08a4.7 4.7 0 0 1 0-1.02l.46-.12a2 2 0 0 0 1.43-2.47l-.16-.56c.25-.2.53-.36.82-.5l.34.36ZM9.5 3a6.5 6.5 0 0 1 4.94 10.73l3.41 3.42a.5.5 0 0 1-.63.76l-.07-.06-3.42-3.41c-.81.7-1.8 1.19-2.88 1.42.08-.35.13-.7.14-1.07A5.48 5.48 0 0 0 15 9.5a5.5 5.5 0 0 0-11-.22c-.34.1-.68.23-1 .4V9.5A6.5 6.5 0 0 1 9.5 3Zm-4 10.57a1 1 0 1 0 0 2 1 1 0 0 0 0-2Z"]));
export const SearchShieldFilled = ( /*#__PURE__*/createFluentIcon('SearchShieldFilled', "1em", ["M9.5 3a6.5 6.5 0 0 1 5.1 10.54l3.43 3.43a.75.75 0 0 1-.98 1.13l-.08-.07-3.43-3.43A6.47 6.47 0 0 1 9.57 16c.2-.45.35-.95.4-1.52a5 5 0 1 0-5.46-5.23l-.08.06c-.33.31-.82.7-1.39.94C3.02 10 3 9.75 3 9.5A6.5 6.5 0 0 1 9.5 3Zm-4.38 7.04c.2-.2.56-.2.76 0 .5.48 1.48 1.25 2.68 1.4.24.04.44.22.44.45v2.1c0 2.85-2.78 3.88-3.39 4.07a.37.37 0 0 1-.22 0C4.79 17.86 2 16.84 2 14v-2.11c0-.23.2-.41.44-.44a5.07 5.07 0 0 0 2.68-1.41Z"]));
export const SearchShieldRegular = ( /*#__PURE__*/createFluentIcon('SearchShieldRegular', "1em", ["M5.12 10.04c.2-.2.56-.2.76 0 .5.48 1.48 1.25 2.68 1.4.24.04.44.22.44.45v2.1c0 2.85-2.78 3.88-3.39 4.07a.37.37 0 0 1-.22 0C4.79 17.86 2 16.84 2 14v-2.11c0-.23.2-.41.44-.44a5.07 5.07 0 0 0 2.68-1.41ZM9.5 3a6.5 6.5 0 0 1 4.94 10.73l3.41 3.42a.5.5 0 0 1-.63.76l-.07-.06-3.42-3.41A6.47 6.47 0 0 1 9.57 16c.15-.31.26-.65.33-1.02A5.47 5.47 0 0 0 15 9.5a5.5 5.5 0 1 0-11 0v.17c-.27.22-.6.43-.96.58C3.02 10 3 9.75 3 9.5A6.5 6.5 0 0 1 9.5 3Z"]));
export const SearchSparkleColor = ( /*#__PURE__*/createFluentIcon('SearchSparkleColor', "1em", `<path d="M14 8.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0Z" fill="url(#ic_fluent_search_sparkle_20_color__a)"/><path d="M12.54 13.6a6.5 6.5 0 1 1 1.06-1.06l3.43 3.43a.75.75 0 0 1-.98 1.13l-.08-.07-3.43-3.43Zm.96-5.1a5 5 0 1 0-10 0 5 5 0 0 0 10 0Z" fill="url(#ic_fluent_search_sparkle_20_color__b)"/><path d="m17.78 8.21-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02Z" fill="url(#ic_fluent_search_sparkle_20_color__c)"/><path d="m12.88.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.23 2.23 0 0 0-1.4-1.4L9.28 3.9a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Z" fill="url(#ic_fluent_search_sparkle_20_color__d)"/><defs><radialGradient id="ic_fluent_search_sparkle_20_color__c" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(12.82142 25.58036 -19.91881 9.98373 4.38 -12.81)"><stop offset=".72" stop-color="#FFCD0F"/><stop offset=".99" stop-color="#E67505"/></radialGradient><radialGradient id="ic_fluent_search_sparkle_20_color__d" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(61.2 15.06 -8.55) scale(30.098 23.4366)"><stop offset=".7" stop-color="#FFCD0F"/><stop offset=".99" stop-color="#E67505"/></radialGradient><linearGradient id="ic_fluent_search_sparkle_20_color__a" x1="11.25" y1="4.83" x2="3" y2="14" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_search_sparkle_20_color__b" x1="2.8" y1="15.64" x2="15.64" y2="5.21" gradientUnits="userSpaceOnUse"><stop stop-color="#0094F0"/><stop offset="1" stop-color="#29C3FF"/></linearGradient></defs>`, { color: true }));
export const SearchSparkleFilled = ( /*#__PURE__*/createFluentIcon('SearchSparkleFilled', "1em", ["M8.04 3.17a1.44 1.44 0 0 0 .48 1.43 5 5 0 1 0 5.73 6.47l.03.08c.1.25.26.46.48.62.21.15.47.23.74.23a6.5 6.5 0 0 1-.9 1.54l3.43 3.43a.75.75 0 0 1-.98 1.13l-.08-.07-3.43-3.43a6.5 6.5 0 1 1-5.5-11.43ZM15.48 6a.3.3 0 0 1 .29.2l.25.77a1.58 1.58 0 0 0 1 1l.76.24h.02a.3.3 0 0 1 .14.47.3.3 0 0 1-.14.1l-.77.26a1.58 1.58 0 0 0-1 1l-.24.76a.3.3 0 0 1-.58 0l-.24-.77a1.57 1.57 0 0 0-1-1l-.77-.25a.3.3 0 0 1-.14-.46.3.3 0 0 1 .14-.1l.77-.26a1.58 1.58 0 0 0 .98-1l.25-.76a.3.3 0 0 1 .28-.2Zm-3-6a.42.42 0 0 1 .4.28l.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.64.2l-.02-.01a.43.43 0 0 1-.14-.2l-.35-1.06a2.22 2.22 0 0 0-1.4-1.4L9.28 3.9a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .4-.28Z"]));
export const SearchSparkleRegular = ( /*#__PURE__*/createFluentIcon('SearchSparkleRegular', "1em", ["M8.04 3.17a1.44 1.44 0 0 0 .13 1 5.5 5.5 0 1 0 6.4 7.44l.19.16c.21.15.47.23.74.23a6.5 6.5 0 0 1-1.06 1.73l3.41 3.42a.5.5 0 0 1-.63.76l-.07-.06-3.42-3.41a6.5 6.5 0 1 1-5.7-11.27ZM15.48 6a.3.3 0 0 1 .29.2l.25.77a1.58 1.58 0 0 0 1 1l.76.24h.02a.3.3 0 0 1 .14.47.3.3 0 0 1-.14.1l-.77.26a1.58 1.58 0 0 0-1 1l-.24.76a.3.3 0 0 1-.58 0l-.24-.77a1.57 1.57 0 0 0-1-1l-.77-.25a.3.3 0 0 1-.14-.46.3.3 0 0 1 .14-.1l.77-.26a1.58 1.58 0 0 0 .98-1l.25-.76a.3.3 0 0 1 .28-.2Zm-3-6a.42.42 0 0 1 .4.28l.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.64.2l-.02-.01a.43.43 0 0 1-.14-.2l-.35-1.06a2.22 2.22 0 0 0-1.4-1.4L9.28 3.9a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .4-.28Z"]));
export const SearchSquareFilled = ( /*#__PURE__*/createFluentIcon('SearchSquareFilled', "1em", ["M9 11.5a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5ZM3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6Zm6 6.5c.79 0 1.51-.26 2.1-.7l2.55 2.55a.5.5 0 1 0 .7-.7L11.8 11.1A3.5 3.5 0 1 0 9 12.5Z"]));
export const SearchSquareRegular = ( /*#__PURE__*/createFluentIcon('SearchSquareRegular', "1em", ["M9 12.5c.79 0 1.51-.26 2.1-.7l2.55 2.55a.5.5 0 1 0 .7-.7L11.8 11.1A3.5 3.5 0 1 0 9 12.5Zm0-1a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5ZM6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6ZM4 6c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V6Z"]));
export const SearchVisualColor = ( /*#__PURE__*/createFluentIcon('SearchVisualColor', "1em", `<path fill-rule="evenodd" clip-rule="evenodd" d="M4.5 4a.5.5 0 0 0-.5.5V7a1 1 0 0 1-2 0V4.5A2.5 2.5 0 0 1 4.5 2H7a1 1 0 0 1 0 2H4.5ZM12 3a1 1 0 0 1 1-1h2.5A2.5 2.5 0 0 1 18 4.5V7a1 1 0 1 1-2 0V4.5a.5.5 0 0 0-.5-.5H13a1 1 0 0 1-1-1Zm-9 9a1 1 0 0 1 1 1v2.5c0 .28.22.5.5.5H7a1 1 0 1 1 0 2H4.5A2.5 2.5 0 0 1 2 15.5V13a1 1 0 0 1 1-1Zm14 0a1 1 0 0 1 1 1v2.5a2.5 2.5 0 0 1-2.5 2.5H13a1 1 0 1 1 0-2h2.5a.5.5 0 0 0 .5-.5V13a1 1 0 0 1 1-1Z" fill="url(#ic_fluent_search_visual_20_color__a)"/><path d="M10 12a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM7 8a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z" fill="url(#ic_fluent_search_visual_20_color__b)"/><defs><radialGradient id="ic_fluent_search_visual_20_color__b" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(3.375 3.75 -3.2117 2.89053 7.88 7.5)"><stop stop-color="#0FAFFF"/><stop offset="1" stop-color="#2052CB"/></radialGradient><linearGradient id="ic_fluent_search_visual_20_color__a" x1="1.37" y1=".66" x2="13.91" y2="20.93" gradientUnits="userSpaceOnUse"><stop offset=".02" stop-color="#3DCBFF"/><stop offset="1" stop-color="#0094F0"/></linearGradient></defs>`, { color: true }));
export const SearchVisualFilled = ( /*#__PURE__*/createFluentIcon('SearchVisualFilled', "1em", ["M3 6.25C3 4.45 4.46 3 6.25 3h1a.75.75 0 0 1 0 1.5h-1c-.97 0-1.75.78-1.75 1.75v1a.75.75 0 0 1-1.5 0v-1Zm14 7.5c0 1.8-1.46 3.25-3.25 3.25h-1a.75.75 0 0 1 0-1.5h1c.97 0 1.75-.78 1.75-1.75v-1a.75.75 0 0 1 1.5 0v1Zm0-7.5C17 4.45 15.54 3 13.75 3h-1a.75.75 0 0 0 0 1.5h1c.97 0 1.75.78 1.75 1.75v1a.75.75 0 0 0 1.5 0v-1ZM6.25 17A3.25 3.25 0 0 1 3 13.75v-1a.75.75 0 0 1 1.5 0v1c0 .97.78 1.75 1.75 1.75h1a.75.75 0 0 1 0 1.5h-1ZM10 12a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM7 8a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"]));
export const SearchVisualRegular = ( /*#__PURE__*/createFluentIcon('SearchVisualRegular', "1em", ["M14 3a3 3 0 0 1 3 3v1.5a.5.5 0 0 1-1 0V6a2 2 0 0 0-2-2h-1.5a.5.5 0 0 1 0-1H14ZM6 3a3 3 0 0 0-3 3v1.5a.5.5 0 0 0 1 0V6c0-1.1.9-2 2-2h1.5a.5.5 0 0 0 0-1H6Zm8 14a3 3 0 0 0 3-3v-1.5a.5.5 0 0 0-1 0V14a2 2 0 0 1-2 2h-1.5a.5.5 0 0 0 0 1H14ZM3 14a3 3 0 0 0 3 3h1.5a.5.5 0 0 0 0-1H6a2 2 0 0 1-2-2v-1.5a.5.5 0 0 0-1 0V14Zm7-2a2 2 0 1 0 0-4 2 2 0 0 0 0 4Zm0-1a1 1 0 1 1 0-2 1 1 0 0 1 0 2ZM6.5 7.25a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z"]));
export const SeatFilled = ( /*#__PURE__*/createFluentIcon('SeatFilled', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v3.76a2.99 2.99 0 0 0-4.5.58 3 3 0 0 0-5 0A3 3 0 0 0 3 9.76V6Zm9 6a2 2 0 1 0-4 0v5h4v-5Zm1 5h2a2 2 0 0 0 2-2v-3a2 2 0 1 0-4 0v5Zm-6 0H5a2 2 0 0 1-2-2v-3a2 2 0 1 1 4 0v5Z"]));
export const SeatRegular = ( /*#__PURE__*/createFluentIcon('SeatRegular', "1em", ["M6 3a3 3 0 0 0-3 3v9c0 1.1.9 2 2 2h10a2 2 0 0 0 2-2V6a3 3 0 0 0-3-3H6Zm10 6.5a2.49 2.49 0 0 0-3.62.67 3 3 0 0 0-4.76 0A2.5 2.5 0 0 0 4 9.5V6c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v3.5ZM12 12v4H8v-4a2 2 0 1 1 4 0Zm1 4v-4.5a1.5 1.5 0 0 1 3 0V15a1 1 0 0 1-1 1h-2Zm-9-1v-3.5a1.5 1.5 0 0 1 3 0V16H5a1 1 0 0 1-1-1Z"]));
export const SeatAddFilled = ( /*#__PURE__*/createFluentIcon('SeatAddFilled', "1em", ["M19 5.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V5h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V6h1.5a.5.5 0 0 0 0-1H15V3.5Zm-.5 7.5c.7 0 1.35-.13 1.97-.36A2 2 0 0 1 17 12v3a2 2 0 0 1-2 2h-2v-5a2 2 0 0 1 .34-1.12c.38.08.76.12 1.16.12ZM6 3h3.6a5.48 5.48 0 0 0 .67 6.01L10 9a3 3 0 0 0-2.5 1.34A3 3 0 0 0 3 9.76V6a3 3 0 0 1 3-3Zm6 9a2 2 0 1 0-4 0v5h4v-5Zm-5 5H5a2 2 0 0 1-2-2v-3a2 2 0 1 1 4 0v5Z"]));
export const SeatAddRegular = ( /*#__PURE__*/createFluentIcon('SeatAddRegular', "1em", ["M19 5.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V5h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V6h1.5a.5.5 0 0 0 0-1H15V3.5Zm1 8c0-.24-.06-.46-.16-.67.4-.1.8-.24 1.16-.43V15a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V6a3 3 0 0 1 3-3h3.6c-.16.32-.3.65-.4 1H6a2 2 0 0 0-2 2v3.5a2.49 2.49 0 0 1 3.62.67 3 3 0 0 1 2.65-1.16 5.5 5.5 0 0 0 2.89 1.82c-.1.2-.16.43-.16.67V16h2a1 1 0 0 0 1-1v-3.5Zm-4 .5a2 2 0 1 0-4 0v4h4v-4Zm-8 3a1 1 0 0 0 1 1h2v-4.5a1.5 1.5 0 0 0-3 0V15Z"]));
export const SelectAllOffFilled = ( /*#__PURE__*/createFluentIcon('SelectAllOffFilled', "1em", ["M3 6a3 3 0 0 1 3-3h6a3 3 0 0 1 3 3v6a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6Zm4.99 11a3 3 0 0 1-2.24-1h6.74a3.5 3.5 0 0 0 3.5-3.5V5.77A3 3 0 0 1 17 8v4.5a4.5 4.5 0 0 1-4.5 4.5h-4.5Z"]));
export const SelectAllOffRegular = ( /*#__PURE__*/createFluentIcon('SelectAllOffRegular', "1em", ["M6 3a3 3 0 0 0-3 3v6a3 3 0 0 0 3 3h6a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6ZM4 6c0-1.1.9-2 2-2h6a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V6Zm3.99 11a3 3 0 0 1-2.24-1h6.74a3.5 3.5 0 0 0 3.5-3.5V5.77A3 3 0 0 1 17 8v4.5a4.5 4.5 0 0 1-4.5 4.5h-4.5Z"]));
export const SelectAllOnFilled = ( /*#__PURE__*/createFluentIcon('SelectAllOnFilled', "1em", ["M6 3a3 3 0 0 0-3 3v6a3 3 0 0 0 3 3h6a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6Zm6.33 3.62c.2.19.23.5.05.7l-3.5 4a.5.5 0 0 1-.73.03l-2-2a.5.5 0 1 1 .7-.7l1.63 1.62 3.14-3.6a.5.5 0 0 1 .7-.05ZM5.75 16A3 3 0 0 0 8 17h4.5a4.5 4.5 0 0 0 4.5-4.5V8a3 3 0 0 0-1-2.23v6.73a3.5 3.5 0 0 1-3.5 3.5H5.75Z"]));
export const SelectAllOnRegular = ( /*#__PURE__*/createFluentIcon('SelectAllOnRegular', "1em", ["M12.33 6.62c.2.19.23.5.05.7l-3.5 4a.5.5 0 0 1-.73.03l-2-2a.5.5 0 1 1 .7-.7l1.63 1.62 3.14-3.6a.5.5 0 0 1 .7-.05ZM3 6a3 3 0 0 1 3-3h6a3 3 0 0 1 3 3v6a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6Zm3-2a2 2 0 0 0-2 2v6c0 1.1.9 2 2 2h6a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2H6Zm-.25 12A3 3 0 0 0 8 17h4.5a4.5 4.5 0 0 0 4.5-4.5V8a3 3 0 0 0-1-2.23v6.73a3.5 3.5 0 0 1-3.5 3.5H5.75Z"]));
export const SelectObjectFilled = ( /*#__PURE__*/createFluentIcon('SelectObjectFilled', "1em", ["M6 4.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Zm11 0a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Zm-11 11a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Zm11 0a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0ZM7 4.75c0-.41.34-.75.75-.75h4.5a.75.75 0 0 1 0 1.5h-4.5A.75.75 0 0 1 7 4.75Zm0 10.5c0-.41.34-.75.75-.75h4.5a.75.75 0 0 1 0 1.5h-4.5a.75.75 0 0 1-.75-.75Zm-3-7.5a.75.75 0 0 1 1.5 0v4.5a.75.75 0 0 1-1.5 0v-4.5Zm10.5 0a.75.75 0 0 1 1.5 0v4.5a.75.75 0 0 1-1.5 0v-4.5Z"]));
export const SelectObjectRegular = ( /*#__PURE__*/createFluentIcon('SelectObjectRegular', "1em", ["M6 4.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Zm11 0a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Zm-11 11a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Zm11 0a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0ZM7 4.5c0-.28.22-.5.5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5Zm0 11c0-.28.22-.5.5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5Zm-3-8a.5.5 0 0 1 1 0v5a.5.5 0 0 1-1 0v-5Zm11 0a.5.5 0 0 1 1 0v5a.5.5 0 0 1-1 0v-5Z"]));
export const SelectObjectSkewFilled = ( /*#__PURE__*/createFluentIcon('SelectObjectSkewFilled', "1em", ["M15 4.5a1.5 1.5 0 1 0 3 0 1.5 1.5 0 0 0-3 0Zm-4 11a1.5 1.5 0 1 0 3 0 1.5 1.5 0 0 0-3 0ZM3.5 17a1.5 1.5 0 1 1 0-3 1.5 1.5 0 0 1 0 3ZM6 4.5a1.5 1.5 0 1 0 3 0 1.5 1.5 0 0 0-3 0Zm8.11.75H9.9a2.5 2.5 0 0 0 0-1.5h4.22a2.5 2.5 0 0 0 0 1.5ZM3.61 13 5.98 6.5c.4.3.88.48 1.41.5l-2.37 6.52c-.4-.3-.88-.48-1.41-.5Zm6.5 3.25H5.9a2.5 2.5 0 0 0 0-1.5h4.22a2.5 2.5 0 0 0 0 1.5Zm2.5-3.25 2.37-6.51c.4.3.88.48 1.41.5l-2.37 6.52c-.4-.3-.88-.48-1.41-.5Z"]));
export const SelectObjectSkewRegular = ( /*#__PURE__*/createFluentIcon('SelectObjectSkewRegular', "1em", ["M16.49 6h.01a1.5 1.5 0 1 0-1.41-2l-.01.02A1.5 1.5 0 0 0 16.48 6Zm-5.4 10a1.5 1.5 0 1 0 1.42-2h-.01c-.65 0-1.2.42-1.41 1l-.01.02a1.5 1.5 0 0 0 0 .98ZM3.5 17a1.5 1.5 0 1 1 0-3 1.5 1.5 0 0 1 0 3ZM7.49 6a1.5 1.5 0 1 0 .02-3 1.5 1.5 0 0 0-.02 3Zm-3.62 7.03 2.32-6.4c.28.17.6.3.94.34l-2.32 6.4c-.28-.17-.6-.3-.94-.34ZM14.05 5h-4.1a2.51 2.51 0 0 0 0-1h4.1a2.51 2.51 0 0 0 0 1Zm-8.1 11h4.1a2.51 2.51 0 0 1 0-1h-4.1a2.51 2.51 0 0 1 0 1Zm6.92-2.97 2.32-6.4c.28.17.6.3.94.34l-2.32 6.4c-.28-.17-.6-.3-.94-.34Z"]));
export const SelectObjectSkewDismissFilled = ( /*#__PURE__*/createFluentIcon('SelectObjectSkewDismissFilled', "1em", ["M15 4.5a1.5 1.5 0 1 0 3 0 1.5 1.5 0 0 0-3 0Zm-13 11a1.5 1.5 0 1 0 3 0 1.5 1.5 0 0 0-3 0Zm4-11a1.5 1.5 0 1 0 3 0 1.5 1.5 0 0 0-3 0Zm3.89.75h4.22a2.5 2.5 0 0 1 0-1.5H9.9a2.5 2.5 0 0 1 0 1.5ZM3.6 13 5.98 6.5c.4.3.88.48 1.41.5l-2.37 6.52c-.4-.3-.88-.48-1.41-.5Zm2.28 3.25h3.4a5.48 5.48 0 0 1-.28-1.5H5.89a2.5 2.5 0 0 1 0 1.5ZM16.39 7l-.77 2.11a5.52 5.52 0 0 0-1.56-.1l.92-2.52c.4.3.88.48 1.41.5ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.65-1.15a.5.5 0 0 0-.7-.7l-1.15 1.14-1.15-1.14a.5.5 0 0 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 0 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 0 0 .7-.7l-1.14-1.15 1.14-1.15Z"]));
export const SelectObjectSkewDismissRegular = ( /*#__PURE__*/createFluentIcon('SelectObjectSkewDismissRegular', "1em", ["M16.49 6h.01a1.5 1.5 0 1 0-1.41-2l-.01.02a1.5 1.5 0 0 0 .47 1.64c.26.21.58.34.94.34ZM2 15.5a1.5 1.5 0 1 0 2.92-.48V15a1.5 1.5 0 0 0-1.4-1H3.5c-.83 0-1.5.67-1.5 1.5ZM7.49 6h.01c.65 0 1.2-.42 1.41-1l.01-.02a1.5 1.5 0 1 0-2.37.68c.26.21.58.34.94.34Zm-1.3.63-2.32 6.4c.34.05.66.17.94.34l2.32-6.4a2.48 2.48 0 0 1-.94-.34ZM14.05 5h-4.1a2.51 2.51 0 0 0 0-1h4.1a2.51 2.51 0 0 0 0 1Zm.45 4c.3 0 .59.02.87.07l.76-2.1a2.48 2.48 0 0 1-.94-.34L14.33 9h.17Zm-5.48 6c.03.34.1.68.19 1H5.95a2.51 2.51 0 0 0 0-1h3.07Zm9.98-.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.65-1.15a.5.5 0 0 0-.7-.7l-1.15 1.14-1.15-1.14a.5.5 0 0 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 0 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 0 0 .7-.7l-1.14-1.15 1.14-1.15Z"]));
export const SelectObjectSkewEditFilled = ( /*#__PURE__*/createFluentIcon('SelectObjectSkewEditFilled', "1em", ["M15 4.5a1.5 1.5 0 1 0 3 0 1.5 1.5 0 0 0-3 0Zm-13 11a1.5 1.5 0 1 0 3 0 1.5 1.5 0 0 0-3 0Zm4-11a1.5 1.5 0 1 0 3 0 1.5 1.5 0 0 0-3 0Zm3.89.75h4.22a2.5 2.5 0 0 1 0-1.5H9.9a2.5 2.5 0 0 1 0 1.5ZM3.6 13 5.98 6.5c.4.3.88.48 1.41.5l-2.37 6.52c-.4-.3-.88-.48-1.41-.5Zm2.28 3.25H9.4l.02-.1c.12-.46.34-.9.65-1.26 0-.05.02-.1.03-.14H5.9a2.5 2.5 0 0 1 0 1.5ZM16.39 7l-.92 2.53-.37.31-2.1 2.1 1.98-5.45c.4.3.88.48 1.41.5Zm-5.41 8.38 4.83-4.83a1.87 1.87 0 1 1 2.64 2.64l-4.83 4.83a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.07l.37-1.5c.1-.39.3-.74.58-1.02Z"]));
export const SelectObjectSkewEditRegular = ( /*#__PURE__*/createFluentIcon('SelectObjectSkewEditRegular', "1em", ["M16.49 6h.01a1.5 1.5 0 1 0-1.41-2l-.01.02a1.5 1.5 0 0 0 .47 1.64c.26.21.58.34.94.34ZM2 15.5a1.5 1.5 0 1 0 2.92-.48V15a1.5 1.5 0 0 0-1.4-1H3.5c-.83 0-1.5.67-1.5 1.5ZM7.49 6h.01c.65 0 1.2-.42 1.41-1l.01-.02a1.5 1.5 0 1 0-2.37.68c.26.21.58.34.94.34Zm-1.3.63-2.32 6.4c.34.05.66.17.94.34l2.32-6.4a2.48 2.48 0 0 1-.94-.34ZM14.05 5h-4.1a2.51 2.51 0 0 0 0-1h4.1a2.51 2.51 0 0 0 0 1Zm-.64 6.53 1.67-1.67 1.05-2.89a2.48 2.48 0 0 1-.94-.34l-1.78 4.9ZM5.95 16h3.52c.11-.36.29-.7.52-1H5.95a2.51 2.51 0 0 1 0 1Zm5.03-.62 4.83-4.83a1.87 1.87 0 1 1 2.64 2.64l-4.83 4.83a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.07l.37-1.5c.1-.39.3-.74.58-1.02Z"]));
export const SendColor = ( /*#__PURE__*/createFluentIcon('SendColor', "1em", `<path d="M11.5 9.5a.5.5 0 0 1 0 1l-8.12 1.77.6-2.27-.6-2.27L11.5 9.5Z" fill="url(#ic_fluent_send_20_color__a)"/><path d="M2.72 2.05a.5.5 0 0 0-.7.58l1.5 5.62c.05.19.2.33.4.36l6.85 1.14c.28.05.28.45 0 .5l-6.85 1.14a.5.5 0 0 0-.4.36l-1.5 5.62a.5.5 0 0 0 .7.58l15-7.5a.5.5 0 0 0 0-.9l-15-7.5Z" fill="url(#ic_fluent_send_20_color__b)"/><path d="M2.72 2.05a.5.5 0 0 0-.7.58l1.5 5.62c.05.19.2.33.4.36l6.85 1.14c.28.05.28.45 0 .5l-6.85 1.14a.5.5 0 0 0-.4.36l-1.5 5.62a.5.5 0 0 0 .7.58l15-7.5a.5.5 0 0 0 0-.9l-15-7.5Z" fill="url(#ic_fluent_send_20_color__c)"/><defs><linearGradient id="ic_fluent_send_20_color__b" x1="2" y1="-4.5" x2="15.7" y2="13.71" gradientUnits="userSpaceOnUse"><stop stop-color="#3BD5FF"/><stop offset="1" stop-color="#0094F0"/></linearGradient><linearGradient id="ic_fluent_send_20_color__c" x1="10" y1="6.31" x2="14.16" y2="17.57" gradientUnits="userSpaceOnUse"><stop offset=".13" stop-color="#DCF8FF" stop-opacity="0"/><stop offset=".77" stop-color="#FF6CE8" stop-opacity=".7"/></linearGradient><radialGradient id="ic_fluent_send_20_color__a" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(7 0 0 .9275 1.5 10)"><stop stop-color="#0094F0"/><stop offset="1" stop-color="#2052CB"/></radialGradient></defs>`, { color: true }));
export const SendFilled = ( /*#__PURE__*/createFluentIcon('SendFilled', "1em", ["M2.72 2.05a.5.5 0 0 0-.7.58l1.5 5.62c.05.19.2.33.4.36l6.85 1.14c.28.05.28.45 0 .5l-6.85 1.14a.5.5 0 0 0-.4.36l-1.5 5.62a.5.5 0 0 0 .7.58l15-7.5a.5.5 0 0 0 0-.9l-15-7.5Z"], { flipInRtl: true }));
export const SendRegular = ( /*#__PURE__*/createFluentIcon('SendRegular', "1em", ["M2.18 2.11a.5.5 0 0 1 .54-.06l15 7.5a.5.5 0 0 1 0 .9l-15 7.5a.5.5 0 0 1-.7-.58L3.98 10 2.02 2.63a.5.5 0 0 1 .16-.52Zm2.7 8.39-1.61 6.06L16.38 10 3.27 3.44 4.88 9.5h6.62a.5.5 0 1 1 0 1H4.88Z"], { flipInRtl: true }));
export const SendBeakerFilled = ( /*#__PURE__*/createFluentIcon('SendBeakerFilled', "1em", ["M2.72 1.55a.5.5 0 0 0-.7.58l1.5 5.62c.05.19.2.33.4.36l6.85 1.14c.28.05.28.45 0 .5l-6.85 1.14a.5.5 0 0 0-.4.36l-1.5 5.62a.5.5 0 0 0 .7.58l9.74-4.87A1.5 1.5 0 0 1 13.5 10h4.11l.11-.05a.5.5 0 0 0 0-.9l-15-7.5ZM17 14.4a2 2 0 0 0 .22.92l.35.68h-4.14l.35-.67a2 2 0 0 0 .22-.92V12h-.5a.5.5 0 1 1 0-1h4a.5.5 0 0 1 0 1H17v2.4ZM12.9 17l-.8 1.54a1 1 0 0 0 .9 1.46H18a1 1 0 0 0 .89-1.46l-.8-1.54H12.9Z"], { flipInRtl: true }));
export const SendBeakerRegular = ( /*#__PURE__*/createFluentIcon('SendBeakerRegular', "1em", ["M2.18 1.61a.5.5 0 0 1 .54-.06L17.5 10h-.01a.5.5 0 0 1-.21-.05l-14.01-7L4.88 9h6.62a.5.5 0 1 1 0 1H4.88l-1.61 6.06L12 11.69c.04.35.2.66.45.89l-9.74 4.87a.5.5 0 0 1-.7-.58L3.98 9.5 2.02 2.13a.5.5 0 0 1 .16-.52Zm.54-.06L17.51 10a.5.5 0 0 0 .21-.95l-15-7.5ZM17 14.4a2 2 0 0 0 .22.92l.35.68h-4.14l.35-.67a2 2 0 0 0 .22-.92V12h-.5a.5.5 0 1 1 0-1h4a.5.5 0 0 1 0 1H17v2.4ZM12.9 17l-.8 1.54a1 1 0 0 0 .9 1.46H18a1 1 0 0 0 .89-1.46l-.8-1.54H12.9Z"], { flipInRtl: true }));
export const SendClockColor = ( /*#__PURE__*/createFluentIcon('SendClockColor', "1em", `<path d="M11.5 9.5a.5.5 0 0 1 0 1l-8.12 1.77.6-2.27-.6-2.27L11.5 9.5Z" fill="url(#ic_fluent_send_clock_20_color__a)"/><path d="M2.72 2.05a.5.5 0 0 0-.7.58l1.5 5.62c.05.19.2.33.4.36l6.85 1.14c.28.05.28.45 0 .5l-6.85 1.14a.5.5 0 0 0-.4.36l-1.5 5.62a.5.5 0 0 0 .7.58l15-7.5a.5.5 0 0 0 0-.9l-15-7.5Z" fill="url(#ic_fluent_send_clock_20_color__b)"/><path d="M2.72 2.05a.5.5 0 0 0-.7.58l1.5 5.62c.05.19.2.33.4.36l6.85 1.14c.28.05.28.45 0 .5l-6.85 1.14a.5.5 0 0 0-.4.36l-1.5 5.62a.5.5 0 0 0 .7.58l15-7.5a.5.5 0 0 0 0-.9l-15-7.5Z" fill="url(#ic_fluent_send_clock_20_color__c)"/><path d="M2.72 2.05a.5.5 0 0 0-.7.58l1.5 5.62c.05.19.2.33.4.36l6.85 1.14c.28.05.28.45 0 .5l-6.85 1.14a.5.5 0 0 0-.4.36l-1.5 5.62a.5.5 0 0 0 .7.58l15-7.5a.5.5 0 0 0 0-.9l-15-7.5Z" fill="url(#ic_fluent_send_clock_20_color__d)" fill-opacity=".3"/><path d="M19 14.5a4.5 4.5 0 1 0-9 0 4.5 4.5 0 0 0 9 0Z" fill="url(#ic_fluent_send_clock_20_color__e)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 12c.28 0 .5.22.5.5V14h1a.5.5 0 0 1 0 1h-1.5a.5.5 0 0 1-.5-.5v-2c0-.28.22-.5.5-.5Z" fill="url(#ic_fluent_send_clock_20_color__f)"/><defs><linearGradient id="ic_fluent_send_clock_20_color__b" x1="2" y1="-4.5" x2="15.7" y2="13.71" gradientUnits="userSpaceOnUse"><stop stop-color="#3BD5FF"/><stop offset="1" stop-color="#0094F0"/></linearGradient><linearGradient id="ic_fluent_send_clock_20_color__c" x1="10" y1="6.31" x2="14.16" y2="17.57" gradientUnits="userSpaceOnUse"><stop offset=".13" stop-color="#DCF8FF" stop-opacity="0"/><stop offset=".77" stop-color="#FF6CE8" stop-opacity=".7"/></linearGradient><linearGradient id="ic_fluent_send_clock_20_color__e" x1="11.5" y1="9.5" x2="16" y2="19.5" gradientUnits="userSpaceOnUse"><stop stop-color="#43E5CA"/><stop offset="1" stop-color="#2764E7"/></linearGradient><linearGradient id="ic_fluent_send_clock_20_color__f" x1="14.22" y1="12.46" x2="13.51" y2="14.89" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#D1D1FF"/></linearGradient><radialGradient id="ic_fluent_send_clock_20_color__a" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(7 0 0 .9275 1.5 10)"><stop stop-color="#0094F0"/><stop offset="1" stop-color="#2052CB"/></radialGradient><radialGradient id="ic_fluent_send_clock_20_color__d" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(1 8.5 -6.67857 .78571 14.5 16.5)"><stop offset=".76" stop-color="#1B44B1"/><stop offset="1" stop-color="#1B44B1" stop-opacity="0"/></radialGradient></defs>`, { color: true }));
export const SendClockFilled = ( /*#__PURE__*/createFluentIcon('SendClockFilled', "1em", ["M2.72 1.05a.5.5 0 0 0-.7.58l1.5 5.62c.05.19.2.33.4.36l6.85 1.14c.28.05.28.45 0 .5l-6.85 1.14a.5.5 0 0 0-.4.36l-1.5 5.62a.5.5 0 0 0 .7.58l6.33-3.16A5.5 5.5 0 0 1 17.2 9.7l.52-.26a.5.5 0 0 0 0-.9l-15-7.5ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM14.5 12a.5.5 0 0 0-.5.5v2c0 .28.22.5.5.5H16a.5.5 0 0 0 0-1h-1v-1.5a.5.5 0 0 0-.5-.5Z"], { flipInRtl: true }));
export const SendClockRegular = ( /*#__PURE__*/createFluentIcon('SendClockRegular', "1em", ["M2.18 1.11a.5.5 0 0 1 .54-.06l15 7.5a.5.5 0 1 1-.44.9l-14.01-7L4.88 8.5h6.62a.5.5 0 1 1 0 1H4.88l-1.61 6.06 6.1-3.06c-.15.41-.27.84-.32 1.29l-6.33 3.16a.5.5 0 0 1-.7-.58L3.98 9 2.02 1.63a.5.5 0 0 1 .16-.52ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM14.5 12a.5.5 0 0 0-.5.5v2c0 .28.22.5.5.5H16a.5.5 0 0 0 0-1h-1v-1.5a.5.5 0 0 0-.5-.5Z"], { flipInRtl: true }));
export const SendCopyFilled = ( /*#__PURE__*/createFluentIcon('SendCopyFilled', "1em", ["M8.47 2.22c.3-.3.77-.3 1.06 0l2.5 2.5a.75.75 0 0 1-1.06 1.06L9.75 4.56v6.69a.75.75 0 0 1-1.5 0V4.56L7.03 5.78a.75.75 0 0 1-1.06-1.06l2.5-2.5ZM5.57 16.5A2 2 0 0 0 7.5 18H13a4.5 4.5 0 0 0 4.5-4.5v-2.25a.75.75 0 0 0-1.5 0v2.25a3 3 0 0 1-3 3H5.57ZM4.5 8.75a.75.75 0 0 0-1.5 0v4.75c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V8.75a.75.75 0 0 0-1.5 0v4.75a.5.5 0 0 1-.5.5H5a.5.5 0 0 1-.5-.5V8.75Z"]));
export const SendCopyRegular = ( /*#__PURE__*/createFluentIcon('SendCopyRegular', "1em", ["M8.65 2.15c.2-.2.5-.2.7 0l3 3a.5.5 0 0 1-.7.7L9.5 3.71v7.79a.5.5 0 0 1-1 0V3.7L6.35 5.86a.5.5 0 1 1-.7-.7l3-3ZM5.27 17c.34.6.99 1 1.73 1h6a4 4 0 0 0 4-4v-3.5a.5.5 0 1 0-1 0V14a3 3 0 0 1-3 3H5.27ZM4 8.5a.5.5 0 0 0-1 0V14c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V8.5a.5.5 0 0 0-1 0V14a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V8.5Z"]));
export const SendPersonFilled = ( /*#__PURE__*/createFluentIcon('SendPersonFilled', "1em", ["M2.72 2.05a.5.5 0 0 0-.7.58l1.5 5.62c.05.19.2.33.4.36l6.85 1.14c.28.05.28.45 0 .5l-6.85 1.14a.5.5 0 0 0-.4.36l-1.5 5.62a.5.5 0 0 0 .7.58l9.78-4.9V13a3 3 0 0 1 4.85-2.36l.37-.2a.5.5 0 0 0 0-.89l-15-7.5ZM17.5 13a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm1.5 4.5c0 1.25-1 2.5-3.5 2.5S12 18.75 12 17.5c0-.83.67-1.5 1.5-1.5h4c.83 0 1.5.67 1.5 1.5Z"], { flipInRtl: true }));
export const SendPersonRegular = ( /*#__PURE__*/createFluentIcon('SendPersonRegular', "1em", ["M2.18 2.11a.5.5 0 0 1 .54-.06l15 7.5a.5.5 0 0 1-.44.9l-14.01-7L4.88 9.5h6.62a.5.5 0 1 1 0 1H4.88l-1.61 6.06 9.47-4.74a2.99 2.99 0 0 0-.24 1.24l-9.78 4.89a.5.5 0 0 1-.7-.58L3.98 10 2.02 2.63a.5.5 0 0 1 .16-.52ZM15.5 15a2 2 0 1 0 0-4 2 2 0 0 0 0 4Zm0 5c2.5 0 3.5-1.25 3.5-2.5 0-.83-.67-1.5-1.5-1.5h-4c-.83 0-1.5.67-1.5 1.5 0 1.25 1 2.5 3.5 2.5Z"], { flipInRtl: true }));
export const SerialPortFilled = ( /*#__PURE__*/createFluentIcon('SerialPortFilled', "1em", ["M2.33 9.07A2.5 2.5 0 0 1 4.77 6h10.46a2.5 2.5 0 0 1 2.43 3.07l-.7 3A2.5 2.5 0 0 1 14.53 14H5.47a2.5 2.5 0 0 1-2.44-1.93l-.7-3ZM6 9.5a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1ZM8.5 9a.5.5 0 1 0-1 0 .5.5 0 0 0 1 0ZM7 11.5a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1Zm2.5-.5a.5.5 0 1 0-1 0 .5.5 0 0 0 1 0Zm1.5.5a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1Zm2.5-.5a.5.5 0 1 0-1 0 .5.5 0 0 0 1 0ZM10 9.5a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1Zm2.5-.5a.5.5 0 1 0-1 0 .5.5 0 0 0 1 0Zm1.5.5a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1Z"]));
export const SerialPortRegular = ( /*#__PURE__*/createFluentIcon('SerialPortRegular', "1em", ["M6 9.5a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1ZM8.5 9a.5.5 0 1 1-1 0 .5.5 0 0 1 1 0ZM7 11.5a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1Zm2.5-.5a.5.5 0 1 1-1 0 .5.5 0 0 1 1 0Zm1.5.5a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1Zm2.5-.5a.5.5 0 1 1-1 0 .5.5 0 0 1 1 0ZM10 9.5a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1Zm2.5-.5a.5.5 0 1 1-1 0 .5.5 0 0 1 1 0Zm1.5.5a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1ZM4.77 6a2.5 2.5 0 0 0-2.44 3.07l.7 3A2.5 2.5 0 0 0 5.47 14h9.06a2.5 2.5 0 0 0 2.43-1.93l.7-3A2.5 2.5 0 0 0 15.23 6H4.77ZM3.3 8.84A1.5 1.5 0 0 1 4.77 7h10.46c.97 0 1.68.9 1.46 1.84l-.7 3A1.5 1.5 0 0 1 14.53 13H5.47c-.7 0-1.3-.48-1.46-1.16l-.7-3Z"]));
export const ServerFilled = ( /*#__PURE__*/createFluentIcon('ServerFilled', "1em", ["M7.5 2A2.5 2.5 0 0 0 5 4.5v11A2.5 2.5 0 0 0 7.5 18h5a2.5 2.5 0 0 0 2.5-2.5v-11A2.5 2.5 0 0 0 12.5 2h-5ZM7 5.5c0-.28.22-.5.5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5Zm0 7c0-.28.22-.5.5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5Zm0 2c0-.28.22-.5.5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5Z"]));
export const ServerRegular = ( /*#__PURE__*/createFluentIcon('ServerRegular', "1em", ["M7.5 5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5ZM7 12.5c0-.28.22-.5.5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5Zm.5 1.5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5ZM5 4.5A2.5 2.5 0 0 1 7.5 2h5A2.5 2.5 0 0 1 15 4.5v11a2.5 2.5 0 0 1-2.5 2.5h-5A2.5 2.5 0 0 1 5 15.5v-11ZM7.5 3C6.67 3 6 3.67 6 4.5v11c0 .83.67 1.5 1.5 1.5h5c.83 0 1.5-.67 1.5-1.5v-11c0-.83-.67-1.5-1.5-1.5h-5Z"]));
export const ServerLinkFilled = ( /*#__PURE__*/createFluentIcon('ServerLinkFilled', "1em", ["M7.5 2A2.5 2.5 0 0 0 5 4.5v11A2.5 2.5 0 0 0 7.5 18h1.84a3.49 3.49 0 0 1 0-3H7.5a.5.5 0 0 1 0-1h2.55c.63-.62 1.5-1 2.45-1H15V4.5A2.5 2.5 0 0 0 12.5 2h-5Zm5 11h-5a.5.5 0 0 1 0-1h5a.5.5 0 0 1 0 1ZM7 5.5c0-.28.22-.5.5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5Zm5.5 8.5a2.5 2.5 0 0 0 0 5h.5a.5.5 0 0 0 0-1h-.5a1.5 1.5 0 0 1 0-3h.5a.5.5 0 0 0 0-1h-.5Zm3.5 0a.5.5 0 0 0 0 1h.5a1.5 1.5 0 0 1 0 3H16a.5.5 0 0 0 0 1h.5a2.5 2.5 0 0 0 0-5H16Zm-4 2.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z"]));
export const ServerLinkRegular = ( /*#__PURE__*/createFluentIcon('ServerLinkRegular', "1em", ["M7.5 5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5ZM7 12.5c0-.28.22-.5.5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5Zm7-8V13h1V4.5A2.5 2.5 0 0 0 12.5 2h-5A2.5 2.5 0 0 0 5 4.5v11A2.5 2.5 0 0 0 7.5 18h1.84a3.48 3.48 0 0 1-.3-1H7.5A1.5 1.5 0 0 1 6 15.5v-11C6 3.67 6.67 3 7.5 3h5c.83 0 1.5.67 1.5 1.5ZM9.34 15c.17-.37.42-.71.71-1H7.5a.5.5 0 0 0 0 1h1.84Zm3.16-1a2.5 2.5 0 0 0 0 5h.5a.5.5 0 0 0 0-1h-.5a1.5 1.5 0 0 1 0-3h.5a.5.5 0 0 0 0-1h-.5Zm3.5 0a.5.5 0 0 0 0 1h.5a1.5 1.5 0 0 1 0 3H16a.5.5 0 0 0 0 1h.5a2.5 2.5 0 0 0 0-5H16Zm-4 2.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z"]));
export const ServerMultipleFilled = ( /*#__PURE__*/createFluentIcon('ServerMultipleFilled', "1em", ["M7.5 2A2.5 2.5 0 0 0 5 4.5v11A2.5 2.5 0 0 0 7.5 18h5a2.5 2.5 0 0 0 2.5-2.5v-11A2.5 2.5 0 0 0 12.5 2h-5Zm0 3h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1 0-1ZM7 12.5c0-.28.22-.5.5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5Zm0 2c0-.28.22-.5.5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5ZM2 7c0-1.1.9-2 2-2v10.5c0 .17.01.34.04.5H4a2 2 0 0 1-2-2V7Zm14 8.5c0 .17-.01.34-.04.5H16a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2v10.5Z"]));
export const ServerMultipleRegular = ( /*#__PURE__*/createFluentIcon('ServerMultipleRegular', "1em", ["M7.5 5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5ZM7 12.5c0-.28.22-.5.5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5Zm.5 1.5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5ZM5 4.5A2.5 2.5 0 0 1 7.5 2h5A2.5 2.5 0 0 1 15 4.5V5h1a2 2 0 0 1 2 2v7a2 2 0 0 1-2 2h-1.05a2.5 2.5 0 0 1-2.45 2h-5a2.5 2.5 0 0 1-2.45-2H4a2 2 0 0 1-2-2V7c0-1.1.9-2 2-2h1v-.5ZM15 15h1a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1h-1v9ZM5 6H4a1 1 0 0 0-1 1v7a1 1 0 0 0 1 1h1V6Zm2.5-3C6.67 3 6 3.67 6 4.5v11c0 .83.67 1.5 1.5 1.5h5c.83 0 1.5-.67 1.5-1.5v-11c0-.83-.67-1.5-1.5-1.5h-5Z"]));
export const ServerPlayFilled = ( /*#__PURE__*/createFluentIcon('ServerPlayFilled', "1em", ["M7.5 2A2.5 2.5 0 0 0 5 4.5v11A2.5 2.5 0 0 0 7.5 18h2.76a5.47 5.47 0 0 1-1.24-3H7.5a.5.5 0 0 1 0-1h1.52c.03-.34.1-.68.19-1H7.5a.5.5 0 0 1 0-1h2.1A5.5 5.5 0 0 1 15 9.02V4.5A2.5 2.5 0 0 0 12.5 2h-5ZM7 5.5c0-.28.22-.5.5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5Zm12 9a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.29-.44-2.97-1.65a.5.5 0 0 0-.74.44v3.3c0 .38.41.62.74.44l2.97-1.65a.5.5 0 0 0 0-.88Z"]));
export const ServerPlayRegular = ( /*#__PURE__*/createFluentIcon('ServerPlayRegular', "1em", ["M14 9.02V4.5c0-.83-.67-1.5-1.5-1.5h-5C6.67 3 6 3.67 6 4.5v11c0 .83.67 1.5 1.5 1.5h2.1c.18.36.4.7.66 1H7.5A2.5 2.5 0 0 1 5 15.5v-11A2.5 2.5 0 0 1 7.5 2h5A2.5 2.5 0 0 1 15 4.5v4.52a5.57 5.57 0 0 0-1 0ZM7.5 5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5ZM7 12.5c0-.28.22-.5.5-.5h2.1c-.16.32-.3.65-.4 1H7.5a.5.5 0 0 1-.5-.5Zm2 2c0-.17 0-.34.02-.5H7.5a.5.5 0 0 0 0 1h1.52a5.57 5.57 0 0 1-.02-.5Zm10 0a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.29-.44-2.97-1.65a.5.5 0 0 0-.74.44v3.3c0 .38.41.62.74.44l2.97-1.65a.5.5 0 0 0 0-.88Z"]));
export const ServiceBellFilled = ( /*#__PURE__*/createFluentIcon('ServiceBellFilled', "1em", ["M8 5a2 2 0 1 1 4 0v.79a7 7 0 0 1 5 6.71.5.5 0 0 1-.5.5h-13a.5.5 0 0 1-.5-.5 7 7 0 0 1 5-6.71V5Zm2.5 3.5c.42 0 .84 0 1.27.16.41.15.87.45 1.31 1.12a.5.5 0 0 0 .84-.56 3.66 3.66 0 0 0-1.81-1.5 4.51 4.51 0 0 0-1.59-.22h-.02a.5.5 0 0 0 0 1Zm-7 5.5a1.5 1.5 0 0 0 0 3h13a1.5 1.5 0 0 0 0-3h-13Z"]));
export const ServiceBellRegular = ( /*#__PURE__*/createFluentIcon('ServiceBellRegular', "1em", ["M10.5 8.5c.42 0 .84 0 1.27.16.41.15.87.45 1.31 1.12a.5.5 0 0 0 .84-.56 3.66 3.66 0 0 0-1.81-1.5 4.51 4.51 0 0 0-1.59-.22h-.02a.5.5 0 0 0 0 1ZM8 5v.79a7 7 0 0 0-5 6.71c0 .28.22.5.5.5h13a.5.5 0 0 0 .5-.5 7 7 0 0 0-5-6.71V5a2 2 0 1 0-4 0Zm2-1a1 1 0 0 1 1 1v.57a7.06 7.06 0 0 0-2 0V5a1 1 0 0 1 1-1Zm0 2.5a6 6 0 0 1 5.98 5.5H4.02A6 6 0 0 1 10 6.5ZM3.5 14a1.5 1.5 0 0 0 0 3h13a1.5 1.5 0 0 0 0-3h-13ZM3 15.5c0-.28.22-.5.5-.5h13a.5.5 0 0 1 0 1h-13a.5.5 0 0 1-.5-.5Z"]));
export const SettingsColor = ( /*#__PURE__*/createFluentIcon('SettingsColor', "1em", `<path d="M1.91 7.38A8.5 8.5 0 0 1 3.7 4.3a.5.5 0 0 1 .54-.13l1.92.68a1 1 0 0 0 1.32-.76l.36-2a.5.5 0 0 1 .4-.4 8.53 8.53 0 0 1 3.55 0c.2.04.35.2.38.4l.37 2a1 1 0 0 0 1.32.76l1.92-.68a.5.5 0 0 1 .54.13 8.5 8.5 0 0 1 1.78 3.08c.06.2 0 .4-.15.54l-1.56 1.32a1 1 0 0 0 0 1.52l1.56 1.32a.5.5 0 0 1 .15.54 8.5 8.5 0 0 1-1.78 3.08.5.5 0 0 1-.54.13l-1.92-.68a1 1 0 0 0-1.32.76l-.37 2a.5.5 0 0 1-.38.4 8.53 8.53 0 0 1-3.56 0 .5.5 0 0 1-.39-.4l-.36-2a1 1 0 0 0-1.32-.76l-1.92.68a.5.5 0 0 1-.54-.13 8.5 8.5 0 0 1-1.78-3.08.5.5 0 0 1 .15-.54l1.56-1.32a1 1 0 0 0 0-1.52L2.06 7.92a.5.5 0 0 1-.15-.54ZM8 10a2 2 0 1 0 4 0 2 2 0 0 0-4 0Z" fill="url(#ic_fluent_settings_20_color__a)"/><defs><linearGradient id="ic_fluent_settings_20_color__a" x1="14.06" y1="17.84" x2="4.53" y2="3.07" gradientUnits="userSpaceOnUse"><stop stop-color="#70777D"/><stop offset="1" stop-color="#B9C0C7"/></linearGradient></defs>`, { color: true }));
export const SettingsFilled = ( /*#__PURE__*/createFluentIcon('SettingsFilled', "1em", ["M1.91 7.38A8.5 8.5 0 0 1 3.7 4.3a.5.5 0 0 1 .54-.13l1.92.68a1 1 0 0 0 1.32-.76l.36-2a.5.5 0 0 1 .4-.4 8.53 8.53 0 0 1 3.55 0c.2.04.35.2.38.4l.37 2a1 1 0 0 0 1.32.76l1.92-.68a.5.5 0 0 1 .54.13 8.5 8.5 0 0 1 1.78 3.08c.06.2 0 .4-.15.54l-1.56 1.32a1 1 0 0 0 0 1.52l1.56 1.32a.5.5 0 0 1 .15.54 8.5 8.5 0 0 1-1.78 3.08.5.5 0 0 1-.54.13l-1.92-.68a1 1 0 0 0-1.32.76l-.37 2a.5.5 0 0 1-.38.4 8.53 8.53 0 0 1-3.56 0 .5.5 0 0 1-.39-.4l-.36-2a1 1 0 0 0-1.32-.76l-1.92.68a.5.5 0 0 1-.54-.13 8.5 8.5 0 0 1-1.78-3.08.5.5 0 0 1 .15-.54l1.56-1.32a1 1 0 0 0 0-1.52L2.06 7.92a.5.5 0 0 1-.15-.54ZM8 10a2 2 0 1 0 4 0 2 2 0 0 0-4 0Z"]));
export const SettingsRegular = ( /*#__PURE__*/createFluentIcon('SettingsRegular', "1em", ["M1.91 7.38A8.5 8.5 0 0 1 3.7 4.3a.5.5 0 0 1 .54-.13l1.92.68a1 1 0 0 0 1.32-.76l.36-2a.5.5 0 0 1 .4-.4 8.53 8.53 0 0 1 3.55 0c.2.04.35.2.38.4l.37 2a1 1 0 0 0 1.32.76l1.92-.68a.5.5 0 0 1 .54.13 8.5 8.5 0 0 1 1.78 3.08c.06.2 0 .4-.15.54l-1.56 1.32a1 1 0 0 0 0 1.52l1.56 1.32a.5.5 0 0 1 .15.54 8.5 8.5 0 0 1-1.78 3.08.5.5 0 0 1-.54.13l-1.92-.68a1 1 0 0 0-1.32.76l-.37 2a.5.5 0 0 1-.38.4 8.53 8.53 0 0 1-3.56 0 .5.5 0 0 1-.39-.4l-.36-2a1 1 0 0 0-1.32-.76l-1.92.68a.5.5 0 0 1-.54-.13 8.5 8.5 0 0 1-1.78-3.08.5.5 0 0 1 .15-.54l1.56-1.32a1 1 0 0 0 0-1.52L2.06 7.92a.5.5 0 0 1-.15-.54Zm1.06 0 1.3 1.1a2 2 0 0 1 0 3.04l-1.3 1.1c.3.79.72 1.51 1.25 2.16l1.6-.58a2 2 0 0 1 2.63 1.53l.3 1.67a7.56 7.56 0 0 0 2.5 0l.3-1.67a2 2 0 0 1 2.64-1.53l1.6.58a7.5 7.5 0 0 0 1.24-2.16l-1.3-1.1a2 2 0 0 1 0-3.04l1.3-1.1a7.5 7.5 0 0 0-1.25-2.16l-1.6.58a2 2 0 0 1-2.63-1.53l-.3-1.67a7.55 7.55 0 0 0-2.5 0l-.3 1.67A2 2 0 0 1 5.81 5.8l-1.6-.58a7.5 7.5 0 0 0-1.24 2.16ZM7.5 10a2.5 2.5 0 1 1 5 0 2.5 2.5 0 0 1-5 0Zm1 0a1.5 1.5 0 1 0 3 0 1.5 1.5 0 0 0-3 0Z"]));
export const SettingsChatFilled = ( /*#__PURE__*/createFluentIcon('SettingsChatFilled', "1em", ["M1.91 7.38A8.5 8.5 0 0 1 3.7 4.3a.5.5 0 0 1 .54-.13l1.92.68a1 1 0 0 0 1.32-.76l.36-2a.5.5 0 0 1 .4-.4 8.53 8.53 0 0 1 3.55 0c.2.04.35.2.38.4l.37 2a1 1 0 0 0 1.32.76l1.92-.68a.5.5 0 0 1 .54.13 8.5 8.5 0 0 1 1.78 3.08c.06.2 0 .4-.15.54l-1.56 1.32-.07.06a5.5 5.5 0 0 0-4.35.32 2 2 0 1 0-2.34 2.34 5.48 5.48 0 0 0-.13 4.81l-.43 1.4-.05.27a8.48 8.48 0 0 1-.79-.13.5.5 0 0 1-.39-.4l-.36-2a1 1 0 0 0-1.32-.76l-1.92.68a.5.5 0 0 1-.54-.13 8.5 8.5 0 0 1-1.78-3.08.5.5 0 0 1 .15-.54l1.56-1.32a1 1 0 0 0 0-1.52L2.06 7.92a.5.5 0 0 1-.15-.54Zm8.1 11.12a.4.4 0 0 0 .52.48l1.79-.54A4.5 4.5 0 1 0 14.5 10a4.49 4.49 0 0 0-2.72.92 4.48 4.48 0 0 0-1.21 5.77l-.55 1.78v.03ZM14.5 15a.5.5 0 0 1 0 1h-2a.5.5 0 1 1 0-1h2Zm-2-2h4a.5.5 0 1 1 0 1h-4a.5.5 0 1 1 0-1Z"]));
export const SettingsChatRegular = ( /*#__PURE__*/createFluentIcon('SettingsChatRegular', "1em", ["M1.91 7.38A8.5 8.5 0 0 1 3.7 4.3a.5.5 0 0 1 .54-.13l1.92.68a1 1 0 0 0 1.32-.76l.36-2a.5.5 0 0 1 .4-.4 8.53 8.53 0 0 1 3.55 0c.2.04.35.2.38.4l.37 2a1 1 0 0 0 1.32.76l1.92-.68a.5.5 0 0 1 .54.13 8.5 8.5 0 0 1 1.78 3.08c.06.2 0 .4-.15.54l-1.56 1.32-.07.06c-.33-.11-.68-.2-1.04-.25a2 2 0 0 1 .47-.57l1.29-1.1a7.5 7.5 0 0 0-1.25-2.16l-1.6.58a2 2 0 0 1-2.63-1.53l-.3-1.67a7.55 7.55 0 0 0-2.5 0l-.3 1.67A2 2 0 0 1 5.81 5.8l-1.6-.58a7.5 7.5 0 0 0-1.24 2.16l1.3 1.1a2 2 0 0 1 0 3.04l-1.3 1.1c.3.79.72 1.51 1.25 2.16l1.6-.58a2 2 0 0 1 2.63 1.53l.3 1.67.53.07-.22.7-.05.27a8.48 8.48 0 0 1-.79-.13.5.5 0 0 1-.39-.4l-.36-2a1 1 0 0 0-1.32-.76l-1.92.68a.5.5 0 0 1-.54-.13 8.5 8.5 0 0 1-1.78-3.08.5.5 0 0 1 .15-.54l1.56-1.32a1 1 0 0 0 0-1.52L2.06 7.92a.5.5 0 0 1-.15-.54Zm8.1 11.12a.4.4 0 0 0 .52.48l1.79-.54a4.5 4.5 0 1 0 .13-7.94 4.48 4.48 0 0 0-1.89 6.19l-.24.8-.3.98v.03ZM14.5 15a.5.5 0 0 1 0 1h-2a.5.5 0 1 1 0-1h2Zm2-1h-4a.5.5 0 1 1 0-1h4a.5.5 0 1 1 0 1ZM10 7.5a2.5 2.5 0 0 1 2.43 1.9c-.33.14-.64.3-.93.5a1.5 1.5 0 1 0-1.6 1.6c-.2.29-.36.6-.5.93A2.5 2.5 0 0 1 10 7.5Z"]));
export const SettingsCogMultipleFilled = ( /*#__PURE__*/createFluentIcon('SettingsCogMultipleFilled', "1em", ["M8 2c-.37 0-.73.04-1.08.1a.5.5 0 0 0-.4.4l-.26 1.36c-.05.25-.3.4-.54.31l-1.3-.45a.5.5 0 0 0-.55.14A5.5 5.5 0 0 0 2.8 5.74c-.07.2-.01.4.14.54l1.05.9c.19.17.19.47 0 .63l-1.05.91a.5.5 0 0 0-.14.54c.23.7.6 1.34 1.08 1.88.14.15.35.2.54.14l1.3-.45c.25-.08.5.06.55.31l.27 1.36c.03.2.19.35.39.4a5.52 5.52 0 0 0 2.17 0 .5.5 0 0 0 .4-.4l.25-1.36c.05-.25.3-.4.55-.31l1.3.45c.19.06.4 0 .54-.14a5.5 5.5 0 0 0 1.08-1.89.5.5 0 0 0-.14-.53l-1.04-.9a.42.42 0 0 1 0-.63l1.04-.9a.5.5 0 0 0 .14-.54 5.5 5.5 0 0 0-1.08-1.89.5.5 0 0 0-.54-.14l-1.3.45a.42.42 0 0 1-.55-.31L9.48 2.5a.5.5 0 0 0-.4-.4C8.75 2.05 8.39 2 8 2ZM6.5 7.5a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0Zm4.66 4.95a.46.46 0 0 1 .53-.15l.8.27c.26.1.54-.07.6-.34l.15-.83c.04-.2.2-.36.4-.38a3.55 3.55 0 0 1 .72 0c.2.02.35.18.4.38l.15.83c.06.27.34.43.6.34l.8-.27c.19-.07.4-.02.52.15.14.2.27.4.36.62.09.19.03.4-.13.53l-.64.56c-.2.18-.2.5 0 .68l.64.56c.16.13.22.34.13.53-.1.22-.22.43-.36.62a.46.46 0 0 1-.52.15l-.8-.27a.45.45 0 0 0-.6.34l-.16.83c-.04.2-.19.36-.4.38a3.55 3.55 0 0 1-.71 0 .46.46 0 0 1-.4-.38l-.16-.83a.45.45 0 0 0-.6-.34l-.8.27c-.18.07-.4.02-.52-.15a3.5 3.5 0 0 1-.36-.62.46.46 0 0 1 .13-.53l.64-.56c.21-.18.21-.5 0-.68l-.64-.56a.46.46 0 0 1-.13-.53c.1-.22.22-.43.36-.62ZM15 14.5a1 1 0 1 0-2 0 1 1 0 0 0 2 0Z"]));
export const SettingsCogMultipleRegular = ( /*#__PURE__*/createFluentIcon('SettingsCogMultipleRegular', "1em", ["m7.44 3.03-.2 1.02A1.42 1.42 0 0 1 5.4 5.12l-.98-.34c-.22.3-.41.62-.56.97l.78.68c.65.56.65 1.57 0 2.14l-.78.68c.15.35.34.67.56.97l.98-.34c.82-.28 1.7.23 1.85 1.07l.2 1.02a4.55 4.55 0 0 0 1.13 0l.2-1.02a1.42 1.42 0 0 1 1.84-1.07l.98.34c.22-.3.41-.63.56-.98l-.78-.67a1.42 1.42 0 0 1 0-2.14l.78-.67a4.5 4.5 0 0 0-.56-.98l-.98.34a1.42 1.42 0 0 1-1.85-1.07l-.2-1.01a4.55 4.55 0 0 0-1.12 0Zm-.52-.92a5.52 5.52 0 0 1 2.17 0c.2.04.35.2.4.4l.25 1.35c.05.25.3.4.55.31l1.3-.45a.5.5 0 0 1 .54.14 5.5 5.5 0 0 1 1.08 1.89c.07.19.01.4-.14.53l-1.04.9c-.2.17-.2.47 0 .63l1.04.9a.5.5 0 0 1 .14.54 5.5 5.5 0 0 1-1.08 1.89.5.5 0 0 1-.54.14l-1.3-.45a.42.42 0 0 0-.55.31l-.26 1.36a.5.5 0 0 1-.4.4 5.52 5.52 0 0 1-2.16 0 .5.5 0 0 1-.4-.4l-.26-1.36a.42.42 0 0 0-.54-.31l-1.3.45a.5.5 0 0 1-.55-.14A5.5 5.5 0 0 1 2.8 9.26a.5.5 0 0 1 .14-.54l1.05-.9c.19-.17.19-.47 0-.63l-1.05-.91a.5.5 0 0 1-.14-.54c.23-.7.6-1.34 1.08-1.88a.5.5 0 0 1 .54-.14l1.3.45c.25.08.5-.06.55-.31l.27-1.36a.5.5 0 0 1 .39-.4Zm4.77 10.19a.46.46 0 0 0-.53.15c-.14.2-.26.4-.36.62-.08.19-.02.4.13.53l.64.56c.21.18.21.5 0 .68l-.64.56a.46.46 0 0 0-.13.53c.1.22.22.43.36.62.12.17.34.22.53.15l.8-.27c.26-.1.54.07.6.34l.15.83c.04.2.2.36.4.38a3.56 3.56 0 0 0 .72 0c.2-.02.35-.18.4-.38l.15-.83a.45.45 0 0 1 .6-.34l.8.27c.19.07.4.02.52-.15.14-.2.27-.4.36-.62a.46.46 0 0 0-.13-.53l-.64-.56a.45.45 0 0 1 0-.68l.64-.56a.46.46 0 0 0 .13-.53 3.5 3.5 0 0 0-.36-.62.46.46 0 0 0-.52-.15l-.8.27a.45.45 0 0 1-.6-.34l-.16-.83a.46.46 0 0 0-.4-.38 3.55 3.55 0 0 0-.71 0 .46.46 0 0 0-.4.38l-.16.83a.45.45 0 0 1-.6.34l-.8-.27ZM14 15.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm-7-8a1 1 0 1 1 2 0 1 1 0 0 1-2 0Zm1-2a2 2 0 1 0 0 4 2 2 0 0 0 0-4Z"]));
export const ShapeExcludeFilled = ( /*#__PURE__*/createFluentIcon('ShapeExcludeFilled', "1em", ["M2 10.5v-6A2.5 2.5 0 0 1 4.5 2h6A2.5 2.5 0 0 1 13 4.5V7H9.5A2.5 2.5 0 0 0 7 9.5V13H4.5A2.5 2.5 0 0 1 2 10.5ZM7 13v2.5A2.5 2.5 0 0 0 9.5 18h6a2.5 2.5 0 0 0 2.5-2.5v-6A2.5 2.5 0 0 0 15.5 7H13v3.5a2.5 2.5 0 0 1-2.5 2.5H7Z"]));
export const ShapeExcludeRegular = ( /*#__PURE__*/createFluentIcon('ShapeExcludeRegular', "1em", ["M2 10.53V4.5A2.5 2.5 0 0 1 4.5 2h6.06A2.49 2.49 0 0 1 13 4.5V7h2.5A2.5 2.5 0 0 1 18 9.5v6.22A2.5 2.5 0 0 1 15.5 18h-6A2.5 2.5 0 0 1 7 15.5V13H4.5a2.52 2.52 0 0 1-2.09-1.12c-.25-.38-.4-.84-.4-1.32L2 10.53ZM12 8H9.5C8.67 8 8 8.67 8 9.5V12h2.5c.83 0 1.5-.67 1.5-1.5V8ZM3 9.56v.94c0 .23.05.45.15.65l8-8A1.5 1.5 0 0 0 10.5 3h-.94L3 9.56ZM8.14 3H6.56L3 6.56v1.58L8.14 3ZM3 5.14 5.14 3H4.5C3.67 3 3 3.67 3 4.5v.64Zm8.85-1.29L8.5 7.21c.3-.14.64-.21 1-.21h.8L12 5.3v-.8c0-.23-.05-.45-.15-.65ZM7.21 8.5l-3.36 3.35c.2.1.42.15.65.15h.8L7 10.3v-.8c0-.36.07-.7.2-1ZM8 13.7v1.6l2.3-2.3H8.7l-.7.7Zm5-3.4L15.3 8h-1.6l-.7.7v1.6Zm3.4-2-8.1 8.1c.24.32.6.53 1 .59L17 9.3a1.5 1.5 0 0 0-.59-1Zm.6 2.4L10.7 17h1.6l4.7-4.7v-1.6Zm0 3L13.7 17h1.6l1.7-1.7v-1.6Z"]));
export const ShapeIntersectFilled = ( /*#__PURE__*/createFluentIcon('ShapeIntersectFilled', "1em", ["M2 4.5A2.5 2.5 0 0 1 4.5 2h6A2.5 2.5 0 0 1 13 4.5V7h2.5A2.5 2.5 0 0 1 18 9.5v6a2.5 2.5 0 0 1-2.5 2.5h-6A2.5 2.5 0 0 1 7 15.5V13H4.5A2.5 2.5 0 0 1 2 10.5v-6ZM7 12V9.5A2.5 2.5 0 0 1 9.5 7H12V4.5c0-.83-.67-1.5-1.5-1.5h-6C3.67 3 3 3.67 3 4.5v6c0 .83.67 1.5 1.5 1.5H7Zm1 1v2.5c0 .83.67 1.5 1.5 1.5h6c.83 0 1.5-.67 1.5-1.5v-6c0-.83-.67-1.5-1.5-1.5H13v2.5a2.5 2.5 0 0 1-2.5 2.5H8Z"]));
export const ShapeIntersectRegular = ( /*#__PURE__*/createFluentIcon('ShapeIntersectRegular', "1em", ["M2 4.5A2.5 2.5 0 0 1 4.5 2h6A2.5 2.5 0 0 1 13 4.5V7h2.5A2.5 2.5 0 0 1 18 9.5v6a2.5 2.5 0 0 1-2.5 2.5h-6A2.5 2.5 0 0 1 7 15.5V13H4.5A2.5 2.5 0 0 1 2 10.5v-6Zm10 0c0-.83-.67-1.5-1.5-1.5h-6C3.67 3 3 3.67 3 4.5v6c0 .83.67 1.5 1.5 1.5H7V9.5A2.5 2.5 0 0 1 9.5 7H12V4.5Zm-4 6.2V12h.3L12 8.3V8h-1.3L8 10.7Zm.02-1.42 1.26-1.26a1.5 1.5 0 0 0-1.26 1.26ZM13 8v2.5a2.5 2.5 0 0 1-2.5 2.5H8v2.5c0 .83.67 1.5 1.5 1.5h6c.83 0 1.5-.67 1.5-1.5v-6c0-.83-.67-1.5-1.5-1.5H13Zm-3.3 4h.8c.83 0 1.5-.67 1.5-1.5v-.8L9.7 12Z"]));
export const ShapeOrganicFilled = ( /*#__PURE__*/createFluentIcon('ShapeOrganicFilled', "1em", ["M14.5 7.83c.42.32.89.33 1.35.53.25.1.57.3.9.6.66.63 1.25 1.72 1.25 3.54a4.73 4.73 0 0 1-2.54 4.33C13.97 17.68 12 18 10 18c-2.19 0-4.21-.38-5.68-1.62-1.91-1.6-2.35-4.35-2.32-6.7 0-.66.09-2.12.67-3.61.4-1 1.02-2.02 2.01-2.8A6.65 6.65 0 0 1 8.86 2c.25 0 1.23.05 2.26.4 1.15.4 2.48 1.28 2.48 3.1 0 1.36.49 2 .9 2.33Z"]));
export const ShapeOrganicRegular = ( /*#__PURE__*/createFluentIcon('ShapeOrganicRegular', "1em", ["M14.5 7.83c.42.32.89.33 1.35.53.25.1.57.3.9.6.66.63 1.25 1.72 1.25 3.54a4.73 4.73 0 0 1-2.54 4.33C13.97 17.68 12 18 10 18c-2.19 0-4.21-.38-5.68-1.62-1.91-1.6-2.35-4.35-2.32-6.7 0-.66.09-2.12.67-3.61.4-1 1.02-2.02 2.01-2.8A6.65 6.65 0 0 1 8.86 2c.25 0 1.23.05 2.26.4 1.15.4 2.48 1.28 2.48 3.1 0 1.36.49 2 .9 2.33Zm-9.54 7.79C6.16 16.62 7.89 17 10 17c1.92 0 3.7-.31 4.97-1.04 2.04-1.15 2.93-4.5 1.09-6.27a2.14 2.14 0 0 0-.62-.42c-.5-.22-1.1-.3-1.54-.65-.69-.53-1.3-1.48-1.3-3.12 0-1.18-.82-1.8-1.81-2.15A6.94 6.94 0 0 0 8.96 3 5.59 5.59 0 0 0 5.3 4.07a5.48 5.48 0 0 0-1.7 2.36A9.62 9.62 0 0 0 3 9.68c-.02 2.1.26 4.5 1.96 5.94Z"]));
export const ShapeSubtractFilled = ( /*#__PURE__*/createFluentIcon('ShapeSubtractFilled', "1em", ["M4.5 2A2.5 2.5 0 0 0 2 4.5v6A2.5 2.5 0 0 0 4.5 13H7v2.5A2.5 2.5 0 0 0 9.5 18h6a2.5 2.5 0 0 0 2.5-2.5v-6A2.5 2.5 0 0 0 15.5 7H13V4.5A2.5 2.5 0 0 0 10.5 2h-6ZM8 9.5C8 8.67 8.67 8 9.5 8h6c.83 0 1.5.67 1.5 1.5v6c0 .83-.67 1.5-1.5 1.5h-6A1.5 1.5 0 0 1 8 15.5v-6Z"]));
export const ShapeSubtractRegular = ( /*#__PURE__*/createFluentIcon('ShapeSubtractRegular', "1em", ["M4.5 2A2.5 2.5 0 0 0 2 4.5V10.56c.01.48.16.94.41 1.32l.02.02A2.52 2.52 0 0 0 4.3 13H7v2.5A2.5 2.5 0 0 0 9.5 18h6a2.5 2.5 0 0 0 2.5-2.5v-6A2.5 2.5 0 0 0 15.5 7H13V4.5a2.52 2.52 0 0 0-.41-1.38l-.02-.02A2.51 2.51 0 0 0 10.51 2H4.5Zm.64 1L3 5.14V4.5C3 3.67 3.67 3 4.5 3h.64ZM3 6.56 6.56 3h1.58L3 8.14V6.56ZM9.56 3h.94c.23 0 .45.05.65.15l-8 8A1.5 1.5 0 0 1 3 10.5v-.94L9.56 3Zm2.3.85c.09.2.14.42.14.65v.8L10.3 7h-.8c-.36 0-.7.07-1 .2l3.35-3.35ZM7.2 8.5c-.14.3-.21.64-.21 1v.8L5.3 12h-.8a1.5 1.5 0 0 1-.65-.15L7.21 8.5Zm.79 1C8 8.67 8.67 8 9.5 8h6c.83 0 1.5.67 1.5 1.5v6c0 .83-.67 1.5-1.5 1.5h-6A1.5 1.5 0 0 1 8 15.5v-6Z"]));
export const ShapeUnionFilled = ( /*#__PURE__*/createFluentIcon('ShapeUnionFilled', "1em", ["M4.5 2A2.5 2.5 0 0 0 2 4.5v6A2.5 2.5 0 0 0 4.5 13H7v2.5A2.5 2.5 0 0 0 9.5 18h6a2.5 2.5 0 0 0 2.5-2.5v-6A2.5 2.5 0 0 0 15.5 7H13V4.5A2.5 2.5 0 0 0 10.5 2h-6Z"]));
export const ShapeUnionRegular = ( /*#__PURE__*/createFluentIcon('ShapeUnionRegular', "1em", ["M4.5 2A2.5 2.5 0 0 0 2 4.5v6A2.5 2.5 0 0 0 4.3 13H7v2.5A2.5 2.5 0 0 0 9.5 18h6.22a2.5 2.5 0 0 0 2.27-2.28v-.01l.01-.21v-6A2.5 2.5 0 0 0 15.5 7H13V4.5a2.52 2.52 0 0 0-.5-1.5 2.5 2.5 0 0 0-2-1h-6Zm6.65 1.15-8 8A1.5 1.5 0 0 1 3 10.5v-.94L9.56 3h.94c.23 0 .45.05.65.15Zm-7.3 8.7 8-8c.1.2.15.42.15.65v.8L5.3 12h-.8a1.5 1.5 0 0 1-.65-.15ZM12 6.71v.79c0 .21.13.4.32.47l-4.35 4.35A.5.5 0 0 0 7.5 12h-.8L12 6.7ZM13.7 8h1.6L8 15.3v-1.6L13.7 8Zm2.7.3c.32.24.53.6.59 1L9.3 17a1.5 1.5 0 0 1-1-.59l8.1-8.1Zm.6 2.4v1.6L12.3 17h-1.6l6.3-6.3Zm0 3v1.6L15.3 17h-1.6l3.3-3.3ZM3 8.15V6.56L6.56 3h1.58L3 8.14Zm0-3V4.5C3 3.67 3.67 3 4.5 3h.64L3 5.14Z"]));
export const ShapesFilled = ( /*#__PURE__*/createFluentIcon('ShapesFilled', "1em", ["M2 7.5A5.5 5.5 0 0 1 12.98 7H10.5A3.5 3.5 0 0 0 7 10.5v2.48A5.5 5.5 0 0 1 2 7.5Zm8.5.5A2.5 2.5 0 0 0 8 10.5v5a2.5 2.5 0 0 0 2.5 2.5h5a2.5 2.5 0 0 0 2.5-2.5v-5A2.5 2.5 0 0 0 15.5 8h-5Z"]));
export const ShapesRegular = ( /*#__PURE__*/createFluentIcon('ShapesRegular', "1em", ["M7.5 3a4.5 4.5 0 0 0-.5 8.97v1A5.5 5.5 0 1 1 12.98 7h-1A4.5 4.5 0 0 0 7.5 3Zm3 5A2.5 2.5 0 0 0 8 10.5v5a2.5 2.5 0 0 0 2.5 2.5h5a2.5 2.5 0 0 0 2.5-2.5v-5A2.5 2.5 0 0 0 15.5 8h-5ZM9 10.5c0-.83.67-1.5 1.5-1.5h5c.83 0 1.5.67 1.5 1.5v5c0 .83-.67 1.5-1.5 1.5h-5A1.5 1.5 0 0 1 9 15.5v-5Z"]));
export const ShareFilled = ( /*#__PURE__*/createFluentIcon('ShareFilled', "1em", ["M9.5 3a.5.5 0 0 1 0 1H6a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2v-1.5a.5.5 0 0 1 1 0V14a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6a3 3 0 0 1 3-3h3.5Zm3.8-.96a.5.5 0 0 1 .54.09l5 4.5a.5.5 0 0 1 0 .74l-5 4.5a.5.5 0 0 1-.84-.37V9.34c-1.4.13-2.67.78-3.7 1.6a9.55 9.55 0 0 0-2.2 2.5l-.15.28A.5.5 0 0 1 6 13.5c0-2.05.38-4.28 1.52-6.02A6.57 6.57 0 0 1 13 4.5V2.43a.5.5 0 0 1 .3-.39Z"]));
export const ShareRegular = ( /*#__PURE__*/createFluentIcon('ShareRegular', "1em", ["M9.5 3a.5.5 0 0 1 0 1H6a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2v-1.5a.5.5 0 0 1 1 0V14a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6a3 3 0 0 1 3-3h3.5Zm3.8-.96a.5.5 0 0 1 .53.09l5 4.5a.5.5 0 0 1 0 .74l-5 4.5a.5.5 0 0 1-.83-.37V9.34c-1.4.13-2.67.78-3.7 1.6a9.55 9.55 0 0 0-2.2 2.5l-.15.28A.5.5 0 0 1 6 13.5c0-2.05.38-4.28 1.52-6.02A6.57 6.57 0 0 1 13 4.5V2.43a.5.5 0 0 1 .3-.39ZM14 5a.5.5 0 0 1-.5.5c-2.59 0-4.18 1.05-5.14 2.52a8.79 8.79 0 0 0-1.25 3.69 11 11 0 0 1 1.56-1.54 7.8 7.8 0 0 1 4.83-1.85c.28 0 .5.22.5.5v1.56L17.75 7 14 3.62V5Z"]));
export const ShareAndroidColor = ( /*#__PURE__*/createFluentIcon('ShareAndroidColor', "1em", `<path fill-rule="evenodd" clip-rule="evenodd" d="m13.16 5.33.68 1.34L7.18 10l7.66 3.83-.68 1.34L3.82 10l9.34-4.67Z" fill="url(#ic_fluent_share_android_20_color__a)"/><path fill-rule="evenodd" clip-rule="evenodd" d="m13.16 5.33.68 1.34L7.18 10l7.66 3.83-.68 1.34L3.82 10l9.34-4.67Z" fill="url(#ic_fluent_share_android_20_color__b)"/><path fill-rule="evenodd" clip-rule="evenodd" d="m13.16 5.33.68 1.34L7.18 10l7.66 3.83-.68 1.34L3.82 10l9.34-4.67Z" fill="url(#ic_fluent_share_android_20_color__c)"/><path fill-rule="evenodd" clip-rule="evenodd" d="m13.16 5.33.68 1.34L7.18 10l7.66 3.83-.68 1.34L3.82 10l9.34-4.67Z" fill="url(#ic_fluent_share_android_20_color__d)"/><circle cx="14.5" cy="14.5" r="2.5" fill="url(#ic_fluent_share_android_20_color__e)"/><path d="M8 10a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0Z" fill="url(#ic_fluent_share_android_20_color__f)"/><circle cx="14.5" cy="5.5" r="2.5" fill="url(#ic_fluent_share_android_20_color__g)"/><defs><radialGradient id="ic_fluent_share_android_20_color__b" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(1.30211 -2.79293 3.10735 1.4487 13 14.18)"><stop offset=".55" stop-color="#70777D"/><stop offset="1" stop-color="#70777D" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_share_android_20_color__c" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(3.72703 0 0 4.03643 5.55 9.99)"><stop offset=".55" stop-color="#70777D"/><stop offset="1" stop-color="#70777D" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_share_android_20_color__d" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(-3.19461 2.0952 -2.2918 -3.49438 14.06 5.27)"><stop offset=".55" stop-color="#70777D"/><stop offset="1" stop-color="#70777D" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_share_android_20_color__e" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(53.62 -1.87 12.1) scale(13.5213 11.5804)"><stop offset=".53" stop-color="#0FAFFF"/><stop offset="1" stop-color="#0078D4"/></radialGradient><radialGradient id="ic_fluent_share_android_20_color__f" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(53.62 -1.92 .94) scale(13.5213 11.5804)"><stop offset=".53" stop-color="#0FAFFF"/><stop offset="1" stop-color="#0078D4"/></radialGradient><radialGradient id="ic_fluent_share_android_20_color__g" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(53.62 7.04 7.6) scale(13.5213 11.5804)"><stop offset=".53" stop-color="#0FAFFF"/><stop offset="1" stop-color="#0078D4"/></radialGradient><linearGradient id="ic_fluent_share_android_20_color__a" x1="3.82" y1="5.33" x2="7.05" y2="15.64" gradientUnits="userSpaceOnUse"><stop stop-color="#B9C0C7"/><stop offset="1" stop-color="#70777D"/></linearGradient></defs>`, { color: true }));
export const ShareAndroidFilled = ( /*#__PURE__*/createFluentIcon('ShareAndroidFilled', "1em", ["M17 5.5a2.5 2.5 0 0 1-4.47 1.54L7.92 9.35a2.5 2.5 0 0 1 0 1.3l4.61 2.3a2.5 2.5 0 1 1-.45.9l-4.61-2.3a2.5 2.5 0 1 1 0-3.1l4.61-2.3A2.5 2.5 0 1 1 17 5.5Z"]));
export const ShareAndroidRegular = ( /*#__PURE__*/createFluentIcon('ShareAndroidRegular', "1em", ["M12 5.5a2.5 2.5 0 1 1 .53 1.54L7.92 9.35a2.5 2.5 0 0 1 0 1.3l4.61 2.3a2.5 2.5 0 1 1-.45.9l-4.61-2.3a2.5 2.5 0 1 1 0-3.1l4.61-2.3A2.5 2.5 0 0 1 12 5.5ZM14.5 4a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm0 9a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3ZM4 10a1.5 1.5 0 1 0 3 0 1.5 1.5 0 0 0-3 0Z"]));
export const ShareCloseTrayFilled = ( /*#__PURE__*/createFluentIcon('ShareCloseTrayFilled', "1em", ["M4 16a2 2 0 0 1-2-2V6c0-1.1.9-2 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H4Zm6-10a.5.5 0 0 0-.5.5v5.8l-1.65-1.65a.5.5 0 0 0-.7.7l2.5 2.5c.2.2.5.2.7 0l2.5-2.5a.5.5 0 0 0-.7-.7l-1.65 1.64V6.5A.5.5 0 0 0 10 6Z"]));
export const ShareCloseTrayRegular = ( /*#__PURE__*/createFluentIcon('ShareCloseTrayRegular', "1em", ["M10 6a.5.5 0 0 0-.5.5v5.8l-1.65-1.65a.5.5 0 0 0-.7.7l2.5 2.5c.2.2.5.2.7 0l2.5-2.5a.5.5 0 0 0-.7-.7l-1.65 1.64V6.5A.5.5 0 0 0 10 6Zm-8 8c0 1.1.9 2 2 2h12a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2v8Zm2 1a1 1 0 0 1-1-1V6a1 1 0 0 1 1-1h12a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1H4Z"]));
export const ShareIosColor = ( /*#__PURE__*/createFluentIcon('ShareIosColor', "1em", `<path d="M10.29 2.06a.75.75 0 0 0-.82.16L5.22 6.47a.75.75 0 0 0 1.06 1.06l2.97-2.97v7.69a.75.75 0 0 0 1.5 0V4.56l2.97 2.97a.75.75 0 1 0 1.06-1.06l-4.25-4.25a.75.75 0 0 0-.24-.16ZM3.75 9c.41 0 .75.34.75.75v4c0 .97.78 1.75 1.75 1.75h7.5c.97 0 1.75-.78 1.75-1.75v-4a.75.75 0 0 1 1.5 0v4c0 1.8-1.46 3.25-3.25 3.25h-7.5A3.25 3.25 0 0 1 3 13.75v-4c0-.41.34-.75.75-.75Z" fill="url(#ic_fluent_share_ios_20_color__a)"/><defs><radialGradient id="ic_fluent_share_ios_20_color__a" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(15.62873 20.07924 -16.84135 13.1085 1.37 -2.14)"><stop offset=".28" stop-color="#0FAFFF"/><stop offset="1" stop-color="#0078D4"/></radialGradient></defs>`, { color: true }));
export const ShareIosFilled = ( /*#__PURE__*/createFluentIcon('ShareIosFilled', "1em", ["M10.29 2.06a.75.75 0 0 0-.82.16L5.22 6.47a.75.75 0 0 0 1.06 1.06l2.97-2.97v7.69a.75.75 0 0 0 1.5 0V4.56l2.97 2.97a.75.75 0 1 0 1.06-1.06l-4.25-4.25a.75.75 0 0 0-.24-.16ZM3.75 9c.41 0 .75.34.75.75v4c0 .97.78 1.75 1.75 1.75h7.5c.97 0 1.75-.78 1.75-1.75v-4a.75.75 0 0 1 1.5 0v4c0 1.8-1.46 3.25-3.25 3.25h-7.5A3.25 3.25 0 0 1 3 13.75v-4c0-.41.34-.75.75-.75Z"]));
export const ShareIosRegular = ( /*#__PURE__*/createFluentIcon('ShareIosRegular', "1em", ["M10.35 2.15a.5.5 0 0 0-.7 0l-4.5 4.5a.5.5 0 1 0 .7.7L9.5 3.71v8.79a.5.5 0 0 0 1 0V3.7l3.65 3.65a.5.5 0 0 0 .7-.7l-4.5-4.5ZM4 9.5a.5.5 0 0 0-1 0V14a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V9.5a.5.5 0 0 0-1 0V14a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V9.5Z"]));
export const ShareMultipleFilled = ( /*#__PURE__*/createFluentIcon('ShareMultipleFilled', "1em", ["M13.31 11.96a.4.4 0 0 0 .19.04c.13 0 .25-.05.35-.14l4-3.91a.5.5 0 0 0 .01-.71l-4-4.09a.51.51 0 0 0-.55-.11.49.49 0 0 0-.31.46v1.76c-5.93.32-6 6.18-6 6.24 0 .19.11.37.28.45.17.08.38.06.53-.06l.01-.01c.2-.15 2.52-1.9 5.18-2.11v1.73c0 .2.12.38.31.46ZM10 4.5a.5.5 0 0 0-.5-.5H8a3 3 0 0 0-3 3v5a3 3 0 0 0 3 3h5a3 3 0 0 0 2.96-2.5c.04-.27-.18-.5-.46-.5s-.5.23-.56.5A2 2 0 0 1 13 14H8a2 2 0 0 1-2-2V7c0-1.1.9-2 2-2h1.5a.5.5 0 0 0 .5-.5ZM4 7v-.24A3 3 0 0 0 3 9v3a5 5 0 0 0 5 5h3a3 3 0 0 0 2.24-1H8a4 4 0 0 1-4-4V7Z"]));
export const ShareMultipleRegular = ( /*#__PURE__*/createFluentIcon('ShareMultipleRegular', "1em", ["M13.31 11.96a.4.4 0 0 0 .19.04c.13 0 .25-.05.35-.14l4-3.91a.5.5 0 0 0 .01-.71l-4-4.09a.51.51 0 0 0-.55-.11.49.49 0 0 0-.31.46v1.76c-5.93.32-6 6.18-6 6.24 0 .19.11.37.28.45.17.08.38.06.53-.06l.01-.01c.2-.15 2.52-1.9 5.18-2.11v1.73c0 .2.12.38.31.46ZM14 5.75V4.72l2.79 2.86L14 10.31V9.25a.5.5 0 0 0-.5-.5c-2.23 0-4.25 1.02-5.38 1.72.31-1.54 1.43-4.22 5.38-4.22a.5.5 0 0 0 .5-.5ZM10 4.5a.5.5 0 0 0-.5-.5H8a3 3 0 0 0-3 3v5a3 3 0 0 0 3 3h5a3 3 0 0 0 2.96-2.5c.04-.27-.18-.5-.46-.5s-.5.23-.56.5A2 2 0 0 1 13 14H8a2 2 0 0 1-2-2V7c0-1.1.9-2 2-2h1.5a.5.5 0 0 0 .5-.5ZM4 7v-.24A3 3 0 0 0 3 9v3a5 5 0 0 0 5 5h3a3 3 0 0 0 2.24-1H8a4 4 0 0 1-4-4V7Z"]));
export const ShareScreenPersonFilled = ( /*#__PURE__*/createFluentIcon('ShareScreenPersonFilled', "1em", ["M5 4a3 3 0 0 0-3 3v6a3 3 0 0 0 3 3h6.05a2.5 2.5 0 0 1 2.22-1.99A2.99 2.99 0 0 1 15.5 9a3 3 0 0 1 2.5 1.34V7a3 3 0 0 0-3-3H5Zm12.5 8a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm1.5 4.5c0 1.25-1 2.5-3.5 2.5S12 17.75 12 16.5c0-.83.67-1.5 1.5-1.5h4c.83 0 1.5.67 1.5 1.5Z"]));
export const ShareScreenPersonRegular = ( /*#__PURE__*/createFluentIcon('ShareScreenPersonRegular', "1em", ["M4.75 4A2.75 2.75 0 0 0 2 6.75v6.5A2.75 2.75 0 0 0 4.75 16h6.3c.07-.37.23-.7.45-1H4.75C3.78 15 3 14.22 3 13.25v-6.5C3 5.78 3.78 5 4.75 5h10.5c.97 0 1.75.78 1.75 1.75V9.4c.4.23.74.56 1 .94V6.75A2.75 2.75 0 0 0 15.25 4H4.75Zm12.75 8a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm1.5 4.5c0 1.25-1 2.5-3.5 2.5S12 17.75 12 16.5c0-.83.67-1.5 1.5-1.5h4c.83 0 1.5.67 1.5 1.5Z"]));
export const ShareScreenPersonOverlayFilled = ( /*#__PURE__*/createFluentIcon('ShareScreenPersonOverlayFilled', "1em", ["M2 7a3 3 0 0 1 3-3h10a3 3 0 0 1 3 3v3.34a3 3 0 1 0-4.73 3.67c-1.1.1-2 .92-2.22 1.99H5a3 3 0 0 1-3-3V7Zm2 0v3a1 1 0 0 0 1 1h4a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1H5a1 1 0 0 0-1 1Zm13.5 5a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm1.5 4.5c0 1.25-1 2.5-3.5 2.5S12 17.75 12 16.5c0-.83.67-1.5 1.5-1.5h4c.83 0 1.5.67 1.5 1.5Z"]));
export const ShareScreenPersonOverlayRegular = ( /*#__PURE__*/createFluentIcon('ShareScreenPersonOverlayRegular', "1em", ["M2 6.75A2.75 2.75 0 0 1 4.75 4h10.5A2.75 2.75 0 0 1 18 6.75v3.6c-.26-.4-.6-.72-1-.95V6.75C17 5.78 16.22 5 15.25 5H4.75C3.78 5 3 5.78 3 6.75v6.5c0 .97.78 1.75 1.75 1.75h6.75c-.22.3-.38.63-.45 1h-6.3A2.75 2.75 0 0 1 2 13.25v-6.5ZM15.5 14a2 2 0 1 0 0-4 2 2 0 0 0 0 4Zm0 5c2.5 0 3.5-1.25 3.5-2.5 0-.83-.67-1.5-1.5-1.5h-4c-.83 0-1.5.67-1.5 1.5 0 1.25 1 2.5 3.5 2.5ZM5 6a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h4a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1H5Z"]));
export const ShareScreenPersonOverlayInsideFilled = ( /*#__PURE__*/createFluentIcon('ShareScreenPersonOverlayInsideFilled', "1em", ["M2 7a3 3 0 0 1 3-3h10a3 3 0 0 1 3 3v6a3 3 0 0 1-3 3H5a3 3 0 0 1-3-3V7Zm3-1a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h3a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1H5Zm10 1.5a1.5 1.5 0 1 0-3 0 1.5 1.5 0 0 0 3 0ZM12 10a1 1 0 0 0-1 1v1c0 1.1.9 2 2 2h1a2 2 0 0 0 2-2v-1a1 1 0 0 0-1-1h-3Z"]));
export const ShareScreenPersonOverlayInsideRegular = ( /*#__PURE__*/createFluentIcon('ShareScreenPersonOverlayInsideRegular', "1em", ["M13.5 9a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3ZM11 11a1 1 0 0 1 1-1h3a1 1 0 0 1 1 1v1a2 2 0 0 1-2 2h-1a2 2 0 0 1-2-2v-1ZM5 6a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h4a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1H5Zm-.25-2A2.75 2.75 0 0 0 2 6.75v6.5A2.75 2.75 0 0 0 4.75 16h10.5A2.75 2.75 0 0 0 18 13.25v-6.5A2.75 2.75 0 0 0 15.25 4H4.75ZM3 6.75C3 5.78 3.78 5 4.75 5h10.5c.97 0 1.75.78 1.75 1.75v6.5c0 .97-.78 1.75-1.75 1.75H4.75C3.78 15 3 14.22 3 13.25v-6.5Z"]));
export const ShareScreenPersonPFilled = ( /*#__PURE__*/createFluentIcon('ShareScreenPersonPFilled', "1em", ["M2 7a3 3 0 0 1 3-3h10a3 3 0 0 1 3 3v3.34a3 3 0 1 0-4.73 3.67c-1.1.1-2 .92-2.22 1.99H5a3 3 0 0 1-3-3V7Zm4 .5v5a.5.5 0 0 0 1 0V11h1a2 2 0 1 0 0-4H6.5a.5.5 0 0 0-.5.5ZM7 10h1a1 1 0 0 0 0-2H7v2Zm10.5 2a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm1.5 4.5c0 1.25-1 2.5-3.5 2.5S12 17.75 12 16.5c0-.83.67-1.5 1.5-1.5h4c.83 0 1.5.67 1.5 1.5Z"]));
export const ShareScreenPersonPRegular = ( /*#__PURE__*/createFluentIcon('ShareScreenPersonPRegular', "1em", ["M2 6.75A2.75 2.75 0 0 1 4.75 4h10.5A2.75 2.75 0 0 1 18 6.75v3.6c-.26-.4-.6-.72-1-.95V6.75C17 5.78 16.22 5 15.25 5H4.75C3.78 5 3 5.78 3 6.75v6.5c0 .97.78 1.75 1.75 1.75h6.75c-.22.3-.38.63-.45 1h-6.3A2.75 2.75 0 0 1 2 13.25v-6.5ZM15.5 14a2 2 0 1 0 0-4 2 2 0 0 0 0 4Zm0 5c2.5 0 3.5-1.25 3.5-2.5 0-.83-.67-1.5-1.5-1.5h-4c-.83 0-1.5.67-1.5 1.5 0 1.25 1 2.5 3.5 2.5Zm-9-12a.5.5 0 0 0-.5.5v5a.5.5 0 0 0 1 0V11h1a2 2 0 1 0 0-4H6.5ZM8 10H7V8h1a1 1 0 0 1 0 2Z"]));
export const ShareScreenStartFilled = ( /*#__PURE__*/createFluentIcon('ShareScreenStartFilled', "1em", ["M4 4a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h12a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2H4Zm6 10a.5.5 0 0 1-.5-.5V7.7L7.85 9.36a.5.5 0 1 1-.7-.7l2.5-2.5c.2-.2.5-.2.7 0l2.5 2.5a.5.5 0 0 1-.7.7L10.5 7.71v5.79a.5.5 0 0 1-.5.5Z"]));
export const ShareScreenStartRegular = ( /*#__PURE__*/createFluentIcon('ShareScreenStartRegular', "1em", ["M10 14a.5.5 0 0 1-.5-.5V7.7L7.85 9.36a.5.5 0 1 1-.7-.7l2.5-2.5c.2-.2.5-.2.7 0l2.5 2.5a.5.5 0 0 1-.7.7L10.5 7.71v5.79a.5.5 0 0 1-.5.5ZM2 6c0-1.1.9-2 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V6Zm2-1a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H4Z"]));
export const ShareScreenStopFilled = ( /*#__PURE__*/createFluentIcon('ShareScreenStopFilled', "1em", ["M4.5 4A2.5 2.5 0 0 0 2 6.5v7A2.5 2.5 0 0 0 4.5 16h11a2.5 2.5 0 0 0 2.5-2.5v-7A2.5 2.5 0 0 0 15.5 4h-11Zm2.65 3.15c.2-.2.5-.2.7 0L10 9.29l2.15-2.14a.5.5 0 0 1 .7.7L10.71 10l2.14 2.15a.5.5 0 0 1-.7.7L10 10.71l-2.15 2.14a.5.5 0 0 1-.7-.7L9.29 10 7.15 7.85a.5.5 0 0 1 0-.7Z"]));
export const ShareScreenStopRegular = ( /*#__PURE__*/createFluentIcon('ShareScreenStopRegular', "1em", ["M7.15 7.15c.2-.2.5-.2.7 0L10 9.29l2.15-2.14a.5.5 0 0 1 .7.7L10.71 10l2.14 2.15a.5.5 0 0 1-.7.7L10 10.71l-2.15 2.14a.5.5 0 0 1-.7-.7L9.29 10 7.15 7.85a.5.5 0 0 1 0-.7ZM2 6.5A2.5 2.5 0 0 1 4.5 4h11A2.5 2.5 0 0 1 18 6.5v7a2.5 2.5 0 0 1-2.5 2.5h-11A2.5 2.5 0 0 1 2 13.5v-7ZM4.5 5C3.67 5 3 5.67 3 6.5v7c0 .83.67 1.5 1.5 1.5h11c.83 0 1.5-.67 1.5-1.5v-7c0-.83-.67-1.5-1.5-1.5h-11Z"]));
export const ShieldColor = ( /*#__PURE__*/createFluentIcon('ShieldColor', "1em", `<path d="M9.72 2.08a.5.5 0 0 1 .56 0c1.94 1.3 4.03 2.1 6.3 2.43A.5.5 0 0 1 17 5v4.5c0 3.9-2.3 6.73-6.82 8.47a.5.5 0 0 1-.36 0C5.31 16.23 3 13.39 3 9.5V5a.5.5 0 0 1 .43-.5 15.05 15.05 0 0 0 6.3-2.42Z" fill="url(#ic_fluent_shield_20_color__a)"/><defs><radialGradient id="ic_fluent_shield_20_color__a" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(21.50002 31 -27.12496 18.81249 -2.5 -7)"><stop offset=".34" stop-color="#0FAFFF"/><stop offset=".53" stop-color="#367AF2"/><stop offset=".68" stop-color="#5750E2"/><stop offset=".86" stop-color="#CC23D1"/></radialGradient></defs>`, { color: true }));
export const ShieldFilled = ( /*#__PURE__*/createFluentIcon('ShieldFilled', "1em", ["M9.72 2.08a.5.5 0 0 1 .56 0c1.94 1.3 4.03 2.1 6.3 2.43A.5.5 0 0 1 17 5v4.5c0 3.9-2.3 6.73-6.82 8.47a.5.5 0 0 1-.36 0C5.31 16.23 3 13.39 3 9.5V5a.5.5 0 0 1 .43-.5 15.05 15.05 0 0 0 6.3-2.42Z"]));
export const ShieldRegular = ( /*#__PURE__*/createFluentIcon('ShieldRegular', "1em", ["M9.72 2.08a.5.5 0 0 1 .56 0c1.94 1.3 4.03 2.1 6.3 2.43A.5.5 0 0 1 17 5v4.5c0 3.9-2.3 6.73-6.82 8.47a.5.5 0 0 1-.36 0C5.31 16.23 3 13.39 3 9.5V5a.5.5 0 0 1 .43-.5 15.05 15.05 0 0 0 6.3-2.42ZM9.6 3.35A15.97 15.97 0 0 1 4 5.43V9.5c0 3.4 1.97 5.86 6 7.46 4.03-1.6 6-4.07 6-7.46V5.43a15.97 15.97 0 0 1-5.6-2.08L10 3.1l-.4.25Z"]));
export const ShieldAddFilled = ( /*#__PURE__*/createFluentIcon('ShieldAddFilled', "1em", ["M9.72 2.08a.5.5 0 0 1 .56 0c1.94 1.3 4.03 2.1 6.3 2.43A.5.5 0 0 1 17 5v4.6a5.5 5.5 0 0 0-6.78 8.35l-.04.02a.5.5 0 0 1-.36 0C5.31 16.23 3 13.39 3 9.5V5a.5.5 0 0 1 .43-.5 15.05 15.05 0 0 0 6.3-2.42ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const ShieldAddRegular = ( /*#__PURE__*/createFluentIcon('ShieldAddRegular', "1em", ["M9.72 2.08a.5.5 0 0 1 .56 0c1.94 1.3 4.03 2.1 6.3 2.43A.5.5 0 0 1 17 5v4.6c-.32-.16-.65-.3-1-.4V5.44a15.97 15.97 0 0 1-5.6-2.08L10 3.1l-.4.25A15.97 15.97 0 0 1 4 5.43V9.5c0 3.24 1.8 5.64 5.48 7.25.2.43.44.84.74 1.2l-.04.02a.5.5 0 0 1-.36 0C5.31 16.23 3 13.39 3 9.5V5a.5.5 0 0 1 .43-.5 15.05 15.05 0 0 0 6.3-2.42ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const ShieldArrowRightFilled = ( /*#__PURE__*/createFluentIcon('ShieldArrowRightFilled', "1em", ["M9.72 2.08a.5.5 0 0 1 .56 0c1.94 1.3 4.03 2.1 6.3 2.43A.5.5 0 0 1 17 5v4.6a5.5 5.5 0 0 0-6.78 8.35l-.04.02a.5.5 0 0 1-.36 0C5.31 16.23 3 13.39 3 9.5V5a.5.5 0 0 1 .43-.5 15.05 15.05 0 0 0 6.3-2.42ZM19 14.5a4.5 4.5 0 1 0-9 0 4.5 4.5 0 0 0 9 0Zm-4.15 2.35a.5.5 0 0 1-.7-.7L15.29 15H12.5a.5.5 0 0 1 0-1h2.8l-1.15-1.15a.5.5 0 0 1 .7-.7l2 2a.5.5 0 0 1 .15.35.5.5 0 0 1-.14.35l-2 2Z"]));
export const ShieldArrowRightRegular = ( /*#__PURE__*/createFluentIcon('ShieldArrowRightRegular', "1em", ["M9.72 2.08a.5.5 0 0 1 .56 0c1.94 1.3 4.03 2.1 6.3 2.43A.5.5 0 0 1 17 5v4.6c-.32-.16-.65-.3-1-.4V5.44a15.97 15.97 0 0 1-5.6-2.08L10 3.1l-.4.25A15.97 15.97 0 0 1 4 5.43V9.5c0 3.24 1.8 5.64 5.48 7.25.2.43.44.84.74 1.2l-.04.02a.5.5 0 0 1-.36 0C5.31 16.23 3 13.39 3 9.5V5a.5.5 0 0 1 .43-.5 15.05 15.05 0 0 0 6.3-2.42ZM19 14.5a4.5 4.5 0 1 0-9 0 4.5 4.5 0 0 0 9 0Zm-4.15 2.35a.5.5 0 0 1-.7-.7L15.29 15H12.5a.5.5 0 0 1 0-1h2.8l-1.15-1.15a.5.5 0 0 1 .7-.7l2 2a.5.5 0 0 1 .15.35.5.5 0 0 1-.14.35l-2 2Z"]));
export const ShieldBadgeFilled = ( /*#__PURE__*/createFluentIcon('ShieldBadgeFilled', "1em", ["M4 5a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h6V9c3.23 0 3.75-.83 4.11-1.43.2-.32.36-.57.89-.57s.69.25.89.57c.2.32.43.7 1.11 1V7a2 2 0 0 0-2-2H4Zm10.53 3.83v.02a1.63 1.63 0 0 1-.45.5c-.4.3-1.17.65-2.58.65a.5.5 0 0 0-.5.5v2c0 1.03.13 2.14.7 3.12.56 1 1.55 1.82 3.14 2.35.1.04.22.04.32 0a5.35 5.35 0 0 0 3.15-2.35c.56-.98.69-2.09.69-3.12v-2a.5.5 0 0 0-.5-.5c-1.41 0-2.18-.35-2.57-.65a1.63 1.63 0 0 1-.46-.52.5.5 0 0 0-.94 0Zm.94 0v.01Zm-.94 0v.01Z"]));
export const ShieldBadgeRegular = ( /*#__PURE__*/createFluentIcon('ShieldBadgeRegular', "1em", ["M2 7c0-1.1.9-2 2-2h11a2 2 0 0 1 2 2v1.57a2.11 2.11 0 0 1-1-.82V7a1 1 0 0 0-1-1H4a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h6v1H4a2 2 0 0 1-2-2V7Zm12.53 1.83a.5.5 0 0 1 .95.02 1.63 1.63 0 0 0 .45.5c.4.3 1.16.65 2.57.65.28 0 .5.22.5.5v2c0 1.03-.13 2.14-.7 3.12a5.35 5.35 0 0 1-3.14 2.35.5.5 0 0 1-.32 0 5.35 5.35 0 0 1-3.15-2.35A6.19 6.19 0 0 1 11 12.5v-2a.5.5 0 0 1 .5-.5c1.41 0 2.18-.35 2.57-.65a1.63 1.63 0 0 0 .46-.52Zm.94 0v.01Zm0 0Zm-.94 0v.01Zm.15 1.32c-.54.4-1.38.76-2.68.84v1.51c0 .97.12 1.86.56 2.63A4.27 4.27 0 0 0 15 16.97a4.27 4.27 0 0 0 2.44-1.84c.44-.77.56-1.66.56-2.63v-1.51a4.81 4.81 0 0 1-2.68-.84L15 9.87c-.1.09-.2.19-.32.28Zm-.15-1.32"]));
export const ShieldCheckmarkColor = ( /*#__PURE__*/createFluentIcon('ShieldCheckmarkColor', "1em", `<path d="M9.72 2.08a.5.5 0 0 1 .56 0c1.94 1.3 4.03 2.1 6.3 2.43A.5.5 0 0 1 17 5v4.5c0 3.9-2.3 6.73-6.82 8.47a.5.5 0 0 1-.36 0C5.31 16.23 3 13.39 3 9.5V5a.5.5 0 0 1 .43-.5 15.05 15.05 0 0 0 6.3-2.42Z" fill="url(#ic_fluent_shield_checkmark_20_color__a)"/><path d="M9.72 2.08a.5.5 0 0 1 .56 0c1.94 1.3 4.03 2.1 6.3 2.43A.5.5 0 0 1 17 5v4.5c0 3.9-2.3 6.73-6.82 8.47a.5.5 0 0 1-.36 0C5.31 16.23 3 13.39 3 9.5V5a.5.5 0 0 1 .43-.5 15.05 15.05 0 0 0 6.3-2.42Z" fill="url(#ic_fluent_shield_checkmark_20_color__b)" fill-opacity=".5"/><path d="M19 14.5a4.5 4.5 0 1 0-9 0 4.5 4.5 0 0 0 9 0Z" fill="url(#ic_fluent_shield_checkmark_20_color__c)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M16.85 12.65c.2.2.2.5 0 .7l-3 3a.5.5 0 0 1-.7 0l-1-1a.5.5 0 0 1 .7-.7l.65.64 2.65-2.64c.2-.2.5-.2.7 0Z" fill="url(#ic_fluent_shield_checkmark_20_color__d)"/><defs><radialGradient id="ic_fluent_shield_checkmark_20_color__a" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(21.50002 31 -27.12496 18.81249 -2.5 -7)"><stop offset=".34" stop-color="#0FAFFF"/><stop offset=".53" stop-color="#367AF2"/><stop offset=".68" stop-color="#5750E2"/><stop offset=".86" stop-color="#CC23D1"/></radialGradient><radialGradient id="ic_fluent_shield_checkmark_20_color__b" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(90 -.5 15) scale(6.5)"><stop offset=".5" stop-color="#1E1868"/><stop offset="1" stop-color="#1E1868" stop-opacity="0"/></radialGradient><linearGradient id="ic_fluent_shield_checkmark_20_color__c" x1="10.32" y1="11.69" x2="16.53" y2="18.14" gradientUnits="userSpaceOnUse"><stop stop-color="#52D17C"/><stop offset="1" stop-color="#22918B"/></linearGradient><linearGradient id="ic_fluent_shield_checkmark_20_color__d" x1="12.94" y1="12.91" x2="13.95" y2="17.36" gradientUnits="userSpaceOnUse"><stop stop-color="#fff"/><stop offset="1" stop-color="#E3FFD9"/></linearGradient></defs>`, { color: true }));
export const ShieldCheckmarkFilled = ( /*#__PURE__*/createFluentIcon('ShieldCheckmarkFilled', "1em", ["M9.72 2.08a.5.5 0 0 1 .56 0c1.94 1.3 4.03 2.1 6.3 2.43A.5.5 0 0 1 17 5v4.6a5.5 5.5 0 0 0-6.78 8.35l-.04.02a.5.5 0 0 1-.36 0C5.31 16.23 3 13.39 3 9.5V5a.5.5 0 0 1 .43-.5 15.05 15.05 0 0 0 6.3-2.42ZM19 14.5a4.5 4.5 0 1 0-9 0 4.5 4.5 0 0 0 9 0Zm-2.15-1.85c.2.2.2.5 0 .7l-3 3a.5.5 0 0 1-.7 0l-1-1a.5.5 0 0 1 .7-.7l.65.64 2.65-2.64c.2-.2.5-.2.7 0Z"]));
export const ShieldCheckmarkRegular = ( /*#__PURE__*/createFluentIcon('ShieldCheckmarkRegular', "1em", ["M9.72 2.08a.5.5 0 0 1 .56 0c1.94 1.3 4.03 2.1 6.3 2.43A.5.5 0 0 1 17 5v4.6c-.32-.16-.65-.3-1-.4V5.44a15.97 15.97 0 0 1-5.6-2.08L10 3.1l-.4.25A15.97 15.97 0 0 1 4 5.43V9.5c0 3.24 1.8 5.64 5.48 7.25.2.43.44.84.74 1.2l-.04.02a.5.5 0 0 1-.36 0C5.31 16.23 3 13.39 3 9.5V5a.5.5 0 0 1 .43-.5 15.05 15.05 0 0 0 6.3-2.42ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15-1.85a.5.5 0 0 0-.7 0l-2.65 2.64-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l3-3a.5.5 0 0 0 0-.7Z"]));
export const ShieldDismissFilled = ( /*#__PURE__*/createFluentIcon('ShieldDismissFilled', "1em", ["M10.28 2.08c1.94 1.3 4.03 2.1 6.3 2.43A.5.5 0 0 1 17 5v4.5c0 3.9-2.3 6.73-6.82 8.47a.5.5 0 0 1-.36 0C5.31 16.23 3 13.39 3 9.5V5a.5.5 0 0 1 .43-.5 15.05 15.05 0 0 0 6.3-2.42.5.5 0 0 1 .55 0ZM8.03 6.97a.75.75 0 0 0-1.06 1.06L8.94 10l-1.97 1.97a.75.75 0 1 0 1.06 1.06L10 11.06l1.97 1.97a.75.75 0 1 0 1.06-1.06L11.06 10l1.97-1.97a.75.75 0 0 0-1.06-1.06L10 8.94 8.03 6.97Z"]));
export const ShieldDismissRegular = ( /*#__PURE__*/createFluentIcon('ShieldDismissRegular', "1em", ["M7.85 7.15a.5.5 0 1 0-.7.7L9.29 10l-2.14 2.15a.5.5 0 0 0 .7.7L10 10.71l2.15 2.14a.5.5 0 0 0 .7-.7L10.71 10l2.14-2.15a.5.5 0 0 0-.7-.7L10 9.29 7.85 7.15Zm2.43-5.07a.5.5 0 0 0-.56 0 15.05 15.05 0 0 1-6.3 2.43A.5.5 0 0 0 3 5v4.5c0 3.9 2.3 6.73 6.82 8.47a.5.5 0 0 0 .36 0C14.69 16.23 17 13.39 17 9.5V5a.5.5 0 0 0-.43-.5 15.05 15.05 0 0 1-6.3-2.42ZM4 5.43a15.97 15.97 0 0 0 5.6-2.08l.4-.25.4.25A15.97 15.97 0 0 0 16 5.43V9.5c0 3.4-1.97 5.86-6 7.46-4.03-1.6-6-4.07-6-7.46V5.43Z"]));
export const ShieldDismissShieldFilled = ( /*#__PURE__*/createFluentIcon('ShieldDismissShieldFilled', "1em", ["M10.28 2.08a.5.5 0 0 0-.56 0 15.05 15.05 0 0 1-6.3 2.43A.5.5 0 0 0 3 5v4.5c0 3.9 2.3 6.73 6.82 8.47a.5.5 0 0 0 .36 0c.34-.14.68-.27 1-.42a5.82 5.82 0 0 1-.66-1.16 7.05 7.05 0 0 1-.52-2.5V11.05l-1.97 1.97a.75.75 0 0 1-1.06-1.06L8.94 10 6.97 8.03a.75.75 0 0 1 1.06-1.06L10 8.94l1.97-1.97a.75.75 0 1 1 1.06 1.06l-1.64 1.64h.01c.9 0 1.76-.37 2.6-1.24a1.39 1.39 0 0 1 2 0 5.06 5.06 0 0 0 1 .8V5a.5.5 0 0 0-.43-.5 15.05 15.05 0 0 1-6.3-2.42ZM17 10.35a4.63 4.63 0 0 1-1-.59c-.24-.18-.48-.4-.72-.64a.39.39 0 0 0-.56 0 4.5 4.5 0 0 1-3.32 1.55.4.4 0 0 0-.4.41v2.77c.03.8.18 1.51.44 2.15A4.81 4.81 0 0 0 13 18c.52.4 1.15.73 1.87.98.09.03.17.03.26 0 2.56-.89 3.87-2.71 3.87-5.4V11a.4.4 0 0 0-.4-.33 4.24 4.24 0 0 1-1.6-.32Z"]));
export const ShieldDismissShieldRegular = ( /*#__PURE__*/createFluentIcon('ShieldDismissShieldRegular', "1em", ["M10.28 2.08a.5.5 0 0 0-.56 0 15.05 15.05 0 0 1-6.3 2.43A.5.5 0 0 0 3 5v4.5c0 3.9 2.3 6.73 6.82 8.47a.5.5 0 0 0 .36 0c.34-.14.68-.27 1-.42-.2-.27-.38-.56-.52-.86-.21.1-.43.18-.66.27-4.03-1.6-6-4.07-6-7.46V5.43a15.97 15.97 0 0 0 5.6-2.08l.4-.25.4.25A15.97 15.97 0 0 0 16 5.43v3a5.06 5.06 0 0 0 1 .8V5a.5.5 0 0 0-.43-.5 15.05 15.05 0 0 1-6.3-2.42Zm-.24 8.67c.11-.47.46-.87.94-1.02l1.87-1.88a.5.5 0 0 0-.7-.7L10 9.29 7.85 7.15a.5.5 0 1 0-.7.7L9.29 10l-2.14 2.15a.5.5 0 0 0 .7.7L10 10.71l.04.04Zm6.96-.4a4.63 4.63 0 0 1-1-.59c-.24-.18-.48-.4-.72-.64a.39.39 0 0 0-.56 0 4.5 4.5 0 0 1-3.32 1.55.4.4 0 0 0-.4.41v2.77c.03.8.18 1.51.44 2.15A4.81 4.81 0 0 0 13 18c.52.4 1.15.73 1.87.98.09.03.17.03.26 0 2.56-.89 3.87-2.71 3.87-5.4V11a.4.4 0 0 0-.4-.33 4.24 4.24 0 0 1-1.6-.32Z"]));
export const ShieldErrorFilled = ( /*#__PURE__*/createFluentIcon('ShieldErrorFilled', "1em", ["M9.72 2.08a.5.5 0 0 1 .56 0c1.94 1.3 4.03 2.1 6.3 2.43A.5.5 0 0 1 17 5v4.5c0 3.9-2.3 6.73-6.82 8.47a.5.5 0 0 1-.36 0C5.31 16.23 3 13.39 3 9.5V5a.5.5 0 0 1 .43-.5 15.05 15.05 0 0 0 6.3-2.42ZM10 6a.5.5 0 0 0-.5.5v5a.5.5 0 0 0 1 0v-5A.5.5 0 0 0 10 6Zm0 8.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z"]));
export const ShieldErrorRegular = ( /*#__PURE__*/createFluentIcon('ShieldErrorRegular', "1em", ["M10 6c.28 0 .5.22.5.5v5a.5.5 0 0 1-1 0v-5c0-.28.22-.5.5-.5Zm0 8.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM9.72 2.08a.5.5 0 0 1 .56 0c1.94 1.3 4.03 2.1 6.3 2.43A.5.5 0 0 1 17 5v4.5c0 3.9-2.3 6.73-6.82 8.47a.5.5 0 0 1-.36 0C5.31 16.23 3 13.39 3 9.5V5a.5.5 0 0 1 .43-.5 15.05 15.05 0 0 0 6.3-2.42ZM9.6 3.35A15.97 15.97 0 0 1 4 5.43V9.5c0 3.4 1.97 5.86 6 7.46 4.03-1.6 6-4.07 6-7.46V5.43a15.97 15.97 0 0 1-5.6-2.08L10 3.1l-.4.25Z"]));
export const ShieldGlobeFilled = ( /*#__PURE__*/createFluentIcon('ShieldGlobeFilled', "1em", ["M10.28 2.08a.5.5 0 0 0-.56 0 15.05 15.05 0 0 1-6.3 2.43A.5.5 0 0 0 3 5v4.5c0 3.9 2.3 6.73 6.82 8.47a.5.5 0 0 0 .36 0C14.69 16.23 17 13.39 17 9.5V5a.5.5 0 0 0-.43-.5 15.05 15.05 0 0 1-6.3-2.42Zm2.68 8.42a3 3 0 0 1-1.43 2.08c.24-.57.4-1.3.45-2.08h.98Zm0-1a3 3 0 0 0-1.43-2.08c.24.57.4 1.3.45 2.08h.98Zm-1.98 0a5.13 5.13 0 0 0-.46-1.88 1.72 1.72 0 0 0-.39-.54.43.43 0 0 0-.12-.08.03.03 0 0 0-.02 0h-.01a.43.43 0 0 0-.11.08c-.11.09-.25.26-.39.54-.23.46-.4 1.11-.46 1.88h1.96Zm-1.96 1c.05.77.23 1.42.46 1.88.14.28.28.45.39.54a.42.42 0 0 0 .12.08.03.03 0 0 0 .02 0h.01c.02-.01.06-.03.11-.08.11-.09.25-.26.39-.54.23-.46.4-1.11.46-1.88H9.02Zm-1 0c.04.79.2 1.5.45 2.08a3 3 0 0 1-1.43-2.08h.98Zm0-1c.04-.79.2-1.5.45-2.08A3 3 0 0 0 7.04 9.5h.98ZM14 10a4 4 0 1 1-8 0 4 4 0 0 1 8 0Z"]));
export const ShieldGlobeRegular = ( /*#__PURE__*/createFluentIcon('ShieldGlobeRegular', "1em", ["M10.28 2.08a.5.5 0 0 0-.56 0 15.05 15.05 0 0 1-6.3 2.43A.5.5 0 0 0 3 5v4.5c0 3.9 2.3 6.73 6.82 8.47a.5.5 0 0 0 .36 0C14.69 16.23 17 13.39 17 9.5V5a.5.5 0 0 0-.43-.5 15.05 15.05 0 0 1-6.3-2.42ZM4 5.43a15.97 15.97 0 0 0 5.6-2.08l.4-.25.4.25A15.97 15.97 0 0 0 16 5.43V9.5c0 3.4-1.97 5.86-6 7.46-4.03-1.6-6-4.07-6-7.46V5.43Zm8.96 5.07h-.98c-.04.79-.2 1.5-.45 2.08a3 3 0 0 0 1.43-2.08Zm0-1a3 3 0 0 0-1.43-2.08c.24.57.4 1.3.45 2.08h.98Zm-1.98 0a5.13 5.13 0 0 0-.46-1.88 1.72 1.72 0 0 0-.39-.54.43.43 0 0 0-.12-.08.03.03 0 0 0-.02 0h-.01a.43.43 0 0 0-.11.08c-.11.09-.25.26-.39.54-.23.46-.4 1.11-.46 1.88h1.96Zm-1.96 1c.05.77.23 1.42.46 1.88.14.28.28.45.39.54a.42.42 0 0 0 .12.08.03.03 0 0 0 .02 0h.01c.02-.01.06-.03.11-.08.11-.09.25-.26.39-.54.23-.46.4-1.11.46-1.88H9.02Zm-1 0h-.98a3 3 0 0 0 1.43 2.08c-.24-.57-.4-1.3-.45-2.08Zm0-1c.04-.79.2-1.5.45-2.08A3 3 0 0 0 7.04 9.5h.98ZM14 10a4 4 0 1 1-8 0 4 4 0 0 1 8 0Z"]));
export const ShieldKeyholeFilled = ( /*#__PURE__*/createFluentIcon('ShieldKeyholeFilled', "1em", ["M10.28 2.08a.5.5 0 0 0-.56 0 15.05 15.05 0 0 1-6.3 2.43A.5.5 0 0 0 3 5v4.5c0 3.9 2.3 6.73 6.82 8.47a.5.5 0 0 0 .36 0C14.69 16.23 17 13.39 17 9.5V5a.5.5 0 0 0-.43-.5 15.05 15.05 0 0 1-6.3-2.42ZM11.5 9c0 .65-.42 1.2-1 1.41v2.09a.5.5 0 0 1-1 0v-2.09a1.5 1.5 0 1 1 2-1.41Z"]));
export const ShieldKeyholeRegular = ( /*#__PURE__*/createFluentIcon('ShieldKeyholeRegular', "1em", ["M11.5 9c0 .65-.42 1.2-1 1.41v2.09a.5.5 0 0 1-1 0v-2.09a1.5 1.5 0 1 1 2-1.41Zm-1.22-6.92a.5.5 0 0 0-.56 0 15.05 15.05 0 0 1-6.3 2.43A.5.5 0 0 0 3 5v4.5c0 3.9 2.3 6.73 6.82 8.47a.5.5 0 0 0 .36 0C14.69 16.23 17 13.39 17 9.5V5a.5.5 0 0 0-.43-.5 15.05 15.05 0 0 1-6.3-2.42ZM4 5.43a15.97 15.97 0 0 0 5.6-2.08l.4-.25.4.25A15.97 15.97 0 0 0 16 5.43V9.5c0 3.4-1.97 5.86-6 7.46-4.03-1.6-6-4.07-6-7.46V5.43Z"]));
export const ShieldLockFilled = ( /*#__PURE__*/createFluentIcon('ShieldLockFilled', "1em", ["M12.5 12v-1a2 2 0 1 1 4 0v1h.5a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1h-5a1 1 0 0 1-1-1v-4a1 1 0 0 1 1-1h.5Zm1-1v1h2v-1a1 1 0 1 0-2 0Zm1.75 4a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0ZM9.72 2.08a.5.5 0 0 1 .56 0c1.94 1.3 4.03 2.1 6.3 2.43A.5.5 0 0 1 17 5v4.34A3 3 0 0 0 11.5 11v.06A2 2 0 0 0 10 13v4a2 2 0 0 0 .24.94l-.06.03a.5.5 0 0 1-.36 0C5.31 16.23 3 13.39 3 9.5V5a.5.5 0 0 1 .43-.5 15.05 15.05 0 0 0 6.3-2.42Z"]));
export const ShieldLockRegular = ( /*#__PURE__*/createFluentIcon('ShieldLockRegular', "1em", ["M9.72 2.08a.5.5 0 0 1 .56 0c1.94 1.3 4.03 2.1 6.3 2.43A.5.5 0 0 1 17 5v4.34c-.26-.38-.6-.7-1-.94V5.43a15.97 15.97 0 0 1-5.6-2.08L10 3.1l-.4.25A15.97 15.97 0 0 1 4 5.43V9.5c0 3.4 1.97 5.86 6 7.46V17a2 2 0 0 0 .24.94l-.06.03a.5.5 0 0 1-.36 0C5.31 16.23 3 13.39 3 9.5V5a.5.5 0 0 1 .43-.5 15.05 15.05 0 0 0 6.3-2.42ZM12.5 12v-1a2 2 0 1 1 4 0v1h.5a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1h-5a1 1 0 0 1-1-1v-4a1 1 0 0 1 1-1h.5Zm1-1v1h2v-1a1 1 0 1 0-2 0Zm1.75 4a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Z"]));
export const ShieldPersonFilled = ( /*#__PURE__*/createFluentIcon('ShieldPersonFilled', "1em", ["M10.28 2.08a.5.5 0 0 0-.56 0 15.05 15.05 0 0 1-6.3 2.43A.5.5 0 0 0 3 5v4.5c0 3.9 2.3 6.73 6.82 8.47a.5.5 0 0 0 .36 0C14.69 16.23 17 13.39 17 9.5V5a.5.5 0 0 0-.43-.5 15.05 15.05 0 0 1-6.3-2.42ZM10 9.5a2 2 0 1 1 0-4 2 2 0 0 1 0 4Zm0 5c-2.5 0-3.5-1.25-3.5-2.5 0-.83.67-1.5 1.5-1.5h4c.83 0 1.5.67 1.5 1.5 0 1.24-1 2.5-3.5 2.5Z"]));
export const ShieldPersonRegular = ( /*#__PURE__*/createFluentIcon('ShieldPersonRegular', "1em", ["M10 9.5a2 2 0 1 0 0-4 2 2 0 0 0 0 4Zm0 5c2.5 0 3.5-1.26 3.5-2.5 0-.83-.67-1.5-1.5-1.5H8c-.83 0-1.5.67-1.5 1.5 0 1.25 1 2.5 3.5 2.5Zm.28-12.42a.5.5 0 0 0-.56 0 15.05 15.05 0 0 1-6.3 2.43A.5.5 0 0 0 3 5v4.5c0 3.9 2.3 6.73 6.82 8.47a.5.5 0 0 0 .36 0C14.69 16.23 17 13.39 17 9.5V5a.5.5 0 0 0-.43-.5 15.05 15.05 0 0 1-6.3-2.42ZM4 5.43a15.97 15.97 0 0 0 5.6-2.08l.4-.25.4.25A15.97 15.97 0 0 0 16 5.43V9.5c0 3.4-1.97 5.86-6 7.46-4.03-1.6-6-4.07-6-7.46V5.43Z"]));
export const ShieldPersonAddFilled = ( /*#__PURE__*/createFluentIcon('ShieldPersonAddFilled', "1em", ["M10.28 2.08a.5.5 0 0 0-.56 0 15.05 15.05 0 0 1-6.3 2.43A.5.5 0 0 0 3 5v4.5c0 3.9 2.3 6.73 6.82 8.47a.5.5 0 0 0 .36 0l.04-.02A5.48 5.48 0 0 1 9 14.42c-1.77-.29-2.5-1.35-2.5-2.42 0-.83.67-1.5 1.5-1.5h2.73A5.48 5.48 0 0 1 17 9.6V5a.5.5 0 0 0-.43-.5 15.05 15.05 0 0 1-6.3-2.42ZM10 9.5a2 2 0 1 1 0-4 2 2 0 0 1 0 4Zm9 5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const ShieldPersonAddRegular = ( /*#__PURE__*/createFluentIcon('ShieldPersonAddRegular', "1em", ["M10.28 2.08a.5.5 0 0 0-.56 0 15.05 15.05 0 0 1-6.3 2.43A.5.5 0 0 0 3 5v4.5c0 3.9 2.3 6.73 6.82 8.47a.5.5 0 0 0 .36 0l.04-.02a5.5 5.5 0 0 1-.74-1.2C5.8 15.15 4 12.75 4 9.5V5.43a15.97 15.97 0 0 0 5.6-2.08l.4-.25.4.25A15.97 15.97 0 0 0 16 5.43V9.2c.35.1.68.23 1 .39V5a.5.5 0 0 0-.43-.5 15.05 15.05 0 0 1-6.3-2.42ZM9 14.42a5.48 5.48 0 0 1 1.73-3.92H8c-.83 0-1.5.67-1.5 1.5 0 1.07.73 2.13 2.5 2.42Zm3-6.92a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm7 7a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const ShieldProhibitedFilled = ( /*#__PURE__*/createFluentIcon('ShieldProhibitedFilled', "1em", ["M10.28 2.08a.5.5 0 0 0-.56 0 15.05 15.05 0 0 1-6.3 2.43A.5.5 0 0 0 3 5v4.5c0 3.9 2.3 6.73 6.82 8.47a.5.5 0 0 0 .36 0l.07-.03A5.5 5.5 0 1 1 17 9.26V5a.5.5 0 0 0-.43-.5 15.05 15.05 0 0 1-6.3-2.42Zm.42 13.52 4.9-4.9a3.5 3.5 0 0 0-4.9 4.9Zm.7.7a3.5 3.5 0 0 0 4.9-4.9l-4.9 4.9Zm2.1 1.7a4.5 4.5 0 1 1 0-9 4.5 4.5 0 0 1 0 9Z"]));
export const ShieldProhibitedRegular = ( /*#__PURE__*/createFluentIcon('ShieldProhibitedRegular', "1em", ["M10.28 2.08a.5.5 0 0 0-.56 0 15.05 15.05 0 0 1-6.3 2.43A.5.5 0 0 0 3 5v4.5c0 3.9 2.3 6.73 6.82 8.47a.5.5 0 0 0 .36 0l.07-.03c-.55-.4-1.02-.9-1.38-1.48C5.6 14.86 4 12.56 4 9.5V5.43a15.97 15.97 0 0 0 5.6-2.08l.4-.25.4.25A15.97 15.97 0 0 0 16 5.43V8.6c.36.18.7.4 1 .66V5a.5.5 0 0 0-.43-.5 15.05 15.05 0 0 1-6.3-2.42Zm.42 13.52 4.9-4.9a3.5 3.5 0 0 0-4.9 4.9Zm.7.7a3.5 3.5 0 0 0 4.9-4.9l-4.9 4.9Zm2.1 1.7a4.5 4.5 0 1 1 0-9 4.5 4.5 0 0 1 0 9Z"]));
export const ShieldQuestionFilled = ( /*#__PURE__*/createFluentIcon('ShieldQuestionFilled', "1em", ["M9.72 2.08a.5.5 0 0 1 .56 0c1.94 1.3 4.03 2.1 6.3 2.43A.5.5 0 0 1 17 5v4.5c0 3.9-2.3 6.73-6.82 8.47a.5.5 0 0 1-.36 0C5.31 16.23 3 13.39 3 9.5V5a.5.5 0 0 1 .43-.5 15.05 15.05 0 0 0 6.3-2.42Zm1.03 11.67a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Zm-2-5.5a1.25 1.25 0 1 1 2.5 0c0 .46-.27.76-.73 1.22l-.03.03c-.42.42-.99.99-.99 1.9v.1a.5.5 0 0 0 1 0v-.1c0-.47.27-.77.73-1.22l.03-.04c.42-.41.99-.98.99-1.89a2.25 2.25 0 0 0-4.5 0 .5.5 0 0 0 1 0Z"]));
export const ShieldQuestionRegular = ( /*#__PURE__*/createFluentIcon('ShieldQuestionRegular', "1em", ["M9.72 2.08a.5.5 0 0 1 .56 0c1.94 1.3 4.03 2.1 6.3 2.43A.5.5 0 0 1 17 5v4.5c0 3.9-2.3 6.73-6.82 8.47a.5.5 0 0 1-.36 0C5.31 16.23 3 13.39 3 9.5V5a.5.5 0 0 1 .43-.5 15.05 15.05 0 0 0 6.3-2.42ZM9.6 3.35A15.97 15.97 0 0 1 4 5.43V9.5c0 3.4 1.97 5.86 6 7.46 4.03-1.6 6-4.07 6-7.46V5.43a15.97 15.97 0 0 1-5.6-2.08L10 3.1l-.4.25Zm1.15 10.4a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm-2-5.5a1.25 1.25 0 1 1 2.5 0c0 .46-.27.76-.73 1.22l-.03.03c-.42.42-.99.99-.99 1.9v.1a.5.5 0 0 0 1 0v-.1c0-.47.27-.77.73-1.22l.03-.04c.42-.41.99-.98.99-1.89a2.25 2.25 0 0 0-4.5 0 .5.5 0 0 0 1 0Z"]));
export const ShieldSettingsFilled = ( /*#__PURE__*/createFluentIcon('ShieldSettingsFilled', "1em", ["M13.07 10.75a2 2 0 0 0 2.9 0l.33-.35c.3.14.58.32.84.52l-.13.42a2 2 0 0 0 1.46 2.52l.35.09a4.7 4.7 0 0 1 0 1.01l-.45.12a2 2 0 0 0-1.43 2.48l.15.55c-.25.2-.53.37-.82.5l-.34-.36a2 2 0 0 0-2.9 0l-.33.35c-.3-.14-.58-.32-.84-.52l.13-.42a2 2 0 0 0-1.46-2.52l-.35-.09a4.7 4.7 0 0 1 0-1.01l.46-.12a2 2 0 0 0 1.43-2.48l-.16-.56c.25-.2.53-.36.82-.5l.34.37ZM9.72 2.08a.5.5 0 0 1 .56 0c1.94 1.3 4.03 2.1 6.29 2.42A.5.5 0 0 1 17 5v4.6a5.5 5.5 0 0 0-6.78 8.35l-.04.02a.5.5 0 0 1-.36 0C5.31 16.23 3 13.39 3 9.5V5a.5.5 0 0 1 .43-.5 15.05 15.05 0 0 0 6.3-2.42ZM14.5 13.5a1 1 0 1 0 0 2 1 1 0 0 0 0-2Z"]));
export const ShieldSettingsRegular = ( /*#__PURE__*/createFluentIcon('ShieldSettingsRegular', "1em", ["M13.07 10.75a2 2 0 0 0 2.9 0l.33-.35c.3.14.58.32.84.52l-.13.42a2 2 0 0 0 1.46 2.52l.35.09a4.7 4.7 0 0 1 0 1.01l-.45.12a2 2 0 0 0-1.43 2.48l.15.55c-.25.2-.53.37-.82.5l-.34-.36a2 2 0 0 0-2.9 0l-.33.35c-.3-.14-.58-.32-.84-.52l.13-.42a2 2 0 0 0-1.46-2.52l-.35-.09a4.7 4.7 0 0 1 0-1.01l.46-.12a2 2 0 0 0 1.43-2.48l-.16-.56c.25-.2.53-.36.82-.5l.34.37ZM9.72 2.08a.5.5 0 0 1 .56 0c1.94 1.3 4.03 2.1 6.29 2.42A.5.5 0 0 1 17 5v4.6c-.32-.16-.65-.3-1-.4V5.44a15.97 15.97 0 0 1-5.6-2.08L10 3.1l-.4.25A15.97 15.97 0 0 1 4 5.43V9.5c0 3.24 1.8 5.64 5.48 7.25.2.43.44.83.74 1.2l-.04.02a.5.5 0 0 1-.36 0C5.31 16.23 3 13.39 3 9.5V5a.5.5 0 0 1 .43-.5 15.05 15.05 0 0 0 6.3-2.42ZM14.5 13.5a1 1 0 1 0 0 2 1 1 0 0 0 0-2Z"]));
export const ShieldTaskFilled = ( /*#__PURE__*/createFluentIcon('ShieldTaskFilled', "1em", ["M10.28 2.08a.5.5 0 0 0-.56 0 15.05 15.05 0 0 1-6.3 2.43A.5.5 0 0 0 3 5v4.5c0 3.9 2.3 6.73 6.82 8.47a.5.5 0 0 0 .36 0C14.69 16.23 17 13.39 17 9.5V5a.5.5 0 0 0-.43-.5 15.05 15.05 0 0 1-6.3-2.42Zm3.57 5.77-4 4a.5.5 0 0 1-.7 0l-2-2a.5.5 0 1 1 .7-.7l1.65 1.64 3.65-3.64a.5.5 0 0 1 .7.7Z"]));
export const ShieldTaskRegular = ( /*#__PURE__*/createFluentIcon('ShieldTaskRegular', "1em", ["M13.85 7.85a.5.5 0 0 0-.7-.7L9.5 10.79 7.85 9.15a.5.5 0 0 0-.7.7l2 2c.2.2.5.2.7 0l4-4Zm-3.57-5.77a.5.5 0 0 0-.56 0 15.05 15.05 0 0 1-6.3 2.43A.5.5 0 0 0 3 5v4.5c0 3.9 2.3 6.73 6.82 8.47a.5.5 0 0 0 .36 0C14.69 16.23 17 13.39 17 9.5V5a.5.5 0 0 0-.43-.5 15.05 15.05 0 0 1-6.3-2.42ZM4 5.43a15.97 15.97 0 0 0 5.6-2.08l.4-.25.4.25A15.97 15.97 0 0 0 16 5.43V9.5c0 3.4-1.97 5.86-6 7.46-4.03-1.6-6-4.07-6-7.46V5.43Z"]));
export const ShiftsColor = ( /*#__PURE__*/createFluentIcon('ShiftsColor', "1em", `<path d="M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6Z" fill="url(#ic_fluent_shifts_20_color__a)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M9.5 6c.28 0 .5.22.5.5V10h2.5a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5v-4c0-.28.22-.5.5-.5Z" fill="url(#ic_fluent_shifts_20_color__b)"/><defs><linearGradient id="ic_fluent_shifts_20_color__a" x1="5.33" y1="2.22" x2="12.33" y2="17.78" gradientUnits="userSpaceOnUse"><stop stop-color="#1EC8B0"/><stop offset="1" stop-color="#2764E7"/></linearGradient><linearGradient id="ic_fluent_shifts_20_color__b" x1="8.94" y1="6.38" x2="7.46" y2="11.33" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#DEDEFF"/></linearGradient></defs>`, { color: true }));
export const ShiftsFilled = ( /*#__PURE__*/createFluentIcon('ShiftsFilled', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6Zm7 .5a.5.5 0 0 0-1 0v4c0 .28.22.5.5.5h3a.5.5 0 0 0 0-1H10V6.5Z"]));
export const ShiftsRegular = ( /*#__PURE__*/createFluentIcon('ShiftsRegular', "1em", ["M10 6.5a.5.5 0 0 0-1 0v4c0 .28.22.5.5.5h3a.5.5 0 0 0 0-1H10V6.5ZM6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6ZM4 6c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V6Z"]));
export const Shifts30MinutesFilled = ( /*#__PURE__*/createFluentIcon('Shifts30MinutesFilled', "1em", ["M10 7a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5ZM8 8a2 2 0 0 0-2 2v.5c0 .28.22.5.5.5h7a.5.5 0 0 0 .5-.5V10a2 2 0 0 0-2-2H8Zm-2.5 5.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm-.75 3.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm8.05-3.58c-.18.3-.3.77-.3 1.33s.12 1.03.3 1.33c.17.28.4.42.7.42.3 0 .53-.14.7-.42.18-.3.3-.77.3-1.33a2.6 2.6 0 0 0-.3-1.33c-.17-.28-.4-.42-.7-.42-.3 0-.53.14-.7.42Zm-.85-.52c.33-.53.85-.9 1.55-.9.7 0 1.22.37 1.55.9.32.5.45 1.17.45 1.85 0 .68-.13 1.34-.45 1.85-.33.53-.85.9-1.55.9-.7 0-1.22-.37-1.55-.9a3.58 3.58 0 0 1-.45-1.85c0-.68.13-1.34.45-1.85Zm-4.14.5c.46-.36.83-.43 1.08-.4.25.05.44.2.54.37.1.17.09.35 0 .48-.08.14-.32.35-.9.4a.5.5 0 0 0 0 1c.6.05.82.25.9.37.09.13.1.31 0 .5-.1.18-.3.33-.55.37-.25.04-.61-.02-1.07-.38a.5.5 0 1 0-.62.78c.62.5 1.26.68 1.85.6.57-.1 1.02-.45 1.26-.9a1.47 1.47 0 0 0-.33-1.85 1.47 1.47 0 0 0 .33-1.86c-.24-.44-.7-.78-1.27-.86a2.4 2.4 0 0 0-1.84.6.5.5 0 0 0 .62.78Z"]));
export const Shifts30MinutesRegular = ( /*#__PURE__*/createFluentIcon('Shifts30MinutesRegular', "1em", ["M8.5 4.5a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0ZM10 2a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5Zm-3 8a1 1 0 0 1 1-1h4a1 1 0 0 1 1 1v.5a.5.5 0 0 0 1 0V10a2 2 0 0 0-2-2H8a2 2 0 0 0-2 2v.5a.5.5 0 0 0 1 0V10Zm-1.5 3.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm-.75 3.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm8.05-3.58c-.18.3-.3.77-.3 1.33s.12 1.03.3 1.33c.17.28.4.42.7.42.3 0 .53-.14.7-.42.18-.3.3-.77.3-1.33a2.6 2.6 0 0 0-.3-1.33c-.17-.28-.4-.42-.7-.42-.3 0-.53.14-.7.42Zm-.85-.52c.33-.53.85-.9 1.55-.9.7 0 1.22.37 1.55.9.32.5.45 1.17.45 1.85 0 .68-.13 1.34-.45 1.85-.33.53-.85.9-1.55.9-.7 0-1.22-.37-1.55-.9a3.58 3.58 0 0 1-.45-1.85c0-.68.13-1.34.45-1.85Zm-4.14.5c.46-.36.83-.43 1.08-.4.25.05.44.2.54.37.1.17.09.35 0 .48-.08.14-.32.35-.9.4a.5.5 0 0 0 0 1c.6.05.82.25.9.37.09.13.1.31 0 .5-.1.18-.3.33-.55.37-.25.04-.61-.02-1.07-.38a.5.5 0 1 0-.62.78c.62.5 1.26.68 1.85.6.57-.1 1.02-.45 1.26-.9a1.47 1.47 0 0 0-.33-1.85 1.47 1.47 0 0 0 .33-1.86c-.24-.44-.7-.78-1.27-.86a2.4 2.4 0 0 0-1.84.6.5.5 0 0 0 .62.78Z"]));
export const ShiftsActivityFilled = ( /*#__PURE__*/createFluentIcon('ShiftsActivityFilled', "1em", ["M10 2.7a.75.75 0 0 1-.67.83 6.5 6.5 0 1 0 7.14 7.14.75.75 0 1 1 1.5.16 8 8 0 1 1-8.8-8.8c.42-.04.79.26.83.68Zm1.02-.06c.1-.4.5-.65.9-.55.38.09.75.2 1.1.35a.75.75 0 0 1-.55 1.39 6.55 6.55 0 0 0-.9-.29.75.75 0 0 1-.55-.9Zm6.54 4.33a.75.75 0 0 0-1.39.56c.12.29.21.59.28.9a.75.75 0 1 0 1.46-.35c-.09-.38-.2-.75-.35-1.1ZM14.3 3.93a.75.75 0 0 1 1.06-.08c.3.27.6.56.86.87a.75.75 0 0 1-1.15.97 6.65 6.65 0 0 0-.7-.7.75.75 0 0 1-.07-1.06ZM10 5.75a.75.75 0 0 0-1.5 0v5c0 .41.34.75.75.75h3a.75.75 0 1 0 0-1.5H10V5.75Z"]));
export const ShiftsActivityRegular = ( /*#__PURE__*/createFluentIcon('ShiftsActivityRegular', "1em", ["M10 2.48a.5.5 0 0 1-.46.53 7 7 0 1 0 7.45 7.45.5.5 0 1 1 1 .07 8 8 0 1 1-8.52-8.51.5.5 0 0 1 .53.46Zm1 .07a.5.5 0 0 1 .6-.4c.56.12 1.1.3 1.6.52a.5.5 0 1 1-.4.91c-.44-.2-.91-.34-1.4-.44a.5.5 0 0 1-.4-.59Zm6.34 4.25a.5.5 0 1 0-.92.4c.2.45.34.91.44 1.4a.5.5 0 0 0 .98-.2 7.95 7.95 0 0 0-.5-1.6ZM14.4 3.92a.5.5 0 0 1 .7-.07c.4.33.75.69 1.08 1.08a.5.5 0 1 1-.78.63c-.28-.34-.6-.66-.93-.94a.5.5 0 0 1-.07-.7ZM10 5.5a.5.5 0 0 0-1 0v5c0 .28.22.5.5.5h3a.5.5 0 1 0 0-1H10V5.5Z"]));
export const ShiftsAddFilled = ( /*#__PURE__*/createFluentIcon('ShiftsAddFilled', "1em", ["M6 3a3 3 0 0 0-3 3v3.6a5.5 5.5 0 0 1 7.4 7.4H14a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6Zm4.5 3c.28 0 .5.22.5.5V9h1.5a.5.5 0 0 1 0 1h-2a.5.5 0 0 1-.5-.5v-3c0-.28.22-.5.5-.5Zm-.5 8.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14H3.5a.5.5 0 0 0 0 1H5v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H6v-1.5Z"]));
export const ShiftsAddRegular = ( /*#__PURE__*/createFluentIcon('ShiftsAddRegular', "1em", ["M6 3a3 3 0 0 0-3 3v3.6c.32-.16.65-.3 1-.4V6c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2h-3.2c-.1.35-.24.68-.4 1H14a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6Zm-.5 16a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm0-7c.28 0 .5.22.5.5V14h1.5a.5.5 0 0 1 0 1H6v1.5a.5.5 0 0 1-1 0V15H3.5a.5.5 0 0 1 0-1H5v-1.5c0-.28.22-.5.5-.5ZM11 6.5a.5.5 0 0 0-1 0v3c0 .28.22.5.5.5h2a.5.5 0 0 0 0-1H11V6.5Z"]));
export const ShiftsAvailabilityFilled = ( /*#__PURE__*/createFluentIcon('ShiftsAvailabilityFilled', "1em", ["M6 12.92A7 7 0 0 1 12.92 6 6 6 0 1 0 6 12.92Zm3.35-8.27c.2.2.2.5 0 .7l-3 3a.5.5 0 0 1-.7 0l-1.5-1.5a.5.5 0 1 1 .7-.7L6 7.29l2.65-2.64c.2-.2.5-.2.7 0ZM13 19a6 6 0 1 0 0-12 6 6 0 0 0 0 12Zm-1.65-8.35L13 12.29l1.65-1.64a.5.5 0 0 1 .7.7L13.71 13l1.64 1.65a.5.5 0 0 1-.7.7L13 13.71l-1.65 1.64a.5.5 0 0 1-.7-.7L12.29 13l-1.64-1.65a.5.5 0 0 1 .7-.7Z"]));
export const ShiftsAvailabilityRegular = ( /*#__PURE__*/createFluentIcon('ShiftsAvailabilityRegular', "1em", ["M11.92 6.08a5 5 0 1 0-5.84 5.84c-.05.32-.08.66-.08 1A6 6 0 1 1 12.92 6c-.34 0-.68.03-1 .08Zm-.57 4.57a.5.5 0 0 0-.7.7L12.29 13l-1.64 1.65a.5.5 0 0 0 .7.7L13 13.71l1.65 1.64a.5.5 0 0 0 .7-.7L13.71 13l1.64-1.65a.5.5 0 0 0-.7-.7L13 12.29l-1.65-1.64ZM13 19a6 6 0 1 0 0-12 6 6 0 0 0 0 12Zm0-1a5 5 0 1 1 0-10 5 5 0 0 1 0 10ZM9.35 5.35a.5.5 0 1 0-.7-.7L6 7.29 4.85 6.15a.5.5 0 1 0-.7.7l1.5 1.5c.2.2.5.2.7 0l3-3Z"]));
export const ShiftsCheckmarkFilled = ( /*#__PURE__*/createFluentIcon('ShiftsCheckmarkFilled', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3h-3.6a5.48 5.48 0 0 0-.66-6h2.76a.5.5 0 0 0 0-1H10V6.5a.5.5 0 0 0-1 0v3.76a5.48 5.48 0 0 0-6-.66V6Zm7 8.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15-1.85a.5.5 0 0 0-.7 0L4.5 15.29l-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l3-3a.5.5 0 0 0 0-.7Z"]));
export const ShiftsCheckmarkRegular = ( /*#__PURE__*/createFluentIcon('ShiftsCheckmarkRegular', "1em", ["M6 3a3 3 0 0 0-3 3v3.6c.32-.16.65-.3 1-.4V6c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2h-3.2c-.1.35-.24.68-.4 1H14a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6Zm3 7.26c.27.22.52.47.74.74h2.76a.5.5 0 0 0 0-1H10V6.5a.5.5 0 0 0-1 0v3.76Zm1 4.24a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15-1.85a.5.5 0 0 0-.7 0L4.5 15.29l-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l3-3a.5.5 0 0 0 0-.7Z"]));
export const ShiftsDayFilled = ( /*#__PURE__*/createFluentIcon('ShiftsDayFilled', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9Zm3.4 2.04a1.82 1.82 0 0 0-.34.5l-.03.08a.5.5 0 0 0 .94.34l.02-.05.13-.17c.12-.11.3-.24.65-.24.4 0 .64.23.75.54.1.33.03.72-.24.96-.15.15-.34.28-.58.44l-.04.02c-.22.15-.47.31-.7.51A2.52 2.52 0 0 0 6 12.5a.5.5 0 0 0 .5.5H9a.5.5 0 0 0 0-1H7.07c.1-.32.29-.56.54-.77.18-.15.39-.3.62-.44l.02-.02c.23-.15.5-.33.72-.54.58-.54.71-1.34.5-2A1.74 1.74 0 0 0 7.77 7c-.64 0-1.09.26-1.36.54ZM11.5 7a.5.5 0 0 0-.5.5V10a.5.5 0 0 0 .5.5H13v2a.5.5 0 0 0 1 0v-5a.5.5 0 0 0-1 0v2h-1v-2a.5.5 0 0 0-.5-.5Z"]));
export const ShiftsDayRegular = ( /*#__PURE__*/createFluentIcon('ShiftsDayRegular', "1em", ["M6.4 7.54c.28-.28.73-.54 1.37-.54.88 0 1.48.56 1.7 1.23.21.66.08 1.46-.5 2-.23.21-.49.39-.72.54l-.02.02c-.23.15-.44.29-.62.44a1.6 1.6 0 0 0-.54.77H9a.5.5 0 1 1 0 1H6.5a.5.5 0 0 1-.5-.5c0-.97.44-1.59.96-2.03.23-.2.48-.36.7-.5l.04-.03c.24-.16.43-.3.58-.44a.93.93 0 0 0 .24-.96.75.75 0 0 0-.75-.54.86.86 0 0 0-.65.24.82.82 0 0 0-.15.22.5.5 0 0 1-.94-.34l.03-.07.07-.14c.05-.1.15-.23.28-.37ZM11.5 7c.28 0 .5.22.5.5v2h1v-2a.5.5 0 0 1 1 0v5a.5.5 0 0 1-1 0v-2h-1.5a.5.5 0 0 1-.5-.5V7.5c0-.28.22-.5.5-.5Zm-6-4A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5v-9A2.5 2.5 0 0 0 14.5 3h-9ZM4 5.5C4 4.67 4.67 4 5.5 4h9c.83 0 1.5.67 1.5 1.5v9c0 .83-.67 1.5-1.5 1.5h-9A1.5 1.5 0 0 1 4 14.5v-9Z"]));
export const ShiftsOpenFilled = ( /*#__PURE__*/createFluentIcon('ShiftsOpenFilled', "1em", ["M4.5 5.75c0-.69.56-1.25 1.25-1.25H7.5a.75.75 0 0 0 0-1.5H5.75A2.75 2.75 0 0 0 3 5.75v8.5A2.75 2.75 0 0 0 5.75 17H7.5a.75.75 0 0 0 0-1.5H5.75c-.69 0-1.25-.56-1.25-1.25v-8.5Zm8-2.75a.75.75 0 0 0 0 1.5h1.75c.69 0 1.25.56 1.25 1.25v8.5c0 .69-.56 1.25-1.25 1.25H12.5a.75.75 0 0 0 0 1.5h1.75A2.75 2.75 0 0 0 17 14.25v-8.5A2.75 2.75 0 0 0 14.25 3H12.5Zm-2 2.75a.75.75 0 0 0-1.5 0v4.5c0 .41.34.75.75.75h3.5a.75.75 0 0 0 0-1.5H10.5V5.75Z"]));
export const ShiftsOpenRegular = ( /*#__PURE__*/createFluentIcon('ShiftsOpenRegular', "1em", ["M4 5.5C4 4.67 4.67 4 5.5 4h2a.5.5 0 0 0 0-1h-2A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h2a.5.5 0 0 0 0-1h-2A1.5 1.5 0 0 1 4 14.5v-9ZM12.5 3a.5.5 0 0 0 0 1h2c.83 0 1.5.67 1.5 1.5v9c0 .83-.67 1.5-1.5 1.5h-2a.5.5 0 0 0 0 1h2a2.5 2.5 0 0 0 2.5-2.5v-9A2.5 2.5 0 0 0 14.5 3h-2ZM10 5.5a.5.5 0 0 0-1 0v5c0 .28.22.5.5.5h4a.5.5 0 0 0 0-1H10V5.5Z"]));
export const ShiftsProhibitedFilled = ( /*#__PURE__*/createFluentIcon('ShiftsProhibitedFilled', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3h-3.6A5.5 5.5 0 0 0 3 9.6V6Zm8 .5a.5.5 0 0 0-1 0v3c0 .28.22.5.5.5h2a.5.5 0 0 0 0-1H11V6.5Zm-10 8a4.5 4.5 0 1 0 9 0 4.5 4.5 0 0 0-9 0Zm1 0a3.5 3.5 0 0 1 5.6-2.8l-4.9 4.9a3.48 3.48 0 0 1-.7-2.1ZM5.5 18c-.79 0-1.51-.26-2.1-.7l4.9-4.9A3.5 3.5 0 0 1 5.5 18Z"]));
export const ShiftsProhibitedRegular = ( /*#__PURE__*/createFluentIcon('ShiftsProhibitedRegular', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3h-3.6c.16-.32.3-.65.4-1H14a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v3.2c-.35.1-.68.24-1 .4V6Zm7.5 0c.28 0 .5.22.5.5V9h1.5a.5.5 0 0 1 0 1h-2a.5.5 0 0 1-.5-.5v-3c0-.28.22-.5.5-.5ZM1 14.5a4.5 4.5 0 1 0 9 0 4.5 4.5 0 0 0-9 0Zm1 0a3.5 3.5 0 0 1 5.6-2.8l-4.9 4.9a3.48 3.48 0 0 1-.7-2.1ZM5.5 18c-.79 0-1.51-.26-2.1-.7l4.9-4.9A3.5 3.5 0 0 1 5.5 18Z"]));
export const ShiftsQuestionMarkFilled = ( /*#__PURE__*/createFluentIcon('ShiftsQuestionMarkFilled', "1em", ["M6 3a3 3 0 0 0-3 3v3.6a5.5 5.5 0 0 1 7.4 7.4H14a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6Zm4.5 3c.28 0 .5.22.5.5V9h2a.5.5 0 0 1 0 1h-2.5a.5.5 0 0 1-.5-.5v-3c0-.28.22-.5.5-.5Zm-.5 8.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4.5 1.88a.62.62 0 1 0 0 1.25.62.62 0 0 0 0-1.25Zm0-4.88c-1.05 0-1.86.82-1.85 1.96a.5.5 0 1 0 1-.01c0-.58.36-.95.85-.95.47 0 .85.4.85.95 0 .2-.07.32-.36.55l-.27.21c-.51.4-.72.72-.72 1.29a.5.5 0 0 0 1 .09v-.16c.02-.14.1-.25.35-.44l.28-.22c.5-.4.72-.73.72-1.32 0-1.1-.82-1.95-1.85-1.95Z"]));
export const ShiftsQuestionMarkRegular = ( /*#__PURE__*/createFluentIcon('ShiftsQuestionMarkRegular', "1em", ["M6 3a3 3 0 0 0-3 3v3.6c.32-.16.65-.3 1-.4V6c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2h-3.2c-.1.35-.24.68-.4 1H14a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6Zm5 3.5a.5.5 0 0 0-1 0v3c0 .28.22.5.5.5h2a.5.5 0 0 0 0-1H11V6.5Zm-1 8a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4.5 1.88a.62.62 0 1 0 0 1.25.62.62 0 0 0 0-1.25Zm0-4.88c-1.05 0-1.86.82-1.85 1.96a.5.5 0 1 0 1-.01c0-.58.36-.95.85-.95.47 0 .85.4.85.95 0 .2-.07.32-.36.55l-.27.21c-.51.4-.72.72-.72 1.29a.5.5 0 0 0 1 .09v-.16c.02-.14.1-.25.35-.44l.28-.22c.5-.4.72-.73.72-1.32 0-1.1-.82-1.95-1.85-1.95Z"]));
export const ShiftsTeamFilled = ( /*#__PURE__*/createFluentIcon('ShiftsTeamFilled', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3h-3.02l.02-.38c0-.91-.59-1.75-1.45-2.02a2.25 2.25 0 0 0-3.31-3.01A2.75 2.75 0 0 0 3 10.1V6Zm7 .5a.5.5 0 0 0-1 0v4c0 .28.22.5.5.5h3a.5.5 0 0 0 0-1H10V6.5Zm-6.25 8a1.75 1.75 0 1 0 0-3.5 1.75 1.75 0 0 0 0 3.5ZM4 19c2.14 0 3-1.1 3-2.19a1.3 1.3 0 0 0-1.29-1.31H2.3A1.3 1.3 0 0 0 1 16.81c0 1.1.86 2.19 3 2.19Zm3.5-.5h-.02c.35-.51.52-1.1.52-1.69 0-.48-.15-.93-.4-1.31h1.33c.6 0 1.07.5 1.07 1.13 0 .93-.71 1.87-2.5 1.87Zm.25-4a1.25 1.25 0 1 0 0-2.5 1.25 1.25 0 0 0 0 2.5Z"]));
export const ShiftsTeamRegular = ( /*#__PURE__*/createFluentIcon('ShiftsTeamRegular', "1em", ["M10 6.5a.5.5 0 0 0-1 0v4c0 .28.22.5.5.5h3a.5.5 0 0 0 0-1H10V6.5ZM6 3a3 3 0 0 0-3 3v4.1a2.75 2.75 0 0 1 1-.09V6c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2h-3.1a2.16 2.16 0 0 1 .08 1H14a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6ZM3.75 14.5a1.75 1.75 0 1 0 0-3.5 1.75 1.75 0 0 0 0 3.5ZM4 19c2.14 0 3-1.1 3-2.19a1.3 1.3 0 0 0-1.29-1.31H2.3A1.3 1.3 0 0 0 1 16.81c0 1.1.86 2.19 3 2.19Zm3.5-.5h-.02c.35-.51.52-1.1.52-1.69 0-.48-.15-.93-.4-1.31h1.33c.6 0 1.07.5 1.07 1.13 0 .93-.71 1.87-2.5 1.87Zm.25-4a1.25 1.25 0 1 0 0-2.5 1.25 1.25 0 0 0 0 2.5Z"]));
export const ShoppingBagFilled = ( /*#__PURE__*/createFluentIcon('ShoppingBagFilled', "1em", ["M6 4.5V6H5a1 1 0 0 0-1 1v8a2.93 2.93 0 0 0 .88 2.13A3 3 0 0 0 7 18h4.76a2.99 2.99 0 0 1-.76-2V4.5a2.48 2.48 0 0 0-.33-1.24 1.48 1.48 0 0 1 2.21.66c.08.18.12.37.12.58V6h-1v10a2 2 0 1 0 4 0V7a1 1 0 0 0-1-1h-1V4.5a2.48 2.48 0 0 0-4-2A2.54 2.54 0 0 0 8.5 2a2.42 2.42 0 0 0-1.77.73A2.43 2.43 0 0 0 6 4.5Zm1 0a1.48 1.48 0 0 1 .91-1.38 1.48 1.48 0 0 1 1.97.8c.08.18.12.37.12.58V6H7V4.5Z"]));
export const ShoppingBagRegular = ( /*#__PURE__*/createFluentIcon('ShoppingBagRegular', "1em", ["M10 2.5a2.5 2.5 0 0 0-4 2V6H5a1 1 0 0 0-1 1v8a3 3 0 0 0 3 3h6.5a2.5 2.5 0 0 0 2.5-2.5V7a1 1 0 0 0-1-1h-1V4.5a2.5 2.5 0 0 0-4-2Zm-3 2a1.5 1.5 0 1 1 3 0V6H7V4.5Zm3.67-1.25A1.5 1.5 0 0 1 13 4.5V6h-2V4.5c0-.45-.12-.88-.33-1.25ZM7 17a2 2 0 0 1-2-2V7h6v8.5c0 .56.19 1.08.5 1.5H7Zm8-1.5a1.5 1.5 0 0 1-3 0V7h3v8.5Z"]));
export const ShoppingBagAddFilled = ( /*#__PURE__*/createFluentIcon('ShoppingBagAddFilled', "1em", ["M14.5 19a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm0-7c.28 0 .5.22.5.5V14h1.5a.5.5 0 0 1 0 1H15v1.5a.5.5 0 0 1-1 0V15h-1.5a.5.5 0 0 1 0-1H14v-1.5c0-.28.22-.5.5-.5ZM6 6V4.5a2.42 2.42 0 0 1 .73-1.77A2.43 2.43 0 0 1 8.5 2a2.43 2.43 0 0 1 1.5.5 2.44 2.44 0 0 1 2.48-.3 2.53 2.53 0 0 1 1.32 1.33c.13.3.2.63.2.97V6h1a1 1 0 0 1 1 1v2.2a5.5 5.5 0 0 0-4 .4V6h1V4.5a1.47 1.47 0 0 0-.44-1.06A1.48 1.48 0 0 0 11.5 3c-.3 0-.58.09-.83.26A2.5 2.5 0 0 1 11 4.5v5.76a5.49 5.49 0 0 0-.74 7.74H7a3 3 0 0 1-3-3V7a1 1 0 0 1 1-1h1Zm4 0V4.5a1.47 1.47 0 0 0-.44-1.06A1.48 1.48 0 0 0 8.5 3a1.47 1.47 0 0 0-1.06.44A1.48 1.48 0 0 0 7 4.5V6h3Z"]));
export const ShoppingBagAddRegular = ( /*#__PURE__*/createFluentIcon('ShoppingBagAddRegular', "1em", ["M14.5 19a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm0-7c.28 0 .5.22.5.5V14h1.5a.5.5 0 0 1 0 1H15v1.5a.5.5 0 0 1-1 0V15h-1.5a.5.5 0 0 1 0-1H14v-1.5c0-.28.22-.5.5-.5ZM10 2.5a2.5 2.5 0 0 0-4 2V6H5a1 1 0 0 0-1 1v8a3 3 0 0 0 3 3h3.26a5.5 5.5 0 0 1-.66-1H7a2 2 0 0 1-2-2V7h6v3.26c.3-.26.64-.48 1-.66V7h3v2.02c.34.03.68.1 1 .19V7a1 1 0 0 0-1-1h-1V4.5a2.5 2.5 0 0 0-4-2Zm-3 2a1.5 1.5 0 1 1 3 0V6H7V4.5Zm3.67-1.25A1.5 1.5 0 0 1 13 4.5V6h-2V4.5c0-.45-.12-.88-.33-1.25Z"]));
export const ShoppingBagArrowLeftFilled = ( /*#__PURE__*/createFluentIcon('ShoppingBagArrowLeftFilled', "1em", ["M6 6V4.5a2.42 2.42 0 0 1 .73-1.77A2.43 2.43 0 0 1 8.5 2a2.43 2.43 0 0 1 1.5.5 2.44 2.44 0 0 1 2.48-.3 2.53 2.53 0 0 1 1.32 1.33c.13.3.2.63.2.97V6h1a1 1 0 0 1 1 1v2.2a5.5 5.5 0 0 0-4 .4V6h1V4.5a1.47 1.47 0 0 0-.44-1.06A1.48 1.48 0 0 0 11.5 3c-.3 0-.58.09-.83.26A2.5 2.5 0 0 1 11 4.5v5.76a5.49 5.49 0 0 0-.74 7.74H7a3 3 0 0 1-3-3V7a1 1 0 0 1 1-1h1Zm4 0V4.5a1.47 1.47 0 0 0-.44-1.06A1.48 1.48 0 0 0 8.5 3a1.47 1.47 0 0 0-1.06.44A1.48 1.48 0 0 0 7 4.5V6h3Zm9 8.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-6.85-.35a.5.5 0 0 0-.15.35.5.5 0 0 0 .15.35l2 2a.5.5 0 0 0 .7-.7L13.71 15h2.79a.5.5 0 0 0 0-1h-2.8l1.15-1.15a.5.5 0 0 0-.7-.7l-2 2Z"]));
export const ShoppingBagArrowLeftRegular = ( /*#__PURE__*/createFluentIcon('ShoppingBagArrowLeftRegular', "1em", ["M15 6a1 1 0 0 1 1 1v2.2c-.32-.08-.66-.15-1-.18V7h-3v2.6c-.36.18-.7.4-1 .66V7H5v8a1.98 1.98 0 0 0 1.23 1.84c.24.1.5.16.77.16h2.6c.18.36.4.7.66 1H7a3 3 0 0 1-3-3V7a1 1 0 0 1 1-1h1V4.5a2.42 2.42 0 0 1 .73-1.77A2.43 2.43 0 0 1 8.5 2a2.43 2.43 0 0 1 1.5.5 2.44 2.44 0 0 1 2.48-.3 2.53 2.53 0 0 1 1.32 1.33c.13.3.2.63.2.97V6h1Zm-2-1.5a1.47 1.47 0 0 0-.44-1.06A1.48 1.48 0 0 0 11.5 3c-.3 0-.58.09-.83.26A2.5 2.5 0 0 1 11 4.5V6h2V4.5ZM7 6h3V4.5a1.47 1.47 0 0 0-.44-1.06A1.48 1.48 0 0 0 8.5 3a1.47 1.47 0 0 0-1.06.44A1.48 1.48 0 0 0 7 4.5V6Zm7.5 13a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm-2.36-4.85 2-2a.5.5 0 0 1 .71.7L13.71 14h2.79a.5.5 0 0 1 0 1h-2.8l1.15 1.15a.5.5 0 0 1-.7.7l-2-2a.5.5 0 0 1-.15-.35.5.5 0 0 1 .14-.35Z"]));
export const ShoppingBagCheckmarkFilled = ( /*#__PURE__*/createFluentIcon('ShoppingBagCheckmarkFilled', "1em", ["M6 4.5V6H5a1 1 0 0 0-1 1v8a2.93 2.93 0 0 0 .88 2.13A3 3 0 0 0 7 18h3.26a5.48 5.48 0 0 1 .74-7.74V4.5a2.48 2.48 0 0 0-.33-1.24 1.48 1.48 0 0 1 2.21.66c.08.18.12.37.12.58V6h-1v3.6a5.48 5.48 0 0 1 4-.4V7a1 1 0 0 0-1-1h-1V4.5a2.48 2.48 0 0 0-4-2A2.54 2.54 0 0 0 8.5 2a2.42 2.42 0 0 0-1.77.73A2.43 2.43 0 0 0 6 4.5Zm1 0a1.48 1.48 0 0 1 .91-1.38 1.48 1.48 0 0 1 1.97.8c.08.18.12.37.12.58V6H7V4.5Zm12 10a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15-1.85a.5.5 0 0 0-.7 0l-2.65 2.64-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l3-3a.5.5 0 0 0 0-.7Z"]));
export const ShoppingBagCheckmarkRegular = ( /*#__PURE__*/createFluentIcon('ShoppingBagCheckmarkRegular', "1em", ["M10 2.5a2.5 2.5 0 0 0-4 2V6H5a1 1 0 0 0-1 1v8a3 3 0 0 0 3 3h3.26a5.5 5.5 0 0 1-.66-1H7a2 2 0 0 1-2-2V7h6v3.26c.3-.26.64-.48 1-.66V7h3v2.02c.34.03.68.1 1 .19V7a1 1 0 0 0-1-1h-1V4.5a2.5 2.5 0 0 0-4-2Zm-3 2a1.5 1.5 0 1 1 3 0V6H7V4.5Zm3.67-1.25A1.5 1.5 0 0 1 13 4.5V6h-2V4.5c0-.45-.12-.88-.33-1.25ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15-1.85a.5.5 0 0 0-.7 0l-2.65 2.64-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l3-3a.5.5 0 0 0 0-.7Z"]));
export const ShoppingBagDismissFilled = ( /*#__PURE__*/createFluentIcon('ShoppingBagDismissFilled', "1em", ["M6 6V4.5a2.42 2.42 0 0 1 .73-1.77A2.43 2.43 0 0 1 8.5 2a2.43 2.43 0 0 1 1.5.5 2.44 2.44 0 0 1 2.48-.3 2.53 2.53 0 0 1 1.32 1.33c.13.3.2.63.2.97V6h1a1 1 0 0 1 1 1v2.2a5.5 5.5 0 0 0-4 .4V6h1V4.5a1.47 1.47 0 0 0-.44-1.06A1.48 1.48 0 0 0 11.5 3c-.3 0-.58.09-.83.26A2.5 2.5 0 0 1 11 4.5v5.76a5.49 5.49 0 0 0-.74 7.74H7a3 3 0 0 1-3-3V7a1 1 0 0 1 1-1h1Zm4 0V4.5a1.47 1.47 0 0 0-.44-1.06A1.48 1.48 0 0 0 8.5 3a1.47 1.47 0 0 0-1.06.44A1.48 1.48 0 0 0 7 4.5V6h3Zm9 8.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.65-1.15a.5.5 0 0 0-.7-.7l-1.15 1.14-1.15-1.14a.5.5 0 0 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 0 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 0 0 .7-.7l-1.14-1.15 1.14-1.15Z"]));
export const ShoppingBagDismissRegular = ( /*#__PURE__*/createFluentIcon('ShoppingBagDismissRegular', "1em", ["M10 2.5a2.5 2.5 0 0 0-4 2V6H5a1 1 0 0 0-1 1v8a3 3 0 0 0 3 3h3.26a5.5 5.5 0 0 1-.66-1H7a2 2 0 0 1-2-2V7h6v3.26c.3-.26.64-.48 1-.66V7h3v2.02c.34.03.68.1 1 .19V7a1 1 0 0 0-1-1h-1V4.5a2.5 2.5 0 0 0-4-2Zm-3 2a1.5 1.5 0 1 1 3 0V6H7V4.5Zm3.67-1.25A1.5 1.5 0 0 1 13 4.5V6h-2V4.5c0-.45-.12-.88-.33-1.25ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.65-1.15a.5.5 0 0 0-.7-.7l-1.15 1.14-1.15-1.14a.5.5 0 0 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 0 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 0 0 .7-.7l-1.14-1.15 1.14-1.15Z"]));
export const ShoppingBagPauseFilled = ( /*#__PURE__*/createFluentIcon('ShoppingBagPauseFilled', "1em", ["M6 6V4.5a2.42 2.42 0 0 1 .73-1.77A2.43 2.43 0 0 1 8.5 2a2.43 2.43 0 0 1 1.5.5 2.44 2.44 0 0 1 2.48-.3 2.53 2.53 0 0 1 1.32 1.33c.13.3.2.63.2.97V6h1a1 1 0 0 1 1 1v2.2a5.5 5.5 0 0 0-4 .4V6h1V4.5a1.47 1.47 0 0 0-.44-1.06A1.48 1.48 0 0 0 11.5 3c-.3 0-.58.09-.83.26A2.5 2.5 0 0 1 11 4.5v5.76a5.49 5.49 0 0 0-.74 7.74H7a3 3 0 0 1-3-3V7a1 1 0 0 1 1-1h1Zm4 0V4.5a1.47 1.47 0 0 0-.44-1.06A1.48 1.48 0 0 0 8.5 3a1.47 1.47 0 0 0-1.06.44A1.48 1.48 0 0 0 7 4.5V6h3Zm9 8.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM13 12a.5.5 0 0 0-.5.5v4a.5.5 0 0 0 1 0v-4a.5.5 0 0 0-.5-.5Zm3 0a.5.5 0 0 0-.5.5v4a.5.5 0 0 0 1 0v-4a.5.5 0 0 0-.5-.5Z"]));
export const ShoppingBagPauseRegular = ( /*#__PURE__*/createFluentIcon('ShoppingBagPauseRegular', "1em", ["M10 2.5a2.5 2.5 0 0 0-4 2V6H5a1 1 0 0 0-1 1v8a3 3 0 0 0 3 3h3.26a5.5 5.5 0 0 1-.66-1H7a2 2 0 0 1-2-2V7h6v3.26c.3-.26.64-.48 1-.66V7h3v2.02c.34.03.68.1 1 .19V7a1 1 0 0 0-1-1h-1V4.5a2.5 2.5 0 0 0-4-2Zm-3 2a1.5 1.5 0 1 1 3 0V6H7V4.5Zm3.67-1.25A1.5 1.5 0 0 1 13 4.5V6h-2V4.5c0-.45-.12-.88-.33-1.25ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM13 12a.5.5 0 0 0-.5.5v4a.5.5 0 0 0 1 0v-4a.5.5 0 0 0-.5-.5Zm3 0a.5.5 0 0 0-.5.5v4a.5.5 0 0 0 1 0v-4a.5.5 0 0 0-.5-.5Z"]));
export const ShoppingBagPercentFilled = ( /*#__PURE__*/createFluentIcon('ShoppingBagPercentFilled', "1em", ["M14.5 10a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9Zm-3-8A2.48 2.48 0 0 1 14 4.5V6h1a1 1 0 0 1 1 1v2.2a5.5 5.5 0 0 0-4 .4V6h1V4.5a1.47 1.47 0 0 0-.44-1.06A1.48 1.48 0 0 0 11.5 3c-.3 0-.58.09-.83.26A2.5 2.5 0 0 1 11 4.5v5.76a5.49 5.49 0 0 0-.74 7.74H7a3 3 0 0 1-3-3V7a1 1 0 0 1 1-1h1V4.5a2.42 2.42 0 0 1 .73-1.77A2.42 2.42 0 0 1 8.5 2a2.43 2.43 0 0 1 1.5.5 2.44 2.44 0 0 1 1.5-.5Zm5 13a1 1 0 1 0 0 2 1 1 0 0 0 0-2Zm.35-2.85a.5.5 0 0 0-.7 0l-4 4a.5.5 0 1 0 .7.7l4-4a.5.5 0 0 0 0-.7ZM12.5 12a1 1 0 1 0 0 2 1 1 0 0 0 0-2Zm-4-9a1.47 1.47 0 0 0-1.06.44A1.48 1.48 0 0 0 7 4.5V6h3V4.5a1.47 1.47 0 0 0-.44-1.06A1.48 1.48 0 0 0 8.5 3Z"]));
export const ShoppingBagPercentRegular = ( /*#__PURE__*/createFluentIcon('ShoppingBagPercentRegular', "1em", ["M14.5 10a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9Zm-3-8A2.48 2.48 0 0 1 14 4.5V6h1a1 1 0 0 1 1 1v2.2c-.32-.08-.66-.15-1-.18V7h-3v2.6c-.36.18-.7.4-1 .66V7H5v8a1.98 1.98 0 0 0 1.23 1.84c.24.1.5.16.77.16h2.6c.18.36.4.7.66 1H7a3 3 0 0 1-3-3V7a1 1 0 0 1 1-1h1V4.5a2.42 2.42 0 0 1 .73-1.77A2.42 2.42 0 0 1 8.5 2a2.43 2.43 0 0 1 1.5.5 2.44 2.44 0 0 1 1.5-.5Zm5 13a1 1 0 1 0 0 2 1 1 0 0 0 0-2Zm.35-2.85a.5.5 0 0 0-.7 0l-4 4a.5.5 0 1 0 .7.7l4-4a.5.5 0 0 0 0-.7ZM12.5 12a1 1 0 1 0 0 2 1 1 0 0 0 0-2Zm-4-9a1.47 1.47 0 0 0-1.06.44A1.48 1.48 0 0 0 7 4.5V6h3V4.5a1.47 1.47 0 0 0-.44-1.06A1.48 1.48 0 0 0 8.5 3Zm3 0c-.3 0-.58.09-.83.26A2.5 2.5 0 0 1 11 4.5V6h2V4.5a1.47 1.47 0 0 0-.44-1.06A1.48 1.48 0 0 0 11.5 3Z"]));
export const ShoppingBagPlayFilled = ( /*#__PURE__*/createFluentIcon('ShoppingBagPlayFilled', "1em", ["M6 4.5V6H5a1 1 0 0 0-1 1v8a2.93 2.93 0 0 0 .88 2.13A3 3 0 0 0 7 18h3.26a5.48 5.48 0 0 1 .74-7.74V4.5a2.48 2.48 0 0 0-.33-1.24 1.48 1.48 0 0 1 2.21.66c.08.18.12.37.12.58V6h-1v3.6a5.48 5.48 0 0 1 4-.4V7a1 1 0 0 0-1-1h-1V4.5a2.48 2.48 0 0 0-4-2A2.54 2.54 0 0 0 8.5 2a2.42 2.42 0 0 0-1.77.73A2.43 2.43 0 0 0 6 4.5ZM10 6H7V4.5a1.48 1.48 0 0 1 .91-1.38 1.48 1.48 0 0 1 1.97.8c.08.18.12.37.12.58V6Zm4.5 13a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm-.74-6.55c.1 0 .18.03.26.08l2.3 1.51c.07.05.12.1.16.18a.54.54 0 0 1-.03.54.46.46 0 0 1-.13.13l-2.3 1.57a.54.54 0 0 1-.12.06.45.45 0 0 1-.32-.02.57.57 0 0 1-.16-.1.5.5 0 0 1-.14-.36v-3.08a.51.51 0 0 1 .3-.46.44.44 0 0 1 .18-.05Z"]));
export const ShoppingBagPlayRegular = ( /*#__PURE__*/createFluentIcon('ShoppingBagPlayRegular', "1em", ["M15 6a1 1 0 0 1 1 1v2.2c-.32-.08-.66-.15-1-.18V7h-3v2.6c-.36.18-.7.4-1 .66V7H5v8a1.98 1.98 0 0 0 1.23 1.84c.24.1.5.16.77.16h2.6c.18.36.4.7.66 1H7a3 3 0 0 1-3-3V7a1 1 0 0 1 1-1h1V4.5a2.42 2.42 0 0 1 .73-1.77A2.43 2.43 0 0 1 8.5 2a2.43 2.43 0 0 1 1.5.5 2.44 2.44 0 0 1 2.48-.3 2.53 2.53 0 0 1 1.32 1.33c.13.3.2.63.2.97V6h1Zm-2-1.5a1.47 1.47 0 0 0-.44-1.06A1.48 1.48 0 0 0 11.5 3c-.3 0-.58.09-.83.26A2.5 2.5 0 0 1 11 4.5V6h2V4.5ZM7 6h3V4.5a1.47 1.47 0 0 0-.44-1.06A1.48 1.48 0 0 0 8.5 3a1.47 1.47 0 0 0-1.06.44A1.48 1.48 0 0 0 7 4.5V6Zm12 8.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4.98-1.97a.45.45 0 0 0-.45-.03.5.5 0 0 0-.15.1.51.51 0 0 0-.14.36v3.08a.5.5 0 0 0 .14.35.45.45 0 0 0 .52.12.54.54 0 0 0 .09-.05l2.3-1.57a.46.46 0 0 0 .16-.18.54.54 0 0 0 0-.49.49.49 0 0 0-.17-.18l-2.3-1.5Z"]));
export const ShoppingBagTagFilled = ( /*#__PURE__*/createFluentIcon('ShoppingBagTagFilled', "1em", ["M6 6V4.5a2.42 2.42 0 0 1 .73-1.77A2.43 2.43 0 0 1 8.5 2a2.43 2.43 0 0 1 1.5.5 2.44 2.44 0 0 1 2.48-.3 2.53 2.53 0 0 1 1.32 1.33c.13.3.2.63.2.97V6h1a1 1 0 0 1 1 1v2.6a2.5 2.5 0 0 0-1.62-.6H12V6h1V4.5a1.47 1.47 0 0 0-.44-1.06A1.48 1.48 0 0 0 11.5 3c-.3 0-.58.09-.83.26A2.5 2.5 0 0 1 11 4.5v4.55c-1.14.24-2 1.25-2 2.46v2.88c0 .66.26 1.29.72 1.76L11.53 18H7a3 3 0 0 1-3-3V7a1 1 0 0 1 1-1h1Zm4 0V4.5a1.47 1.47 0 0 0-.44-1.06A1.48 1.48 0 0 0 8.5 3a1.47 1.47 0 0 0-1.06.44A1.48 1.48 0 0 0 7 4.5V6h3Zm.43 9.45a1.51 1.51 0 0 1-.43-1.06v-2.88c0-.83.68-1.51 1.51-1.51h2.87c.4 0 .8.16 1.07.45l3.11 3.14c.6.6.58 1.57-.02 2.15l-2.95 2.84a1.5 1.5 0 0 1-2.12-.03l-3.04-3.1Zm1.57-2.7a.75.75 0 1 0 1.5 0 .75.75 0 0 0-1.5 0Z"]));
export const ShoppingBagTagRegular = ( /*#__PURE__*/createFluentIcon('ShoppingBagTagRegular', "1em", ["M10 2.5a2.5 2.5 0 0 0-4 2V6H5a1 1 0 0 0-1 1v8a3 3 0 0 0 3 3h4.53l-.98-1H7a2 2 0 0 1-2-2V7h6v2.05c.16-.03.34-.05.51-.05H12V7h3v2.08c.37.09.7.27 1 .51V7a1 1 0 0 0-1-1h-1V4.5a2.5 2.5 0 0 0-4-2Zm-3 2a1.5 1.5 0 1 1 3 0V6H7V4.5Zm3.67-1.25A1.5 1.5 0 0 1 13 4.5V6h-2V4.5c0-.45-.12-.88-.33-1.25Zm-.24 12.2a1.51 1.51 0 0 1-.43-1.06v-2.88c0-.83.68-1.51 1.51-1.51h2.87c.4 0 .8.16 1.07.45l3.11 3.14c.6.6.58 1.57-.02 2.15l-2.95 2.84a1.5 1.5 0 0 1-2.12-.03l-3.04-3.1Zm1.57-2.7a.75.75 0 1 0 1.5 0 .75.75 0 0 0-1.5 0Z"]));
export const ShortpickFilled = ( /*#__PURE__*/createFluentIcon('ShortpickFilled', "1em", ["M7 2a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h.5a.5.5 0 0 0 0-1H7V3h.5a.5.5 0 0 0 0-1H7Zm2.5 0a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1h-1Zm3 0a.5.5 0 0 0 0 1h.5v2h-.5a.5.5 0 0 0 0 1h.5a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1h-.5Zm-3 3a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1h-1Zm-5 2c.28 0 .5.22.5.5v8c0 .83.67 1.5 1.5 1.5h7c.83 0 1.5-.67 1.5-1.5v-8a.5.5 0 0 1 1 0v8a2.5 2.5 0 0 1-2.5 2.5h-7A2.5 2.5 0 0 1 4 15.5v-8c0-.28.22-.5.5-.5ZM7 12a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1H7ZM6 8a1 1 0 0 1 1-1h.5a.5.5 0 0 1 0 1H7v2h.5a.5.5 0 0 1 0 1H7a1 1 0 0 1-1-1V8Zm3-.5c0-.28.22-.5.5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5Zm3 0c0-.28.22-.5.5-.5h.5a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1h-.5a.5.5 0 0 1 0-1h.5V8h-.5a.5.5 0 0 1-.5-.5Zm-3 3c0-.28.22-.5.5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5Z"]));
export const ShortpickRegular = ( /*#__PURE__*/createFluentIcon('ShortpickRegular', "1em", ["M7 2a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h.5a.5.5 0 0 0 0-1H7V3h.5a.5.5 0 0 0 0-1H7Zm2.5 0a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1h-1Zm3 0a.5.5 0 0 0 0 1h.5v2h-.5a.5.5 0 0 0 0 1h.5a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1h-.5Zm-3 3a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1h-1ZM5 7.5a.5.5 0 0 0-1 0v8A2.5 2.5 0 0 0 6.5 18h7a2.5 2.5 0 0 0 2.5-2.5v-8a.5.5 0 0 0-1 0v8c0 .83-.67 1.5-1.5 1.5h-7A1.5 1.5 0 0 1 5 15.5v-8ZM7 12a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1H7Zm0 1h6v2H7v-2ZM6 8a1 1 0 0 1 1-1h.5a.5.5 0 0 1 0 1H7v2h.5a.5.5 0 0 1 0 1H7a1 1 0 0 1-1-1V8Zm3-.5c0-.28.22-.5.5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5Zm3 0c0-.28.22-.5.5-.5h.5a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1h-.5a.5.5 0 0 1 0-1h.5V8h-.5a.5.5 0 0 1-.5-.5Zm-3 3c0-.28.22-.5.5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5Z"]));
export const ShowerheadFilled = ( /*#__PURE__*/createFluentIcon('ShowerheadFilled', "1em", ["m15.48 2.42-1.7 1.7a7.03 7.03 0 0 1 2.06 2.02l1.68-1.68a1.44 1.44 0 1 0-2.04-2.04ZM4.85 11.85a.5.5 0 0 0-.7-.7l-2 2a.5.5 0 0 0 .7.7l2-2Zm2 2a.5.5 0 0 0-.7-.7l-2 2a.5.5 0 0 0 .7.7l2-2Zm2 1.3c.2.2.2.5 0 .7l-2 2a.5.5 0 0 1-.7-.7l2-2c.2-.2.5-.2.7 0Zm4.86-.8a1.46 1.46 0 0 0-.18-.22L5.87 6.47a1.45 1.45 0 0 0-2.05 2.05l7.66 7.66a1.45 1.45 0 0 0 2.23-1.82ZM6.58 5.78a2.46 2.46 0 0 0-.45-.36 6 6 0 0 1 8.46 8.46c-.1-.16-.22-.3-.35-.44L6.58 5.77Z"]));
export const ShowerheadRegular = ( /*#__PURE__*/createFluentIcon('ShowerheadRegular', "1em", ["M17.43 2.57a1.94 1.94 0 0 0-2.74 0L12.65 4.6v.01a6 6 0 0 0-6.76 1.02 1.91 1.91 0 0 0-1.74 3.22l7 7a1.91 1.91 0 0 0 3.23-1.74 6 6 0 0 0 1.01-6.76l2.04-2.03c.76-.76.76-2 0-2.75Zm-2.57 3.9a6.05 6.05 0 0 0-1.34-1.33l1.88-1.86a.94.94 0 1 1 1.33 1.33l-1.87 1.87Zm-8.02-.34a5 5 0 0 1 7.03 7.03l-.01-.01-7-7-.02-.02Zm-.72.7 7.05 7.05a.91.91 0 0 1-1.31 1.27l-7-7a.91.91 0 0 1 1.26-1.32Zm.73 6.32c.2.2.2.5 0 .7l-2 2a.5.5 0 0 1-.7-.7l2-2c.2-.2.5-.2.7 0Zm-2-1.3a.5.5 0 1 0-.7-.7l-2 2a.5.5 0 1 0 .7.7l2-2Zm4 3.3c.2.2.2.5 0 .7l-2 2a.5.5 0 0 1-.7-.7l2-2c.2-.2.5-.2.7 0Z"]));
export const SidebarSearchLtrFilled = ( /*#__PURE__*/createFluentIcon('SidebarSearchLtrFilled', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-2.59a1.5 1.5 0 0 0-.35-.56l-2-2A4.49 4.49 0 0 0 5.5 8c-.93 0-1.78.28-2.5.76V5.5Zm10 1v7a.5.5 0 0 0 1 0v-7a.5.5 0 0 0-1 0Zm-4 6c0 .79-.26 1.51-.7 2.1l2.55 2.55a.5.5 0 0 1-.7.7L7.6 15.3A3.5 3.5 0 1 1 9 12.5Zm-1 0a2.5 2.5 0 1 0-5 0 2.5 2.5 0 0 0 5 0Z"]));
export const SidebarSearchLtrRegular = ( /*#__PURE__*/createFluentIcon('SidebarSearchLtrRegular', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-2.59a1.5 1.5 0 0 0-.35-.56l-.44-.44h3.38c.83 0 1.5-.67 1.5-1.5v-9c0-.83-.67-1.5-1.5-1.5h-9C4.67 4 4 4.67 4 5.5v2.76c-.36.12-.7.3-1 .5V5.5Zm5.3 9.1a3.5 3.5 0 1 0-.7.7l2.55 2.55a.5.5 0 0 0 .7-.7L8.3 14.6Zm-2.8.4a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5Zm8-9a.5.5 0 0 0-.5.5v7a.5.5 0 0 0 1 0v-7a.5.5 0 0 0-.5-.5Z"]));
export const SidebarSearchRtlFilled = ( /*#__PURE__*/createFluentIcon('SidebarSearchRtlFilled', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v7a4.5 4.5 0 1 0-4.5 4.5h-7A2.5 2.5 0 0 1 3 14.5v-9Zm3 1v7a.5.5 0 0 0 1 0v-7a.5.5 0 0 0-1 0Zm10 6c0 .79-.26 1.51-.7 2.1l2.55 2.55a.5.5 0 0 1-.7.7L14.6 15.3a3.5 3.5 0 1 1 1.4-2.8Zm-1 0a2.5 2.5 0 1 0-5 0 2.5 2.5 0 0 0 5 0Z"]));
export const SidebarSearchRtlRegular = ( /*#__PURE__*/createFluentIcon('SidebarSearchRtlRegular', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v7c0-1.07-.37-2.06-1-2.83V5.5c0-.83-.67-1.5-1.5-1.5h-9C4.67 4 4 4.67 4 5.5v9c0 .83.67 1.5 1.5 1.5h4.17c.77.63 1.76 1 2.83 1h-7A2.5 2.5 0 0 1 3 14.5v-9Zm3 1a.5.5 0 0 1 1 0v7a.5.5 0 0 1-1 0v-7Zm10 6c0 .79-.26 1.51-.7 2.1l2.55 2.55a.5.5 0 0 1-.7.7L14.6 15.3a3.5 3.5 0 1 1 1.4-2.8Zm-1 0a2.5 2.5 0 1 0-5 0 2.5 2.5 0 0 0 5 0Z"]));
export const SignOutFilled = ( /*#__PURE__*/createFluentIcon('SignOutFilled', "1em", ["M11 3.5a.5.5 0 0 0-.58-.5l-7 1.08a.5.5 0 0 0-.42.49v10.86c0 .25.18.46.42.5l7 1.07a.5.5 0 0 0 .58-.5V10h5.17l-1 .87a.5.5 0 0 0 .66.76l2-1.75a.5.5 0 0 0 0-.76l-2-1.75a.5.5 0 1 0-.65.76l1 .87H11V3.5Zm-2.5 7.75a.75.75 0 1 1 0-1.5.75.75 0 0 1 0 1.5Zm4 4.75H12v-5h1v4.5a.5.5 0 0 1-.5.5ZM12 8V4h.5c.28 0 .5.22.5.5V8h-1Z"]));
export const SignOutRegular = ( /*#__PURE__*/createFluentIcon('SignOutRegular', "1em", ["M8.5 11.25a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM11 3.5a.5.5 0 0 0-.58-.5l-7 1.08a.5.5 0 0 0-.42.49v10.86c0 .25.18.46.42.5l7 1.07a.5.5 0 0 0 .58-.5V10h5.17l-1 .87a.5.5 0 0 0 .66.76l2-1.75a.5.5 0 0 0 0-.76l-2-1.75a.5.5 0 1 0-.65.76l1 .87H11V3.5Zm-1 .58v11.84L4 15V5l6-.92ZM12.5 16H12v-5h1v4.5a.5.5 0 0 1-.5.5ZM12 8V4h.5c.28 0 .5.22.5.5V8h-1Z"]));
export const SignatureFilled = ( /*#__PURE__*/createFluentIcon('SignatureFilled', "1em", ["M12.02 2.77a2.44 2.44 0 1 1 3.46 3.46L14.2 7.5l.08.09a2 2 0 0 1 0 2.82l-1.44 1.44a.5.5 0 0 1-.7-.7l1.44-1.44a1 1 0 0 0 0-1.42l-.09-.08-6.65 6.64a.5.5 0 0 1-.23.14l-4 1a.5.5 0 0 1-.6-.65l1.26-3.75a.5.5 0 0 1 .12-.2l8.62-8.62ZM3.27 16.9c-.02 0-.04-.02-.05-.03l1.35-.34c.53.27 1.18.47 1.93.47.5 0 1.01-.18 1.53-.47.53-.3 1.03-.7 1.53-1.1l.13-.11c.44-.36.9-.74 1.34-1 .47-.27 1.04-.49 1.63-.3.82.28 1.08 1.04 1.32 1.84.05.18.15.36.26.49.11.12.2.15.26.15.19 0 .46-.1.8-.3a9.43 9.43 0 0 0 .93-.62 5.6 5.6 0 0 1 1.1-.55h.03l.14.47-.14-.48a.5.5 0 0 1 .28.96 2.74 2.74 0 0 0-.21.08 4.6 4.6 0 0 0-.92.54l-.7.46a2.7 2.7 0 0 1-1.31.44c-.44 0-.78-.23-1-.49a2.33 2.33 0 0 1-.48-.87c-.26-.87-.41-1.08-.68-1.17-.16-.05-.4-.02-.8.22-.37.21-.77.54-1.23.92l-.12.1c-.5.4-1.06.84-1.66 1.19-.6.34-1.29.6-2.03.6a5.49 5.49 0 0 1-3.23-1.1Z"]));
export const SignatureRegular = ( /*#__PURE__*/createFluentIcon('SignatureRegular', "1em", ["M12.02 2.77a2.44 2.44 0 1 1 3.46 3.46L14.2 7.5l.08.09a2 2 0 0 1 0 2.82l-1.44 1.44a.5.5 0 0 1-.7-.7l1.44-1.44a1 1 0 0 0 0-1.42l-.09-.08-6.65 6.64a.5.5 0 0 1-.23.14l-4 1a.5.5 0 0 1-.6-.65l1.26-3.75a.5.5 0 0 1 .12-.2l8.62-8.62Zm2.75.7a1.44 1.44 0 0 0-2.04 0l-8.54 8.55-.93 2.77 2.98-.74 8.53-8.53c.57-.56.57-1.48 0-2.04ZM3.22 16.88l.05.03C4 17.44 5.1 18 6.5 18c.74 0 1.42-.26 2.03-.6.6-.35 1.16-.8 1.66-1.2l.12-.1c.46-.37.86-.7 1.23-.91.4-.24.64-.27.8-.22.27.1.42.3.68 1.17.09.3.24.61.47.87.23.26.57.49 1.01.49.47 0 .94-.23 1.3-.44a12.61 12.61 0 0 0 .97-.64 4.6 4.6 0 0 1 .82-.42l.04-.02h.01a.5.5 0 0 0-.28-.96h-.01l-.02.01a2.35 2.35 0 0 0-.31.12c-.2.09-.47.22-.8.43l-.33.23c-.19.13-.38.26-.6.39-.33.2-.6.3-.79.3-.06 0-.15-.03-.26-.15-.11-.13-.2-.31-.26-.5-.24-.8-.5-1.55-1.32-1.82-.59-.2-1.16.02-1.63.3-.44.25-.9.63-1.34.99l-.13.1c-.5.41-1 .8-1.53 1.1-.52.3-1.02.48-1.53.48-.75 0-1.4-.2-1.93-.47l-1.35.34ZM17.5 15.5l-.14-.48.14.48Z"]));
export const SimFilled = ( /*#__PURE__*/createFluentIcon('SimFilled', "1em", ["M4 5a3 3 0 0 1 3-3h3.46a3 3 0 0 1 2.13.88l2.53 2.53A3 3 0 0 1 16 7.54V15a3 3 0 0 1-3 3H7a3 3 0 0 1-3-3V5Zm3 5.5v.5h3V9H8.5C7.67 9 7 9.67 7 10.5ZM7 12v1.5c0 .83.67 1.5 1.5 1.5H10v-3H7Zm4.5 3c.83 0 1.5-.67 1.5-1.5v-3c0-.83-.67-1.5-1.5-1.5H11v6h.5Z"]));
export const SimRegular = ( /*#__PURE__*/createFluentIcon('SimRegular', "1em", ["M8.5 9h3c.83 0 1.5.67 1.5 1.5v3c0 .83-.67 1.5-1.5 1.5h-3A1.5 1.5 0 0 1 7 13.5v-3C7 9.67 7.67 9 8.5 9ZM8 10.5v.5h2v-1H8.5a.5.5 0 0 0-.5.5ZM8 12v1.5c0 .28.22.5.5.5H10v-2H8Zm3.5 2a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5H11v4h.5ZM7 2a3 3 0 0 0-3 3v10a3 3 0 0 0 3 3h6a3 3 0 0 0 3-3V7.54a3 3 0 0 0-.88-2.13L12.6 2.88A3 3 0 0 0 10.46 2H7ZM5 5c0-1.1.9-2 2-2h3.46a2 2 0 0 1 1.42.59l2.53 2.53A2 2 0 0 1 15 7.54V15a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V5Z"]));
export const SkipBack10Filled = ( /*#__PURE__*/createFluentIcon('SkipBack10Filled', "1em", ["M4 5.63V3.75a.75.75 0 0 0-1.5 0v3.5c0 .41.34.75.75.75h4a.75.75 0 0 0 0-1.5H5.23A6.3 6.3 0 0 1 10 4.25c2.4 0 4.53 1.41 5.65 3.54.15.28.43.46.73.46.54 0 .91-.53.67-1.01A7.93 7.93 0 0 0 10 2.75a7.77 7.77 0 0 0-6 2.88Zm4.25 5.12a.75.75 0 0 0-1.24-.57l-1.75 1.5a.75.75 0 1 0 .98 1.14l.51-.44v3.87a.75.75 0 0 0 1.5 0v-5.5ZM15 13.5c0 1.93-.63 3.5-2.5 3.5-1.88 0-2.5-1.57-2.5-3.5s.63-3.5 2.5-3.5c1.88 0 2.5 1.57 2.5 3.5Zm-1.5 0c0-.85-.15-1.4-.32-1.69a.59.59 0 0 0-.22-.22.94.94 0 0 0-.46-.09.94.94 0 0 0-.46.09.59.59 0 0 0-.22.22c-.17.3-.32.84-.32 1.69s.15 1.4.32 1.69c.08.12.15.18.22.22.07.04.2.09.46.09s.39-.05.46-.09c.07-.04.14-.1.22-.22.17-.3.32-.84.32-1.69Z"]));
export const SkipBack10Regular = ( /*#__PURE__*/createFluentIcon('SkipBack10Regular', "1em", ["M3 3.5a.5.5 0 1 1 1 0v2.2a8 8 0 0 1 13.16 1.75.5.5 0 1 1-.9.44 7 7 0 0 0-12-.89H7.5a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5v-4Zm5 7a.5.5 0 0 0-.78-.42l-1.5 1a.5.5 0 0 0 .56.84l.72-.49v5.07a.5.5 0 0 0 1 0v-6Zm4.5-.5c-.93 0-1.6.44-2 1.13-.37.65-.5 1.5-.5 2.37 0 .86.13 1.72.5 2.37.4.7 1.07 1.13 2 1.13.94 0 1.6-.44 2-1.13.38-.65.5-1.5.5-2.37 0-.86-.12-1.72-.5-2.37a2.18 2.18 0 0 0-2-1.13ZM11 13.5c0-.8.13-1.44.37-1.87.23-.4.57-.63 1.13-.63.57 0 .9.23 1.13.63.25.43.37 1.08.37 1.87 0 .8-.12 1.44-.37 1.87-.22.4-.56.63-1.13.63-.56 0-.9-.23-1.13-.63A3.87 3.87 0 0 1 11 13.5Z"]));
export const SkipBack15Filled = ( /*#__PURE__*/createFluentIcon('SkipBack15Filled', "1em", ["M3.25 3c.41 0 .75.34.75.75v1.84a8.23 8.23 0 0 1 12.98 1.25.75.75 0 1 1-1.27.8A6.74 6.74 0 0 0 5.21 6.5h2.04a.75.75 0 0 1 0 1.5h-4a.75.75 0 0 1-.75-.75v-3.5c0-.41.34-.75.75-.75Zm11.25 7.75c0 .41-.34.75-.75.75H11.9l-.06.5h.52a2.51 2.51 0 0 1 2.6 2.85 2.5 2.5 0 0 1-4.73.72.75.75 0 1 1 1.35-.64 1.01 1.01 0 0 0 .77.56 1 1 0 1 0 .03-1.99H11a.75.75 0 0 1-.74-.84l.24-2a.75.75 0 0 1 .75-.66h2.5c.41 0 .75.34.75.75Zm-6.93-.68c.26.12.43.39.43.68v5.5a.75.75 0 0 1-1.5 0v-3.87l-.51.44A.75.75 0 0 1 5 11.7l1.76-1.5c.22-.2.53-.24.8-.12Z"]));
export const SkipBack15Regular = ( /*#__PURE__*/createFluentIcon('SkipBack15Regular', "1em", ["M10 4a7 7 0 0 0-5.75 3H7.5a.5.5 0 1 1 0 1h-4a.5.5 0 0 1-.5-.5v-4a.5.5 0 0 1 1 0v2.2a7.98 7.98 0 0 1 13.08 1.57.5.5 0 0 1-.89.46A7 7 0 0 0 10 4Zm4.5 6.5a.5.5 0 0 1-.5.5h-2.3l-.13 1h.93a2.5 2.5 0 1 1-2.17 3.75.5.5 0 0 1 .87-.5A1.5 1.5 0 1 0 12.5 13H11a.5.5 0 0 1-.5-.56l.26-2a.5.5 0 0 1 .5-.44H14c.28 0 .5.22.5.5Zm-6.76-.44a.5.5 0 0 1 .26.44v6a.5.5 0 0 1-1 0v-5.07l-.72.49a.5.5 0 1 1-.56-.84l1.5-1a.5.5 0 0 1 .52-.02Z"]));
export const SkipForward10Filled = ( /*#__PURE__*/createFluentIcon('SkipForward10Filled', "1em", ["M15.73 5.63V3.75a.75.75 0 0 1 1.5 0v3.5c0 .41-.33.75-.75.75h-4a.75.75 0 0 1 0-1.5h2.03a6.3 6.3 0 0 0-4.78-2.25 6.45 6.45 0 0 0-5.65 3.54.83.83 0 0 1-.73.46c-.54 0-.91-.53-.67-1.01a7.93 7.93 0 0 1 7.05-4.49c2.4 0 4.54 1.12 6 2.88ZM12.5 17c1.88 0 2.5-1.57 2.5-3.5s-.62-3.5-2.5-3.5c-1.87 0-2.5 1.57-2.5 3.5s.63 3.5 2.5 3.5Zm.68-1.81a.59.59 0 0 1-.22.22.94.94 0 0 1-.46.09.94.94 0 0 1-.46-.09.59.59 0 0 1-.21-.22 3.38 3.38 0 0 1-.33-1.69c0-.85.15-1.4.32-1.69a.59.59 0 0 1 .22-.22c.07-.04.2-.09.46-.09s.4.05.46.09c.07.04.14.1.22.22.18.3.32.84.32 1.69s-.14 1.4-.32 1.69Zm-4.93-4.44a.75.75 0 0 0-1.24-.57l-1.75 1.5a.75.75 0 1 0 .98 1.14l.51-.44v3.87a.75.75 0 0 0 1.5 0v-5.5Z"]));
export const SkipForward10Regular = ( /*#__PURE__*/createFluentIcon('SkipForward10Regular', "1em", ["M17 3.5a.5.5 0 1 0-1 0v2.2A8 8 0 0 0 2.84 7.45a.5.5 0 1 0 .9.44 7 7 0 0 1 12-.89H12.5a.5.5 0 0 0 0 1h4a.5.5 0 0 0 .5-.5v-4Zm-6.5 7.63c.4-.7 1.07-1.13 2-1.13.94 0 1.6.44 2 1.13.37.65.5 1.5.5 2.37 0 .86-.13 1.72-.5 2.37-.4.7-1.06 1.13-2 1.13-.93 0-1.6-.44-2-1.13-.37-.65-.5-1.5-.5-2.37 0-.86.13-1.72.5-2.37Zm.87.5A3.87 3.87 0 0 0 11 13.5c0 .8.12 1.44.37 1.87.23.4.57.63 1.13.63.57 0 .9-.23 1.13-.63.25-.43.37-1.08.37-1.87 0-.8-.12-1.44-.37-1.87-.23-.4-.56-.63-1.13-.63-.56 0-.9.23-1.13.63ZM8 10.5a.5.5 0 0 0-.78-.42l-1.5 1a.5.5 0 1 0 .56.84l.72-.49v5.07a.5.5 0 0 0 1 0v-6Z"]));
export const SkipForward15Filled = ( /*#__PURE__*/createFluentIcon('SkipForward15Filled', "1em", ["M16.34 3a.75.75 0 0 0-.75.75v1.84A8.23 8.23 0 0 0 2.62 6.84a.75.75 0 1 0 1.26.8 6.74 6.74 0 0 1 10.5-1.14h-2.04a.75.75 0 0 0 0 1.5h4c.42 0 .75-.34.75-.75v-3.5a.75.75 0 0 0-.75-.75Zm-1.84 7.75c0 .41-.34.75-.75.75H11.9l-.06.5h.52a2.5 2.5 0 0 1 2.6 2.85 2.5 2.5 0 0 1-4.73.72.75.75 0 1 1 1.35-.64 1.01 1.01 0 0 0 .77.56 1 1 0 1 0 .03-1.99H11a.75.75 0 0 1-.74-.84l.24-2a.75.75 0 0 1 .75-.66h2.5c.41 0 .75.34.75.75Zm-6.93-.68c.26.12.43.39.43.68v5.5a.75.75 0 0 1-1.5 0v-3.87l-.51.44A.75.75 0 0 1 5 11.7l1.76-1.5c.22-.2.53-.24.8-.12Z"]));
export const SkipForward15Regular = ( /*#__PURE__*/createFluentIcon('SkipForward15Regular', "1em", ["M10.13 4a7 7 0 0 1 5.75 3h-3.25a.5.5 0 0 0 0 1h4a.5.5 0 0 0 .5-.5v-4a.5.5 0 1 0-1 0v2.2A7.98 7.98 0 0 0 3.06 7.28a.5.5 0 1 0 .88.46A7 7 0 0 1 10.14 4Zm4.37 6.5a.5.5 0 0 1-.5.5h-2.3l-.13 1h.93a2.5 2.5 0 1 1-2.17 3.75.5.5 0 1 1 .87-.5A1.5 1.5 0 1 0 12.5 13H11a.5.5 0 0 1-.5-.56l.26-2a.5.5 0 0 1 .5-.44H14c.28 0 .5.22.5.5Zm-6.76-.44a.5.5 0 0 1 .26.44v6a.5.5 0 0 1-1 0v-5.07l-.72.49a.5.5 0 1 1-.56-.84l1.5-1a.5.5 0 0 1 .52-.02Z"]));
export const SkipForward30Filled = ( /*#__PURE__*/createFluentIcon('SkipForward30Filled', "1em", ["M15.73 5.63V3.75a.75.75 0 0 1 1.5 0v3.5c0 .41-.33.75-.75.75h-4a.75.75 0 0 1 0-1.5h2.03a6.3 6.3 0 0 0-4.78-2.25 6.45 6.45 0 0 0-5.65 3.54.83.83 0 0 1-.73.46c-.54 0-.91-.53-.67-1.01a7.93 7.93 0 0 1 7.05-4.49c2.4 0 4.54 1.12 6 2.88ZM4.97 10.72a.75.75 0 0 0 1.06 1.07v-.01l.07-.06a2.3 2.3 0 0 1 1.4-.47c.56 0 .88.15 1.04.3.16.13.22.29.22.43-.01.24-.26.77-1.26.77a.75.75 0 0 0 0 1.5c1 0 1.25.53 1.26.77 0 .14-.06.3-.22.44s-.48.29-1.04.29a2.3 2.3 0 0 1-1.46-.53h-.01a.75.75 0 0 0-1.06 1.06c-.28-.28 0 0 0 0h.01l.01.02a2.03 2.03 0 0 0 .19.16 3.8 3.8 0 0 0 2.33.8c.81-.01 1.5-.24 2-.66a2.05 2.05 0 0 0 .08-3.1 2.05 2.05 0 0 0-.07-3.1 3.05 3.05 0 0 0-2.02-.65 3.8 3.8 0 0 0-2.5.95l-.02.01ZM16 13.5c0 2.07-.62 3.75-2.5 3.75-1.87 0-2.5-1.68-2.5-3.75 0-2.07.63-3.75 2.5-3.75 1.88 0 2.5 1.68 2.5 3.75Zm-1.5 0c0-.93-.15-1.56-.35-1.9a.67.67 0 0 0-.23-.26.8.8 0 0 0-.42-.09.8.8 0 0 0-.42.09.67.67 0 0 0-.23.26c-.2.34-.35.97-.35 1.9 0 .93.15 1.56.35 1.9.09.16.17.23.23.26a.8.8 0 0 0 .42.09.8.8 0 0 0 .42-.09c.07-.03.15-.1.23-.26.2-.34.35-.97.35-1.9Z"]));
export const SkipForward30Regular = ( /*#__PURE__*/createFluentIcon('SkipForward30Regular', "1em", ["M16.5 3c.28 0 .5.22.5.5v4a.5.5 0 0 1-.5.5h-4a.5.5 0 1 1 0-1h3.25a7 7 0 0 0-12.01.89.5.5 0 1 1-.9-.44A8 8 0 0 1 16 5.7V3.5c0-.28.22-.5.5-.5Zm-3 7c-.93 0-1.6.44-2 1.13-.37.65-.5 1.5-.5 2.37 0 .86.13 1.72.5 2.37.4.7 1.07 1.13 2 1.13.94 0 1.6-.44 2-1.13.37-.65.5-1.5.5-2.37 0-.86-.13-1.72-.5-2.37a2.18 2.18 0 0 0-2-1.13ZM12 13.5c0-.8.12-1.44.37-1.87.23-.4.57-.63 1.13-.63.57 0 .9.23 1.13.63.25.43.37 1.08.37 1.87 0 .8-.12 1.44-.37 1.87-.23.4-.56.63-1.13.63-.56 0-.9-.23-1.13-.63A3.87 3.87 0 0 1 12 13.5Zm-6.85-1.9c.19.2.5.2.7 0h.02l.07-.07A2.56 2.56 0 0 1 7.5 11c.6 0 .98.16 1.2.35.22.19.31.42.3.64 0 .4-.4 1.01-1.5 1.01a.5.5 0 0 0 0 1c1.1 0 1.5.6 1.5 1.01a.8.8 0 0 1-.3.64c-.22.19-.6.35-1.2.35a2.56 2.56 0 0 1-1.65-.6.5.5 0 0 0-.7 0c-.34.33 0 .7 0 .7a3.37 3.37 0 0 0 .18.16A3.56 3.56 0 0 0 7.5 17c.78 0 1.4-.21 1.85-.59.44-.37.67-.9.65-1.42a1.89 1.89 0 0 0-.8-1.49c.5-.37.79-.9.8-1.49a1.8 1.8 0 0 0-.65-1.42A2.8 2.8 0 0 0 7.5 10a3.56 3.56 0 0 0-2.34.88v.01h-.01a.5.5 0 0 0 0 .71Zm.7 3.8Z"]));
export const SkipForwardTabFilled = ( /*#__PURE__*/createFluentIcon('SkipForwardTabFilled', "1em", ["M3.09 7.97C4.2 6.57 6.07 4.89 8.35 4.4c1.9-.42 4.25-.04 6.86 2.35H12.5a.75.75 0 1 0 0 1.5H17c.41 0 .75-.34.75-.75v-4a.75.75 0 0 0-1.5 0v2.17c-2.92-2.68-5.75-3.28-8.22-2.74-2.76.6-4.9 2.58-6.12 4.1a.75.75 0 0 0 1.18.94Zm3.41 2.78c-.97 0-1.75.78-1.75 1.75v3c0 .97.78 1.75 1.75 1.75h7c.97 0 1.75-.78 1.75-1.75v-3c0-.97-.78-1.75-1.75-1.75h-7Zm-.25 1.75c0-.14.11-.25.25-.25h7c.14 0 .25.11.25.25v3c0 .14-.11.25-.25.25h-7a.25.25 0 0 1-.25-.25v-3Z"]));
export const SkipForwardTabRegular = ( /*#__PURE__*/createFluentIcon('SkipForwardTabRegular', "1em", ["M2.9 7.81C4.01 6.4 5.92 4.66 8.3 4.15c2.1-.46 4.7.03 7.54 2.85H12.5a.5.5 0 0 0 0 1H17a.5.5 0 0 0 .5-.5v-4a.5.5 0 1 0-1 0v2.75c-3.03-2.97-5.92-3.62-8.42-3.08C5.4 3.76 3.31 5.7 2.11 7.2a.5.5 0 0 0 .78.62ZM6.5 11c-.83 0-1.5.67-1.5 1.5v3c0 .83.67 1.5 1.5 1.5h7c.83 0 1.5-.67 1.5-1.5v-3c0-.83-.67-1.5-1.5-1.5h-7ZM6 12.5c0-.28.22-.5.5-.5h7c.28 0 .5.22.5.5v3a.5.5 0 0 1-.5.5h-7a.5.5 0 0 1-.5-.5v-3Z"]));
export const SlashForwardFilled = ( /*#__PURE__*/createFluentIcon('SlashForwardFilled', "1em", ["M13.02 2.05c.38.15.58.58.43.97l-5.5 14.5a.75.75 0 1 1-1.4-.54l5.5-14.5a.75.75 0 0 1 .97-.43Z"]));
export const SlashForwardRegular = ( /*#__PURE__*/createFluentIcon('SlashForwardRegular', "1em", ["M12.66 2.03c.26.08.4.37.31.63l-5 15a.5.5 0 1 1-.94-.32l5-15a.5.5 0 0 1 .63-.31Z"]));
export const SleepFilled = ( /*#__PURE__*/createFluentIcon('SleepFilled', "1em", ["M11.16 2.74a.5.5 0 0 1 .43-.13c3.5.6 6.4 3.67 6.4 7.4a7.5 7.5 0 0 1-7.5 7.5 7.96 7.96 0 0 1-6.4-3.22.5.5 0 0 1 .37-.79 6.94 6.94 0 0 0 4.69-2.59c1.34-1.65 2.24-4.17 1.85-7.75a.5.5 0 0 1 .16-.42ZM3.5 10C4.33 10 5 9.33 5 8.5V4.9l3-.76V6.1A1.5 1.5 0 1 0 9 7.5v-4a.5.5 0 0 0-.62-.48l-4 1A.5.5 0 0 0 4 4.5v2.59A1.5 1.5 0 1 0 3.5 10Z"]));
export const SleepRegular = ( /*#__PURE__*/createFluentIcon('SleepRegular', "1em", ["M11.59 2.61a.5.5 0 0 0-.59.55c.4 3.58-.5 6.1-1.85 7.75a6.94 6.94 0 0 1-4.69 2.6.5.5 0 0 0-.37.78 7.96 7.96 0 0 0 6.4 3.21A7.5 7.5 0 0 0 18 10c0-3.72-2.9-6.78-6.4-7.39Zm-1.66 8.93c1.43-1.77 2.36-4.34 2.13-7.8A6.65 6.65 0 0 1 17 10a6.5 6.5 0 0 1-6.5 6.5 7.1 7.1 0 0 1-5.06-2.14 8.1 8.1 0 0 0 4.49-2.82ZM3.5 10C4.33 10 5 9.33 5 8.5V4.89l3-.75v1.94A1.5 1.5 0 1 0 9 7.5v-4a.5.5 0 0 0-.62-.49l-4 1A.5.5 0 0 0 4 4.5v2.58A1.5 1.5 0 1 0 3.5 10Z"]));
export const SlideAddFilled = ( /*#__PURE__*/createFluentIcon('SlideAddFilled', "1em", ["M2 6.75A2.75 2.75 0 0 1 4.75 4h10.5A2.75 2.75 0 0 1 18 6.75v3.5A5.5 5.5 0 0 0 9.2 16H4.76A2.75 2.75 0 0 1 2 13.26v-6.5Zm17 7.75a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const SlideAddRegular = ( /*#__PURE__*/createFluentIcon('SlideAddRegular', "1em", ["M2 6.75A2.75 2.75 0 0 1 4.75 4h10.5A2.75 2.75 0 0 1 18 6.75v3.5a5.5 5.5 0 0 0-1-.65V6.75C17 5.78 16.22 5 15.25 5H4.75C3.78 5 3 5.78 3 6.75v6.5c0 .97.78 1.75 1.75 1.75h4.27c.03.34.1.68.19 1H4.75A2.75 2.75 0 0 1 2 13.25v-6.5Zm17 7.75a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const SlideArrowRightFilled = ( /*#__PURE__*/createFluentIcon('SlideArrowRightFilled', "1em", ["M2 6.5A2.5 2.5 0 0 1 4.5 4h11A2.5 2.5 0 0 1 18 6.5v3.76a5.48 5.48 0 0 0-5.8-.76H5.5a.5.5 0 0 0 0 1h5.23c-.46.43-.84.94-1.13 1.5H5.5a.5.5 0 0 0 0 1h3.7a5.5 5.5 0 0 0 0 3H4.5A2.5 2.5 0 0 1 2 13.5v-7Zm3.5.5a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15.35a.5.5 0 0 0 .15-.35.5.5 0 0 0-.15-.35l-2-2a.5.5 0 0 0-.7.7L15.29 14H12.5a.5.5 0 0 0 0 1h2.8l-1.15 1.15a.5.5 0 0 0 .7.7l2-2Z"]));
export const SlideArrowRightRegular = ( /*#__PURE__*/createFluentIcon('SlideArrowRightRegular', "1em", ["M5.5 7a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Zm0 2.5a.5.5 0 0 0 0 1h5.23c.43-.4.93-.75 1.48-1H5.5Zm0 2.5h4.1c-.16.32-.3.65-.4 1H5.5a.5.5 0 0 1 0-1Zm-1 3h4.52c.03.34.1.68.19 1H4.5A2.5 2.5 0 0 1 2 13.5v-7A2.5 2.5 0 0 1 4.5 4h11A2.5 2.5 0 0 1 18 6.5v3.76a5.5 5.5 0 0 0-1-.66V6.5c0-.83-.67-1.5-1.5-1.5h-11C3.67 5 3 5.67 3 6.5v7c0 .83.67 1.5 1.5 1.5Zm14.5-.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15.35a.5.5 0 0 0 .15-.35.5.5 0 0 0-.15-.35l-2-2a.5.5 0 0 0-.7.7L15.29 14H12.5a.5.5 0 0 0 0 1h2.8l-1.15 1.15a.5.5 0 0 0 .7.7l2-2Z"]));
export const SlideContentFilled = ( /*#__PURE__*/createFluentIcon('SlideContentFilled', "1em", ["M15.76 4.01A2.5 2.5 0 0 1 18 6.5v7a2.5 2.5 0 0 1-2.5 2.5h-11A2.5 2.5 0 0 1 2 13.5v-7A2.5 2.5 0 0 1 4.5 4h11l.26.01ZM6 7a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h3a1 1 0 0 0 1-1V8a1 1 0 0 0-1-1H6Zm5.5 5a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3Zm0-2.5a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3Zm0-2.5a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3Z"]));
export const SlideContentRegular = ( /*#__PURE__*/createFluentIcon('SlideContentRegular', "1em", ["M15.76 4.01A2.5 2.5 0 0 1 18 6.5v7a2.5 2.5 0 0 1-2.5 2.5h-11A2.5 2.5 0 0 1 2 13.5v-7A2.5 2.5 0 0 1 4.5 4h11l.26.01ZM4.5 5C3.67 5 3 5.67 3 6.5v7c0 .83.67 1.5 1.5 1.5h11c.83 0 1.5-.67 1.5-1.5v-7A1.5 1.5 0 0 0 15.65 5H4.5ZM9 7a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h3Zm5.5 5a.5.5 0 0 1 0 1h-3a.5.5 0 0 1 0-1h3Zm0-2.5a.5.5 0 0 1 0 1h-3a.5.5 0 0 1 0-1h3Zm0-2.5a.5.5 0 0 1 0 1h-3a.5.5 0 0 1 0-1h3Z"]));
export const SlideEraserFilled = ( /*#__PURE__*/createFluentIcon('SlideEraserFilled', "1em", ["M2 6c0-1.1.9-2 2-2h12a2 2 0 0 1 2 2v5.07l-.4-.41a2.25 2.25 0 0 0-3.2 0l-3.74 3.75A2.24 2.24 0 0 0 10 16H4a2 2 0 0 1-2-2V6Zm13.12 5.37a1.25 1.25 0 0 1 1.76 0l1.75 1.75c.5.48.5 1.28 0 1.76l-2.57 2.58-3.52-3.52 2.58-2.57Zm-3.18 3.17-.57.58a1.25 1.25 0 0 0 0 1.76l1.75 1.75c.48.5 1.28.5 1.76 0l.58-.57-3.52-3.52Z"]));
export const SlideEraserRegular = ( /*#__PURE__*/createFluentIcon('SlideEraserRegular', "1em", ["M4 4a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h6c0-.34.08-.69.23-1H4a1 1 0 0 1-1-1V6a1 1 0 0 1 1-1h12a1 1 0 0 1 1 1v4.23c.21.11.41.25.6.43l.4.41V6a2 2 0 0 0-2-2H4Zm11.12 7.37a1.25 1.25 0 0 1 1.76 0l1.75 1.75c.5.48.5 1.28 0 1.76l-2.57 2.58-3.52-3.52 2.58-2.57Zm-3.18 3.17-.57.58a1.25 1.25 0 0 0 0 1.76l1.75 1.75c.48.5 1.28.5 1.76 0l.58-.57-3.52-3.52Z"]));
export const SlideGridFilled = ( /*#__PURE__*/createFluentIcon('SlideGridFilled', "1em", ["M4 7a1 1 0 0 1 1-1h3.5a1 1 0 0 1 1 1v1.5a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V7Zm1 3.5a1 1 0 0 0-1 1V13a1 1 0 0 0 1 1h3.5a1 1 0 0 0 1-1v-1.5a1 1 0 0 0-1-1H5ZM10.5 7a1 1 0 0 1 1-1H15a1 1 0 0 1 1 1v1.5a1 1 0 0 1-1 1h-3.5a1 1 0 0 1-1-1V7Zm1 3.5a1 1 0 0 0-1 1V13a1 1 0 0 0 1 1H15a1 1 0 0 0 1-1v-1.5a1 1 0 0 0-1-1h-3.5ZM2 6c0-1.1.9-2 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V6Zm2-1a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H4Z"]));
export const SlideGridRegular = ( /*#__PURE__*/createFluentIcon('SlideGridRegular', "1em", ["M5 6a1 1 0 0 0-1 1v1.5a1 1 0 0 0 1 1h3.5a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1H5Zm3.5 1v1.5H5V7h3.5ZM4 11.5a1 1 0 0 1 1-1h3.5a1 1 0 0 1 1 1V13a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1v-1.5Zm1 0V13h3.5v-1.5H5ZM11.5 6H15a1 1 0 0 1 1 1v1.5a1 1 0 0 1-1 1h-3.5a1 1 0 0 1-1-1V7a1 1 0 0 1 1-1ZM15 7h-3.5v1.5H15V7Zm-4.5 4.5a1 1 0 0 1 1-1H15a1 1 0 0 1 1 1V13a1 1 0 0 1-1 1h-3.5a1 1 0 0 1-1-1v-1.5Zm1 0V13H15v-1.5h-3.5ZM2 6c0-1.1.9-2 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V6Zm2-1a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H4Z"]));
export const SlideHideFilled = ( /*#__PURE__*/createFluentIcon('SlideHideFilled', "1em", ["M6 3a4 4 0 0 0-4 4v5c0 1.1.9 2 2 2V8a3 3 0 0 1 3-3h8a2 2 0 0 0-2-2H6Zm0 5a1 1 0 0 1 1-1h.5a.5.5 0 0 0 0-1H7a2 2 0 0 0-2 2v.5a.5.5 0 0 0 1 0V8Zm3.5-2a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1h-1Zm3 0a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1h-1Zm3 0a.5.5 0 0 0 0 1h.5a1 1 0 0 1 1 1v.5a.5.5 0 0 0 1 0V8a2 2 0 0 0-2-2h-.5ZM6 10.5a.5.5 0 0 0-1 0v2a.5.5 0 0 0 1 0v-2Zm12 0a.5.5 0 0 0-1 0v2a.5.5 0 0 0 1 0v-2Zm-12 4a.5.5 0 0 0-1 0v.5c0 1.1.9 2 2 2h.5a.5.5 0 0 0 0-1H7a1 1 0 0 1-1-1v-.5Zm12 0a.5.5 0 0 0-1 0v.5a1 1 0 0 1-1 1h-.5a.5.5 0 0 0 0 1h.5a2 2 0 0 0 2-2v-.5ZM9.5 16a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1h-1Zm3 0a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1h-1Z"]));
export const SlideHideRegular = ( /*#__PURE__*/createFluentIcon('SlideHideRegular', "1em", ["M6 3a4 4 0 0 0-4 4v5c0 1.1.9 2 2 2v-1a1 1 0 0 1-1-1V7a3 3 0 0 1 3-3h7a1 1 0 0 1 1 1h1a2 2 0 0 0-2-2H6Zm0 5a1 1 0 0 1 1-1h.5a.5.5 0 0 0 0-1H7a2 2 0 0 0-2 2v.5a.5.5 0 0 0 1 0V8Zm3.5-2a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1h-1Zm3 0a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1h-1Zm3 0a.5.5 0 0 0 0 1h.5a1 1 0 0 1 1 1v.5a.5.5 0 0 0 1 0V8a2 2 0 0 0-2-2h-.5ZM6 10.5a.5.5 0 0 0-1 0v2a.5.5 0 0 0 1 0v-2Zm12 0a.5.5 0 0 0-1 0v2a.5.5 0 0 0 1 0v-2Zm-12 4a.5.5 0 0 0-1 0v.5c0 1.1.9 2 2 2h.5a.5.5 0 0 0 0-1H7a1 1 0 0 1-1-1v-.5Zm12 0a.5.5 0 0 0-1 0v.5a1 1 0 0 1-1 1h-.5a.5.5 0 0 0 0 1h.5a2 2 0 0 0 2-2v-.5ZM9.5 16a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1h-1Zm3 0a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1h-1Z"]));
export const SlideLayoutFilled = ( /*#__PURE__*/createFluentIcon('SlideLayoutFilled', "1em", ["M5.5 7h9c.28 0 .5.22.5.5V9H5V7.5c0-.28.22-.5.5-.5ZM7 10v3H5.5a.5.5 0 0 1-.5-.5V10h2Zm7.5 3H8v-3h7v2.5a.5.5 0 0 1-.5.5Zm-10-9A2.5 2.5 0 0 0 2 6.5v7A2.5 2.5 0 0 0 4.5 16h11a2.5 2.5 0 0 0 2.5-2.5v-7A2.5 2.5 0 0 0 15.5 4h-11Zm10 10h-9A1.5 1.5 0 0 1 4 12.5v-5C4 6.67 4.67 6 5.5 6h9c.83 0 1.5.67 1.5 1.5v5c0 .83-.67 1.5-1.5 1.5Z"]));
export const SlideLayoutRegular = ( /*#__PURE__*/createFluentIcon('SlideLayoutRegular', "1em", ["M5.5 14A1.5 1.5 0 0 1 4 12.5v-5C4 6.67 4.67 6 5.5 6h9c.83 0 1.5.67 1.5 1.5v5c0 .83-.67 1.5-1.5 1.5h-9Zm0-7a.5.5 0 0 0-.5.5V9h10V7.5a.5.5 0 0 0-.5-.5h-9ZM7 10H5v2.5c0 .28.22.5.5.5H7v-3Zm1 3h6.5a.5.5 0 0 0 .5-.5V10H8v3ZM2 6.5A2.5 2.5 0 0 1 4.5 4h11A2.5 2.5 0 0 1 18 6.5v7a2.5 2.5 0 0 1-2.5 2.5h-11A2.5 2.5 0 0 1 2 13.5v-7ZM4.5 5C3.67 5 3 5.67 3 6.5v7c0 .83.67 1.5 1.5 1.5h11c.83 0 1.5-.67 1.5-1.5v-7c0-.83-.67-1.5-1.5-1.5h-11Z"]));
export const SlideLinkFilled = ( /*#__PURE__*/createFluentIcon('SlideLinkFilled', "1em", ["M2 6c0-1.1.9-2 2-2h12a2 2 0 0 1 2 2v4.84a3.49 3.49 0 0 0-1.5-.34h-4A3.5 3.5 0 0 0 9.63 16H4a2 2 0 0 1-2-2V6Zm10.5 5.5a2.5 2.5 0 0 0 0 5h.5a.5.5 0 0 0 0-1h-.5a1.5 1.5 0 0 1 0-3h.5a.5.5 0 0 0 0-1h-.5Zm3.5 0a.5.5 0 0 0 0 1h.5a1.5 1.5 0 0 1 0 3H16a.5.5 0 0 0 0 1h.5a2.5 2.5 0 0 0 0-5H16ZM12 14c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z"]));
export const SlideLinkRegular = ( /*#__PURE__*/createFluentIcon('SlideLinkRegular', "1em", ["M2 6c0-1.1.9-2 2-2h12a2 2 0 0 1 2 2v4.84a3.47 3.47 0 0 0-1-.3V6a1 1 0 0 0-1-1H4a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h5.14c.11.36.28.7.49 1H4a2 2 0 0 1-2-2V6Zm10.5 5.5a2.5 2.5 0 0 0 0 5h.5a.5.5 0 0 0 0-1h-.5a1.5 1.5 0 0 1 0-3h.5a.5.5 0 0 0 0-1h-.5Zm3.5 0a.5.5 0 0 0 0 1h.5a1.5 1.5 0 0 1 0 3H16a.5.5 0 0 0 0 1h.5a2.5 2.5 0 0 0 0-5H16ZM12 14c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z"]));
export const SlideMicrophoneFilled = ( /*#__PURE__*/createFluentIcon('SlideMicrophoneFilled', "1em", ["M2 6.5A2.5 2.5 0 0 1 4.5 4h11A2.5 2.5 0 0 1 18 6.5v5.47a3 3 0 0 0-6 .03v1.07a1.5 1.5 0 0 0-1.95 1.64c.06.45.19.89.37 1.29H4.5A2.5 2.5 0 0 1 2 13.5v-7Zm3.5.5a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4ZM5 10c0 .28.22.5.5.5H11a.5.5 0 0 0 0-1H5.5a.5.5 0 0 0-.5.5Zm.5 2a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Zm7.5 0a2 2 0 1 1 4 0v2a2 2 0 0 1-4 0v-2Zm-.97 2.43a.5.5 0 1 0-.99.14 4 4 0 0 0 3.46 3.4v.53a.5.5 0 1 0 1 0v-.53a4 4 0 0 0 3.46-3.4.5.5 0 1 0-1-.14 3 3 0 0 1-5.93 0Z"]));
export const SlideMicrophoneRegular = ( /*#__PURE__*/createFluentIcon('SlideMicrophoneRegular', "1em", ["M5.5 7a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Zm0 2.5a.5.5 0 0 0 0 1h6a.5.5 0 0 0 0-1h-6Zm-.5 3c0-.28.22-.5.5-.5H10a.5.5 0 0 1 0 1H5.5a.5.5 0 0 1-.5-.5ZM4.5 4A2.5 2.5 0 0 0 2 6.5v7A2.5 2.5 0 0 0 4.5 16h5.92a4.97 4.97 0 0 1-.32-1H4.5A1.5 1.5 0 0 1 3 13.5v-7C3 5.67 3.67 5 4.5 5h11c.83 0 1.5.67 1.5 1.5v3.26a3 3 0 0 1 1 2.2V6.5A2.5 2.5 0 0 0 15.5 4h-11Zm8.5 8a2 2 0 1 1 4 0v2a2 2 0 0 1-4 0v-2Zm-.97 2.43a.5.5 0 1 0-.99.14 4 4 0 0 0 3.46 3.4v.53a.5.5 0 1 0 1 0v-.53a4 4 0 0 0 3.46-3.4.5.5 0 1 0-1-.14 3 3 0 0 1-5.93 0Z"]));
export const SlideMultipleFilled = ( /*#__PURE__*/createFluentIcon('SlideMultipleFilled', "1em", ["M6 3a4 4 0 0 0-4 4v5c0 1.1.9 2 2 2V8a3 3 0 0 1 3-3h8a2 2 0 0 0-2-2H6Zm1 3a2 2 0 0 0-2 2v7c0 1.1.9 2 2 2h9a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H7Z"]));
export const SlideMultipleRegular = ( /*#__PURE__*/createFluentIcon('SlideMultipleRegular', "1em", ["M6 3a4 4 0 0 0-4 4v5c0 1.1.9 2 2 2v-1a1 1 0 0 1-1-1V7a3 3 0 0 1 3-3h7a1 1 0 0 1 1 1h1a2 2 0 0 0-2-2H6Zm1 3a2 2 0 0 0-2 2v7c0 1.1.9 2 2 2h9a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H7ZM6 8a1 1 0 0 1 1-1h9a1 1 0 0 1 1 1v7a1 1 0 0 1-1 1H7a1 1 0 0 1-1-1V8Z"]));
export const SlideMultipleArrowRightFilled = ( /*#__PURE__*/createFluentIcon('SlideMultipleArrowRightFilled', "1em", ["M6 3a4 4 0 0 0-4 4v5c0 1.1.9 2 2 2V8a3 3 0 0 1 3-3h8a2 2 0 0 0-2-2H6Zm1 3a2 2 0 0 0-2 2v7c0 1.1.9 2 2 2h2.6a5.5 5.5 0 0 1 8.4-6.74V8a2 2 0 0 0-2-2H7Zm7.5 4a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9Zm2.35 4.85a.5.5 0 0 0 .15-.35.5.5 0 0 0-.15-.35l-2-2a.5.5 0 0 0-.7.7L15.29 14H12.5a.5.5 0 0 0 0 1h2.8l-1.15 1.15a.5.5 0 0 0 .7.7l2-2Z"]));
export const SlideMultipleArrowRightRegular = ( /*#__PURE__*/createFluentIcon('SlideMultipleArrowRightRegular', "1em", ["M6 3a4 4 0 0 0-4 4v5c0 1.1.9 2 2 2v-1a1 1 0 0 1-1-1V7a3 3 0 0 1 3-3h7a1 1 0 0 1 1 1h1a2 2 0 0 0-2-2H6Zm1 3a2 2 0 0 0-2 2v7c0 1.1.9 2 2 2h2.6c-.16-.32-.3-.65-.4-1H7a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h9a1 1 0 0 1 1 1v1.6c.36.18.7.4 1 .66V8a2 2 0 0 0-2-2H7Zm7.5 4a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9Zm2.35 4.85a.5.5 0 0 0 .15-.35.5.5 0 0 0-.15-.35l-2-2a.5.5 0 0 0-.7.7L15.29 14H12.5a.5.5 0 0 0 0 1h2.8l-1.15 1.15a.5.5 0 0 0 .7.7l2-2Z"]));
export const SlideMultipleSearchFilled = ( /*#__PURE__*/createFluentIcon('SlideMultipleSearchFilled', "1em", ["M6 3a4 4 0 0 0-4 4v2.76c.58-.4 1.27-.65 2-.73V8a3 3 0 0 1 3-3h8a2 2 0 0 0-2-2H6Zm10 14h-5.88l-1.56-1.56A4.5 4.5 0 0 0 5 9.03V8c0-1.1.9-2 2-2h9a2 2 0 0 1 2 2v7a2 2 0 0 1-2 2ZM4.5 17c.79 0 1.51-.26 2.1-.7l2.55 2.55a.5.5 0 1 0 .7-.7L7.3 15.6A3.5 3.5 0 1 0 4.5 17Zm0-1a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5Z"]));
export const SlideMultipleSearchRegular = ( /*#__PURE__*/createFluentIcon('SlideMultipleSearchRegular', "1em", ["M6 3a4 4 0 0 0-4 4v2.76c.3-.2.64-.38 1-.5V7a3 3 0 0 1 3-3h7a1 1 0 0 1 1 1h1a2 2 0 0 0-2-2H6Zm10 14h-5.88l-1-1H16a1 1 0 0 0 1-1V8a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1v1.26a4.47 4.47 0 0 0-1-.23V8c0-1.1.9-2 2-2h9a2 2 0 0 1 2 2v7a2 2 0 0 1-2 2ZM4.5 17c.79 0 1.51-.26 2.1-.7l2.55 2.55a.5.5 0 1 0 .7-.7L7.3 15.6A3.5 3.5 0 1 0 4.5 17Zm0-1a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5Z"]));
export const SlidePlayFilled = ( /*#__PURE__*/createFluentIcon('SlidePlayFilled', "1em", ["M4.75 4A2.75 2.75 0 0 0 2 6.75v6.5A2.75 2.75 0 0 0 4.75 16h4.46A5.5 5.5 0 0 1 18 10.26V6.75A2.75 2.75 0 0 0 15.25 4H4.75ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM13 16c0 .38.42.62.76.42l2.5-1.5a.5.5 0 0 0 0-.85l-2.5-1.5A.5.5 0 0 0 13 13v3Z"]));
export const SlidePlayRegular = ( /*#__PURE__*/createFluentIcon('SlidePlayRegular', "1em", ["M4.75 4A2.75 2.75 0 0 0 2 6.75v6.5A2.75 2.75 0 0 0 4.75 16h4.46c-.1-.32-.16-.66-.19-1H4.75C3.78 15 3 14.22 3 13.25v-6.5C3 5.78 3.78 5 4.75 5h10.5c.97 0 1.75.78 1.75 1.75V9.6c.36.18.7.4 1 .66V6.75A2.75 2.75 0 0 0 15.25 4H4.75ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM13 16c0 .38.42.62.76.42l2.5-1.5a.5.5 0 0 0 0-.85l-2.5-1.5A.5.5 0 0 0 13 13v3Z"]));
export const SlideRecordFilled = ( /*#__PURE__*/createFluentIcon('SlideRecordFilled', "1em", ["M4.5 4A2.5 2.5 0 0 0 2 6.5v7A2.5 2.5 0 0 0 4.5 16h4.7a5.5 5.5 0 0 1 0-3H5.5a.5.5 0 0 1 0-1h4.1c.29-.56.67-1.07 1.13-1.5H5.5a.5.5 0 0 1 0-1h6.7a5.48 5.48 0 0 1 5.8.76V6.5A2.5 2.5 0 0 0 15.5 4h-11ZM5 7.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5ZM14.5 18a3.5 3.5 0 1 1 0-7 3.5 3.5 0 0 1 0 7Zm0 1a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm0-2a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5Z"]));
export const SlideRecordRegular = ( /*#__PURE__*/createFluentIcon('SlideRecordRegular', "1em", ["M5 7.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5ZM5 10c0-.28.22-.5.5-.5h6.7c-.54.25-1.04.6-1.47 1H5.5A.5.5 0 0 1 5 10Zm4.6 2H5.5a.5.5 0 0 0 0 1h3.7c.1-.35.24-.68.4-1Zm-.58 3H4.5A1.5 1.5 0 0 1 3 13.5v-7C3 5.67 3.67 5 4.5 5h11c.83 0 1.5.67 1.5 1.5v3.1c.36.18.7.4 1 .66V6.5A2.5 2.5 0 0 0 15.5 4h-11A2.5 2.5 0 0 0 2 6.5v7A2.5 2.5 0 0 0 4.5 16h4.7c-.08-.32-.15-.66-.18-1Zm5.48 3a3.5 3.5 0 1 1 0-7 3.5 3.5 0 0 1 0 7Zm0 1a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm0-2a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5Z"]));
export const SlideSearchFilled = ( /*#__PURE__*/createFluentIcon('SlideSearchFilled', "1em", ["M2 6.5A2.5 2.5 0 0 1 4.5 4h11A2.5 2.5 0 0 1 18 6.5v7a2.5 2.5 0 0 1-2.5 2.5h-5.38l-1.56-1.56c.21-.44.36-.93.41-1.44h3.53a.5.5 0 0 0 0-1H8.97a4.47 4.47 0 0 0-.44-1.5h5.97a.5.5 0 0 0 0-1H7.85A4.49 4.49 0 0 0 2 8.76V6.5Zm3.5.5a.5.5 0 0 0 0 1h6a.5.5 0 0 0 0-1h-6Zm-1 9c.79 0 1.51-.26 2.1-.7l2.55 2.55a.5.5 0 1 0 .7-.7L7.3 14.6A3.5 3.5 0 1 0 4.5 16Zm0-1a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5Z"]));
export const SlideSearchRegular = ( /*#__PURE__*/createFluentIcon('SlideSearchRegular', "1em", ["M5.5 7a.5.5 0 0 0 0 1h6a.5.5 0 0 0 0-1h-6Zm3.03 3.5a4.5 4.5 0 0 0-.68-1h6.65a.5.5 0 0 1 0 1H8.53Zm.47 2c0 .17 0 .34-.03.5h3.53a.5.5 0 0 0 0-1H8.97c.02.16.03.33.03.5Zm-6-6v1.76c-.36.12-.7.3-1 .5V6.5A2.5 2.5 0 0 1 4.5 4h11A2.5 2.5 0 0 1 18 6.5v7a2.5 2.5 0 0 1-2.5 2.5h-5.38l-1-1h6.38c.83 0 1.5-.67 1.5-1.5v-7c0-.83-.67-1.5-1.5-1.5h-11C3.67 5 3 5.67 3 6.5ZM4.5 16c.79 0 1.51-.26 2.1-.7l2.55 2.55a.5.5 0 1 0 .7-.7L7.3 14.6A3.5 3.5 0 1 0 4.5 16Zm0-1a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5Z"]));
export const SlideSettingsFilled = ( /*#__PURE__*/createFluentIcon('SlideSettingsFilled', "1em", ["M4.75 4A2.75 2.75 0 0 0 2 6.75v6.5A2.75 2.75 0 0 0 4.75 16h4.46A5.5 5.5 0 0 1 18 10.26V6.75A2.75 2.75 0 0 0 15.25 4H4.75Zm7.32 7.44a2 2 0 0 1-1.44 2.48l-.46.12a4.73 4.73 0 0 0 .01 1.01l.35.09A2 2 0 0 1 12 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.15-.55a2 2 0 0 1 1.43-2.48l.46-.12a4.73 4.73 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 17 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.3.13-.57.3-.82.5l.16.55Zm2.43 4.06a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const SlideSettingsRegular = ( /*#__PURE__*/createFluentIcon('SlideSettingsRegular', "1em", ["M2 6.75A2.75 2.75 0 0 1 4.75 4h10.5A2.75 2.75 0 0 1 18 6.75v3.5a5.5 5.5 0 0 0-1-.65V6.75C17 5.78 16.22 5 15.25 5H4.75C3.78 5 3 5.78 3 6.75v6.5c0 .97.78 1.75 1.75 1.75h4.27c.03.34.1.68.19 1H4.75A2.75 2.75 0 0 1 2 13.25v-6.5Zm10.07 4.7a2 2 0 0 1-1.44 2.47l-.46.12a4.73 4.73 0 0 0 .01 1.01l.35.09A2 2 0 0 1 12 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.15-.55a2 2 0 0 1 1.43-2.48l.46-.12a4.73 4.73 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 17 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.3.13-.57.3-.82.5l.16.55Zm2.43 4.05a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const SlideSizeFilled = ( /*#__PURE__*/createFluentIcon('SlideSizeFilled', "1em", ["M2 6.75A2.75 2.75 0 0 1 4.75 4h10.5A2.75 2.75 0 0 1 18 6.75v6.5A2.75 2.75 0 0 1 15.25 16H4.75A2.75 2.75 0 0 1 2 13.25v-6.5Zm9-.25c0 .28.22.5.5.5h.8l-1.65 1.65a.5.5 0 0 0 .7.7L13 7.71v.79a.5.5 0 0 0 1 0v-2a.5.5 0 0 0-.5-.5h-2a.5.5 0 0 0-.5.5Zm-1.65 4.15a.5.5 0 0 0-.7 0L7 12.29v-.79a.5.5 0 0 0-1 0v2a.5.5 0 0 0 .5.5h2a.5.5 0 0 0 0-1h-.8l1.65-1.65a.5.5 0 0 0 0-.7Z"]));
export const SlideSizeRegular = ( /*#__PURE__*/createFluentIcon('SlideSizeRegular', "1em", ["M2 6.75A2.75 2.75 0 0 1 4.75 4h10.5A2.75 2.75 0 0 1 18 6.75v6.5A2.75 2.75 0 0 1 15.25 16H4.75A2.75 2.75 0 0 1 2 13.25v-6.5ZM4.75 5C3.78 5 3 5.78 3 6.75v6.5c0 .97.78 1.75 1.75 1.75h10.5c.97 0 1.75-.78 1.75-1.75v-6.5C17 5.78 16.22 5 15.25 5H4.75ZM11 6.5c0-.28.22-.5.5-.5h2c.28 0 .5.22.5.5v2a.5.5 0 0 1-1 0v-.8l-1.65 1.65a.5.5 0 0 1-.7-.7L12.29 7h-.79a.5.5 0 0 1-.5-.5Zm-2.35 4.15a.5.5 0 0 1 .7.7L7.71 13h.79a.5.5 0 0 1 0 1h-2a.5.5 0 0 1-.5-.5v-2a.5.5 0 0 1 1 0v.8l1.65-1.65Z"]));
export const SlideTextFilled = ( /*#__PURE__*/createFluentIcon('SlideTextFilled', "1em", ["M2 6.5A2.5 2.5 0 0 1 4.5 4h11A2.5 2.5 0 0 1 18 6.5v7a2.5 2.5 0 0 1-2.5 2.5h-11A2.5 2.5 0 0 1 2 13.5v-7Zm3.5.5a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4ZM5 10c0 .28.22.5.5.5h7a.5.5 0 0 0 0-1h-7a.5.5 0 0 0-.5.5Zm.5 2a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5Z"], { flipInRtl: true }));
export const SlideTextRegular = ( /*#__PURE__*/createFluentIcon('SlideTextRegular', "1em", ["M5.5 7a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Zm0 2.5a.5.5 0 0 0 0 1h7a.5.5 0 0 0 0-1h-7Zm-.5 3c0-.28.22-.5.5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5ZM4.5 4A2.5 2.5 0 0 0 2 6.5v7A2.5 2.5 0 0 0 4.5 16h11a2.5 2.5 0 0 0 2.5-2.5v-7A2.5 2.5 0 0 0 15.5 4h-11ZM3 6.5C3 5.67 3.67 5 4.5 5h11c.83 0 1.5.67 1.5 1.5v7c0 .83-.67 1.5-1.5 1.5h-11A1.5 1.5 0 0 1 3 13.5v-7Z"], { flipInRtl: true }));
export const SlideTextCallFilled = ( /*#__PURE__*/createFluentIcon('SlideTextCallFilled', "1em", ["M2 6.5A2.5 2.5 0 0 1 4.5 4h11A2.5 2.5 0 0 1 18 6.5v.68c-1.19-.5-2.6.07-3.07 1.3l-.28.75c-.28.72-.1 1.53.46 2.07l.51.51c-.1.44-.33.81-.7 1.12l-.8-.18c-.72-.18-1.5.06-2 .62l-.55.61a2.2 2.2 0 0 0-.5 2.02H4.5A2.5 2.5 0 0 1 2 13.5v-7Zm3.5.5a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4ZM5 10c0 .28.22.5.5.5h7a.5.5 0 0 0 0-1h-7a.5.5 0 0 0-.5.5Zm.5 2a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5Zm10.08-2.42.29-.75a1.32 1.32 0 0 1 1.74-.73l.39.17c.47.2.86.57.94 1.06.46 2.73-1.9 6.6-4.63 7.59a1.6 1.6 0 0 1-1.44-.25l-.35-.23c-.6-.41-.7-1.24-.2-1.79l.54-.6c.26-.3.66-.42 1.04-.33l1.22.29c.97-.6 1.5-1.46 1.56-2.56l-.88-.86a.94.94 0 0 1-.22-1Z"]));
export const SlideTextCallRegular = ( /*#__PURE__*/createFluentIcon('SlideTextCallRegular', "1em", ["M5.5 7a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Zm0 2.5a.5.5 0 0 0 0 1h7a.5.5 0 0 0 0-1h-7Zm-.5 3c0-.28.22-.5.5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5ZM4.5 4A2.5 2.5 0 0 0 2 6.5v7A2.5 2.5 0 0 0 4.5 16h6.57a2.19 2.19 0 0 1-.02-1H4.5A1.5 1.5 0 0 1 3 13.5v-7C3 5.67 3.67 5 4.5 5h11c.83 0 1.5.67 1.5 1.5V7c.33-.01.68.05 1 .18V6.5A2.5 2.5 0 0 0 15.5 4h-11Zm11.08 5.58.29-.75a1.32 1.32 0 0 1 1.74-.73l.39.17c.47.2.86.57.94 1.06.46 2.73-1.9 6.6-4.63 7.59a1.6 1.6 0 0 1-1.44-.25l-.35-.23c-.6-.41-.7-1.24-.2-1.79l.54-.6c.26-.3.66-.42 1.04-.33l1.22.29c.97-.6 1.5-1.46 1.56-2.56l-.88-.86a.94.94 0 0 1-.22-1Z"]));
export const SlideTextCursorFilled = ( /*#__PURE__*/createFluentIcon('SlideTextCursorFilled', "1em", ["M2 6.5A2.5 2.5 0 0 1 4.5 4h11A2.5 2.5 0 0 1 18 6.5v6.33l-4.44-4.4A1.5 1.5 0 0 0 11 9.5H5.5a.5.5 0 0 0 0 1H11V16H4.5A2.5 2.5 0 0 1 2 13.5v-7Zm3.5.5a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3Zm0 5a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Zm7.36-2.85a.5.5 0 0 0-.86.35v8a.5.5 0 0 0 .9.3l2-2.65 3.5.78a.5.5 0 0 0 .45-.84l-6-5.94Z"]));
export const SlideTextCursorRegular = ( /*#__PURE__*/createFluentIcon('SlideTextCursorRegular', "1em", ["M5.5 7a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3Zm0 2.5a.5.5 0 0 0 0 1H11v-1H5.5Zm-1 5.5H11v1H4.5A2.5 2.5 0 0 1 2 13.5v-7A2.5 2.5 0 0 1 4.5 4h11A2.5 2.5 0 0 1 18 6.5v6.33l-1-.99V6.5c0-.83-.67-1.5-1.5-1.5h-11C3.67 5 3 5.67 3 6.5v7c0 .83.67 1.5 1.5 1.5Zm.5-2.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm7.86-3.35a.5.5 0 0 0-.86.35v8a.5.5 0 0 0 .9.3l2-2.65 3.5.78a.5.5 0 0 0 .45-.84l-6-5.94Z"]));
export const SlideTextEditFilled = ( /*#__PURE__*/createFluentIcon('SlideTextEditFilled', "1em", ["M2 6.5A2.5 2.5 0 0 1 4.5 4h11A2.5 2.5 0 0 1 18 6.5v2.63a2.87 2.87 0 0 0-2.9.71l-4.83 4.83a3.2 3.2 0 0 0-.8 1.33H4.5A2.5 2.5 0 0 1 2 13.5v-7Zm3.5.5a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4ZM5 10c0 .28.22.5.5.5h7a.5.5 0 0 0 0-1h-7a.5.5 0 0 0-.5.5Zm.5 2a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5Zm5.48 3.38 4.83-4.83a1.87 1.87 0 1 1 2.64 2.64l-4.83 4.83a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.07l.37-1.5c.1-.39.3-.74.58-1.02Z"]));
export const SlideTextEditRegular = ( /*#__PURE__*/createFluentIcon('SlideTextEditRegular', "1em", ["M5.5 7a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Zm0 2.5a.5.5 0 0 0 0 1h7a.5.5 0 0 0 0-1h-7Zm-.5 3c0-.28.22-.5.5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5ZM4.5 4A2.5 2.5 0 0 0 2 6.5v7A2.5 2.5 0 0 0 4.5 16h4.97c.11-.36.29-.7.52-1H4.5A1.5 1.5 0 0 1 3 13.5v-7C3 5.67 3.67 5 4.5 5h11c.83 0 1.5.67 1.5 1.5V9c.34-.01.68.03 1 .13V6.5A2.5 2.5 0 0 0 15.5 4h-11Zm6.48 11.38 4.83-4.83a1.87 1.87 0 1 1 2.64 2.64l-4.83 4.83a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.07l.37-1.5c.1-.39.3-.74.58-1.02Z"]));
export const SlideTextMultipleFilled = ( /*#__PURE__*/createFluentIcon('SlideTextMultipleFilled', "1em", ["M13.5 15a2.5 2.5 0 0 0 2.5-2.5v-7c0-.1 0-.19-.02-.28A2.5 2.5 0 0 0 13.5 3h-9A2.5 2.5 0 0 0 2 5.5v7A2.51 2.51 0 0 0 4.48 15h9.02Zm-8-9h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1 0-1Zm0 2.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1 0-1Zm-.5 3c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5ZM6.5 17a2.5 2.5 0 0 1-2-1h9a3.5 3.5 0 0 0 3.5-3.5v-7c.6.46 1 1.18 1 2v5a4.5 4.5 0 0 1-4.5 4.5h-7Z"]));
export const SlideTextMultipleRegular = ( /*#__PURE__*/createFluentIcon('SlideTextMultipleRegular', "1em", ["M5.5 6a.5.5 0 1 0 0 1h4a.5.5 0 0 0 0-1h-4ZM5 9c0-.28.22-.5.5-.5h7a.5.5 0 0 1 0 1h-7A.5.5 0 0 1 5 9Zm.5 2a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4ZM16 5.5A2.5 2.5 0 0 0 13.5 3h-9A2.5 2.5 0 0 0 2 5.5v7A2.5 2.5 0 0 0 4.5 15h9a2.5 2.5 0 0 0 2.5-2.5v-7Zm-13 7v-7C3 4.67 3.67 4 4.5 4h9c.83 0 1.5.67 1.5 1.5v7c0 .83-.67 1.5-1.5 1.5h-9A1.5 1.5 0 0 1 3 12.5ZM6.5 17a2.5 2.5 0 0 1-2-1h9a3.5 3.5 0 0 0 3.5-3.5v-7c.6.46 1 1.18 1 2v5a4.5 4.5 0 0 1-4.5 4.5h-7Z"]));
export const SlideTextPersonFilled = ( /*#__PURE__*/createFluentIcon('SlideTextPersonFilled', "1em", ["M4.5 4A2.5 2.5 0 0 0 2 6.5v7A2.5 2.5 0 0 0 4.5 16h6.54a2.5 2.5 0 0 1 2.23-2.99 2.99 2.99 0 0 1-.73-2.51H5.5a.5.5 0 0 1 0-1h7a.5.5 0 0 1 .33.13A3 3 0 0 1 18 9.34V6.5A2.5 2.5 0 0 0 15.5 4h-11ZM5 7.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm0 5c0-.28.22-.5.5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5ZM17.5 11a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm1.5 4.5c0 1.25-1 2.5-3.5 2.5S12 16.75 12 15.5c0-.83.67-1.5 1.5-1.5h4c.83 0 1.5.67 1.5 1.5Z"]));
export const SlideTextPersonRegular = ( /*#__PURE__*/createFluentIcon('SlideTextPersonRegular', "1em", ["M5 7.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5ZM5 10c0-.28.22-.5.5-.5h7a.5.5 0 0 1 .33.13c-.14.27-.24.56-.29.87H5.5A.5.5 0 0 1 5 10Zm6.05 5H4.5A1.5 1.5 0 0 1 3 13.5v-7C3 5.67 3.67 5 4.5 5h11c.83 0 1.5.67 1.5 1.5v1.9c.4.23.74.56 1 .94V6.5A2.5 2.5 0 0 0 15.5 4h-11A2.5 2.5 0 0 0 2 6.5v7A2.5 2.5 0 0 0 4.5 16h6.54a3.3 3.3 0 0 1 .01-1ZM5.5 12a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5Zm12-1a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm1.5 4.5c0 1.25-1 2.5-3.5 2.5S12 16.75 12 15.5c0-.83.67-1.5 1.5-1.5h4c.83 0 1.5.67 1.5 1.5Z"]));
export const SlideTextSparkleColor = ( /*#__PURE__*/createFluentIcon('SlideTextSparkleColor', "1em", `<path d="M15.5 3.97h-11A2.5 2.5 0 0 0 2 6.47v7a2.5 2.5 0 0 0 2.5 2.5h11a2.5 2.5 0 0 0 2.5-2.5v-7a2.5 2.5 0 0 0-2.5-2.5Z" fill="#FFF600"/><path d="M15.5 3.97h-11A2.5 2.5 0 0 0 2 6.47v7a2.5 2.5 0 0 0 2.5 2.5h11a2.5 2.5 0 0 0 2.5-2.5v-7a2.5 2.5 0 0 0-2.5-2.5Z" fill="url(#ic_fluent_slide_text_sparkle_20_color__a)"/><path d="M15.5 3.97h-11A2.5 2.5 0 0 0 2 6.47v7a2.5 2.5 0 0 0 2.5 2.5h11a2.5 2.5 0 0 0 2.5-2.5v-7a2.5 2.5 0 0 0-2.5-2.5Z" fill="url(#ic_fluent_slide_text_sparkle_20_color__b)" fill-opacity=".3"/><path d="M15.5 3.97h-11A2.5 2.5 0 0 0 2 6.47v7a2.5 2.5 0 0 0 2.5 2.5h11a2.5 2.5 0 0 0 2.5-2.5v-7a2.5 2.5 0 0 0-2.5-2.5Z" fill="url(#ic_fluent_slide_text_sparkle_20_color__c)" fill-opacity=".3"/><path d="M15.5 3.97h-11A2.5 2.5 0 0 0 2 6.47v7a2.5 2.5 0 0 0 2.5 2.5h11a2.5 2.5 0 0 0 2.5-2.5v-7a2.5 2.5 0 0 0-2.5-2.5Z" fill="url(#ic_fluent_slide_text_sparkle_20_color__d)" fill-opacity=".3"/><path d="M15.5 3.97h-11A2.5 2.5 0 0 0 2 6.47v7a2.5 2.5 0 0 0 2.5 2.5h11a2.5 2.5 0 0 0 2.5-2.5v-7a2.5 2.5 0 0 0-2.5-2.5Z" fill="url(#ic_fluent_slide_text_sparkle_20_color__e)" fill-opacity=".6"/><path d="M15.5 3.97h-11A2.5 2.5 0 0 0 2 6.47v7a2.5 2.5 0 0 0 2.5 2.5h11a2.5 2.5 0 0 0 2.5-2.5v-7a2.5 2.5 0 0 0-2.5-2.5Z" fill="url(#ic_fluent_slide_text_sparkle_20_color__f)" fill-opacity=".4"/><path d="M12.5 9.47h-7a.5.5 0 0 0-.5.5c0 .28.22.5.5.5h7a.5.5 0 0 0 .5-.5.5.5 0 0 0-.5-.5Z" fill="url(#ic_fluent_slide_text_sparkle_20_color__g)"/><path d="M5.5 7.97h4a.5.5 0 0 0 .5-.5.5.5 0 0 0-.5-.5h-4a.5.5 0 0 0-.5.5c0 .28.22.5.5.5Z" fill="url(#ic_fluent_slide_text_sparkle_20_color__h)"/><path d="M10.5 11.97h-5a.5.5 0 0 0-.5.5c0 .28.22.5.5.5h5a.5.5 0 0 0 .5-.5.5.5 0 0 0-.5-.5Z" fill="url(#ic_fluent_slide_text_sparkle_20_color__i)"/><path d="M15.78 5.75c.24-.24.54-.43.86-.53l1.07-.35a.43.43 0 0 0 .28-.39.43.43 0 0 0-.08-.24.37.37 0 0 0-.2-.15h-.02l-1.07-.35a2.18 2.18 0 0 1-1.39-1.39l-.35-1.07a.43.43 0 0 0-.39-.28.43.43 0 0 0-.24.08.37.37 0 0 0-.15.2l-.35 1.07a2.24 2.24 0 0 1-1.37 1.4l-1.07.35a.43.43 0 0 0-.28.39c0 .08.03.17.08.24.05.07.12.13.2.15l1.07.35c.28.09.53.24.75.43l.12.11c.2.2.36.44.47.7l.06.17.35 1.07a.5.5 0 0 0 .13.19l.02.02c.07.05.16.08.24.08.08 0 .17-.03.24-.08a.37.37 0 0 0 .15-.2l.35-1.07c.11-.33.28-.66.52-.9Z" fill="url(#ic_fluent_slide_text_sparkle_20_color__j)"/><path d="M19.94 9.3a.33.33 0 0 0-.15-.11h-.02L19 8.94a1.58 1.58 0 0 1-1-1l-.25-.76a.33.33 0 0 0-.11-.15.27.27 0 0 0-.34 0 .33.33 0 0 0-.11.15l-.25.76c-.08.23-.2.44-.37.61-.17.17-.38.3-.61.38l-.77.25a.33.33 0 0 0-.15.11.27.27 0 0 0 0 .34c.04.05.09.09.15.11l.77.25c.23.08.44.21.62.38.17.17.3.39.38.62l.25.76c.02.06.06.11.11.15a.27.27 0 0 0 .34 0 .33.33 0 0 0 .11-.15l.25-.76c.08-.23.21-.44.38-.62.17-.17.39-.3.62-.38l.77-.25a.33.33 0 0 0 .15-.11.27.27 0 0 0 0-.34v.01Z" fill="url(#ic_fluent_slide_text_sparkle_20_color__k)"/><defs><linearGradient id="ic_fluent_slide_text_sparkle_20_color__a" x1="2.33" y1="15.88" x2="12.86" y2="1.71" gradientUnits="userSpaceOnUse"><stop stop-color="#FC92CB"/><stop offset=".51" stop-color="#DD3CE2"/><stop offset="1" stop-color="#B91CBF"/></linearGradient><linearGradient id="ic_fluent_slide_text_sparkle_20_color__g" x1="12.67" y1="9.97" x2="4" y2="9.97" gradientUnits="userSpaceOnUse"><stop stop-color="#FEE5FF"/><stop offset=".96" stop-color="#F0B6F2"/></linearGradient><linearGradient id="ic_fluent_slide_text_sparkle_20_color__h" x1="9.79" y1="7.47" x2="4.38" y2="7.47" gradientUnits="userSpaceOnUse"><stop stop-color="#FEE5FF"/><stop offset=".96" stop-color="#F0B6F2"/></linearGradient><linearGradient id="ic_fluent_slide_text_sparkle_20_color__i" x1="10.75" y1="12.47" x2="4.25" y2="12.47" gradientUnits="userSpaceOnUse"><stop stop-color="#FEE5FF"/><stop offset=".96" stop-color="#F0B6F2"/></linearGradient><linearGradient id="ic_fluent_slide_text_sparkle_20_color__j" x1="17.86" y1="8.78" x2="12.3" y2="4.33" gradientUnits="userSpaceOnUse"><stop stop-color="#FEE5FF"/><stop offset=".96" stop-color="#F0B6F2"/></linearGradient><linearGradient id="ic_fluent_slide_text_sparkle_20_color__k" x1="23.13" y1="13.94" x2="15.98" y2="7.81" gradientUnits="userSpaceOnUse"><stop stop-color="#FEE5FF"/><stop offset=".96" stop-color="#F0B6F2"/></linearGradient><radialGradient id="ic_fluent_slide_text_sparkle_20_color__b" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(0 .6 -2.46429 0 7.67 7.57)"><stop stop-color="#55107A"/><stop offset="1" stop-color="#55107A" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_slide_text_sparkle_20_color__c" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(0 .9 -4.75179 0 9.33 9.97)"><stop stop-color="#55107A"/><stop offset="1" stop-color="#55107A" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_slide_text_sparkle_20_color__d" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(0 .9 -3.37963 0 8.33 12.37)"><stop stop-color="#55107A"/><stop offset="1" stop-color="#55107A" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_slide_text_sparkle_20_color__e" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(0 2.7 -3.90089 0 14 5.17)"><stop stop-color="#55107A"/><stop offset="1" stop-color="#55107A" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_slide_text_sparkle_20_color__f" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(0 1.8 -2.13477 0 17.33 8.77)"><stop stop-color="#55107A"/><stop offset="1" stop-color="#55107A" stop-opacity="0"/></radialGradient></defs>`, { color: true }));
export const SlideTextSparkleFilled = ( /*#__PURE__*/createFluentIcon('SlideTextSparkleFilled', "1em", ["m14.88 1.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.23 2.23 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Zm4.9 7.93-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02Zm-3.02 3.56c.21.15.47.23.74.23.17 0 .34-.02.5-.08v.58a2.5 2.5 0 0 1-2.5 2.5h-11A2.5 2.5 0 0 1 2 13.5v-7A2.5 2.5 0 0 1 4.5 4h5.59a1.42 1.42 0 0 0 .17 1.32c.17.24.41.43.71.53l1.06.35c.15.05.3.13.47.29.11.11.2.24.3.47l.35 1.1c.1.24.25.47.52.68.14.1.3.17.45.21a1.3 1.3 0 0 0 .77 1.79l.77.25c.08.03.16.08.22.14.07.06.1.14.14.22l.26.8c.1.25.26.46.48.62ZM5 7.5c0 .28.22.5.5.5h4a.5.5 0 0 0 0-1h-4a.5.5 0 0 0-.5.5Zm.5 3h7a.5.5 0 0 0 0-1h-7a.5.5 0 0 0 0 1Zm-.5 2c0 .28.22.5.5.5h5a.5.5 0 0 0 0-1h-5a.5.5 0 0 0-.5.5Z"]));
export const SlideTextSparkleRegular = ( /*#__PURE__*/createFluentIcon('SlideTextSparkleRegular', "1em", ["m14.88 1.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.23 2.23 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Zm4.9 7.93-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02ZM17 12.91c.16.06.33.09.5.09.17 0 .34-.02.5-.08v.58a2.5 2.5 0 0 1-2.5 2.5h-11A2.5 2.5 0 0 1 2 13.5v-7A2.5 2.5 0 0 1 4.5 4h5.59a1.42 1.42 0 0 0 0 1H4.5C3.67 5 3 5.67 3 6.5v7c0 .83.67 1.5 1.5 1.5h11c.83 0 1.5-.67 1.5-1.5v-.6ZM5 7.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5ZM5 10c0-.28.22-.5.5-.5h7a.5.5 0 0 1 0 1h-7A.5.5 0 0 1 5 10Zm.5 2a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5Z"]));
export const SlideTextTitleFilled = ( /*#__PURE__*/createFluentIcon('SlideTextTitleFilled', "1em", ["M4.5 4A2.5 2.5 0 0 0 2 6.5v7A2.5 2.5 0 0 0 4.5 16h11a2.5 2.5 0 0 0 2.5-2.5v-7A2.5 2.5 0 0 0 15.5 4h-11ZM6 7h8a1 1 0 1 1 0 2H6a1 1 0 0 1 0-2Z"]));
export const SlideTextTitleRegular = ( /*#__PURE__*/createFluentIcon('SlideTextTitleRegular', "1em", ["M4.5 4A2.5 2.5 0 0 0 2 6.5v7A2.5 2.5 0 0 0 4.5 16h11a2.5 2.5 0 0 0 2.5-2.5v-7A2.5 2.5 0 0 0 15.5 4h-11ZM3 6.5C3 5.67 3.67 5 4.5 5h11c.83 0 1.5.67 1.5 1.5v7c0 .83-.67 1.5-1.5 1.5h-11A1.5 1.5 0 0 1 3 13.5v-7ZM6 7a1 1 0 0 0 0 2h8a1 1 0 1 0 0-2H6Z"]));
export const SlideTextTitleAddFilled = ( /*#__PURE__*/createFluentIcon('SlideTextTitleAddFilled', "1em", ["M4.5 4A2.5 2.5 0 0 0 2 6.5v7A2.5 2.5 0 0 0 4.5 16h4.7a5.5 5.5 0 0 1 8.8-5.74V6.5A2.5 2.5 0 0 0 15.5 4h-11ZM6 7h8a1 1 0 1 1 0 2H6a1 1 0 0 1 0-2Zm13 7.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const SlideTextTitleAddRegular = ( /*#__PURE__*/createFluentIcon('SlideTextTitleAddRegular', "1em", ["M4.5 4A2.5 2.5 0 0 0 2 6.5v7A2.5 2.5 0 0 0 4.5 16h4.7c-.08-.32-.15-.66-.18-1H4.5A1.5 1.5 0 0 1 3 13.5v-7C3 5.67 3.67 5 4.5 5h11c.83 0 1.5.67 1.5 1.5v3.1c.36.18.7.4 1 .66V6.5A2.5 2.5 0 0 0 15.5 4h-11ZM6 7a1 1 0 0 0 0 2h8a1 1 0 1 0 0-2H6Zm13 7.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const SlideTextTitleCheckmarkFilled = ( /*#__PURE__*/createFluentIcon('SlideTextTitleCheckmarkFilled', "1em", ["M4.5 4A2.5 2.5 0 0 0 2 6.5v7A2.5 2.5 0 0 0 4.5 16h4.7a5.5 5.5 0 0 1 8.8-5.74V6.5A2.5 2.5 0 0 0 15.5 4h-11ZM6 7h8a1 1 0 1 1 0 2H6a1 1 0 0 1 0-2Zm13 7.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-5.15 1.85 3-3a.5.5 0 0 0-.7-.7l-2.65 2.64-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0Z"]));
export const SlideTextTitleCheckmarkRegular = ( /*#__PURE__*/createFluentIcon('SlideTextTitleCheckmarkRegular', "1em", ["M4.5 4A2.5 2.5 0 0 0 2 6.5v7A2.5 2.5 0 0 0 4.5 16h4.7c-.08-.32-.15-.66-.18-1H4.5A1.5 1.5 0 0 1 3 13.5v-7C3 5.67 3.67 5 4.5 5h11c.83 0 1.5.67 1.5 1.5v3.1c.36.18.7.4 1 .66V6.5A2.5 2.5 0 0 0 15.5 4h-11ZM6 7a1 1 0 0 0 0 2h8a1 1 0 1 0 0-2H6Zm13 7.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-5.15 1.85 3-3a.5.5 0 0 0-.7-.7l-2.65 2.64-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0Z"]));
export const SlideTextTitleEditFilled = ( /*#__PURE__*/createFluentIcon('SlideTextTitleEditFilled', "1em", ["M4.5 4A2.5 2.5 0 0 0 2 6.5v7A2.5 2.5 0 0 0 4.5 16h4.98c.15-.5.42-.96.8-1.33l4.82-4.83a2.87 2.87 0 0 1 2.9-.7V6.5A2.5 2.5 0 0 0 15.5 4h-11ZM6 7h8a1 1 0 1 1 0 2H6a1 1 0 0 1 0-2Zm4.98 8.38 4.83-4.83a1.87 1.87 0 1 1 2.64 2.64l-4.83 4.83a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.07l.37-1.5c.1-.39.3-.74.58-1.02Z"]));
export const SlideTextTitleEditRegular = ( /*#__PURE__*/createFluentIcon('SlideTextTitleEditRegular', "1em", ["M4.5 4A2.5 2.5 0 0 0 2 6.5v7A2.5 2.5 0 0 0 4.5 16h4.98c.1-.36.28-.7.5-1H4.5A1.5 1.5 0 0 1 3 13.5v-7C3 5.67 3.67 5 4.5 5h11c.83 0 1.5.67 1.5 1.5V9c.34-.01.68.03 1 .13V6.5A2.5 2.5 0 0 0 15.5 4h-11ZM6 7a1 1 0 0 0 0 2h8a1 1 0 1 0 0-2H6Zm4.98 8.38 4.83-4.83a1.87 1.87 0 1 1 2.64 2.64l-4.83 4.83a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.07l.37-1.5c.1-.39.3-.74.58-1.02Z"]));
export const SlideTopicAddFilled = ( /*#__PURE__*/createFluentIcon('SlideTopicAddFilled', "1em", ["M15.5 11a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9Zm0 2a.5.5 0 0 0-.5.5V15h-1.5a.5.5 0 0 0 0 1H15v1.5a.5.5 0 0 0 1 0V16h1.5a.5.5 0 0 0 0-1H16v-1.5a.5.5 0 0 0-.5-.5ZM15 7a3 3 0 0 1 3 3v.6a5.5 5.5 0 0 0-7.8 6.4H5a3 3 0 0 1-3-3v-4a3 3 0 0 1 3-3h10Zm-9.5 5a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Zm0-2a.5.5 0 0 0 0 1h6a.5.5 0 0 0 0-1h-6Zm11-7a1.5 1.5 0 0 1 0 3h-13a1.5 1.5 0 1 1 0-3h13Z"]));
export const SlideTopicAddRegular = ( /*#__PURE__*/createFluentIcon('SlideTopicAddRegular', "1em", ["M15.5 11a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9Zm0 2a.5.5 0 0 0-.5.5V15h-1.5a.5.5 0 0 0 0 1H15v1.5a.5.5 0 0 0 1 0V16h1.5a.5.5 0 0 0 0-1H16v-1.5a.5.5 0 0 0-.5-.5ZM15 7a3 3 0 0 1 3 3v.6c-.32-.16-.65-.3-1-.4V10a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h5.02c.03.34.1.68.19 1H5a3 3 0 0 1-3-3v-4a3 3 0 0 1 3-3h10Zm-5.5 5a.5.5 0 0 1 0 1h-4a.5.5 0 0 1 0-1h4Zm2-2a.5.5 0 0 1 0 1h-6a.5.5 0 0 1 0-1h6Zm5-7a1.5 1.5 0 0 1 0 3h-13a1.5 1.5 0 1 1 0-3h13Z"]));
export const SlideTransitionFilled = ( /*#__PURE__*/createFluentIcon('SlideTransitionFilled', "1em", ["M2 6.75A2.75 2.75 0 0 1 4.75 4h10.5A2.75 2.75 0 0 1 18 6.75v6.5A2.75 2.75 0 0 1 15.25 16H4.75A2.75 2.75 0 0 1 2 13.25v-6.5ZM6 5H5v10h1V5Zm3 0H8v10h1V5Zm3 0v10h1V5h-1Z"]));
export const SlideTransitionRegular = ( /*#__PURE__*/createFluentIcon('SlideTransitionRegular', "1em", ["M4.75 4A2.75 2.75 0 0 0 2 6.75v6.5A2.75 2.75 0 0 0 4.75 16h10.5A2.75 2.75 0 0 0 18 13.25v-6.5A2.75 2.75 0 0 0 15.25 4H4.75ZM12 5v10H9V5h3Zm1 10V5h2.25c.97 0 1.75.78 1.75 1.75v6.5c0 .97-.78 1.75-1.75 1.75H13Zm-5 0H6V5h2v10ZM5 5v10h-.25C3.78 15 3 14.22 3 13.25v-6.5C3 5.78 3.78 5 4.75 5H5Z"]));
export const SmartwatchFilled = ( /*#__PURE__*/createFluentIcon('SmartwatchFilled', "1em", ["M8 2a2 2 0 0 0-2 2v.17A3 3 0 0 1 7 4h6a3 3 0 0 1 1 .17V4a2 2 0 0 0-2-2H8ZM7 5a2 2 0 0 0-2 2v6c0 1.1.9 2 2 2h6a2 2 0 0 0 2-2v-2a1 1 0 0 0 1-1V9a1 1 0 0 0-1-1V7a2 2 0 0 0-2-2H7Zm0 11a3 3 0 0 1-1-.17V16c0 1.1.9 2 2 2h4a2 2 0 0 0 2-2v-.17a3 3 0 0 1-1 .17H7Z"]));
export const SmartwatchRegular = ( /*#__PURE__*/createFluentIcon('SmartwatchRegular', "1em", ["M6 5.27V4c0-1.1.9-2 2-2h4a2 2 0 0 1 2 2v1.27c.6.34 1 .99 1 1.73v1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1v2a2 2 0 0 1-1 1.73V16a2 2 0 0 1-2 2H8a2 2 0 0 1-2-2v-1.27A2 2 0 0 1 5 13V7a2 2 0 0 1 1-1.73ZM8 3a1 1 0 0 0-1 1v1h6V4a1 1 0 0 0-1-1H8Zm6 10V7a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1Zm-7 3a1 1 0 0 0 1 1h4a1 1 0 0 0 1-1v-1H7v1Z"]));
export const SmartwatchDotFilled = ( /*#__PURE__*/createFluentIcon('SmartwatchDotFilled', "1em", ["M13.5 2.68A2 2 0 0 0 12 2H8a2 2 0 0 0-2 2v.17A3 3 0 0 1 7 4h6.04c.06-.48.23-.92.47-1.32ZM13.05 5H7a2 2 0 0 0-2 2v6c0 1.1.9 2 2 2h6a2 2 0 0 0 2-2v-2a1 1 0 0 0 1-1V9a1 1 0 0 0-1-1v-.34A3.5 3.5 0 0 1 13.04 5ZM7 16a3 3 0 0 1-1-.17V16c0 1.1.9 2 2 2h4a2 2 0 0 0 2-2v-.17a3 3 0 0 1-1 .17H7ZM19 4.5a2.5 2.5 0 1 0-5 0 2.5 2.5 0 0 0 5 0Z"]));
export const SmartwatchDotRegular = ( /*#__PURE__*/createFluentIcon('SmartwatchDotRegular', "1em", ["M16.5 2a2.5 2.5 0 1 1 0 5 2.5 2.5 0 0 1 0-5Zm-3 .68A2 2 0 0 0 12 2H8a2 2 0 0 0-2 2v1.27A2 2 0 0 0 5 7v6a2 2 0 0 0 1 1.73V16c0 1.1.9 2 2 2h4a2 2 0 0 0 2-2v-1.27A2 2 0 0 0 15 13v-2a1 1 0 0 0 1-1V9a1 1 0 0 0-1-1v-.34a3.5 3.5 0 0 1-1-.71A1 1 0 0 1 14 7v6a1 1 0 0 1-1 1H7a1 1 0 0 1-1-1V7a1 1 0 0 1 1-1h6a1 1 0 0 1 .37.07 3.49 3.49 0 0 1 .14-3.39ZM13 4.5V5H7V4a1 1 0 0 1 1-1h4a1 1 0 0 1 1 1v.5ZM7 15h6v1a1 1 0 0 1-1 1H8a1 1 0 0 1-1-1v-1Z"]));
export const SnoozeFilled = ( /*#__PURE__*/createFluentIcon('SnoozeFilled', "1em", ["M10.75 4a.75.75 0 0 0 0 1.5h3.88l-4.45 5.27a.75.75 0 0 0 .57 1.23h5.5a.75.75 0 0 0 0-1.5h-3.88l4.45-5.27A.75.75 0 0 0 16.25 4h-5.5Zm-7 6a.75.75 0 0 0 0 1.5h1.97l-2.56 3.29A.75.75 0 0 0 3.75 16h3.5a.75.75 0 0 0 0-1.5H5.28l2.56-3.29A.75.75 0 0 0 7.25 10h-3.5Z"]));
export const SnoozeRegular = ( /*#__PURE__*/createFluentIcon('SnoozeRegular', "1em", ["M10.5 4a.5.5 0 0 0 0 1h4.03l-4.44 6.2a.5.5 0 0 0 .41.8h5a.5.5 0 0 0 0-1h-4.03l4.44-6.2a.5.5 0 0 0-.41-.8h-5Zm-6 6a.5.5 0 0 0 0 1h2.96l-3.35 4.19a.5.5 0 0 0 .39.81h4a.5.5 0 0 0 0-1H5.54l3.35-4.19A.5.5 0 0 0 8.5 10h-4Z"]));
export const SoundSourceFilled = ( /*#__PURE__*/createFluentIcon('SoundSourceFilled', "1em", ["M3 10a7 7 0 1 1 12.14 4.75l.65.77a8 8 0 1 0-11.58 0l.65-.77A6.97 6.97 0 0 1 3 10Zm11.16 3.6a5.5 5.5 0 1 0-8.32 0l.65-.78a4.5 4.5 0 1 1 7.01 0l.66.78Zm-1.65-1.96a3 3 0 1 0-5.02 0l.69-.81a2 2 0 1 1 3.64 0l.69.81Zm-2.13-.96a.5.5 0 0 0-.76 0l-5.5 6.5a.5.5 0 0 0 .38.82h11a.5.5 0 0 0 .38-.82l-5.5-6.5Z"]));
export const SoundSourceRegular = ( /*#__PURE__*/createFluentIcon('SoundSourceRegular', "1em", ["M3 10a7 7 0 1 1 12.14 4.75l.65.77a8 8 0 1 0-11.58 0l.65-.77A6.97 6.97 0 0 1 3 10Zm11.16 3.6a5.5 5.5 0 1 0-8.32 0l.65-.78a4.5 4.5 0 1 1 7.01 0l.66.78Zm-1.65-1.96a3 3 0 1 0-5.02 0l.69-.81a2 2 0 1 1 3.64 0l.69.81Zm-2.13-.96a.5.5 0 0 0-.76 0l-5.5 6.5a.5.5 0 0 0 .38.82h11a.5.5 0 0 0 .38-.82l-5.5-6.5ZM14.42 17H5.58L10 11.77 14.42 17Z"]));
export const SoundWaveCircleFilled = ( /*#__PURE__*/createFluentIcon('SoundWaveCircleFilled', "1em", ["M18 10a8 8 0 1 1-16 0 8 8 0 0 1 16 0ZM6 8.5a.5.5 0 0 0-.5.5v2a.5.5 0 0 0 1 0V9a.5.5 0 0 0-.5-.5Zm5.5 0a.5.5 0 0 0-1 0v3a.5.5 0 0 0 1 0v-3ZM8.5 7a.5.5 0 0 0-.5.5v5a.5.5 0 0 0 1 0v-5a.5.5 0 0 0-.5-.5Zm5.5.5a.5.5 0 0 0-1 0v5a.5.5 0 0 0 1 0v-5Z"]));
export const SoundWaveCircleRegular = ( /*#__PURE__*/createFluentIcon('SoundWaveCircleRegular', "1em", ["M10 3a7 7 0 1 0 0 14 7 7 0 0 0 0-14Zm-8 7a8 8 0 1 1 16 0 8 8 0 0 1-16 0Zm4-1.5c.28 0 .5.22.5.5v2a.5.5 0 0 1-1 0V9c0-.28.22-.5.5-.5Zm5.5 0a.5.5 0 0 0-1 0v3a.5.5 0 0 0 1 0v-3ZM8.5 7c.28 0 .5.22.5.5v5a.5.5 0 0 1-1 0v-5c0-.28.22-.5.5-.5Zm5.5.5a.5.5 0 0 0-1 0v5a.5.5 0 0 0 1 0v-5Z"]));
export const SoundWaveCircleSparkleFilled = ( /*#__PURE__*/createFluentIcon('SoundWaveCircleSparkleFilled', "1em", ["m14.88.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.23 2.23 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Zm4.9 7.93-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02Zm-3.02 3.56a1.33 1.33 0 0 0 1 .21 8 8 0 1 1-6.6-9.9l-.2.07A1.43 1.43 0 0 0 10 3.5a1.41 1.41 0 0 0 .97 1.35l1.06.35c.15.05.3.13.47.29.11.11.2.24.3.47l.35 1.1.03.06a.5.5 0 0 0-.18.38v5a.5.5 0 0 0 1 0v-4c0 .27.08.54.24.76.16.22.38.38.65.48l.77.25c.08.03.16.08.22.14.07.06.1.14.14.22l.26.8c.1.25.26.46.48.62ZM5.5 9v2a.5.5 0 0 0 1 0V9a.5.5 0 0 0-1 0ZM11 8a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 1 0v-3A.5.5 0 0 0 11 8Zm-3-.5v5a.5.5 0 0 0 1 0v-5a.5.5 0 0 0-1 0Z"]));
export const SoundWaveCircleSparkleRegular = ( /*#__PURE__*/createFluentIcon('SoundWaveCircleSparkleRegular', "1em", ["m14.88.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.23 2.23 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Zm4.9 7.93-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02ZM17.5 12c-.26 0-.52-.08-.73-.22A7 7 0 1 1 10.09 3a1.42 1.42 0 0 1 .86-.85l.22-.07a8 8 0 1 0 6.58 9.9l-.25.02Zm-3.83-4.26c-.24-.19-.4-.4-.5-.62a.5.5 0 0 0-.17.38v5a.5.5 0 0 0 1 0V7.92c-.11-.05-.22-.1-.33-.18ZM6 8.5c.28 0 .5.22.5.5v2a.5.5 0 0 1-1 0V9c0-.28.22-.5.5-.5Zm5.5 0a.5.5 0 0 0-1 0v3a.5.5 0 0 0 1 0v-3ZM8.5 7c.28 0 .5.22.5.5v5a.5.5 0 0 1-1 0v-5c0-.28.22-.5.5-.5Z"]));
export const Space3DFilled = ( /*#__PURE__*/createFluentIcon('Space3DFilled', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v6.5h-.71L14.86 10H16V6a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v4h1.14L3.7 12.5H3V6Zm0 8v-.5h4.34l-.82 2.86-.2.64H6a3 3 0 0 1-3-3Zm4.48 2.64.9-3.14h3.24l.9 3.13.1.37H7.37l.1-.36h.01Zm1.18-4.14h2.68l-.72-2.5H9.38l-.72 2.5Zm4.82 3.86-.82-2.86H17v.5a3 3 0 0 1-3 3h-.35l-.17-.63Zm-1.1-3.86h2.76L13.7 10h-2.05l.72 2.5Zm-7.52 0h2.76l.72-2.5H6.29l-1.43 2.5Z"]));
export const Space3DRegular = ( /*#__PURE__*/createFluentIcon('Space3DRegular', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6Zm13 0a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v3h12V6ZM4 12l1.14-2H4v2Zm.86.5h2.76l.72-2.5H6.29l-1.43 2.5Zm-.86 1v.5c0 1.1.9 2 2 2h.62l.72-2.5H4Zm4.38 0L7.66 16h4.68l-.72-2.5H8.38Zm4.28 0 .72 2.5H14a2 2 0 0 0 2-2v-.5h-3.34Zm2.48-1L13.7 10h-2.05l.72 2.5h2.76Zm-3.8 0-.72-2.5H9.38l-.72 2.5h2.68ZM16 12v-2h-1.14L16 12Z"]));
export const SpacebarFilled = ( /*#__PURE__*/createFluentIcon('SpacebarFilled', "1em", ["M2.75 7.75c.41 0 .75.34.75.75v2h13v-2a.75.75 0 0 1 1.5 0v2c0 .83-.67 1.5-1.5 1.5h-13A1.5 1.5 0 0 1 2 10.5v-2c0-.41.34-.75.75-.75Z"]));
export const SpacebarRegular = ( /*#__PURE__*/createFluentIcon('SpacebarRegular', "1em", ["M2.5 8c.28 0 .5.22.5.5v2c0 .28.22.5.5.5h13a.5.5 0 0 0 .5-.5v-2a.5.5 0 0 1 1 0v2c0 .83-.67 1.5-1.5 1.5h-13A1.5 1.5 0 0 1 2 10.5v-2c0-.28.22-.5.5-.5Z"]));
export const SparkleFilled = ( /*#__PURE__*/createFluentIcon('SparkleFilled', "1em", ["M7.4 12.8a1.04 1.04 0 0 0 1.59-.51l.45-1.37a2.34 2.34 0 0 1 1.47-1.48l1.4-.45A1.04 1.04 0 0 0 12.25 7l-1.37-.45A2.34 2.34 0 0 1 9.4 5.08L8.95 3.7a1.03 1.03 0 0 0-.82-.68 1.04 1.04 0 0 0-1.15.7l-.46 1.4a2.34 2.34 0 0 1-1.44 1.45L3.7 7a1.04 1.04 0 0 0 .02 1.97l1.37.45a2.33 2.33 0 0 1 1.48 1.48l.46 1.4c.07.2.2.37.38.5Zm6.14 4.05a.8.8 0 0 0 1.22-.4l.25-.76a1.09 1.09 0 0 1 .68-.68l.77-.25a.8.8 0 0 0-.02-1.52l-.77-.25a1.08 1.08 0 0 1-.68-.68l-.25-.77a.8.8 0 0 0-1.52.01l-.24.76a1.1 1.1 0 0 1-.67.68l-.77.25a.8.8 0 0 0 0 1.52l.77.25a1.09 1.09 0 0 1 .68.68l.25.77c.06.16.16.3.3.4Z"]));
export const SparkleRegular = ( /*#__PURE__*/createFluentIcon('SparkleRegular', "1em", ["M7.4 12.8a1.04 1.04 0 0 0 1.59-.51l.45-1.37a2.34 2.34 0 0 1 1.47-1.48l1.4-.45A1.04 1.04 0 0 0 12.25 7l-1.37-.45A2.34 2.34 0 0 1 9.4 5.08L8.95 3.7a1.03 1.03 0 0 0-.82-.68 1.04 1.04 0 0 0-1.15.7l-.46 1.4a2.34 2.34 0 0 1-1.44 1.45L3.7 7a1.04 1.04 0 0 0 .02 1.97l1.37.45a2.33 2.33 0 0 1 1.48 1.48l.46 1.4c.07.2.2.37.38.5Zm.08-7.4.53-1.38.44 1.37a3.33 3.33 0 0 0 2.12 2.12l1.4.53-1.38.45a3.34 3.34 0 0 0-2.11 2.11l-.53 1.38-.45-1.38a3.34 3.34 0 0 0-2.1-2.12L4 7.96 5.4 7.5a3.36 3.36 0 0 0 2.08-2.12Zm6.06 11.45a.8.8 0 0 0 1.22-.4l.25-.76a1.09 1.09 0 0 1 .68-.68l.77-.25a.8.8 0 0 0-.02-1.52l-.77-.25a1.08 1.08 0 0 1-.68-.68l-.25-.77a.8.8 0 0 0-1.52.01l-.24.76a1.1 1.1 0 0 1-.67.68l-.77.25a.8.8 0 0 0 0 1.52l.77.25a1.09 1.09 0 0 1 .68.68l.25.77c.06.16.16.3.3.4Zm-.92-2.8-.18-.05.19-.06a2.09 2.09 0 0 0 1.3-1.32l.06-.18.05.18a2.08 2.08 0 0 0 1.32 1.32l.2.06-.18.06a2.08 2.08 0 0 0-1.32 1.32l-.06.18-.06-.18a2.07 2.07 0 0 0-1.32-1.32Z"]));
export const SparkleActionFilled = ( /*#__PURE__*/createFluentIcon('SparkleActionFilled', "1em", ["M9.03 14.42a.75.75 0 0 1 1.05 1.05l-.05.06-2.5 2.5a.75.75 0 0 1-1.06-1.06l2.5-2.5.06-.05Zm-5.25.75a.75.75 0 0 1 1 1.11l-1.5 1.5a.75.75 0 0 1-1.06-1.06l1.5-1.5.06-.05Zm10.9-5.87c.09-.4.64-.4.75-.02l.13.7c.13.77.71 1.38 1.47 1.54l.66.15.06.02c.33.12.32.57.04.71l-.07.03-.71.13c-.77.13-1.37.71-1.54 1.47l-.14.67c-.1.4-.66.4-.76.02l-.13-.7a1.92 1.92 0 0 0-1.47-1.55l-.67-.14c-.4-.1-.4-.7.02-.77l.67-.12a1.92 1.92 0 0 0 1.53-1.47l.15-.67Zm-6.96 1.92a.75.75 0 0 1 1.06 1.06l-2.25 2.25-.06.05a.75.75 0 0 1-1-1.11l2.25-2.25Zm-2-2a.75.75 0 0 1 1.06 1.06l-3.5 3.5a.75.75 0 0 1-1.06-1.06l3.5-3.5Zm4.2-6.75c.14-.63 1.02-.63 1.16 0l.2 1a2.88 2.88 0 0 0 2.26 2.25l1 .2c.6.13.61.97.05 1.14l-1.05.21a2.88 2.88 0 0 0-2.26 2.26l-.2 1-.03.08c-.18.5-.85.5-1.07.08l-.04-.1-.21-1.06a2.88 2.88 0 0 0-2.26-2.26l-1-.2c-.6-.12-.63-.96-.06-1.13l1.05-.22a2.88 2.88 0 0 0 2.26-2.26l.2-1Z"]));
export const SparkleActionRegular = ( /*#__PURE__*/createFluentIcon('SparkleActionRegular', "1em", ["M9.22 14.58a.5.5 0 0 1 .63.77l-2.5 2.5a.5.5 0 0 1-.7-.7l2.5-2.5.07-.07Zm-5.08.57c.2-.2.52-.2.71 0 .2.2.2.5 0 .7l-1.5 1.5-.08.07a.5.5 0 0 1-.62-.78l1.5-1.5ZM14.67 9.3c.1-.4.65-.4.76-.02l.13.7c.13.77.71 1.38 1.47 1.54l.66.15.05.02c.34.12.33.57.05.71l-.07.03-.71.13c-.77.13-1.37.71-1.54 1.47l-.15.67c-.09.4-.65.4-.75.02l-.13-.7a1.92 1.92 0 0 0-1.47-1.55l-.67-.14c-.41-.1-.4-.7.02-.77l.67-.12a1.92 1.92 0 0 0 1.53-1.47l.15-.67Zm-6.53 1.85a.5.5 0 0 1 .71.7l-2.5 2.5a.5.5 0 1 1-.7-.7l2.5-2.5ZM5.72 9.08a.5.5 0 0 1 .7.7l-.07.07-3.5 3.5-.08.07a.5.5 0 0 1-.63-.77l3.5-3.5.08-.07Zm4.2-6.61c.14-.63 1.02-.63 1.16 0l.2 1a2.88 2.88 0 0 0 2.26 2.25l1 .2c.6.13.61.97.05 1.14l-1.05.21a2.88 2.88 0 0 0-2.26 2.26l-.2 1-.03.08c-.18.5-.85.5-1.07.08l-.04-.1-.21-1.06a2.88 2.88 0 0 0-2.26-2.26l-1-.2c-.6-.12-.62-.96-.06-1.13l1.05-.22a2.88 2.88 0 0 0 2.26-2.26l.2-1Z"]));
export const SparkleCircleFilled = ( /*#__PURE__*/createFluentIcon('SparkleCircleFilled', "1em", ["M10 2a8 8 0 1 0 0 16 8 8 0 0 0 0-16ZM8.82 5.58l.26.73c.1.28.33.5.61.6l.73.26a.87.87 0 0 1 0 1.65l-.73.26a1 1 0 0 0-.6.61l-.27.73a.87.87 0 0 1-1.65 0l-.25-.73a1 1 0 0 0-.61-.6l-.73-.27a.88.88 0 0 1 0-1.65l.73-.25a1 1 0 0 0 .6-.61l.26-.73a.87.87 0 0 1 1.65 0ZM11.33 10a.7.7 0 0 1 1.34 0l.18.6c.08.26.29.47.56.55l.6.18a.7.7 0 0 1 0 1.34l-.6.18a.83.83 0 0 0-.56.56l-.18.6a.7.7 0 0 1-1.34 0l-.18-.6a.83.83 0 0 0-.56-.56l-.59-.18a.7.7 0 0 1 0-1.34l.6-.18a.83.83 0 0 0 .55-.56l.18-.6Z"]));
export const SparkleCircleRegular = ( /*#__PURE__*/createFluentIcon('SparkleCircleRegular', "1em", ["M10 3a7 7 0 1 0 0 14 7 7 0 0 0 0-14Zm-8 7a8 8 0 1 1 16 0 8 8 0 0 1-16 0Zm5.17-4.42a.87.87 0 0 1 1.65 0l.26.73c.1.28.33.5.61.6l.73.26a.87.87 0 0 1 0 1.65l-.73.26a1 1 0 0 0-.6.61l-.27.73a.87.87 0 0 1-1.65 0l-.25-.73a1 1 0 0 0-.61-.6l-.73-.27a.88.88 0 0 1 0-1.65l.73-.25a1 1 0 0 0 .6-.61l.26-.73Zm5.5 4.42a.7.7 0 0 0-1.34 0l-.18.6a.83.83 0 0 1-.56.55l-.59.18a.7.7 0 0 0 0 1.34l.6.18c.26.08.47.29.55.56l.18.6a.7.7 0 0 0 1.34 0l.18-.6a.83.83 0 0 1 .56-.56l.6-.18a.7.7 0 0 0 0-1.34l-.6-.18a.83.83 0 0 1-.56-.56l-.18-.59Z"]));
export const SparkleInfoFilled = ( /*#__PURE__*/createFluentIcon('SparkleInfoFilled', "1em", ["M9.98 11.31a5.51 5.51 0 0 0-2.74-2.03 2.37 2.37 0 0 0-1.16-.85l-1.37-.45a1.06 1.06 0 0 1-.7-.83 1.05 1.05 0 0 1 .68-1.14l1.4-.45A2.34 2.34 0 0 0 7.51 4.1l.46-1.4a1.04 1.04 0 0 1 1.97-.02l.46 1.4a2.34 2.34 0 0 0 1.48 1.47l1.37.45a1.06 1.06 0 0 1 .72.83 1.04 1.04 0 0 1-.68 1.15l-1.39.45a2.34 2.34 0 0 0-1.47 1.48l-.45 1.37v.02Zm4.56 4.54a.8.8 0 0 0 1.22-.4l.25-.76a1.09 1.09 0 0 1 .68-.68l.77-.25a.8.8 0 0 0-.02-1.52l-.77-.25a1.08 1.08 0 0 1-.68-.68l-.25-.77a.8.8 0 0 0-1.52.01l-.24.76a1.1 1.1 0 0 1-.67.68l-.77.25a.8.8 0 0 0 0 1.52l.77.25a1.09 1.09 0 0 1 .68.68l.25.77c.06.16.16.3.3.4ZM5.5 11.88a.62.62 0 1 1 0 1.24.62.62 0 0 1 0-1.24Zm0 5.12a.5.5 0 0 1-.5-.5v-2a.5.5 0 0 1 1 0v2a.5.5 0 0 1-.5.5Zm0-7a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9Zm0 8a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7Z"]));
export const SparkleInfoRegular = ( /*#__PURE__*/createFluentIcon('SparkleInfoRegular', "1em", ["m7.2 9.21.04.07c.5.17.96.4 1.39.7L8.5 9.6a3.34 3.34 0 0 0-2.1-2.12L5 6.96 6.4 6.5a3.36 3.36 0 0 0 2.08-2.12l.53-1.37.44 1.37a3.33 3.33 0 0 0 2.12 2.12l1.4.53-1.38.45A3.34 3.34 0 0 0 9.48 9.6l-.3.8c.3.28.57.58.8.91v-.02l.46-1.37a2.34 2.34 0 0 1 1.47-1.48l1.4-.45A1.04 1.04 0 0 0 13.25 6l-1.37-.45a2.33 2.33 0 0 1-1.48-1.48L9.95 2.7a1.03 1.03 0 0 0-.82-.68 1.04 1.04 0 0 0-1.15.7l-.46 1.4a2.34 2.34 0 0 1-1.44 1.45L4.7 6a1.05 1.05 0 0 0 .02 1.97l1.37.45c.44.14.83.42 1.11.78Zm7.34 6.64a.8.8 0 0 0 1.22-.4l.25-.76a1.09 1.09 0 0 1 .68-.68l.77-.25a.8.8 0 0 0-.02-1.52l-.77-.25a1.08 1.08 0 0 1-.68-.68l-.25-.77a.8.8 0 0 0-1.52.01l-.24.76a1.1 1.1 0 0 1-.67.68l-.77.25a.8.8 0 0 0 0 1.52l.77.25a1.09 1.09 0 0 1 .68.68l.25.77c.06.16.16.3.3.4Zm-.92-2.8-.18-.05.19-.06a2.09 2.09 0 0 0 1.3-1.32l.06-.18.05.18a2.08 2.08 0 0 0 1.32 1.32l.2.06-.18.06a2.08 2.08 0 0 0-1.32 1.32l-.06.18-.06-.18a2.07 2.07 0 0 0-1.32-1.32ZM5.5 11.88a.62.62 0 1 1 0 1.25.62.62 0 0 1 0-1.24Zm0 5.13a.5.5 0 0 1-.5-.5v-2a.5.5 0 0 1 1 0v2a.5.5 0 0 1-.5.5Zm0-7a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9Zm0 8a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7Z"]));
export const SpatulaSpoonFilled = ( /*#__PURE__*/createFluentIcon('SpatulaSpoonFilled', "1em", ["m6.4 12-2.8 2.58h-.01a2 2 0 0 0 2.82 2.83h.01l2.68-2.92L7.01 12H6.4Zm6.94-2.03c.32-.2.73-.3 1.2-.37a6.53 6.53 0 0 0 3.44-1.63 3.5 3.5 0 1 0-4.95-4.94 6.53 6.53 0 0 0-1.63 3.44c-.06.47-.19.9-.4 1.23V8l2.34 1.96Zm.16-4.47c.28 0 .5.22.5.5a1 1 0 0 0 1 1 .5.5 0 0 1 0 1 2 2 0 0 1-2-2c0-.28.22-.5.5-.5ZM3.96 2.59a2 2 0 0 1 2.83 0L9.41 5.2A2 2 0 0 1 10 6.62v1.63c0 .14.07.28.18.38l6.07 5.09.02.01a2.5 2.5 0 1 1-3.54 3.54l-.01-.02-5.09-6.07a.5.5 0 0 0-.38-.18H5.62a2 2 0 0 1-1.41-.59L1.59 7.8a2 2 0 0 1 0-2.83L3.96 2.6ZM3.4 6.15a.5.5 0 0 0 0 .7l2 2a.5.5 0 1 0 .7-.7l-2-2a.5.5 0 0 0-.7 0ZM5.85 4.4a.5.5 0 1 0-.7.7l2 2a.5.5 0 1 0 .7-.7l-2-2Z"]));
export const SpatulaSpoonRegular = ( /*#__PURE__*/createFluentIcon('SpatulaSpoonRegular', "1em", ["M6.09 3.3a1 1 0 0 0-1.42 0L2.3 5.66a1 1 0 0 0 0 1.42L4.91 9.7a1 1 0 0 0 .71.29h1.63c.44 0 .86.2 1.15.54l5.05 6.03a1.5 1.5 0 0 0 2.12-2.12L9.54 9.4A1.5 1.5 0 0 1 9 8.25V6.62a1 1 0 0 0-.3-.7L6.1 3.28Zm-2.13-.71a2 2 0 0 1 2.83 0L9.41 5.2A2 2 0 0 1 10 6.62v1.63c0 .12.04.23.12.32l.64-.59c.37-.33.55-.88.64-1.51a6.53 6.53 0 0 1 1.63-3.44 3.5 3.5 0 1 1 4.95 4.94 6.53 6.53 0 0 1-3.45 1.63c-.63.09-1.18.27-1.52.64l-.4.43 3.64 3.05.02.01a2.5 2.5 0 1 1-3.54 3.54l-.01-.02-2.94-3.5-3.36 3.66a2 2 0 0 1-2.83-2.82v-.01l3.85-3.54a.5.5 0 0 0-.2-.04H5.63a2 2 0 0 1-1.41-.59L1.59 7.8a2 2 0 0 1 0-2.83L3.96 2.6Zm7.89 7.44.43-.46a3.45 3.45 0 0 1 2.12-.96 5.54 5.54 0 0 0 2.87-1.34 2.5 2.5 0 0 0-3.54-3.54c-.6.6-1.19 1.79-1.34 2.87-.1.7-.33 1.54-.95 2.12l-.55.5.96.81Zm-3.73 1.74L4.3 15.3A1 1 0 0 0 5.7 16.7l3.44-3.73-1.02-1.21ZM4.35 6.15a.5.5 0 1 0-.7.7L5.4 8.6a.5.5 0 1 0 .7-.7L4.35 6.15Zm.8-1.5c.2-.2.5-.2.7 0L7.6 6.4a.5.5 0 1 1-.7.7L5.15 5.35a.5.5 0 0 1 0-.7ZM14 6a.5.5 0 0 0-1 0c0 1.1.9 2 2 2a.5.5 0 0 0 0-1 1 1 0 0 1-1-1Z"]));
export const Speaker0Filled = ( /*#__PURE__*/createFluentIcon('Speaker0Filled', "1em", ["M12 3a1 1 0 0 0-1.68-.73l-3.87 3.6A.5.5 0 0 1 6.1 6H3.5C2.67 6 2 6.67 2 7.5v5c0 .83.67 1.5 1.5 1.5h2.6a.5.5 0 0 1 .35.13l3.87 3.6a1 1 0 0 0 1.68-.74V3.01Z"]));
export const Speaker0Regular = ( /*#__PURE__*/createFluentIcon('Speaker0Regular', "1em", ["M12 3a1 1 0 0 0-1.68-.73l-3.88 3.6A.5.5 0 0 1 6.1 6H3.5C2.67 6 2 6.67 2 7.5v5c0 .83.67 1.5 1.5 1.5h2.6a.5.5 0 0 1 .34.13l3.88 3.6a1 1 0 0 0 1.68-.74V3.01ZM7.12 6.6 11 3v14l-3.88-3.6A1.5 1.5 0 0 0 6.1 13H3.5a.5.5 0 0 1-.5-.5v-5c0-.28.22-.5.5-.5h2.6c.38 0 .75-.14 1.02-.4Z"]));
export const Speaker1Filled = ( /*#__PURE__*/createFluentIcon('Speaker1Filled', "1em", ["M12 3a1 1 0 0 0-1.68-.73l-3.87 3.6A.5.5 0 0 1 6.1 6H3.5C2.67 6 2 6.67 2 7.5v5c0 .83.67 1.5 1.5 1.5h2.6a.5.5 0 0 1 .35.13l3.87 3.6a1 1 0 0 0 1.68-.74V3.01Zm2.08 9.93a.5.5 0 0 1-.19-.68 4.5 4.5 0 0 0 0-4.5.5.5 0 1 1 .87-.5 5.5 5.5 0 0 1 0 5.5.5.5 0 0 1-.68.18Z"]));
export const Speaker1Regular = ( /*#__PURE__*/createFluentIcon('Speaker1Regular', "1em", ["M12 3a1 1 0 0 0-1.68-.73l-3.88 3.6A.5.5 0 0 1 6.1 6H3.5C2.67 6 2 6.67 2 7.5v5c0 .83.67 1.5 1.5 1.5h2.6a.5.5 0 0 1 .34.13l3.88 3.6a1 1 0 0 0 1.68-.74V3.01ZM7.12 6.6 11 3v14l-3.88-3.6A1.5 1.5 0 0 0 6.1 13H3.5a.5.5 0 0 1-.5-.5v-5c0-.28.22-.5.5-.5h2.6c.38 0 .75-.14 1.02-.4Zm6.96 6.33a.5.5 0 0 1-.18-.68 4.5 4.5 0 0 0 0-4.5.5.5 0 1 1 .86-.5 5.5 5.5 0 0 1 0 5.5.5.5 0 0 1-.68.18Z"]));
export const Speaker2Filled = ( /*#__PURE__*/createFluentIcon('Speaker2Filled', "1em", ["M12 3a1 1 0 0 0-1.68-.73l-3.87 3.6A.5.5 0 0 1 6.1 6H3.5C2.67 6 2 6.67 2 7.5v5c0 .83.67 1.5 1.5 1.5h2.6a.5.5 0 0 1 .35.13l3.87 3.6a1 1 0 0 0 1.68-.74V3.01Zm3.25 1.63a.5.5 0 0 1 .71.04 8 8 0 0 1 0 10.66.5.5 0 1 1-.75-.66 7 7 0 0 0 0-9.34.5.5 0 0 1 .04-.7Zm-1.17 8.3a.5.5 0 0 1-.19-.68 4.5 4.5 0 0 0 0-4.5.5.5 0 1 1 .87-.5 5.5 5.5 0 0 1 0 5.5.5.5 0 0 1-.68.18Z"]));
export const Speaker2Regular = ( /*#__PURE__*/createFluentIcon('Speaker2Regular', "1em", ["M12 3a1 1 0 0 0-1.68-.73l-3.88 3.6A.5.5 0 0 1 6.1 6H3.5C2.67 6 2 6.67 2 7.5v5c0 .83.67 1.5 1.5 1.5h2.6a.5.5 0 0 1 .34.13l3.88 3.6a1 1 0 0 0 1.68-.74V3.01ZM7.12 6.6 11 3v14l-3.88-3.6A1.5 1.5 0 0 0 6.1 13H3.5a.5.5 0 0 1-.5-.5v-5c0-.28.22-.5.5-.5h2.6c.38 0 .75-.14 1.02-.4Zm8.14-1.97a.5.5 0 0 1 .7.04 8 8 0 0 1 0 10.66.5.5 0 0 1-.74-.66 7 7 0 0 0 0-9.34.5.5 0 0 1 .04-.7Zm-1.18 8.3a.5.5 0 0 1-.18-.68 4.5 4.5 0 0 0 0-4.5.5.5 0 1 1 .86-.5 5.5 5.5 0 0 1 0 5.5.5.5 0 0 1-.68.18Z"]));
export const SpeakerBluetoothFilled = ( /*#__PURE__*/createFluentIcon('SpeakerBluetoothFilled', "1em", ["M10.32 2.27a1 1 0 0 1 1.68.74v13.98a1 1 0 0 1-1.68.74l-3.87-3.6A.5.5 0 0 0 6.1 14H3.5A1.5 1.5 0 0 1 2 12.5v-5C2 6.67 2.67 6 3.5 6h2.6a.5.5 0 0 0 .35-.13l3.87-3.6Zm5.53 2.88a.5.5 0 0 0-.85.35v3.46l-1.19-.95a.5.5 0 1 0-.62.78L14.7 10l-1.51 1.21a.5.5 0 1 0 .62.78l1.19-.95v3.46a.5.5 0 0 0 .85.35l2.5-2.5a.5.5 0 0 0-.04-.74L16.3 10l2.01-1.61a.5.5 0 0 0 .04-.74l-2.5-2.5Zm1.4 6.9L16 13.28v-2.25l1.25 1ZM16 6.7l1.25 1.25-1.25 1V6.71Z"]));
export const SpeakerBluetoothRegular = ( /*#__PURE__*/createFluentIcon('SpeakerBluetoothRegular', "1em", ["M10.32 2.27a1 1 0 0 1 1.68.74v13.98a1 1 0 0 1-1.68.74l-3.88-3.6A.5.5 0 0 0 6.1 14H3.5A1.5 1.5 0 0 1 2 12.5v-5C2 6.67 2.67 6 3.5 6h2.6a.5.5 0 0 0 .34-.13l3.88-3.6Zm.68.74L7.12 6.6c-.27.26-.64.4-1.02.4H3.5a.5.5 0 0 0-.5.5v5c0 .28.22.5.5.5h2.6c.38 0 .75.14 1.02.4L11 17V3Zm4.85 2.14a.5.5 0 0 0-.85.35v3.46l-1.19-.95a.5.5 0 1 0-.62.78L14.7 10l-1.51 1.21a.5.5 0 1 0 .62.78l1.19-.95v3.46a.5.5 0 0 0 .85.35l2.5-2.5a.5.5 0 0 0-.04-.74L16.3 10l2.01-1.61a.5.5 0 0 0 .04-.74l-2.5-2.5Zm1.4 6.9L16 13.28v-2.25l1.25 1ZM16 6.7l1.25 1.25-1.25 1V6.71Z"]));
export const SpeakerBoxFilled = ( /*#__PURE__*/createFluentIcon('SpeakerBoxFilled', "1em", ["M4 5a3 3 0 0 1 3-3h6a3 3 0 0 1 3 3v10a3 3 0 0 1-3 3H7a3 3 0 0 1-3-3V5Zm6 5a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm-3 2a3 3 0 1 0 6 0 3 3 0 0 0-6 0Zm3-5a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"]));
export const SpeakerBoxRegular = ( /*#__PURE__*/createFluentIcon('SpeakerBoxRegular', "1em", ["M4 5a3 3 0 0 1 3-3h6a3 3 0 0 1 3 3v10a3 3 0 0 1-3 3H7a3 3 0 0 1-3-3V5Zm3-2a2 2 0 0 0-2 2v10c0 1.1.9 2 2 2h6a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2H7Zm3 7a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm-3 2a3 3 0 1 1 6 0 3 3 0 0 1-6 0Zm3-5a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"]));
export const SpeakerEditFilled = ( /*#__PURE__*/createFluentIcon('SpeakerEditFilled', "1em", ["M12 3a1 1 0 0 0-1.68-.73l-3.87 3.6A.5.5 0 0 1 6.1 6H3.5C2.67 6 2 6.67 2 7.5v5c0 .83.67 1.5 1.5 1.5h2.6a.5.5 0 0 1 .35.13l2.83 2.63.15-.6a3.2 3.2 0 0 1 .84-1.5L12 12.95V3Zm3.96 1.66a7.97 7.97 0 0 1 1.99 4.46c-.34-.1-.68-.14-1.02-.12a6.97 6.97 0 0 0-1.72-3.67.5.5 0 0 1 .75-.67Zm-1.2 2.59c.41.72.65 1.5.72 2.27-.14.1-.26.2-.38.32l-.63.63c.1-.92-.08-1.87-.58-2.72a.5.5 0 0 1 .87-.5Zm-3.78 8.12 4.83-4.83a1.87 1.87 0 1 1 2.64 2.65l-4.83 4.83a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.08l.37-1.5c.1-.38.3-.73.58-1.02Z"]));
export const SpeakerEditRegular = ( /*#__PURE__*/createFluentIcon('SpeakerEditRegular', "1em", ["M12 3a1 1 0 0 0-1.68-.73l-3.87 3.6A.5.5 0 0 1 6.1 6H3.5C2.67 6 2 6.67 2 7.5v5c0 .83.67 1.5 1.5 1.5h2.6a.5.5 0 0 1 .35.13l2.83 2.63.15-.6c.04-.17.1-.32.16-.48L7.13 13.4A1.5 1.5 0 0 0 6.1 13H3.5a.5.5 0 0 1-.5-.5v-5c0-.28.22-.5.5-.5h2.6c.38 0 .75-.15 1.03-.4L11 3v10.94l1-1V3Zm3.96 1.66a7.97 7.97 0 0 1 1.99 4.46c-.33-.1-.68-.14-1.02-.12a6.97 6.97 0 0 0-1.71-3.67.5.5 0 0 1 .74-.67Zm-1.2 2.59c.42.72.65 1.5.72 2.27-.13.1-.26.2-.38.32l-.62.62c.1-.9-.09-1.86-.58-2.71a.5.5 0 0 1 .86-.5Zm-3.78 8.12 4.83-4.83a1.87 1.87 0 1 1 2.64 2.65l-4.83 4.83a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.08l.37-1.5c.1-.38.3-.73.58-1.02Z"]));
export const SpeakerMuteFilled = ( /*#__PURE__*/createFluentIcon('SpeakerMuteFilled', "1em", ["M12 3a1 1 0 0 0-1.68-.73l-3.88 3.6A.5.5 0 0 1 6.1 6H3.5C2.67 6 2 6.67 2 7.5v5c0 .83.67 1.5 1.5 1.5h2.6a.5.5 0 0 1 .34.13l3.88 3.6a1 1 0 0 0 1.68-.74V3.01Zm1.14 4.65c.2-.2.51-.2.71 0l1.65 1.64 1.64-1.64a.5.5 0 1 1 .71.7L16.2 10l1.65 1.65a.5.5 0 1 1-.7.7l-1.65-1.64-1.65 1.64a.5.5 0 1 1-.7-.7L14.78 10l-1.65-1.65a.5.5 0 0 1 0-.7Z"]));
export const SpeakerMuteRegular = ( /*#__PURE__*/createFluentIcon('SpeakerMuteRegular', "1em", ["M12 3a1 1 0 0 0-1.68-.73l-3.88 3.6A.5.5 0 0 1 6.1 6H3.5C2.67 6 2 6.67 2 7.5v5c0 .83.67 1.5 1.5 1.5h2.6a.5.5 0 0 1 .34.13l3.88 3.6a1 1 0 0 0 1.68-.74V3.01ZM7.12 6.6 11 3v14l-3.88-3.6A1.5 1.5 0 0 0 6.1 13H3.5a.5.5 0 0 1-.5-.5v-5c0-.28.22-.5.5-.5h2.6c.38 0 .75-.14 1.02-.4Zm6.02 1.05c.2-.2.51-.2.71 0l1.65 1.64 1.64-1.64a.5.5 0 1 1 .71.7L16.2 10l1.65 1.65a.5.5 0 1 1-.7.7l-1.65-1.64-1.65 1.64a.5.5 0 1 1-.7-.7L14.78 10l-1.65-1.65a.5.5 0 0 1 0-.7Z"]));
export const SpeakerOffFilled = ( /*#__PURE__*/createFluentIcon('SpeakerOffFilled', "1em", ["M2.85 2.15a.5.5 0 1 0-.7.7L5.29 6H3.5C2.67 6 2 6.67 2 7.5v5c0 .83.67 1.5 1.5 1.5h2.6a.5.5 0 0 1 .35.13l3.87 3.6a1 1 0 0 0 1.68-.74v-4.28l5.15 5.14a.5.5 0 0 0 .7-.7l-2.56-2.57L2.85 2.15Zm13.11 2.52a8 8 0 0 1 .66 9.83l-.73-.73a7 7 0 0 0-.68-8.44.5.5 0 1 1 .75-.66Zm-1.2 2.58c1 1.74.95 3.8.04 5.43l-.74-.74a4.5 4.5 0 0 0-.17-4.19.5.5 0 1 1 .87-.5ZM12 3.01v6.87L7.25 5.13l3.07-2.86a1 1 0 0 1 1.68.74Z"]));
export const SpeakerOffRegular = ( /*#__PURE__*/createFluentIcon('SpeakerOffRegular', "1em", ["M2.85 2.15a.5.5 0 1 0-.7.7L5.29 6H3.5C2.68 6 2 6.67 2 7.5v5c0 .83.68 1.5 1.5 1.5H6.1a.5.5 0 0 1 .34.13l3.88 3.6a1 1 0 0 0 1.68-.74V12.7l5.15 5.15a.5.5 0 0 0 .7-.7l-2.56-2.57L2.85 2.15ZM11 11.7V17l-3.88-3.6A1.5 1.5 0 0 0 6.1 13H3.5a.5.5 0 0 1-.5-.5v-5c0-.28.22-.5.5-.5h2.6l.18-.01L11 11.7ZM11 3v5.88l1 1V3a1 1 0 0 0-1.68-.74L7.24 5.12l.71.71L11 3.01Zm3.06 8.94.74.74a5.5 5.5 0 0 0-.04-5.43.5.5 0 1 0-.86.5 4.5 4.5 0 0 1 .16 4.19Zm1.84 1.84.72.72a8 8 0 0 0-.66-9.83.5.5 0 1 0-.74.66 7 7 0 0 1 .68 8.45Z"]));
export const SpeakerSettingsFilled = ( /*#__PURE__*/createFluentIcon('SpeakerSettingsFilled', "1em", ["M12 3a1 1 0 0 0-1.68-.73l-3.87 3.6A.5.5 0 0 1 6.1 6H3.5C2.67 6 2 6.67 2 7.5v5c0 .83.67 1.5 1.5 1.5h2.6a.5.5 0 0 1 .35.13l3.21 2.98A5.48 5.48 0 0 1 12 9.6V3Zm.07 8.44-.16-.55c.25-.2.53-.37.82-.5l.34.36a2 2 0 0 0 2.9 0l.33-.35c.3.14.58.32.84.52l-.13.42a2 2 0 0 0 1.46 2.52l.35.09a4.7 4.7 0 0 1 0 1.01l-.45.12a2 2 0 0 0-1.43 2.48l.15.55c-.25.2-.53.37-.82.5l-.34-.36a2 2 0 0 0-2.9 0l-.33.35c-.3-.14-.58-.32-.84-.52l.13-.42a2 2 0 0 0-1.46-2.52l-.35-.09a4.71 4.71 0 0 1 0-1.01l.45-.12a2 2 0 0 0 1.44-2.48Zm2.43 4.06a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"]));
export const SpeakerSettingsRegular = ( /*#__PURE__*/createFluentIcon('SpeakerSettingsRegular', "1em", ["M12 3a1 1 0 0 0-1.68-.73l-3.88 3.6A.5.5 0 0 1 6.1 6H3.5C2.67 6 2 6.67 2 7.5v5c0 .83.67 1.5 1.5 1.5h2.6a.5.5 0 0 1 .34.13l3.22 2.99a5.46 5.46 0 0 1-.62-1.94L7.12 13.4A1.5 1.5 0 0 0 6.1 13H3.5a.5.5 0 0 1-.5-.5v-5c0-.28.22-.5.5-.5h2.6c.38 0 .75-.14 1.02-.4L11 3v7.26c.3-.25.64-.48 1-.66V3Zm.06 8.44a2 2 0 0 1-1.43 2.48l-.46.12a4.7 4.7 0 0 0 .01 1.01l.35.09A2 2 0 0 1 12 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.16-.55a2 2 0 0 1 1.43-2.48l.47-.12a4.7 4.7 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 17 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.3.13-.57.3-.82.5l.15.55Zm2.44 4.06a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const SpeakerUsbFilled = ( /*#__PURE__*/createFluentIcon('SpeakerUsbFilled', "1em", ["M10.32 2.27a1 1 0 0 1 1.68.74v13.98a1 1 0 0 1-1.68.74l-3.87-3.6A.5.5 0 0 0 6.1 14H3.5A1.5 1.5 0 0 1 2 12.5v-5C2 6.67 2.67 6 3.5 6h2.6a.5.5 0 0 0 .35-.13l3.87-3.6ZM14 8V6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v2a1 1 0 0 1 1 1v2.2a1 1 0 0 1-.2.6l-1.3 1.8V15a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1v-1.4l-1.31-1.84a1 1 0 0 1-.19-.58V9a1 1 0 0 1 1-1Zm1 0h2V6h-2v2Z"]));
export const SpeakerUsbRegular = ( /*#__PURE__*/createFluentIcon('SpeakerUsbRegular', "1em", ["M10.32 2.27a1 1 0 0 1 1.68.74v13.98a1 1 0 0 1-1.68.74l-3.88-3.6A.5.5 0 0 0 6.1 14H3.5A1.5 1.5 0 0 1 2 12.5v-5C2 6.67 2.67 6 3.5 6h2.6a.5.5 0 0 0 .34-.13l3.88-3.6Zm.68.74L7.12 6.6c-.27.26-.64.4-1.02.4H3.5a.5.5 0 0 0-.5.5v5c0 .28.22.5.5.5h2.6c.38 0 .75.14 1.02.4L11 17V3ZM14 8V6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v2a1 1 0 0 1 1 1v2.2a1 1 0 0 1-.2.6l-1.3 1.8V15a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1v-1.4l-1.31-1.84a1 1 0 0 1-.19-.58V9a1 1 0 0 1 1-1Zm1 0h2V6h-2v2Z"]));
export const SpinnerIosFilled = ( /*#__PURE__*/createFluentIcon('SpinnerIosFilled', "1em", ["M10 3.5A6.5 6.5 0 0 0 3.5 10 .75.75 0 0 1 2 10a8 8 0 1 1 8 8 .75.75 0 0 1 0-1.5 6.5 6.5 0 1 0 0-13Z"]));
export const SpinnerIosRegular = ( /*#__PURE__*/createFluentIcon('SpinnerIosRegular', "1em", ["M10 3a7 7 0 0 0-7 7 .5.5 0 0 1-1 0 8 8 0 1 1 8 8 .5.5 0 0 1 0-1 7 7 0 1 0 0-14Z"]));
export const SplitHintFilled = ( /*#__PURE__*/createFluentIcon('SplitHintFilled', "1em", ["M9.5 2c.28 0 .5.22.5.5v15a.5.5 0 0 1-1 0v-15c0-.28.22-.5.5-.5ZM4 4a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h4V4H4Zm11 1a1 1 0 0 1 1 1v.5a.5.5 0 0 0 1 0V6a2 2 0 0 0-2-2h-.5a.5.5 0 0 0 0 1h.5Zm0 10a1 1 0 0 0 1-1v-.5a.5.5 0 0 1 1 0v.5a2 2 0 0 1-2 2h-.5a.5.5 0 0 1 0-1h.5Zm1.5-7a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 1 0v-3a.5.5 0 0 0-.5-.5Zm-4-4a.5.5 0 0 1 0 1h-1a.5.5 0 0 1 0-1h1Zm.5 11.5a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 .5-.5Z"]));
export const SplitHintRegular = ( /*#__PURE__*/createFluentIcon('SplitHintRegular', "1em", ["M9.5 2c.28 0 .5.22.5.5v15a.5.5 0 0 1-1 0v-15c0-.28.22-.5.5-.5ZM2 6c0-1.1.9-2 2-2h4v1H4a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h4v1H4a2 2 0 0 1-2-2V6Zm13-1a1 1 0 0 1 1 1v.5a.5.5 0 0 0 1 0V6a2 2 0 0 0-2-2h-.5a.5.5 0 0 0 0 1h.5Zm0 10a1 1 0 0 0 1-1v-.5a.5.5 0 0 1 1 0v.5a2 2 0 0 1-2 2h-.5a.5.5 0 0 1 0-1h.5Zm1.5-7a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 1 0v-3a.5.5 0 0 0-.5-.5Zm-4-4a.5.5 0 0 1 0 1h-1a.5.5 0 0 1 0-1h1Zm.5 11.5a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 .5-.5Z"]));
export const SplitHorizontalFilled = ( /*#__PURE__*/createFluentIcon('SplitHorizontalFilled', "1em", ["M17.5 10a.5.5 0 0 0 0-1h-15a.5.5 0 0 0 0 1h15ZM14 2a2 2 0 0 1 2 2v4H4V4c0-1.1.9-2 2-2h8ZM4 11v4c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2v-4H4Z"]));
export const SplitHorizontalRegular = ( /*#__PURE__*/createFluentIcon('SplitHorizontalRegular', "1em", ["M17.5 10a.5.5 0 0 0 0-1h-15a.5.5 0 0 0 0 1h15ZM16 4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v4h1V4a1 1 0 0 1 1-1h8a1 1 0 0 1 1 1v4h1V4Zm0 7h-1v4a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1v-4H4v4c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2v-4Z"]));
export const SplitVerticalFilled = ( /*#__PURE__*/createFluentIcon('SplitVerticalFilled', "1em", ["M10 2.5a.5.5 0 0 0-1 0v15a.5.5 0 0 0 1 0v-15ZM2 6c0-1.1.9-2 2-2h4v12H4a2 2 0 0 1-2-2V6Zm9 10h4a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2h-4v12Z"]));
export const SplitVerticalRegular = ( /*#__PURE__*/createFluentIcon('SplitVerticalRegular', "1em", ["M10 2.5a.5.5 0 0 0-1 0v15a.5.5 0 0 0 1 0v-15ZM4 4a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h4v-1H4a1 1 0 0 1-1-1V6a1 1 0 0 1 1-1h4V4H4Zm7 0v1h4a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1h-4v1h4a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2h-4Z"]));
export const SportColor = ( /*#__PURE__*/createFluentIcon('SportColor', "1em", `<circle cx="12" cy="8" r="6" fill="url(#ic_fluent_sport_20_color__a)"/><circle cx="12" cy="8" r="6" fill="url(#ic_fluent_sport_20_color__b)" fill-opacity=".8"/><path opacity=".6" d="M14.59 2.58a2 2 0 0 0-.31 2.44l1.6-1.6c.25.21.49.45.7.7l-1.6 1.6a1.99 1.99 0 0 0 2.44-.3c.15.31.27.64.37.99a2.99 2.99 0 0 1-3.53.04L12.71 8l3.87 3.87c-.21.26-.45.5-.7.71L12 8.71l-3.87 3.87c-.26-.21-.5-.45-.71-.7L11.29 8 7.42 4.13c.21-.26.45-.5.7-.71L12 7.29l1.55-1.55a2.99 2.99 0 0 1 .04-3.53c.35.1.68.22 1 .37Z" fill="url(#ic_fluent_sport_20_color__c)"/><path d="M2 8.5C2 7.67 2.67 7 3.5 7H5a8 8 0 0 1 8 8v1.5c0 .83-.67 1.5-1.5 1.5H10a8 8 0 0 1-8-8V8.5Z" fill="url(#ic_fluent_sport_20_color__d)"/><path d="M2 8.5C2 7.67 2.67 7 3.5 7H5a8 8 0 0 1 8 8v1.5c0 .83-.67 1.5-1.5 1.5H10a8 8 0 0 1-8-8V8.5Z" fill="url(#ic_fluent_sport_20_color__e)" fill-opacity=".9"/><path d="M6.15 11.15c.2-.2.5-.2.7 0l2 2a.5.5 0 0 1-.7.7l-2-2a.5.5 0 0 1 0-.7Z" fill="#FFC470"/><defs><radialGradient id="ic_fluent_sport_20_color__a" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(-90 16.93 3.32) scale(20.9675)"><stop stop-color="#EB4824"/><stop offset=".98" stop-color="#FF921F"/></radialGradient><radialGradient id="ic_fluent_sport_20_color__b" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(5 -5 6.84028 6.84028 7.5 12.5)"><stop offset=".59" stop-color="#AA1D2D"/><stop offset=".93" stop-color="#EB4824" stop-opacity=".1"/></radialGradient><radialGradient id="ic_fluent_sport_20_color__d" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(8.49996 11.49997 -10.3992 7.68636 3 7.5)"><stop offset=".24" stop-color="#AE5606"/><stop offset="1" stop-color="#944600"/></radialGradient><radialGradient id="ic_fluent_sport_20_color__e" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(10.94 -106.2 41.88) scale(16.2778)"><stop offset=".63" stop-color="#FFA43D" stop-opacity="0"/><stop offset=".93" stop-color="#FFA43D"/></radialGradient><linearGradient id="ic_fluent_sport_20_color__c" x1="16.44" y1="3.75" x2="9.93" y2="10.26" gradientUnits="userSpaceOnUse"><stop offset=".71" stop-color="#8E250B"/><stop offset=".9" stop-color="#8E250B" stop-opacity="0"/></linearGradient></defs>`, { color: true }));
export const SportFilled = ( /*#__PURE__*/createFluentIcon('SportFilled', "1em", ["M16.58 4.13a6 6 0 0 1 .83 1.28 2 2 0 0 1-2.43.31l1.6-1.6Zm-.7-.71-1.6 1.6a2 2 0 0 1 .3-2.44 6 6 0 0 1 1.3.84ZM18 8a6 6 0 0 0-.21-1.59 2.99 2.99 0 0 1-3.53.04L13.21 7.5l3.8 3.8c.63-.94.99-2.08.99-3.3Zm-5-4c0-.67.22-1.29.59-1.79a6 6 0 0 0-4.9.78l3.81 3.8 1.05-1.05A2.99 2.99 0 0 1 13 4Zm-1.3 5a8.97 8.97 0 0 1 2.2 4.7 6 6 0 0 0 2.49-1.6L12.5 8.2l-.8.8Zm.1-1.5-.8.8a8.97 8.97 0 0 0-4.7-2.2A6 6 0 0 1 7.9 3.6l3.9 3.89ZM3.5 7C2.67 7 2 7.67 2 8.5V10a8 8 0 0 0 8 8h1.5c.83 0 1.5-.67 1.5-1.5V15a8 8 0 0 0-8-8H3.5Zm2.65 4.15c.2-.2.5-.2.7 0l2 2a.5.5 0 0 1-.7.7l-2-2a.5.5 0 0 1 0-.7Z"]));
export const SportRegular = ( /*#__PURE__*/createFluentIcon('SportRegular', "1em", ["M13.7 12.7a5 5 0 0 0 1.46-.83L8.13 4.84A5 5 0 0 0 7.3 6.3a8.95 8.95 0 0 0-1-.2 6 6 0 1 1 7.6 7.6 8.97 8.97 0 0 0-.2-1Zm-1-4.7 3.17 3.16a4.98 4.98 0 0 0 1.06-4.02 2.99 2.99 0 0 1-3.17-.2L12.71 8Zm3.17-3.16-1.39 1.38a2 2 0 0 0 2.16-.08 5 5 0 0 0-.77-1.3ZM12.5 4.5c0-.52.13-1 .36-1.43a5.03 5.03 0 0 0-4.02 1.06L12 7.29l1.05-1.05a2.99 2.99 0 0 1-.55-1.74Zm1 0c0 .37.1.72.28 1.02l1.38-1.4a5 5 0 0 0-1.3-.76 2 2 0 0 0-.36 1.14ZM3.5 8a.5.5 0 0 0-.5.5V10a7 7 0 0 0 7 7h1.5a.5.5 0 0 0 .5-.5V15a7 7 0 0 0-7-7H3.5ZM2 8.5C2 7.67 2.67 7 3.5 7H5a8 8 0 0 1 8 8v1.5c0 .83-.67 1.5-1.5 1.5H10a8 8 0 0 1-8-8V8.5Zm4.15 2.65c.2-.2.5-.2.7 0l2 2a.5.5 0 0 1-.7.7l-2-2a.5.5 0 0 1 0-.7Z"]));
export const SportAmericanFootballFilled = ( /*#__PURE__*/createFluentIcon('SportAmericanFootballFilled', "1em", ["M10.94 2.64A11.63 11.63 0 0 0 2.6 10.9l6.6 6.6a10.9 10.9 0 0 0 6.08-4.08 13.32 13.32 0 0 0 2.07-4.35l-6.42-6.43Zm.91 5.5c.2.2.2.52 0 .71l-3 3a.5.5 0 0 1-.7-.7l3-3c.2-.2.5-.2.7 0Zm5.8-.2c.26-1.3.36-2.56.35-3.71A2.25 2.25 0 0 0 15.7 2c-1.32.02-2.53.15-3.62.37l5.56 5.56Zm-9.6 9.81-5.72-5.72A16.1 16.1 0 0 0 2 15.84c.04 1.18 1 2.09 2.15 2.14 1.43.07 2.72-.02 3.89-.23Z"]));
export const SportAmericanFootballRegular = ( /*#__PURE__*/createFluentIcon('SportAmericanFootballRegular', "1em", ["M11.85 8.85a.5.5 0 1 0-.7-.7l-3 3a.5.5 0 1 0 .7.7l3-3ZM18 4.23A2.25 2.25 0 0 0 15.7 2c-5.62.07-9.12 2.15-11.18 4.96-2.04 2.78-2.6 6.2-2.51 8.88.04 1.18 1 2.09 2.15 2.14 5.53.26 9.03-1.73 11.13-4.56 2.07-2.8 2.73-6.36 2.71-9.2ZM15.71 3c.72 0 1.29.54 1.3 1.23 0 .9-.07 1.86-.23 2.84l-3.84-3.84C13.79 3.09 14.7 3 15.7 3Zm-3.95.46 4.79 4.8c-.39 1.6-1.04 3.19-2.07 4.56a10.01 10.01 0 0 1-6.1 3.85.5.5 0 0 0-.03-.02l-4.93-4.93a11.8 11.8 0 0 1 1.9-4.17 10.8 10.8 0 0 1 6.44-4.09ZM3.19 12.9l3.98 3.99c-.9.11-1.89.15-2.96.1A1.24 1.24 0 0 1 3 15.81c-.03-.91.02-1.9.18-2.92Z"]));
export const SportBaseballFilled = ( /*#__PURE__*/createFluentIcon('SportBaseballFilled', "1em", ["M18 10c0 1.55-.44 3-1.2 4.22-.95-.7-2-1.24-3.14-1.63a.5.5 0 1 0-.32.95c1.04.35 2 .86 2.88 1.5a7.98 7.98 0 0 1-12.44 0c.87-.64 1.84-1.15 2.88-1.5a.5.5 0 0 0-.32-.95c-1.13.39-2.2.94-3.14 1.63a7.96 7.96 0 0 1 0-8.43c.94.7 2 1.25 3.14 1.63a.5.5 0 1 0 .32-.95 10.47 10.47 0 0 1-2.88-1.5 7.98 7.98 0 0 1 12.44 0c-.87.64-1.84 1.15-2.88 1.5a.5.5 0 1 0 .32.95c1.14-.38 2.2-.94 3.14-1.63A7.96 7.96 0 0 1 18 10Zm-8 3c.49 0 .96.03 1.43.1a.5.5 0 1 0 .14-1 11.6 11.6 0 0 0-3.14 0 .5.5 0 0 0 .14 1c.47-.07.94-.1 1.43-.1ZM8.57 6.92a.5.5 0 0 0-.14.99 11.6 11.6 0 0 0 3.14 0 .5.5 0 1 0-.14-1 10.6 10.6 0 0 1-2.86 0Z"]));
export const SportBaseballRegular = ( /*#__PURE__*/createFluentIcon('SportBaseballRegular', "1em", ["M4.61 5.53a6.99 6.99 0 0 1 10.78 0c-.64.38-1.33.7-2.05.94a.5.5 0 0 0 .32.95c.81-.27 1.59-.64 2.31-1.08a6.97 6.97 0 0 1 0 7.33c-.73-.44-1.5-.8-2.31-1.08a.5.5 0 0 0-.32.95c.72.24 1.4.56 2.04.94a6.99 6.99 0 0 1-10.76 0c.64-.38 1.32-.7 2.04-.94a.5.5 0 1 0-.32-.95c-.81.28-1.58.64-2.3 1.08a6.97 6.97 0 0 1-.01-7.33c.72.44 1.5.8 2.31 1.08a.5.5 0 0 0 .32-.95c-.72-.24-1.4-.56-2.05-.94ZM10 2a8 8 0 1 0 0 16 8 8 0 0 0 0-16ZM8.57 6.92a10.6 10.6 0 0 0 2.86 0 .5.5 0 0 1 .14.99 11.6 11.6 0 0 1-3.14 0 .5.5 0 0 1 .14-1Zm0 6.18a10.6 10.6 0 0 1 2.86 0 .5.5 0 0 0 .14-1 11.6 11.6 0 0 0-3.14 0 .5.5 0 1 0 .14 1Z"]));
export const SportBasketballFilled = ( /*#__PURE__*/createFluentIcon('SportBasketballFilled', "1em", ["M4.7 4A7.97 7.97 0 0 1 9 2.06c.07.43.14.91.24 1.4.18.9.43 1.89.78 2.79.28.71.62 1.4 1.06 1.96L10 9.3 4.7 4Zm-.7.7A7.97 7.97 0 0 0 2.06 9c.43.07.9.14 1.4.24.9.18 1.89.43 2.79.78.71.28 1.4.62 1.96 1.06L9.29 10 4 4.7Zm3.5 7.1c-.43-.32-.99-.6-1.61-.85-.83-.31-1.75-.55-2.62-.72-.45-.1-.88-.17-1.27-.22 0 2.02.76 3.87 2 5.28l3.5-3.5ZM4.7 16l3.5-3.5c.32.43.6.98.85 1.61.31.83.55 1.75.72 2.62.1.45.17.88.22 1.27a7.97 7.97 0 0 1-5.28-2Zm4.22-4.21L10 10.71 15.3 16a7.97 7.97 0 0 1-4.3 1.94c-.07-.43-.15-.91-.25-1.4-.18-.9-.43-1.89-.77-2.79a7.57 7.57 0 0 0-1.06-1.96Zm7.08 3.5a7.97 7.97 0 0 0 1.94-4.3 17.37 17.37 0 0 1-4.18-1.02 7.57 7.57 0 0 1-1.97-1.05L10.7 10 16 15.3ZM12.5 8.2c.43.33.98.6 1.61.85.83.32 1.75.55 2.62.72.45.1.88.17 1.27.22 0-2.02-.76-3.87-2-5.28l-3.5 3.5ZM15.3 4A7.97 7.97 0 0 0 10 2c.06.4.14.82.23 1.27.17.87.4 1.8.72 2.62.24.63.53 1.18.85 1.6L15.3 4Z"]));
export const SportBasketballRegular = ( /*#__PURE__*/createFluentIcon('SportBasketballRegular', "1em", ["m10 9.3 1.08-1.09a7.57 7.57 0 0 1-1.06-1.96 17.37 17.37 0 0 1-.85-3.2 6.97 6.97 0 0 0-3.75 1.66L10 9.29Zm1.79-.38L10.71 10l4.58 4.58a6.97 6.97 0 0 0 1.66-3.75l-.42-.07c-.9-.18-1.88-.43-2.77-.78a7.57 7.57 0 0 1-1.97-1.06Zm5.2.9a6.97 6.97 0 0 0-1.7-4.4L12.5 8.2c.43.32.99.6 1.61.85a16.39 16.39 0 0 0 2.89.78ZM11.8 7.5l2.8-2.8A6.98 6.98 0 0 0 10.16 3l.06.27c.17.87.4 1.8.72 2.62.25.62.53 1.18.85 1.6ZM10 10.7 8.92 11.8c.44.55.79 1.25 1.06 1.96a17.37 17.37 0 0 1 .86 3.2 6.97 6.97 0 0 0 3.74-1.66L10 10.71Zm-1.8 1.8-2.78 2.8a6.97 6.97 0 0 0 4.4 1.7c0-.1-.03-.18-.04-.27-.18-.87-.41-1.8-.73-2.62a6.83 6.83 0 0 0-.84-1.6Zm-.7-.7c-.43-.33-.98-.6-1.61-.85A16.38 16.38 0 0 0 3 10.17c.04 1.58.61 3.15 1.7 4.41l2.8-2.79Zm.71-.72L9.3 10 4.71 5.42a6.97 6.97 0 0 0-1.66 3.74l.42.08c.9.18 1.88.43 2.78.78.72.28 1.4.62 1.96 1.06Zm7.45 4.58A8 8 0 1 1 4.34 4.34a8 8 0 0 1 11.32 11.32Z"]));
export const SportCricketBallFilled = ( /*#__PURE__*/createFluentIcon('SportCricketBallFilled', "1em", ["M10 2c1.52 0 2.93.42 4.14 1.15a.5.5 0 0 0-.14.35v1a.5.5 0 0 0 1 0v-.74A7.98 7.98 0 0 1 10 18a8 8 0 1 1 0-16ZM4.5 13a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 1 0v-1a.5.5 0 0 0-.5-.5Zm2 1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1h-1Zm0-3a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 1 0v-1a.5.5 0 0 0-.5-.5Zm2 1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1h-1Zm0-3a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 1 0v-1a.5.5 0 0 0-.5-.5Zm2 1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1h-1Zm0-3a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 1 0v-1a.5.5 0 0 0-.5-.5Zm2 1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1h-1Zm0-3a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 1 0v-1a.5.5 0 0 0-.5-.5Zm2 1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1h-1Z"]));
export const SportCricketBallRegular = ( /*#__PURE__*/createFluentIcon('SportCricketBallRegular', "1em", ["M10 2a8 8 0 1 1 0 16 8 8 0 0 1 0-16Zm0 1a7 7 0 0 0-6 10.6v-.1a.5.5 0 0 1 1 0v1a.5.5 0 0 1-.1.3 7 7 0 0 0 11.07-8.44c.02.04.03.09.03.14a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1 0-1h1a.5.5 0 0 1 .33.13A7 7 0 0 0 10 3ZM7.5 14a.5.5 0 0 1 0 1h-1a.5.5 0 0 1 0-1h1Zm-1-3c.28 0 .5.22.5.5v1a.5.5 0 0 1-1 0v-1c0-.28.22-.5.5-.5Zm3 1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1 0-1h1Zm-1-3c.28 0 .5.22.5.5v1a.5.5 0 0 1-1 0v-1c0-.28.22-.5.5-.5Zm3 1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1 0-1h1Zm-1-3c.28 0 .5.22.5.5v1a.5.5 0 0 1-1 0v-1c0-.28.22-.5.5-.5Zm3 1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1 0-1h1Zm-1-3c.28 0 .5.22.5.5v1a.5.5 0 0 1-1 0v-1c0-.28.22-.5.5-.5Z"]));
export const SportCricketBatFilled = ( /*#__PURE__*/createFluentIcon('SportCricketBatFilled', "1em", ["M14.23 7.94a1.5 1.5 0 0 0-.23.8v1.38l-.01.2a2 2 0 0 1-.58 1.22l-5.88 5.88a2 2 0 0 1-2.82 0L2.59 15.3a2 2 0 0 1 0-2.83l5.88-5.88A2 2 0 0 1 9.88 6h1.37c.29 0 .57-.09.8-.24l2.18 2.18Zm1.2-5.5a1.5 1.5 0 0 1 2.12 2.12L14.91 7.2l-2.12-2.12 2.64-2.64Z"]));
export const SportCricketBatRegular = ( /*#__PURE__*/createFluentIcon('SportCricketBatRegular', "1em", ["M14.74 2.45a2 2 0 0 1 2.68.14l.13.15a2 2 0 0 1 0 2.52l-.13.15-2.98 2.98A1.5 1.5 0 0 0 14 9.45v.68l-.01.2a2 2 0 0 1-.58 1.2l-5.87 5.89a2 2 0 0 1-2.83 0L2.59 15.3a2 2 0 0 1 0-2.83l5.88-5.88.14-.14A2 2 0 0 1 9.88 6h.67c.4 0 .78-.16 1.06-.44L14.6 2.6l.15-.14ZM11.9 6.6c-.4.26-.87.4-1.35.4h-.67a1 1 0 0 0-.63.23l-.08.06-5.88 5.89a1 1 0 0 0 0 1.4l2.12 2.13a1 1 0 0 0 1.42 0l5.88-5.88a1 1 0 0 0 .28-.6v-.78c0-.48.15-.95.4-1.35l-1.5-1.5Zm4.8-3.3a1 1 0 0 0-1.33-.08l-.08.07-2.64 2.65 1.41 1.41 2.65-2.64.07-.08a1 1 0 0 0 0-1.26l-.07-.08Z"]));
export const SportHockeyFilled = ( /*#__PURE__*/createFluentIcon('SportHockeyFilled', "1em", ["M11.97 2.06a3.7 3.7 0 0 1 3.45 1.3l1.71 1.93c.75.84 1.08 2.02.73 3.13-2.1 6.7-7.03 9.08-10.19 9.55-.9.14-1.76-.22-2.39-.78l-1.8-1.6A4.07 4.07 0 0 1 2.2 11.2c2.12-5.99 6.46-8.47 9.76-9.15Zm2.52 3.52a.5.5 0 1 0-.98-.16 10.9 10.9 0 0 1-3.05 5.9 10.32 10.32 0 0 1-4.1 2.7.5.5 0 1 0 .28.96c1.25-.36 3-1.38 4.53-2.96a11.89 11.89 0 0 0 3.32-6.44Z"]));
export const SportHockeyRegular = ( /*#__PURE__*/createFluentIcon('SportHockeyRegular', "1em", ["M11.97 2.06a3.7 3.7 0 0 1 3.45 1.3l1.71 1.93c.75.84 1.08 2.02.73 3.13-2.1 6.7-7.03 9.08-10.19 9.55-.9.14-1.76-.22-2.39-.78l-1.8-1.6A4.07 4.07 0 0 1 2.2 11.2c2.12-5.99 6.46-8.47 9.76-9.15Zm2.7 1.97c-.68-.76-1.6-1.17-2.5-.99-3 .61-7.03 2.89-9.02 8.5-.4 1.15.02 2.44.98 3.3l1.82 1.6c.46.41 1.03.63 1.57.54 2.85-.42 7.41-2.57 9.39-8.86.23-.73.02-1.55-.53-2.16l-1.71-1.93Zm-.6.98c.28.04.47.3.42.57a11.89 11.89 0 0 1-3.32 6.44 11.28 11.28 0 0 1-4.53 2.96.5.5 0 0 1-.28-.96c1.05-.3 2.66-1.22 4.1-2.7a10.9 10.9 0 0 0 3.05-5.9.5.5 0 0 1 .57-.41Z"]));
export const SportSoccerFilled = ( /*#__PURE__*/createFluentIcon('SportSoccerFilled', "1em", ["M10 2a8 8 0 1 0 0 16 8 8 0 0 0 0-16ZM7.1 3.63l2.4 1.4v1.7L6.73 8.7l-1.56-.57-.62-2.51a7.02 7.02 0 0 1 2.54-1.98ZM3.02 10.7l1.83-1.62 1.55.56 1.04 3.3L6.73 14H4.25a6.96 6.96 0 0 1-1.22-3.3Zm5.34 6.12-.81-2.25.7-1.06h3.47l.72 1.06-.82 2.25a7.02 7.02 0 0 1-3.26 0ZM15.75 14h-2.48l-.72-1.08 1.02-3.29 1.57-.56 1.83 1.62a6.96 6.96 0 0 1-1.22 3.3Zm-.3-8.38-.62 2.5-1.58.57-2.75-1.95v-1.7l2.4-1.4c1 .45 1.88 1.13 2.56 1.98Z"]));
export const SportSoccerRegular = ( /*#__PURE__*/createFluentIcon('SportSoccerRegular', "1em", ["M10 2a8 8 0 1 0 0 16 8 8 0 0 0 0-16ZM8.34 3.2a7.02 7.02 0 0 1 3.33 0L10 4.17 8.34 3.2Zm-1.25.43 2.41 1.4v1.7L6.73 8.7l-1.56-.57-.62-2.51a7.02 7.02 0 0 1 2.54-1.98ZM3.8 6.75l.4 1.58-1.17 1.03c.08-.94.35-1.82.77-2.61Zm-.77 3.94 1.83-1.62 1.55.56 1.04 3.3L6.73 14H4.25a6.96 6.96 0 0 1-1.22-3.3ZM5.1 15h1.55l.51 1.41A7.01 7.01 0 0 1 5.1 15Zm3.27 1.82-.81-2.25.7-1.06h3.47l.72 1.06-.82 2.25a7.02 7.02 0 0 1-3.26 0Zm4.47-.41.51-1.4h1.55a7.02 7.02 0 0 1-2.06 1.4Zm2.9-2.4h-2.47l-.72-1.08 1.02-3.29 1.57-.56 1.83 1.62a6.96 6.96 0 0 1-1.22 3.3Zm1.23-4.64-1.16-1.03.4-1.58c.4.8.68 1.68.76 2.6Zm-1.51-3.74-.63 2.5-1.58.57-2.75-1.95v-1.7l2.4-1.4c1 .45 1.88 1.13 2.56 1.98ZM7.4 9.45 10 7.6l2.59 1.84-.96 3.05H8.37L7.4 9.45Z"]));
export const SquareFilled = ( /*#__PURE__*/createFluentIcon('SquareFilled', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6Z"]));
export const SquareRegular = ( /*#__PURE__*/createFluentIcon('SquareRegular', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6Zm3-2a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2H6Z"]));
export const SquareAddFilled = ( /*#__PURE__*/createFluentIcon('SquareAddFilled', "1em", ["M6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h3.6A5.5 5.5 0 0 1 17 9.6V6a3 3 0 0 0-3-3H6Zm8.5 16a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm0-7c.28 0 .5.22.5.5V14h1.5a.5.5 0 0 1 0 1H15v1.5a.5.5 0 0 1-1 0V15h-1.5a.5.5 0 0 1 0-1H14v-1.5c0-.28.22-.5.5-.5Z"]));
export const SquareAddRegular = ( /*#__PURE__*/createFluentIcon('SquareAddRegular', "1em", ["M6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h3.6c-.16-.32-.3-.65-.4-1H6a2 2 0 0 1-2-2V6c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v3.2c.35.1.68.24 1 .4V6a3 3 0 0 0-3-3H6Zm8.5 16a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm0-7c.28 0 .5.22.5.5V14h1.5a.5.5 0 0 1 0 1H15v1.5a.5.5 0 0 1-1 0V15h-1.5a.5.5 0 0 1 0-1H14v-1.5c0-.28.22-.5.5-.5Z"]));
export const SquareArrowForwardFilled = ( /*#__PURE__*/createFluentIcon('SquareArrowForwardFilled', "1em", ["M6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h3.6A5.5 5.5 0 0 1 17 9.6V6a3 3 0 0 0-3-3H6Zm8.5 16a4.5 4.5 0 1 1 0-9 4.5 4.5 0 0 1 0 9Zm.9-6.4.9.9h-1.55A2.75 2.75 0 0 0 12 16.25v.25a.5.5 0 0 0 1 0v-.25c0-.97.78-1.75 1.75-1.75h1.54l-.9.9a.5.5 0 0 0 .71.7l1.76-1.75a.5.5 0 0 0 0-.7L16.1 11.9a.5.5 0 0 0-.7.7Z"]));
export const SquareArrowForwardRegular = ( /*#__PURE__*/createFluentIcon('SquareArrowForwardRegular', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v3.6c-.32-.16-.65-.3-1-.4V6a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h3.2c.1.35.24.68.4 1H6a3 3 0 0 1-3-3V6Zm11.5 13a4.5 4.5 0 1 1 0-9 4.5 4.5 0 0 1 0 9Zm.9-6.4.9.9h-1.55A2.75 2.75 0 0 0 12 16.25v.25a.5.5 0 0 0 1 0v-.25c0-.97.78-1.75 1.75-1.75h1.54l-.9.9a.5.5 0 0 0 .71.7l1.76-1.75a.5.5 0 0 0 0-.7L16.1 11.9a.5.5 0 0 0-.7.7Z"]));
export const SquareDismissFilled = ( /*#__PURE__*/createFluentIcon('SquareDismissFilled', "1em", ["M6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h3.6A5.5 5.5 0 0 1 17 9.6V6a3 3 0 0 0-3-3H6Zm8.5 16a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm1.85-6.35c.2.2.2.5 0 .7l-1.14 1.15 1.14 1.15a.5.5 0 0 1-.7.7l-1.15-1.14-1.15 1.14a.5.5 0 0 1-.7-.7l1.14-1.15-1.14-1.15a.5.5 0 0 1 .7-.7l1.15 1.14 1.15-1.14c.2-.2.5-.2.7 0Z"]));
export const SquareDismissRegular = ( /*#__PURE__*/createFluentIcon('SquareDismissRegular', "1em", ["M6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h3.6c-.16-.32-.3-.65-.4-1H6a2 2 0 0 1-2-2V6c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v3.2c.35.1.68.24 1 .4V6a3 3 0 0 0-3-3H6Zm8.5 16a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm1.85-6.35c.2.2.2.5 0 .7l-1.14 1.15 1.14 1.15a.5.5 0 0 1-.7.7l-1.15-1.14-1.15 1.14a.5.5 0 0 1-.7-.7l1.14-1.15-1.14-1.15a.5.5 0 0 1 .7-.7l1.15 1.14 1.15-1.14c.2-.2.5-.2.7 0Z"]));
export const SquareDovetailJointFilled = ( /*#__PURE__*/createFluentIcon('SquareDovetailJointFilled', "1em", ["M8 11.75a.5.5 0 0 1 .68-.47L12 12.53V7.47L8.67 8.7A.5.5 0 0 1 8 8.23V3H6a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h2v-5.25ZM14 3H9v4.51l3.33-1.23a.5.5 0 0 1 .67.47v6.5a.5.5 0 0 1-.68.47L9 12.47V17h5a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3Z"]));
export const SquareDovetailJointRegular = ( /*#__PURE__*/createFluentIcon('SquareDovetailJointRegular', "1em", ["M14 3H6a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3ZM4 14V6c0-1.1.9-2 2-2h2v4.23a.5.5 0 0 0 .67.47L12 7.47v5.06l-3.32-1.25a.5.5 0 0 0-.68.47V16H6a2 2 0 0 1-2-2Zm12 0a2 2 0 0 1-2 2H9v-3.53l3.32 1.25a.5.5 0 0 0 .68-.47v-6.5a.5.5 0 0 0-.67-.47L9 7.51v-3.5h5a2 2 0 0 1 2 2v8V14Z"]));
export const SquareEraserFilled = ( /*#__PURE__*/createFluentIcon('SquareEraserFilled', "1em", ["m8.73 13.64 4.9-4.9A2.48 2.48 0 0 1 17 8.59V6a3 3 0 0 0-3-3H6a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h2.6a2.5 2.5 0 0 1 .13-3.36Zm7.74-4.2 2.1 2.1a1.5 1.5 0 0 1 0 2.12l-3.6 3.6-4.22-4.22 3.6-3.6a1.5 1.5 0 0 1 2.12 0Zm-2.21 8.52-4.22-4.22-.6.6a1.5 1.5 0 0 0 0 2.13l2.1 2.1a1.5 1.5 0 0 0 1.12.43h4.09a.5.5 0 0 0 0-1h-2.53l.04-.04Z"]));
export const SquareEraserRegular = ( /*#__PURE__*/createFluentIcon('SquareEraserRegular', "1em", ["M8.08 16H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v2.08c.37.09.71.26 1 .5V6a3 3 0 0 0-3-3H6a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h2.6a2.47 2.47 0 0 1-.52-1Zm1.36.47a1.5 1.5 0 0 1 0-2.13l4.9-4.9a1.5 1.5 0 0 1 2.12 0l2.1 2.1a1.5 1.5 0 0 1 0 2.13L14.22 18h2.53a.5.5 0 0 1 0 1h-4.1a1.5 1.5 0 0 1-1.12-.44l-2.1-2.1Zm5.61-6.32-3.6 3.6 2.8 2.8 3.6-3.6a.5.5 0 0 0 0-.71l-2.1-2.1a.5.5 0 0 0-.7 0Zm-1.5 7.1-2.8-2.8-.6.6a.5.5 0 0 0 0 .71l2.1 2.1a.5.5 0 0 0 .7 0l.6-.6Z"]));
export const SquareHintFilled = ( /*#__PURE__*/createFluentIcon('SquareHintFilled', "1em", ["M9.25 3a.75.75 0 0 0 0 1.5h1.5a.75.75 0 0 0 0-1.5h-1.5ZM3 10.75a.75.75 0 0 0 1.5 0v-1.5a.75.75 0 0 0-1.5 0v1.5Zm5.5 5.5c0-.41.34-.75.75-.75h1.5a.75.75 0 0 1 0 1.5h-1.5a.75.75 0 0 1-.75-.75Zm7-5.5a.75.75 0 0 0 1.5 0v-1.5a.75.75 0 0 0-1.5 0v1.5Zm-9.5-7A.75.75 0 0 0 5.25 3C4.01 3 3 4 3 5.25a.75.75 0 0 0 1.5 0c0-.41.34-.75.75-.75S6 4.16 6 3.75ZM5.25 17a.75.75 0 0 0 0-1.5.75.75 0 0 1-.75-.75.75.75 0 0 0-1.5 0C3 15.99 4 17 5.25 17ZM14 3.75c0-.41.34-.75.75-.75C15.99 3 17 4 17 5.25a.75.75 0 0 1-1.5 0 .75.75 0 0 0-.75-.75.75.75 0 0 1-.75-.75ZM14.75 17a.75.75 0 0 1 0-1.5c.41 0 .75-.34.75-.75a.75.75 0 0 1 1.5 0c0 1.24-1 2.25-2.25 2.25Z"]));
export const SquareHintRegular = ( /*#__PURE__*/createFluentIcon('SquareHintRegular', "1em", ["M6 3.5a.5.5 0 0 0-.5-.5A2.5 2.5 0 0 0 3 5.5a.5.5 0 0 0 1 0C4 4.67 4.67 4 5.5 4a.5.5 0 0 0 .5-.5ZM16.5 6a.5.5 0 0 0 .5-.5A2.5 2.5 0 0 0 14.5 3a.5.5 0 0 0 0 1c.83 0 1.5.67 1.5 1.5 0 .28.22.5.5.5Zm-2 11a.5.5 0 0 1 0-1c.83 0 1.5-.67 1.5-1.5a.5.5 0 0 1 1 0 2.5 2.5 0 0 1-2.5 2.5Zm-11-3a.5.5 0 0 0-.5.5A2.5 2.5 0 0 0 5.5 17a.5.5 0 0 0 0-1A1.5 1.5 0 0 1 4 14.5a.5.5 0 0 0-.5-.5ZM3 9a.5.5 0 0 1 1 0v2a.5.5 0 0 1-1 0V9Zm13.5-.5a.5.5 0 0 0-.5.5v2a.5.5 0 0 0 1 0V9a.5.5 0 0 0-.5-.5Zm-8-5c0-.28.22-.5.5-.5h2a.5.5 0 0 1 0 1H9a.5.5 0 0 1-.5-.5ZM9 16a.5.5 0 0 0 0 1h2a.5.5 0 0 0 0-1H9Z"]));
export const SquareHintAppsFilled = ( /*#__PURE__*/createFluentIcon('SquareHintAppsFilled', "1em", ["M8.5 3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3ZM4.05 5.54a2 2 0 0 1 1.55-1.5.5.5 0 0 0 .4-.59.5.5 0 0 0-.66-.38 3 3 0 0 0-2.29 2.34.5.5 0 0 0 .4.6.5.5 0 0 0 .6-.47Zm0 8.92a2 2 0 0 0 1.55 1.5.5.5 0 0 1 .4.59.5.5 0 0 1-.66.38 3 3 0 0 1-2.29-2.34.5.5 0 0 1 .4-.6.5.5 0 0 1 .6.47ZM14.66 3.07a.5.5 0 0 0-.66.38.5.5 0 0 0 .46.6 2 2 0 0 1 1.5 1.55.5.5 0 0 0 .59.4.5.5 0 0 0 .38-.66 3 3 0 0 0-2.27-2.27ZM3 11.5a.5.5 0 0 0 1 0v-3a.5.5 0 0 0-1 0v3ZM6.5 5C5.67 5 5 5.67 5 6.5v7c0 .83.67 1.5 1.5 1.5H7v-.25A2.75 2.75 0 0 1 9.75 12H12V9.75A2.75 2.75 0 0 1 14.75 7H15v-.5c0-.83-.67-1.5-1.5-1.5h-7ZM19 9.75C19 8.78 18.22 8 17.25 8h-2.5C13.78 8 13 8.78 13 9.75V13H9.75C8.78 13 8 13.78 8 14.75v2.5c0 .97.78 1.75 1.75 1.75h6.75a2.5 2.5 0 0 0 2.5-2.5V9.75ZM14 13V9.75c0-.41.34-.75.75-.75h2.5c.41 0 .75.34.75.75V13h-4Zm2.5 5H14v-4h4v2.5c0 .83-.67 1.5-1.5 1.5Zm-6.75-4H13v4H9.75a.75.75 0 0 1-.75-.75v-2.5c0-.41.34-.75.75-.75Z"]));
export const SquareHintAppsRegular = ( /*#__PURE__*/createFluentIcon('SquareHintAppsRegular', "1em", ["M8.5 3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3ZM4.05 5.54a2 2 0 0 1 1.55-1.5.5.5 0 0 0 .4-.59.5.5 0 0 0-.66-.38 3 3 0 0 0-2.29 2.34.5.5 0 0 0 .4.6.5.5 0 0 0 .6-.47Zm0 8.92a2 2 0 0 0 1.55 1.5.5.5 0 0 1 .4.59.5.5 0 0 1-.66.38 3 3 0 0 1-2.29-2.34.5.5 0 0 1 .4-.6.5.5 0 0 1 .6.47ZM14.66 3.07a.5.5 0 0 0-.66.38.5.5 0 0 0 .46.6 2 2 0 0 1 1.5 1.55.5.5 0 0 0 .59.4.5.5 0 0 0 .38-.66 3 3 0 0 0-2.27-2.27ZM3 11.5a.5.5 0 0 0 1 0v-3a.5.5 0 0 0-1 0v3Zm16-1.75C19 8.78 18.22 8 17.25 8h-2.5C13.78 8 13 8.78 13 9.75V13H9.75C8.78 13 8 13.78 8 14.75v2.5c0 .97.78 1.75 1.75 1.75h6.75a2.5 2.5 0 0 0 2.5-2.5V9.75ZM14 13V9.75c0-.41.34-.75.75-.75h2.5c.41 0 .75.34.75.75V13h-4Zm2.5 5H14v-4h4v2.5c0 .83-.67 1.5-1.5 1.5Zm-6.75-4H13v4H9.75a.75.75 0 0 1-.75-.75v-2.5c0-.41.34-.75.75-.75Z"]));
export const SquareHintArrowBackFilled = ( /*#__PURE__*/createFluentIcon('SquareHintArrowBackFilled', "1em", ["M9.25 3a.75.75 0 0 0 0 1.5h1.5a.75.75 0 0 0 0-1.5h-1.5ZM3 10.75a.75.75 0 0 0 1.5 0v-1.5a.75.75 0 0 0-1.5 0v1.5Zm4.5 5.5c0-.41.34-.75.75-.75h.84c.1.53.27 1.03.51 1.5H8.25a.75.75 0 0 1-.75-.75Zm8-7.16c.53.1 1.03.27 1.5.51V8.25a.75.75 0 0 0-1.5 0v.84ZM6 3.75A.75.75 0 0 0 5.25 3C4.01 3 3 4 3 5.25a.75.75 0 0 0 1.5 0c0-.41.34-.75.75-.75S6 4.16 6 3.75ZM5.25 17a.75.75 0 0 0 0-1.5.75.75 0 0 1-.75-.75.75.75 0 0 0-1.5 0C3 15.99 4 17 5.25 17ZM14 3.75c0-.41.34-.75.75-.75C15.99 3 17 4 17 5.25a.75.75 0 0 1-1.5 0 .75.75 0 0 0-.75-.75.75.75 0 0 1-.75-.75ZM14.5 19a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm-.9-6.4-.9.9h1.55A2.75 2.75 0 0 1 17 16.25v.25a.5.5 0 0 1-1 0v-.25c0-.97-.78-1.75-1.75-1.75h-1.54l.9.9a.5.5 0 0 1-.71.7l-1.76-1.75a.5.5 0 0 1 0-.7l1.76-1.75a.5.5 0 0 1 .7.7Z"]));
export const SquareHintArrowBackRegular = ( /*#__PURE__*/createFluentIcon('SquareHintArrowBackRegular', "1em", ["M6 3.5a.5.5 0 0 0-.5-.5A2.5 2.5 0 0 0 3 5.5a.5.5 0 0 0 1 0C4 4.67 4.67 4 5.5 4a.5.5 0 0 0 .5-.5ZM16.5 6a.5.5 0 0 0 .5-.5A2.5 2.5 0 0 0 14.5 3a.5.5 0 0 0 0 1c.83 0 1.5.67 1.5 1.5 0 .28.22.5.5.5Zm-13 8a.5.5 0 0 0-.5.5A2.5 2.5 0 0 0 5.5 17a.5.5 0 0 0 0-1A1.5 1.5 0 0 1 4 14.5a.5.5 0 0 0-.5-.5ZM3 9a.5.5 0 0 1 1 0v2a.5.5 0 0 1-1 0V9Zm13.5-1.5a.5.5 0 0 0-.5.5v1.2c.35.1.68.24 1 .4V8a.5.5 0 0 0-.5-.5ZM9.6 17c-.16-.32-.3-.65-.4-1H8a.5.5 0 0 0 0 1h1.6ZM8.5 3.5c0-.28.22-.5.5-.5h2a.5.5 0 0 1 0 1H9a.5.5 0 0 1-.5-.5Zm6 15.5a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm-.9-6.4-.9.9h1.55A2.75 2.75 0 0 1 17 16.25v.25a.5.5 0 0 1-1 0v-.25c0-.97-.78-1.75-1.75-1.75h-1.54l.9.9a.5.5 0 0 1-.71.7l-1.76-1.75a.5.5 0 0 1 0-.7l1.76-1.75a.5.5 0 0 1 .7.7Z"]));
export const SquareHintHexagonFilled = ( /*#__PURE__*/createFluentIcon('SquareHintHexagonFilled', "1em", ["M5.5 3a.5.5 0 0 1 0 1C4.67 4 4 4.67 4 5.5a.5.5 0 0 1-1 0A2.5 2.5 0 0 1 5.5 3ZM17 5.5a.5.5 0 0 1-1 0c0-.83-.67-1.5-1.5-1.5a.5.5 0 0 1 0-1A2.5 2.5 0 0 1 17 5.5Zm-3 11c0 .28.22.5.5.5a2.5 2.5 0 0 0 2.5-2.5.5.5 0 0 0-1 0c0 .83-.67 1.5-1.5 1.5a.5.5 0 0 0-.5.5Zm-11-2a.5.5 0 0 1 1 0c0 .83.67 1.5 1.5 1.5a.5.5 0 0 1 0 1A2.5 2.5 0 0 1 3 14.5Zm.5-6A.5.5 0 0 0 3 9v2a.5.5 0 0 0 1 0V9a.5.5 0 0 0-.5-.5ZM16 9a.5.5 0 0 1 1 0v2a.5.5 0 0 1-1 0V9ZM9 3a.5.5 0 0 0 0 1h2a.5.5 0 0 0 0-1H9Zm-.5 13.5c0-.28.22-.5.5-.5h2a.5.5 0 0 1 0 1H9a.5.5 0 0 1-.5-.5ZM7.33 6.63c.23-.4.64-.63 1.09-.63h3.17c.44 0 .86.24 1.08.63l1.58 2.75c.23.38.23.86 0 1.24l-1.58 2.75c-.22.4-.64.63-1.08.63H8.42c-.45 0-.86-.24-1.09-.63l-1.58-2.75a1.25 1.25 0 0 1 0-1.24l1.58-2.75Z"]));
export const SquareHintHexagonRegular = ( /*#__PURE__*/createFluentIcon('SquareHintHexagonRegular', "1em", ["M5.5 3a.5.5 0 0 1 0 1C4.67 4 4 4.67 4 5.5a.5.5 0 0 1-1 0A2.5 2.5 0 0 1 5.5 3ZM17 5.5a.5.5 0 0 1-1 0c0-.83-.67-1.5-1.5-1.5a.5.5 0 0 1 0-1A2.5 2.5 0 0 1 17 5.5Zm-3 11c0 .28.22.5.5.5a2.5 2.5 0 0 0 2.5-2.5.5.5 0 0 0-1 0c0 .83-.67 1.5-1.5 1.5a.5.5 0 0 0-.5.5Zm-11-2a.5.5 0 0 1 1 0c0 .83.67 1.5 1.5 1.5a.5.5 0 0 1 0 1A2.5 2.5 0 0 1 3 14.5Zm.5-6A.5.5 0 0 0 3 9v2a.5.5 0 0 0 1 0V9a.5.5 0 0 0-.5-.5ZM16 9a.5.5 0 0 1 1 0v2a.5.5 0 0 1-1 0V9ZM9 3a.5.5 0 0 0 0 1h2a.5.5 0 0 0 0-1H9Zm-.5 13.5c0-.28.22-.5.5-.5h2a.5.5 0 0 1 0 1H9a.5.5 0 0 1-.5-.5Zm-.3-9.37A.25.25 0 0 1 8.42 7h3.17c.09 0 .17.05.21.13l1.59 2.75c.04.07.04.17 0 .24l-1.59 2.75a.25.25 0 0 1-.21.13H8.42a.25.25 0 0 1-.22-.13l-1.59-2.75a.25.25 0 0 1 0-.24L8.2 7.13ZM8.42 6c-.45 0-.86.24-1.09.63L5.75 9.38c-.23.38-.23.86 0 1.24l1.58 2.75c.23.4.64.63 1.09.63h3.17c.44 0 .86-.24 1.08-.63l1.58-2.75c.23-.38.23-.86 0-1.24l-1.58-2.75A1.25 1.25 0 0 0 11.59 6H8.42Z"]));
export const SquareHintSparklesFilled = ( /*#__PURE__*/createFluentIcon('SquareHintSparklesFilled', "1em", ["m14.88.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.23 2.23 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Zm4.9 7.93-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02ZM10 3.5c0-.17.04-.34.1-.5h-.85a.75.75 0 0 0 0 1.5h1.18a1.43 1.43 0 0 1-.43-1Zm-6.25 8a.75.75 0 0 1-.75-.75v-1.5a.75.75 0 0 1 1.5 0v1.5c0 .41-.34.75-.75.75Zm5.5 4a.75.75 0 0 0 0 1.5h1.5a.75.75 0 0 0 0-1.5h-1.5ZM5.25 3a.75.75 0 0 1 0 1.5.75.75 0 0 0-.75.75.75.75 0 0 1-1.5 0C3 4.01 4 3 5.25 3ZM6 16.25c0 .41-.34.75-.75.75C4.01 17 3 16 3 14.75a.75.75 0 0 1 1.5 0c0 .41.34.75.75.75s.75.34.75.75Zm8 0c0 .41.34.75.75.75 1.24 0 2.25-1 2.25-2.25a.75.75 0 0 0-1.5 0c0 .41-.34.75-.75.75a.75.75 0 0 0-.75.75Z"]));
export const SquareHintSparklesRegular = ( /*#__PURE__*/createFluentIcon('SquareHintSparklesRegular', "1em", ["m14.88.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.23 2.23 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Zm4.9 7.93-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02ZM10 3.5c0-.17.04-.34.1-.5H9a.5.5 0 0 0 0 1h1.1c-.06-.16-.1-.33-.1-.5ZM5.5 3a.5.5 0 0 1 0 1C4.67 4 4 4.67 4 5.5a.5.5 0 0 1-1 0A2.5 2.5 0 0 1 5.5 3ZM14 16.5c0 .28.22.5.5.5a2.5 2.5 0 0 0 2.5-2.5.5.5 0 0 0-1 0c0 .83-.67 1.5-1.5 1.5a.5.5 0 0 0-.5.5Zm-11-2a.5.5 0 0 1 1 0c0 .83.67 1.5 1.5 1.5a.5.5 0 0 1 0 1A2.5 2.5 0 0 1 3 14.5Zm.5-6A.5.5 0 0 0 3 9v2a.5.5 0 0 0 1 0V9a.5.5 0 0 0-.5-.5Zm5 8c0-.28.22-.5.5-.5h2a.5.5 0 0 1 0 1H9a.5.5 0 0 1-.5-.5Z"]));
export const SquareMultipleFilled = ( /*#__PURE__*/createFluentIcon('SquareMultipleFilled', "1em", ["M6.09 4H5.05A2.5 2.5 0 0 1 7.5 2H14a4 4 0 0 1 4 4v6.5a2.5 2.5 0 0 1-2 2.45v-1.04c.58-.2 1-.76 1-1.41V6a3 3 0 0 0-3-3H7.5c-.65 0-1.2.42-1.41 1ZM2 7.5A2.5 2.5 0 0 1 4.5 5h8A2.5 2.5 0 0 1 15 7.5v8a2.5 2.5 0 0 1-2.5 2.5h-8A2.5 2.5 0 0 1 2 15.5v-8Z"]));
export const SquareMultipleRegular = ( /*#__PURE__*/createFluentIcon('SquareMultipleRegular', "1em", ["M6.09 4H5.05A2.5 2.5 0 0 1 7.5 2H14a4 4 0 0 1 4 4v6.5a2.5 2.5 0 0 1-2 2.45v-1.04c.58-.2 1-.76 1-1.41V6a3 3 0 0 0-3-3H7.5c-.65 0-1.2.42-1.41 1ZM4.5 5A2.5 2.5 0 0 0 2 7.5v8A2.5 2.5 0 0 0 4.5 18h8a2.5 2.5 0 0 0 2.5-2.5v-8A2.5 2.5 0 0 0 12.5 5h-8ZM3 7.5C3 6.67 3.67 6 4.5 6h8c.83 0 1.5.67 1.5 1.5v8c0 .83-.67 1.5-1.5 1.5h-8A1.5 1.5 0 0 1 3 15.5v-8Z"]));
export const SquareShadowFilled = ( /*#__PURE__*/createFluentIcon('SquareShadowFilled', "1em", ["M4.5 2A2.5 2.5 0 0 0 2 4.5v7A2.5 2.5 0 0 0 4.5 14H6v1.5A2.5 2.5 0 0 0 8.5 18h7a2.5 2.5 0 0 0 2.5-2.5v-7A2.5 2.5 0 0 0 15.5 6H14V4.5A2.5 2.5 0 0 0 11.5 2h-7Zm-1 2.5a1 1 0 0 1 1-1h7a1 1 0 0 1 1 1v7a1 1 0 0 1-1 1h-7a1 1 0 0 1-1-1v-7Z"]));
export const SquareShadowRegular = ( /*#__PURE__*/createFluentIcon('SquareShadowRegular', "1em", ["M4.5 2A2.5 2.5 0 0 0 2 4.5v7A2.5 2.5 0 0 0 4.5 14H6v1.5A2.5 2.5 0 0 0 8.5 18h7a2.5 2.5 0 0 0 2.5-2.5v-7A2.5 2.5 0 0 0 15.5 6H14V4.5A2.5 2.5 0 0 0 11.5 2h-7ZM3 4.5C3 3.67 3.67 3 4.5 3h7c.83 0 1.5.67 1.5 1.5v7c0 .83-.67 1.5-1.5 1.5h-7A1.5 1.5 0 0 1 3 11.5v-7Z"]));
export const SquareTextArrowRepeatAllFilled = ( /*#__PURE__*/createFluentIcon('SquareTextArrowRepeatAllFilled', "1em", ["m16.06 8.94.94.94V5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h5.47a1.5 1.5 0 0 1-1.17-.6c-.5-.67-.8-1.5-.8-2.4H6.41a.5.5 0 0 1 0-1H9.13a4 4 0 0 1 1.93-2.5H6.41a.5.5 0 0 1 0-1h7.17a1.5 1.5 0 0 1 2.48-.56ZM14 6.5a.5.5 0 0 1-.41.5H6.41a.5.5 0 0 1 0-1h7.18a.5.5 0 0 1 .41.5Zm1.35 3.15a.5.5 0 0 0-.7.7l.64.65H13a3 3 0 0 0-2.4 4.8.5.5 0 1 0 .8-.6A2 2 0 0 1 13 12h2.3l-.65.65a.5.5 0 0 0 .7.7l1.5-1.5a.5.5 0 0 0 0-.7l-1.5-1.5Zm3.05 2.55a.5.5 0 0 0-.8.6A2 2 0 0 1 16 16h-2.3l.65-.65a.5.5 0 0 0-.7-.7l-1.5 1.5a.5.5 0 0 0 0 .7l1.5 1.5a.5.5 0 0 0 .7-.7l-.64-.65H16a3 3 0 0 0 2.4-4.8Z"]));
export const SquareTextArrowRepeatAllRegular = ( /*#__PURE__*/createFluentIcon('SquareTextArrowRepeatAllRegular', "1em", ["m16.06 8.94.94.94V5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h5.47a1.5 1.5 0 0 1-1.17-.6c-.1-.13-.18-.26-.26-.4H5.5A1.5 1.5 0 0 1 4 14.5v-9C4 4.67 4.67 4 5.5 4h9c.83 0 1.5.67 1.5 1.5v3.38l.06.06ZM9 14a4 4 0 0 1 .13-1H6.4a.5.5 0 0 0 .09 1H9Zm4.5-4c0-.17.03-.33.08-.5a.5.5 0 0 0-.08 0H6.41a.5.5 0 0 0 .09 1h4.56c.58-.32 1.24-.5 1.94-.5h.5Zm.5-3.5a.5.5 0 0 1-.41.5H6.5a.5.5 0 0 1-.09-1h7.09c.28 0 .5.22.5.5Zm1.35 3.15a.5.5 0 0 0-.7.7l.64.65H13a3 3 0 0 0-2.4 4.8.5.5 0 1 0 .8-.6A2 2 0 0 1 13 12h2.3l-.65.65a.5.5 0 0 0 .7.7l1.5-1.5a.5.5 0 0 0 0-.7l-1.5-1.5Zm3.05 2.55a.5.5 0 0 0-.8.6A2 2 0 0 1 16 16h-2.3l.65-.65a.5.5 0 0 0-.7-.7l-1.5 1.5a.5.5 0 0 0 0 .7l1.5 1.5a.5.5 0 0 0 .7-.7l-.64-.65H16a3 3 0 0 0 2.4-4.8Z"]));
export const SquaresNestedFilled = ( /*#__PURE__*/createFluentIcon('SquaresNestedFilled', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v1.76A2.99 2.99 0 0 0 15 7h-5a3 3 0 0 0-3 3v5c0 .77.29 1.47.76 2H6a3 3 0 0 1-3-3V6Zm7 11h4a3 3 0 0 0 3-3v-4a2 2 0 0 0-2-2h-5a2 2 0 0 0-2 2v5c0 1.1.9 2 2 2Z"]));
export const SquaresNestedRegular = ( /*#__PURE__*/createFluentIcon('SquaresNestedRegular', "1em", ["M6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6Zm10 4.76A2.99 2.99 0 0 0 14 7h-4a3 3 0 0 0-3 3v4c0 .77.29 1.47.76 2H6a2 2 0 0 1-2-2V6c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v1.76ZM10 16a2 2 0 0 1-2-2v-4c0-1.1.9-2 2-2h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2h-4Z"]));
export const StackFilled = ( /*#__PURE__*/createFluentIcon('StackFilled', "1em", ["M4 3a2 2 0 0 0-2 2v6c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2H4Zm.27 11c.34.6.99 1 1.73 1h6a4 4 0 0 0 4-4V7a2 2 0 0 0-1-1.73V11a3 3 0 0 1-3 3H4.27Zm2 2c.34.6.99 1 1.73 1h4a6 6 0 0 0 6-6V9a2 2 0 0 0-1-1.73V11a5 5 0 0 1-5 5H6.27Z"]));
export const StackRegular = ( /*#__PURE__*/createFluentIcon('StackRegular', "1em", ["M2 5c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5Zm2-1a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1H4Zm2 11a2 2 0 0 1-1.73-1H12a3 3 0 0 0 3-3V5.27c.6.34 1 .99 1 1.73v4a4 4 0 0 1-4 4H6Zm2 2a2 2 0 0 1-1.73-1H12a5 5 0 0 0 5-5V7.27c.6.34 1 .99 1 1.73v2a6 6 0 0 1-6 6H8Z"]));
export const StackAddFilled = ( /*#__PURE__*/createFluentIcon('StackAddFilled', "1em", ["M10 6.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V6H3.5a.5.5 0 0 0 0 1H5v1.5a.5.5 0 0 0 1 0V7h1.5a.5.5 0 0 0 0-1H6V4.5ZM5.5 12a5.5 5.5 0 0 0 4.9-8H12a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2v-1.26A5.48 5.48 0 0 0 5.5 12Zm-1.23 3c.34.6.99 1 1.73 1h6a4 4 0 0 0 4-4V8a2 2 0 0 0-1-1.73V12a3 3 0 0 1-3 3H4.27Zm2 2c.34.6.99 1 1.73 1h4a6 6 0 0 0 6-6v-2a2 2 0 0 0-1-1.73V12a5 5 0 0 1-5 5H6.27Z"]));
export const StackAddRegular = ( /*#__PURE__*/createFluentIcon('StackAddRegular', "1em", ["M10 6.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V6H3.5a.5.5 0 0 0 0 1H5v1.5a.5.5 0 0 0 1 0V7h1.5a.5.5 0 0 0 0-1H6V4.5Zm6 .5h-1.2c-.1-.35-.24-.68-.4-1H12a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2v-1.26c.3.26.64.48 1 .66v.6a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1ZM6 16a2 2 0 0 1-1.73-1H12a3 3 0 0 0 3-3V6.27c.6.34 1 .99 1 1.73v4a4 4 0 0 1-4 4H6Zm2 2a2 2 0 0 1-1.73-1H12a5 5 0 0 0 5-5V8.27c.6.34 1 .99 1 1.73v2a6 6 0 0 1-6 6H8Z"]));
export const StackArrowForwardFilled = ( /*#__PURE__*/createFluentIcon('StackArrowForwardFilled', "1em", ["M14.5 10a4.5 4.5 0 1 1 0-9 4.5 4.5 0 0 1 0 9Zm1.6-7.1a.5.5 0 0 0-.7.7l.9.9h-1.55A2.75 2.75 0 0 0 12 7.25v.25a.5.5 0 0 0 1 0v-.25c0-.97.78-1.75 1.75-1.75h1.54l-.9.9a.5.5 0 0 0 .71.7l1.76-1.75a.5.5 0 0 0 0-.7L16.1 2.9ZM4 3h5.6a5.5 5.5 0 0 0 4.4 7.98V11a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5c0-1.1.9-2 2-2Zm11 7.98c.34-.03.68-.1 1-.19V11a4 4 0 0 1-4 4H6a2 2 0 0 1-1.73-1H12a3 3 0 0 0 3-3v-.02Zm3-1.24c-.3.26-.64.48-1 .66v.6a5 5 0 0 1-5 5H6.27c.34.6.99 1 1.73 1h4a6 6 0 0 0 6-6V9.74Z"]));
export const StackArrowForwardRegular = ( /*#__PURE__*/createFluentIcon('StackArrowForwardRegular', "1em", ["M14.5 10a4.5 4.5 0 1 1 0-9 4.5 4.5 0 0 1 0 9Zm1.6-7.1a.5.5 0 0 0-.7.7l.9.9h-1.55A2.75 2.75 0 0 0 12 7.25v.25a.5.5 0 0 0 1 0v-.25c0-.97.78-1.75 1.75-1.75h1.54l-.9.9a.5.5 0 0 0 .71.7l1.76-1.75a.5.5 0 0 0 0-.7L16.1 2.9ZM14 11v-.02c-.34-.03-.68-.1-1-.19V11a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V5a1 1 0 0 1 1-1h5.2c.1-.35.24-.68.4-1H4a2 2 0 0 0-2 2v6c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2Zm1-.02c.34-.03.68-.1 1-.19V11a4 4 0 0 1-4 4H6a2 2 0 0 1-1.73-1H12a3 3 0 0 0 3-3v-.02Zm3-1.24c-.3.26-.64.48-1 .66v.6a5 5 0 0 1-5 5H6.27c.34.6.99 1 1.73 1h4a6 6 0 0 0 6-6V9.74Z"]));
export const StackOffFilled = ( /*#__PURE__*/createFluentIcon('StackOffFilled', "1em", ["M2.85 2.15a.5.5 0 1 0-.7.7l.59.6A2 2 0 0 0 2 5v6c0 1.1.9 2 2 2h8c.1 0 .18 0 .27-.02l.82.82A3 3 0 0 1 12 14H4.27c.34.6.99 1 1.73 1h6c.66 0 1.3-.16 1.84-.45l.74.74c-.75.45-1.64.71-2.58.71H6.27c.34.6.99 1 1.73 1h4c1.22 0 2.36-.36 3.3-.99l1.85 1.84a.5.5 0 0 0 .7-.7l-15-15Zm11.76 10.34.72.72c.42-.63.67-1.4.67-2.21V7a2 2 0 0 0-1-1.73V11c0 .54-.14 1.05-.4 1.49Zm1.44 1.44.72.72A5.97 5.97 0 0 0 18 11V9a2 2 0 0 0-1-1.73V11c0 1.1-.35 2.1-.95 2.93ZM5.12 3l8.74 8.74A2 2 0 0 0 14 11V5a2 2 0 0 0-2-2H5.12Z"]));
export const StackOffRegular = ( /*#__PURE__*/createFluentIcon('StackOffRegular', "1em", ["M2.85 2.15a.5.5 0 1 0-.7.7l.59.6A2 2 0 0 0 2 5v6c0 1.1.9 2 2 2h8c.1 0 .18 0 .27-.02l.82.82A3 3 0 0 1 12 14H4.27c.34.6.99 1 1.73 1h6c.66 0 1.3-.16 1.84-.45l.74.74c-.75.45-1.64.71-2.58.71H6.27c.34.6.99 1 1.73 1h4c1.22 0 2.36-.36 3.3-.99l1.85 1.84a.5.5 0 0 0 .7-.7l-15-15ZM11.3 12H4a1 1 0 0 1-1-1V5a1 1 0 0 1 .45-.84L11.3 12ZM13 5v5.88l.86.86A2 2 0 0 0 14 11V5a2 2 0 0 0-2-2H5.12l1 1H12a1 1 0 0 1 1 1Zm1.6 7.49.73.72c.42-.63.67-1.4.67-2.21V7a2 2 0 0 0-1-1.73V11c0 .54-.14 1.05-.4 1.49Zm1.45 1.44.72.72A5.97 5.97 0 0 0 18 11V9a2 2 0 0 0-1-1.73V11c0 1.1-.35 2.1-.95 2.93Z"]));
export const StackStarFilled = ( /*#__PURE__*/createFluentIcon('StackStarFilled', "1em", ["M4 3a2 2 0 0 0-2 2v6c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2H4Zm4.33 2.08.91 1.73 1.8.22a.38.38 0 0 1 .2.67L9.91 8.74l.45 1.93a.38.38 0 0 1-.56.4L8 10l-1.8 1.08a.38.38 0 0 1-.57-.4l.45-1.93L4.77 7.7a.38.38 0 0 1 .19-.67l1.8-.22.9-1.73a.38.38 0 0 1 .67 0ZM4.27 14c.34.6.99 1 1.73 1h6a4 4 0 0 0 4-4V7a2 2 0 0 0-1-1.73V11a3 3 0 0 1-3 3H4.27Zm2 2c.34.6.99 1 1.73 1h4a6 6 0 0 0 6-6V9a2 2 0 0 0-1-1.73V11a5 5 0 0 1-5 5H6.27Z"]));
export const StackStarRegular = ( /*#__PURE__*/createFluentIcon('StackStarRegular', "1em", ["M8 4.75c.19 0 .36.1.44.27l.88 1.68 1.74.2a.5.5 0 0 1 .25.9l-1.25 1 .43 1.84a.5.5 0 0 1-.75.54L8 10.14l-1.74 1.04a.5.5 0 0 1-.75-.54l.43-1.85-1.25-1a.5.5 0 0 1 .25-.88l1.74-.21.88-1.68A.5.5 0 0 1 8 4.75ZM2 5c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5Zm2-1a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1H4Zm2 11a2 2 0 0 1-1.73-1H12a3 3 0 0 0 3-3V5.27c.6.34 1 .99 1 1.73v4a4 4 0 0 1-4 4H6Zm2 2a2 2 0 0 1-1.73-1H12a5 5 0 0 0 5-5V7.27c.6.34 1 .99 1 1.73v2a6 6 0 0 1-6 6H8Z"]));
export const StackVerticalFilled = ( /*#__PURE__*/createFluentIcon('StackVerticalFilled', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v10.75a.75.75 0 0 1-1.5 0V13.5a1 1 0 0 0-1-1h-9a1 1 0 0 0-1 1v2.75a.75.75 0 0 1-1.5 0V5.5Zm1.5 5.7c.3-.13.64-.2 1-.2h9c.36 0 .7.07 1 .2V9.5a1 1 0 0 0-1-1h-9a1 1 0 0 0-1 1v1.7Zm11-5.7a1 1 0 0 0-1-1h-9a1 1 0 0 0-1 1v1.7c.3-.13.64-.2 1-.2h9c.36 0 .7.07 1 .2V5.5Z"]));
export const StackVerticalRegular = ( /*#__PURE__*/createFluentIcon('StackVerticalRegular', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v11a.5.5 0 0 1-1 0v-3c0-.83-.67-1.5-1.5-1.5h-9c-.83 0-1.5.67-1.5 1.5v3a.5.5 0 0 1-1 0v-11Zm1 6c.42-.31.94-.5 1.5-.5h9c.56 0 1.08.19 1.5.5v-2c0-.83-.67-1.5-1.5-1.5h-9C4.67 8 4 8.67 4 9.5v2Zm12-6c0-.83-.67-1.5-1.5-1.5h-9C4.67 4 4 4.67 4 5.5v2c.42-.31.94-.5 1.5-.5h9c.56 0 1.08.19 1.5.5v-2Z"]));
export const StarColor = ( /*#__PURE__*/createFluentIcon('StarColor', "1em", `<path d="M9.1 2.9a1 1 0 0 1 1.8 0l1.93 3.91 4.31.63a1 1 0 0 1 .56 1.7l-3.12 3.05.73 4.3a1 1 0 0 1-1.45 1.05L10 15.51l-3.86 2.03a1 1 0 0 1-1.45-1.05l.74-4.3L2.3 9.14a1 1 0 0 1 .56-1.7l4.31-.63L9.1 2.9Z" fill="url(#ic_fluent_star_20_color__a)"/><defs><linearGradient id="ic_fluent_star_20_color__a" x1="18" y1="18" x2="1.55" y2="2.48" gradientUnits="userSpaceOnUse"><stop stop-color="#FF6F47"/><stop offset="1" stop-color="#FFCD0F"/></linearGradient></defs>`, { color: true }));
export const StarFilled = ( /*#__PURE__*/createFluentIcon('StarFilled', "1em", ["M9.1 2.9a1 1 0 0 1 1.8 0l1.93 3.91 4.31.63a1 1 0 0 1 .56 1.7l-3.12 3.05.73 4.3a1 1 0 0 1-1.45 1.05L10 15.51l-3.86 2.03a1 1 0 0 1-1.45-1.05l.74-4.3L2.3 9.14a1 1 0 0 1 .56-1.7l4.31-.63L9.1 2.9Z"]));
export const StarRegular = ( /*#__PURE__*/createFluentIcon('StarRegular', "1em", ["M9.1 2.9a1 1 0 0 1 1.8 0l1.93 3.91 4.31.63a1 1 0 0 1 .56 1.7l-3.12 3.05.73 4.3a1 1 0 0 1-1.45 1.05L10 15.51l-3.86 2.03a1 1 0 0 1-1.45-1.05l.74-4.3L2.3 9.14a1 1 0 0 1 .56-1.7l4.31-.63L9.1 2.9Zm.9.44L8.07 7.25a1 1 0 0 1-.75.55L3 8.43l3.12 3.04a1 1 0 0 1 .3.89l-.75 4.3 3.87-2.03a1 1 0 0 1 .93 0l3.86 2.03-.74-4.3a1 1 0 0 1 .29-.89L17 8.43l-4.32-.63a1 1 0 0 1-.75-.55L10 3.35Z"]));
export const StarAddFilled = ( /*#__PURE__*/createFluentIcon('StarAddFilled', "1em", ["M9.1 2.9a1 1 0 0 1 1.8 0l1.93 3.91 4.31.63a1 1 0 0 1 .56 1.7l-.55.54a5.5 5.5 0 0 0-7.96 6.26l-3.05 1.6a1 1 0 0 1-1.45-1.05l.74-4.3L2.3 9.14a1 1 0 0 1 .56-1.7l4.31-.63L9.1 2.9ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 1 0 0 1H14v1.5a.5.5 0 1 0 1 0V15h1.5a.5.5 0 1 0 0-1H15v-1.5Z"]));
export const StarAddRegular = ( /*#__PURE__*/createFluentIcon('StarAddRegular', "1em", ["M9.1 2.9a1 1 0 0 1 1.8 0l1.93 3.91 4.31.63a1 1 0 0 1 .56 1.7l-.55.54a5.46 5.46 0 0 0-1-.43l.85-.82-4.32-.63a1 1 0 0 1-.75-.55L10 3.35l-1.93 3.9a1 1 0 0 1-.75.55L3 8.43l3.12 3.04a1 1 0 0 1 .3.89l-.75 4.3 3.35-1.76c.02.36.08.7.17 1.04l-3.05 1.6a1 1 0 0 1-1.45-1.05l.74-4.3L2.3 9.14a1 1 0 0 1 .56-1.7l4.31-.63L9.1 2.9ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 1 0 0 1H14v1.5a.5.5 0 1 0 1 0V15h1.5a.5.5 0 1 0 0-1H15v-1.5Z"]));
export const StarArrowBackFilled = ( /*#__PURE__*/createFluentIcon('StarArrowBackFilled', "1em", ["M9.1 2.9a1 1 0 0 1 1.8 0l1.93 3.91 4.31.63a1 1 0 0 1 .56 1.7l-.55.54a5.5 5.5 0 0 0-7.96 6.26l-3.05 1.6a1 1 0 0 1-1.45-1.05l.74-4.3L2.3 9.14a1 1 0 0 1 .56-1.7l4.31-.63L9.1 2.9ZM14.5 19a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm-.9-6.4-.9.9h1.55A2.75 2.75 0 0 1 17 16.25v.25a.5.5 0 0 1-1 0v-.25c0-.97-.78-1.75-1.75-1.75h-1.54l.9.9a.5.5 0 0 1-.71.7l-1.76-1.75a.5.5 0 0 1 0-.7l1.76-1.75a.5.5 0 0 1 .7.7Z"]));
export const StarArrowBackRegular = ( /*#__PURE__*/createFluentIcon('StarArrowBackRegular', "1em", ["M9.1 2.9a1 1 0 0 1 1.8 0l1.93 3.91 4.31.63a1 1 0 0 1 .56 1.7l-.55.54a5.47 5.47 0 0 0-1-.43l.85-.82-4.32-.63a1 1 0 0 1-.75-.55L10 3.35l-1.93 3.9a1 1 0 0 1-.75.55L3 8.43l3.12 3.04a1 1 0 0 1 .3.89l-.75 4.3 3.34-1.76c.03.36.09.7.18 1.04l-3.05 1.6a1 1 0 0 1-1.45-1.05l.74-4.3L2.3 9.14a1 1 0 0 1 .56-1.7l4.31-.63L9.1 2.9ZM14.5 19a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm-.9-6.4-.9.9h1.55A2.75 2.75 0 0 1 17 16.25v.25a.5.5 0 0 1-1 0v-.25c0-.97-.78-1.75-1.75-1.75h-1.54l.9.9a.5.5 0 0 1-.71.7l-1.76-1.75a.5.5 0 0 1 0-.7l1.76-1.75a.5.5 0 0 1 .7.7Z"]));
export const StarArrowRightEndFilled = ( /*#__PURE__*/createFluentIcon('StarArrowRightEndFilled', "1em", ["M10.9 2.56a1 1 0 0 0-1.8 0L7.17 6.45l-4.31.62a1 1 0 0 0-.56 1.7l3.13 3.03-.74 4.28a1 1 0 0 0 1.45 1.05l3.05-1.6a5.46 5.46 0 0 1 5.31-6.9c.96 0 1.86.24 2.65.67l.55-.53a1 1 0 0 0-.56-1.7l-4.31-.62-1.93-3.9ZM19 14.5a4.5 4.5 0 1 0-9 0 4.5 4.5 0 0 0 9 0Zm-4.15 2.35a.5.5 0 0 1-.7-.7L15.29 15H12.5a.5.5 0 0 1 0-1h2.8l-1.15-1.15a.5.5 0 0 1 .7-.7l2 2a.5.5 0 0 1 .15.35.5.5 0 0 1-.14.35l-2 2Z"]));
export const StarArrowRightEndRegular = ( /*#__PURE__*/createFluentIcon('StarArrowRightEndRegular', "1em", ["M10.9 2.56a1 1 0 0 0-1.8 0L7.17 6.45l-4.31.62a1 1 0 0 0-.56 1.7l3.13 3.03-.74 4.28a1 1 0 0 0 1.45 1.05l3.05-1.6a5.44 5.44 0 0 1-.17-1.03l-3.35 1.75.74-4.28a1 1 0 0 0-.29-.88L3 8.06l4.32-.63a1 1 0 0 0 .75-.54L10 2.99l1.93 3.9c.15.3.43.5.75.54l4.32.63-.85.82c.35.11.69.25 1 .42l.55-.53a1 1 0 0 0-.56-1.7l-4.31-.62-1.93-3.9ZM19 14.5a4.5 4.5 0 1 0-9 0 4.5 4.5 0 0 0 9 0Zm-4.15 2.35a.5.5 0 0 1-.7-.7L15.29 15H12.5a.5.5 0 0 1 0-1h2.8l-1.15-1.15a.5.5 0 0 1 .7-.7l2 2a.5.5 0 0 1 .15.35.5.5 0 0 1-.14.35l-2 2Z"]));
export const StarArrowRightStartFilled = ( /*#__PURE__*/createFluentIcon('StarArrowRightStartFilled', "1em", ["M9.1 2.56a1 1 0 0 1 1.8 0l1.93 3.9 4.31.64a1 1 0 0 1 .56 1.7l-3.13 3.05.74 4.3a1 1 0 0 1-1.45 1.05l-2.98-1.57a5.52 5.52 0 0 0-7.8-6.07L2.3 8.8a1 1 0 0 1 .56-1.7l4.31-.63L9.1 2.56ZM5.5 10a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9Zm2.35 4.85A.5.5 0 0 0 8 14.5a.5.5 0 0 0-.15-.35l-2-2a.5.5 0 0 0-.7.7L6.29 14H3.5a.5.5 0 0 0 0 1h2.8l-1.15 1.15a.5.5 0 0 0 .7.7l2-2Z"]));
export const StarArrowRightStartRegular = ( /*#__PURE__*/createFluentIcon('StarArrowRightStartRegular', "1em", ["M9.1 2.56a1 1 0 0 1 1.8 0l1.93 3.89 4.31.62a1 1 0 0 1 .56 1.7l-3.13 3.03.74 4.28a1 1 0 0 1-1.45 1.05l-2.97-1.55c.07-.35.1-.7.11-1.07l3.33 1.74-.74-4.28a1 1 0 0 1 .29-.88L17 8.06l-4.32-.63a1 1 0 0 1-.75-.54L10 2.99 8.07 6.9a1 1 0 0 1-.75.54L3 8.06l1.14 1.1c-.36.1-.7.23-1.04.39l-.8-.78a1 1 0 0 1 .56-1.7l4.31-.62 1.93-3.9ZM5.5 10a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9Zm2.35 4.85A.5.5 0 0 0 8 14.5a.5.5 0 0 0-.15-.35l-2-2a.5.5 0 0 0-.7.7L6.29 14H3.5a.5.5 0 0 0 0 1h2.8l-1.15 1.15a.5.5 0 0 0 .7.7l2-2Z"]));
export const StarCheckmarkFilled = ( /*#__PURE__*/createFluentIcon('StarCheckmarkFilled', "1em", ["M10.9 2.9a1 1 0 0 0-1.8 0L7.17 6.8l-4.31.63a1 1 0 0 0-.56 1.7l3.13 3.05-.74 4.3a1 1 0 0 0 1.45 1.05l3.05-1.6a5.5 5.5 0 0 1 7.96-6.26l.55-.54a1 1 0 0 0-.56-1.7l-4.31-.63L10.9 2.9ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15-1.85a.5.5 0 0 0-.7 0l-2.65 2.64-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l3-3a.5.5 0 0 0 0-.7Z"]));
export const StarCheckmarkRegular = ( /*#__PURE__*/createFluentIcon('StarCheckmarkRegular', "1em", ["M10.9 2.9a1 1 0 0 0-1.8 0L7.17 6.8l-4.31.63a1 1 0 0 0-.56 1.7l3.13 3.05-.74 4.3a1 1 0 0 0 1.45 1.05l3.05-1.6a5.49 5.49 0 0 1-.18-1.04l-3.34 1.76.74-4.3a1 1 0 0 0-.29-.89L3 8.43l4.32-.63a1 1 0 0 0 .75-.55L10 3.35l1.93 3.9c.15.3.43.5.75.55l4.32.63-.85.82c.35.11.69.26 1 .43l.55-.54a1 1 0 0 0-.56-1.7l-4.31-.63L10.9 2.9ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15-1.85a.5.5 0 0 0-.7 0l-2.65 2.64-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l3-3a.5.5 0 0 0 0-.7Z"]));
export const StarDismissFilled = ( /*#__PURE__*/createFluentIcon('StarDismissFilled', "1em", ["M9.1 2.9a1 1 0 0 1 1.8 0l1.93 3.91 4.31.63a1 1 0 0 1 .56 1.7l-.55.54a5.5 5.5 0 0 0-7.96 6.26l-3.05 1.6a1 1 0 0 1-1.45-1.05l.74-4.3L2.3 9.14a1 1 0 0 1 .56-1.7l4.31-.63L9.1 2.9ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.65-1.15a.5.5 0 0 0-.7-.7l-1.15 1.14-1.15-1.14a.5.5 0 0 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 0 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 0 0 .7-.7l-1.14-1.15 1.14-1.15Z"]));
export const StarDismissRegular = ( /*#__PURE__*/createFluentIcon('StarDismissRegular', "1em", ["M9.1 2.9a1 1 0 0 1 1.8 0l1.93 3.91 4.31.63a1 1 0 0 1 .56 1.7l-.55.54a5.47 5.47 0 0 0-1-.43l.85-.82-4.32-.63a1 1 0 0 1-.75-.55L10 3.35l-1.93 3.9a1 1 0 0 1-.75.55L3 8.43l3.12 3.04a1 1 0 0 1 .3.89l-.75 4.3 3.34-1.76c.03.36.09.7.18 1.04l-3.05 1.6a1 1 0 0 1-1.45-1.05l.74-4.3L2.3 9.14a1 1 0 0 1 .56-1.7l4.31-.63L9.1 2.9ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.65-1.15a.5.5 0 0 0-.7-.7l-1.15 1.14-1.15-1.14a.5.5 0 0 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 0 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 0 0 .7-.7l-1.14-1.15 1.14-1.15Z"]));
export const StarEditFilled = ( /*#__PURE__*/createFluentIcon('StarEditFilled', "1em", ["M10.9 2.9a1 1 0 0 0-1.8 0L7.17 6.8l-4.31.63a1 1 0 0 0-.56 1.7l3.13 3.05-.74 4.3a1 1 0 0 0 1.45 1.05l3.43-1.8c.16-.4.4-.76.7-1.07l4.83-4.83a2.87 2.87 0 0 1 2.67-.77 1 1 0 0 0-.63-1.63l-4.31-.63L10.9 2.9Zm4.9 7.65-4.82 4.83a2.2 2.2 0 0 0-.58 1.02l-.37 1.5a.89.89 0 0 0 1.08 1.07l1.5-.37c.38-.1.73-.3 1.01-.58l4.83-4.83a1.87 1.87 0 0 0-2.64-2.64Z"]));
export const StarEditRegular = ( /*#__PURE__*/createFluentIcon('StarEditRegular', "1em", ["M10.9 2.9a1 1 0 0 0-1.8 0L7.17 6.8l-4.31.63a1 1 0 0 0-.56 1.7l3.13 3.05-.74 4.3a1 1 0 0 0 1.45 1.05l3.43-1.8c.16-.4.4-.76.7-1.07l.1-.09a1 1 0 0 0-.83.05l-3.87 2.03.74-4.3a1 1 0 0 0-.29-.89L3 8.43l4.32-.63a1 1 0 0 0 .75-.55L10 3.35l1.93 3.9c.15.3.43.5.75.55l4.32.63-.72.7c.48-.15 1-.17 1.49-.06a1 1 0 0 0-.63-1.63l-4.31-.63L10.9 2.9Zm4.9 7.65-4.82 4.83a2.2 2.2 0 0 0-.58 1.02l-.37 1.5a.89.89 0 0 0 1.08 1.07l1.5-.37c.38-.1.73-.3 1.01-.58l4.83-4.83a1.87 1.87 0 0 0-2.64-2.64Z"]));
export const StarEmphasisFilled = ( /*#__PURE__*/createFluentIcon('StarEmphasisFilled', "1em", ["M9.1 2.9a1 1 0 0 1 1.8 0l1.93 3.91 4.31.63a1 1 0 0 1 .56 1.7l-3.12 3.05.73 4.3a1 1 0 0 1-1.45 1.05L10 15.51l-3.86 2.03a1 1 0 0 1-1.45-1.05l.74-4.3L2.3 9.14a1 1 0 0 1 .56-1.7l4.31-.63L9.1 2.9ZM4.4 12.69a.5.5 0 0 1-.08.7l-2.5 2a.5.5 0 1 1-.62-.78l2.5-2a.5.5 0 0 1 .7.08ZM4.31 5.1a.5.5 0 1 1-.62.78l-2.5-2a.5.5 0 1 1 .62-.78l2.5 2Zm11.3 7.58a.5.5 0 0 0 .08.7l2.5 2a.5.5 0 1 0 .62-.78l-2.5-2a.5.5 0 0 0-.7.08Zm.08-7.58a.5.5 0 0 0 .62.78l2.5-2a.5.5 0 1 0-.62-.78l-2.5 2Z"]));
export const StarEmphasisRegular = ( /*#__PURE__*/createFluentIcon('StarEmphasisRegular', "1em", ["M9.1 2.9a1 1 0 0 1 1.8 0l1.93 3.91 4.31.63a1 1 0 0 1 .56 1.7l-3.12 3.05.73 4.3a1 1 0 0 1-1.45 1.05L10 15.51l-3.86 2.03a1 1 0 0 1-1.45-1.05l.74-4.3L2.3 9.14a1 1 0 0 1 .56-1.7l4.31-.63L9.1 2.9Zm.9.44L8.07 7.25a1 1 0 0 1-.75.55L3 8.43l3.12 3.04a1 1 0 0 1 .3.89l-.75 4.3 3.87-2.03a1 1 0 0 1 .93 0l3.86 2.03-.74-4.3a1 1 0 0 1 .29-.89L17 8.43l-4.32-.63a1 1 0 0 1-.75-.55L10 3.35ZM4.4 12.7a.5.5 0 0 1-.08.7l-2.5 2a.5.5 0 1 1-.62-.78l2.5-2a.5.5 0 0 1 .7.08ZM4.31 5.1a.5.5 0 1 1-.62.78l-2.5-2a.5.5 0 1 1 .62-.78l2.5 2Zm11.3 7.58a.5.5 0 0 0 .08.7l2.5 2a.5.5 0 1 0 .62-.78l-2.5-2a.5.5 0 0 0-.7.08Zm.08-7.58a.5.5 0 0 0 .62.78l2.5-2a.5.5 0 1 0-.62-.78l-2.5 2Z"]));
export const StarHalfFilled = ( /*#__PURE__*/createFluentIcon('StarHalfFilled', "1em", ["M10 2.34a.99.99 0 0 0-.9.56L7.17 6.8l-4.31.63a1 1 0 0 0-.56 1.7l3.13 3.05-.74 4.3a1 1 0 0 0 1.45 1.05L10 15.51V2.34Z"]));
export const StarHalfRegular = ( /*#__PURE__*/createFluentIcon('StarHalfRegular', "1em", ["M9.1 2.9a.99.99 0 0 1 .9-.56c.36 0 .71.19.9.56l1.93 3.91 4.31.63a1 1 0 0 1 .56 1.7l-3.12 3.05.73 4.3a1 1 0 0 1-1.45 1.05L10 15.51l-3.86 2.03a1 1 0 0 1-1.45-1.05l.74-4.3L2.3 9.14a1 1 0 0 1 .56-1.7l4.31-.63L9.1 2.9ZM10 14.5a1 1 0 0 1 .47.12l3.86 2.03-.74-4.3a1 1 0 0 1 .29-.89L17 8.43l-4.32-.63a1 1 0 0 1-.75-.55L10 3.35V14.5Z"]));
export const StarLineHorizontal3Filled = ( /*#__PURE__*/createFluentIcon('StarLineHorizontal3Filled', "1em", ["M10.9 2.9a1 1 0 0 0-1.8 0L7.17 6.8l-4.31.63a1 1 0 0 0-.56 1.7l3.13 3.05-.74 4.3a1 1 0 0 0 1.45 1.05L11 14.98V13.5c0-.83.67-1.5 1.5-1.5a1.5 1.5 0 1 1 0-3 1.5 1.5 0 0 1-.07-3L10.9 2.9Zm1.6 7.1a.5.5 0 1 0 0 1h5a.5.5 0 1 0 0-1h-5ZM12 7.5c0-.28.23-.5.5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5Zm.5 5.5a.5.5 0 1 0 0 1h5a.5.5 0 1 0 0-1h-5Z"]));
export const StarLineHorizontal3Regular = ( /*#__PURE__*/createFluentIcon('StarLineHorizontal3Regular', "1em", ["M9.1 2.9a1 1 0 0 1 1.8 0L12.92 7h4.58a.5.5 0 1 1 0 1h-4.58a1 1 0 0 1-.9-.56L10 3.34 8.07 7.25a1 1 0 0 1-.75.55L3 8.43l3.12 3.04a1 1 0 0 1 .3.89l-.75 4.3 4.1-2.16a.5.5 0 0 1 .46.89l-4.09 2.15a1 1 0 0 1-1.45-1.05l.74-4.3L2.3 9.14a1 1 0 0 1 .56-1.7l4.31-.63L9.1 2.9Zm2.9 7.6c0-.28.22-.5.5-.5h5a.5.5 0 1 1 0 1h-5a.5.5 0 0 1-.5-.5Zm.5 2.5a.5.5 0 1 0 0 1h5a.5.5 0 0 0 0-1h-5Z"]));
export const StarOffFilled = ( /*#__PURE__*/createFluentIcon('StarOffFilled', "1em", ["M2.86 2.15a.5.5 0 1 0-.71.7l4.1 4.1-3.4.49a1 1 0 0 0-.55 1.7l3.13 3.05-.74 4.3a1 1 0 0 0 1.45 1.05L10 15.51l3.86 2.03a1 1 0 0 0 1.45-1.05l-.1-.57 1.94 1.93a.5.5 0 0 0 .7-.7l-15-15Zm11.72 10.04.05.32-6.87-6.88L9.1 2.9a1 1 0 0 1 1.8 0l1.93 3.91 4.31.63a1 1 0 0 1 .56 1.7l-3.12 3.05Z"]));
export const StarOffRegular = ( /*#__PURE__*/createFluentIcon('StarOffRegular', "1em", ["M2.86 2.15a.5.5 0 1 0-.71.7l4.1 4.1-3.4.49a1 1 0 0 0-.55 1.7l3.13 3.05-.74 4.3a1 1 0 0 0 1.45 1.05L10 15.51l3.86 2.03a1 1 0 0 0 1.45-1.05l-.1-.57 1.94 1.93a.5.5 0 0 0 .7-.7l-15-15ZM13.99 14.7l.34 1.96-3.86-2.03a1 1 0 0 0-.93 0l-3.87 2.03.74-4.3a1 1 0 0 0-.29-.89L3 8.43l4.12-.6L14 14.7Zm-.11-3.23a1 1 0 0 0-.13.16l.88.88-.05-.32 3.12-3.05a1 1 0 0 0-.56-1.7l-4.31-.63L10.9 2.9a1 1 0 0 0-1.8 0L7.76 5.63l.74.75L10 3.34l1.93 3.91c.15.3.43.5.75.55l4.32.63-3.12 3.04Z"]));
export const StarOneQuarterFilled = ( /*#__PURE__*/createFluentIcon('StarOneQuarterFilled', "1em", ["M8 5.14 7.17 6.8l-4.31.63a1 1 0 0 0-.56 1.7l3.13 3.05-.74 4.3a1 1 0 0 0 1.45 1.05L8 16.56V5.14Z"]));
export const StarOneQuarterRegular = ( /*#__PURE__*/createFluentIcon('StarOneQuarterRegular', "1em", ["M10.9 2.9a1 1 0 0 0-1.8 0L8 5.13l-.83 1.68-4.31.63a1 1 0 0 0-.56 1.7l3.13 3.05-.74 4.3a1 1 0 0 0 1.45 1.05L10 15.51l3.86 2.03a1 1 0 0 0 1.45-1.05l-.73-4.3 3.12-3.05a1 1 0 0 0-.55-1.7l-4.32-.63L10.9 2.9ZM8 15.43V7.37a1 1 0 0 0 .07-.12L10 3.35l1.93 3.9c.15.3.43.5.76.55l4.31.63-3.12 3.04a1 1 0 0 0-.29.89l.74 4.3-3.86-2.03a1 1 0 0 0-.93 0l-1.54.8Z"]));
export const StarProhibitedFilled = ( /*#__PURE__*/createFluentIcon('StarProhibitedFilled', "1em", ["M9.1 2.9a1 1 0 0 1 1.8 0l1.93 3.91 4.31.63a1 1 0 0 1 .56 1.7l-.55.54a5.5 5.5 0 0 0-7.96 6.26l-3.05 1.6a1 1 0 0 1-1.45-1.05l.74-4.3L2.3 9.14a1 1 0 0 1 .56-1.7l4.31-.63L9.1 2.9Zm.9 11.6a4.5 4.5 0 1 0 9 0 4.5 4.5 0 0 0-9 0Zm1 0a3.5 3.5 0 0 1 5.6-2.8l-4.9 4.9a3.48 3.48 0 0 1-.7-2.1Zm3.5 3.5c-.78 0-1.51-.26-2.1-.7l4.9-4.9a3.5 3.5 0 0 1-2.8 5.6Z"]));
export const StarProhibitedRegular = ( /*#__PURE__*/createFluentIcon('StarProhibitedRegular', "1em", ["M9.1 2.9a1 1 0 0 1 1.8 0l1.93 3.91 4.31.63a1 1 0 0 1 .56 1.7l-.55.54a5.46 5.46 0 0 0-1-.43l.85-.82-4.32-.63a1 1 0 0 1-.75-.55L10 3.35l-1.93 3.9a1 1 0 0 1-.75.55L3 8.43l3.12 3.04a1 1 0 0 1 .3.89l-.75 4.3 3.35-1.76c.02.36.08.7.17 1.04l-3.05 1.6a1 1 0 0 1-1.45-1.05l.74-4.3L2.3 9.14a1 1 0 0 1 .56-1.7l4.31-.63L9.1 2.9Zm.9 11.6a4.5 4.5 0 1 0 9 0 4.5 4.5 0 0 0-9 0Zm1 0a3.5 3.5 0 0 1 5.6-2.8l-4.9 4.9a3.48 3.48 0 0 1-.7-2.1Zm3.5 3.5c-.78 0-1.51-.26-2.1-.7l4.9-4.9a3.5 3.5 0 0 1-2.8 5.6Z"]));
export const StarSettingsColor = ( /*#__PURE__*/createFluentIcon('StarSettingsColor', "1em", `<path d="M9.1 2.9a1 1 0 0 1 1.8 0l1.93 3.91 4.31.63a1 1 0 0 1 .56 1.7l-3.12 3.05.14.83a1.5 1.5 0 0 0-1.58.85L10 15.5l-3.86 2.03a1 1 0 0 1-1.45-1.05l.74-4.3L2.3 9.14a1 1 0 0 1 .56-1.7l4.31-.63L9.1 2.9Z" fill="url(#ic_fluent_star_settings_20_color__a)"/><path d="M9.1 2.9a1 1 0 0 1 1.8 0l1.93 3.91 4.31.63a1 1 0 0 1 .56 1.7l-3.12 3.05.14.83a1.5 1.5 0 0 0-1.58.85L10 15.5l-3.86 2.03a1 1 0 0 1-1.45-1.05l.74-4.3L2.3 9.14a1 1 0 0 1 .56-1.7l4.31-.63L9.1 2.9Z" fill="url(#ic_fluent_star_settings_20_color__b)"/><path d="M9.1 2.9a1 1 0 0 1 1.8 0l1.93 3.91 4.31.63a1 1 0 0 1 .56 1.7l-3.12 3.05.14.83a1.5 1.5 0 0 0-1.58.85L10 15.5l-3.86 2.03a1 1 0 0 1-1.45-1.05l.74-4.3L2.3 9.14a1 1 0 0 1 .56-1.7l4.31-.63L9.1 2.9Z" fill="url(#ic_fluent_star_settings_20_color__c)" fill-opacity=".4"/><path d="M9.1 2.9a1 1 0 0 1 1.8 0l1.93 3.91 4.31.63a1 1 0 0 1 .56 1.7l-3.12 3.05.14.83a1.5 1.5 0 0 0-1.58.85L10 15.5l-3.86 2.03a1 1 0 0 1-1.45-1.05l.74-4.3L2.3 9.14a1 1 0 0 1 .56-1.7l4.31-.63L9.1 2.9Z" fill="url(#ic_fluent_star_settings_20_color__d)" fill-opacity=".4"/><path d="M9.1 2.9a1 1 0 0 1 1.8 0l1.93 3.91 4.31.63a1 1 0 0 1 .56 1.7l-3.12 3.05.14.83a1.5 1.5 0 0 0-1.58.85L10 15.5l-3.86 2.03a1 1 0 0 1-1.45-1.05l.74-4.3L2.3 9.14a1 1 0 0 1 .56-1.7l4.31-.63L9.1 2.9Z" fill="url(#ic_fluent_star_settings_20_color__e)" fill-opacity=".4"/><path d="M10.64 13.92a2 2 0 0 0 1.43-2.48l-.16-.55c.25-.2.53-.37.82-.5l.34.36a2 2 0 0 0 2.9 0l.33-.35c.3.14.58.32.84.52l-.13.42a2 2 0 0 0 1.46 2.52l.35.09a4.7 4.7 0 0 1 0 1.01l-.45.12a2 2 0 0 0-1.43 2.48l.15.55c-.25.2-.53.37-.82.5l-.34-.36a2 2 0 0 0-2.9 0l-.33.35c-.3-.14-.58-.32-.84-.52l.13-.42a2 2 0 0 0-1.46-2.52l-.35-.09a4.71 4.71 0 0 1 0-1.01l.46-.12Zm4.86.58a1 1 0 1 0-2 0 1 1 0 0 0 2 0Z" fill="url(#ic_fluent_star_settings_20_color__f)"/><defs><radialGradient id="ic_fluent_star_settings_20_color__b" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(-174.29 7.65 7.64) scale(10.0499 12.0275)"><stop offset=".39" stop-color="#EB4824" stop-opacity=".6"/><stop offset=".78" stop-color="#EB4824" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_star_settings_20_color__c" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(180 7.25 7.25) scale(6 2.62494)"><stop offset=".59" stop-color="#B03111"/><stop offset="1" stop-color="#B03111" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_star_settings_20_color__d" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(-3 -4.99994 2.38324 -1.42996 14.5 14.5)"><stop offset=".63" stop-color="#B03111"/><stop offset="1" stop-color="#B03111" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_star_settings_20_color__e" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(3 -5.49994 2.62157 1.42996 14.5 14.5)"><stop offset=".67" stop-color="#B03111"/><stop offset=".97" stop-color="#B03111" stop-opacity="0"/></radialGradient><linearGradient id="ic_fluent_star_settings_20_color__a" x1="18" y1="18" x2="1.55" y2="2.48" gradientUnits="userSpaceOnUse"><stop stop-color="#FF6F47"/><stop offset="1" stop-color="#FFCD0F"/></linearGradient><linearGradient id="ic_fluent_star_settings_20_color__f" x1="16.67" y1="18.29" x2="12.28" y2="10.74" gradientUnits="userSpaceOnUse"><stop stop-color="#70777D"/><stop offset="1" stop-color="#B9C0C7"/></linearGradient></defs>`, { color: true }));
export const StarSettingsFilled = ( /*#__PURE__*/createFluentIcon('StarSettingsFilled', "1em", ["M10.9 2.9a1 1 0 0 0-1.8 0L7.17 6.8l-4.31.63a1 1 0 0 0-.56 1.7l3.13 3.05-.74 4.3a1 1 0 0 0 1.45 1.05l3.05-1.6a5.5 5.5 0 0 1 7.96-6.26l.55-.54a1 1 0 0 0-.56-1.7l-4.31-.63L10.9 2.9Zm-.27 11.02-.46.12a4.74 4.74 0 0 0 .01 1.01l.35.09A2 2 0 0 1 12 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.15-.55a2 2 0 0 1 1.43-2.48l.46-.12a4.73 4.73 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 17 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.3.13-.57.3-.82.5l.16.55a2 2 0 0 1-1.44 2.48Zm4.87.58a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z"]));
export const StarSettingsRegular = ( /*#__PURE__*/createFluentIcon('StarSettingsRegular', "1em", ["M10.9 2.9a1 1 0 0 0-1.8 0L7.17 6.8l-4.31.63a1 1 0 0 0-.56 1.7l3.13 3.05-.74 4.3a1 1 0 0 0 1.45 1.05l3.05-1.6a5.49 5.49 0 0 1-.18-1.04l-3.34 1.76.74-4.3a1 1 0 0 0-.29-.89L3 8.43l4.32-.63a1 1 0 0 0 .75-.55L10 3.35l1.93 3.9c.15.3.43.5.75.55l4.32.63-.85.82c.35.11.69.26 1 .43l.55-.54a1 1 0 0 0-.56-1.7l-4.31-.63L10.9 2.9Zm-.27 11.02a2 2 0 0 0 1.44-2.48l-.16-.55c.25-.2.53-.37.82-.5l.34.36a2 2 0 0 0 2.9 0l.33-.35c.3.14.58.32.84.52l-.13.42a2 2 0 0 0 1.46 2.52l.35.09a4.7 4.7 0 0 1 0 1.01l-.45.12a2 2 0 0 0-1.43 2.48l.15.55c-.25.2-.53.37-.82.5l-.34-.36a2 2 0 0 0-2.9 0l-.33.35c-.3-.14-.58-.32-.84-.52l.13-.42a2 2 0 0 0-1.46-2.52l-.35-.09a4.71 4.71 0 0 1 0-1.01l.45-.12Zm4.87.58a1 1 0 1 0-2 0 1 1 0 0 0 2 0Z"]));
export const StarThreeQuarterFilled = ( /*#__PURE__*/createFluentIcon('StarThreeQuarterFilled', "1em", ["M12 5.13 10.9 2.9a1 1 0 0 0-1.8 0L7.17 6.8l-4.31.63a1 1 0 0 0-.56 1.7l3.13 3.05-.74 4.3a1 1 0 0 0 1.45 1.05L10 15.51l2 1.05V5.13Z"]));
export const StarThreeQuarterRegular = ( /*#__PURE__*/createFluentIcon('StarThreeQuarterRegular', "1em", ["m10.9 2.9 1.93 3.91 4.31.63a1 1 0 0 1 .56 1.7l-3.12 3.05.73 4.3a1 1 0 0 1-1.45 1.05L10 15.51l-3.86 2.03a1 1 0 0 1-1.45-1.05l.74-4.3L2.3 9.14a1 1 0 0 1 .56-1.7l4.31-.63L9.1 2.9a1 1 0 0 1 1.8 0ZM12 7.37v8.06l2.33 1.23-.74-4.3a1 1 0 0 1 .29-.89L17 8.43l-4.32-.63a1 1 0 0 1-.68-.43Z"]));
export const StatusFilled = ( /*#__PURE__*/createFluentIcon('StatusFilled', "1em", ["M17.35 2.65a2.62 2.62 0 0 0-3.7 0l-5.5 5.5a.5.5 0 0 0-.14.23l-1 4a.5.5 0 0 0 .61.6l4-1a.5.5 0 0 0 .23-.13l5.5-5.5a2.62 2.62 0 0 0 0-3.7Zm-1.4 6.53a6 6 0 1 1-5.12-5.12l.85-.86A7.02 7.02 0 0 0 3 10a7 7 0 1 0 13.8-1.68l-.86.86Z"]));
export const StatusRegular = ( /*#__PURE__*/createFluentIcon('StatusRegular', "1em", ["M17.35 2.65a2.62 2.62 0 0 0-3.7 0l-5.5 5.5a.5.5 0 0 0-.14.23l-1 4a.5.5 0 0 0 .61.6l4-1a.5.5 0 0 0 .23-.13l5.5-5.5a2.62 2.62 0 0 0 0-3.7Zm-3 .7a1.62 1.62 0 0 1 2.3 2.3l-5.4 5.4-3.06.76.76-3.05 5.4-5.4ZM10 4c.28 0 .55.02.82.06l.86-.86A7.02 7.02 0 0 0 3 10a7 7 0 1 0 13.8-1.68l-.86.86A6 6 0 1 1 10 4Z"]));
export const StepFilled = ( /*#__PURE__*/createFluentIcon('StepFilled', "1em", ["M13 2a1 1 0 0 0-1 1v4H8a1 1 0 0 0-1 1v4H3a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h12a3 3 0 0 0 3-3V3a1 1 0 0 0-1-1h-4Z"]));
export const StepRegular = ( /*#__PURE__*/createFluentIcon('StepRegular', "1em", ["M12 3a1 1 0 0 1 1-1h4a1 1 0 0 1 1 1v12a3 3 0 0 1-3 3H3a1 1 0 0 1-1-1v-4a1 1 0 0 1 1-1h4V8a1 1 0 0 1 1-1h4V3Zm5 0h-4v4a1 1 0 0 1-1 1H8v4a1 1 0 0 1-1 1H3v4h12a2 2 0 0 0 2-2V3Z"]));
export const StepsFilled = ( /*#__PURE__*/createFluentIcon('StepsFilled', "1em", ["M11 3a1 1 0 0 1 1-1h3a1 1 0 0 1 1 1v4h-1V3h-3v3a1 1 0 0 1-1 1H8v3a1 1 0 0 1-1 1H4v3h4v1H4a1 1 0 0 1-1-1v-3a1 1 0 0 1 1-1h3V7a1 1 0 0 1 1-1h3V3Zm2 6a1 1 0 0 1 1-1h3a1 1 0 0 1 1 1v5.5a2.5 2.5 0 0 1-2.5 2.5H10a1 1 0 0 1-1-1v-3a1 1 0 0 1 1-1h3V9Z"]));
export const StepsRegular = ( /*#__PURE__*/createFluentIcon('StepsRegular', "1em", ["M11 3a1 1 0 0 1 1-1h3a1 1 0 0 1 1 1v4h-1V3h-3v3a1 1 0 0 1-1 1H8v3a1 1 0 0 1-1 1H4v3h4v1H4a1 1 0 0 1-1-1v-3a1 1 0 0 1 1-1h3V7a1 1 0 0 1 1-1h3V3Zm3 5a1 1 0 0 0-1 1v3h-3a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h5.5a2.5 2.5 0 0 0 2.5-2.5V9a1 1 0 0 0-1-1h-3Zm0 1h3v5.5c0 .83-.67 1.5-1.5 1.5H10v-3h3a1 1 0 0 0 1-1V9Z"]));
export const StethoscopeFilled = ( /*#__PURE__*/createFluentIcon('StethoscopeFilled', "1em", ["M2.75 2a.75.75 0 0 0-.75.75v5a4.5 4.5 0 0 0 3.75 4.44v1.06a5.25 5.25 0 1 0 10.5 0v-1.1a2.75 2.75 0 1 0-1.5 0v1.1a3.75 3.75 0 1 1-7.5 0v-1.06A4.5 4.5 0 0 0 11 7.75v-5a.75.75 0 0 0-.75-.75h-1.5a.75.75 0 0 0 0 1.5h.75v4.25a3 3 0 1 1-6 0V3.5h.75a.75.75 0 0 0 0-1.5h-1.5ZM15.5 8.25a1.25 1.25 0 1 1 0 2.5 1.25 1.25 0 0 1 0-2.5Z"]));
export const StethoscopeRegular = ( /*#__PURE__*/createFluentIcon('StethoscopeRegular', "1em", ["M2.5 2a.5.5 0 0 0-.5.5v5a4.5 4.5 0 0 0 4 4.47V13a5 5 0 0 0 10 0v-1.05a2.5 2.5 0 1 0-1 0V13a4 4 0 1 1-8 0v-1.03a4.5 4.5 0 0 0 4-4.47v-5a.5.5 0 0 0-.5-.5h-2a.5.5 0 0 0 0 1H10v4.5a3.5 3.5 0 0 1-7 0V3h1.5a.5.5 0 0 0 0-1h-2Zm13 6a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3Z"]));
export const StickerFilled = ( /*#__PURE__*/createFluentIcon('StickerFilled', "1em", ["M6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h5v-3.08a5.87 5.87 0 0 1-3.47-.47 4.2 4.2 0 0 1-.86-.57l-.01-.02h-.01a.5.5 0 0 1 .7-.72 1 1 0 0 0 .14.12c.1.07.26.18.48.3A4.5 4.5 0 0 0 10 13c.43 0 .81-.05 1.15-.14a2.75 2.75 0 0 1 2.6-1.86H17V6a3 3 0 0 0-3-3H6Zm1.5 6a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm6-1a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-.7 8.41a2 2 0 0 1-.8.5v-3.16c0-.97.78-1.75 1.75-1.75h3.15a2 2 0 0 1-.49.8L12.8 16.4Z"]));
export const StickerRegular = ( /*#__PURE__*/createFluentIcon('StickerRegular', "1em", ["M7.5 9a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm6-1a1 1 0 1 1-2 0 1 1 0 0 1 2 0ZM3 6v8a3 3 0 0 0 3 3h5.38a1.97 1.97 0 0 0 1.41-.59l3.62-3.62a2 2 0 0 0 .59-1.41V6a3 3 0 0 0-3-3H6a3 3 0 0 0-3 3Zm13 0v5h-2.25c-1.2 0-2.24.78-2.6 1.86-.34.09-.72.14-1.15.14a4.5 4.5 0 0 1-2.51-.74 1.97 1.97 0 0 1-.14-.11.5.5 0 0 0-.7.7v.01l.02.02a2 2 0 0 0 .22.18 5.5 5.5 0 0 0 4.11.86V16H6a2 2 0 0 1-2-2V6c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2Zm-3.91 9.7a1 1 0 0 1-.09.08v-2.03c0-.97.78-1.75 1.75-1.75h2.03l-.07.09-3.62 3.62Z"]));
export const StickerAddFilled = ( /*#__PURE__*/createFluentIcon('StickerAddFilled', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v3.6a5.5 5.5 0 0 0-7.78 3.34 4.23 4.23 0 0 1-1.73-.68 1.97 1.97 0 0 1-.14-.11.5.5 0 0 0-.7.7v.01l.02.02a2 2 0 0 0 .22.18 5.22 5.22 0 0 0 2.14.87A5.56 5.56 0 0 0 9.6 17H6a3 3 0 0 1-3-3V6Zm4.5 3a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm6-1a1 1 0 1 0-2 0 1 1 0 0 0 2 0Zm5.5 6.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const StickerAddRegular = ( /*#__PURE__*/createFluentIcon('StickerAddRegular', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v3.6c-.32-.16-.65-.3-1-.4V6a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h3.2c.1.35.24.68.4 1H6a3 3 0 0 1-3-3V6Zm4.97 6.55c.3.15.72.31 1.25.4-.09.3-.16.64-.19.97a5.22 5.22 0 0 1-2.14-.86 2.93 2.93 0 0 1-.22-.18l-.01-.02h-.01a.5.5 0 0 1 .7-.72 1 1 0 0 0 .14.12c.1.07.26.18.48.3ZM7.5 9a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm6-1a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm5.5 6.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const StopFilled = ( /*#__PURE__*/createFluentIcon('StopFilled', "1em", ["M4.5 3C3.67 3 3 3.67 3 4.5v11c0 .83.67 1.5 1.5 1.5h11c.83 0 1.5-.67 1.5-1.5v-11c0-.83-.67-1.5-1.5-1.5h-11Z"]));
export const StopRegular = ( /*#__PURE__*/createFluentIcon('StopRegular', "1em", ["M15.5 4c.28 0 .5.22.5.5v11a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11c0-.28.22-.5.5-.5h11Zm-11-1C3.67 3 3 3.67 3 4.5v11c0 .83.67 1.5 1.5 1.5h11c.83 0 1.5-.67 1.5-1.5v-11c0-.83-.67-1.5-1.5-1.5h-11Z"]));
export const StorageFilled = ( /*#__PURE__*/createFluentIcon('StorageFilled', "1em", ["M2 8.5A2.5 2.5 0 0 1 4.5 6h11A2.5 2.5 0 0 1 18 8.5v3a2.5 2.5 0 0 1-2.5 2.5h-11A2.5 2.5 0 0 1 2 11.5v-3ZM13 9a1 1 0 1 0-2 0 1 1 0 0 0 2 0Zm3 0a1 1 0 1 0-2 0 1 1 0 0 0 2 0Z"]));
export const StorageRegular = ( /*#__PURE__*/createFluentIcon('StorageRegular', "1em", ["M13 9a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm2 1a1 1 0 1 0 0-2 1 1 0 0 0 0 2ZM2 8.5A2.5 2.5 0 0 1 4.5 6h11A2.5 2.5 0 0 1 18 8.5v3a2.5 2.5 0 0 1-2.5 2.5h-11A2.5 2.5 0 0 1 2 11.5v-3ZM4.5 7C3.67 7 3 7.67 3 8.5v3c0 .83.67 1.5 1.5 1.5h11c.83 0 1.5-.67 1.5-1.5v-3c0-.83-.67-1.5-1.5-1.5h-11Z"]));
export const StoreMicrosoftFilled = ( /*#__PURE__*/createFluentIcon('StoreMicrosoftFilled', "1em", ["M7 2.5V4H2.5a.5.5 0 0 0-.5.5v10A2.5 2.5 0 0 0 4.5 17h11a2.5 2.5 0 0 0 2.5-2.5v-10a.5.5 0 0 0-.5-.5H13V2.5c0-.83-.67-1.5-1.5-1.5h-3C7.67 1 7 1.67 7 2.5ZM8.5 2h3c.28 0 .5.22.5.5V4H8V2.5c0-.28.22-.5.5-.5Zm-2 8V7h3v3h-3Zm0 4v-3h3v3h-3Zm7-4h-3V7h3v3Zm-3 4v-3h3v3h-3Z"]));
export const StoreMicrosoftRegular = ( /*#__PURE__*/createFluentIcon('StoreMicrosoftRegular', "1em", ["M9.5 7v3h-3V7h3Zm0 7v-3h-3v3h3Zm4-7v3h-3V7h3Zm0 7v-3h-3v3h3ZM7 4V2.5C7 1.67 7.67 1 8.5 1h3c.83 0 1.5.67 1.5 1.5V4h4.5c.28 0 .5.22.5.5v10a2.5 2.5 0 0 1-2.5 2.5h-11A2.5 2.5 0 0 1 2 14.5v-10c0-.28.22-.5.5-.5H7Zm1-1.5V4h4V2.5a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0-.5.5Zm-5 12c0 .83.67 1.5 1.5 1.5h11c.83 0 1.5-.67 1.5-1.5V5H3v9.5Z"]));
export const StreamFilled = ( /*#__PURE__*/createFluentIcon('StreamFilled', "1em", ["M7.5 9.25a5.75 5.75 0 0 1 5.75-5.75h.5a.75.75 0 0 0 0-1.5h-.5C9.25 2 6 5.25 6 9.25v1c0 .41-.34.75-.75.75h-2.5a.75.75 0 0 0 0 1.5h2.5c1.24 0 2.25-1 2.25-2.25v-1Zm6.25-3A3.25 3.25 0 0 0 10.5 9.5v1a4.75 4.75 0 0 1-4.75 4.75h-3a.75.75 0 0 1 0-1.5h3c1.8 0 3.25-1.46 3.25-3.25v-1a4.75 4.75 0 0 1 4.75-4.75h3.5a.75.75 0 0 1 0 1.5h-3.5Zm.5 2.75a.75.75 0 0 0-.75.75v1c0 4-3.25 7.25-7.25 7.25h-.5a.75.75 0 0 1 0-1.5h.5A5.75 5.75 0 0 0 12 10.75v-1c0-1.24 1-2.25 2.25-2.25h3a.75.75 0 0 1 0 1.5h-3Z"]));
export const StreamRegular = ( /*#__PURE__*/createFluentIcon('StreamRegular', "1em", ["M7 9a6 6 0 0 1 6-6h.5a.5.5 0 0 0 0-1H13a7 7 0 0 0-7 7v1a1 1 0 0 1-1 1H2.5a.5.5 0 0 0 0 1H5a2 2 0 0 0 2-2V9Zm6.5-3A3.5 3.5 0 0 0 10 9.5v1A4.5 4.5 0 0 1 5.5 15h-3a.5.5 0 0 1 0-1h3A3.5 3.5 0 0 0 9 10.5v-1A4.5 4.5 0 0 1 13.5 5h4a.5.5 0 0 1 0 1h-4Zm.5 3a1 1 0 0 0-1 1v1a7 7 0 0 1-7 7h-.5a.5.5 0 0 1 0-1H6a6 6 0 0 0 6-6v-1c0-1.1.9-2 2-2h3.5a.5.5 0 0 1 0 1H14Z"]));
export const StreamInputFilled = ( /*#__PURE__*/createFluentIcon('StreamInputFilled', "1em", ["M7.5 9.25a5.75 5.75 0 0 1 5.75-5.75h.5a.75.75 0 0 0 0-1.5h-.5C9.25 2 6 5.25 6 9.25v1c0 .41-.34.75-.75.75H4.9l1.3 1.3a2.25 2.25 0 0 0 1.3-2.05v-1ZM6.4 16.5l-1.23 1.23c.14.16.35.27.58.27h.5c4 0 7.25-3.25 7.25-7.25v-1c0-.41.34-.75.75-.75h3a.75.75 0 0 0 0-1.5h-3c-1.24 0-2.25 1-2.25 2.25v1c0 3.12-2.5 5.67-5.6 5.75Zm.8-3.09c.26.48.34 1.02.23 1.53a4.75 4.75 0 0 0 3.07-4.44v-1c0-1.8 1.46-3.25 3.25-3.25h3.5a.75.75 0 0 0 0-1.5h-3.5A4.75 4.75 0 0 0 9 9.5v1c0 1.28-.74 2.38-1.8 2.91Zm-5.48-2.44c.3-.3.77-.3 1.06 0l3 3c.3.3.3.77 0 1.06l-3 3a.75.75 0 0 1-1.06-1.06l1.72-1.72H.75a.75.75 0 0 1 0-1.5h2.69l-1.72-1.72a.75.75 0 0 1 0-1.06Z"]));
export const StreamInputRegular = ( /*#__PURE__*/createFluentIcon('StreamInputRegular', "1em", ["M7 9a6 6 0 0 1 6-6h.5a.5.5 0 0 0 0-1H13a7 7 0 0 0-7 7v1a1 1 0 0 1-1 1h-.9l1 1A2 2 0 0 0 7 10V9ZM.5 14a.5.5 0 0 0 0 1h3.68l-2.14 2.15a.5.5 0 0 0 .7.7l3-2.99a.5.5 0 0 0 0-.72l-3-3a.5.5 0 0 0-.7.71L4.18 14H.5Zm9.5-3.5a4.5 4.5 0 0 1-3.15 4.3c.06-.35.01-.7-.12-1.02A3.5 3.5 0 0 0 9 10.5v-1A4.5 4.5 0 0 1 13.5 5h4a.5.5 0 0 1 0 1h-4A3.5 3.5 0 0 0 10 9.5v1ZM14 9a1 1 0 0 0-1 1v1a7 7 0 0 1-7 7h-.5a.5.5 0 0 1 0-1H6a6 6 0 0 0 6-6v-1c0-1.1.9-2 2-2h3.5a.5.5 0 0 1 0 1H14Z"]));
export const StreamInputOutputFilled = ( /*#__PURE__*/createFluentIcon('StreamInputOutputFilled', "1em", ["M13.25 3.5A5.75 5.75 0 0 0 7.5 9.25v1c0 1.24-1 2.25-2.25 2.25h-2.5a.75.75 0 0 1 0-1.5h2.5c.41 0 .75-.34.75-.75v-1C6 5.25 9.25 2 13.25 2h.5a.75.75 0 0 1 0 1.5h-.5Zm-2.75 6c0-1.8 1.46-3.25 3.25-3.25h3.5a.75.75 0 0 0 0-1.5h-3.5A4.75 4.75 0 0 0 9 9.5v1c0 1.8-1.46 3.25-3.25 3.25h-3a.75.75 0 0 0 0 1.5h3a4.75 4.75 0 0 0 4.75-4.75v-1Zm3.75-.5a.75.75 0 0 0-.75.75v1c0 .66-.09 1.3-.25 1.9a1.9 1.9 0 0 0-1.59.05c.22-.61.34-1.27.34-1.95v-1c0-1.24 1-2.25 2.25-2.25h3a.75.75 0 0 1 0 1.5h-3Zm-1.4 9.16a.5.5 0 0 1-.7.7l-2-2a.5.5 0 0 1 0-.7l2-2a.5.5 0 0 1 .7.7l-1.14 1.16h5.58l-1.14-1.15a.5.5 0 0 1 .7-.7l2 2c.2.19.2.5 0 .7l-2 2a.5.5 0 0 1-.7-.7l1.14-1.15h-5.58l1.14 1.14Z"]));
export const StreamInputOutputRegular = ( /*#__PURE__*/createFluentIcon('StreamInputOutputRegular', "1em", ["M13 3a6 6 0 0 0-6 6v1a2 2 0 0 1-2 2H2.5a.5.5 0 0 1 0-1H5a1 1 0 0 0 1-1V9a7 7 0 0 1 7-7h.5a.5.5 0 0 1 0 1H13Zm-3 6.5A3.5 3.5 0 0 1 13.5 6h4a.5.5 0 0 0 0-1h-4A4.5 4.5 0 0 0 9 9.5v1A3.5 3.5 0 0 1 5.5 14h-3a.5.5 0 0 0 0 1h3a4.5 4.5 0 0 0 4.5-4.5v-1Zm3 .5c0-.6.4-1 1-1h3.5c.3 0 .5-.2.5-.5s-.2-.5-.5-.5H14a2 2 0 0 0-2 2v1c0 .9-.2 1.7-.5 2.4.3-.2.6-.4 1-.4h.2c.2-.6.3-1.3.3-2v-1Zm-.15 8.16a.5.5 0 0 1-.7.7l-2-2a.5.5 0 0 1 0-.7l2-2a.5.5 0 0 1 .7.7l-1.14 1.16h5.58l-1.14-1.15a.5.5 0 0 1 .7-.7l2 2c.2.19.2.5 0 .7l-2 2a.5.5 0 0 1-.7-.7l1.14-1.15h-5.58l1.14 1.14Z"]));
export const StreamOutputFilled = ( /*#__PURE__*/createFluentIcon('StreamOutputFilled', "1em", ["M16.78 1.97a.75.75 0 1 0-1.06 1.06l1.72 1.72h-3.69A4.75 4.75 0 0 0 9 9.5v1c0 1.8-1.46 3.25-3.25 3.25h-3a.75.75 0 0 0 0 1.5h3a4.75 4.75 0 0 0 4.75-4.75v-1c0-1.8 1.46-3.25 3.25-3.25h3.69l-1.72 1.72a.75.75 0 0 0 1.06 1.06l3-3c.3-.3.3-.77 0-1.06l-3-3ZM13.25 3.5A5.75 5.75 0 0 0 7.5 9.25v1c0 1.24-1 2.25-2.25 2.25h-2.5a.75.75 0 0 1 0-1.5h2.5c.41 0 .75-.34.75-.75v-1C6 5.25 9.25 2 13.25 2h.5a.75.75 0 0 1 0 1.5h-.5Zm.91 4c-.24.49-.3 1.03-.17 1.54-.28.1-.49.39-.49.71v1c0 4-3.25 7.25-7.25 7.25h-.5a.75.75 0 0 1 0-1.5h.5A5.75 5.75 0 0 0 12 10.75v-1c0-1.21.96-2.2 2.16-2.25Z"]));
export const StreamOutputRegular = ( /*#__PURE__*/createFluentIcon('StreamOutputRegular', "1em", ["M16.15 2.15c.2-.2.5-.2.7 0l3 2.99a.5.5 0 0 1 0 .72l-3 3a.5.5 0 0 1-.7-.71L18.29 6H13.5C11.6 6 10 7.6 10 9.5v1C10 13 8 15 5.5 15h-3c-.3 0-.5-.2-.5-.5s.2-.5.5-.5h3C7.4 14 9 12.4 9 10.5v-1C9 7 11 5 13.5 5h4.8l-2.15-2.15a.5.5 0 0 1 0-.7ZM2.5 12H5a2 2 0 0 0 2-2V9c0-3.3 2.7-6 6-6h.5c.3 0 .5-.2.5-.5s-.2-.5-.5-.5H13C9.1 2 6 5.1 6 9v1c0 .6-.4 1-1 1H2.5c-.3 0-.5.2-.5.5s.2.5.5.5Zm12.6-4H14a2 2 0 0 0-2 2v1c0 3.3-2.7 6-6 6h-.5c-.3 0-.5.2-.5.5s.2.5.5.5H6c3.9 0 7-3.1 7-7v-1c0-.6.4-1 1-1h1.1c-.1-.3-.1-.7 0-1Z"]));
export const StreetSignFilled = ( /*#__PURE__*/createFluentIcon('StreetSignFilled', "1em", ["M7 4a2 2 0 1 1 4 0v1h2.38a2 2 0 0 1 1.41.59l2.06 2.06a.5.5 0 0 1 0 .7l-2.06 2.06a2 2 0 0 1-1.41.59H11v6a1 1 0 0 1-1 1H8a1 1 0 0 1-1-1v-6H5a2 2 0 0 1-2-2V7c0-1.1.9-2 2-2h2V4Zm3 0a1 1 0 0 0-2 0v1h2V4ZM8 17h2v-6H8v6Z"]));
export const StreetSignRegular = ( /*#__PURE__*/createFluentIcon('StreetSignRegular', "1em", ["M7 4a2 2 0 1 1 4 0v1h2.38a2 2 0 0 1 1.41.59l2.06 2.06a.5.5 0 0 1 0 .7l-2.06 2.06a2 2 0 0 1-1.41.59H11v6a1 1 0 0 1-1 1H8a1 1 0 0 1-1-1v-6H5a2 2 0 0 1-2-2V7c0-1.1.9-2 2-2h2V4Zm1 1h2V4a1 1 0 0 0-2 0v1Zm0 6v6h2v-6H8ZM4 7v2a1 1 0 0 0 1 1h8.38a1 1 0 0 0 .7-.3L15.8 8l-1.7-1.7a1 1 0 0 0-.71-.3H5a1 1 0 0 0-1 1Z"]));
export const StyleGuideFilled = ( /*#__PURE__*/createFluentIcon('StyleGuideFilled', "1em", ["M6.82 17.26c.07.27.19.52.33.74H7a2 2 0 0 1-2-2v-5.54l1.82 6.8ZM4 16.5c0 .15.01.3.04.44l-.06-.01a2 2 0 0 1-1.41-2.45l1.42-5.34L4 16.5Zm3.65.02a2 2 0 0 0 2.46 1.41l5.41-1.45a2 2 0 0 0 1.41-2.45L14.1 3.48a2 2 0 0 0-2.45-1.41L6.23 3.52a2 2 0 0 0-1.41 2.45l2.83 10.55ZM9 6.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Z"]));
export const StyleGuideRegular = ( /*#__PURE__*/createFluentIcon('StyleGuideRegular', "1em", ["M8.62 16.26a1 1 0 0 0 1.23.7l5.41-1.45a1 1 0 0 0 .7-1.22L13.14 3.74a1 1 0 0 0-1.22-.7L6.49 4.48a1 1 0 0 0-.7 1.22l2.83 10.55Zm1.49 1.67a2 2 0 0 1-2.46-1.41L4.82 5.97a2 2 0 0 1 1.41-2.45l5.42-1.45a2 2 0 0 1 2.45 1.41l2.83 10.55a2 2 0 0 1-1.4 2.45l-5.42 1.45ZM7 18h.14a2.48 2.48 0 0 1-.33-.74l-.08-.3A1 1 0 0 1 6 16v-1.79l-1-3.73V16a2 2 0 0 0 2 2ZM4 16.5c0 .15.01.3.04.45l-.06-.02a2 2 0 0 1-1.41-2.45l1.42-5.33v3.86l-.46 1.73A1 1 0 0 0 4 15.86v.64Zm4.25-11a.75.75 0 1 1 0 1.5.75.75 0 0 1 0-1.5Z"]));
export const SubGridFilled = ( /*#__PURE__*/createFluentIcon('SubGridFilled', "1em", ["M6 10.5v2c0 .83.67 1.5 1.5 1.5h2v-3.5H6Zm0-1v-2C6 6.67 6.67 6 7.5 6h2v3.5H6ZM10.5 6v3.5H14v-2c0-.83-.67-1.5-1.5-1.5h-2Zm3.5 4.5h-3.5V14h2c.83 0 1.5-.67 1.5-1.5v-2ZM6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6Zm-2 7.5h2v-1H4V6c0-1.1.9-2 2-2h3.5v2h1V4H14a2 2 0 0 1 2 2v3.5h-2v1h2V14a2 2 0 0 1-2 2h-3.5v-2h-1v2H6a2 2 0 0 1-2-2v-3.5Z"]));
export const SubGridRegular = ( /*#__PURE__*/createFluentIcon('SubGridRegular', "1em", ["M6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6ZM4 14v-3.5h2v2c0 .83.67 1.5 1.5 1.5h2v2H6a2 2 0 0 1-2-2Zm6.5 0h2c.83 0 1.5-.67 1.5-1.5v-2h2V14a2 2 0 0 1-2 2h-3.5v-2Zm2.5-3.5v2a.5.5 0 0 1-.5.5h-2v-2.5H13Zm1-1v-2c0-.83-.67-1.5-1.5-1.5h-2V4H14a2 2 0 0 1 2 2v3.5h-2ZM10.5 7h2c.28 0 .5.22.5.5v2h-2.5V7Zm-1-1h-2C6.67 6 6 6.67 6 7.5v2H4V6c0-1.1.9-2 2-2h3.5v2ZM7 9.5v-2c0-.28.22-.5.5-.5h2v2.5H7Zm0 1h2.5V13h-2a.5.5 0 0 1-.5-.5v-2Z"]));
export const SubtitlesFilled = ( /*#__PURE__*/createFluentIcon('SubtitlesFilled', "1em", ["M2 6.75A2.75 2.75 0 0 1 4.75 4h10.5A2.75 2.75 0 0 1 18 6.75v6.5A2.75 2.75 0 0 1 15.25 16H4.75A2.75 2.75 0 0 1 2 13.25v-6.5Zm2 4.75c0 .28.22.5.5.5h7a.5.5 0 0 0 0-1h-7a.5.5 0 0 0-.5.5Zm.5 1.5a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3Zm8.5-1.5c0 .28.22.5.5.5h2a.5.5 0 0 0 0-1h-2a.5.5 0 0 0-.5.5ZM9.5 13a.5.5 0 0 0 0 1h6a.5.5 0 0 0 0-1h-6Z"]));
export const SubtitlesRegular = ( /*#__PURE__*/createFluentIcon('SubtitlesRegular', "1em", ["M2 6.75A2.75 2.75 0 0 1 4.75 4h10.5A2.75 2.75 0 0 1 18 6.75v6.5A2.75 2.75 0 0 1 15.25 16H4.75A2.75 2.75 0 0 1 2 13.25v-6.5ZM4.75 5C3.78 5 3 5.78 3 6.75v6.5c0 .97.78 1.75 1.75 1.75h10.5c.97 0 1.75-.78 1.75-1.75v-6.5C17 5.78 16.22 5 15.25 5H4.75ZM4 11.5c0-.28.22-.5.5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5Zm.5 1.5a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3Zm8.5-1.5c0-.28.22-.5.5-.5h2a.5.5 0 0 1 0 1h-2a.5.5 0 0 1-.5-.5ZM9.5 13a.5.5 0 0 0 0 1h6a.5.5 0 0 0 0-1h-6Z"]));
export const SubtractFilled = ( /*#__PURE__*/createFluentIcon('SubtractFilled', "1em", ["M3 10c0-.41.34-.75.75-.75h12.5a.75.75 0 0 1 0 1.5H3.75A.75.75 0 0 1 3 10Z"]));
export const SubtractRegular = ( /*#__PURE__*/createFluentIcon('SubtractRegular', "1em", ["M3 10c0-.28.22-.5.5-.5h13a.5.5 0 0 1 0 1h-13A.5.5 0 0 1 3 10Z"]));
export const SubtractCircleFilled = ( /*#__PURE__*/createFluentIcon('SubtractCircleFilled', "1em", ["M18 10a8 8 0 1 1-16 0 8 8 0 0 1 16 0ZM6 10c0 .28.22.5.5.5h7a.5.5 0 0 0 0-1h-7a.5.5 0 0 0-.5.5Z"]));
export const SubtractCircleRegular = ( /*#__PURE__*/createFluentIcon('SubtractCircleRegular', "1em", ["M6 10c0-.28.22-.5.5-.5h7a.5.5 0 0 1 0 1h-7A.5.5 0 0 1 6 10Zm4 8a8 8 0 1 0 0-16 8 8 0 0 0 0 16Zm0-1a7 7 0 1 1 0-14 7 7 0 0 1 0 14Z"]));
export const SubtractCircleArrowBackFilled = ( /*#__PURE__*/createFluentIcon('SubtractCircleArrowBackFilled', "1em", ["M16.98 9.59 17 9a8 8 0 1 0-7.41 7.98A5.48 5.48 0 0 1 12.2 9.5H5.5a.5.5 0 0 1 0-1h7a.5.5 0 0 1 .45.72 5.5 5.5 0 0 1 4.03.37ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-5.4-2.6a.5.5 0 0 0-.7 0l-1.75 1.75a.5.5 0 0 0 0 .7l1.75 1.75a.5.5 0 0 0 .7-.7l-.9-.9h1.55c.97 0 1.75.78 1.75 1.75v.25a.5.5 0 0 0 1 0v-.25a2.75 2.75 0 0 0-2.75-2.75h-1.54l.9-.9a.5.5 0 0 0 0-.7Z"]));
export const SubtractCircleArrowBackRegular = ( /*#__PURE__*/createFluentIcon('SubtractCircleArrowBackRegular', "1em", ["M5.5 8.5a.5.5 0 0 0 0 1h6.7c.24-.11.5-.2.75-.28a.5.5 0 0 0-.45-.72h-7Zm10.5.7V9a7 7 0 1 0-6.8 7c.1.34.23.67.39.98L9 17a8 8 0 1 1 7.98-7.41A5.46 5.46 0 0 0 16 9.2Zm3 5.3a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-5.4-2.6a.5.5 0 0 0-.7 0l-1.75 1.75a.5.5 0 0 0 0 .7l1.75 1.75a.5.5 0 0 0 .7-.7l-.9-.9h1.55c.97 0 1.75.78 1.75 1.75v.25a.5.5 0 0 0 1 0v-.25a2.75 2.75 0 0 0-2.75-2.75h-1.54l.9-.9a.5.5 0 0 0 0-.7Z"]));
export const SubtractCircleArrowForwardFilled = ( /*#__PURE__*/createFluentIcon('SubtractCircleArrowForwardFilled', "1em", ["M16.98 9.59 17 9a8 8 0 1 0-7.41 7.98A5.48 5.48 0 0 1 12.2 9.5H5.5a.5.5 0 0 1 0-1h7a.5.5 0 0 1 .45.72 5.5 5.5 0 0 1 4.03.37ZM10 14.5a4.5 4.5 0 1 0 9 0 4.5 4.5 0 0 0-9 0Zm5.4-2.6c.2-.2.5-.2.7 0l1.75 1.75a.5.5 0 0 1 0 .7L16.1 16.1a.5.5 0 0 1-.7-.7l.9-.9h-1.55c-.97 0-1.75.78-1.75 1.75v.25a.5.5 0 0 1-1 0v-.25a2.75 2.75 0 0 1 2.75-2.75h1.54l-.9-.9a.5.5 0 0 1 0-.7Z"]));
export const SubtractCircleArrowForwardRegular = ( /*#__PURE__*/createFluentIcon('SubtractCircleArrowForwardRegular', "1em", ["M5.5 8.5a.5.5 0 0 0 0 1h6.7c.24-.11.5-.2.75-.28a.5.5 0 0 0-.45-.72h-7Zm10.5.7V9a7 7 0 1 0-6.8 7c.1.34.23.67.39.98L9 17a8 8 0 1 1 7.98-7.41A5.46 5.46 0 0 0 16 9.2Zm-6 5.3a4.5 4.5 0 1 0 9 0 4.5 4.5 0 0 0-9 0Zm5.4-2.6c.2-.2.5-.2.7 0l1.75 1.75a.5.5 0 0 1 0 .7L16.1 16.1a.5.5 0 0 1-.7-.7l.9-.9h-1.55c-.97 0-1.75.78-1.75 1.75v.25a.5.5 0 0 1-1 0v-.25a2.75 2.75 0 0 1 2.75-2.75h1.54l-.9-.9a.5.5 0 0 1 0-.7Z"]));
export const SubtractParenthesesFilled = ( /*#__PURE__*/createFluentIcon('SubtractParenthesesFilled', "1em", ["M5.77 5.07a.75.75 0 1 0-.98-1.14 7.98 7.98 0 0 0 0 12.14.75.75 0 1 0 .98-1.14 6.48 6.48 0 0 1 0-9.86Zm9.44-1.14a.75.75 0 1 0-.98 1.14 6.48 6.48 0 0 1 0 9.86.75.75 0 1 0 .98 1.14 7.98 7.98 0 0 0 0-12.14ZM6.75 9.25a.75.75 0 0 0 0 1.5h6.5a.75.75 0 0 0 0-1.5h-6.5Z"]));
export const SubtractParenthesesRegular = ( /*#__PURE__*/createFluentIcon('SubtractParenthesesRegular', "1em", ["M5.8 4.4a.5.5 0 0 0-.6-.8 7.99 7.99 0 0 0 0 12.8.5.5 0 0 0 .6-.8 6.99 6.99 0 0 1 0-11.2Zm9-.8a.5.5 0 0 0-.6.8 6.99 6.99 0 0 1 0 11.2.5.5 0 1 0 .6.8 7.99 7.99 0 0 0 0-12.8ZM6.5 9.5a.5.5 0 1 0 0 1h7a.5.5 0 1 0 0-1h-7Z"]));
export const SubtractSquareFilled = ( /*#__PURE__*/createFluentIcon('SubtractSquareFilled', "1em", ["M6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6Zm.5 6.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1 0-1Z"]));
export const SubtractSquareRegular = ( /*#__PURE__*/createFluentIcon('SubtractSquareRegular', "1em", ["M6.5 9.5a.5.5 0 0 0 0 1h7a.5.5 0 0 0 0-1h-7ZM6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6ZM4 6c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V6Z"]));
export const SubtractSquareMultipleFilled = ( /*#__PURE__*/createFluentIcon('SubtractSquareMultipleFilled', "1em", ["M16 5.27c.6.34 1 .99 1 1.73v6a4 4 0 0 1-4 4H7a2 2 0 0 1-1.73-1H13a3 3 0 0 0 3-3V5.27ZM15 5a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V5Zm-3 4a.5.5 0 0 1-.5.5h-5a.5.5 0 1 1 0-1h5c.28 0 .5.22.5.5Z"]));
export const SubtractSquareMultipleRegular = ( /*#__PURE__*/createFluentIcon('SubtractSquareMultipleRegular', "1em", ["M16 5.27V13a3 3 0 0 1-3 3H5.27c.34.6.99 1 1.73 1h6a4 4 0 0 0 4-4V7a2 2 0 0 0-1-1.73ZM11.5 9.5a.5.5 0 0 0 0-1h-5a.5.5 0 1 0 0 1h5ZM13 3a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5c0-1.1.9-2 2-2h8Zm1 2a1 1 0 0 0-1-1H5a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V5Z"]));
export const SurfaceEarbudsFilled = ( /*#__PURE__*/createFluentIcon('SurfaceEarbudsFilled', "1em", ["M8.55 14.03a5.75 5.75 0 0 0 2.9 4.24l-1.4.57a2 2 0 0 1-2.37-.66l-.27-.37a2 2 0 0 1 .06-2.44l1.08-1.34Zm5.7-5.53a4.75 4.75 0 1 1 0 9.5 4.75 4.75 0 0 1 0-9.5ZM5.75 1c.2 0 .39.01.58.03l.28.05-.14.04A3.72 3.72 0 0 0 4.54 6.6a3.65 3.65 0 0 0 5.75.56A4.75 4.75 0 1 1 5.75 1Zm5.37.46.09.1.09.12.44.65a1.5 1.5 0 0 1-.03 1.72l-.09.12-1.88 2.18a2.65 2.65 0 0 1-4.26-.18 2.72 2.72 0 0 1 1.43-4.1l2.62-.97a1.5 1.5 0 0 1 1.59.36Zm-1.14.68a.5.5 0 0 0-.2.61l.03.08.26.43.06.07a.5.5 0 0 0 .84-.5l-.04-.09-.26-.43-.05-.07a.5.5 0 0 0-.64-.1Z"]));
export const SurfaceEarbudsRegular = ( /*#__PURE__*/createFluentIcon('SurfaceEarbudsRegular', "1em", ["M14.13 8.25a4.87 4.87 0 1 1-1.1 9.63l-.1.03-2.21.9c-1 .41-2.15.13-2.85-.68l-.1-.15-.28-.36a2.5 2.5 0 0 1-.04-2.91l.1-.15 1.58-1.94.17-.2a4.87 4.87 0 0 1 4.83-4.17Zm-4.8 5.72-1 1.22a1.5 1.5 0 0 0-.12 1.71l.08.12.28.37a1.5 1.5 0 0 0 1.63.55l.14-.05 1.34-.55a4.88 4.88 0 0 1-2.36-3.37Zm4.8-4.72a3.88 3.88 0 0 0-3.76 2.93l-.07.3-.03.25-.01.18v.21c0 1.78 1.18 3.28 2.81 3.74l.2.04.22.05.2.02.17.02H14.33a3.88 3.88 0 0 0-.2-7.74ZM5.88 1c.66 0 1.29.13 1.86.37l.7-.23a2.5 2.5 0 0 1 2.66.73l.12.14.12.17.29.46c.53.84.5 1.91-.05 2.74l-.1.15-.13.14-.62.67A4.88 4.88 0 1 1 5.88 1Zm-.04 1h.04A3.87 3.87 0 1 0 9.1 8.02l-.06.04-.2.13a3.44 3.44 0 0 1-4.77-1.05A3.5 3.5 0 0 1 5.61 2.1l.23-.1Zm4.58.61a1.5 1.5 0 0 0-1.53-.56l-.14.04-2.36.78a2.5 2.5 0 0 0-1.46 3.74 2.44 2.44 0 0 0 3.75.46l.16-.16L10.6 5l.1-.11a1.5 1.5 0 0 0 .15-1.6l-.07-.12-.28-.45-.08-.12Zm-.8.53.05.08.26.42a.5.5 0 0 1-.8.6l-.06-.08-.26-.43a.5.5 0 0 1 .8-.59Z"]));
export const SurfaceHubFilled = ( /*#__PURE__*/createFluentIcon('SurfaceHubFilled', "1em", ["M5.26 2a.5.5 0 0 0-.5.45l-.76 8a.5.5 0 0 0 .5.55h2.42l-.91 6.43a.5.5 0 0 0 .98.14L7.36 15h3L10 17.43a.5.5 0 0 0 .98.14l.37-2.57h2.28l.37 2.57a.5.5 0 0 0 .98-.14L14.08 11h.66a.5.5 0 0 0 .5-.45l.76-8a.5.5 0 0 0-.5-.55H5.26Zm8.23 12h-1.98l.42-3h1.14l.42 3Zm-3 0H7.51l.42-3h3l-.44 3Z"]));
export const SurfaceHubRegular = ( /*#__PURE__*/createFluentIcon('SurfaceHubRegular', "1em", ["M4.76 2.45a.5.5 0 0 1 .5-.45H15.5a.5.5 0 0 1 .5.55l-.76 8a.5.5 0 0 1-.5.45h-.66l.91 6.43a.5.5 0 0 1-.98.14L13.64 15h-2.28L11 17.57a.5.5 0 0 1-.98-.14l.34-2.43H7.36L7 17.57a.5.5 0 0 1-.98-.14L6.92 11H4.5a.5.5 0 0 1-.5-.55l.76-8ZM7.51 14h2.98l.43-3H7.93l-.42 3Zm4 0h1.98l-.42-3h-1.14l-.42 3Zm2.78-4 .66-7H5.71l-.66 7h9.24Z"]));
export const SwimmingPoolFilled = ( /*#__PURE__*/createFluentIcon('SwimmingPoolFilled', "1em", ["M5.75 4a.75.75 0 0 0-.75.75v.5a.75.75 0 0 1-1.5 0v-.5a2.25 2.25 0 0 1 4.5 0V7.5h5V4.75a.75.75 0 1 0-1.5 0v.5a.75.75 0 1 1-1.5 0v-.5a2.25 2.25 0 0 1 4.5 0v7.03c-.4.13-.91.23-1.5.22V9H8v1.23A7.16 7.16 0 0 0 6.5 10V4.75A.75.75 0 0 0 5.75 4Zm.06 8.53c-.8.09-1.35.42-1.6.61a.75.75 0 0 1-.9-1.2c.4-.31 1.2-.77 2.33-.9a6.84 6.84 0 0 1 4.24 1.05c2.93 1.7 5.3.58 6 .17a.75.75 0 1 1 .75 1.3 7.33 7.33 0 0 1-7.5-.17 5.36 5.36 0 0 0-3.32-.86Zm0 3c-.8.09-1.35.42-1.6.61a.75.75 0 0 1-.9-1.2c.4-.31 1.2-.77 2.33-.9a6.84 6.84 0 0 1 4.24 1.05c2.93 1.7 5.3.58 6 .17a.75.75 0 1 1 .75 1.3 7.33 7.33 0 0 1-7.5-.17 5.36 5.36 0 0 0-3.32-.86Z"]));
export const SwimmingPoolRegular = ( /*#__PURE__*/createFluentIcon('SwimmingPoolRegular', "1em", ["M5 5a1 1 0 0 1 2 0v5.05c.32.03.65.1 1 .19V9h5v3c.37 0 .7-.03 1-.09V5a2 2 0 1 0-4 0v.5a.5.5 0 0 0 1 0V5a1 1 0 1 1 2 0v3H8V5a2 2 0 1 0-4 0v.5a.5.5 0 0 0 1 0V5Zm8.08 9a7.6 7.6 0 0 1-3.83-1.08c-3.42-1.97-5.32-.15-5.39-.08a.5.5 0 0 1-.71 0 .48.48 0 0 1 0-.7c.1-.1 2.48-2.46 6.6-.1a6 6 0 0 0 6.45.05c.22-.16.53-.11.7.1a.5.5 0 0 1-.1.7 6.65 6.65 0 0 1-3.72 1.1V14Zm-3.83 1.92A7.6 7.6 0 0 0 13.08 17v-.01a6.65 6.65 0 0 0 3.71-1.1.5.5 0 0 0 .11-.7.51.51 0 0 0-.7-.1 6 6 0 0 1-6.44-.04c-4.13-2.37-6.5 0-6.61.1-.2.19-.2.5 0 .7.2.19.52.18.71 0 .07-.08 1.97-1.9 5.39.07Z"]));
export const SwipeDownFilled = ( /*#__PURE__*/createFluentIcon('SwipeDownFilled', "1em", ["M14 6a4 4 0 0 1-2.25 3.6V8.44a3 3 0 1 0-3.5 0V9.6A4 4 0 1 1 14 6ZM9.47 17.78c.3.3.77.3 1.06 0l2.5-2.5a.75.75 0 1 0-1.06-1.06l-1.22 1.22V5.75a.75.75 0 0 0-1.5 0v9.69l-1.22-1.22a.75.75 0 0 0-1.06 1.06l2.5 2.5Z"]));
export const SwipeDownRegular = ( /*#__PURE__*/createFluentIcon('SwipeDownRegular', "1em", ["M14 6a4 4 0 0 1-2.5 3.7V8.6a3 3 0 1 0-3 0v1.1A4 4 0 1 1 14 6ZM9.65 17.85c.2.2.5.2.7 0l3-3a.5.5 0 0 0-.7-.7l-2.15 2.14V5.5a.5.5 0 0 0-1 0v10.8l-2.15-2.15a.5.5 0 1 0-.7.7l3 3Z"]));
export const SwipeRightFilled = ( /*#__PURE__*/createFluentIcon('SwipeRightFilled', "1em", ["M6 6a4 4 0 0 1 3.6 2.25H8.44a3 3 0 1 0 0 3.5H9.6A4 4 0 1 1 6 6Zm9.28 7.03 2.5-2.5c.3-.3.3-.77 0-1.06l-2.5-2.5a.75.75 0 0 0-1.06 1.06l1.22 1.22H5.75a.75.75 0 1 0 0 1.5h9.69l-1.22 1.22a.75.75 0 1 0 1.06 1.06Z"]));
export const SwipeRightRegular = ( /*#__PURE__*/createFluentIcon('SwipeRightRegular', "1em", ["M6 6a4 4 0 0 1 3.7 2.5H8.6a3 3 0 1 0 0 3h1.1A4 4 0 1 1 6 6Zm8.85 7.35 3-3a.5.5 0 0 0 0-.7l-3-3a.5.5 0 1 0-.7.7l2.14 2.15H5.5a.5.5 0 0 0 0 1h10.8l-2.15 2.15a.5.5 0 0 0 .7.7Z"]));
export const SwipeUpFilled = ( /*#__PURE__*/createFluentIcon('SwipeUpFilled', "1em", ["M10.53 2.22a.75.75 0 0 0-1.06 0l-2.5 2.5a.75.75 0 0 0 1.06 1.06l1.22-1.22v9.69a.75.75 0 0 0 1.5 0V4.56l1.22 1.22a.75.75 0 1 0 1.06-1.06l-2.5-2.5ZM6 14a4 4 0 0 1 2.25-3.6v1.16a3 3 0 1 0 3.5 0V10.4A4 4 0 1 1 6 14Z"]));
export const SwipeUpRegular = ( /*#__PURE__*/createFluentIcon('SwipeUpRegular', "1em", ["M10.35 2.15a.5.5 0 0 0-.7 0l-3 3a.5.5 0 1 0 .7.7L9.5 3.71V14.5a.5.5 0 0 0 1 0V3.7l2.15 2.15a.5.5 0 0 0 .7-.7l-3-3ZM6 14a4 4 0 0 1 2.5-3.7v1.1a3 3 0 1 0 3 0v-1.1A4 4 0 1 1 6 14Z"]));
export const SymbolsFilled = ( /*#__PURE__*/createFluentIcon('SymbolsFilled', "1em", ["M14.14 7.97c.2.2.51.2.7 0l2.56-2.55a2 2 0 1 0-2.83-2.83l-.07.08-.08-.08a2 2 0 0 0-2.83 2.83l2.55 2.55ZM2 5.5a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0ZM5.5 3c-.5 0-.98.16-1.38.42L7.6 6.88A2.5 2.5 0 0 0 5.5 3ZM3 5.5A2.5 2.5 0 0 0 6.88 7.6L3.4 4.12C3.15 4.52 3 5 3 5.5Zm9.34 7.75A2.5 2.5 0 0 1 16.5 13h-1a.5.5 0 1 0 0 1h2a.5.5 0 0 0 .5-.5v-2a.5.5 0 0 0-1 0v.55a3.49 3.49 0 0 0-5.53.7.5.5 0 0 0 .87.5Zm-.34 3.7v.55a.5.5 0 0 1-1 0v-2c0-.28.22-.5.5-.5h2a.5.5 0 1 1 0 1h-1a2.5 2.5 0 0 0 4.17-.25.5.5 0 0 1 .86.5 3.5 3.5 0 0 1-5.53.7ZM5.5 11c.28 0 .5.23.5.5V14h2.5a.5.5 0 1 1 0 1H6v2.5a.5.5 0 0 1-1 0V15H2.5a.5.5 0 1 1 0-1H5v-2.5c0-.27.22-.5.5-.5Z"]));
export const SymbolsRegular = ( /*#__PURE__*/createFluentIcon('SymbolsRegular', "1em", ["M14.14 7.97c.2.2.51.2.7 0l2.56-2.55a2 2 0 1 0-2.83-2.83l-.07.08-.08-.08a2 2 0 0 0-2.83 2.83l2.55 2.55ZM12.3 4.71a1 1 0 1 1 1.42-1.41l.79.78.5-.5.28-.28a1 1 0 0 1 1.43 0 1 1 0 0 1 0 1.4L14.5 6.92l-2.2-2.2ZM2 5.51a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0ZM5.5 3c-.5 0-.98.15-1.38.4L7.6 6.89A2.5 2.5 0 0 0 5.5 3ZM3 5.5a2.5 2.5 0 0 0 3.88 2.08L3.4 4.12C3.15 4.52 3 5 3 5.5Zm9.34 7.74A2.5 2.5 0 0 1 16.5 13h-1a.5.5 0 1 0 0 1h2a.5.5 0 0 0 .5-.5v-2a.5.5 0 0 0-1 0v.55a3.49 3.49 0 0 0-5.53.7.5.5 0 0 0 .87.5Zm-.34 3.7v.55a.5.5 0 0 1-1 0v-2c0-.28.22-.5.5-.5h2a.5.5 0 1 1 0 1h-1a2.5 2.5 0 0 0 4.17-.25.5.5 0 0 1 .86.5 3.5 3.5 0 0 1-5.53.7ZM5.5 11c.28 0 .5.23.5.5V14h2.5a.5.5 0 1 1 0 1H6v2.5a.5.5 0 0 1-1 0V15H2.5a.5.5 0 1 1 0-1H5v-2.5c0-.27.22-.5.5-.5Z"]));
export const SyncOffFilled = ( /*#__PURE__*/createFluentIcon('SyncOffFilled', "1em", ["M17.94 9H12.3l.67-2.36a.5.5 0 0 0-.96-.28l-2 7a.5.5 0 0 0 .96.28L12.02 10H18a8 8 0 0 1-16 0h5.98l-.96 3.36a.5.5 0 0 0 .96.28l2-7a.5.5 0 0 0-.96-.28L8.27 9h-6.2a8 8 0 0 1 15.87 0Z"]));
export const SyncOffRegular = ( /*#__PURE__*/createFluentIcon('SyncOffRegular', "1em", ["M2 10a8 8 0 1 1 16 0 8 8 0 0 1-16 0Zm8-7a7 7 0 0 0-6.93 6h5.2l.75-2.64a.5.5 0 1 1 .96.28l-2 7a.5.5 0 1 1-.96-.28L7.98 10H3a7 7 0 1 0 14 0h-4.98l-1.04 3.64a.5.5 0 1 1-.96-.28l2-7a.5.5 0 1 1 .96.28L12.31 9h4.62A7 7 0 0 0 10 3Z"]));
export const SyringeFilled = ( /*#__PURE__*/createFluentIcon('SyringeFilled', "1em", ["M14.15 2.15c.2-.2.5-.2.7 0l3 3a.5.5 0 0 1-.7.7l-.4-.4-1.8 1.8 1.9 1.9a.5.5 0 0 1-.7.7L15 8.71l-5.56 5.56a2.5 2.5 0 0 1-1.77.73H5.71l-2.86 2.85a.5.5 0 0 1-.7-.7L5 14.29v-1.96c0-.66.26-1.3.73-1.77L6.3 10l.86.85a.5.5 0 0 0 .7-.7L7 9.29l.8-.79.85.85a.5.5 0 1 0 .7-.7l-.85-.86.8-.79.85.85a.5.5 0 0 0 .7-.7L10 6.29 11.3 5l-1.15-1.15a.5.5 0 0 1 .7-.7l1.9 1.9 1.8-1.8-.4-.4a.5.5 0 0 1 0-.7Zm1.9 2.6-.8-.8-1.8 1.8.8.8 1.8-1.8Z"]));
export const SyringeRegular = ( /*#__PURE__*/createFluentIcon('SyringeRegular', "1em", ["M14.15 2.15c.2-.2.5-.2.7 0l3 3a.5.5 0 0 1-.7.7l-.4-.4-1.8 1.8 1.9 1.9a.5.5 0 0 1-.7.7L15 8.71l-5.56 5.56a2.5 2.5 0 0 1-1.77.73H5.71l-2.86 2.85a.5.5 0 0 1-.7-.7L5 14.29v-1.96c0-.66.26-1.3.73-1.77L11.3 5l-1.14-1.15a.5.5 0 0 1 .7-.7l1.9 1.9 1.8-1.8-.4-.4a.5.5 0 0 1 0-.7ZM10 7.7l-.8.79.65.65a.5.5 0 0 1-.7.7l-.65-.64-.8.79.65.65a.5.5 0 0 1-.7.7L7 10.71l-.56.56A1.5 1.5 0 0 0 6 12.33V14h1.67c.4 0 .78-.16 1.06-.44L14.3 8 12 5.7 10.7 7l.65.65a.5.5 0 0 1-.7.7L10 7.71Zm6.04-2.96-.79-.8-1.8 1.8.8.8 1.8-1.8Z"]));
export const SystemFilled = ( /*#__PURE__*/createFluentIcon('SystemFilled', "1em", ["M2 6.5A2.5 2.5 0 0 1 4.5 4h11A2.5 2.5 0 0 1 18 6.5v7a2.5 2.5 0 0 1-2.5 2.5h-11A2.5 2.5 0 0 1 2 13.5v-7Zm2.5-1a1 1 0 0 0-1 1v7a1 1 0 0 0 1 1h11a1 1 0 0 0 1-1v-7a1 1 0 0 0-1-1h-11Z"]));
export const SystemRegular = ( /*#__PURE__*/createFluentIcon('SystemRegular', "1em", ["M2 6.5A2.5 2.5 0 0 1 4.5 4h11A2.5 2.5 0 0 1 18 6.5v7a2.5 2.5 0 0 1-2.5 2.5h-11A2.5 2.5 0 0 1 2 13.5v-7ZM4.5 5C3.67 5 3 5.67 3 6.5v7c0 .83.67 1.5 1.5 1.5h11c.83 0 1.5-.67 1.5-1.5v-7c0-.83-.67-1.5-1.5-1.5h-11Z"]));
export const TabFilled = ( /*#__PURE__*/createFluentIcon('TabFilled', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9Zm2.5-1a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h9a1 1 0 0 0 1-1v-9a1 1 0 0 0-1-1h-9Z"]));
export const TabRegular = ( /*#__PURE__*/createFluentIcon('TabRegular', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9ZM5.5 4C4.67 4 4 4.67 4 5.5v9c0 .83.67 1.5 1.5 1.5h9c.83 0 1.5-.67 1.5-1.5v-9c0-.83-.67-1.5-1.5-1.5h-9Z"]));
export const TabAddFilled = ( /*#__PURE__*/createFluentIcon('TabAddFilled', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v4.1a5.46 5.46 0 0 0-1.5-.5V5.5a1 1 0 0 0-1-1h-9a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h3.6c.09.53.26 1.03.5 1.5H5.5A2.5 2.5 0 0 1 3 14.5v-9Zm16 9a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const TabAddRegular = ( /*#__PURE__*/createFluentIcon('TabAddRegular', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v4.1c-.32-.16-.65-.3-1-.4V5.5c0-.83-.67-1.5-1.5-1.5h-9C4.67 4 4 4.67 4 5.5v9c0 .83.67 1.5 1.5 1.5h3.7c.1.35.24.68.4 1H5.5A2.5 2.5 0 0 1 3 14.5v-9Zm16 9a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const TabArrowLeftFilled = ( /*#__PURE__*/createFluentIcon('TabArrowLeftFilled', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v4.1a5.46 5.46 0 0 0-1.5-.5V5.5a1 1 0 0 0-1-1h-9a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h3.6c.09.53.26 1.03.5 1.5H5.5A2.5 2.5 0 0 1 3 14.5v-9ZM14.5 19a4.5 4.5 0 1 1 0-9 4.5 4.5 0 0 1 0 9Zm-2.35-4.85a.5.5 0 0 0-.15.35.5.5 0 0 0 .15.35l2 2a.5.5 0 0 0 .7-.7L13.71 15h2.79a.5.5 0 0 0 0-1h-2.8l1.15-1.15a.5.5 0 0 0-.7-.7l-2 2Z"]));
export const TabArrowLeftRegular = ( /*#__PURE__*/createFluentIcon('TabArrowLeftRegular', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v4.1c-.32-.16-.65-.3-1-.4V5.5c0-.83-.67-1.5-1.5-1.5h-9C4.67 4 4 4.67 4 5.5v9c0 .83.67 1.5 1.5 1.5h3.7c.1.35.24.68.4 1H5.5A2.5 2.5 0 0 1 3 14.5v-9ZM14.5 19a4.5 4.5 0 1 1 0-9 4.5 4.5 0 0 1 0 9Zm-2.35-4.85a.5.5 0 0 0-.15.35.5.5 0 0 0 .15.35l2 2a.5.5 0 0 0 .7-.7L13.71 15h2.79a.5.5 0 0 0 0-1h-2.8l1.15-1.15a.5.5 0 0 0-.7-.7l-2 2Z"]));
export const TabDesktopFilled = ( /*#__PURE__*/createFluentIcon('TabDesktopFilled', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V7H9.5A1.5 1.5 0 0 1 8 5.5V3H5.5ZM9 3v2.5c0 .28.22.5.5.5H17v-.5A2.5 2.5 0 0 0 14.5 3H9Z"]));
export const TabDesktopRegular = ( /*#__PURE__*/createFluentIcon('TabDesktopRegular', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9ZM16 6v-.5c0-.83-.67-1.5-1.5-1.5H9v1.5c0 .28.22.5.5.5H16ZM8 4H5.5C4.67 4 4 4.67 4 5.5v9c0 .83.67 1.5 1.5 1.5h9c.83 0 1.5-.67 1.5-1.5V7H9.5A1.5 1.5 0 0 1 8 5.5V4Z"]));
export const TabDesktopArrowClockwiseFilled = ( /*#__PURE__*/createFluentIcon('TabDesktopArrowClockwiseFilled', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5v3.76a5.48 5.48 0 0 1 5.2-1A1.5 1.5 0 0 1 11 9v1.34a5.48 5.48 0 0 1-.26 6.66h3.76a2.5 2.5 0 0 0 2.5-2.5V7H9.5A1.5 1.5 0 0 1 8 5.5V3H5.5ZM9 3v2.5c0 .28.22.5.5.5H17v-.5A2.5 2.5 0 0 0 14.5 3H9Zm1 8a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1 0-1h.8a3.5 3.5 0 1 0 1.7 3 .5.5 0 0 1 1 0 4.5 4.5 0 1 1-2-3.74V9a.5.5 0 0 1 .5-.5c.28 0 .5.22.5.5v2Z"]));
export const TabDesktopArrowClockwiseRegular = ( /*#__PURE__*/createFluentIcon('TabDesktopArrowClockwiseRegular', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-3.76c.26-.3.48-.64.66-1h3.1c.83 0 1.5-.67 1.5-1.5V7H9.5A1.5 1.5 0 0 1 8 5.5V4H5.5C4.67 4 4 4.67 4 5.5v3.1c-.36.18-.7.4-1 .66V5.5ZM16 6v-.5c0-.83-.67-1.5-1.5-1.5H9v1.5c0 .28.22.5.5.5H16ZM9.5 8.5c.28 0 .5.22.5.5v2a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1 0-1h.8a3.5 3.5 0 1 0 1.7 3 .5.5 0 0 1 1 0 4.5 4.5 0 1 1-2-3.74V9c0-.28.22-.5.5-.5Z"]));
export const TabDesktopArrowLeftFilled = ( /*#__PURE__*/createFluentIcon('TabDesktopArrowLeftFilled', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5v4.1a5.5 5.5 0 0 1 7.4 7.4h4.1a2.5 2.5 0 0 0 2.5-2.5V7H9.5A1.5 1.5 0 0 1 8 5.5V3H5.5ZM9 3v2.5c0 .28.22.5.5.5H17v-.5A2.5 2.5 0 0 0 14.5 3H9Zm1 11.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-6.85-.35a.5.5 0 0 0-.15.35.5.5 0 0 0 .15.35l2 2a.5.5 0 0 0 .7-.7L4.71 15H7.5a.5.5 0 0 0 0-1H4.7l1.15-1.15a.5.5 0 0 0-.7-.7l-2 2Z"]));
export const TabDesktopArrowLeftRegular = ( /*#__PURE__*/createFluentIcon('TabDesktopArrowLeftRegular', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-4.1c.16-.32.3-.65.4-1h3.7c.82 0 1.5-.67 1.5-1.5V7H9.5A1.5 1.5 0 0 1 8 5.5V4H5.5C4.67 4 4 4.67 4 5.5v3.7c-.35.1-.69.24-1 .4V5.5ZM16 6v-.5c0-.83-.68-1.5-1.5-1.5H9v1.5c0 .28.22.5.5.5H16Zm-6 8.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-6.85-.35a.5.5 0 0 0-.15.35.5.5 0 0 0 .15.35l2 2a.5.5 0 0 0 .7-.7L4.71 15H7.5a.5.5 0 0 0 0-1H4.7l1.15-1.15a.5.5 0 0 0-.7-.7l-2 2Z"]));
export const TabDesktopBottomFilled = ( /*#__PURE__*/createFluentIcon('TabDesktopBottomFilled', "1em", ["M14.5 17a2.5 2.5 0 0 0 2.5-2.5v-9A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5V13h7.5c.83 0 1.5.67 1.5 1.5V17h2.5ZM11 17v-2.5a.5.5 0 0 0-.5-.5H3v.5A2.5 2.5 0 0 0 5.5 17H11Z"]));
export const TabDesktopBottomRegular = ( /*#__PURE__*/createFluentIcon('TabDesktopBottomRegular', "1em", ["M17 14.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v9ZM4 14v.5c0 .83.67 1.5 1.5 1.5H11v-1.5a.5.5 0 0 0-.5-.5H4Zm8 2h2.5c.83 0 1.5-.67 1.5-1.5v-9c0-.83-.67-1.5-1.5-1.5h-9C4.67 4 4 4.67 4 5.5V13h6.5c.83 0 1.5.67 1.5 1.5V16Z"]));
export const TabDesktopClockFilled = ( /*#__PURE__*/createFluentIcon('TabDesktopClockFilled', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5v4.1a5.5 5.5 0 0 1 7.4 7.4h4.1a2.5 2.5 0 0 0 2.5-2.5V7H9.5A1.5 1.5 0 0 1 8 5.5V3H5.5ZM9 3v2.5c0 .28.22.5.5.5H17v-.5A2.5 2.5 0 0 0 14.5 3H9ZM5.5 19a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm0-7c.28 0 .5.22.5.5V14h1a.5.5 0 0 1 0 1H5.5a.5.5 0 0 1-.5-.5v-2c0-.28.22-.5.5-.5Z"]));
export const TabDesktopClockRegular = ( /*#__PURE__*/createFluentIcon('TabDesktopClockRegular', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-4.1c.16-.32.3-.65.4-1h3.7c.83 0 1.5-.67 1.5-1.5V7H9.5A1.5 1.5 0 0 1 8 5.5V4H5.5C4.67 4 4 4.67 4 5.5v3.7c-.35.1-.68.24-1 .4V5.5ZM16 6v-.5c0-.83-.67-1.5-1.5-1.5H9v1.5c0 .28.22.5.5.5H16Zm-6 8.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM5.5 12a.5.5 0 0 0-.5.5v2c0 .28.22.5.5.5H7a.5.5 0 0 0 0-1H6v-1.5a.5.5 0 0 0-.5-.5Z"]));
export const TabDesktopCopyFilled = ( /*#__PURE__*/createFluentIcon('TabDesktopCopyFilled', "1em", ["M5 4.5A2.5 2.5 0 0 1 7.5 2H9v2.5c0 .83.67 1.5 1.5 1.5H18v6.5a2.5 2.5 0 0 1-2.5 2.5h-8A2.5 2.5 0 0 1 5 12.5v-8Zm5 0V2h5.5A2.5 2.5 0 0 1 18 4.5V5h-7.5a.5.5 0 0 1-.5-.5ZM12.5 18a2.5 2.5 0 0 0 2.45-2H7.5A3.5 3.5 0 0 1 4 12.5V5.05A2.5 2.5 0 0 0 2 7.5V14a4 4 0 0 0 4 4h6.5Z"]));
export const TabDesktopCopyRegular = ( /*#__PURE__*/createFluentIcon('TabDesktopCopyRegular', "1em", ["M7.5 2A2.5 2.5 0 0 0 5 4.5v8A2.5 2.5 0 0 0 7.5 15h8a2.5 2.5 0 0 0 2.5-2.5v-8A2.5 2.5 0 0 0 15.5 2h-8ZM17 4.5V5h-6.5a.5.5 0 0 1-.5-.5V3h5.5c.83 0 1.5.67 1.5 1.5Zm-8 0c0 .83.67 1.5 1.5 1.5H17v6.5c0 .83-.67 1.5-1.5 1.5h-8A1.5 1.5 0 0 1 6 12.5v-8C6 3.67 6.67 3 7.5 3H9v1.5ZM12.5 18a2.5 2.5 0 0 0 2.45-2h-1.04c-.2.58-.76 1-1.41 1H6a3 3 0 0 1-3-3V7.5c0-.65.42-1.2 1-1.41V5.05A2.5 2.5 0 0 0 2 7.5V14a4 4 0 0 0 4 4h6.5Z"]));
export const TabDesktopImageFilled = ( /*#__PURE__*/createFluentIcon('TabDesktopImageFilled', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5v2.84c.45-.22.96-.34 1.5-.34h4a3.5 3.5 0 0 1 3.5 3.5v4c0 .54-.12 1.05-.34 1.5h2.84a2.5 2.5 0 0 0 2.5-2.5V7H9.5A1.5 1.5 0 0 1 8 5.5V3H5.5ZM9 3v2.5c0 .28.22.5.5.5H17v-.5A2.5 2.5 0 0 0 14.5 3H9Zm-7 8.5A2.5 2.5 0 0 1 4.5 9h4a2.5 2.5 0 0 1 2.5 2.5v4c0 .5-.15.98-.41 1.38l-3.03-3.03a1.5 1.5 0 0 0-2.12 0L2.4 16.88C2.15 16.48 2 16 2 15.5v-4Zm7 .25a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Zm-5.88 5.84c.4.26.87.41 1.38.41h4c.51 0 .98-.15 1.38-.41l-3.03-3.03a.5.5 0 0 0-.7 0L3.12 17.6Z"]));
export const TabDesktopImageRegular = ( /*#__PURE__*/createFluentIcon('TabDesktopImageRegular', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-2.84c.15-.31.25-.65.3-1h2.54c.82 0 1.5-.67 1.5-1.5V7H9.5A1.5 1.5 0 0 1 8 5.5V4H5.5C4.67 4 4 4.67 4 5.5v2.54c-.36.05-.7.15-1 .3V5.5ZM16 6v-.5c0-.83-.68-1.5-1.5-1.5H9v1.5c0 .28.22.5.5.5H16ZM2 11.5A2.5 2.5 0 0 1 4.5 9h4a2.5 2.5 0 0 1 2.5 2.5v4c0 .5-.15.98-.41 1.38l-3.03-3.03a1.5 1.5 0 0 0-2.12 0L2.4 16.88C2.15 16.48 2 16 2 15.5v-4Zm7 .25a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Zm-5.88 5.84c.4.26.87.41 1.38.41h4c.51 0 .98-.15 1.38-.41l-3.03-3.03a.5.5 0 0 0-.7 0L3.12 17.6Z"]));
export const TabDesktopLinkFilled = ( /*#__PURE__*/createFluentIcon('TabDesktopLinkFilled', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h3.54a3.5 3.5 0 0 1 3.46-4h4c.17 0 .33.01.5.03V7H9.5A1.5 1.5 0 0 1 8 5.5V3H5.5ZM9 3v2.5c0 .28.22.5.5.5H17v-.5A2.5 2.5 0 0 0 14.5 3H9Zm3.5 11a2.5 2.5 0 0 0 0 5h.5a.5.5 0 0 0 0-1h-.5a1.5 1.5 0 0 1 0-3h.5a.5.5 0 0 0 0-1h-.5Zm3.5 0a.5.5 0 0 0 0 1h.5a1.5 1.5 0 0 1 0 3H16a.5.5 0 0 0 0 1h.5a2.5 2.5 0 0 0 0-5H16Zm-4 2.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z"]));
export const TabDesktopLinkRegular = ( /*#__PURE__*/createFluentIcon('TabDesktopLinkRegular', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v7.53a3.53 3.53 0 0 0-.5-.03H16V7H9.5A1.5 1.5 0 0 1 8 5.5V4H5.5C4.67 4 4 4.67 4 5.5v9c0 .83.67 1.5 1.5 1.5h3.54a3.53 3.53 0 0 0 0 1H5.5A2.5 2.5 0 0 1 3 14.5v-9ZM16 6v-.5c0-.83-.68-1.5-1.5-1.5H9v1.5c0 .28.22.5.5.5H16Zm-3.5 8a2.5 2.5 0 0 0 0 5h.5a.5.5 0 0 0 0-1h-.5a1.5 1.5 0 0 1 0-3h.5a.5.5 0 0 0 0-1h-.5Zm3.5 0a.5.5 0 0 0 0 1h.5a1.5 1.5 0 0 1 0 3H16a.5.5 0 0 0 0 1h.5a2.5 2.5 0 0 0 0-5H16Zm-4 2.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z"]));
export const TabDesktopMultipleFilled = ( /*#__PURE__*/createFluentIcon('TabDesktopMultipleFilled', "1em", ["M2 4.5A2.5 2.5 0 0 1 4.5 2H6v2.5C6 5.33 6.67 6 7.5 6H15v6.5a2.5 2.5 0 0 1-2.5 2.5h-8A2.5 2.5 0 0 1 2 12.5v-8Zm5 0V2h5.5A2.5 2.5 0 0 1 15 4.5V5H7.5a.5.5 0 0 1-.5-.5ZM7.5 18a2.5 2.5 0 0 1-2.45-2h7.45a3.5 3.5 0 0 0 3.5-3.5V5.05a2.5 2.5 0 0 1 2 2.45V14a4 4 0 0 1-4 4H7.5Z"]));
export const TabDesktopMultipleRegular = ( /*#__PURE__*/createFluentIcon('TabDesktopMultipleRegular', "1em", ["M4.5 2A2.5 2.5 0 0 0 2 4.5v8A2.5 2.5 0 0 0 4.5 15h8a2.5 2.5 0 0 0 2.5-2.5v-8A2.5 2.5 0 0 0 12.5 2h-8ZM14 4.5V5H7.5a.5.5 0 0 1-.5-.5V3h5.5c.83 0 1.5.67 1.5 1.5Zm-8 0C6 5.33 6.67 6 7.5 6H14v6.5c0 .83-.67 1.5-1.5 1.5h-8A1.5 1.5 0 0 1 3 12.5v-8C3 3.67 3.67 3 4.5 3H6v1.5ZM7.5 18a2.5 2.5 0 0 1-2.45-2h1.04c.2.58.76 1 1.41 1H14a3 3 0 0 0 3-3V7.5c0-.65-.42-1.2-1-1.41V5.05a2.5 2.5 0 0 1 2 2.45V14a4 4 0 0 1-4 4H7.5Z"]));
export const TabDesktopMultipleAddFilled = ( /*#__PURE__*/createFluentIcon('TabDesktopMultipleAddFilled', "1em", ["M2 4.5A2.5 2.5 0 0 1 4.5 2H6v2.5C6 5.33 6.67 6 7.5 6H15v6.5a2.5 2.5 0 0 1-2.5 2.5h-1.52l.02-.5a5.5 5.5 0 0 0-9-4.24V4.5ZM10.8 16a5.49 5.49 0 0 1-1.06 2H14a4 4 0 0 0 4-4V7.5a2.5 2.5 0 0 0-2-2.45v7.45a3.5 3.5 0 0 1-3.5 3.5h-1.7ZM7 4.5V2h5.5A2.5 2.5 0 0 1 15 4.5V5H7.5a.5.5 0 0 1-.5-.5Zm3 10a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14H3.5a.5.5 0 0 0 0 1H5v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H6v-1.5Z"]));
export const TabDesktopMultipleAddRegular = ( /*#__PURE__*/createFluentIcon('TabDesktopMultipleAddRegular', "1em", ["M4.5 2A2.5 2.5 0 0 0 2 4.5v5.76c.3-.26.64-.48 1-.66V4.5C3 3.67 3.67 3 4.5 3H6v1.5C6 5.33 6.67 6 7.5 6H14v6.5c0 .83-.67 1.5-1.5 1.5h-1.52a5.59 5.59 0 0 1 0 1h1.52a2.5 2.5 0 0 0 2.5-2.5v-8A2.5 2.5 0 0 0 12.5 2h-8ZM14 18H9.74c.26-.3.48-.64.66-1H14a3 3 0 0 0 3-3V7.5c0-.65-.42-1.2-1-1.41V5.05a2.5 2.5 0 0 1 2 2.45V14a4 4 0 0 1-4 4Zm0-13.5V5H7.5a.5.5 0 0 1-.5-.5V3h5.5c.83 0 1.5.67 1.5 1.5Zm-4 10a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14H3.5a.5.5 0 0 0 0 1H5v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H6v-1.5Z"]));
export const TabDesktopMultipleBottomFilled = ( /*#__PURE__*/createFluentIcon('TabDesktopMultipleBottomFilled', "1em", ["M5.05 4h7.45A3.5 3.5 0 0 1 16 7.5v7.45a2.5 2.5 0 0 0 2-2.45V6a4 4 0 0 0-4-4H7.5a2.5 2.5 0 0 0-2.45 2ZM2 7.5A2.5 2.5 0 0 1 4.5 5h8A2.5 2.5 0 0 1 15 7.5v8a2.5 2.5 0 0 1-2.5 2.5H11v-2.5c0-.83-.67-1.5-1.5-1.5H2V7.5Zm8 8V18H4.5A2.5 2.5 0 0 1 2 15.5V15h7.5c.28 0 .5.22.5.5Z"]));
export const TabDesktopMultipleBottomRegular = ( /*#__PURE__*/createFluentIcon('TabDesktopMultipleBottomRegular', "1em", ["M6.09 4H5.05A2.5 2.5 0 0 1 7.5 2H14a4 4 0 0 1 4 4v6.5a2.5 2.5 0 0 1-2 2.45v-1.04c.58-.2 1-.76 1-1.41V6a3 3 0 0 0-3-3H7.5c-.65 0-1.2.42-1.41 1ZM9.5 15H3v.5c0 .83.67 1.5 1.5 1.5H10v-1.5a.5.5 0 0 0-.5-.5ZM3 14h6.5c.83 0 1.5.67 1.5 1.5V17h1.5c.83 0 1.5-.67 1.5-1.5v-8c0-.83-.67-1.5-1.5-1.5h-8C3.67 6 3 6.67 3 7.5V14Zm1.5 4A2.5 2.5 0 0 1 2 15.5v-8A2.5 2.5 0 0 1 4.5 5h8A2.5 2.5 0 0 1 15 7.5v8a2.5 2.5 0 0 1-2.5 2.5h-8Z"]));
export const TabDesktopMultipleSparkleFilled = ( /*#__PURE__*/createFluentIcon('TabDesktopMultipleSparkleFilled', "1em", ["m14.88.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.23 2.23 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Zm4.9 7.93-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02ZM17.5 12c-.27 0-.52-.08-.74-.23a1.4 1.4 0 0 1-.48-.62l-.26-.8-.02-.04v2.19a3.5 3.5 0 0 1-3.5 3.5H5.05a2.5 2.5 0 0 0 2.45 2H14a4 4 0 0 0 4-4v-2.08c-.16.06-.33.08-.5.08Zm-4.35-4.95L12.81 6H7.5A1.5 1.5 0 0 1 6 4.5V2H4.5A2.5 2.5 0 0 0 2 4.5v8A2.5 2.5 0 0 0 4.5 15h8a2.5 2.5 0 0 0 2.5-2.5V9.77l-.1-.03c-.28-.1-.5-.26-.66-.48a1.3 1.3 0 0 1-.12-1.3 1.32 1.32 0 0 1-.45-.22 1.51 1.51 0 0 1-.52-.69Zm-2.2-4.9.48-.15H7v2.5c0 .28.22.5.5.5h3.93l-.46-.15A1.41 1.41 0 0 1 10 3.5a1.4 1.4 0 0 1 .95-1.35Z"]));
export const TabDesktopMultipleSparkleRegular = ( /*#__PURE__*/createFluentIcon('TabDesktopMultipleSparkleRegular', "1em", ["m14.88.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.23 2.23 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Zm4.9 7.93-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02ZM17 11.91c.16.06.33.09.5.09.17 0 .34-.02.5-.08V14a4 4 0 0 1-4 4H7.5a2.5 2.5 0 0 1-2.45-2h1.04c.2.58.76 1 1.41 1H14a3 3 0 0 0 3-3v-2.1ZM11.43 2H4.5A2.5 2.5 0 0 0 2 4.5v8A2.5 2.5 0 0 0 4.5 15h8a2.5 2.5 0 0 0 2.5-2.5V9.77l-.1-.03c-.28-.1-.5-.26-.66-.48A1.27 1.27 0 0 1 14 8.5v4c0 .83-.67 1.5-1.5 1.5h-8A1.5 1.5 0 0 1 3 12.5v-8C3 3.67 3.67 3 4.5 3H6v1.5C6 5.33 6.67 6 7.5 6h5.3v-.04a1.27 1.27 0 0 0-.3-.47 1.3 1.3 0 0 0-.47-.3l-.6-.19H7.5a.5.5 0 0 1-.5-.5V3h3.09a1.42 1.42 0 0 1 .86-.85l.48-.15Z"]));
export const TabDesktopNewPageFilled = ( /*#__PURE__*/createFluentIcon('TabDesktopNewPageFilled', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3H8v2.5C8 6.33 8.67 7 9.5 7H17v7.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9ZM8 11a1 1 0 1 0-2 0 1 1 0 0 0 2 0Zm2 1a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm4-1a1 1 0 1 0-2 0 1 1 0 0 0 2 0Zm3-5v-.5A2.5 2.5 0 0 0 14.5 3H9v2.5c0 .28.22.5.5.5H17Z"]));
export const TabDesktopNewPageRegular = ( /*#__PURE__*/createFluentIcon('TabDesktopNewPageRegular', "1em", ["M7 12a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm4-1a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm2 1a1 1 0 1 0 0-2 1 1 0 0 0 0 2ZM3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9ZM5.5 4C4.67 4 4 4.67 4 5.5v9c0 .83.67 1.5 1.5 1.5h9c.83 0 1.5-.67 1.5-1.5V7H9.5A1.5 1.5 0 0 1 8 5.5V4H5.5ZM16 5.5c0-.83-.67-1.5-1.5-1.5H9v1.5c0 .28.22.5.5.5H16v-.5Z"]));
export const TabDesktopSearchFilled = ( /*#__PURE__*/createFluentIcon('TabDesktopSearchFilled', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3H8v2.5C8 6.33 8.67 7 9.5 7H17v7.5a2.5 2.5 0 0 1-2.5 2.5H11.9a1.5 1.5 0 0 0-.35-.56l-2-2A4.5 4.5 0 0 0 3 8.76V5.5Zm6 0V3h5.5A2.5 2.5 0 0 1 17 5.5V6H9.5a.5.5 0 0 1-.5-.5ZM5.5 16c.79 0 1.51-.26 2.1-.7l2.55 2.55a.5.5 0 1 0 .7-.7L8.3 14.6A3.5 3.5 0 1 0 5.5 16Zm0-1a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5Z"]));
export const TabDesktopSearchRegular = ( /*#__PURE__*/createFluentIcon('TabDesktopSearchRegular', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5v3.26c.3-.2.64-.38 1-.5V5.5C4 4.67 4.67 4 5.5 4H8v1.5C8 6.33 8.67 7 9.5 7H16v7.5c0 .83-.68 1.5-1.5 1.5h-3.38l.44.44c.16.16.28.36.35.56h2.59a2.5 2.5 0 0 0 2.5-2.5v-9A2.5 2.5 0 0 0 14.5 3h-9ZM16 5.5V6H9.5a.5.5 0 0 1-.5-.5V4h5.5c.82 0 1.5.67 1.5 1.5ZM5.5 16c.79 0 1.51-.26 2.1-.7l2.55 2.55a.5.5 0 1 0 .7-.7L8.3 14.6A3.5 3.5 0 1 0 5.5 16Zm0-1a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5Z"]));
export const TabGroupFilled = ( /*#__PURE__*/createFluentIcon('TabGroupFilled', "1em", ["M3.5 4A2.5 2.5 0 0 0 1 6.5v5A2.5 2.5 0 0 0 3.5 14h11a2.5 2.5 0 0 0 2.5-2.5v-5A2.5 2.5 0 0 0 14.5 4h-11ZM5 9c0-.28.22-.5.5-.5h7a.5.5 0 0 1 0 1h-7A.5.5 0 0 1 5 9Zm-1.5 6c.46.6 1.19 1 2 1h9a4.5 4.5 0 0 0 4.5-4.5v-3c0-.82-.39-1.54-1-2v5a3.5 3.5 0 0 1-3.5 3.5h-11Z"]));
export const TabGroupRegular = ( /*#__PURE__*/createFluentIcon('TabGroupRegular', "1em", ["M1 6.5A2.5 2.5 0 0 1 3.5 4h11A2.5 2.5 0 0 1 17 6.5v5a2.5 2.5 0 0 1-2.5 2.5h-11A2.5 2.5 0 0 1 1 11.5v-5ZM3.5 5C2.67 5 2 5.67 2 6.5v5c0 .83.67 1.5 1.5 1.5h11c.83 0 1.5-.67 1.5-1.5v-5c0-.83-.67-1.5-1.5-1.5h-11Zm2 11a2.5 2.5 0 0 1-2-1h11a3.5 3.5 0 0 0 3.5-3.5v-5c.61.46 1 1.18 1 2v3a4.5 4.5 0 0 1-4.5 4.5h-9Zm0-7.5a.5.5 0 0 0 0 1h7a.5.5 0 0 0 0-1h-7Z"]));
export const TabInPrivateFilled = ( /*#__PURE__*/createFluentIcon('TabInPrivateFilled', "1em", ["M5.5 3h9A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3Zm-1 2.5v1.3l2.3-2.3H5.5a1 1 0 0 0-1 1Zm0 2.7v2.6l6.3-6.3H8.2L4.5 8.2Zm7.7-3.7-7.7 7.7v2.3a1 1 0 0 0 .03.26L14.76 4.53a1 1 0 0 0-.26-.03h-2.3Zm3.27.74L5.24 15.47a1 1 0 0 0 .26.03h2.3l7.7-7.7V5.5a1 1 0 0 0-.03-.26Zm.03 3.97L9.2 15.5h2.6l3.7-3.7V9.2Zm0 4-2.3 2.29h1.3a1 1 0 0 0 1-1v-1.3Z"]));
export const TabInPrivateRegular = ( /*#__PURE__*/createFluentIcon('TabInPrivateRegular', "1em", ["M5.5 3h9A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3ZM4 5.5v1.8L7.3 4H5.5C4.67 4 4 4.67 4 5.5Zm0 3.2v2.6L11.3 4H8.7L4 8.7ZM12.7 4 4 12.7v1.8c0 .23.05.45.15.65l11-11A1.5 1.5 0 0 0 14.5 4h-1.8Zm3.15.85-11 11c.2.1.42.15.65.15h1.8L16 7.3V5.5c0-.23-.05-.45-.15-.65ZM16 8.71 8.7 16h2.6l4.7-4.7V8.7Zm0 4L12.7 16h1.8c.83 0 1.5-.67 1.5-1.5v-1.8Z"]));
export const TabInprivateAccountFilled = ( /*#__PURE__*/createFluentIcon('TabInprivateAccountFilled', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v2.13c-.44-.3-.95-.52-1.5-.6V5.5a1 1 0 0 0-1-1h-9a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1H10v.44c0 .37.06.73.16 1.06H5.5A2.5 2.5 0 0 1 3 14.5v-9Zm15.57 9.03a1.5 1.5 0 0 0-1.12-.53h-4.9c-.46 0-.86.24-1.12.53-.26.29-.43.69-.43 1.09v.32c0 1.63 1.63 3.06 4 3.06 1.24 0 2.28-.4 2.99-1H15v-1h3.76c.15-.32.23-.65.24-1h-4v-1h3.87a1.78 1.78 0 0 0-.3-.47ZM15 13a2.5 2.5 0 1 1 2-4h-2v1h2.45a2.51 2.51 0 0 1 0 1H15v1h2c-.46.6-1.18 1-2 1Z"]));
export const TabInprivateAccountRegular = ( /*#__PURE__*/createFluentIcon('TabInprivateAccountRegular', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h4.66c-.1-.32-.15-.65-.16-1H5.5A1.5 1.5 0 0 1 4 14.5v-9C4 4.67 4.67 4 5.5 4h9c.83 0 1.5.67 1.5 1.5v1.64c.36.11.7.28 1 .49V5.5A2.5 2.5 0 0 0 14.5 3h-9Zm8 7.5c0 .83.67 1.5 1.5 1.5h2a2.5 2.5 0 1 1 0-3h-2c-.83 0-1.5.67-1.5 1.5Zm-1.32 4.7c.12-.14.26-.2.37-.2h6.32a1.78 1.78 0 0 0-.3-.47 1.5 1.5 0 0 0-1.12-.53h-4.9c-.46 0-.86.24-1.12.53-.26.29-.43.69-.43 1.09v.32c0 1.63 1.63 3.06 4 3.06 1.24 0 2.28-.4 2.99-1H15c-2.03 0-3-1.17-3-2.06v-.32c0-.13.06-.3.18-.43Zm5.32-4.7c0 .17-.02.34-.05.5H15v-1h2.45c.03.16.05.33.05.5Zm1.26 6.5H15v-1h4c0 .35-.1.68-.24 1Z"]));
export const TabProhibitedFilled = ( /*#__PURE__*/createFluentIcon('TabProhibitedFilled', "1em", ["M3 5.25C3 4.01 4 3 5.25 3h9.5C15.99 3 17 4 17 5.25V9.6a5.46 5.46 0 0 0-1.5-.5V5.24a.75.75 0 0 0-.75-.75h-9.5a.75.75 0 0 0-.75.75v9.5c0 .41.34.75.75.75h3.84c.1.53.27 1.03.51 1.5H5.25C4.01 17 3 16 3 14.75v-9.5ZM14.5 19a4.5 4.5 0 1 1 0-9 4.5 4.5 0 0 1 0 9Zm0-8a3.5 3.5 0 0 0-2.8 5.6l4.9-4.9a3.48 3.48 0 0 0-2.1-.7Zm-2.1 6.3a3.5 3.5 0 0 0 4.9-4.9l-4.9 4.9Z"]));
export const TabProhibitedRegular = ( /*#__PURE__*/createFluentIcon('TabProhibitedRegular', "1em", ["M3 5c0-1.1.9-2 2-2h10a2 2 0 0 1 2 2v4.6c-.32-.16-.65-.3-1-.4V5a1 1 0 0 0-1-1H5a1 1 0 0 0-1 1v10a1 1 0 0 0 1 1h4.2c.1.35.24.68.4 1H5a2 2 0 0 1-2-2V5Zm7 9.5a4.5 4.5 0 1 0 9 0 4.5 4.5 0 0 0-9 0Zm1 0a3.5 3.5 0 0 1 5.6-2.8l-4.9 4.9a3.48 3.48 0 0 1-.7-2.1Zm3.5 3.5c-.79 0-1.51-.26-2.1-.7l4.9-4.9a3.5 3.5 0 0 1-2.8 5.6Z"]));
export const TabShieldDismissFilled = ( /*#__PURE__*/createFluentIcon('TabShieldDismissFilled', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v2.73c-.34-.2-.67-.46-1-.8a1.4 1.4 0 0 0-.5-.34V5.5a1 1 0 0 0-1-1h-9a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h5.07a5.8 5.8 0 0 0 .96 1.5H5.5A2.5 2.5 0 0 1 3 14.5v-9Zm12.28 2.62c1 1.04 2.1 1.55 3.32 1.55.2 0 .36.14.4.34v2.57c0 2.69-1.31 4.51-3.87 5.4a.39.39 0 0 1-.26 0c-2.48-.86-3.79-2.6-3.87-5.15v-2.75a.4.4 0 0 1 .4-.41 4.5 4.5 0 0 0 3.32-1.55.39.39 0 0 1 .56 0ZM15 12.47l-1.36-1.36a.38.38 0 0 0-.53.53L14.47 13l-1.36 1.35a.38.38 0 0 0 .54.54L15 13.53l1.35 1.36a.38.38 0 0 0 .54-.54L15.53 13l1.36-1.36a.38.38 0 0 0-.54-.53L15 12.47Z"]));
export const TabShieldDismissRegular = ( /*#__PURE__*/createFluentIcon('TabShieldDismissRegular', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v2.73c-.34-.2-.67-.46-1-.8V5.5c0-.83-.67-1.5-1.5-1.5h-9C4.67 4 4 4.67 4 5.5v9c0 .83.67 1.5 1.5 1.5h5.32a5.75 5.75 0 0 0 .71 1H5.5A2.5 2.5 0 0 1 3 14.5v-9Zm15.6 4.17c-1.22 0-2.32-.51-3.32-1.55a.39.39 0 0 0-.56 0 4.5 4.5 0 0 1-3.32 1.55.4.4 0 0 0-.4.41v2.75c.08 2.55 1.4 4.29 3.87 5.15.09.03.17.03.26 0 2.56-.89 3.87-2.71 3.87-5.4v-2.57a.4.4 0 0 0-.4-.34Zm-4.96 1.44L15 12.47l1.35-1.36a.38.38 0 0 1 .54.54L15.53 13l1.36 1.35a.38.38 0 0 1-.54.54L15 13.53l-1.35 1.36a.38.38 0 0 1-.54-.54L14.47 13l-1.36-1.36a.38.38 0 0 1 .53-.53Z"]));
export const TableColor = ( /*#__PURE__*/createFluentIcon('TableColor', "1em", `<rect x="3" y="3" width="14" height="14" rx="3.5" fill="url(#ic_fluent_table_20_color__a)"/><path d="M13 17h1.5a2.5 2.5 0 0 0 2.5-2.5V13h-4v4Zm0-5V8h4v4h-4Zm-1 0H8V8h4v4Zm-4 1h4v4H8v-4Zm-1-1V8H3v4h4Zm-4 1h4v4H5.5A2.5 2.5 0 0 1 3 14.5V13Zm10-6h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4Zm-1-4v4H8V3h4ZM7 3v4H3V5.5A2.5 2.5 0 0 1 5.5 3H7Z" fill="url(#ic_fluent_table_20_color__b)"/><defs><linearGradient id="ic_fluent_table_20_color__a" x1="4" y1="4" x2="16" y2="16" gradientUnits="userSpaceOnUse"><stop stop-color="#B0F098"/><stop offset="1" stop-color="#98F0B0"/></linearGradient><linearGradient id="ic_fluent_table_20_color__b" x1="3" y1="3" x2="17" y2="17" gradientUnits="userSpaceOnUse"><stop stop-color="#42B870"/><stop offset="1" stop-color="#1A7F7C"/></linearGradient></defs>`, { color: true }));
export const TableFilled = ( /*#__PURE__*/createFluentIcon('TableFilled', "1em", ["M13 17h1.5a2.5 2.5 0 0 0 2.5-2.5V13h-4v4Zm0-5V8h4v4h-4Zm-1 0H8V8h4v4Zm-4 1h4v4H8v-4Zm-1-1V8H3v4h4Zm-4 1h4v4H5.5A2.5 2.5 0 0 1 3 14.5V13Zm10-6h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4Zm-1-4v4H8V3h4ZM7 3v4H3V5.5A2.5 2.5 0 0 1 5.5 3H7Z"]));
export const TableRegular = ( /*#__PURE__*/createFluentIcon('TableRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5v-9Zm-13 9V13h3v3H5.36A1.5 1.5 0 0 1 4 14.5Zm8-1.5v3H8v-3h4Zm2.5 3H13v-3h3V14.64A1.5 1.5 0 0 1 14.5 16ZM12 8v4H8V8h4Zm1 0h3v4h-3V8Zm-1-4v3H8V4h4Zm1 0H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM7 4v3H4V5.36A1.5 1.5 0 0 1 5.5 4H7Zm0 4v4H4V8h3Z"]));
export const TableAddFilled = ( /*#__PURE__*/createFluentIcon('TableAddFilled', "1em", ["M13 7h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4Zm-6 5V8H3v4h4Zm2.6 0A5.52 5.52 0 0 1 12 9.6V8H8v4h1.6Zm4.9-3c.9 0 1.75.22 2.5.6V8h-4v1.2c.48-.13.98-.2 1.5-.2ZM9 14.5c0-.52.07-1.02.2-1.5H8v4h1.6c-.38-.75-.6-1.6-.6-2.5ZM7 13H3v1.5A2.5 2.5 0 0 0 5.5 17H7v-4Zm5-6V3H8v4h4ZM7 3v4H3V5.5A2.5 2.5 0 0 1 5.5 3H7Zm12 11.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const TableAddRegular = ( /*#__PURE__*/createFluentIcon('TableAddRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h4.1c-.16-.32-.3-.65-.4-1H8v-3h1.2c.1-.35.24-.68.4-1H8V8h4v1.6c.32-.16.65-.3 1-.4V8h3v1.2c.35.1.68.24 1 .4V5.5Zm-13 9V13h3v3H5.36A1.5 1.5 0 0 1 4 14.5ZM12 4v3H8V4h4Zm1 0H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM7 4v3H4V5.36A1.5 1.5 0 0 1 5.5 4H7Zm0 4v4H4V8h3Zm12 6.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const TableAltTextFilled = ( /*#__PURE__*/createFluentIcon('TableAltTextFilled', "1em", ["M13 9h4V8h-4v1Zm-4 7.5V13H8v4h1.05a2.51 2.51 0 0 1-.05-.5ZM11.5 9h.5V8H8v4h1v-.5A2.5 2.5 0 0 1 11.5 9ZM7 12V8H3v4h4Zm-4 1h4v4H5.5A2.5 2.5 0 0 1 3 14.5V13Zm10-6h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4Zm-1-4v4H8V3h4ZM7 3v4H3V5.5A2.5 2.5 0 0 1 5.5 3H7Zm3 8.5c0-.83.67-1.5 1.5-1.5h6c.83 0 1.5.67 1.5 1.5v5c0 .83-.67 1.5-1.5 1.5h-6a1.5 1.5 0 0 1-1.5-1.5v-5Zm7 4a.5.5 0 0 0-.5-.5h-4a.5.5 0 0 0 0 1h4a.5.5 0 0 0 .5-.5ZM12.5 12a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Z"]));
export const TableAltTextRegular = ( /*#__PURE__*/createFluentIcon('TableAltTextRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h3.55a2.51 2.51 0 0 1-.05-.5V16H8v-3h1v-1H8V8h4v1h1V8h3v1h1V5.5Zm-13 9V13h3v3H5.36A1.5 1.5 0 0 1 4 14.5ZM12 7H8V4h4v3Zm1-3H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM4 7V5.36A1.5 1.5 0 0 1 5.5 4H7v3H4Zm3 1v4H4V8h3Zm3 3.5c0-.83.67-1.5 1.5-1.5h6c.83 0 1.5.67 1.5 1.5v5c0 .83-.67 1.5-1.5 1.5h-6a1.5 1.5 0 0 1-1.5-1.5v-5Zm7 4a.5.5 0 0 0-.5-.5h-4a.5.5 0 0 0 0 1h4a.5.5 0 0 0 .5-.5ZM12.5 12a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Z"]));
export const TableArrowRepeatAllFilled = ( /*#__PURE__*/createFluentIcon('TableArrowRepeatAllFilled', "1em", ["M17 11h-.08a1.5 1.5 0 0 0-.36-.56l-1.5-1.5A1.5 1.5 0 0 0 13 8.88V8h4v3Zm-5-1a4 4 0 0 0-3.46 2H8V8h4v2ZM7 8v4H3V8h4Zm0 5H3v1.5A2.5 2.5 0 0 0 5.5 17H7v-4Zm10-6h-4V3h1.5A2.5 2.5 0 0 1 17 5.5V7Zm-5 0V3H8v4h4ZM7 7V3H5.5A2.5 2.5 0 0 0 3 5.5V7h4Zm7.35 2.65a.5.5 0 0 0-.7.7l.64.65H12a3 3 0 0 0-2.4 4.8.5.5 0 1 0 .8-.6A2 2 0 0 1 12 12h2.3l-.65.65a.5.5 0 0 0 .7.7l1.5-1.5a.5.5 0 0 0 0-.7l-1.5-1.5Zm3.05 2.55a.5.5 0 0 0-.8.6A2 2 0 0 1 15 16h-2.3l.65-.65a.5.5 0 0 0-.7-.7l-1.5 1.5a.5.5 0 0 0 0 .7l1.5 1.5a.5.5 0 0 0 .7-.7l-.64-.65H15a3 3 0 0 0 2.4-4.8Z"]));
export const TableArrowRepeatAllRegular = ( /*#__PURE__*/createFluentIcon('TableArrowRepeatAllRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h4.47a1.5 1.5 0 0 1-1.17-.6c-.1-.13-.18-.26-.26-.4H8v-3h.13c.09-.35.23-.7.4-1H8V8h4v2h.5a1.5 1.5 0 0 1 .5-1.12V8h3v1.88l.56.56c.17.16.28.36.36.56H17V5.5Zm-13 9V13h3v3H5.36A1.5 1.5 0 0 1 4 14.5ZM12 7H8V4h4v3Zm1-3H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM4 7V5.36A1.5 1.5 0 0 1 5.5 4H7v3H4Zm3 1v4H4V8h3Zm7.35 1.65a.5.5 0 0 0-.7.7l.64.65H12a3 3 0 0 0-2.4 4.8.5.5 0 1 0 .8-.6A2 2 0 0 1 12 12h2.3l-.65.65a.5.5 0 0 0 .7.7l1.5-1.5a.5.5 0 0 0 0-.7l-1.5-1.5Zm3.05 2.55a.5.5 0 0 0-.8.6A2 2 0 0 1 15 16h-2.3l.65-.65a.5.5 0 0 0-.7-.7l-1.5 1.5a.5.5 0 0 0 0 .7l1.5 1.5a.5.5 0 0 0 .7-.7l-.64-.65H15a3 3 0 0 0 2.4-4.8Z"]));
export const TableArrowUpFilled = ( /*#__PURE__*/createFluentIcon('TableArrowUpFilled', "1em", ["M17 7h-4V3h1.5A2.5 2.5 0 0 1 17 5.5V7ZM7 8v4H3V8h4Zm5 1.6A5.52 5.52 0 0 0 9.6 12H8V8h4v1.6Zm5 0a5.48 5.48 0 0 0-4-.4V8h4v1.6ZM9.2 13a5.5 5.5 0 0 0 .4 4H8v-4h1.2ZM3 13h4v4H5.5A2.5 2.5 0 0 1 3 14.5V13Zm9-10v4H8V3h4ZM7 7V3H5.5A2.5 2.5 0 0 0 3 5.5V7h4Zm12 7.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15.35a.5.5 0 0 0 0-.7l-2-2a.5.5 0 0 0-.35-.15.5.5 0 0 0-.35.15l-2 2a.5.5 0 0 0 .7.7L14 13.71v2.79a.5.5 0 1 0 1 0v-2.8l1.15 1.15c.2.2.5.2.7 0Z"]));
export const TableArrowUpRegular = ( /*#__PURE__*/createFluentIcon('TableArrowUpRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v4.1c-.32-.16-.65-.3-1-.4V8h-3v1.2c-.35.1-.68.24-1 .4V8H8v4h1.6c-.16.32-.3.65-.4 1H8v3h1.2c.1.35.24.68.4 1H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9ZM4 13v1.5c0 .78.6 1.42 1.36 1.5H7v-3H4Zm4-6h4V4H8v3Zm6.5-3H13v3h3V5.5c0-.78-.6-1.42-1.36-1.5h-.14ZM4 5.5V7h3V4H5.5c-.78 0-1.42.6-1.5 1.36v.14ZM7 12V8H4v4h3Zm12 2.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15.35a.5.5 0 0 0 0-.7l-2-2a.5.5 0 0 0-.35-.15.5.5 0 0 0-.35.15l-2 2a.5.5 0 0 0 .7.7L14 13.71v2.79a.5.5 0 1 0 1 0v-2.8l1.15 1.15c.2.2.5.2.7 0Z"]));
export const TableBottomRowFilled = ( /*#__PURE__*/createFluentIcon('TableBottomRowFilled', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5V12h-1V5.5c0-.78-.6-1.42-1.36-1.5H5.5c-.78 0-1.42.6-1.5 1.36V12H3V5.5A2.5 2.5 0 0 1 5.5 3h9ZM17 14.5a2.5 2.5 0 0 1-2.5 2.5H13v-4h4v1.5Zm-13 2c.42.31.94.5 1.5.5H7v-4H3v1.5c0 .82.4 1.54 1 2ZM8 13h4v4H8v-4Z"]));
export const TableBottomRowRegular = ( /*#__PURE__*/createFluentIcon('TableBottomRowRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9ZM4 13v1.5c0 .78.6 1.42 1.36 1.5H7v-3H4Zm4 3h4v-3H8v3Zm5 0h1.5c.78 0 1.42-.6 1.5-1.36V13h-3v3Zm3-4V5.5c0-.78-.6-1.42-1.36-1.5H5.5c-.78 0-1.42.6-1.5 1.36V12h12Z"]));
export const TableCalculatorFilled = ( /*#__PURE__*/createFluentIcon('TableCalculatorFilled', "1em", ["M13 7h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4Zm-6 5V8H3v4h4Zm5-3.5V8H8v4h3v-1.5c0-.82.4-1.54 1-2ZM11 13H8v4h3v-4Zm-4 0H3v1.5A2.5 2.5 0 0 0 5.5 17H7v-4Zm5-6V3H8v4h4ZM7 3v4H3V5.5A2.5 2.5 0 0 1 5.5 3H7Zm5 7.5c0-.83.67-1.5 1.5-1.5h4c.83 0 1.5.67 1.5 1.5v7c0 .83-.67 1.5-1.5 1.5h-4a1.5 1.5 0 0 1-1.5-1.5v-7Zm2.5 2.5h-1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1Zm3.5.5a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 .5-.5ZM14.5 15h-1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1Zm3.5.5a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 .5-.5ZM14.5 17h-1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1Zm3.5.5a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 .5-.5ZM13.5 10a.5.5 0 0 0-.5.5v1c0 .28.22.5.5.5h4a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-4Z"]));
export const TableCalculatorRegular = ( /*#__PURE__*/createFluentIcon('TableCalculatorRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17H11v-1H8v-3h3v-1H8V8h4v.5c.3-.22.63-.38 1-.45V8h4V5.5Zm-13 9V13h3v3H5.36A1.5 1.5 0 0 1 4 14.5ZM12 7H8V4h4v3Zm1-3H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM4 7V5.36A1.5 1.5 0 0 1 5.5 4H7v3H4Zm3 1v4H4V8h3Zm5 2.5c0-.83.67-1.5 1.5-1.5h4c.83 0 1.5.67 1.5 1.5v7c0 .83-.67 1.5-1.5 1.5h-4a1.5 1.5 0 0 1-1.5-1.5v-7Zm2.5 2.5h-1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1Zm3.5.5a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 .5-.5ZM14.5 15h-1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1Zm3.5.5a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 .5-.5ZM14.5 17h-1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1Zm3.5.5a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 .5-.5ZM13.5 10a.5.5 0 0 0-.5.5v1c0 .28.22.5.5.5h4a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-4Z"]));
export const TableCellAddFilled = ( /*#__PURE__*/createFluentIcon('TableCellAddFilled', "1em", ["M9 3a2 2 0 0 0-2 2v1h6V5a2 2 0 0 0-2-2H9Zm4 4H7v6h2.2A5.51 5.51 0 0 1 13 9.2V7Zm-6 7h2.02a5.57 5.57 0 0 0 .58 3H9a2 2 0 0 1-2-2v-1Zm10-5v.6a5.48 5.48 0 0 0-3-.58V7h1a2 2 0 0 1 2 2ZM6 13V7H5a2 2 0 0 0-2 2v2c0 1.1.9 2 2 2h1Zm13 1.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const TableCellAddRegular = ( /*#__PURE__*/createFluentIcon('TableCellAddRegular', "1em", ["M9 3a2 2 0 0 0-2 2v2H5a2 2 0 0 0-2 2v2c0 1.1.9 2 2 2h2v2c0 1.1.9 2 2 2h.6c-.16-.32-.3-.65-.4-1H9a1 1 0 0 1-1-1v-2h1.2c.1-.35.24-.68.4-1H8V8h4v1.6c.32-.16.65-.3 1-.4V8h2a1 1 0 0 1 1 1v.2c.35.1.68.24 1 .4V9a2 2 0 0 0-2-2h-2V5a2 2 0 0 0-2-2H9Zm3 4H8V5a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v2ZM7 8v4H5a1 1 0 0 1-1-1V9a1 1 0 0 1 1-1h2Zm12 6.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const TableCellCenterFilled = ( /*#__PURE__*/createFluentIcon('TableCellCenterFilled', "1em", ["M13 17h1.5a2.5 2.5 0 0 0 2.5-2.5V13h-4v4Zm0-5V8h4v4h-4Zm-5 1h4v4H8v-4Zm-1-1V8H3v4h4Zm-4 1h4v4H5.5A2.5 2.5 0 0 1 3 14.5V13Zm10-6h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4Zm-1-4v4H8V3h4ZM7 3v4H3V5.5A2.5 2.5 0 0 1 5.5 3H7Z"]));
export const TableCellCenterRegular = ( /*#__PURE__*/createFluentIcon('TableCellCenterRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5v-9Zm-13 9V13h3v3H5.36A1.5 1.5 0 0 1 4 14.5Zm8-1.5v3H8v-3h4Zm2.5 3H13v-3h3V14.64A1.5 1.5 0 0 1 14.5 16ZM13 8h3v4h-3V8Zm-1-4v3H8V4h4Zm1 0H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM7 4v3H4V5.36A1.5 1.5 0 0 1 5.5 4H7Zm0 4v4H4V8h3Z"]));
export const TableCellCenterArrowRepeatAllFilled = ( /*#__PURE__*/createFluentIcon('TableCellCenterArrowRepeatAllFilled', "1em", ["M17 11h-.08a1.5 1.5 0 0 0-.36-.56l-1.5-1.5A1.5 1.5 0 0 0 13 8.88V8h4v3ZM7 8v4H3V8h4Zm0 5H3v1.5A2.5 2.5 0 0 0 5.5 17H7v-4Zm10-6h-4V3h1.5A2.5 2.5 0 0 1 17 5.5V7Zm-5 0V3H8v4h4ZM7 7V3H5.5A2.5 2.5 0 0 0 3 5.5V7h4Zm7.35 2.65a.5.5 0 0 0-.7.7l.64.65H12a3 3 0 0 0-2.4 4.8.5.5 0 1 0 .8-.6A2 2 0 0 1 12 12h2.3l-.65.65a.5.5 0 0 0 .7.7l1.5-1.5a.5.5 0 0 0 0-.7l-1.5-1.5Zm3.05 2.55a.5.5 0 0 0-.8.6A2 2 0 0 1 15 16h-2.3l.65-.65a.5.5 0 0 0-.7-.7l-1.5 1.5a.5.5 0 0 0 0 .7l1.5 1.5a.5.5 0 0 0 .7-.7l-.64-.65H15a3 3 0 0 0 2.4-4.8Z"]));
export const TableCellCenterArrowRepeatAllRegular = ( /*#__PURE__*/createFluentIcon('TableCellCenterArrowRepeatAllRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h4.47a1.5 1.5 0 0 1-1.17-.6c-.1-.13-.18-.26-.26-.4H8v-3h.13A4 4 0 0 1 12 10h.5a1.5 1.5 0 0 1 .5-1.12V8h3v1.88l.56.56c.17.16.28.36.36.56H17V5.5Zm-13 9V13h3v3H5.36A1.5 1.5 0 0 1 4 14.5ZM12 7H8V4h4v3Zm1-3H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM4 7V5.36A1.5 1.5 0 0 1 5.5 4H7v3H4Zm3 1v4H4V8h3Zm7.35 1.65a.5.5 0 0 0-.7.7l.64.65H12a3 3 0 0 0-2.4 4.8.5.5 0 1 0 .8-.6A2 2 0 0 1 12 12h2.3l-.65.65a.5.5 0 0 0 .7.7l1.5-1.5a.5.5 0 0 0 0-.7l-1.5-1.5Zm3.05 2.55a.5.5 0 0 0-.8.6A2 2 0 0 1 15 16h-2.3l.65-.65a.5.5 0 0 0-.7-.7l-1.5 1.5a.5.5 0 0 0 0 .7l1.5 1.5a.5.5 0 0 0 .7-.7l-.64-.65H15a3 3 0 0 0 2.4-4.8Z"]));
export const TableCellCenterEditFilled = ( /*#__PURE__*/createFluentIcon('TableCellCenterEditFilled', "1em", ["M15.1 9.84c.53-.53 1.21-.8 1.9-.84V8h-4v3.94l2.1-2.1Zm-4.83 4.83L11.94 13H8v4h1.22l.21-.84a3.2 3.2 0 0 1 .84-1.49ZM7 12V8H3v4h4Zm-4 1h4v4H5.5A2.5 2.5 0 0 1 3 14.5V13Zm10-6h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4Zm-1-4v4H8V3h4ZM7 3v4H3V5.5A2.5 2.5 0 0 1 5.5 3H7Zm3.98 12.38 4.83-4.83a1.87 1.87 0 1 1 2.64 2.64l-4.83 4.83a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.07l.37-1.5c.1-.39.3-.74.58-1.02Z"]));
export const TableCellCenterEditRegular = ( /*#__PURE__*/createFluentIcon('TableCellCenterEditRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h3.72l.21-.84.05-.16H8v-3h3.94L13 11.94V8h3v1.23c.32-.13.66-.21 1-.23V5.5Zm-13 9V13h3v3H5.36A1.5 1.5 0 0 1 4 14.5ZM12 7H8V4h4v3Zm1-3H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM4 7V5.36A1.5 1.5 0 0 1 5.5 4H7v3H4Zm3 1v4H4V8h3Zm3.98 7.38 4.83-4.83a1.87 1.87 0 1 1 2.64 2.64l-4.83 4.83a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.07l.37-1.5c.1-.39.3-.74.58-1.02Z"]));
export const TableCellCenterLinkFilled = ( /*#__PURE__*/createFluentIcon('TableCellCenterLinkFilled', "1em", ["M13 12V8h4v4h-4Zm-4 3.5c0-.98.4-1.86 1.05-2.5H8v4h1.34A3.49 3.49 0 0 1 9 15.5ZM7 12V8H3v4h4Zm-4 1h4v4H5.5A2.5 2.5 0 0 1 3 14.5V13Zm10-6h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4Zm-1-4v4H8V3h4ZM7 3v4H3V5.5A2.5 2.5 0 0 1 5.5 3H7Zm5.5 10a2.5 2.5 0 0 0 0 5h.5a.5.5 0 0 0 0-1h-.5a1.5 1.5 0 0 1 0-3h.5a.5.5 0 0 0 0-1h-.5Zm3.5 0a.5.5 0 0 0 0 1h.5a1.5 1.5 0 0 1 0 3H16a.5.5 0 0 0 0 1h.5a2.5 2.5 0 0 0 0-5H16Zm-4 2.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z"]));
export const TableCellCenterLinkRegular = ( /*#__PURE__*/createFluentIcon('TableCellCenterLinkRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h3.84a3.48 3.48 0 0 1-.3-1H8v-3h2.05c.63-.62 1.5-1 2.45-1h.5V8h3v4h.5c.17 0 .34.01.5.04V5.5Zm-13 9V13h3v3H5.36A1.5 1.5 0 0 1 4 14.5ZM12 7H8V4h4v3Zm1-3H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM4 7V5.36A1.5 1.5 0 0 1 5.5 4H7v3H4Zm3 1v4H4V8h3Zm5.5 5a2.5 2.5 0 0 0 0 5h.5a.5.5 0 0 0 0-1h-.5a1.5 1.5 0 0 1 0-3h.5a.5.5 0 0 0 0-1h-.5Zm3.5 0a.5.5 0 0 0 0 1h.5a1.5 1.5 0 0 1 0 3H16a.5.5 0 0 0 0 1h.5a2.5 2.5 0 0 0 0-5H16Zm-4 2.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z"]));
export const TableCellCenterSearchFilled = ( /*#__PURE__*/createFluentIcon('TableCellCenterSearchFilled', "1em", ["M13 17h1.5a2.5 2.5 0 0 0 2.5-2.5V13h-4v4Zm0-5V8h4v4h-4ZM4.5 9c.93 0 1.78.28 2.5.76V8H3v1.26A4.5 4.5 0 0 1 4.5 9Zm4.06 6.44L10.12 17H12v-4H8.97a4.55 4.55 0 0 1-.4 2.44ZM13 7h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4Zm-1-4v4H8V3h4ZM7 3v4H3V5.5A2.5 2.5 0 0 1 5.5 3H7ZM4.5 17c.79 0 1.51-.26 2.1-.7l2.55 2.55a.5.5 0 1 0 .7-.7L7.3 15.6A3.5 3.5 0 1 0 4.5 17Zm0-1a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5Z"]));
export const TableCellCenterSearchRegular = ( /*#__PURE__*/createFluentIcon('TableCellCenterSearchRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v3.76c.32-.12.65-.2 1-.23V8h3v1.76A4.5 4.5 0 0 1 8.97 13H12v3H9.12l1 1h4.38a2.5 2.5 0 0 0 2.5-2.5v-9ZM14.5 16H13v-3h3V14.64A1.5 1.5 0 0 1 14.5 16ZM13 8h3v4h-3V8Zm-1-1H8V4h4v3Zm1-3H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM4 7V5.36A1.5 1.5 0 0 1 5.5 4H7v3H4Zm.5 10c.79 0 1.51-.26 2.1-.7l2.55 2.55a.5.5 0 1 0 .7-.7L7.3 15.6A3.5 3.5 0 1 0 4.5 17Zm0-1a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5Z"]));
export const TableCellEditFilled = ( /*#__PURE__*/createFluentIcon('TableCellEditFilled', "1em", ["M8 13h1.98c.1-.12.19-.23.3-.33L12 10.94V7H8v6Zm7.1-5.16c.26-.26.55-.45.86-.6A2 2 0 0 0 15 7h-2v2.94l2.1-2.1ZM5 13a2 2 0 0 1-2-2V9c0-1.1.9-2 2-2h2v6H5Zm10.8-4.45-4.82 4.83a2.2 2.2 0 0 0-.58 1.02l-.37 1.5a.89.89 0 0 0 1.08 1.07l1.5-.37c.38-.1.73-.3 1.01-.58l4.83-4.83a1.87 1.87 0 0 0-2.64-2.64Z"]));
export const TableCellEditRegular = ( /*#__PURE__*/createFluentIcon('TableCellEditRegular', "1em", ["M9.98 13c.1-.12.19-.23.3-.33l.66-.67H8V8h4v2.94l1-1V8h1.94l.16-.16c.26-.26.55-.45.86-.6A2 2 0 0 0 15 7H5a2 2 0 0 0-2 2v2c0 1.1.9 2 2 2h4.98ZM7 8v4H5a1 1 0 0 1-1-1V9a1 1 0 0 1 1-1h2Zm8.8.55-4.82 4.83a2.2 2.2 0 0 0-.58 1.02l-.37 1.5a.89.89 0 0 0 1.08 1.07l1.5-.37c.38-.1.73-.3 1.01-.58l4.83-4.83a1.87 1.87 0 0 0-2.64-2.64Z"]));
export const TableCellsMergeFilled = ( /*#__PURE__*/createFluentIcon('TableCellsMergeFilled', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3H3Zm0 1v6h14V7H3Zm4.35 1.85-.64.65h6.58l-.64-.65a.5.5 0 0 1 .7-.7l1.5 1.5c.2.2.2.5 0 .7l-1.5 1.5a.5.5 0 0 1-.7-.7l.64-.65H6.71l.64.65a.5.5 0 0 1-.7.7l-1.5-1.5a.5.5 0 0 1 0-.7l1.5-1.5a.5.5 0 1 1 .7.7ZM3 14h14a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3Z"]));
export const TableCellsMergeRegular = ( /*#__PURE__*/createFluentIcon('TableCellsMergeRegular', "1em", ["M7.35 8.85a.5.5 0 1 0-.7-.7l-1.5 1.5a.5.5 0 0 0 0 .7l1.5 1.5a.5.5 0 0 0 .7-.7l-.64-.65h6.58l-.64.65a.5.5 0 0 0 .7.7l1.5-1.5a.5.5 0 0 0 0-.7l-1.5-1.5a.5.5 0 0 0-.7.7l.64.65H6.71l.64-.65ZM6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6ZM4 7h12v6H4V7Zm10 9H6a2 2 0 0 1-2-2h12a2 2 0 0 1-2 2Zm2-10H4c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2Z"]));
export const TableCellsSplitFilled = ( /*#__PURE__*/createFluentIcon('TableCellsSplitFilled', "1em", ["M10 6h7v-.5A2.5 2.5 0 0 0 14.5 3H10v3Zm7 7V7H3v6h14Zm-7-5v4H9V8h1Zm0 9h4.5a2.5 2.5 0 0 0 2.5-2.5V14h-7v3Zm-1-3H3v.5A2.5 2.5 0 0 0 5.5 17H9v-3Zm0-8V3H5.5A2.5 2.5 0 0 0 3 5.5V6h6Z"]));
export const TableCellsSplitRegular = ( /*#__PURE__*/createFluentIcon('TableCellsSplitRegular', "1em", ["M10 8v4H9V8h1Zm7-2.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5v-9Zm-13 9V14h5v2H5.36A1.5 1.5 0 0 1 4 14.5ZM9 4v2H4v-.64A1.5 1.5 0 0 1 5.5 4H9Zm1 2V4h4.64A1.5 1.5 0 0 1 16 5.5V6h-6Zm6 7H4V7h12v6Zm0 1.5v.14A1.5 1.5 0 0 1 14.5 16H10v-2h6v.5Z"]));
export const TableCheckerFilled = ( /*#__PURE__*/createFluentIcon('TableCheckerFilled', "1em", ["M7 3v4H3V5.5A2.5 2.5 0 0 1 5.5 3H7Zm5 5H8v4h4V8Zm1 5h4v1.5a2.5 2.5 0 0 1-2.5 2.5H13v-4ZM8 4h6.5c.83 0 1.5.67 1.5 1.5V12h1V5.5A2.5 2.5 0 0 0 14.5 3H8v1ZM5.5 16H12v1H5.5A2.5 2.5 0 0 1 3 14.5V8h1v6.5c0 .83.67 1.5 1.5 1.5Z"]));
export const TableCheckerRegular = ( /*#__PURE__*/createFluentIcon('TableCheckerRegular', "1em", ["M16 5.5V11h1V5.5A2.5 2.5 0 0 0 14.5 3H9v1h5.5c.83 0 1.5.67 1.5 1.5ZM3 9v5.5A2.5 2.5 0 0 0 5.5 17H11v-1H5.5A1.5 1.5 0 0 1 4 14.5V9H3Zm2.5-6H8v4h5v5h4v2.5a2.5 2.5 0 0 1-2.5 2.5H12v-4H7V8H3V5.5A2.5 2.5 0 0 1 5.5 3Zm9 13c.78 0 1.42-.6 1.5-1.36V13h-3v3h1.5ZM12 8H8v4h4V8ZM4 7h3V4H5.5c-.78 0-1.42.6-1.5 1.36V7Z"]));
export const TableColumnTopBottomFilled = ( /*#__PURE__*/createFluentIcon('TableColumnTopBottomFilled', "1em", ["M13 17h1.5a2.5 2.5 0 0 0 2.5-2.5V13h-4v4Zm0-5V8h4v4h-4Zm-1 0H8V8h4v4Zm-4 4h4v1H8v-1Zm-1-4V8H3v4h4Zm-4 1h4v4H5.5A2.5 2.5 0 0 1 3 14.5V13Zm10-6h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4ZM8 4h4V3H8v1ZM7 3v4H3V5.5A2.5 2.5 0 0 1 5.5 3H7Z"]));
export const TableColumnTopBottomRegular = ( /*#__PURE__*/createFluentIcon('TableColumnTopBottomRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5v-9Zm-13 9V13h3v3H5.36A1.5 1.5 0 0 1 4 14.5ZM14.5 16H13v-3h3V14.64A1.5 1.5 0 0 1 14.5 16ZM12 8v4H8V8h4Zm1 0h3v4h-3V8Zm0-4H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM4 7V5.36A1.5 1.5 0 0 1 5.5 4H7v3H4Zm3 1v4H4V8h3Z"]));
export const TableColumnTopBottomArrowRepeatAllFilled = ( /*#__PURE__*/createFluentIcon('TableColumnTopBottomArrowRepeatAllFilled', "1em", ["M17 11h-.08a1.5 1.5 0 0 0-.36-.56l-1.5-1.5A1.5 1.5 0 0 0 13 8.88V8h4v3Zm-5-1a4 4 0 0 0-3.46 2H8V8h4v2ZM7 8v4H3V8h4Zm0 5H3v1.5A2.5 2.5 0 0 0 5.5 17H7v-4Zm10-6h-4V3h1.5A2.5 2.5 0 0 1 17 5.5V7Zm-5-3H8V3h4v1ZM7 7V3H5.5A2.5 2.5 0 0 0 3 5.5V7h4Zm7.35 2.65a.5.5 0 0 0-.7.7l.64.65H12a3 3 0 0 0-2.4 4.8.5.5 0 1 0 .8-.6A2 2 0 0 1 12 12h2.3l-.65.65a.5.5 0 0 0 .7.7l1.5-1.5a.5.5 0 0 0 0-.7l-1.5-1.5Zm3.05 2.55a.5.5 0 0 0-.8.6A2 2 0 0 1 15 16h-2.3l.65-.65a.5.5 0 0 0-.7-.7l-1.5 1.5a.5.5 0 0 0 0 .7l1.5 1.5a.5.5 0 0 0 .7-.7l-.64-.65H15a3 3 0 0 0 2.4-4.8Z"]));
export const TableColumnTopBottomArrowRepeatAllRegular = ( /*#__PURE__*/createFluentIcon('TableColumnTopBottomArrowRepeatAllRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h4.47a1.5 1.5 0 0 1-1.17-.6 3.99 3.99 0 0 1-.26-4.4H8V8h4v2h.5a1.5 1.5 0 0 1 .5-1.12V8h3v1.88l.56.56c.17.16.28.36.36.56H17V5.5Zm-13 9V13h3v3H5.36A1.5 1.5 0 0 1 4 14.5ZM13 4H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM4 7V5.36A1.5 1.5 0 0 1 5.5 4H7v3H4Zm3 1v4H4V8h3Zm7.35 1.65a.5.5 0 0 0-.7.7l.64.65H12a3 3 0 0 0-2.4 4.8.5.5 0 1 0 .8-.6A2 2 0 0 1 12 12h2.3l-.65.65a.5.5 0 0 0 .7.7l1.5-1.5a.5.5 0 0 0 0-.7l-1.5-1.5Zm3.05 2.55a.5.5 0 0 0-.8.6A2 2 0 0 1 15 16h-2.3l.65-.65a.5.5 0 0 0-.7-.7l-1.5 1.5a.5.5 0 0 0 0 .7l1.5 1.5a.5.5 0 0 0 .7-.7l-.64-.65H15a3 3 0 0 0 2.4-4.8Z"]));
export const TableColumnTopBottomEditFilled = ( /*#__PURE__*/createFluentIcon('TableColumnTopBottomEditFilled', "1em", ["M15.1 9.84c.53-.53 1.21-.8 1.9-.84V8h-4v3.94l2.1-2.1Zm-5.67 6.32.05-.16H8v1h1.22l.21-.84ZM12 12H8V8h4v4Zm-5 0V8H3v4h4Zm-4 1h4v4H5.5A2.5 2.5 0 0 1 3 14.5V13Zm10-6h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4ZM8 4h4V3H8v1ZM7 3v4H3V5.5A2.5 2.5 0 0 1 5.5 3H7Zm3.98 12.38 4.83-4.83a1.87 1.87 0 1 1 2.64 2.64l-4.83 4.83a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.07l.37-1.5c.1-.39.3-.74.58-1.02Z"]));
export const TableColumnTopBottomEditRegular = ( /*#__PURE__*/createFluentIcon('TableColumnTopBottomEditRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h3.72l.21-.84a3.2 3.2 0 0 1 .84-1.49L13 11.94V8h3v1.23c.32-.13.66-.21 1-.23V5.5Zm-13 9V13h3v3H5.36A1.5 1.5 0 0 1 4 14.5ZM12 8v4H8V8h4Zm1-4H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM4 7V5.36A1.5 1.5 0 0 1 5.5 4H7v3H4Zm3 1v4H4V8h3Zm3.98 7.38 4.83-4.83a1.87 1.87 0 1 1 2.64 2.64l-4.83 4.83a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.07l.37-1.5c.1-.39.3-.74.58-1.02Z"]));
export const TableColumnTopBottomLinkFilled = ( /*#__PURE__*/createFluentIcon('TableColumnTopBottomLinkFilled', "1em", ["M13 12V8h4v4h-4Zm-3.66 5a3.48 3.48 0 0 1-.3-1H8v1h1.34ZM12 12H8V8h4v4Zm-5 0V8H3v4h4Zm-4 1h4v4H5.5A2.5 2.5 0 0 1 3 14.5V13Zm10-6h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4ZM8 4h4V3H8v1ZM7 3v4H3V5.5A2.5 2.5 0 0 1 5.5 3H7Zm5.5 10a2.5 2.5 0 0 0 0 5h.5a.5.5 0 0 0 0-1h-.5a1.5 1.5 0 0 1 0-3h.5a.5.5 0 0 0 0-1h-.5Zm3.5 0a.5.5 0 0 0 0 1h.5a1.5 1.5 0 0 1 0 3H16a.5.5 0 0 0 0 1h.5a2.5 2.5 0 0 0 0-5H16Zm-4 2.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z"]));
export const TableColumnTopBottomLinkRegular = ( /*#__PURE__*/createFluentIcon('TableColumnTopBottomLinkRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h3.84a3.5 3.5 0 0 1 3.16-5h.5V8h3v4h.5c.17 0 .34.01.5.04V5.5Zm-13 9V13h3v3H5.36A1.5 1.5 0 0 1 4 14.5ZM12 8v4H8V8h4Zm1-4H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM4 7V5.36A1.5 1.5 0 0 1 5.5 4H7v3H4Zm3 1v4H4V8h3Zm5.5 5a2.5 2.5 0 0 0 0 5h.5a.5.5 0 0 0 0-1h-.5a1.5 1.5 0 0 1 0-3h.5a.5.5 0 0 0 0-1h-.5Zm3.5 0a.5.5 0 0 0 0 1h.5a1.5 1.5 0 0 1 0 3H16a.5.5 0 0 0 0 1h.5a2.5 2.5 0 0 0 0-5H16Zm-4 2.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z"]));
export const TableColumnTopBottomSearchFilled = ( /*#__PURE__*/createFluentIcon('TableColumnTopBottomSearchFilled', "1em", ["M13 17h1.5a2.5 2.5 0 0 0 2.5-2.5V13h-4v4Zm0-5V8h4v4h-4Zm-1 0H8.74A4.5 4.5 0 0 0 8 10.67V8h4v4Zm-2.88 4 1 1H12v-1H9.12ZM4.5 9c.93 0 1.78.28 2.5.76V8H3v1.26A4.5 4.5 0 0 1 4.5 9ZM13 7h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4ZM8 4h4V3H8v1ZM7 3v4H3V5.5A2.5 2.5 0 0 1 5.5 3H7ZM4.5 17c.79 0 1.51-.26 2.1-.7l2.55 2.55a.5.5 0 1 0 .7-.7L7.3 15.6A3.5 3.5 0 1 0 4.5 17Zm0-1a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5Z"]));
export const TableColumnTopBottomSearchRegular = ( /*#__PURE__*/createFluentIcon('TableColumnTopBottomSearchRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v3.76c.32-.12.65-.2 1-.23V8h3v1.76c.38.25.71.56 1 .91V8h4v4H8.74a4.5 4.5 0 0 1-.18 3.44L10.12 17h4.38a2.5 2.5 0 0 0 2.5-2.5v-9ZM14.5 16H13v-3h3V14.64A1.5 1.5 0 0 1 14.5 16ZM13 8h3v4h-3V8Zm0-4H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM4 7V5.36A1.5 1.5 0 0 1 5.5 4H7v3H4Zm.5 10c.79 0 1.51-.26 2.1-.7l2.55 2.55a.5.5 0 1 0 .7-.7L7.3 15.6A3.5 3.5 0 1 0 4.5 17Zm0-1a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5Z"]));
export const TableCopyFilled = ( /*#__PURE__*/createFluentIcon('TableCopyFilled', "1em", ["M4 6v6a4 4 0 0 0 4 4h6.24A3 3 0 0 1 12 17H8a5 5 0 0 1-5-5V8a3 3 0 0 1 1-2.24V6Zm4 6v3a3 3 0 0 1-3-3h3Zm5 0v3H9v-3h4Zm4 0a3 3 0 0 1-3 3v-3h3ZM8 7v4H5V7h3Zm5 0v4H9V7h4Zm4 0v4h-3V7h3ZM8 6H5a3 3 0 0 1 3-3v3Zm5-3v3H9V3h4Zm1 0a3 3 0 0 1 3 3h-3V3Z"]));
export const TableCopyRegular = ( /*#__PURE__*/createFluentIcon('TableCopyRegular', "1em", ["M4 6v6a4 4 0 0 0 4 4h6.24A3 3 0 0 1 12 17H8a5 5 0 0 1-5-5V8a3 3 0 0 1 1-2.24V6Zm10-3a3 3 0 0 1 3 3v6.15A3 3 0 0 1 14 15H8a3 3 0 0 1-3-3V6a3 3 0 0 1 2.85-3H14Zm-8 8v1c0 1.1.9 2 2 2h1v-3H6Zm4 0v3h2v-3h-2Zm3 0v3h1a2 2 0 0 0 1.99-1.8L16 12v-1h-3ZM6 8v2h3V8H6Zm4 0v2h2V8h-2Zm3 0v2h3V8h-3ZM8 4l-.2.01A2 2 0 0 0 6 6v1h3V4H8Zm2 0v3h2V4h-2Zm3 0v3h3V6a2 2 0 0 0-2-2h-1Z"]));
export const TableCursorFilled = ( /*#__PURE__*/createFluentIcon('TableCursorFilled', "1em", ["M13.56 9.44 16.15 12H17V8h-4v1.08c.2.08.4.2.56.36ZM11 17v-4H8v4h3Zm.93-7.88.07-.03V8H8v4h3v-1.5c0-.6.37-1.15.93-1.38ZM7 12V8H3v4h4Zm-4 1h4v4H5.5A2.5 2.5 0 0 1 3 14.5V13Zm10-6h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4Zm-1-4v4H8V3h4ZM7 3v4H3V5.5A2.5 2.5 0 0 1 5.5 3H7Zm5.86 7.15a.5.5 0 0 0-.86.35v8a.5.5 0 0 0 .9.3l2-2.65 3.5.78a.5.5 0 0 0 .45-.84l-6-5.94Z"]));
export const TableCursorRegular = ( /*#__PURE__*/createFluentIcon('TableCursorRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17H11v-1H8v-3h3v-1H8V8h4v1.09a1.5 1.5 0 0 1 1 0V8h3v3.85l1 1V5.5Zm-13 9V13h3v3H5.36A1.5 1.5 0 0 1 4 14.5ZM12 7H8V4h4v3Zm1-3H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM4 7V5.36A1.5 1.5 0 0 1 5.5 4H7v3H4Zm3 1v4H4V8h3Zm5.86 2.15a.5.5 0 0 0-.86.35v8a.5.5 0 0 0 .9.3l2-2.65 3.5.78a.5.5 0 0 0 .45-.84l-6-5.94Z"]));
export const TableDeleteColumnFilled = ( /*#__PURE__*/createFluentIcon('TableDeleteColumnFilled', "1em", ["M10.5 2.5a.5.5 0 0 0-1 0v4.88c.13.1.24.22.36.34l.14.15.14-.15c.12-.12.23-.24.36-.34V2.5Zm-1 15v-4.89c.13-.1.24-.23.36-.35l.14-.14.14.14c.12.12.23.24.36.35v4.89a.5.5 0 0 1-1 0ZM2 3.5c0-.28.22-.5.5-.5H4a2 2 0 0 1 2 2v2H2V3.5Zm0 13V13h4v2a2 2 0 0 1-2 2H2.5a.5.5 0 0 1-.5-.5ZM6 8v4H2V8h4Zm12-4.5a.5.5 0 0 0-.5-.5H16a2 2 0 0 0-2 2v2h4V3.5ZM14 13v2c0 1.1.9 2 2 2h1.5a.5.5 0 0 0 .5-.5V13h-4Zm-2.15-4.85a.5.5 0 0 0-.7 0L10 9.29 8.85 8.15a.5.5 0 1 0-.7.7L9.29 10l-1.14 1.15a.5.5 0 0 0 .7.7L10 10.71l1.15 1.14a.5.5 0 0 0 .7-.7L10.71 10l1.14-1.15a.5.5 0 0 0 0-.7ZM18 12V8h-4v4h4Z"]));
export const TableDeleteColumnRegular = ( /*#__PURE__*/createFluentIcon('TableDeleteColumnRegular', "1em", ["M10.5 2.5a.5.5 0 0 0-1 0v4.88c.13.1.24.22.36.34l.14.15.14-.15c.12-.12.23-.24.36-.34V2.5Zm-1 15v-4.89c.13-.1.24-.23.36-.35l.14-.14.14.14c.12.12.23.24.36.35v4.89a.5.5 0 0 1-1 0ZM2 3.5c0-.28.22-.5.5-.5H4a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2H2.5a.5.5 0 0 1 0-1H4a1 1 0 0 0 1-1v-2H2.5a.5.5 0 0 1 0-1H5V8H2.5a.5.5 0 0 1 0-1H5V5a1 1 0 0 0-1-1H2.5a.5.5 0 0 1-.5-.5Zm16 0a.5.5 0 0 0-.5-.5H16a2 2 0 0 0-2 2v10c0 1.1.9 2 2 2h1.5a.5.5 0 0 0 0-1H16a1 1 0 0 1-1-1v-2h2.5a.5.5 0 0 0 0-1H15V8h2.5a.5.5 0 0 0 0-1H15V5a1 1 0 0 1 1-1h1.5a.5.5 0 0 0 .5-.5Zm-6.15 4.65a.5.5 0 0 0-.7 0L10 9.29 8.85 8.15a.5.5 0 1 0-.7.7L9.29 10l-1.14 1.15a.5.5 0 0 0 .7.7L10 10.71l1.15 1.14a.5.5 0 0 0 .7-.7L10.71 10l1.14-1.15a.5.5 0 0 0 0-.7Z"]));
export const TableDeleteRowFilled = ( /*#__PURE__*/createFluentIcon('TableDeleteRowFilled', "1em", ["M12 6H8V2h4v4ZM3.5 2H7v4H5a2 2 0 0 1-2-2V2.5c0-.28.22-.5.5-.5ZM15 6h-2V2h3.5c.28 0 .5.22.5.5V4a2 2 0 0 1-2 2Zm1.5 12a.5.5 0 0 0 .5-.5V16a2 2 0 0 0-2-2h-2v4h3.5ZM12 18v-4H8v4h4Zm-5 0H3.5a.5.5 0 0 1-.5-.5V16c0-1.1.9-2 2-2h2v4Zm10.5-7.5a.5.5 0 0 0 0-1h-4.89a5 5 0 0 1-.48.5l.14.13c.12.12.25.24.35.37h4.88Zm-15-1h4.89a5 5 0 0 0 .34.35l.14.14-.14.14c-.12.12-.25.24-.35.37H2.5a.5.5 0 0 1 0-1Zm9.35 2.35a.5.5 0 0 0 0-.7L10.71 10l1.14-1.15a.5.5 0 0 0-.7-.7L10 9.29 8.85 8.15a.5.5 0 1 0-.7.7L9.29 10l-1.14 1.15a.5.5 0 0 0 .7.7L10 10.71l1.15 1.14c.2.2.5.2.7 0Z"]));
export const TableDeleteRowRegular = ( /*#__PURE__*/createFluentIcon('TableDeleteRowRegular', "1em", ["M16.5 2c.28 0 .5.22.5.5V4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V2.5a.5.5 0 0 1 1 0V4a1 1 0 0 0 1 1h2V2.5a.5.5 0 0 1 1 0V5h4V2.5a.5.5 0 0 1 1 0V5h2a1 1 0 0 0 1-1V2.5c0-.28.22-.5.5-.5Zm0 16a.5.5 0 0 0 .5-.5V16a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v1.5a.5.5 0 0 0 1 0V16a1 1 0 0 1 1-1h2v2.5a.5.5 0 0 0 1 0V15h4v2.5a.5.5 0 0 0 1 0V15h2a1 1 0 0 1 1 1v1.5c0 .28.22.5.5.5Zm1-7.5a.5.5 0 0 0 0-1h-4.89a5 5 0 0 1-.48.5l.14.13c.12.12.25.24.35.37h4.88Zm-15-1h4.89a5 5 0 0 0 .34.35l.14.14-.14.14c-.12.12-.25.24-.35.37H2.5a.5.5 0 0 1 0-1Zm9.35 2.35a.5.5 0 0 0 0-.7L10.71 10l1.14-1.15a.5.5 0 0 0-.7-.7L10 9.29 8.85 8.15a.5.5 0 1 0-.7.7L9.29 10l-1.14 1.15a.5.5 0 0 0 .7.7L10 10.71l1.15 1.14c.2.2.5.2.7 0Z"]));
export const TableDismissFilled = ( /*#__PURE__*/createFluentIcon('TableDismissFilled', "1em", ["M13 7h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4Zm-6 5V8H3v4h4Zm2.6 0A5.52 5.52 0 0 1 12 9.6V8H8v4h1.6Zm4.9-3c.9 0 1.75.22 2.5.6V8h-4v1.2c.48-.13.98-.2 1.5-.2ZM9 14.5c0-.52.07-1.02.2-1.5H8v4h1.6c-.38-.75-.6-1.6-.6-2.5ZM7 13H3v1.5A2.5 2.5 0 0 0 5.5 17H7v-4Zm5-6V3H8v4h4ZM7 3v4H3V5.5A2.5 2.5 0 0 1 5.5 3H7Zm12 11.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-3.8 0 1.15-1.15a.5.5 0 0 0-.7-.7l-1.15 1.14-1.15-1.14a.5.5 0 0 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 0 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 0 0 .7-.7l-1.14-1.15Z"]));
export const TableDismissRegular = ( /*#__PURE__*/createFluentIcon('TableDismissRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h4.1c-.16-.32-.3-.65-.4-1H8v-3h1.2c.1-.35.24-.68.4-1H8V8h4v1.6c.32-.16.65-.3 1-.4V8h3v1.2c.35.1.68.24 1 .4V5.5Zm-13 9V13h3v3H5.36A1.5 1.5 0 0 1 4 14.5ZM12 4v3H8V4h4Zm1 0H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM7 4v3H4V5.36A1.5 1.5 0 0 1 5.5 4H7Zm0 4v4H4V8h3Zm12 6.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-3.8 0 1.15-1.15a.5.5 0 0 0-.7-.7l-1.15 1.14-1.15-1.14a.5.5 0 0 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 0 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 0 0 .7-.7l-1.14-1.15Z"]));
export const TableEditFilled = ( /*#__PURE__*/createFluentIcon('TableEditFilled', "1em", ["M18.45 13.2a1.87 1.87 0 0 0-2.64-2.65l-4.83 4.83a2.2 2.2 0 0 0-.58 1.02l-.37 1.5a.89.89 0 0 0 1.08 1.07l1.5-.37c.38-.1.73-.3 1.01-.58l4.83-4.83ZM15.1 9.83c.53-.53 1.21-.8 1.9-.84V8h-4v3.94l2.1-2.1Zm-4.83 4.83L11.94 13H8v4h1.22l.21-.85a3.2 3.2 0 0 1 .84-1.48ZM12 12H8V8h4v4Zm-5 0V8H3v4h4Zm-4 1h4v4H5.5A2.5 2.5 0 0 1 3 14.5V13Zm10-6h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4Zm-1-4v4H8V3h4ZM7 3v4H3V5.5A2.5 2.5 0 0 1 5.5 3H7Z"]));
export const TableEditRegular = ( /*#__PURE__*/createFluentIcon('TableEditRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h3.72l.21-.85.05-.15H8v-3h3.94L13 11.94V8h3v1.23c.32-.14.66-.21 1-.23V5.5Zm-13 9V13h3v3H5.36A1.5 1.5 0 0 1 4 14.5ZM12 8v4H8V8h4Zm0-1H8V4h4v3Zm1-3H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM4 7V5.36A1.5 1.5 0 0 1 5.5 4H7v3H4Zm3 1v4H4V8h3Zm8.8 2.55-4.82 4.83a2.2 2.2 0 0 0-.58 1.02l-.37 1.5a.89.89 0 0 0 1.08 1.07l1.5-.37c.38-.1.73-.3 1.01-.58l4.83-4.83a1.87 1.87 0 0 0-2.64-2.64ZM14.66 17 17 14.65Z"]));
export const TableFreezeColumnFilled = ( /*#__PURE__*/createFluentIcon('TableFreezeColumnFilled', "1em", ["M16 14.5c0 .83-.67 1.5-1.5 1.5H12v-3H8v4h6.5a2.5 2.5 0 0 0 2.5-2.5v-9A2.5 2.5 0 0 0 14.5 3H8v4h4V4h2.5c.83 0 1.5.67 1.5 1.5v9ZM5.5 3H7v4H3V5.5A2.5 2.5 0 0 1 5.5 3ZM7 12V8H3v4h4Zm5-4H8v4h4V8Zm-9 5h4v4H5.5A2.5 2.5 0 0 1 3 14.5V13Z"], { flipInRtl: true }));
export const TableFreezeColumnRegular = ( /*#__PURE__*/createFluentIcon('TableFreezeColumnRegular', "1em", ["M5.5 17A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9ZM12 4H8v3h4V4ZM7 4H5.5c-.78 0-1.42.6-1.5 1.36V7h3V4Zm1 4v4h4V8H8Zm-4 4h3V8H4v4Zm4 1v3h4v-3H8Zm-2.5 3H7v-3H4v1.5c0 .78.6 1.42 1.36 1.5h.14Zm9-12H13v12h1.5c.78 0 1.42-.6 1.5-1.36V5.5c0-.78-.6-1.42-1.36-1.5h-.14Z"], { flipInRtl: true }));
export const TableFreezeColumnAndRowFilled = ( /*#__PURE__*/createFluentIcon('TableFreezeColumnAndRowFilled', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17H12v-4H8v3H5.5A1.5 1.5 0 0 1 4 14.5v-9C4 4.67 4.67 4 5.5 4h9c.83 0 1.5.67 1.5 1.5V8h-3v4h4V5.5A2.5 2.5 0 0 0 14.5 3h-9Zm9 14H13v-4h4v1.5a2.5 2.5 0 0 1-2.5 2.5ZM8 12h4V8H8v4Z"], { flipInRtl: true }));
export const TableFreezeColumnAndRowRegular = ( /*#__PURE__*/createFluentIcon('TableFreezeColumnAndRowRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9ZM8 16h4v-3H8v3Zm5 0h1.5c.78 0 1.42-.6 1.5-1.36V13h-3v3Zm-1-4V8H8v4h4Zm4-4h-3v4h3V8ZM5.5 16H7V7h9V5.5c0-.78-.6-1.42-1.36-1.5H5.5c-.78 0-1.42.6-1.5 1.36v9.14c0 .78.6 1.42 1.36 1.5h.14Z"], { flipInRtl: true }));
export const TableFreezeColumnAndRowDismissFilled = ( /*#__PURE__*/createFluentIcon('TableFreezeColumnAndRowDismissFilled', "1em", ["M14.5 10a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9Zm0-7A2.5 2.5 0 0 1 17 5.5v4.1a5.48 5.48 0 0 0-4-.4V8h3V5.5c0-.83-.67-1.5-1.5-1.5h-9C4.67 4 4 4.67 4 5.5v9c0 .83.67 1.5 1.5 1.5H8v-3h1.2a5.5 5.5 0 0 0 .4 4H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm1.85 9.65a.5.5 0 0 0-.7 0l-1.15 1.14-1.15-1.14a.5.5 0 1 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 1 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 1 0 .7-.7l-1.14-1.15 1.14-1.15a.5.5 0 0 0 0-.7ZM12 9.6A5.52 5.52 0 0 0 9.6 12H8V8h4v1.6Z"]));
export const TableFreezeColumnAndRowDismissRegular = ( /*#__PURE__*/createFluentIcon('TableFreezeColumnAndRowDismissRegular', "1em", ["M14.5 10a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9Zm0-7A2.5 2.5 0 0 1 17 5.5v4.1c-.32-.16-.65-.3-1-.4V8h-3v1.2c-.35.1-.68.24-1 .4V8H8v4h1.6c-.16.32-.3.65-.4 1H8v3h1.2c.1.35.24.68.4 1H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm1.85 9.65a.5.5 0 0 0-.7 0l-1.15 1.14-1.15-1.14a.5.5 0 1 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 1 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 1 0 .7-.7l-1.14-1.15 1.14-1.15a.5.5 0 0 0 0-.7ZM5.5 4c-.78 0-1.42.6-1.5 1.36v9.14c0 .78.6 1.42 1.36 1.5H7V7h9V5.5c0-.78-.6-1.42-1.36-1.5H5.5Z"]));
export const TableFreezeColumnDismissFilled = ( /*#__PURE__*/createFluentIcon('TableFreezeColumnDismissFilled', "1em", ["M14.5 10a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9ZM12 7H8V4H5.5C4.67 4 4 4.67 4 5.5v9c0 .83.67 1.5 1.5 1.5H8v-3h1.2a5.5 5.5 0 0 0 .4 4H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3H12v4Zm4.35 5.65a.5.5 0 0 0-.7 0l-1.15 1.14-1.15-1.14a.5.5 0 1 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 1 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 1 0 .7-.7l-1.14-1.15 1.14-1.15a.5.5 0 0 0 0-.7ZM12 9.6A5.52 5.52 0 0 0 9.6 12H8V8h4v1.6Zm5 0a5.48 5.48 0 0 0-4-.4V8h4v1.6ZM14.5 3A2.5 2.5 0 0 1 17 5.5V7h-4V3h1.5Z"]));
export const TableFreezeColumnDismissRegular = ( /*#__PURE__*/createFluentIcon('TableFreezeColumnDismissRegular', "1em", ["M14.5 10a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9Zm0-7A2.5 2.5 0 0 1 17 5.5v4.1c-.32-.16-.65-.3-1-.4V8h-3v1.2c-.35.1-.68.24-1 .4V8H8v4h1.6c-.16.32-.3.65-.4 1H8v3h1.2c.1.35.24.68.4 1H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm1.85 9.65a.5.5 0 0 0-.7 0l-1.15 1.14-1.15-1.14a.5.5 0 1 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 1 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 1 0 .7-.7l-1.14-1.15 1.14-1.15a.5.5 0 0 0 0-.7ZM5.5 4c-.78 0-1.42.6-1.5 1.36v9.14c0 .78.6 1.42 1.36 1.5H7V4H5.5ZM8 7h4V4H8v3Zm5 0h3V5.5c0-.78-.6-1.42-1.36-1.5H13v3Z"]));
export const TableFreezeRowFilled = ( /*#__PURE__*/createFluentIcon('TableFreezeRowFilled', "1em", ["M14.5 4c.83 0 1.5.67 1.5 1.5V8h-3v4h4V5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5V12h4V8H4V5.5C4 4.67 4.67 4 5.5 4h9ZM3 14.5V13h4v4H5.5A2.5 2.5 0 0 1 3 14.5Zm9-1.5H8v4h4v-4ZM8 8v4h4V8H8Zm5 9v-4h4v1.5a2.5 2.5 0 0 1-2.5 2.5H13Z"], { flipInRtl: true }));
export const TableFreezeRowRegular = ( /*#__PURE__*/createFluentIcon('TableFreezeRowRegular', "1em", ["M14.5 17a2.5 2.5 0 0 0 2.5-2.5v-9A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h9ZM4 12V8h3v4H4Zm12-5H4V5.36A1.5 1.5 0 0 1 5.5 4h9.14A1.5 1.5 0 0 1 16 5.5V7ZM8 8h4v4H8V8Zm-4 6.5V13h3v3H5.36A1.5 1.5 0 0 1 4 14.5Zm8-1.5v3H8v-3h4Zm4-5v4h-3V8h3Zm0 5V14.64A1.5 1.5 0 0 1 14.5 16H13v-3h3Z"], { flipInRtl: true }));
export const TableFreezeRowDismissFilled = ( /*#__PURE__*/createFluentIcon('TableFreezeRowDismissFilled', "1em", ["M14.5 10a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9ZM7 17H5.5A2.5 2.5 0 0 1 3 14.5V13h4v4Zm2.2-4a5.5 5.5 0 0 0 .4 4H8v-4h1.2Zm7.15-.35a.5.5 0 0 0-.7 0l-1.15 1.14-1.15-1.14a.5.5 0 1 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 1 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 1 0 .7-.7l-1.14-1.15 1.14-1.15a.5.5 0 0 0 0-.7ZM14.5 3A2.5 2.5 0 0 1 17 5.5v4.1a5.48 5.48 0 0 0-4-.4V8h3V5.5c0-.83-.67-1.5-1.5-1.5h-9C4.67 4 4 4.67 4 5.5V8h3v4H3V5.5A2.5 2.5 0 0 1 5.5 3h9ZM12 9.6A5.52 5.52 0 0 0 9.6 12H8V8h4v1.6Z"]));
export const TableFreezeRowDismissRegular = ( /*#__PURE__*/createFluentIcon('TableFreezeRowDismissRegular', "1em", ["M14.5 10a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9Zm0-7A2.5 2.5 0 0 1 17 5.5v4.1c-.32-.16-.65-.3-1-.4V8h-3v1.2c-.35.1-.68.24-1 .4V8H8v4h1.6c-.16.32-.3.65-.4 1H8v3h1.2c.1.35.24.68.4 1H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm1.85 9.65a.5.5 0 0 0-.7 0l-1.15 1.14-1.15-1.14a.5.5 0 1 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 1 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 1 0 .7-.7l-1.14-1.15 1.14-1.15a.5.5 0 0 0 0-.7ZM4 14.5c0 .78.6 1.42 1.36 1.5H7v-3H4v1.5ZM4 12h3V8H4v4Zm1.5-8c-.78 0-1.42.6-1.5 1.36V7h12V5.5c0-.78-.6-1.42-1.36-1.5H5.5Z"]));
export const TableImageFilled = ( /*#__PURE__*/createFluentIcon('TableImageFilled', "1em", ["M16.5 9c.17 0 .34.01.5.04V8h-4v1h3.5ZM9 16.5V13H8v4h1.04a3.53 3.53 0 0 1-.04-.5Zm.04-4.5A3.5 3.5 0 0 1 12 9.04V8H8v4h1.04ZM7 12V8H3v4h4Zm-4 1h4v4H5.5A2.5 2.5 0 0 1 3 14.5V13Zm10-6h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4Zm-1-4v4H8V3h4ZM7 3v4H3V5.5A2.5 2.5 0 0 1 5.5 3H7Zm3 9.5a2.5 2.5 0 0 1 2.5-2.5h4a2.5 2.5 0 0 1 2.5 2.5v4c0 .5-.15.98-.41 1.38l-3.03-3.03a1.5 1.5 0 0 0-2.12 0l-3.03 3.03c-.26-.4-.41-.87-.41-1.38v-4Zm7 .25a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Zm-5.88 5.84c.4.26.87.41 1.38.41h4c.5 0 .98-.15 1.38-.41l-3.03-3.03a.5.5 0 0 0-.7 0l-3.03 3.03Z"]));
export const TableImageRegular = ( /*#__PURE__*/createFluentIcon('TableImageRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h3.54a3.53 3.53 0 0 1-.04-.5V16H8v-3h1v-.5c0-.17.01-.34.04-.5H8V8h4v1.04c.16-.03.33-.04.5-.04h.5V8h3v1h.5c.17 0 .34.01.5.04V5.5Zm-13 9V13h3v3H5.36A1.5 1.5 0 0 1 4 14.5ZM12 7H8V4h4v3Zm1-3H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM4 7V5.36A1.5 1.5 0 0 1 5.5 4H7v3H4Zm3 1v4H4V8h3Zm3 4.5a2.5 2.5 0 0 1 2.5-2.5h4a2.5 2.5 0 0 1 2.5 2.5v4c0 .5-.15.98-.41 1.38l-3.03-3.03a1.5 1.5 0 0 0-2.12 0l-3.03 3.03c-.26-.4-.41-.87-.41-1.38v-4Zm7 .25a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Zm-5.88 5.84c.4.26.87.41 1.38.41h4c.5 0 .98-.15 1.38-.41l-3.03-3.03a.5.5 0 0 0-.7 0l-3.03 3.03Z"]));
export const TableInsertColumnFilled = ( /*#__PURE__*/createFluentIcon('TableInsertColumnFilled', "1em", ["M4 3.5a.5.5 0 0 0-1 0v13a.5.5 0 0 0 1 0v-13Zm13 0a.5.5 0 0 0-1 0v13a.5.5 0 0 0 1 0v-13ZM9 3a2 2 0 0 0-2 2v2h6V5a2 2 0 0 0-2-2H9Zm-2 9V8h6v4H7Zm0 1h6v2a2 2 0 0 1-2 2H9a2 2 0 0 1-2-2v-2Z"]));
export const TableInsertColumnRegular = ( /*#__PURE__*/createFluentIcon('TableInsertColumnRegular', "1em", ["M4 3.5a.5.5 0 0 0-1 0v13a.5.5 0 0 0 1 0v-13Zm13 0a.5.5 0 0 0-1 0v13a.5.5 0 0 0 1 0v-13ZM9 3a2 2 0 0 0-2 2v10c0 1.1.9 2 2 2h2a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2H9Zm-1 9V8h4v4H8Zm4-7v2H8V5a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1Zm-4 8h4v2a1 1 0 0 1-1 1H9a1 1 0 0 1-1-1v-2Z"]));
export const TableInsertRowFilled = ( /*#__PURE__*/createFluentIcon('TableInsertRowFilled', "1em", ["M3.5 16a.5.5 0 0 0 0 1h13a.5.5 0 0 0 0-1h-13Zm0-13a.5.5 0 0 0 0 1h13a.5.5 0 0 0 0-1h-13ZM3 11c0 1.1.9 2 2 2h2V7H5a2 2 0 0 0-2 2v2Zm9 2H8V7h4v6Zm1 0V7h2a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2h-2Z"]));
export const TableInsertRowRegular = ( /*#__PURE__*/createFluentIcon('TableInsertRowRegular', "1em", ["M3.5 16a.5.5 0 0 0 0 1h13a.5.5 0 0 0 0-1h-13Zm0-13a.5.5 0 0 0 0 1h13a.5.5 0 0 0 0-1h-13ZM3 11c0 1.1.9 2 2 2h10a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v2Zm9 1H8V8h4v4ZM5 8h2v4H5a1 1 0 0 1-1-1V9a1 1 0 0 1 1-1Zm8 4V8h2a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1h-2Z"]));
export const TableLightningFilled = ( /*#__PURE__*/createFluentIcon('TableLightningFilled', "1em", ["M13.58 9H17V8h-4v1.12c.18-.08.38-.12.58-.12Zm-2.25 3 .67-1.6V8H8v4h3.33Zm-1.21 2.92.8-1.92H8v4h3.5a1.5 1.5 0 0 1-1.38-2.08ZM7 12V8H3v4h4Zm-4 1h4v4H5.5A2.5 2.5 0 0 1 3 14.5V13Zm10-6h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4Zm-1-4v4H8V3h4ZM7 3v4H3V5.5A2.5 2.5 0 0 1 5.5 3H7Zm5.61 13c.33 0 .56.3.49.62l-.44 1.74c-.12.48.46.83.83.49l4.87-4.55a.75.75 0 0 0-.51-1.3h-.4a.5.5 0 0 1-.48-.66l.56-1.68a.5.5 0 0 0-.47-.66h-3.48a.5.5 0 0 0-.46.3l-2.08 5c-.14.34.1.7.46.7h1.11Z"]));
export const TableLightningRegular = ( /*#__PURE__*/createFluentIcon('TableLightningRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h6a1.5 1.5 0 0 1-1.41-1H8v-3h2.92l.41-1H8V8h4v2.4l.2-.48c.15-.37.45-.65.8-.8V8h3v1h1V5.5Zm-13 9V13h3v3H5.36A1.5 1.5 0 0 1 4 14.5ZM12 7H8V4h4v3Zm1-3H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM4 7V5.36A1.5 1.5 0 0 1 5.5 4H7v3H4Zm3 1v4H4V8h3Zm5.61 8c.33 0 .56.3.49.62l-.44 1.74c-.12.48.46.83.83.49l4.87-4.55a.75.75 0 0 0-.51-1.3h-.4a.5.5 0 0 1-.48-.66l.56-1.68a.5.5 0 0 0-.47-.66h-3.48a.5.5 0 0 0-.46.3l-2.08 5c-.14.34.1.7.46.7h1.11Z"]));
export const TableLinkFilled = ( /*#__PURE__*/createFluentIcon('TableLinkFilled', "1em", ["M9 15.5c0 .54.12 1.05.34 1.5H8v-4h2.05A3.49 3.49 0 0 0 9 15.5ZM13 8v4h3.5c.17 0 .34.01.5.04V8h-4Zm-1 4V8H8v4h4Zm-5 0V8H3v4h4Zm-4 1h4v4H5.5A2.5 2.5 0 0 1 3 14.5V13Zm10-6h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4Zm-1-4v4H8V3h4ZM7 3v4H3V5.5A2.5 2.5 0 0 1 5.5 3H7Zm3 12.5a2.5 2.5 0 0 1 2.5-2.5h.5a.5.5 0 0 1 0 1h-.5a1.5 1.5 0 0 0 0 3h.5a.5.5 0 0 1 0 1h-.5a2.5 2.5 0 0 1-2.5-2.5Zm5.5-2c0-.28.22-.5.5-.5h.5a2.5 2.5 0 0 1 0 5H16a.5.5 0 0 1 0-1h.5a1.5 1.5 0 0 0 0-3H16a.5.5 0 0 1-.5-.5Zm-3 1.5a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Z"]));
export const TableLinkRegular = ( /*#__PURE__*/createFluentIcon('TableLinkRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h3.84a3.48 3.48 0 0 1-.3-1H8v-3h2.05a3.49 3.49 0 0 1 2.45-1h.5V8h3v4h.5c.17 0 .34.01.5.04V5.5ZM12 8v4H8V8h4Zm-8 6.5V13h3v3H5.36A1.5 1.5 0 0 1 4 14.5ZM12 7H8V4h4v3Zm1-3H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM4 7V5.36A1.5 1.5 0 0 1 5.5 4H7v3H4Zm3 1v4H4V8h3Zm3 7.5a2.5 2.5 0 0 1 2.5-2.5h.5a.5.5 0 0 1 0 1h-.5a1.5 1.5 0 0 0 0 3h.5a.5.5 0 0 1 0 1h-.5a2.5 2.5 0 0 1-2.5-2.5Zm5.5-2c0-.28.22-.5.5-.5h.5a2.5 2.5 0 0 1 0 5H16a.5.5 0 0 1 0-1h.5a1.5 1.5 0 0 0 0-3H16a.5.5 0 0 1-.5-.5Zm-3 1.5a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Z"]));
export const TableLockFilled = ( /*#__PURE__*/createFluentIcon('TableLockFilled', "1em", ["M15.5 9c.55 0 1.06.15 1.5.4V8h-4v2.34A3 3 0 0 1 15.5 9ZM11 14c0-.36.1-.7.27-1H8v4h3v-3Zm1-2H8V8h4v4Zm-5 0V8H3v4h4Zm-4 1h4v4H5.5A2.5 2.5 0 0 1 3 14.5V13Zm10-6h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4Zm-1-4v4H8V3h4ZM7 3v4H3V5.5A2.5 2.5 0 0 1 5.5 3H7Zm6.5 9v1H13a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h5a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1h-.5v-1a2 2 0 1 0-4 0Zm1 1v-1a1 1 0 1 1 2 0v1h-2Zm1 2.25a.75.75 0 1 1 0 1.5.75.75 0 0 1 0-1.5Z"]));
export const TableLockRegular = ( /*#__PURE__*/createFluentIcon('TableLockRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17H11v-1H8v-3h3.27a2 2 0 0 1 1.23-.94V12c0-.61.18-1.18.5-1.66V8h3v1.04c.36.06.7.19 1 .36V5.5Zm-13 9V13h3v3H5.36A1.5 1.5 0 0 1 4 14.5ZM12 8v4H8V8h4Zm0-1H8V4h4v3Zm1-3H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM4 7V5.36A1.5 1.5 0 0 1 5.5 4H7v3H4Zm3 1v4H4V8h3Zm6.5 4v1H13a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h5a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1h-.5v-1a2 2 0 1 0-4 0Zm1 1v-1a1 1 0 1 1 2 0v1h-2Zm1 2.25a.75.75 0 1 1 0 1.5.75.75 0 0 1 0-1.5Z"]));
export const TableMoveAboveFilled = ( /*#__PURE__*/createFluentIcon('TableMoveAboveFilled', "1em", ["M3.5 3a.5.5 0 0 0 0 1h13a.5.5 0 0 0 0-1h-13ZM8 12V8.41c.16.06.33.09.5.09v1a1.5 1.5 0 0 0 3 0v-1c.17 0 .34-.03.5-.09V12H8Zm7 5h-2v-4h4v2a2 2 0 0 1-2 2Zm2-5h-4V8h3.5c.28 0 .5.22.5.5V12Zm-9 5h4v-4H8v4ZM7 8v4H3V8.5c0-.28.22-.5.5-.5H7Zm0 9H5a2 2 0 0 1-2-2v-2h4v4Zm4.15-9.65a.5.5 0 0 0 .7-.7l-1.5-1.5a.5.5 0 0 0-.7 0l-1.5 1.5a.5.5 0 1 0 .7.7l.65-.64V9.5a.5.5 0 0 0 1 0V6.7l.65.65Z"]));
export const TableMoveAboveRegular = ( /*#__PURE__*/createFluentIcon('TableMoveAboveRegular', "1em", ["M3 3.5c0-.28.22-.5.5-.5h13a.5.5 0 0 1 0 1h-13a.5.5 0 0 1-.5-.5ZM3.5 8h3.88a1.52 1.52 0 0 0 .62.41V12h4V8.41a1.5 1.5 0 0 0 .62-.41h3.88c.28 0 .5.22.5.5V15a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V8.5c0-.28.22-.5.5-.5Zm.5 5v2a1 1 0 0 0 1 1h2v-3H4Zm8 3v-3H8v3h4Zm1 0h2a1 1 0 0 0 1-1v-2h-3v3Zm0-4h3V9h-3v3ZM4 9v3h3V9H4Zm7.15-1.65a.5.5 0 0 0 .7-.7l-1.5-1.5a.5.5 0 0 0-.7 0l-1.5 1.5a.5.5 0 1 0 .7.7l.65-.64V9.5a.5.5 0 0 0 1 0V6.7l.65.65Z"]));
export const TableMoveBelowFilled = ( /*#__PURE__*/createFluentIcon('TableMoveBelowFilled', "1em", ["M16.5 17a.5.5 0 0 0 0-1h-13a.5.5 0 0 0 0 1h13ZM12 8v3.59a1.5 1.5 0 0 0-.5-.09v-1a1.5 1.5 0 0 0-3 0v1c-.17 0-.34.03-.5.09V8h4ZM5 3h2v4H3V5c0-1.1.9-2 2-2ZM3 8h4v4H3.5a.5.5 0 0 1-.5-.5V8Zm9-5H8v4h4V3Zm1 9V8h4v3.5a.5.5 0 0 1-.5.5H13Zm0-9h2a2 2 0 0 1 2 2v2h-4V3Zm-4.15 9.65a.5.5 0 0 0-.7.7l1.5 1.5c.2.2.5.2.7 0l1.5-1.5a.5.5 0 0 0-.7-.7l-.65.64V10.5a.5.5 0 0 0-1 0v2.8l-.65-.65Z"]));
export const TableMoveBelowRegular = ( /*#__PURE__*/createFluentIcon('TableMoveBelowRegular', "1em", ["M17 16.5a.5.5 0 0 1-.5.5h-13a.5.5 0 0 1 0-1h13c.28 0 .5.22.5.5Zm-.5-4.5h-3.88a1.5 1.5 0 0 0-.62-.41V8H8v3.59a1.5 1.5 0 0 0-.62.41H3.5a.5.5 0 0 1-.5-.5V5c0-1.1.9-2 2-2h10a2 2 0 0 1 2 2v6.5a.5.5 0 0 1-.5.5ZM16 7V5a1 1 0 0 0-1-1h-2v3h3ZM8 4v3h4V4H8ZM7 4H5a1 1 0 0 0-1 1v2h3V4Zm0 4H4v3h3V8Zm9 3V8h-3v3h3Zm-7.15 1.65a.5.5 0 0 0-.7.7l1.5 1.5c.2.2.5.2.7 0l1.5-1.5a.5.5 0 0 0-.7-.7l-.65.64V10.5a.5.5 0 0 0-1 0v2.8l-.65-.65Z"]));
export const TableMoveLeftFilled = ( /*#__PURE__*/createFluentIcon('TableMoveLeftFilled', "1em", ["M3 16.5a.5.5 0 0 0 1 0v-13a.5.5 0 0 0-1 0v13Zm9-4.5H8.41c.06-.16.09-.33.09-.5h1a1.5 1.5 0 0 0 0-3h-1c0-.17-.03-.34-.09-.5H12v4Zm5-7v2h-4V3h2a2 2 0 0 1 2 2Zm-5-2v4H8V3.5c0-.28.22-.5.5-.5H12Zm5 9V8h-4v4h4Zm-9 1h4v4H8.5a.5.5 0 0 1-.5-.5V13Zm9 0v2a2 2 0 0 1-2 2h-2v-4h4ZM7.35 8.85a.5.5 0 1 0-.7-.7l-1.5 1.5a.5.5 0 0 0 0 .7l1.5 1.5a.5.5 0 0 0 .7-.7l-.64-.65H9.5a.5.5 0 0 0 0-1H6.7l.65-.65Z"]));
export const TableMoveLeftRegular = ( /*#__PURE__*/createFluentIcon('TableMoveLeftRegular', "1em", ["M3.5 17a.5.5 0 0 1-.5-.5v-13a.5.5 0 0 1 1 0v13a.5.5 0 0 1-.5.5Zm4.5-.5v-3.88a1.55 1.55 0 0 0 .41-.62H12V8H8.41A1.5 1.5 0 0 0 8 7.38V3.5c0-.28.22-.5.5-.5H15a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2H8.5a.5.5 0 0 1-.5-.5Zm5-.5h2a1 1 0 0 0 1-1v-2h-3v3Zm3-8h-3v4h3V8Zm0-1V5a1 1 0 0 0-1-1h-2v3h3Zm-4 0V4H9v3h3Zm-3 9h3v-3H9v3ZM7.35 8.85a.5.5 0 1 0-.7-.7l-1.5 1.5a.5.5 0 0 0 0 .7l1.5 1.5a.5.5 0 0 0 .7-.7l-.64-.65H9.5a.5.5 0 0 0 0-1H6.7l.65-.65Z"]));
export const TableMoveRightFilled = ( /*#__PURE__*/createFluentIcon('TableMoveRightFilled', "1em", ["M17 3.5a.5.5 0 0 0-1 0v13a.5.5 0 0 0 1 0v-13ZM8 8h3.59a1.5 1.5 0 0 0-.09.5h-1a1.5 1.5 0 1 0 0 3h1c0 .17.03.34.09.5H8V8Zm-5 7v-2h4v4H5a2 2 0 0 1-2-2Zm5 2v-4h4v3.5a.5.5 0 0 1-.5.5H8ZM3 8v4h4V8H3Zm9-1H8V3h3.5c.28 0 .5.22.5.5V7ZM3 7V5c0-1.1.9-2 2-2h2v4H3Zm9.65 4.15a.5.5 0 0 0 .7.7l1.5-1.5a.5.5 0 0 0 0-.7l-1.5-1.5a.5.5 0 0 0-.7.7l.64.65H10.5a.5.5 0 0 0 0 1h2.8l-.65.65Z"]));
export const TableMoveRightRegular = ( /*#__PURE__*/createFluentIcon('TableMoveRightRegular', "1em", ["M16.5 3c.28 0 .5.22.5.5v13a.5.5 0 0 1-1 0v-13c0-.28.22-.5.5-.5Zm-4.5.5v3.88a1.5 1.5 0 0 0-.41.62H8v4h3.59a1.5 1.5 0 0 0 .41.62v3.88a.5.5 0 0 1-.5.5H5a2 2 0 0 1-2-2V5c0-1.1.9-2 2-2h6.5c.28 0 .5.22.5.5ZM7 4H5a1 1 0 0 0-1 1v2h3V4Zm-3 8h3V8H4v4Zm0 1v2a1 1 0 0 0 1 1h2v-3H4Zm4 0v3h3v-3H8Zm3-9H8v3h3V4Zm1.65 7.15a.5.5 0 0 0 .7.7l1.5-1.5a.5.5 0 0 0 0-.7l-1.5-1.5a.5.5 0 0 0-.7.7l.64.65H10.5a.5.5 0 0 0 0 1h2.8l-.65.65Z"]));
export const TableMultipleFilled = ( /*#__PURE__*/createFluentIcon('TableMultipleFilled', "1em", ["M16 5.76A3 3 0 0 1 17 8v4a5 5 0 0 1-5 5H8a3 3 0 0 1-2.24-1H12a4 4 0 0 0 4-4V5.76ZM6 15a3 3 0 0 1-3-3h3v3Zm5 0H7v-3h4v3Zm4-3a3 3 0 0 1-3 3v-3h3Zm-9-1H3V7h3v4Zm5 0H7V7h4v4Zm4 0h-3V7h3v4ZM6 6H3a3 3 0 0 1 3-3v3Zm5 0H7V3h4v3Zm1-3a3 3 0 0 1 3 3h-3V3Z"]));
export const TableMultipleRegular = ( /*#__PURE__*/createFluentIcon('TableMultipleRegular', "1em", ["M16 5.76A3 3 0 0 1 17 8v4a5 5 0 0 1-5 5H8a3 3 0 0 1-2.24-1H12a4 4 0 0 0 4-4V5.76ZM12.14 3A3 3 0 0 1 15 6v6a3 3 0 0 1-3 3H6a3 3 0 0 1-3-2.85V6a3 3 0 0 1 3-3h6.15ZM4 11v1l.01.2A2 2 0 0 0 6 14h1v-3H4Zm4 0v3h2v-3H8Zm3 0v3h1a2 2 0 0 0 2-2v-1h-3Zm-7-1h3V8H4v2Zm4 0h2V8H8v2Zm3 0h3V8h-3v2ZM6 4a2 2 0 0 0-2 2v1h3V4H6Zm2 3h2V4H8v3Zm3 0h3V6a2 2 0 0 0-1.8-1.99L12 4h-1v3Z"]));
export const TableOffsetFilled = ( /*#__PURE__*/createFluentIcon('TableOffsetFilled', "1em", ["M5.5 3H12v4H3V5.5A2.5 2.5 0 0 1 5.5 3ZM8 8h9v4H8V8Zm-1 4V8H3v4h4Zm-4 1h9v4H5.5A2.5 2.5 0 0 1 3 14.5V13Zm10 0v4h1.5a2.5 2.5 0 0 0 2.5-2.5V13h-4Zm0-6h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4Z"]));
export const TableOffsetRegular = ( /*#__PURE__*/createFluentIcon('TableOffsetRegular', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5v-9A2.5 2.5 0 0 0 14.5 3h-9ZM16 12H8V8h8v4Zm-3 1h3v1.5c0 .83-.67 1.5-1.5 1.5H13v-3Zm-1 0v3H5.5A1.5 1.5 0 0 1 4 14.5V13h8Zm-8-1V8h3v4H4Zm0-5V5.5C4 4.67 4.67 4 5.5 4H12v3H4Zm12-1.5V7h-3V4h1.5c.83 0 1.5.67 1.5 1.5Z"]));
export const TableOffsetAddFilled = ( /*#__PURE__*/createFluentIcon('TableOffsetAddFilled', "1em", ["M5.5 3H12v4H3V5.5A2.5 2.5 0 0 1 5.5 3ZM8 8h9v1.6A5.48 5.48 0 0 0 9.6 12H8V8Zm1 6.5c0-.52.07-1.02.2-1.5H3v1.5A2.5 2.5 0 0 0 5.5 17h4.1c-.38-.75-.6-1.6-.6-2.5ZM7 12V8H3v4h4Zm6-5h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4Zm6 7.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const TableOffsetAddRegular = ( /*#__PURE__*/createFluentIcon('TableOffsetAddRegular', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h4.1c-.16-.32-.3-.65-.4-1H5.5A1.5 1.5 0 0 1 4 14.5V13h5.2c.1-.35.24-.68.4-1H8V8h8v1.2c.35.1.68.24 1 .4V5.5A2.5 2.5 0 0 0 14.5 3h-9ZM7 12H4V8h3v4ZM4 7V5.5C4 4.67 4.67 4 5.5 4H12v3H4Zm12-1.5V7h-3V4h1.5c.83 0 1.5.67 1.5 1.5Zm3 9a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const TableOffsetLessThanOrEqualToFilled = ( /*#__PURE__*/createFluentIcon('TableOffsetLessThanOrEqualToFilled', "1em", ["M5.5 3H12v4H3V5.5A2.5 2.5 0 0 1 5.5 3ZM8 8h9v1.6A5.48 5.48 0 0 0 9.6 12H8V8Zm1 6.5c0-.52.07-1.02.2-1.5H3v1.5A2.5 2.5 0 0 0 5.5 17h4.1c-.38-.75-.6-1.6-.6-2.5ZM7 12V8H3v4h4Zm6-5h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4Zm1.5 12a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9ZM13 16h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1 0-1Zm2.4-4.8a.5.5 0 0 1-.1.7L13.83 13l1.47 1.1a.5.5 0 0 1-.6.8l-2-1.5a.5.5 0 0 1 0-.8l2-1.5a.5.5 0 0 1 .7.1Z"]));
export const TableOffsetLessThanOrEqualToRegular = ( /*#__PURE__*/createFluentIcon('TableOffsetLessThanOrEqualToRegular', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h4.1c-.16-.32-.3-.65-.4-1H5.5A1.5 1.5 0 0 1 4 14.5V13h5.2c.1-.35.24-.68.4-1H8V8h8v1.2c.35.1.68.24 1 .4V5.5A2.5 2.5 0 0 0 14.5 3h-9ZM7 12H4V8h3v4ZM4 7V5.5C4 4.67 4.67 4 5.5 4H12v3H4Zm12-1.5V7h-3V4h1.5c.83 0 1.5.67 1.5 1.5ZM14.5 19a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9ZM13 16h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1 0-1Zm2.4-4.8a.5.5 0 0 1-.1.7L13.83 13l1.47 1.1a.5.5 0 0 1-.6.8l-2-1.5a.5.5 0 0 1 0-.8l2-1.5a.5.5 0 0 1 .7.1Z"]));
export const TableOffsetSettingsFilled = ( /*#__PURE__*/createFluentIcon('TableOffsetSettingsFilled', "1em", ["M5.5 3H12v4H3V5.5A2.5 2.5 0 0 1 5.5 3ZM8 8h9v1.6A5.48 5.48 0 0 0 9.6 12H8V8Zm1 6.5c0-.52.07-1.02.2-1.5H3v1.5A2.5 2.5 0 0 0 5.5 17h4.1c-.38-.75-.6-1.6-.6-2.5ZM7 12V8H3v4h4Zm6-5h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4Zm-.93 4.44a2 2 0 0 1-1.43 2.48l-.46.12a4.7 4.7 0 0 0 0 1.01l.35.09A2 2 0 0 1 12 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.15-.55a2 2 0 0 1 1.43-2.48l.46-.12a4.7 4.7 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 17 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.29.13-.57.3-.82.5l.16.55Zm2.43 4.06a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const TableOffsetSettingsRegular = ( /*#__PURE__*/createFluentIcon('TableOffsetSettingsRegular', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h4.1c-.16-.32-.3-.65-.4-1H5.5A1.5 1.5 0 0 1 4 14.5V13h5.2c.1-.35.24-.68.4-1H8V8h8v1.2c.35.1.68.24 1 .4V5.5A2.5 2.5 0 0 0 14.5 3h-9ZM7 12H4V8h3v4ZM4 7V5.5C4 4.67 4.67 4 5.5 4H12v3H4Zm12-1.5V7h-3V4h1.5c.83 0 1.5.67 1.5 1.5Zm-3.93 5.94a2 2 0 0 1-1.43 2.48l-.46.12a4.7 4.7 0 0 0 0 1.01l.35.09A2 2 0 0 1 12 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.15-.55a2 2 0 0 1 1.43-2.48l.46-.12a4.7 4.7 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 17 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.29.13-.57.3-.82.5l.16.55Zm2.43 4.06a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const TableResizeColumnFilled = ( /*#__PURE__*/createFluentIcon('TableResizeColumnFilled', "1em", ["M14 3a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3v-4.38l.06-.06 1.5-1.5a1.5 1.5 0 0 0 0-2.12l-1.5-1.5a1.6 1.6 0 0 0-.06-.06V3Zm-1 0v4a1.5 1.5 0 0 0-1.5 1.5h-3A1.5 1.5 0 0 0 7 7V3h6Zm-4.94 9.56c-.3.3-.68.44-1.06.44v4h6v-4a1.5 1.5 0 0 1-1.5-1.5h-3c0 .38-.15.77-.44 1.06ZM6 17v-4.38a1.55 1.55 0 0 1-.06-.06l-1.5-1.5a1.5 1.5 0 0 1 0-2.12l1.5-1.5.06-.06V3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3Zm1.35-8.85c.2.2.2.5 0 .7l-.64.65h6.58l-.64-.65a.5.5 0 0 1 .7-.7l1.5 1.5c.2.2.2.5 0 .7l-1.5 1.5a.5.5 0 0 1-.7-.7l.64-.65H6.71l.64.65a.5.5 0 0 1-.7.7l-1.5-1.5a.5.5 0 0 1 0-.7l1.5-1.5c.2-.2.5-.2.7 0Z"]));
export const TableResizeColumnRegular = ( /*#__PURE__*/createFluentIcon('TableResizeColumnRegular', "1em", ["M7.35 8.15c.2.2.2.5 0 .7l-.64.65h6.58l-.64-.65a.5.5 0 0 1 .7-.7l1.5 1.5c.2.2.2.5 0 .7l-1.5 1.5a.5.5 0 0 1-.7-.7l.64-.65H6.71l.64.65a.5.5 0 0 1-.7.7l-1.5-1.5a.5.5 0 0 1 0-.7l1.5-1.5c.2-.2.5-.2.7 0ZM17 6a3 3 0 0 0-3-3H6a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V6Zm-4-2v3c.36 0 .72.13 1 .38V4a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2v-3.38a1.5 1.5 0 0 1-1 .38v3H7v-3a1.5 1.5 0 0 1-1-.38V16a2 2 0 0 1-2-2V6c0-1.1.9-2 2-2v3.38A1.5 1.5 0 0 1 7 7V4h6Z"]));
export const TableResizeRowFilled = ( /*#__PURE__*/createFluentIcon('TableResizeRowFilled', "1em", ["M17 14a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3h4.38l.06.06 1.5 1.5a1.5 1.5 0 0 0 2.12 0l1.5-1.5.06-.06H17Zm0-1h-4a1.5 1.5 0 0 0-1.5-1.5v-3A1.5 1.5 0 0 0 13 7h4v6ZM7.44 8.06A1.5 1.5 0 0 1 7 7H3v6h4a1.5 1.5 0 0 1 1.5-1.5v-3a1.5 1.5 0 0 1-1.06-.44ZM3 6h4.38l.06-.06 1.5-1.5a1.5 1.5 0 0 1 2.12 0l1.5 1.5.06.06H17a3 3 0 0 0-3-3H6a3 3 0 0 0-3 3Zm8.85 1.35a.5.5 0 0 1-.7 0l-.65-.64v6.58l.65-.64a.5.5 0 0 1 .7.7l-1.5 1.5a.5.5 0 0 1-.7 0l-1.5-1.5a.5.5 0 0 1 .7-.7l.65.64V6.71l-.65.64a.5.5 0 1 1-.7-.7l1.5-1.5c.2-.2.5-.2.7 0l1.5 1.5c.2.2.2.5 0 .7Z"]));
export const TableResizeRowRegular = ( /*#__PURE__*/createFluentIcon('TableResizeRowRegular', "1em", ["M11.85 7.35a.5.5 0 0 1-.7 0l-.65-.64v6.58l.65-.64a.5.5 0 0 1 .7.7l-1.5 1.5a.5.5 0 0 1-.7 0l-1.5-1.5a.5.5 0 0 1 .7-.7l.65.64V6.71l-.65.64a.5.5 0 1 1-.7-.7l1.5-1.5c.2-.2.5-.2.7 0l1.5 1.5c.2.2.2.5 0 .7ZM14 17a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h8Zm2-4h-3c0 .36-.13.72-.38 1H16a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2h3.38A1.5 1.5 0 0 1 7 13H4V7h3c0-.36.13-.72.38-1H4c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2h-3.38c.25.28.38.64.38 1h3v6Z"]));
export const TableSearchFilled = ( /*#__PURE__*/createFluentIcon('TableSearchFilled', "1em", ["M13 17h1.5a2.5 2.5 0 0 0 2.5-2.5V13h-4v4Z", "M13 12V8h4v4h-4Z", "M12 12H8.74A4.5 4.5 0 0 0 8 10.67V8h4v4Z", "M8.56 15.44 10.12 17H12v-4H8.97a4.55 4.55 0 0 1-.4 2.44Z", "M4.5 9c.93 0 1.78.28 2.5.76V8H3v1.26A4.5 4.5 0 0 1 4.5 9Z", "M13 7h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4Z", "M12 3v4H8V3h4Z", "M7 3v4H3V5.5A2.5 2.5 0 0 1 5.5 3H7Z", "M4.5 17c.79 0 1.51-.26 2.1-.7l2.55 2.55a.5.5 0 1 0 .7-.7L7.3 15.6A3.5 3.5 0 1 0 4.5 17Zm0-1a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5Z"]));
export const TableSearchRegular = ( /*#__PURE__*/createFluentIcon('TableSearchRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v3.76c.32-.12.66-.2 1-.23V8h3v1.76a4.49 4.49 0 0 1 1 .91V8h4v4H8.74a4.5 4.5 0 0 1 .23 1H12v3H9.12l1 1h4.38a2.5 2.5 0 0 0 2.5-2.5v-9ZM14.5 16H13v-3h3V14.64A1.5 1.5 0 0 1 14.5 16ZM13 8h3v4h-3V8Zm-1-1H8V4h4v3Zm1-3H14.64A1.5 1.5 0 0 1 16 5.5V7h-3V4ZM4 7V5.36A1.5 1.5 0 0 1 5.5 4H7v3H4Zm-2.62 4.9a3.5 3.5 0 0 0 5.22 4.4l2.54 2.56a.5.5 0 0 0 .71-.71L7.3 15.6a3.5 3.5 0 1 0-5.92-3.7Zm5.2.21a2.5 2.5 0 1 1-4.16 2.78 2.5 2.5 0 0 1 4.16-2.78Z"]));
export const TableSettingsFilled = ( /*#__PURE__*/createFluentIcon('TableSettingsFilled', "1em", ["M17 9.6a5.48 5.48 0 0 0-4-.4V8h4v1.6ZM9.2 13a5.5 5.5 0 0 0 .4 4H8v-4h1.2ZM12 9.6A5.52 5.52 0 0 0 9.6 12H8V8h4v1.6ZM7 8v4H3V8h4Zm0 5H3v1.5A2.5 2.5 0 0 0 5.5 17H7v-4Zm10-6h-4V3h1.5A2.5 2.5 0 0 1 17 5.5V7Zm-5 0V3H8v4h4ZM7 7V3H5.5A2.5 2.5 0 0 0 3 5.5V7h4Zm5.06 4.44a2 2 0 0 1-1.43 2.48l-.46.12a4.74 4.74 0 0 0 .01 1.01l.35.09A2 2 0 0 1 12 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.16-.55a2 2 0 0 1 1.44-2.48l.46-.12a4.7 4.7 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 17 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.3.13-.57.3-.82.5l.15.55Zm2.44 4.06a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const TableSettingsRegular = ( /*#__PURE__*/createFluentIcon('TableSettingsRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v4.1c-.32-.16-.65-.3-1-.4V8h-3v1.2c-.35.1-.68.24-1 .4V8H8v4h1.6c-.16.32-.3.65-.4 1H8v3h1.2c.1.35.24.68.4 1H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9ZM4 13v1.5c0 .78.6 1.42 1.36 1.5H7v-3H4Zm4-6h4V4H8v3Zm6.5-3H13v3h3V5.5c0-.78-.6-1.42-1.36-1.5h-.14ZM4 5.5V7h3V4H5.5c-.78 0-1.42.6-1.5 1.36v.14ZM7 12V8H4v4h3Zm5.06-.56a2 2 0 0 1-1.43 2.48l-.46.12a4.74 4.74 0 0 0 .01 1.01l.35.09A2 2 0 0 1 12 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.16-.55a2 2 0 0 1 1.44-2.48l.46-.12a4.7 4.7 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 17 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.3.13-.57.3-.82.5l.15.55Zm2.44 4.06a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const TableSimpleFilled = ( /*#__PURE__*/createFluentIcon('TableSimpleFilled', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5v4h6.5V3h-4Zm4 7.5H3v4A2.5 2.5 0 0 0 5.5 17h4v-6.5Zm1 0H17v4a2.5 2.5 0 0 1-2.5 2.5h-4v-6.5Zm6.5-1v-4A2.5 2.5 0 0 0 14.5 3h-4v6.5H17Z"]));
export const TableSimpleRegular = ( /*#__PURE__*/createFluentIcon('TableSimpleRegular', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9Zm1 5v4c0 .83.67 1.5 1.5 1.5h4v-5.5H4Zm5.5-1V4h-4C4.67 4 4 4.67 4 5.5v4h5.5Zm1 1V16h4c.83 0 1.5-.67 1.5-1.5v-4h-5.5Zm5.5-1v-4c0-.83-.67-1.5-1.5-1.5h-4v5.5H16Z"]));
export const TableSimpleCheckmarkFilled = ( /*#__PURE__*/createFluentIcon('TableSimpleCheckmarkFilled', "1em", ["M14 17h-3.5v-6.5H17V14a3 3 0 0 1-3 3Zm3-7.5h-6.5V3H14a3 3 0 0 1 3 3v3.5Zm-7.5 0V3H6a3 3 0 0 0-3 3v3.5h6.5Zm0 7.5v-6.5H3V14a3 3 0 0 0 3 3h3.5Zm5.85-3.9a.5.5 0 0 0-.7-.7l-1.4 1.4-.4-.4a.5.5 0 0 0-.7.7l.75.75c.2.2.5.2.7 0l1.75-1.75Z"]));
export const TableSimpleCheckmarkRegular = ( /*#__PURE__*/createFluentIcon('TableSimpleCheckmarkRegular', "1em", ["M6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6ZM4 6c0-1.1.9-2 2-2h3.5v5.5H4V6Zm6.5 3.5V4H14a2 2 0 0 1 2 2v3.5h-5.5Zm-6.5 1h5.5V16H6a2 2 0 0 1-2-2v-3.5Zm10.86 1.4c.2.2.2.5 0 .7l-1.75 1.75a.5.5 0 0 1-.71 0l-.75-.75a.5.5 0 0 1 .7-.7l.4.4 1.4-1.4c.2-.2.51-.2.7 0Z"]));
export const TableSimpleExcludeFilled = ( /*#__PURE__*/createFluentIcon('TableSimpleExcludeFilled', "1em", ["M4.5 2H8v6H2V4.5A2.5 2.5 0 0 1 4.5 2ZM2 9v3.5A2.5 2.5 0 0 0 4.5 15H8V9H2Zm13-1V4.5A2.5 2.5 0 0 0 12.5 2H9v6h6Zm-4 5c0-1.1.9-2 2-2h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2h-4a2 2 0 0 1-2-2v-4Z"]));
export const TableSimpleExcludeRegular = ( /*#__PURE__*/createFluentIcon('TableSimpleExcludeRegular', "1em", ["M4.5 2A2.5 2.5 0 0 0 2 4.5v8A2.5 2.5 0 0 0 4.5 15h4a.5.5 0 0 0 .5-.5V9h5.5a.5.5 0 0 0 .5-.5v-4A2.5 2.5 0 0 0 12.5 2h-8ZM8 9v5H4.5A1.5 1.5 0 0 1 3 12.5V9h5Zm0-1H3V4.5C3 3.67 3.67 3 4.5 3H8v5Zm1 0V3h3.5c.83 0 1.5.67 1.5 1.5V8H9Zm2 5c0-1.1.9-2 2-2h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2h-4a2 2 0 0 1-2-2v-4Z"]));
export const TableSimpleIncludeFilled = ( /*#__PURE__*/createFluentIcon('TableSimpleIncludeFilled', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5v4h6.13c.11-.14.23-.26.37-.37V3h-4ZM3 10.5h5.6c-.06.24-.1.49-.1.75v4c0 .66.24 1.27.63 1.75H5.5A2.5 2.5 0 0 1 3 14.5v-4Zm14-5v3.63a2.74 2.74 0 0 0-1.75-.63h-4c-.26 0-.51.04-.75.1V3h4A2.5 2.5 0 0 1 17 5.5Zm-7.5 5.75c0-.97.78-1.75 1.75-1.75h4c.97 0 1.75.78 1.75 1.75v4c0 .97-.78 1.75-1.75 1.75h-4c-.97 0-1.75-.78-1.75-1.75v-4Z"]));
export const TableSimpleIncludeRegular = ( /*#__PURE__*/createFluentIcon('TableSimpleIncludeRegular', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v3.63a2.74 2.74 0 0 0-1-.53V5.5c0-.83-.67-1.5-1.5-1.5h-4v4.6c-.37.1-.71.29-1 .53V4h-4C4.67 4 4 4.67 4 5.5v4h5.13c-.24.29-.42.63-.53 1H4v4c0 .83.67 1.5 1.5 1.5h3.1c.1.37.29.71.53 1H5.5A2.5 2.5 0 0 1 3 14.5v-9Zm6.5 5.75c0-.97.78-1.75 1.75-1.75h4c.97 0 1.75.78 1.75 1.75v4c0 .97-.78 1.75-1.75 1.75h-4c-.97 0-1.75-.78-1.75-1.75v-4Z"]));
export const TableSimpleMultipleFilled = ( /*#__PURE__*/createFluentIcon('TableSimpleMultipleFilled', "1em", ["M4.5 2A2.5 2.5 0 0 0 2 4.5V8h6V2H4.5ZM2 12.5V9h6v6H4.5A2.5 2.5 0 0 1 2 12.5ZM9 15V9h6v3.5a2.5 2.5 0 0 1-2.5 2.5H9Zm6-10.5V8H9V2h3.5A2.5 2.5 0 0 1 15 4.5ZM7.5 18a2.5 2.5 0 0 1-2.45-2h7.45a3.5 3.5 0 0 0 3.5-3.5V5.05a2.5 2.5 0 0 1 2 2.45v5.75A4.75 4.75 0 0 1 13.25 18H7.5Z"]));
export const TableSimpleMultipleRegular = ( /*#__PURE__*/createFluentIcon('TableSimpleMultipleRegular', "1em", ["M4.5 2A2.5 2.5 0 0 0 2 4.5v8A2.5 2.5 0 0 0 4.5 15h8a2.5 2.5 0 0 0 2.5-2.5v-8A2.5 2.5 0 0 0 12.5 2h-8ZM14 8H9V3h3.5c.83 0 1.5.67 1.5 1.5V8ZM8 8H3V4.5C3 3.67 3.67 3 4.5 3H8v5ZM3 9h5v5H4.5A1.5 1.5 0 0 1 3 12.5V9Zm6 0h5v3.5c0 .83-.67 1.5-1.5 1.5H9V9Zm-1.5 9a2.5 2.5 0 0 1-2.45-2H6.1c.2.58.76 1 1.41 1h5.75A3.75 3.75 0 0 0 17 13.25V7.5c0-.65-.42-1.2-1-1.41V5.05a2.5 2.5 0 0 1 2 2.45v5.75A4.75 4.75 0 0 1 13.25 18H7.5Z"]));
export const TableSparkleFilled = ( /*#__PURE__*/createFluentIcon('TableSparkleFilled', "1em", ["m13.88.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.23 2.23 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Zm4.9 7.93-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02ZM9.1 3a1.42 1.42 0 0 0 .86 1.84h.01l1.08.35a1.2 1.2 0 0 1 .76.77l.2.6V7H8V3h1.09Zm7.4 9H13V8.5a1.3 1.3 0 0 0 .87 1.23h.01l.77.25a.58.58 0 0 1 .37.37l.25.77v.01a1.3 1.3 0 0 0 1.22.87Zm-1.99 5H13v-4h4v1.5a2.5 2.5 0 0 1-2.5 2.5ZM8 12h4V8H8v4Zm4 1H8v4h4v-4ZM7 8v4H3V8h4Zm0 5H3v1.5A2.5 2.5 0 0 0 5.5 17H7v-4Zm0-6V3H5.5A2.5 2.5 0 0 0 3 5.5V7h4Z"]));
export const TableSparkleRegular = ( /*#__PURE__*/createFluentIcon('TableSparkleRegular', "1em", ["M9.09 3H5.5A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5v-2.6a1.3 1.3 0 0 1-1 0v.1h-3V8h.1l.02-.05c-.16-.04-.3-.12-.44-.21l-.07-.05c-.2-.17-.36-.39-.45-.64v-.01L12 6.57V7H8V4h1.1a1.42 1.42 0 0 1-.01-1ZM4 13h3v3H5.36A1.5 1.5 0 0 1 4 14.5V13Zm4 3v-3h4v3H8Zm5 0v-3h3V14.64A1.5 1.5 0 0 1 14.5 16H13Zm-1-4H8V8h4v4ZM4 5.5v-.14A1.5 1.5 0 0 1 5.5 4H7v3H4V5.5ZM7 12H4V8h3v4ZM13.88.28l.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.23 2.23 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Zm4.9 7.93-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02Z"]));
export const TableSplitFilled = ( /*#__PURE__*/createFluentIcon('TableSplitFilled', "1em", ["M8 6h4V2H8v4ZM7 2H3.5a.5.5 0 0 0-.5.5V4c0 1.1.9 2 2 2h2V2Zm6 4h2a2 2 0 0 0 2-2V2.5a.5.5 0 0 0-.5-.5H13v4Zm4 11.5a.5.5 0 0 1-.5.5H13v-4h2a2 2 0 0 1 2 2v1.5ZM12 14v4H8v-4h4Zm-8.5 4H7v-4H5a2 2 0 0 0-2 2v1.5c0 .28.22.5.5.5Zm-1-8.5h15a.5.5 0 1 1 0 1h-15a.5.5 0 0 1 0-1Z"]));
export const TableSplitRegular = ( /*#__PURE__*/createFluentIcon('TableSplitRegular', "1em", ["M16.5 2c.28 0 .5.22.5.5V4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V2.5a.5.5 0 0 1 1 0V4a1 1 0 0 0 1 1h2V2.5a.5.5 0 0 1 1 0V5h4V2.5a.5.5 0 0 1 1 0V5h2a1 1 0 0 0 1-1V2.5c0-.28.22-.5.5-.5Zm0 16a.5.5 0 0 0 .5-.5V16a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v1.5a.5.5 0 0 0 1 0V16a1 1 0 0 1 1-1h2v2.5a.5.5 0 0 0 1 0V15h4v2.5a.5.5 0 0 0 1 0V15h2a1 1 0 0 1 1 1v1.5c0 .28.22.5.5.5Zm-14-8.5h15a.5.5 0 1 1 0 1h-15a.5.5 0 0 1 0-1Z"]));
export const TableStackAboveFilled = ( /*#__PURE__*/createFluentIcon('TableStackAboveFilled', "1em", ["M3.5 3a.5.5 0 0 0 0 1h13a.5.5 0 0 0 0-1h-13ZM15 17h-2v-4h4v2a2 2 0 0 1-2 2Zm2-5h-4V8h3.5c.28 0 .5.22.5.5V12Zm-5 0V8H8v4h4Zm-4 5h4v-4H8v4ZM7 8v4H3V8.5c0-.28.22-.5.5-.5H7Zm0 9H5a2 2 0 0 1-2-2v-2h4v4Z"]));
export const TableStackAboveRegular = ( /*#__PURE__*/createFluentIcon('TableStackAboveRegular', "1em", ["M3 3.5c0-.28.22-.5.5-.5h13a.5.5 0 0 1 0 1h-13a.5.5 0 0 1-.5-.5Zm0 5c0-.28.22-.5.5-.5h13c.28 0 .5.22.5.5V15a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V8.5ZM4 13v2a1 1 0 0 0 1 1h2v-3H4Zm8 3v-3H8v3h4Zm1 0h2a1 1 0 0 0 1-1v-2h-3v3Zm0-4h3V9h-3v3Zm-1-3H8v3h4V9ZM4 9v3h3V9H4Z"]));
export const TableStackBelowFilled = ( /*#__PURE__*/createFluentIcon('TableStackBelowFilled', "1em", ["M16.5 17a.5.5 0 0 0 0-1h-13a.5.5 0 0 0 0 1h13ZM5 3h2v4H3V5c0-1.1.9-2 2-2ZM3 8h4v4H3.5a.5.5 0 0 1-.5-.5V8Zm5 0v4h4V8H8Zm4-5H8v4h4V3Zm1 9V8h4v3.5a.5.5 0 0 1-.5.5H13Zm0-9h2a2 2 0 0 1 2 2v2h-4V3Z"]));
export const TableStackBelowRegular = ( /*#__PURE__*/createFluentIcon('TableStackBelowRegular', "1em", ["M17 16.5a.5.5 0 0 1-.5.5h-13a.5.5 0 0 1 0-1h13c.28 0 .5.22.5.5Zm0-5a.5.5 0 0 1-.5.5h-13a.5.5 0 0 1-.5-.5V5c0-1.1.9-2 2-2h10a2 2 0 0 1 2 2v6.5ZM16 7V5a1 1 0 0 0-1-1h-2v3h3ZM8 4v3h4V4H8ZM7 4H5a1 1 0 0 0-1 1v2h3V4Zm0 4H4v3h3V8Zm1 3h4V8H8v3Zm8 0V8h-3v3h3Z"]));
export const TableStackLeftFilled = ( /*#__PURE__*/createFluentIcon('TableStackLeftFilled', "1em", ["M3 16.5a.5.5 0 0 0 1 0v-13a.5.5 0 0 0-1 0v13ZM17 5v2h-4V3h2a2 2 0 0 1 2 2Zm-5-2v4H8V3.5c0-.28.22-.5.5-.5H12Zm0 5H8v4h4V8Zm5 4V8h-4v4h4Zm-9 1h4v4H8.5a.5.5 0 0 1-.5-.5V13Zm9 0v2a2 2 0 0 1-2 2h-2v-4h4Z"]));
export const TableStackLeftRegular = ( /*#__PURE__*/createFluentIcon('TableStackLeftRegular', "1em", ["M3.5 17a.5.5 0 0 1-.5-.5v-13a.5.5 0 0 1 1 0v13a.5.5 0 0 1-.5.5Zm5 0a.5.5 0 0 1-.5-.5v-13c0-.28.22-.5.5-.5H15a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2H8.5Zm4.5-1h2a1 1 0 0 0 1-1v-2h-3v3Zm3-8h-3v4h3V8Zm0-1V5a1 1 0 0 0-1-1h-2v3h3Zm-4 0V4H9v3h3ZM9 8v4h3V8H9Zm0 8h3v-3H9v3Z"]));
export const TableStackRightFilled = ( /*#__PURE__*/createFluentIcon('TableStackRightFilled', "1em", ["M17 3.5a.5.5 0 0 0-1 0v13a.5.5 0 0 0 1 0v-13ZM3 15v-2h4v4H5a2 2 0 0 1-2-2Zm5 2v-4h4v3.5a.5.5 0 0 1-.5.5H8Zm0-5h4V8H8v4ZM3 8v4h4V8H3Zm9-1H8V3h3.5c.28 0 .5.22.5.5V7ZM3 7V5c0-1.1.9-2 2-2h2v4H3Z"]));
export const TableStackRightRegular = ( /*#__PURE__*/createFluentIcon('TableStackRightRegular', "1em", ["M16.5 3c.28 0 .5.22.5.5v13a.5.5 0 0 1-1 0v-13c0-.28.22-.5.5-.5Zm-5 0c.28 0 .5.22.5.5v13a.5.5 0 0 1-.5.5H5a2 2 0 0 1-2-2V5c0-1.1.9-2 2-2h6.5ZM7 4H5a1 1 0 0 0-1 1v2h3V4Zm-3 8h3V8H4v4Zm0 1v2a1 1 0 0 0 1 1h2v-3H4Zm4 0v3h3v-3H8Zm3-1V8H8v4h3Zm0-8H8v3h3V4Z"]));
export const TableSwitchFilled = ( /*#__PURE__*/createFluentIcon('TableSwitchFilled', "1em", ["M7.85 1.15a.5.5 0 1 0-.7.7L8.29 3H6a3 3 0 0 0-3 3v2.3L1.85 7.14a.5.5 0 1 0-.7.7l2 2c.2.2.5.2.7 0l2-2a.5.5 0 1 0-.7-.7L4 8.29V6c0-1.1.9-2 2-2h2.3L7.14 5.15a.5.5 0 1 0 .7.7l2-2a.5.5 0 0 0 0-.7l-2-2Zm.71 5.41a1.5 1.5 0 0 1-.56.35V7h4V3h-1.09a1.5 1.5 0 0 1-.35 1.56l-2 2Zm-4 4a1.5 1.5 0 0 1-1.56.35V12h4V8h-.09c-.07.2-.19.4-.35.56l-2 2ZM13 17h1.5a2.5 2.5 0 0 0 2.5-2.5V13h-4v4Zm0-5V8h4v4h-4Zm-1 0H8V8h4v4Zm-4 1h4v4H8v-4Zm-5 0h4v4H5.5A2.5 2.5 0 0 1 3 14.5V13Zm10-6h4V5.5A2.5 2.5 0 0 0 14.5 3H13v4Z"]));
export const TableSwitchRegular = ( /*#__PURE__*/createFluentIcon('TableSwitchRegular', "1em", ["M7.85 1.15a.5.5 0 1 0-.7.7L8.29 3H6a3 3 0 0 0-3 3v2.3L1.85 7.14a.5.5 0 1 0-.7.7l2 2c.2.2.5.2.7 0l2-2a.5.5 0 1 0-.7-.7L4 8.29V6c0-1.1.9-2 2-2h2.3L7.14 5.15a.5.5 0 1 0 .7.7l2-2a.5.5 0 0 0 0-.7l-2-2ZM7 12V7h5V4h-1.09a1.5 1.5 0 0 0 0-1h3.59A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-3.59c.32.12.68.12 1 0V12h3Zm-3 2.5c0 .78.6 1.42 1.36 1.5H7v-3H4v1.5Zm8-1.5H8v3h4v-3Zm2.5 3c.78 0 1.42-.6 1.5-1.36V13h-3v3h1.5ZM12 8H8v4h4V8Zm1 0v4h3V8h-3Zm0-4v3h3V5.5c0-.78-.6-1.42-1.36-1.5H13Z"]));
export const TabletFilled = ( /*#__PURE__*/createFluentIcon('TabletFilled', "1em", ["M2 6c0-1.1.9-2 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V6Zm6.5 6a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3Z"]));
export const TabletRegular = ( /*#__PURE__*/createFluentIcon('TabletRegular', "1em", ["M8.5 12a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3ZM4 4a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h12a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2H4ZM3 6a1 1 0 0 1 1-1h12a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V6Z"]));
export const TabletLaptopFilled = ( /*#__PURE__*/createFluentIcon('TabletLaptopFilled', "1em", ["M7 3a2 2 0 0 0-2 2v3h6a3 3 0 0 1 3 3v1h1a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2H7Zm10.5 11H14v-1h3.5a.5.5 0 0 1 0 1Zm-11 0a.5.5 0 0 0 0 1h2a.5.5 0 0 0 0-1h-2ZM2 11c0-1.1.9-2 2-2h7a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2v-4Z"]));
export const TabletLaptopRegular = ( /*#__PURE__*/createFluentIcon('TabletLaptopRegular', "1em", ["M5 5c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-1v-1h1a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1v3H5V5Zm9 8v1h3.5a.5.5 0 0 0 0-1H14ZM2 11c0-1.1.9-2 2-2h7a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2v-4Zm2-1a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h7a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1H4Zm2 4.5c0-.28.22-.5.5-.5h2a.5.5 0 0 1 0 1h-2a.5.5 0 0 1-.5-.5Z"]));
export const TabletSpeakerFilled = ( /*#__PURE__*/createFluentIcon('TabletSpeakerFilled', "1em", ["M13.7 2.04c.18.08.3.26.3.46v6a.5.5 0 0 1-.85.35L11.29 7h-.79a.5.5 0 0 1-.5-.5v-2c0-.28.22-.5.5-.5h.8l1.85-1.85a.5.5 0 0 1 .54-.11Zm3.95.16c.12.16.29.45.44.87.26.68.41 1.5.41 2.43 0 .94-.15 1.75-.4 2.43-.16.42-.33.7-.45.87a.5.5 0 0 1-.85-.52l.12-.19a5.9 5.9 0 0 0 .58-2.6 5.9 5.9 0 0 0-.58-2.58l-.07-.11a.5.5 0 1 1 .8-.6Zm-1.7 1.08a5.5 5.5 0 0 1 .55 2.22 4.9 4.9 0 0 1-.55 2.22.5.5 0 1 1-.9-.44l.08-.17.15-.4c.14-.42.22-.83.22-1.21s-.08-.8-.22-1.22a4.59 4.59 0 0 0-.23-.56.5.5 0 1 1 .9-.44Zm.4 6.42a1.5 1.5 0 0 1-.53-.74 1.5 1.5 0 0 1-.87-.07 1.5 1.5 0 0 1-2.51.67L10.88 8h-.38A1.5 1.5 0 0 1 9 6.5v-2c0-.18.03-.34.09-.5H4a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h12a2 2 0 0 0 2-2V9.8c-.5.29-1.15.27-1.65-.1ZM8.5 13h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1 0-1Z"]));
export const TabletSpeakerRegular = ( /*#__PURE__*/createFluentIcon('TabletSpeakerRegular', "1em", ["M18.1 3.07a3.67 3.67 0 0 0-.45-.87.5.5 0 0 0-.8.6l.07.1a5.9 5.9 0 0 1 .58 2.6 5.9 5.9 0 0 1-.58 2.6l-.12.18a.5.5 0 0 0 .85.52c.12-.16.29-.45.44-.87.26-.68.41-1.5.41-2.43 0-.94-.15-1.75-.4-2.43ZM14 2.5a.5.5 0 0 0-.85-.35L11.29 4h-.79a.5.5 0 0 0-.5.5v2c0 .28.22.5.5.5h.8l1.85 1.85A.5.5 0 0 0 14 8.5v-6Zm1.95.78a5.5 5.5 0 0 1 .55 2.22 4.9 4.9 0 0 1-.55 2.22.5.5 0 1 1-.9-.44l.08-.17.15-.4c.14-.42.22-.83.22-1.21s-.08-.8-.22-1.22a4.59 4.59 0 0 0-.23-.56.5.5 0 1 1 .9-.44ZM17 9.98V14a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V6a1 1 0 0 1 1-1h5v-.5c0-.18.03-.34.09-.5H4a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h12a2 2 0 0 0 2-2V9.8c-.3.17-.66.24-1 .18ZM8.5 13a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3Z"]));
export const TabsFilled = ( /*#__PURE__*/createFluentIcon('TabsFilled', "1em", ["M2 8a6 6 0 0 1 6-6h3a3 3 0 0 1 2.24 1H8a5 5 0 0 0-5 5v5.24A3 3 0 0 1 2 11V8Zm2 .5A4.5 4.5 0 0 1 8.5 4H13a3 3 0 0 1 2.24 1H8.5A3.5 3.5 0 0 0 5 8.5v6.74A3 3 0 0 1 4 13V8.5ZM9 6a3 3 0 0 0-3 3v6a3 3 0 0 0 3 3h6a3 3 0 0 0 3-3V9a3 3 0 0 0-3-3H9Z"]));
export const TabsRegular = ( /*#__PURE__*/createFluentIcon('TabsRegular', "1em", ["M2 8a6 6 0 0 1 6-6h3a3 3 0 0 1 2.24 1H8a5 5 0 0 0-5 5v5.24A3 3 0 0 1 2 11V8Zm13-2a3 3 0 0 1 3 3v6a3 3 0 0 1-3 3H9a3 3 0 0 1-3-3V9a3 3 0 0 1 3-3h6Zm-8 9c0 1.1.9 2 2 2h6a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2H9a2 2 0 0 0-2 2v6ZM4 8.5A4.5 4.5 0 0 1 8.5 4H13a3 3 0 0 1 2.24 1H8.5A3.5 3.5 0 0 0 5 8.5v6.74A3 3 0 0 1 4 13V8.5Z"]));
export const TagFilled = ( /*#__PURE__*/createFluentIcon('TagFilled', "1em", ["M18 4.03a2 2 0 0 0-1.98-2L11.12 2a2 2 0 0 0-1.42.59L3.02 9.25a2 2 0 0 0 0 2.83l4.95 4.95a2 2 0 0 0 2.83 0l6.63-6.63A2 2 0 0 0 18 8.98V4.03ZM14 7a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const TagRegular = ( /*#__PURE__*/createFluentIcon('TagRegular', "1em", ["M14 7a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm-2.87-5a2 2 0 0 0-1.43.58L3.02 9.25a2 2 0 0 0 0 2.83l4.95 4.95a2 2 0 0 0 2.83 0l6.63-6.63A2 2 0 0 0 18 8.98V4.03a2 2 0 0 0-1.99-2L11.12 2Zm-.72 1.3a1 1 0 0 1 .71-.3l4.9.03a1 1 0 0 1 .99 1v4.95a1 1 0 0 1-.29.7l-6.63 6.64a1 1 0 0 1-1.41 0l-4.95-4.95a1 1 0 0 1 0-1.41l6.68-6.67Z"]));
export const TagAddFilled = ( /*#__PURE__*/createFluentIcon('TagAddFilled', "1em", ["M18 4.03a2 2 0 0 0-1.98-2L11.12 2a2 2 0 0 0-1.42.59L3.02 9.25a2 2 0 0 0 0 2.83l4.95 4.95a2 2 0 0 0 1.95.51 5.5 5.5 0 0 1 7.8-7.5 2 2 0 0 0 .3-1.06L18 4.03ZM14 7a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm5 7.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const TagAddRegular = ( /*#__PURE__*/createFluentIcon('TagAddRegular', "1em", ["M14 7a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm-2.87-5a2 2 0 0 0-1.43.58L3.02 9.25a2 2 0 0 0 0 2.83l4.95 4.95a2 2 0 0 0 1.95.51c-.2-.29-.36-.6-.5-.93a1 1 0 0 1-.75-.29l-4.94-4.95a1 1 0 0 1 0-1.41l6.68-6.67a1 1 0 0 1 .71-.29l4.9.03a1 1 0 0 1 .99 1v4.95a1 1 0 0 1-.16.55c.3.14.6.31.86.5a2 2 0 0 0 .3-1.05V4.03a2 2 0 0 0-2-2L11.14 2ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const TagCircleFilled = ( /*#__PURE__*/createFluentIcon('TagCircleFilled', "1em", ["M2 10a8 8 0 1 1 16 0 8 8 0 0 1-16 0Zm4-1.5v3c0 .83.67 1.5 1.5 1.5h4.06c.4 0 .79-.14 1.1-.39l1.78-1.44a1.5 1.5 0 0 0 0-2.34L12.66 7.4c-.31-.25-.7-.39-1.1-.39H7.5C6.67 7 6 7.67 6 8.5Z"]));
export const TagCircleRegular = ( /*#__PURE__*/createFluentIcon('TagCircleRegular', "1em", ["M7.5 7C6.67 7 6 7.67 6 8.5v3c0 .83.67 1.5 1.5 1.5h4.06c.4 0 .79-.14 1.1-.39l1.78-1.44a1.5 1.5 0 0 0 0-2.34L12.66 7.4c-.31-.25-.7-.39-1.1-.39H7.5ZM7 8.5c0-.28.22-.5.5-.5h4.06c.17 0 .34.06.47.17L13.8 9.6a.5.5 0 0 1 0 .78l-1.78 1.44c-.13.11-.3.17-.47.17H7.5a.5.5 0 0 1-.5-.5v-3ZM10 2a8 8 0 1 0 0 16 8 8 0 0 0 0-16Zm-7 8a7 7 0 1 1 14 0 7 7 0 0 1-14 0Z"]));
export const TagDismissFilled = ( /*#__PURE__*/createFluentIcon('TagDismissFilled', "1em", ["M18 4.03a2 2 0 0 0-1.98-2L11.12 2a2 2 0 0 0-1.42.59L3.02 9.25a2 2 0 0 0 0 2.83l4.95 4.95a2 2 0 0 0 1.95.51 5.5 5.5 0 0 1 7.8-7.5 2 2 0 0 0 .3-1.06L18 4.03ZM14 7a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm5 7.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.65-1.15a.5.5 0 0 0-.7-.7l-1.15 1.14-1.15-1.14a.5.5 0 0 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 0 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 0 0 .7-.7l-1.14-1.15 1.14-1.15Z"]));
export const TagDismissRegular = ( /*#__PURE__*/createFluentIcon('TagDismissRegular', "1em", ["M14 7a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm-2.87-5a2 2 0 0 0-1.43.58L3.02 9.25a2 2 0 0 0 0 2.83l4.95 4.95a2 2 0 0 0 1.95.51c-.2-.29-.36-.6-.5-.93a1 1 0 0 1-.74-.29l-4.95-4.95a1 1 0 0 1 0-1.41l6.68-6.67a1 1 0 0 1 .71-.29l4.9.03a1 1 0 0 1 .99 1v4.95a1 1 0 0 1-.16.55c.3.14.6.31.86.5a2 2 0 0 0 .3-1.05V4.03a2 2 0 0 0-1.99-2L11.12 2ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.65-1.15a.5.5 0 0 0-.7-.7l-1.15 1.14-1.15-1.14a.5.5 0 0 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 0 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 0 0 .7-.7l-1.14-1.15 1.14-1.15Z"]));
export const TagEditFilled = ( /*#__PURE__*/createFluentIcon('TagEditFilled', "1em", ["M18 4.03a2 2 0 0 0-1.98-2L11.12 2a2 2 0 0 0-1.42.59L3.02 9.25a2 2 0 0 0 0 2.83l4.95 4.95.03.03c0-.13.02-.27.06-.4l.37-1.5a3.2 3.2 0 0 1 .84-1.49l4.83-4.83a2.87 2.87 0 0 1 3.91-.14V4.03ZM14 7a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm-4.02 7.38 4.83-4.83a1.87 1.87 0 1 1 2.64 2.64l-4.83 4.83a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.07l.37-1.5c.1-.39.3-.74.58-1.02Z"]));
export const TagEditRegular = ( /*#__PURE__*/createFluentIcon('TagEditRegular', "1em", ["M14 7a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm-2.87-5a2 2 0 0 0-1.43.58L3.02 9.25a2 2 0 0 0 0 2.83l4.95 4.95.03.03c0-.13.02-.27.06-.4l.19-.77-4.52-4.52a1 1 0 0 1 0-1.41l6.68-6.67a1 1 0 0 1 .71-.29l4.9.03a1 1 0 0 1 .99 1v4.1c.36.12.7.31 1 .57V4.03a2 2 0 0 0-2-2L11.14 2ZM9.98 14.38l4.83-4.83a1.87 1.87 0 1 1 2.64 2.64l-4.83 4.83a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.07l.37-1.5c.1-.39.3-.74.58-1.02Z"]));
export const TagErrorFilled = ( /*#__PURE__*/createFluentIcon('TagErrorFilled', "1em", ["M18 4.03a2 2 0 0 0-1.98-2L11.12 2a2 2 0 0 0-1.42.59L3.02 9.25a2 2 0 0 0 0 2.83l4.95 4.95a2 2 0 0 0 1.95.51 5.5 5.5 0 0 1 7.8-7.5 2 2 0 0 0 .3-1.06L18 4.03ZM14 7a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm5 7.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM14.5 12a.5.5 0 0 0-.5.5v2a.5.5 0 1 0 1 0v-2a.5.5 0 0 0-.5-.5Zm0 5.12a.62.62 0 1 0 0-1.25.62.62 0 0 0 0 1.25Z"]));
export const TagErrorRegular = ( /*#__PURE__*/createFluentIcon('TagErrorRegular', "1em", ["M14 7a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm-2.87-5a2 2 0 0 0-1.43.58L3.02 9.25a2 2 0 0 0 0 2.83l4.95 4.95a2 2 0 0 0 1.95.51c-.2-.29-.36-.6-.5-.93a1 1 0 0 1-.74-.29l-4.95-4.95a1 1 0 0 1 0-1.41l6.68-6.67a1 1 0 0 1 .71-.29l4.9.03a1 1 0 0 1 .99 1v4.95a1 1 0 0 1-.16.55c.3.14.6.31.86.5a2 2 0 0 0 .3-1.05V4.03a2 2 0 0 0-1.99-2L11.12 2ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM14.5 12a.5.5 0 0 0-.5.5v2a.5.5 0 0 0 1 0v-2a.5.5 0 0 0-.5-.5Zm0 5.13a.62.62 0 1 0 0-1.25.62.62 0 0 0 0 1.24Z"]));
export const TagLockFilled = ( /*#__PURE__*/createFluentIcon('TagLockFilled', "1em", ["M18 4.03a2 2 0 0 0-1.98-2L11.12 2a2 2 0 0 0-1.42.59L3.02 9.25a2 2 0 0 0 0 2.83l4.95 4.95a2 2 0 0 0 2.03.49V14a2 2 0 0 1 1.5-1.94V12a3 3 0 0 1 5.68-1.35l.25-.25A2 2 0 0 0 18 8.98V4.03ZM14 7a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm-1.5 5v1H12a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h5a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1h-.5v-1a2 2 0 1 0-4 0Zm1 1v-1a1 1 0 1 1 2 0v1h-2Zm1 2.25a.75.75 0 1 1 0 1.5.75.75 0 0 1 0-1.5Z"]));
export const TagLockRegular = ( /*#__PURE__*/createFluentIcon('TagLockRegular', "1em", ["M14 7a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm-2.87-5a2 2 0 0 0-1.43.58L3.02 9.25a2 2 0 0 0 0 2.83l4.95 4.95a2 2 0 0 0 2.03.49V16.4a1 1 0 0 1-1.32-.08l-4.95-4.95a1 1 0 0 1 0-1.41l6.68-6.67a1 1 0 0 1 .71-.29l4.9.03a1 1 0 0 1 .99 1v4.95a1 1 0 0 1-.29.7l-.14.15a3 3 0 0 1 .6.82l.25-.25A2 2 0 0 0 18 8.98V4.03a2 2 0 0 0-1.99-2L11.12 2Zm1.37 10v1H12a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h5a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1h-.5v-1a2 2 0 1 0-4 0Zm1 1v-1a1 1 0 1 1 2 0v1h-2Zm1 2.25a.75.75 0 1 1 0 1.5.75.75 0 0 1 0-1.5Z"]));
export const TagLockAccentFilled = ( /*#__PURE__*/createFluentIcon('TagLockAccentFilled', "1em", ["M17.5 4.03c0-.82-.66-1.49-1.48-1.5l-4.9-.03c-.4 0-.78.16-1.06.44L3.38 9.61a1.5 1.5 0 0 0 0 2.12l4.94 4.95a1.5 1.5 0 0 0 1.68.3V14a2 2 0 0 1 1.5-1.94V12a3 3 0 0 1 5.4-1.79l.17-.16c.29-.29.44-.67.44-1.07V4.03Z"]));
export const TagMultipleFilled = ( /*#__PURE__*/createFluentIcon('TagMultipleFilled', "1em", ["M3 11.8a2 2 0 0 0 .46 2.11l2.97 2.98a4 4 0 0 0 5.65.02l4.4-4.36a2 2 0 0 0 .6-1.43v-.57l-5 4.96-.15.13-.56.55a3 3 0 0 1-4.23 0l-.5-.5a4.05 4.05 0 0 1-.2-.2l-2.98-2.98A2 2 0 0 1 3 11.8Zm6.2-9.21A2 2 0 0 1 10.63 2h4.45a2 2 0 0 1 2 2v4.37a2 2 0 0 1-.59 1.43l-5.82 5.76a2 2 0 0 1-2.82-.01l-4.38-4.39a2 2 0 0 1 0-2.82L9.2 2.59Zm4.3 3.91a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"]));
export const TagMultipleRegular = ( /*#__PURE__*/createFluentIcon('TagMultipleRegular', "1em", ["M13.5 6.5a1 1 0 1 0 0-2 1 1 0 0 0 0 2ZM9.2 2.59A2 2 0 0 1 10.63 2h4.45a2 2 0 0 1 2 2v4.37a2 2 0 0 1-.59 1.43l-5.82 5.76a2 2 0 0 1-2.82-.01l-4.38-4.39a2 2 0 0 1 0-2.82L9.2 2.59Zm1.42.41a1 1 0 0 0-.7.3L4.15 9.03a1 1 0 0 0 0 1.42l4.39 4.38a1 1 0 0 0 1.4 0l5.83-5.76a1 1 0 0 0 .3-.7V4a1 1 0 0 0-1-1h-4.46ZM3 11.8a2 2 0 0 0 .46 2.11l2.97 2.98a4 4 0 0 0 5.65.02l4.4-4.36a2 2 0 0 0 .6-1.43v-.57l-5 4.96-.15.13-.56.55a3 3 0 0 1-4.23 0l-.5-.5a4.05 4.05 0 0 1-.2-.2l-2.98-2.98A2 2 0 0 1 3 11.8Z"]));
export const TagOffFilled = ( /*#__PURE__*/createFluentIcon('TagOffFilled', "1em", ["M2.85 2.15a.5.5 0 1 0-.7.7L5.79 6.5 3.02 9.25a2 2 0 0 0 0 2.83l4.95 4.95a2 2 0 0 0 2.83 0l2.76-2.76 3.59 3.58a.5.5 0 0 0 .7-.7l-15-15Zm14.58 8.25-2.45 2.45L7.2 5.08l2.5-2.5A2 2 0 0 1 11.13 2l4.89.04a2 2 0 0 1 1.99 2v4.94a2 2 0 0 1-.58 1.42ZM14 7a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"]));
export const TagOffRegular = ( /*#__PURE__*/createFluentIcon('TagOffRegular', "1em", ["M5.79 6.5 2.15 2.84a.5.5 0 1 1 .7-.7l15 15a.5.5 0 0 1-.7.7l-3.6-3.58-2.75 2.76a2 2 0 0 1-2.83 0l-4.95-4.95a2 2 0 0 1 0-2.83L5.8 6.49Zm7.06 7.06L6.5 7.2 3.73 9.96a1 1 0 0 0 0 1.41l4.95 4.95a1 1 0 0 0 1.41 0l2.76-2.76Zm3.87-3.87-2.45 2.45.7.71 2.46-2.45A2 2 0 0 0 18 8.98V4.03a2 2 0 0 0-1.99-2L11.12 2a2 2 0 0 0-1.42.58l-2.5 2.5.7.7 2.51-2.49a1 1 0 0 1 .71-.29l4.9.03a1 1 0 0 1 .99 1v4.95a1 1 0 0 1-.29.7ZM14 7a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"]));
export const TagPercentFilled = ( /*#__PURE__*/createFluentIcon('TagPercentFilled', "1em", ["M18 4.03a2 2 0 0 0-1.98-2L11.12 2a2 2 0 0 0-1.42.59L3.02 9.25a2 2 0 0 0 0 2.83l4.95 4.95a2 2 0 0 0 1.95.51 5.5 5.5 0 0 1 7.8-7.5 2 2 0 0 0 .3-1.06L18 4.03ZM14 7a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm5 7.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM11.5 13a1 1 0 1 0 2 0 1 1 0 0 0-2 0Zm5.35-.85a.5.5 0 0 0-.7 0l-4 4a.5.5 0 0 0 .7.7l4-4a.5.5 0 0 0 0-.7ZM16.5 15a1 1 0 1 0 0 2 1 1 0 0 0 0-2Z"]));
export const TagPercentRegular = ( /*#__PURE__*/createFluentIcon('TagPercentRegular', "1em", ["M14 7a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm-2.87-5a2 2 0 0 0-1.43.58L3.02 9.25a2 2 0 0 0 0 2.83l4.95 4.95a2 2 0 0 0 1.95.51c-.2-.29-.36-.6-.5-.93a1 1 0 0 1-.75-.29l-4.94-4.95a1 1 0 0 1 0-1.41l6.68-6.67a1 1 0 0 1 .71-.29l4.9.03a1 1 0 0 1 .99 1v4.95a1 1 0 0 1-.16.55c.3.14.6.31.86.5a2 2 0 0 0 .3-1.05V4.03a2 2 0 0 0-2-2L11.14 2ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM11.5 13a1 1 0 1 0 2 0 1 1 0 0 0-2 0Zm5.35-.85a.5.5 0 0 0-.7 0l-4 4a.5.5 0 0 0 .7.7l4-4a.5.5 0 0 0 0-.7ZM16.5 15a1 1 0 1 0 0 2 1 1 0 0 0 0-2Z"]));
export const TagQuestionMarkFilled = ( /*#__PURE__*/createFluentIcon('TagQuestionMarkFilled', "1em", ["M18 4.03a2 2 0 0 0-1.98-2L11.12 2a2 2 0 0 0-1.42.59L3.02 9.25a2 2 0 0 0 0 2.83l4.95 4.95a2 2 0 0 0 1.95.51 5.5 5.5 0 0 1 7.8-7.5 2 2 0 0 0 .3-1.06L18 4.03ZM14 7a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm5 7.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4.5 1.88a.62.62 0 1 0 0 1.25.62.62 0 0 0 0-1.25Zm0-4.88c-1.05 0-1.86.82-1.85 1.96a.5.5 0 1 0 1-.01c0-.58.36-.95.85-.95.47 0 .85.4.85.95 0 .2-.07.32-.36.55l-.27.21c-.51.4-.72.72-.72 1.29a.5.5 0 0 0 1 .09v-.16c.02-.14.1-.25.35-.44l.28-.22c.5-.4.72-.73.72-1.32 0-1.1-.82-1.95-1.85-1.95Z"]));
export const TagQuestionMarkRegular = ( /*#__PURE__*/createFluentIcon('TagQuestionMarkRegular', "1em", ["M14 7a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm-2.87-5a2 2 0 0 0-1.43.58L3.02 9.25a2 2 0 0 0 0 2.83l4.95 4.95a2 2 0 0 0 1.95.51c-.2-.29-.36-.6-.5-.93a1 1 0 0 1-.74-.29l-4.95-4.95a1 1 0 0 1 0-1.41l6.68-6.67a1 1 0 0 1 .71-.29l4.9.03a1 1 0 0 1 .99 1v4.95a1 1 0 0 1-.16.55c.3.14.6.31.86.5a2 2 0 0 0 .3-1.05V4.03a2 2 0 0 0-1.99-2L11.12 2ZM19 14.5a4.5 4.5 0 1 0-9 0 4.5 4.5 0 0 0 9 0Zm-4.5 1.88a.62.62 0 1 1 0 1.25.62.62 0 0 1 0-1.25Zm0-4.88c1.03 0 1.85.85 1.85 1.95 0 .59-.21.91-.72 1.32l-.28.22c-.25.19-.33.3-.35.44v.16a.5.5 0 0 1-1-.09c0-.57.21-.88.72-1.29l.27-.21c.3-.23.36-.35.36-.55 0-.55-.38-.95-.85-.95-.5 0-.86.37-.85.95a.5.5 0 1 1-1 0c-.01-1.13.8-1.95 1.85-1.95Z"]));
export const TagResetFilled = ( /*#__PURE__*/createFluentIcon('TagResetFilled', "1em", ["M16.02 2.04a2 2 0 0 1 1.99 2v4.94a2 2 0 0 1-.58 1.42l-.15.15A5 5 0 0 0 15 10h-1.09a1.5 1.5 0 0 0-2.47-1.56l-2 2a1.5 1.5 0 0 0 0 2.12l1.2 1.2A1.5 1.5 0 0 0 10 15a5 5 0 0 0 .54 2.25 2 2 0 0 1-2.57-.22l-4.95-4.95a2 2 0 0 1 0-2.83L9.7 2.6A2 2 0 0 1 11.13 2l4.89.04ZM13 6a1 1 0 1 0 2 0 1 1 0 0 0-2 0Zm-.15 3.85a.5.5 0 0 0-.7-.7l-2 2a.5.5 0 0 0 0 .7l2 2a.5.5 0 0 0 .7-.7L11.71 12H15a3 3 0 1 1-3 3 .5.5 0 1 0-1 0 4 4 0 1 0 4-4h-3.3l1.15-1.15Z"]));
export const TagResetRegular = ( /*#__PURE__*/createFluentIcon('TagResetRegular', "1em", ["M15 6a1 1 0 1 1-2 0 1 1 0 0 1 2 0ZM9.7 2.58A2 2 0 0 1 11.13 2l4.89.03a2 2 0 0 1 1.99 2v4.95a2 2 0 0 1-.58 1.42l-.15.15a5 5 0 0 0-1.03-.4l.47-.46a1 1 0 0 0 .3-.7L17 4.02a1 1 0 0 0-1-1L11.12 3a1 1 0 0 0-.71.3L3.73 9.95a1 1 0 0 0 0 1.41l4.95 4.95a1 1 0 0 0 1.41 0l.07-.07a5 5 0 0 0 .37 1 2 2 0 0 1-2.56-.22l-4.95-4.95a2 2 0 0 1 0-2.83L9.7 2.58Zm3.15 7.27a.5.5 0 0 0-.7-.7l-2 2a.5.5 0 0 0 0 .7l2 2a.5.5 0 0 0 .7-.7L11.71 12H15a3 3 0 1 1-3 3 .5.5 0 1 0-1 0 4 4 0 1 0 4-4h-3.3l1.15-1.15Z"]));
export const TagSearchFilled = ( /*#__PURE__*/createFluentIcon('TagSearchFilled', "1em", ["M16.02 2.04a2 2 0 0 1 1.99 2v4.94a2 2 0 0 1-.58 1.42l-.36.36a4.5 4.5 0 1 0-6.31 6.3 2 2 0 0 1-2.8-.03l-4.94-4.95a2 2 0 0 1 0-2.83L9.7 2.6A2 2 0 0 1 11.13 2l4.89.04ZM13 6a1 1 0 1 0 2 0 1 1 0 0 0-2 0Zm3.3 9.6a3.5 3.5 0 1 0-.7.7l2.55 2.55a.5.5 0 1 0 .7-.7L16.3 15.6Zm-.3-2.1a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0Z"]));
export const TagSearchRegular = ( /*#__PURE__*/createFluentIcon('TagSearchRegular', "1em", ["M15 6a1 1 0 1 1-2 0 1 1 0 0 1 2 0ZM9.7 2.58A2 2 0 0 1 11.13 2l4.89.03a2 2 0 0 1 1.99 2v4.95a2 2 0 0 1-.58 1.42l-.36.36c-.2-.27-.44-.51-.7-.72l.35-.35a1 1 0 0 0 .3-.7L17 4.02a1 1 0 0 0-1-1L11.12 3a1 1 0 0 0-.71.3L3.73 9.95a1 1 0 0 0 0 1.41l4.95 4.95a1 1 0 0 0 1.35.05c.22.26.46.5.73.7a2 2 0 0 1-2.8-.04l-4.94-4.95a2 2 0 0 1 0-2.83L9.7 2.58Zm6.6 13.02a3.5 3.5 0 1 0-.7.7l2.55 2.55a.5.5 0 1 0 .7-.7L16.3 15.6Zm-.3-2.1a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0Z"]));
export const TapDoubleFilled = ( /*#__PURE__*/createFluentIcon('TapDoubleFilled', "1em", ["M4 8.5a5.5 5.5 0 1 1 10.97.6c.34.15.65.34.93.57A6.5 6.5 0 1 0 3.64 11.3c.25-.25.53-.45.82-.61A5.48 5.48 0 0 1 4 8.5Zm10 0-.01.33-1-.17.01-.16a3.5 3.5 0 1 0-6.57 1.69 4.4 4.4 0 0 0-1.05.13A4.48 4.48 0 0 1 9.5 4 4.5 4.5 0 0 1 14 8.5Zm-6-1a1.5 1.5 0 1 1 3 0v2.08l2.94.51a2.5 2.5 0 0 1 1.91 3.33l-.98 2.67a2.5 2.5 0 0 1-1.92 1.6l-1.52.26c-1.02.18-1.95-.45-2.43-1.23A5.87 5.87 0 0 0 4.44 14a.5.5 0 0 1-.43-.62c.15-.6.43-1.04.82-1.36.39-.32.85-.47 1.3-.52.63-.06 1.29.05 1.87.25V7.5Z"]));
export const TapDoubleRegular = ( /*#__PURE__*/createFluentIcon('TapDoubleRegular', "1em", ["M9.5 3a5.5 5.5 0 0 0-5.04 7.7c-.3.16-.57.36-.82.61A6.5 6.5 0 1 1 15.9 9.67a3.7 3.7 0 0 0-.93-.57l.03-.6A5.5 5.5 0 0 0 9.5 3Zm4.49 5.83L14 8.5a4.5 4.5 0 1 0-8.62 1.82 4.2 4.2 0 0 1 1.05-.13A3.5 3.5 0 1 1 13 8.66l1 .17ZM9.5 6C8.67 6 8 6.67 8 7.5v4.25a4.46 4.46 0 0 0-1.87-.25c-.45.05-.91.2-1.3.52s-.67.77-.82 1.36a.5.5 0 0 0 .43.62c2.6.28 3.92 1.7 4.56 2.72.48.78 1.4 1.41 2.43 1.23l1.52-.26a2.5 2.5 0 0 0 1.92-1.6l.98-2.67a2.5 2.5 0 0 0-1.91-3.33L11 9.58V7.5c0-.83-.67-1.5-1.5-1.5ZM9 7.5a.5.5 0 0 1 1 0V10c0 .24.17.45.41.5l3.35.58a1.5 1.5 0 0 1 1.15 2l-.98 2.67c-.19.5-.62.86-1.15.95l-1.52.27c-.5.09-1.07-.23-1.41-.77a6.77 6.77 0 0 0-4.65-3.1c.08-.13.17-.23.26-.3.2-.17.47-.27.78-.3.64-.07 1.42.14 2.04.45A.5.5 0 0 0 9 12.5v-5Z"]));
export const TapSingleFilled = ( /*#__PURE__*/createFluentIcon('TapSingleFilled', "1em", ["M6 8.5a3.5 3.5 0 1 1 7 .16l.99.17.01-.33a4.5 4.5 0 1 0-8.62 1.82 4.2 4.2 0 0 1 1.05-.13A3.48 3.48 0 0 1 6 8.5ZM9.5 6C8.67 6 8 6.67 8 7.5v4.25a4.46 4.46 0 0 0-1.87-.25c-.45.05-.91.2-1.3.52s-.67.77-.82 1.36a.5.5 0 0 0 .43.62c2.6.28 3.92 1.7 4.56 2.72.48.78 1.4 1.41 2.43 1.23l1.52-.26a2.5 2.5 0 0 0 1.92-1.6l.98-2.67a2.5 2.5 0 0 0-1.91-3.33L11 9.58V7.5c0-.83-.67-1.5-1.5-1.5Z"]));
export const TapSingleRegular = ( /*#__PURE__*/createFluentIcon('TapSingleRegular', "1em", ["M6 8.5a3.5 3.5 0 1 1 7 .16l.99.17.01-.33a4.5 4.5 0 1 0-8.62 1.82 4.2 4.2 0 0 1 1.05-.13A3.48 3.48 0 0 1 6 8.5ZM9.5 6C8.67 6 8 6.67 8 7.5v4.25a4.46 4.46 0 0 0-1.87-.25c-.45.05-.91.2-1.3.52s-.67.77-.82 1.36a.5.5 0 0 0 .43.62c2.6.28 3.92 1.7 4.56 2.72.48.78 1.4 1.41 2.43 1.23l1.52-.26a2.5 2.5 0 0 0 1.92-1.6l.98-2.67a2.5 2.5 0 0 0-1.91-3.33L11 9.58V7.5c0-.83-.67-1.5-1.5-1.5ZM9 7.5a.5.5 0 0 1 1 0V10c0 .24.17.45.41.5l3.35.58a1.5 1.5 0 0 1 1.15 2l-.98 2.67c-.19.5-.62.86-1.15.95l-1.52.27c-.5.09-1.07-.23-1.41-.77a6.77 6.77 0 0 0-4.65-3.1c.08-.13.17-.23.26-.3.2-.17.47-.27.78-.3.64-.07 1.42.14 2.04.45A.5.5 0 0 0 9 12.5v-5Z"]));
export const TargetFilled = ( /*#__PURE__*/createFluentIcon('TargetFilled', "1em", ["M10 11.5a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3ZM5 10a5 5 0 1 1 10 0 5 5 0 0 1-10 0Zm5-3.5a3.5 3.5 0 1 0 0 7 3.5 3.5 0 0 0 0-7ZM2 10a8 8 0 1 1 16 0 8 8 0 0 1-16 0Zm8-6.5a6.5 6.5 0 1 0 0 13 6.5 6.5 0 0 0 0-13Z"]));
export const TargetRegular = ( /*#__PURE__*/createFluentIcon('TargetRegular', "1em", ["M10 11.5a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3ZM5 10a5 5 0 1 1 10 0 5 5 0 0 1-10 0Zm5-4a4 4 0 1 0 0 8 4 4 0 0 0 0-8Zm-8 4a8 8 0 1 1 16 0 8 8 0 0 1-16 0Zm8-7a7 7 0 1 0 0 14 7 7 0 0 0 0-14Z"]));
export const TargetAddFilled = ( /*#__PURE__*/createFluentIcon('TargetAddFilled', "1em", ["M3.5 10a6.5 6.5 0 0 0 5.86 6.47c.22.55.52 1.07.9 1.52H10a8 8 0 1 1 7.99-7.74 5.5 5.5 0 0 0-1.53-.89A6.5 6.5 0 0 0 3.5 10Zm5.61 3.39a3.5 3.5 0 1 1 4.27-4.28 5.52 5.52 0 0 1 1.52-.1 5 5 0 1 0-5.89 5.9 5.58 5.58 0 0 1 .1-1.52Zm.78-1.9c.42-.63.97-1.18 1.6-1.6a1.5 1.5 0 1 0-1.6 1.6ZM14.5 19a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm0-7c.28 0 .5.22.5.5V14h1.5a.5.5 0 0 1 0 1H15v1.5a.5.5 0 0 1-1 0V15h-1.5a.5.5 0 0 1 0-1H14v-1.5c0-.28.22-.5.5-.5Z"]));
export const TargetAddRegular = ( /*#__PURE__*/createFluentIcon('TargetAddRegular', "1em", ["M19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Zm-5.1-1c.41-.64.96-1.19 1.6-1.6a1.5 1.5 0 1 0-1.6 1.6Zm-.87 2.38a4 4 0 1 1 4.85-4.85 5.56 5.56 0 0 1 1.02-.02 5 5 0 1 0-5.89 5.9 5.58 5.58 0 0 1 .02-1.03Zm.56 3.1A7 7 0 1 1 17 9.6c.36.19.7.4 1 .66L18 10a8 8 0 1 0-7.75 8 5.5 5.5 0 0 1-.66-1.01Z"]));
export const TargetArrowFilled = ( /*#__PURE__*/createFluentIcon('TargetArrowFilled', "1em", ["M17.6 7.52a8 8 0 1 1-5.11-5.13l-1.05 1.05a1.5 1.5 0 0 0-.16.19 6.5 6.5 0 1 0 5.09 5.1l.2-.17 1.03-1.04ZM14.9 9a5.02 5.02 0 0 1-4.9 6 5 5 0 1 1 1-9.9v1.55A3.5 3.5 0 1 0 13.35 9h1.55ZM10 11.5a1.5 1.5 0 0 0 1.45-1.89l1.58-1.58a.74.74 0 0 0 .03-.03h2.44a.5.5 0 0 0 .35-.15l2-2A.5.5 0 0 0 17.5 5H15V2.5a.5.5 0 0 0-.85-.35l-2 2a.5.5 0 0 0-.15.35v2.44a.76.76 0 0 0-.03.03l-1.58 1.58a1.5 1.5 0 1 0-.4 2.95Z"]));
export const TargetArrowRegular = ( /*#__PURE__*/createFluentIcon('TargetArrowRegular', "1em", ["M17.96 5.3a.5.5 0 0 1-.1.55l-2 2a.5.5 0 0 1-.36.15h-2.8l-1.35 1.35a1.5 1.5 0 1 1-.7-.7L12 7.29V4.5a.5.5 0 0 1 .15-.35l2-2a.5.5 0 0 1 .85.35V5h2.5c.2 0 .38.12.46.3ZM16.3 6H14.5a.5.5 0 0 1-.5-.5V3.7l-1 1V7h2.3l1-1Zm1.32 1.52a8 8 0 1 1-5.12-5.13l-.81.81A7.02 7.02 0 0 0 3 10a7 7 0 1 0 13.8-1.68l.8-.8ZM14.9 9a5.02 5.02 0 0 1-4.9 6 5 5 0 1 1 1-9.9v1.03A4 4 0 1 0 13.87 9h1.03Z"]));
export const TargetDismissFilled = ( /*#__PURE__*/createFluentIcon('TargetDismissFilled', "1em", ["M3.5 10a6.5 6.5 0 0 0 5.86 6.47c.22.55.52 1.07.9 1.52H10a8 8 0 1 1 7.99-7.74 5.5 5.5 0 0 0-1.53-.89A6.5 6.5 0 0 0 3.5 10Zm5.61 3.39a3.5 3.5 0 1 1 4.27-4.28 5.52 5.52 0 0 1 1.52-.1 5 5 0 1 0-5.89 5.9 5.58 5.58 0 0 1 .1-1.52Zm2.38-3.5c-.63.42-1.18.97-1.6 1.6a1.5 1.5 0 1 1 1.6-1.6ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.65-1.15a.5.5 0 0 0-.7-.7l-1.15 1.14-1.15-1.14a.5.5 0 0 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 0 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 0 0 .7-.7l-1.14-1.15 1.14-1.15Z"]));
export const TargetDismissRegular = ( /*#__PURE__*/createFluentIcon('TargetDismissRegular', "1em", ["M3 10a7 7 0 0 0 6.6 6.99c.18.36.4.7.65 1L10 18a8 8 0 1 1 8-7.75 5.5 5.5 0 0 0-1.01-.66A7 7 0 0 0 3 10Zm6.03 3.88a4 4 0 1 1 4.85-4.85 5.56 5.56 0 0 1 1.02-.02 5 5 0 1 0-5.89 5.9 5.58 5.58 0 0 1 .02-1.03Zm.86-2.38c.42-.64.97-1.19 1.6-1.6a1.5 1.5 0 1 0-1.6 1.6ZM14.5 19a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm1.85-6.35c.2.2.2.5 0 .7l-1.14 1.15 1.14 1.15a.5.5 0 0 1-.7.7l-1.15-1.14-1.15 1.14a.5.5 0 0 1-.7-.7l1.14-1.15-1.14-1.15a.5.5 0 0 1 .7-.7l1.15 1.14 1.15-1.14c.2-.2.5-.2.7 0Z"]));
export const TargetEditFilled = ( /*#__PURE__*/createFluentIcon('TargetEditFilled', "1em", ["M10 11.5a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3ZM5 10a5 5 0 0 1 10-.05l-2.42 2.4a3.5 3.5 0 1 0-.23.23l-2.08 2.09c-.1.1-.2.21-.28.33A5 5 0 0 1 5 10Zm5-6.5c3.28 0 5.99 2.43 6.43 5.59.5-.13 1.02-.12 1.52.03A8 8 0 1 0 9 17.93c0-.09.02-.18.05-.28l.3-1.19A6.5 6.5 0 0 1 10 3.5Zm.98 11.88 4.83-4.83a1.87 1.87 0 1 1 2.64 2.64l-4.83 4.83a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.08l.37-1.5c.1-.38.3-.73.58-1.01Z"]));
export const TargetEditRegular = ( /*#__PURE__*/createFluentIcon('TargetEditRegular', "1em", ["M10 11.5a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3ZM5 10a5 5 0 0 1 10-.06l-1.15 1.15a4 4 0 1 0-2.76 2.76l-.82.82c-.1.1-.2.21-.29.33A5 5 0 0 1 5 10Zm5-7a7 7 0 0 1 6.93 6c.34-.02.69.02 1.02.12a8 8 0 1 0-8.94 8.82c0-.1.02-.2.05-.29l.17-.7A7 7 0 0 1 10 3Zm.98 12.38 4.83-4.83a1.87 1.87 0 0 1 2.64 2.64l-4.83 4.83a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.08l.37-1.5c.1-.38.3-.73.58-1.01Z"]));
export const TargetSparkleFilled = ( /*#__PURE__*/createFluentIcon('TargetSparkleFilled', "1em", ["M10 2c.4 0 .79.03 1.17.08l-.22.07A1.43 1.43 0 0 0 10 3.5a6.5 6.5 0 1 0 6.36 7.82c.1.18.23.33.4.45a1.33 1.33 0 0 0 .99.21A8 8 0 1 1 10 2Zm0 3c1 0 1.94.3 2.73.81l.06.15.36 1.1c.1.24.25.47.52.68.14.1.3.17.45.21a1.3 1.3 0 0 0 .77 1.79l.1.03V10a5 5 0 1 1-5-5Zm0 1.5a3.5 3.5 0 1 0 0 7 3.5 3.5 0 0 0 0-7Zm7.5 5.5ZM10 8.5a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM17.48 6a.3.3 0 0 1 .29.2l.25.77a1.58 1.58 0 0 0 1 1l.76.24h.02a.3.3 0 0 1 .14.47.3.3 0 0 1-.14.1l-.77.26a1.58 1.58 0 0 0-1 1l-.24.76a.3.3 0 0 1-.58 0l-.24-.77a1.57 1.57 0 0 0-1-1l-.77-.25a.3.3 0 0 1-.14-.46.3.3 0 0 1 .14-.1l.77-.26a1.58 1.58 0 0 0 .98-1l.25-.76a.3.3 0 0 1 .28-.2Zm-3-6a.42.42 0 0 1 .4.28l.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.64.2l-.02-.01a.43.43 0 0 1-.14-.2l-.35-1.06a2.22 2.22 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .4-.28Z"]));
export const TargetSparkleRegular = ( /*#__PURE__*/createFluentIcon('TargetSparkleRegular', "1em", ["M10 2c.4 0 .79.03 1.17.08l-.22.07a1.43 1.43 0 0 0-.86.85H10a7 7 0 1 0 6.77 8.78 1.32 1.32 0 0 0 .98.2A8 8 0 1 1 10 2Zm0 3c.89 0 1.72.23 2.44.64l.06.05c.11.12.2.27.3.52l.35 1.2c.04.12.1.24.16.35a4 4 0 1 0 .54 1.17c.05.11.11.22.2.33.18.22.43.38.74.48l.2.06.01.2a5 5 0 1 1-5-5Zm7.5 7ZM10 8.5a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM17.48 6a.3.3 0 0 1 .29.2l.25.77a1.58 1.58 0 0 0 1 1l.76.24h.02a.3.3 0 0 1 .14.47.3.3 0 0 1-.14.1l-.77.26a1.58 1.58 0 0 0-1 1l-.24.76a.3.3 0 0 1-.58 0l-.24-.77a1.57 1.57 0 0 0-1-1l-.77-.25a.3.3 0 0 1-.14-.46.3.3 0 0 1 .14-.1l.77-.26a1.58 1.58 0 0 0 .98-1l.25-.76a.3.3 0 0 1 .28-.2Zm-3-6a.42.42 0 0 1 .4.28l.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.64.2l-.02-.01a.43.43 0 0 1-.14-.2l-.35-1.06a2.22 2.22 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .4-.28Z"]));
export const TaskListAddFilled = ( /*#__PURE__*/createFluentIcon('TaskListAddFilled', "1em", ["M5.85 3.35a.5.5 0 1 0-.7-.7L3.5 4.29l-.65-.64a.5.5 0 1 0-.7.7l1 1c.2.2.5.2.7 0l2-2Zm2.9.15a.75.75 0 0 0 0 1.5h8.5a.75.75 0 0 0 0-1.5h-8.5Zm0 5a.75.75 0 0 0 0 1.5h8.5a.75.75 0 0 0 0-1.5h-8.5Zm1.27 6.5c.05-.52.17-1.03.35-1.5H8.75a.75.75 0 0 0 0 1.5h1.27ZM5.85 8.85a.5.5 0 1 0-.7-.7L3.5 9.79l-.65-.64a.5.5 0 1 0-.7.7l1 1c.2.2.5.2.7 0l2-2Zm0 4.3c.2.2.2.5 0 .7l-2 2a.5.5 0 0 1-.7 0l-1-1a.5.5 0 0 1 .7-.7l.65.64 1.65-1.64c.2-.2.5-.2.7 0ZM20 15.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V15h-1.5a.5.5 0 0 0 0 1H15v1.5a.5.5 0 0 0 1 0V16h1.5a.5.5 0 0 0 0-1H16v-1.5Z"]));
export const TaskListAddRegular = ( /*#__PURE__*/createFluentIcon('TaskListAddRegular', "1em", ["M5.85 3.35a.5.5 0 1 0-.7-.7L3.5 4.29l-.65-.64a.5.5 0 1 0-.7.7l1 1c.2.2.5.2.7 0l2-2ZM8.5 4a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9Zm0 5a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9Zm1.52 6c.03-.34.1-.68.19-1H8.5a.5.5 0 0 0 0 1h1.52ZM5.85 8.85a.5.5 0 1 0-.7-.7L3.5 9.79l-.65-.64a.5.5 0 1 0-.7.7l1 1c.2.2.5.2.7 0l2-2Zm0 4.3c.2.2.2.5 0 .7l-2 2a.5.5 0 0 1-.7 0l-1-1a.5.5 0 0 1 .7-.7l.65.64 1.65-1.64c.2-.2.5-.2.7 0ZM20 15.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V15h-1.5a.5.5 0 0 0 0 1H15v1.5a.5.5 0 0 0 1 0V16h1.5a.5.5 0 0 0 0-1H16v-1.5Z"]));
export const TaskListLtrFilled = ( /*#__PURE__*/createFluentIcon('TaskListLtrFilled', "1em", ["M5.85 4.35a.5.5 0 1 0-.7-.7L3.5 5.29l-.65-.64a.5.5 0 1 0-.7.7l1 1c.2.2.5.2.7 0l2-2Zm2.9.15a.75.75 0 0 0 0 1.5h8.5a.75.75 0 0 0 0-1.5h-8.5Zm0 5a.75.75 0 0 0 0 1.5h8.5a.75.75 0 0 0 0-1.5h-8.5ZM8 15.25c0-.41.34-.75.75-.75h8.5a.75.75 0 0 1 0 1.5h-8.5a.75.75 0 0 1-.75-.75Zm-2.15-5.4a.5.5 0 1 0-.7-.7L3.5 10.79l-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l2-2Zm0 4.3c.2.2.2.5 0 .7l-2 2a.5.5 0 0 1-.7 0l-1-1a.5.5 0 0 1 .7-.7l.65.64 1.65-1.64c.2-.2.5-.2.7 0Z"]));
export const TaskListLtrRegular = ( /*#__PURE__*/createFluentIcon('TaskListLtrRegular', "1em", ["M5.85 4.35a.5.5 0 1 0-.7-.7L3.5 5.29l-.65-.64a.5.5 0 1 0-.7.7l1 1c.2.2.5.2.7 0l2-2ZM8.5 5a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9Zm0 5a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9ZM8 15.5c0-.28.22-.5.5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5ZM5.85 9.85a.5.5 0 1 0-.7-.7L3.5 10.79l-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l2-2Zm0 4.3c.2.2.2.5 0 .7l-2 2a.5.5 0 0 1-.7 0l-1-1a.5.5 0 0 1 .7-.7l.65.64 1.65-1.64c.2-.2.5-.2.7 0Z"]));
export const TaskListRtlFilled = ( /*#__PURE__*/createFluentIcon('TaskListRtlFilled', "1em", ["M17.85 4.35a.5.5 0 0 0-.7-.7L15.5 5.29l-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l2-2Zm-15.1.15a.75.75 0 0 0 0 1.5h8.5a.75.75 0 0 0 0-1.5h-8.5Zm0 5a.75.75 0 0 0 0 1.5h8.5a.75.75 0 0 0 0-1.5h-8.5ZM2 15.25c0-.41.34-.75.75-.75h8.5a.75.75 0 0 1 0 1.5h-8.5a.75.75 0 0 1-.75-.75Zm13.85-3.4 2-2a.5.5 0 0 0-.7-.7l-1.65 1.64-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0Zm2 3-2 2a.5.5 0 0 1-.7 0l-1-1a.5.5 0 0 1 .7-.7l.65.64 1.65-1.64a.5.5 0 0 1 .7.7Z"]));
export const TaskListRtlRegular = ( /*#__PURE__*/createFluentIcon('TaskListRtlRegular', "1em", ["M17.85 4.35a.5.5 0 0 0-.7-.7L15.5 5.29l-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l2-2ZM2.5 5a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9Zm0 5a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9ZM2 15.5c0-.28.22-.5.5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5Zm15.85-5.65a.5.5 0 0 0-.7-.7l-1.65 1.64-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l2-2Zm0 4.3c.2.2.2.5 0 .7l-2 2a.5.5 0 0 1-.7 0l-1-1a.5.5 0 0 1 .7-.7l.65.64 1.65-1.64c.2-.2.5-.2.7 0Z"]));
export const TaskListSquareAddFilled = ( /*#__PURE__*/createFluentIcon('TaskListSquareAddFilled', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v3.6A5.5 5.5 0 0 0 9.6 17H6a3 3 0 0 1-3-3V6Zm6.35.4a.5.5 0 0 0-.7 0L7.23 7.8l-.4-.35a.5.5 0 0 0-.67.73l.75.69c.2.18.5.17.7-.02L9.34 7.1a.5.5 0 0 0 0-.7Zm0 5.7a.5.5 0 0 0-.7-.7l-1.42 1.4-.4-.35a.5.5 0 0 0-.67.73l.75.69c.2.18.5.17.7-.02l1.74-1.75ZM11 7a.5.5 0 0 0 0 1h2.5a.5.5 0 0 0 0-1H11Zm8 7.5a4.5 4.5 0 1 0-9 0 4.5 4.5 0 0 0 9 0Zm-4-2V14h1.5a.5.5 0 0 1 0 1H15v1.5a.5.5 0 0 1-1 0V15h-1.5a.5.5 0 0 1 0-1H14v-1.5a.5.5 0 0 1 1 0Z"]));
export const TaskListSquareAddRegular = ( /*#__PURE__*/createFluentIcon('TaskListSquareAddRegular', "1em", ["M6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h3.6c-.16-.32-.3-.65-.4-1H6a2 2 0 0 1-2-2V6c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v3.2c.35.1.68.24 1 .4V6a3 3 0 0 0-3-3H6Zm3.35 4.1a.5.5 0 0 0-.7-.7L7.23 7.8l-.4-.35a.5.5 0 0 0-.67.73l.75.69c.2.18.5.17.7-.02L9.34 7.1Zm0 4.3c.2.2.2.5 0 .7L7.6 13.85a.5.5 0 0 1-.69.02l-.75-.69a.5.5 0 0 1 .68-.73l.4.36 1.4-1.41c.2-.2.52-.2.71 0Zm1.15-3.9c0-.28.22-.5.5-.5h2.5a.5.5 0 0 1 0 1H11a.5.5 0 0 1-.5-.5Zm8.5 7a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const TaskListSquareDatabaseFilled = ( /*#__PURE__*/createFluentIcon('TaskListSquareDatabaseFilled', "1em", ["M6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h3.05a2.46 2.46 0 0 1-.05-.5v-4.04l-1.4 1.4a.5.5 0 0 1-.69 0l-.75-.68a.5.5 0 0 1 .68-.73l.4.36 1.4-1.41a.5.5 0 0 1 .36-.15v-.75c0-1.22.88-2.11 1.83-2.64A7.68 7.68 0 0 1 14.5 7c.89 0 1.74.13 2.5.36V6a3 3 0 0 0-3-3H6Zm11 5.42A7.25 7.25 0 0 0 14.5 8C12.01 8 10 9.12 10 10.5s2.02 2.5 4.5 2.5c2.49 0 4.5-1.12 4.5-2.5 0-.87-.8-1.63-2-2.08ZM9.35 6.4c.2.2.2.5 0 .7L7.6 8.85a.5.5 0 0 1-.69.02l-.75-.69a.5.5 0 1 1 .68-.73l.4.36 1.4-1.41c.2-.2.52-.2.71 0ZM14.5 14c1.38 0 2.68-.3 3.67-.86.29-.16.58-.36.83-.59v3.95c0 1.38-2.01 2.5-4.5 2.5S10 17.88 10 16.5v-3.95c.25.23.54.43.83.6 1 .54 2.29.85 3.67.85Z"]));
export const TaskListSquareDatabaseRegular = ( /*#__PURE__*/createFluentIcon('TaskListSquareDatabaseRegular', "1em", ["M6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h3.05a2.46 2.46 0 0 1-.05-.5V16H6a2 2 0 0 1-2-2V6c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v1.13c.35.06.68.14 1 .23V6a3 3 0 0 0-3-3H6Zm11 5.42A7.81 7.81 0 0 0 14.5 8C12.01 8 10 9.12 10 10.5s2.01 2.5 4.5 2.5 4.5-1.12 4.5-2.5c0-.87-.8-1.63-2-2.08Zm-8 2.83a.5.5 0 0 0-.35.15l-1.42 1.4-.4-.35a.5.5 0 0 0-.67.73l.75.69c.2.18.5.17.7-.02L9 12.45v-1.2Zm.35-4.15a.5.5 0 0 0-.7-.7L7.23 7.8l-.4-.35a.5.5 0 0 0-.67.73l.75.69c.2.18.5.17.7-.02L9.34 7.1ZM14.5 14c1.38 0 2.68-.3 3.67-.86.29-.16.58-.36.83-.59v3.95c0 1.38-2.01 2.5-4.5 2.5S10 17.88 10 16.5v-3.95c.25.23.54.43.83.6 1 .54 2.29.85 3.67.85Z"]));
export const TaskListSquareLtrFilled = ( /*#__PURE__*/createFluentIcon('TaskListSquareLtrFilled', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6Zm6.35 1.1a.5.5 0 0 0-.7-.7L7.23 7.8l-.4-.35a.5.5 0 0 0-.67.73l.75.69c.2.18.5.17.7-.02L9.34 7.1Zm0 4.3a.5.5 0 0 0-.7 0l-1.42 1.4-.4-.35a.5.5 0 0 0-.67.73l.75.69c.2.18.5.17.7-.02l1.74-1.75a.5.5 0 0 0 0-.7ZM11 12a.5.5 0 0 0 0 1h2.5a.5.5 0 0 0 0-1H11Zm-.5-4.5c0 .28.22.5.5.5h2.5a.5.5 0 0 0 0-1H11a.5.5 0 0 0-.5.5Z"]));
export const TaskListSquareLtrRegular = ( /*#__PURE__*/createFluentIcon('TaskListSquareLtrRegular', "1em", ["M9.35 7.1a.5.5 0 0 0-.7-.7L7.23 7.8l-.4-.35a.5.5 0 0 0-.67.73l.75.69c.2.18.5.17.7-.02L9.34 7.1Zm0 4.3c.2.2.2.5 0 .7L7.6 13.85a.5.5 0 0 1-.69.02l-.75-.69a.5.5 0 0 1 .68-.73l.4.36 1.4-1.41c.2-.2.52-.2.71 0ZM11 12a.5.5 0 0 0 0 1h2.5a.5.5 0 0 0 0-1H11Zm-.5-4.5c0-.28.22-.5.5-.5h2.5a.5.5 0 0 1 0 1H11a.5.5 0 0 1-.5-.5ZM6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6ZM4 6c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V6Z"]));
export const TaskListSquarePersonFilled = ( /*#__PURE__*/createFluentIcon('TaskListSquarePersonFilled', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v3.4a3 3 0 0 0-4.5 2.6H11a.5.5 0 0 0 0 1h1.67a3 3 0 0 0 .6 1.01A2.5 2.5 0 0 0 11.04 17H6a3 3 0 0 1-3-3V6Zm6.35 1.1a.5.5 0 0 0-.7-.7L7.23 7.8l-.4-.35a.5.5 0 0 0-.67.73l.75.69c.2.18.5.17.7-.02L9.34 7.1Zm0 4.3a.5.5 0 0 0-.7 0l-1.42 1.4-.4-.35a.5.5 0 0 0-.67.73l.75.69c.2.18.5.17.7-.02l1.74-1.75a.5.5 0 0 0 0-.7Zm1.15-3.9c0 .28.22.5.5.5h2.5a.5.5 0 0 0 0-1H11a.5.5 0 0 0-.5.5Zm7 4.5a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm1.5 4.5c0 1.25-1 2.5-3.5 2.5S12 17.75 12 16.5c0-.83.67-1.5 1.5-1.5h4c.83 0 1.5.67 1.5 1.5Z"]));
export const TaskListSquarePersonRegular = ( /*#__PURE__*/createFluentIcon('TaskListSquarePersonRegular', "1em", ["M9.35 7.1a.5.5 0 0 0-.7-.7L7.23 7.8l-.4-.35a.5.5 0 0 0-.67.73l.75.69c.2.18.5.17.7-.02L9.34 7.1Zm0 4.3c.2.2.2.5 0 .7L7.6 13.85a.5.5 0 0 1-.69.02l-.75-.69a.5.5 0 0 1 .68-.73l.4.36 1.4-1.41c.2-.2.52-.2.71 0ZM11 12a.5.5 0 0 0 0 1h1.67a3 3 0 0 1-.17-1H11Zm-5 4h5.05a2.51 2.51 0 0 0-.01 1H6a3 3 0 0 1-3-3V6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v3.4c-.3-.17-.64-.3-1-.36V6a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2Zm4.5-8.5c0-.28.22-.5.5-.5h2.5a.5.5 0 0 1 0 1H11a.5.5 0 0 1-.5-.5Zm7 4.5a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm1.5 4.5c0 1.25-1 2.5-3.5 2.5S12 17.75 12 16.5c0-.83.67-1.5 1.5-1.5h4c.83 0 1.5.67 1.5 1.5Z"]));
export const TaskListSquareRtlFilled = ( /*#__PURE__*/createFluentIcon('TaskListSquareRtlFilled', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6Zm11.35 1.1a.5.5 0 1 0-.7-.7l-1.42 1.4-.4-.35a.5.5 0 0 0-.67.73l.75.69c.2.18.5.17.7-.02l1.74-1.75Zm0 4.3a.5.5 0 0 0-.7 0l-1.42 1.4-.4-.35a.5.5 0 0 0-.67.73l.75.69c.2.18.5.17.7-.02l1.74-1.75a.5.5 0 0 0 0-.7ZM6.5 12a.5.5 0 0 0 0 1H9a.5.5 0 0 0 0-1H6.5ZM6 7.5c0 .28.22.5.5.5H9a.5.5 0 0 0 0-1H6.5a.5.5 0 0 0-.5.5Z"]));
export const TaskListSquareRtlRegular = ( /*#__PURE__*/createFluentIcon('TaskListSquareRtlRegular', "1em", ["M14.35 7.1a.5.5 0 1 0-.7-.7l-1.42 1.4-.4-.35a.5.5 0 0 0-.67.73l.75.69c.2.18.5.17.7-.02l1.74-1.75Zm0 4.3c.2.2.2.5 0 .7l-1.75 1.75a.5.5 0 0 1-.69.02l-.75-.69a.5.5 0 0 1 .68-.73l.4.36 1.4-1.41c.2-.2.52-.2.71 0ZM6.5 12a.5.5 0 0 0 0 1H9a.5.5 0 0 0 0-1H6.5ZM6 7.5c0-.28.22-.5.5-.5H9a.5.5 0 0 1 0 1H6.5a.5.5 0 0 1-.5-.5ZM6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6ZM4 6c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V6Z"]));
export const TaskListSquareSettingsFilled = ( /*#__PURE__*/createFluentIcon('TaskListSquareSettingsFilled', "1em", ["M6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h3.6A5.5 5.5 0 0 1 17 9.6V6a3 3 0 0 0-3-3H6Zm3.35 3.4c.2.2.2.5 0 .7L7.6 8.85a.5.5 0 0 1-.69.02l-.75-.69a.5.5 0 1 1 .68-.73l.4.36 1.4-1.41c.2-.2.52-.2.71 0Zm-.7 5a.5.5 0 0 1 .7.7L7.6 13.85a.5.5 0 0 1-.69.02l-.75-.69a.5.5 0 0 1 .68-.73l.4.36 1.4-1.41ZM11 8a.5.5 0 0 1 0-1h2.5a.5.5 0 0 1 0 1H11Zm-.37 5.92a2 2 0 0 0 1.43-2.48l-.15-.56c.25-.2.53-.36.82-.5l.34.36a2 2 0 0 0 2.9 0l.33-.34c.3.14.58.31.83.52l-.12.42a2 2 0 0 0 1.45 2.52l.35.08a4.6 4.6 0 0 1 .01 1.02l-.46.12a2 2 0 0 0-1.43 2.47l.16.56c-.26.2-.53.36-.82.5l-.34-.36a2 2 0 0 0-2.91 0l-.32.35c-.3-.14-.58-.31-.84-.52l.13-.42a2 2 0 0 0-1.46-2.52l-.34-.08a4.62 4.62 0 0 1-.01-1.02l.45-.12Zm4.87.58a1 1 0 1 0-2 0 1 1 0 0 0 2 0Z"]));
export const TaskListSquareSettingsRegular = ( /*#__PURE__*/createFluentIcon('TaskListSquareSettingsRegular', "1em", ["M9.35 6.4c.2.2.2.5 0 .7L7.6 8.85a.5.5 0 0 1-.69.02l-.75-.69a.5.5 0 1 1 .68-.73l.4.36 1.4-1.41c.2-.2.52-.2.71 0Zm0 5.7a.5.5 0 0 0-.7-.7l-1.42 1.4-.4-.35a.5.5 0 0 0-.67.73l.75.69c.2.18.5.17.7-.02l1.74-1.75ZM11 7a.5.5 0 0 0 0 1h2.5a.5.5 0 0 0 0-1H11ZM3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v3.6a5.5 5.5 0 0 0-1-.4V6a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h3.2c.1.35.24.68.4 1H6a3 3 0 0 1-3-3V6Zm7.63 7.92a2 2 0 0 0 1.43-2.48l-.15-.56c.25-.2.53-.36.82-.5l.34.36a2 2 0 0 0 2.9 0l.33-.34c.3.14.58.31.83.52l-.12.42a2 2 0 0 0 1.45 2.52l.35.08a4.6 4.6 0 0 1 .01 1.02l-.46.12a2 2 0 0 0-1.43 2.47l.16.56c-.26.2-.53.36-.82.5l-.34-.36a2 2 0 0 0-2.91 0l-.32.35c-.3-.14-.58-.31-.84-.52l.13-.42a2 2 0 0 0-1.46-2.52l-.34-.08a4.62 4.62 0 0 1-.01-1.02l.45-.12Zm4.87.58a1 1 0 1 0-2 0 1 1 0 0 0 2 0Z"]));
export const TaskListSquareSparkleFilled = ( /*#__PURE__*/createFluentIcon('TaskListSquareSparkleFilled', "1em", ["M9.09 3a1.42 1.42 0 0 0 .17 1.32c.17.24.41.43.71.53l1.06.35c.15.05.3.13.47.29.11.1.2.24.3.47L12.13 7H11a.5.5 0 0 0 0 1h2.1a1.3 1.3 0 0 0 .14 1.26c.16.22.38.38.65.48l.77.25c.08.03.15.08.21.14.08.06.12.14.15.22l.26.8c.1.25.26.46.48.62.21.15.47.23.74.23.17 0 .34-.02.5-.08V14a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6a3 3 0 0 1 3-3h3.09Zm.26 8.4a.5.5 0 0 0-.7 0l-1.42 1.4-.4-.35a.5.5 0 0 0-.67.73l.75.69c.2.18.5.17.7-.02l1.74-1.75a.5.5 0 0 0 0-.7ZM11 12a.5.5 0 0 0 0 1h2.5a.5.5 0 0 0 0-1H11Zm5.5 0Zm-.02-6a.3.3 0 0 1 .29.2l.25.77a1.58 1.58 0 0 0 1 1l.76.24h.02a.3.3 0 0 1 .14.47.3.3 0 0 1-.14.1l-.77.26a1.58 1.58 0 0 0-1 1l-.24.76a.3.3 0 0 1-.58 0l-.24-.77a1.57 1.57 0 0 0-1-1l-.77-.25a.3.3 0 0 1-.14-.46.3.3 0 0 1 .14-.1l.77-.26a1.58 1.58 0 0 0 .98-1l.25-.76a.3.3 0 0 1 .28-.2Zm-7.13.4a.5.5 0 0 0-.7 0L7.23 7.8l-.4-.35a.5.5 0 0 0-.67.73l.75.69c.2.18.5.17.7-.02L9.34 7.1a.5.5 0 0 0 0-.7ZM13.48 0a.42.42 0 0 1 .4.28l.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.64.2l-.02-.01a.43.43 0 0 1-.14-.2l-.35-1.06a2.22 2.22 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .4-.28Z"]));
export const TaskListSquareSparkleRegular = ( /*#__PURE__*/createFluentIcon('TaskListSquareSparkleRegular', "1em", ["M9.09 3a1.42 1.42 0 0 0 0 1H6a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2v-2.1a1.45 1.45 0 0 0 1 .02V14a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6a3 3 0 0 1 3-3h3.09Zm-.44 8.4a.5.5 0 1 1 .7.7L7.6 13.85a.5.5 0 0 1-.69.02l-.75-.69a.5.5 0 0 1 .68-.73l.4.36 1.4-1.41Zm4.85.6a.5.5 0 0 1 0 1H11a.5.5 0 0 1 0-1h2.5Zm3 0Zm-.02-6a.3.3 0 0 1 .29.2l.25.77a1.58 1.58 0 0 0 1 1l.76.24h.02a.3.3 0 0 1 .14.47.3.3 0 0 1-.14.1l-.77.26a1.58 1.58 0 0 0-1 1l-.24.76a.3.3 0 0 1-.58 0l-.24-.77a1.57 1.57 0 0 0-1-1l-.77-.25a.3.3 0 0 1-.14-.46.3.3 0 0 1 .14-.1l.77-.26a1.58 1.58 0 0 0 .98-1l.25-.76a.3.3 0 0 1 .28-.2Zm-7.83.4a.5.5 0 1 1 .7.7L7.6 8.85a.5.5 0 0 1-.69.02l-.75-.69a.5.5 0 0 1 .68-.73l.4.36 1.4-1.41Zm3.5.65c.1.25.25.48.52.7.14.1.3.16.45.2l-.01.05H11a.5.5 0 0 1 0-1h1.14l.01.05ZM13.48 0a.42.42 0 0 1 .4.28l.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.64.2l-.02-.01a.43.43 0 0 1-.14-.2l-.35-1.06a2.22 2.22 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .4-.28Z"]));
export const TasksAppFilled = ( /*#__PURE__*/createFluentIcon('TasksAppFilled', "1em", ["M4 4c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v9.88l-2.5 2.52-.93-.95a1.5 1.5 0 1 0-2.14 2.1l.44.45H6a2 2 0 0 1-2-2V4Zm5 5.5c0 .28.22.5.5.5h4a.5.5 0 0 0 0-1h-4a.5.5 0 0 0-.5.5ZM9.5 5a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4ZM9 13.5c0 .28.22.5.5.5h4a.5.5 0 0 0 0-1h-4a.5.5 0 0 0-.5.5Zm-2-3a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm1-5a1 1 0 1 0-2 0 1 1 0 0 0 2 0Zm-1 9a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm10.86.35a.5.5 0 0 0-.72-.7l-3.64 3.68-1.64-1.68a.5.5 0 1 0-.72.7l1.93 1.97a.6.6 0 0 0 .86 0l3.93-3.97Z"]));
export const TasksAppRegular = ( /*#__PURE__*/createFluentIcon('TasksAppRegular', "1em", ["M4 4c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v9.88l-1 1.01V4a1 1 0 0 0-1-1H6a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h4.09c.07.2.18.39.34.55l.44.45H6a2 2 0 0 1-2-2V4Zm4 1.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0ZM9.5 5a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Zm0 4a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4ZM9 13.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm-2-3a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm0 4a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm10.86.35a.5.5 0 0 0-.72-.7l-3.64 3.68-1.64-1.68a.5.5 0 1 0-.72.7l1.93 1.97a.6.6 0 0 0 .86 0l3.93-3.97Z"]));
export const TeachingFilled = ( /*#__PURE__*/createFluentIcon('TeachingFilled', "1em", ["M5 2a2 2 0 0 0-2 2v1h-.5a.5.5 0 0 0 0 1H3v3h-.5a.5.5 0 0 0 0 1H3v3h-.5a.5.5 0 0 0 0 1H3v1c0 1.1.9 2 2 2h3.04a9.73 9.73 0 0 1-.46-1H5a1 1 0 0 1-1-1v-1h.5a.5.5 0 0 0 0-1H4v-3h.5a.5.5 0 0 0 0-1H4V6h.5a.5.5 0 0 0 0-1H4V4a1 1 0 0 1 1-1h7a1 1 0 0 1 1 1v1.73c.18.12.34.25.5.39.16-.16.32-.3.5-.44V4a2 2 0 0 0-2-2H5Zm10.95 4.28a.5.5 0 0 0-.67-.23c-.75.38-1.35.96-1.75 1.66A3.45 3.45 0 0 0 10.55 6h-.34a.7.7 0 0 0-.71.7v.35c0 1 .42 1.89 1.1 2.52-1.28.28-2.6 1.45-2.6 3.5 0 2.46 1.45 4.44 2.19 5.3.37.43.91.63 1.44.63h.05c.57 0 1.1-.24 1.5-.67l.08-.1a.72.72 0 0 1 .1-.09c.08-.06.2-.06.28 0l.1.1.09.1c.38.42.92.66 1.5.66h.04c.53 0 1.07-.2 1.44-.64.74-.85 2.19-2.83 2.19-5.28 0-2.39-1.78-3.58-3.2-3.58a4.03 4.03 0 0 0-1.8.4v-.16c0-1.18.67-2.26 1.72-2.8a.5.5 0 0 0 .23-.66Zm-5.45.77V7h.05C11.9 7 13 8.1 13 9.45c0 .03-.02.05-.05.05a2.45 2.45 0 0 1-2.45-2.45Zm1.2 4.73a.5.5 0 0 1-.23.67c-.4.2-.62.63-.54 1.07l.06.4a.5.5 0 1 1-.98.16l-.07-.4c-.14-.87.3-1.73 1.09-2.13a.5.5 0 0 1 .67.23Z"]));
export const TeachingRegular = ( /*#__PURE__*/createFluentIcon('TeachingRegular', "1em", ["M5 2a2 2 0 0 0-2 2v1h-.5a.5.5 0 0 0 0 1H3v3h-.5a.5.5 0 0 0 0 1H3v3h-.5a.5.5 0 0 0 0 1H3v1c0 1.1.9 2 2 2h3.04a9.73 9.73 0 0 1-.46-1H5a1 1 0 0 1-1-1v-1h.5a.5.5 0 0 0 0-1H4v-3h.5a.5.5 0 0 0 0-1H4V6h.5a.5.5 0 0 0 0-1H4V4a1 1 0 0 1 1-1h7a1 1 0 0 1 1 1v1.73c.18.12.34.25.5.39.16-.16.32-.3.5-.44V4a2 2 0 0 0-2-2H5Zm6.7 9.78a.5.5 0 0 0-.67-.23c-.8.4-1.23 1.26-1.09 2.13l.07.4a.5.5 0 1 0 .98-.16l-.06-.4c-.08-.44.15-.87.54-1.07a.5.5 0 0 0 .23-.67Zm3.58-5.73a.5.5 0 1 1 .44.9A3.12 3.12 0 0 0 14 9.74v.16l.25-.1c.36-.15.89-.3 1.56-.3 1.4 0 3.19 1.2 3.19 3.58 0 2.45-1.45 4.43-2.19 5.28a1.9 1.9 0 0 1-1.44.64h-.05c-.57 0-1.1-.24-1.5-.67l-.08-.1a.72.72 0 0 0-.1-.09.24.24 0 0 0-.28 0 .72.72 0 0 0-.1.1l-.09.1c-.38.42-.92.66-1.5.66h-.04a1.9 1.9 0 0 1-1.44-.64C9.45 17.51 8 15.53 8 13.08c0-2.06 1.32-3.23 2.6-3.51a3.44 3.44 0 0 1-1.1-2.52v-.34c0-.4.32-.71.7-.71h.35c1.27 0 2.38.69 2.98 1.71.4-.7 1-1.28 1.75-1.66ZM10.5 7v.05c0 1.35 1.1 2.45 2.45 2.45.03 0 .05-.02.05-.05C13 8.1 11.9 7 10.55 7h-.05Zm.7 3.5c-.9 0-2.2.78-2.2 2.58 0 2.08 1.25 3.83 1.95 4.63.15.18.4.29.68.29h.05c.28 0 .56-.12.75-.33l.09-.1c.07-.09.15-.16.24-.22a1.24 1.24 0 0 1 1.48 0c.09.06.17.13.24.22l.1.1c.18.2.46.33.74.33h.05a.9.9 0 0 0 .68-.29c.7-.8 1.95-2.55 1.95-4.63 0-1.8-1.3-2.58-2.2-2.58-.51 0-.9.11-1.16.22-.31.13-.7.28-1.14.28-.43 0-.83-.15-1.14-.28-.25-.1-.65-.22-1.17-.22Z"]));
export const TeardropBottomRightFilled = ( /*#__PURE__*/createFluentIcon('TeardropBottomRightFilled', "1em", ["M2 10a8 8 0 1 1 16 0v6a2 2 0 0 1-2 2h-6a8 8 0 0 1-8-8Z"]));
export const TeardropBottomRightRegular = ( /*#__PURE__*/createFluentIcon('TeardropBottomRightRegular', "1em", ["M2 10a8 8 0 1 1 16 0v6a2 2 0 0 1-2 2h-6a8 8 0 0 1-8-8Zm8-7a7 7 0 0 0 0 14h6a1 1 0 0 0 1-1v-6a7 7 0 0 0-7-7Z"]));
export const TeddyFilled = ( /*#__PURE__*/createFluentIcon('TeddyFilled', "1em", ["M5.5 3a3.5 3.5 0 0 0-2.85 5.53 7.92 7.92 0 0 1 5.5-4.32A3.5 3.5 0 0 0 5.5 3ZM18 6.5c0 .76-.24 1.46-.65 2.03a7.92 7.92 0 0 0-5.5-4.32A3.5 3.5 0 0 1 18 6.5Zm-15 5C3 7.87 6.17 5 10 5s7 2.87 7 6.5a6.2 6.2 0 0 1-1.76 4.31 5.5 5.5 0 0 0-10.48 0A6.2 6.2 0 0 1 3 11.5Zm8.33 1.7a4.5 4.5 0 0 1 3.07 3.35A7.33 7.33 0 0 1 10 18c-1.66 0-3.2-.54-4.4-1.45a4.5 4.5 0 0 1 3.07-3.35 1.5 1.5 0 0 0 2.66 0Z"]));
export const TeddyRegular = ( /*#__PURE__*/createFluentIcon('TeddyRegular', "1em", ["M2 6.5a3.5 3.5 0 0 0 1.4 2.8c-.26.69-.4 1.43-.4 2.2 0 3.63 3.17 6.5 7 6.5s7-2.87 7-6.5c0-.77-.14-1.51-.4-2.2a3.5 3.5 0 1 0-5.31-4.19 7.54 7.54 0 0 0-2.58 0A3.5 3.5 0 0 0 2 6.5ZM5.5 4c.97 0 1.8.55 2.22 1.35a6.92 6.92 0 0 0-3.87 3.03A2.5 2.5 0 0 1 5.5 4Zm6.78 1.35a2.5 2.5 0 1 1 3.87 3.03 6.92 6.92 0 0 0-3.87-3.03ZM10 6c3.35 0 6 2.5 6 5.5a5.2 5.2 0 0 1-1.2 3.3 5.5 5.5 0 0 0-9.6 0A5.2 5.2 0 0 1 4 11.5C4 8.5 6.65 6 10 6Zm4.06 9.55A6.27 6.27 0 0 1 10 17c-1.57 0-3-.55-4.06-1.45a4.51 4.51 0 0 1 2.73-2.35 1.5 1.5 0 0 0 2.66 0c1.2.37 2.19 1.23 2.73 2.35Z"]));
export const TemperatureFilled = ( /*#__PURE__*/createFluentIcon('TemperatureFilled', "1em", ["M10.75 7.25a.75.75 0 0 0-1.5 0v4.9a2 2 0 1 0 1.5 0v-4.9ZM6.5 5.5a3.5 3.5 0 0 1 7 0v5.67A4.48 4.48 0 0 1 10 18.5a4.5 4.5 0 0 1-3.5-7.33V5.5Zm1.5 0v6.24l-.2.22a3 3 0 1 0 4.4 0l-.2-.22V5.5a2 2 0 0 0-4 0Z"]));
export const TemperatureRegular = ( /*#__PURE__*/createFluentIcon('TemperatureRegular', "1em", ["M10 6.5c.28 0 .5.22.5.5v5.06a2 2 0 1 1-1 0V7c0-.28.22-.5.5-.5ZM10 2a3 3 0 0 0-3 3v6.35A3.99 3.99 0 0 0 10 18a4 4 0 0 0 3-6.65V5a3 3 0 0 0-3-3Zm0 1a2 2 0 0 1 2 2v6.75l.14.15a3 3 0 1 1-4.29 0l.15-.15V5c0-1.1.9-2 2-2Z"]));
export const TemperatureDegreeCelsiusFilled = ( /*#__PURE__*/createFluentIcon('TemperatureDegreeCelsiusFilled', "1em", ["M3 7a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0Zm1.5-3a3 3 0 1 0 0 6 3 3 0 0 0 0-6Zm6.18 2.64A4.7 4.7 0 0 0 9.5 10c0 1.5.48 2.62 1.18 3.36.7.73 1.7 1.14 2.82 1.14a3.83 3.83 0 0 0 3.18-1.59.91.91 0 0 1 .74-.41c.56 0 .94.56.65 1.04A5.27 5.27 0 0 1 13.5 16c-1.5 0-2.89-.55-3.9-1.6A6.2 6.2 0 0 1 8 10a6.2 6.2 0 0 1 1.6-4.4A5.33 5.33 0 0 1 13.5 4a5.33 5.33 0 0 1 4.57 2.46c.3.48-.1 1.04-.65 1.04a.91.91 0 0 1-.74-.41A3.73 3.73 0 0 0 13.5 5.5c-1.13 0-2.11.4-2.82 1.14Z"]));
export const TemperatureDegreeCelsiusRegular = ( /*#__PURE__*/createFluentIcon('TemperatureDegreeCelsiusRegular', "1em", ["M3 6.5a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0ZM4.5 4a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5Zm5.51 2.28A5.38 5.38 0 0 0 8.75 10c0 1.65.5 2.9 1.26 3.72A3.97 3.97 0 0 0 13 15a3.97 3.97 0 0 0 3.63-2.2c.1-.18.28-.3.49-.3.35 0 .6.35.44.68A4.97 4.97 0 0 1 13 16a4.97 4.97 0 0 1-3.73-1.6A6.37 6.37 0 0 1 7.75 10c0-1.85.56-3.35 1.52-4.4A4.97 4.97 0 0 1 13 4a4.97 4.97 0 0 1 4.56 2.82c.16.33-.09.68-.44.68-.21 0-.4-.12-.5-.3A3.97 3.97 0 0 0 13 5c-1.17 0-2.22.45-2.98 1.28Z"]));
export const TemperatureDegreeFahrenheitFilled = ( /*#__PURE__*/createFluentIcon('TemperatureDegreeFahrenheitFilled', "1em", ["M3.5 7a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0ZM5 4a3 3 0 1 0 0 6 3 3 0 0 0 0-6Zm5.75 0a.75.75 0 0 0-.75.75v10.5a.75.75 0 0 0 1.5 0V10.5h4.75a.75.75 0 0 0 0-1.5H11.5V5.5h5.25a.75.75 0 0 0 0-1.5h-6Z"]));
export const TemperatureDegreeFahrenheitRegular = ( /*#__PURE__*/createFluentIcon('TemperatureDegreeFahrenheitRegular', "1em", ["M4 6.5a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0ZM5.5 4a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5Zm5 0a.5.5 0 0 0-.5.5v11a.5.5 0 0 0 1 0V10h5a.5.5 0 0 0 0-1h-5V5h5.5a.5.5 0 0 0 0-1h-6Z"]));
export const TentFilled = ( /*#__PURE__*/createFluentIcon('TentFilled', "1em", ["M10.4 2.82a.5.5 0 0 0-.77 0 20.89 20.89 0 0 1-4.91 3.9.5.5 0 0 0-.25.36L3.37 15H2.5a.5.5 0 0 0 0 1h3.94a.5.5 0 0 0 .1.01h6.9a.5.5 0 0 0 .1-.01h3.96a.5.5 0 0 0 0-1h-.84l-1.1-7.92a.5.5 0 0 0-.24-.36 20.89 20.89 0 0 1-4.92-3.9ZM7.51 15c.84-1.22 1.7-2.79 2.49-5.26.7 2.23 1.5 3.78 2.49 5.26H7.5Z"]));
export const TentRegular = ( /*#__PURE__*/createFluentIcon('TentRegular', "1em", ["M10.4 2.82a.5.5 0 0 0-.77 0 20.89 20.89 0 0 1-4.91 3.9.5.5 0 0 0-.25.36L3.37 15H2.5a.5.5 0 0 0 0 1h3.94a.5.5 0 0 0 .1.01h6.9a.5.5 0 0 0 .1-.01h3.96a.5.5 0 0 0 0-1h-.84l-1.1-7.92a.5.5 0 0 0-.24-.36 20.89 20.89 0 0 1-4.92-3.9ZM13.7 15a19.92 19.92 0 0 1-3.22-7.2.5.5 0 0 0-.97 0c-.98 3.84-2.14 5.75-3.22 7.2H4.4l1.03-7.54c1.3-.76 3.3-2.2 4.6-3.57a23.15 23.15 0 0 0 4.6 3.57L15.64 15h-1.96Zm-1.22 0H7.52c.84-1.22 1.7-2.78 2.48-5.25.7 2.23 1.49 3.77 2.48 5.25Z"]));
export const TetrisAppFilled = ( /*#__PURE__*/createFluentIcon('TetrisAppFilled', "1em", ["M7 2.75c0-.41.34-.75.75-.75H11v4H7V2.75ZM2.75 7a.75.75 0 0 0-.75.75v2.5c0 .41.34.75.75.75H6V7H2.75ZM11 7H7v4h3.25c.41 0 .75-.34.75-.75V7Zm4.25-5H12v4h3.25c.41 0 .75-.34.75-.75v-2.5a.75.75 0 0 0-.75-.75ZM4 14.75c0-.41.34-.75.75-.75H8v4H4.75a.75.75 0 0 1-.75-.75v-2.5ZM13 18v-4H9v4h4Zm5-4v3.25c0 .41-.34.75-.75.75H14v-4h4Zm-3.25-5a.75.75 0 0 0-.75.75V13h4V9.75a.75.75 0 0 0-.75-.75h-2.5Z"]));
export const TetrisAppRegular = ( /*#__PURE__*/createFluentIcon('TetrisAppRegular', "1em", ["M7.25 2C6.56 2 6 2.56 6 3.25v2.5c0 .14-.11.25-.25.25h-2.5C2.56 6 2 6.56 2 7.25v2.5c0 .69.56 1.25 1.25 1.25h6.5c.69 0 1.25-.56 1.25-1.25v-2.5c0-.14.11-.25.25-.25h2.5C14.44 7 15 6.44 15 5.75v-2.5C15 2.56 14.44 2 13.75 2h-6.5Zm6.5 4H11V3h2.75c.14 0 .25.11.25.25v2.5c0 .14-.11.25-.25.25Zm-3.72 1c-.02.08-.03.16-.03.25v2.5c0 .14-.11.25-.25.25H7V7h3.03ZM6 7v3H3.25A.25.25 0 0 1 3 9.75v-2.5c0-.14.11-.25.25-.25H6Zm.97-1C7 5.92 7 5.84 7 5.75v-2.5c0-.14.11-.25.25-.25H10v3H6.97Zm7.28 3c-.69 0-1.25.56-1.25 1.25v2.5c0 .14-.11.25-.25.25h-6.5C5.56 13 5 13.56 5 14.25v2.5c0 .69.56 1.25 1.25 1.25h10.5c.69 0 1.25-.56 1.25-1.25v-6.5C18 9.56 17.44 9 16.75 9h-2.5Zm-.28 4c.02-.08.03-.16.03-.25v-2.5c0-.14.11-.25.25-.25h2.5c.14 0 .25.11.25.25V13h-3.03Zm.03 1h3v2.75c0 .14-.11.25-.25.25H14v-3Zm-1 0v3h-3v-3h3Zm-4 0v3H6.25a.25.25 0 0 1-.25-.25v-2.5c0-.14.11-.25.25-.25H9Z"]));
export const TextAddFilled = ( /*#__PURE__*/createFluentIcon('TextAddFilled', "1em", ["M3 3.75c0-.41.34-.75.75-.75h10c.41 0 .75.34.75.75v1.5a.75.75 0 0 1-1.5 0V4.5H9.5v7.7a5.48 5.48 0 0 0 .1 4.8H6.75a.75.75 0 0 1 0-1.5H8v-11H4.5v.75a.75.75 0 0 1-1.5 0v-1.5ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const TextAddRegular = ( /*#__PURE__*/createFluentIcon('TextAddRegular', "1em", ["M3 3.5c0-.28.22-.5.5-.5h10c.28 0 .5.22.5.5v2a.5.5 0 0 1-1 0V4H9v12h.2c.1.35.24.68.4 1H6.5a.5.5 0 0 1 0-1H8V4H4v1.5a.5.5 0 0 1-1 0v-2Zm16 11a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const TextAddSpaceAfterFilled = ( /*#__PURE__*/createFluentIcon('TextAddSpaceAfterFilled', "1em", ["M3 5.75c0-.41.34-.75.75-.75h12.5a.75.75 0 0 1 0 1.5H3.75A.75.75 0 0 1 3 5.75Zm0 4c0-.41.34-.75.75-.75h12.5a.75.75 0 0 1 0 1.5H3.75A.75.75 0 0 1 3 9.75Zm9.03 6.03c.3-.3.3-.77 0-1.06l-1.5-1.5a.75.75 0 0 0-1.06 0l-1.5 1.5a.75.75 0 1 0 1.06 1.06l.97-.97.97.97c.3.3.77.3 1.06 0Z"]));
export const TextAddSpaceAfterRegular = ( /*#__PURE__*/createFluentIcon('TextAddSpaceAfterRegular', "1em", ["M3 5.5c0-.28.22-.5.5-.5h13a.5.5 0 0 1 0 1h-13a.5.5 0 0 1-.5-.5Zm0 4c0-.28.22-.5.5-.5h13a.5.5 0 0 1 0 1h-13a.5.5 0 0 1-.5-.5Zm5.15 5.15a.5.5 0 0 0 .7.7L10 14.21l1.15 1.14a.5.5 0 0 0 .7-.7l-1.5-1.5a.5.5 0 0 0-.7 0l-1.5 1.5Z"]));
export const TextAddSpaceBeforeFilled = ( /*#__PURE__*/createFluentIcon('TextAddSpaceBeforeFilled', "1em", ["M12.03 5.78a.75.75 0 0 0-1.06-1.06l-.97.97-.97-.97a.75.75 0 0 0-1.06 1.06l1.5 1.5c.3.3.77.3 1.06 0l1.5-1.5ZM3 10.75c0-.41.34-.75.75-.75h12.5a.75.75 0 0 1 0 1.5H3.75a.75.75 0 0 1-.75-.75Zm0 4c0-.41.34-.75.75-.75h12.5a.75.75 0 0 1 0 1.5H3.75a.75.75 0 0 1-.75-.75Z"]));
export const TextAddSpaceBeforeRegular = ( /*#__PURE__*/createFluentIcon('TextAddSpaceBeforeRegular', "1em", ["M8.15 5.85a.5.5 0 1 1 .7-.7L10 6.29l1.15-1.14a.5.5 0 0 1 .7.7l-1.5 1.5a.5.5 0 0 1-.7 0l-1.5-1.5ZM3 10.5c0-.28.22-.5.5-.5h13a.5.5 0 0 1 0 1h-13a.5.5 0 0 1-.5-.5Zm0 4c0-.28.22-.5.5-.5h13a.5.5 0 0 1 0 1h-13a.5.5 0 0 1-.5-.5Z"]));
export const TextAddTFilled = ( /*#__PURE__*/createFluentIcon('TextAddTFilled', "1em", ["M3 3.75c0-.41.34-.75.75-.75h10c.41 0 .75.34.75.75v1.5a.75.75 0 0 1-1.5 0V4.5H9.5v7.7a5.48 5.48 0 0 0 .1 4.8H6.75a.75.75 0 0 1 0-1.5H8v-11H4.5v.75a.75.75 0 0 1-1.5 0v-1.5ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const TextAddTRegular = ( /*#__PURE__*/createFluentIcon('TextAddTRegular', "1em", ["M3 3.5c0-.28.22-.5.5-.5h10c.28 0 .5.22.5.5v2a.5.5 0 0 1-1 0V4H9v12h.2c.1.35.24.68.4 1H6.5a.5.5 0 0 1 0-1H8V4H4v1.5a.5.5 0 0 1-1 0v-2Zm16 11a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const TextAlignCenterFilled = ( /*#__PURE__*/createFluentIcon('TextAlignCenterFilled', "1em", ["M4 4.25c0-.41.34-.75.75-.75h10.5a.75.75 0 0 1 0 1.5H4.75A.75.75 0 0 1 4 4.25Zm-2 5c0-.41.34-.75.75-.75h14.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 9.25Zm4.75 4.25a.75.75 0 0 0 0 1.5h6.5a.75.75 0 0 0 0-1.5h-6.5Z"]));
export const TextAlignCenterRegular = ( /*#__PURE__*/createFluentIcon('TextAlignCenterRegular', "1em", ["M4 4.5c0-.28.22-.5.5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Zm-2 5c0-.28.22-.5.5-.5h15a.5.5 0 0 1 0 1h-15a.5.5 0 0 1-.5-.5ZM6.5 14a.5.5 0 0 0 0 1h7a.5.5 0 0 0 0-1h-7Z"]));
export const TextAlignCenterRotate270Filled = ( /*#__PURE__*/createFluentIcon('TextAlignCenterRotate270Filled', "1em", ["M4.25 16a.75.75 0 0 1-.75-.75V4.75a.75.75 0 0 1 1.5 0v10.5c0 .41-.34.75-.75.75Zm5 2a.75.75 0 0 1-.75-.75V2.75a.75.75 0 0 1 1.5 0v14.5c0 .41-.34.75-.75.75Zm4.25-4.75a.75.75 0 0 0 1.5 0v-6.5a.75.75 0 0 0-1.5 0v6.5Z"]));
export const TextAlignCenterRotate270Regular = ( /*#__PURE__*/createFluentIcon('TextAlignCenterRotate270Regular', "1em", ["M4.5 16a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 1 0v11a.5.5 0 0 1-.5.5Zm5 2a.5.5 0 0 1-.5-.5v-15a.5.5 0 0 1 1 0v15a.5.5 0 0 1-.5.5Zm4.5-4.5a.5.5 0 0 0 1 0v-7a.5.5 0 0 0-1 0v7Z"]));
export const TextAlignCenterRotate90Filled = ( /*#__PURE__*/createFluentIcon('TextAlignCenterRotate90Filled', "1em", ["M15.75 4c.41 0 .75.34.75.75v10.5a.75.75 0 0 1-1.5 0V4.75c0-.41.34-.75.75-.75Zm-5-2c.41 0 .75.34.75.75v14.5a.75.75 0 0 1-1.5 0V2.75c0-.41.34-.75.75-.75ZM6.5 6.75a.75.75 0 0 0-1.5 0v6.5a.75.75 0 0 0 1.5 0v-6.5Z"]));
export const TextAlignCenterRotate90Regular = ( /*#__PURE__*/createFluentIcon('TextAlignCenterRotate90Regular', "1em", ["M15.5 4c.28 0 .5.22.5.5v11a.5.5 0 0 1-1 0v-11c0-.28.22-.5.5-.5Zm-5-2c.28 0 .5.22.5.5v15a.5.5 0 0 1-1 0v-15c0-.28.22-.5.5-.5ZM6 6.5a.5.5 0 0 0-1 0v7a.5.5 0 0 0 1 0v-7Z"]));
export const TextAlignDistributedFilled = ( /*#__PURE__*/createFluentIcon('TextAlignDistributedFilled', "1em", ["M4.78 6.28c.3-.3.3-.77 0-1.06L4.56 5h12.69a.75.75 0 0 0 0-1.5H4.56l.22-.22a.75.75 0 0 0-1.06-1.06l-1.5 1.5c-.3.3-.3.77 0 1.06l1.5 1.5c.3.3.77.3 1.06 0ZM18 9.25c0 .41-.34.75-.75.75H2.75a.75.75 0 0 1 0-1.5h14.5c.41 0 .75.34.75.75ZM2.75 13.5h12.69l-.22-.22a.75.75 0 1 1 1.06-1.06l1.5 1.5c.3.3.3.77 0 1.06l-1.5 1.5a.75.75 0 1 1-1.06-1.06l.22-.22H2.75a.75.75 0 0 1 0-1.5Z"]));
export const TextAlignDistributedRegular = ( /*#__PURE__*/createFluentIcon('TextAlignDistributedRegular', "1em", ["M4.35 5.65 3.71 5H17.5a.5.5 0 0 0 0-1H3.7l.65-.65a.5.5 0 1 0-.7-.7l-1.5 1.5a.5.5 0 0 0 0 .7l1.5 1.5a.5.5 0 1 0 .7-.7ZM2 9.5c0-.28.22-.5.5-.5h15a.5.5 0 0 1 0 1h-15a.5.5 0 0 1-.5-.5Zm.5 4.5h13.8l-.65-.65a.5.5 0 0 1 .7-.7l1.5 1.5c.2.2.2.5 0 .7l-1.5 1.5a.5.5 0 0 1-.7-.7l.64-.65H2.5a.5.5 0 0 1 0-1Z"]));
export const TextAlignDistributedEvenlyFilled = ( /*#__PURE__*/createFluentIcon('TextAlignDistributedEvenlyFilled', "1em", ["M2 3.5c0-.41.34-.75.75-.75h14.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 3.5Zm0 5c0-.41.34-.75.75-.75h14.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 8.5Zm2.56 6.75h10.88l-.72.72a.75.75 0 1 0 1.06 1.06l2-2c.3-.3.3-.77 0-1.06l-2-2a.75.75 0 1 0-1.06 1.06l.72.72H4.56l.72-.72a.75.75 0 1 0-1.06-1.06l-2 2c-.3.3-.3.77 0 1.06l2 2a.75.75 0 0 0 1.06-1.06l-.72-.72Z"]));
export const TextAlignDistributedEvenlyRegular = ( /*#__PURE__*/createFluentIcon('TextAlignDistributedEvenlyRegular', "1em", ["M2 3.5c0-.28.22-.5.5-.5h15a.5.5 0 0 1 0 1h-15a.5.5 0 0 1-.5-.5Zm0 5c0-.28.22-.5.5-.5h15a.5.5 0 0 1 0 1h-15a.5.5 0 0 1-.5-.5ZM3.7 15h12.6l-1.15 1.15a.5.5 0 0 0 .7.7l2-2a.5.5 0 0 0 0-.7l-2-2a.5.5 0 0 0-.7.7L16.29 14H3.71l1.14-1.15a.5.5 0 0 0-.7-.7l-2 2a.5.5 0 0 0 0 .7l2 2a.5.5 0 0 0 .7-.7L3.71 15Z"]));
export const TextAlignDistributedVerticalFilled = ( /*#__PURE__*/createFluentIcon('TextAlignDistributedVerticalFilled', "1em", ["M3.03 14.72a.75.75 0 0 0-1.06 1.06l2 2c.3.3.77.3 1.06 0l2-2a.75.75 0 1 0-1.06-1.06l-.72.72V2.75a.75.75 0 0 0-1.5 0v12.69l-.72-.72ZM10 18a.75.75 0 0 1-.75-.75V2.75a.75.75 0 0 1 1.5 0v14.5c0 .41-.34.75-.75.75Zm8.03-12.72c-.3.3-.77.3-1.06 0l-.72-.72v12.69a.75.75 0 0 1-1.5 0V4.56l-.72.72a.75.75 0 1 1-1.06-1.06l2-2c.3-.3.77-.3 1.06 0l2 2c.3.3.3.77 0 1.06Z"]));
export const TextAlignDistributedVerticalRegular = ( /*#__PURE__*/createFluentIcon('TextAlignDistributedVerticalRegular', "1em", ["M17.85 4.85a.5.5 0 0 1-.7 0L16 3.71V17.5a.5.5 0 1 1-1 0V3.7l-1.15 1.15a.5.5 0 0 1-.7-.7l2-2c.2-.2.5-.2.7 0l2 2c.2.2.2.5 0 .7Zm-15 10.3a.5.5 0 1 0-.7.7l2 2c.2.2.5.2.7 0l2-2a.5.5 0 1 0-.7-.7L5 16.29V2.5a.5.5 0 0 0-1 0v13.8l-1.15-1.15ZM10 18a.5.5 0 0 1-.5-.5v-15a.5.5 0 0 1 1 0v15a.5.5 0 0 1-.5.5Z"]));
export const TextAlignJustifyFilled = ( /*#__PURE__*/createFluentIcon('TextAlignJustifyFilled', "1em", ["M2 4.25c0-.41.34-.75.75-.75h14.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 4.25Zm0 5c0-.41.34-.75.75-.75h14.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 9.25Zm.75 4.25a.75.75 0 0 0 0 1.5h14.5a.75.75 0 0 0 0-1.5H2.75Z"]));
export const TextAlignJustifyRegular = ( /*#__PURE__*/createFluentIcon('TextAlignJustifyRegular', "1em", ["M2 4.5c0-.28.22-.5.5-.5h15a.5.5 0 0 1 0 1h-15a.5.5 0 0 1-.5-.5Zm0 5c0-.28.22-.5.5-.5h15a.5.5 0 0 1 0 1h-15a.5.5 0 0 1-.5-.5Zm.5 4.5a.5.5 0 0 0 0 1h15a.5.5 0 0 0 0-1h-15Z"]));
export const TextAlignJustifyLowFilled = ( /*#__PURE__*/createFluentIcon('TextAlignJustifyLowFilled', "1em", ["M9 4.5c0-.41.34-.75.75-.75h7.5a.75.75 0 0 1 0 1.5h-7.5A.75.75 0 0 1 9 4.5Zm0 5c0-.41.34-.75.75-.75h7.5a.75.75 0 0 1 0 1.5h-7.5A.75.75 0 0 1 9 9.5Zm-6.25 4.25a.75.75 0 0 0 0 1.5h14.5a.75.75 0 0 0 0-1.5H2.75Z"]));
export const TextAlignJustifyLowRegular = ( /*#__PURE__*/createFluentIcon('TextAlignJustifyLowRegular', "1em", ["M9 4.5c0-.28.22-.5.5-.5h8a.5.5 0 0 1 0 1h-8a.5.5 0 0 1-.5-.5Zm0 5c0-.28.22-.5.5-.5h8a.5.5 0 0 1 0 1h-8a.5.5 0 0 1-.5-.5ZM2.5 14a.5.5 0 0 0 0 1h15a.5.5 0 0 0 0-1h-15Z"]));
export const TextAlignJustifyLow90Filled = ( /*#__PURE__*/createFluentIcon('TextAlignJustifyLow90Filled', "1em", ["M15.5 9c.41 0 .75.34.75.75v7.5a.75.75 0 0 1-1.5 0v-7.5c0-.41.34-.75.75-.75Zm-5 0c.41 0 .75.34.75.75v7.5a.75.75 0 0 1-1.5 0v-7.5c0-.41.34-.75.75-.75ZM6.25 2.75a.75.75 0 0 0-1.5 0v14.5a.75.75 0 0 0 1.5 0V2.75Z"]));
export const TextAlignJustifyLow90Regular = ( /*#__PURE__*/createFluentIcon('TextAlignJustifyLow90Regular', "1em", ["M15.5 9c.28 0 .5.22.5.5v8a.5.5 0 0 1-1 0v-8c0-.28.22-.5.5-.5Zm-5 0c.28 0 .5.22.5.5v8a.5.5 0 0 1-1 0v-8c0-.28.22-.5.5-.5ZM6 2.5a.5.5 0 0 0-1 0v15a.5.5 0 0 0 1 0v-15Z"]));
export const TextAlignJustifyLowRotate270Filled = ( /*#__PURE__*/createFluentIcon('TextAlignJustifyLowRotate270Filled', "1em", ["M4.5 11a.75.75 0 0 1-.75-.75v-7.5a.75.75 0 0 1 1.5 0v7.5c0 .41-.34.75-.75.75Zm5 0a.75.75 0 0 1-.75-.75v-7.5a.75.75 0 0 1 1.5 0v7.5c0 .41-.34.75-.75.75Zm4.25 6.25a.75.75 0 0 0 1.5 0V2.75a.75.75 0 0 0-1.5 0v14.5Z"]));
export const TextAlignJustifyLowRotate270Regular = ( /*#__PURE__*/createFluentIcon('TextAlignJustifyLowRotate270Regular', "1em", ["M4.5 11a.5.5 0 0 1-.5-.5v-8a.5.5 0 0 1 1 0v8a.5.5 0 0 1-.5.5Zm5 0a.5.5 0 0 1-.5-.5v-8a.5.5 0 0 1 1 0v8a.5.5 0 0 1-.5.5Zm4.5 6.5a.5.5 0 0 0 1 0v-15a.5.5 0 0 0-1 0v15Z"]));
export const TextAlignJustifyLowRotate90Filled = ( /*#__PURE__*/createFluentIcon('TextAlignJustifyLowRotate90Filled', "1em", ["M15.5 9c.41 0 .75.34.75.75v7.5a.75.75 0 0 1-1.5 0v-7.5c0-.41.34-.75.75-.75Zm-5 0c.41 0 .75.34.75.75v7.5a.75.75 0 0 1-1.5 0v-7.5c0-.41.34-.75.75-.75ZM6.25 2.75a.75.75 0 0 0-1.5 0v14.5a.75.75 0 0 0 1.5 0V2.75Z"]));
export const TextAlignJustifyLowRotate90Regular = ( /*#__PURE__*/createFluentIcon('TextAlignJustifyLowRotate90Regular', "1em", ["M15.5 9c.28 0 .5.22.5.5v8a.5.5 0 0 1-1 0v-8c0-.28.22-.5.5-.5Zm-5 0c.28 0 .5.22.5.5v8a.5.5 0 0 1-1 0v-8c0-.28.22-.5.5-.5ZM6 2.5a.5.5 0 0 0-1 0v15a.5.5 0 0 0 1 0v-15Z"]));
export const TextAlignJustifyRotate270Filled = ( /*#__PURE__*/createFluentIcon('TextAlignJustifyRotate270Filled', "1em", ["M4.25 18a.75.75 0 0 1-.75-.75V2.75a.75.75 0 0 1 1.5 0v14.5c0 .41-.34.75-.75.75Zm5 0a.75.75 0 0 1-.75-.75V2.75a.75.75 0 0 1 1.5 0v14.5c0 .41-.34.75-.75.75Zm4.25-.75a.75.75 0 0 0 1.5 0V2.75a.75.75 0 0 0-1.5 0v14.5Z"]));
export const TextAlignJustifyRotate270Regular = ( /*#__PURE__*/createFluentIcon('TextAlignJustifyRotate270Regular', "1em", ["M4.5 18a.5.5 0 0 1-.5-.5v-15a.5.5 0 0 1 1 0v15a.5.5 0 0 1-.5.5Zm5 0a.5.5 0 0 1-.5-.5v-15a.5.5 0 0 1 1 0v15a.5.5 0 0 1-.5.5Zm4.5-.5a.5.5 0 0 0 1 0v-15a.5.5 0 0 0-1 0v15Z"]));
export const TextAlignJustifyRotate90Filled = ( /*#__PURE__*/createFluentIcon('TextAlignJustifyRotate90Filled', "1em", ["M15.75 2c.41 0 .75.34.75.75v14.5a.75.75 0 0 1-1.5 0V2.75c0-.41.34-.75.75-.75Zm-5 0c.41 0 .75.34.75.75v14.5a.75.75 0 0 1-1.5 0V2.75c0-.41.34-.75.75-.75Zm-4.25.75a.75.75 0 0 0-1.5 0v14.5a.75.75 0 0 0 1.5 0V2.75Z"]));
export const TextAlignJustifyRotate90Regular = ( /*#__PURE__*/createFluentIcon('TextAlignJustifyRotate90Regular', "1em", ["M15.5 2c.28 0 .5.22.5.5v15a.5.5 0 0 1-1 0v-15c0-.28.22-.5.5-.5Zm-5 0c.28 0 .5.22.5.5v15a.5.5 0 0 1-1 0v-15c0-.28.22-.5.5-.5ZM6 2.5a.5.5 0 0 0-1 0v15a.5.5 0 0 0 1 0v-15Z"]));
export const TextAlignLeftFilled = ( /*#__PURE__*/createFluentIcon('TextAlignLeftFilled', "1em", ["M2 4.25c0-.41.34-.75.75-.75h10.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 4.25Zm0 5c0-.41.34-.75.75-.75h14.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 9.25Zm.75 4.25a.75.75 0 0 0 0 1.5h8.5a.75.75 0 0 0 0-1.5h-8.5Z"]));
export const TextAlignLeftRegular = ( /*#__PURE__*/createFluentIcon('TextAlignLeftRegular', "1em", ["M2 4.5c0-.28.22-.5.5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Zm0 5c0-.28.22-.5.5-.5h15a.5.5 0 0 1 0 1h-15a.5.5 0 0 1-.5-.5Zm.5 4.5a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9Z"]));
export const TextAlignLeftRotate270Filled = ( /*#__PURE__*/createFluentIcon('TextAlignLeftRotate270Filled', "1em", ["M4.25 18a.75.75 0 0 1-.75-.75V6.75a.75.75 0 0 1 1.5 0v10.5c0 .41-.34.75-.75.75Zm5 0a.75.75 0 0 1-.75-.75V2.75a.75.75 0 0 1 1.5 0v14.5c0 .41-.34.75-.75.75Zm4.25-.75a.75.75 0 0 0 1.5 0v-8.5a.75.75 0 0 0-1.5 0v8.5Z"]));
export const TextAlignLeftRotate270Regular = ( /*#__PURE__*/createFluentIcon('TextAlignLeftRotate270Regular', "1em", ["M4.5 18a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 1 0v11a.5.5 0 0 1-.5.5Zm5 0a.5.5 0 0 1-.5-.5v-15a.5.5 0 0 1 1 0v15a.5.5 0 0 1-.5.5Zm4.5-.5a.5.5 0 0 0 1 0v-9a.5.5 0 0 0-1 0v9Z"]));
export const TextAlignLeftRotate90Filled = ( /*#__PURE__*/createFluentIcon('TextAlignLeftRotate90Filled', "1em", ["M15.75 2c.41 0 .75.34.75.75v10.5a.75.75 0 0 1-1.5 0V2.75c0-.41.34-.75.75-.75Zm-5 0c.41 0 .75.34.75.75v14.5a.75.75 0 0 1-1.5 0V2.75c0-.41.34-.75.75-.75Zm-4.25.75a.75.75 0 0 0-1.5 0v8.5a.75.75 0 0 0 1.5 0v-8.5Z"]));
export const TextAlignLeftRotate90Regular = ( /*#__PURE__*/createFluentIcon('TextAlignLeftRotate90Regular', "1em", ["M15.5 2c.28 0 .5.22.5.5v11a.5.5 0 0 1-1 0v-11c0-.28.22-.5.5-.5Zm-5 0c.28 0 .5.22.5.5v15a.5.5 0 0 1-1 0v-15c0-.28.22-.5.5-.5ZM6 2.5a.5.5 0 0 0-1 0v9a.5.5 0 0 0 1 0v-9Z"]));
export const TextAlignRightFilled = ( /*#__PURE__*/createFluentIcon('TextAlignRightFilled', "1em", ["M6 4.25c0-.41.34-.75.75-.75h10.5a.75.75 0 0 1 0 1.5H6.75A.75.75 0 0 1 6 4.25Zm-4 5c0-.41.34-.75.75-.75h14.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 9.25Zm7.75 4.25a.75.75 0 0 0 0 1.5h7.5a.75.75 0 0 0 0-1.5h-7.5Z"]));
export const TextAlignRightRegular = ( /*#__PURE__*/createFluentIcon('TextAlignRightRegular', "1em", ["M6 4.5c0-.28.22-.5.5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Zm-4 5c0-.28.22-.5.5-.5h15a.5.5 0 0 1 0 1h-15a.5.5 0 0 1-.5-.5ZM9.5 14a.5.5 0 0 0 0 1h8a.5.5 0 0 0 0-1h-8Z"]));
export const TextAlignRightRotate270Filled = ( /*#__PURE__*/createFluentIcon('TextAlignRightRotate270Filled', "1em", ["M4.25 14a.75.75 0 0 1-.75-.75V2.75a.75.75 0 0 1 1.5 0v10.5c0 .41-.34.75-.75.75Zm5 4a.75.75 0 0 1-.75-.75V2.75a.75.75 0 0 1 1.5 0v14.5c0 .41-.34.75-.75.75Zm4.25-7.75a.75.75 0 0 0 1.5 0v-7.5a.75.75 0 0 0-1.5 0v7.5Z"]));
export const TextAlignRightRotate270Regular = ( /*#__PURE__*/createFluentIcon('TextAlignRightRotate270Regular', "1em", ["M4.5 14a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 1 0v11a.5.5 0 0 1-.5.5Zm5 4a.5.5 0 0 1-.5-.5v-15a.5.5 0 0 1 1 0v15a.5.5 0 0 1-.5.5Zm4.5-7.5a.5.5 0 0 0 1 0v-8a.5.5 0 0 0-1 0v8Z"]));
export const TextAlignRightRotate90Filled = ( /*#__PURE__*/createFluentIcon('TextAlignRightRotate90Filled', "1em", ["M15.75 6c.41 0 .75.34.75.75v10.5a.75.75 0 0 1-1.5 0V6.75c0-.41.34-.75.75-.75Zm-5-4c.41 0 .75.34.75.75v14.5a.75.75 0 0 1-1.5 0V2.75c0-.41.34-.75.75-.75ZM6.5 9.75a.75.75 0 0 0-1.5 0v7.5a.75.75 0 0 0 1.5 0v-7.5Z"]));
export const TextAlignRightRotate90Regular = ( /*#__PURE__*/createFluentIcon('TextAlignRightRotate90Regular', "1em", ["M15.5 6c.28 0 .5.22.5.5v11a.5.5 0 0 1-1 0v-11c0-.28.22-.5.5-.5Zm-5-4c.28 0 .5.22.5.5v15a.5.5 0 0 1-1 0v-15c0-.28.22-.5.5-.5ZM6 9.5a.5.5 0 0 0-1 0v8a.5.5 0 0 0 1 0v-8Z"]));
export const TextArrowDownRightColumnFilled = ( /*#__PURE__*/createFluentIcon('TextArrowDownRightColumnFilled', "1em", ["M2 6.5c0 .28.22.5.5.5h5a.5.5 0 0 0 0-1h-5a.5.5 0 0 0-.5.5Zm0-3c0 .28.22.5.5.5h7a.5.5 0 0 0 0-1h-7a.5.5 0 0 0-.5.5ZM11 7c0-1.1.9-2 2-2h2a2 2 0 0 1 2 2v2h-6V7Zm6 3h-6v3h6v-3Zm0 4h-6v2c0 1.1.9 2 2 2h2a2 2 0 0 0 2-2v-2ZM4 9.5a.5.5 0 0 0-1 0v2A2.5 2.5 0 0 0 5.5 14h1.8l-1.15 1.15a.5.5 0 0 0 .7.7l2-2a.5.5 0 0 0 0-.7l-2-2a.5.5 0 0 0-.7.7L7.29 13H5.5A1.5 1.5 0 0 1 4 11.5v-2Z"]));
export const TextArrowDownRightColumnRegular = ( /*#__PURE__*/createFluentIcon('TextArrowDownRightColumnRegular', "1em", ["M2 6.5c0 .28.22.5.5.5h5a.5.5 0 0 0 0-1h-5a.5.5 0 0 0-.5.5Zm0-3c0 .28.22.5.5.5h7a.5.5 0 0 0 0-1h-7a.5.5 0 0 0-.5.5ZM13 5a2 2 0 0 0-2 2v9c0 1.1.9 2 2 2h2a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2h-2Zm3 4h-4V7a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v2Zm-4 1h4v3h-4v-3Zm0 4h4v2a1 1 0 0 1-1 1h-2a1 1 0 0 1-1-1v-2ZM4 9.5a.5.5 0 0 0-1 0v2A2.5 2.5 0 0 0 5.5 14h1.8l-1.15 1.15a.5.5 0 0 0 .7.7l2-2a.5.5 0 0 0 0-.7l-2-2a.5.5 0 0 0-.7.7L7.29 13H5.5A1.5 1.5 0 0 1 4 11.5v-2Z"]));
export const TextAsteriskFilled = ( /*#__PURE__*/createFluentIcon('TextAsteriskFilled', "1em", ["M10.6 2.5a.6.6 0 1 0-1.2 0v6.05L5.12 4.27a.6.6 0 1 0-.85.85L8.55 9.4H2.5a.6.6 0 1 0 0 1.2h6.05l-4.28 4.28a.6.6 0 0 0 .85.85l4.28-4.28v6.05a.6.6 0 1 0 1.2 0v-6.05l4.28 4.28a.6.6 0 0 0 .85-.85l-4.28-4.28h6.05a.6.6 0 1 0 0-1.2h-6.05l4.28-4.28a.6.6 0 0 0-.85-.85L10.6 8.55V2.5Z"]));
export const TextAsteriskRegular = ( /*#__PURE__*/createFluentIcon('TextAsteriskRegular', "1em", ["M10.5 2.5a.5.5 0 0 0-1 0v6.3L5.05 4.33a.5.5 0 1 0-.7.71L8.78 9.5H2.5a.5.5 0 0 0 0 1h6.3l-4.46 4.45a.5.5 0 1 0 .71.7l4.45-4.44v6.29a.5.5 0 0 0 1 0v-6.3l4.45 4.46a.5.5 0 1 0 .7-.71l-4.44-4.45h6.29a.5.5 0 0 0 0-1h-6.3l4.46-4.45a.5.5 0 1 0-.71-.7L10.5 8.78V2.5Z"]));
export const TextBaselineFilled = ( /*#__PURE__*/createFluentIcon('TextBaselineFilled', "1em", ["M10.7 3.47a.75.75 0 0 0-1.4 0l-3.75 9.5a.75.75 0 0 0 1.4.56l1.2-3.03h3.7l1.2 3.03a.75.75 0 0 0 1.4-.56l-3.75-9.5ZM11.27 9H8.73L10 5.8 11.27 9Z", "M2.5 16a.5.5 0 0 0 0 1h15a.5.5 0 0 0 0-1h-15Z"]));
export const TextBaselineRegular = ( /*#__PURE__*/createFluentIcon('TextBaselineRegular', "1em", ["M10.46 3.8a.5.5 0 0 0-.92 0l-4 9.5a.5.5 0 1 0 .92.4L8.02 10h3.96l1.56 3.7a.5.5 0 1 0 .92-.4l-4-9.5Zm1.1 5.2H8.44L10 5.29 11.56 9Z", "M2.5 16a.5.5 0 0 0 0 1h15a.5.5 0 0 0 0-1h-15Z"]));
export const TextBoldFilled = ( /*#__PURE__*/createFluentIcon('TextBoldFilled', "1em", ["M5 4.5C5 3.67 5.67 3 6.5 3h3.88a4.12 4.12 0 0 1 3.44 6.39 4.24 4.24 0 0 1 1.43 3.24A4.36 4.36 0 0 1 10.88 17H6.5A1.5 1.5 0 0 1 5 15.5v-11ZM8 6v2.25h2.38a1.13 1.13 0 0 0 0-2.25H8Zm0 5.25V14h2.88c.7 0 1.37-.54 1.37-1.37 0-.84-.69-1.38-1.37-1.38H8Z"]));
export const TextBoldRegular = ( /*#__PURE__*/createFluentIcon('TextBoldRegular', "1em", ["M5.5 4.25C5.5 3.56 6.06 3 6.75 3h3.5a4 4 0 0 1 3.17 6.44c.9.7 1.58 1.8 1.58 3.31A4.23 4.23 0 0 1 10.75 17h-4c-.69 0-1.25-.56-1.25-1.25V4.25ZM8 11v3.5h2.75c.81 0 1.75-.62 1.75-1.75S11.56 11 10.75 11H8Zm0-2.5h2.25a1.5 1.5 0 1 0 0-3H8v3Z"]));
export const TextBoxSettingsFilled = ( /*#__PURE__*/createFluentIcon('TextBoxSettingsFilled', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h4.1a5.48 5.48 0 0 1-.5-3.5H6.7c-.38 0-.7-.34-.7-.75s.32-.75.7-.75h2.9c.29-.56.67-1.07 1.13-1.5H6.7c-.4 0-.71-.34-.71-.75S6.32 9 6.7 9H14.36a5.63 5.63 0 0 1 2.65.6V5.5ZM6 6.75c0-.41.32-.75.7-.75h6.6c.38 0 .7.34.7.75s-.32.75-.7.75H6.7c-.38 0-.7-.34-.7-.75Zm6.07 4.7a2 2 0 0 1-1.44 2.47l-.46.12a4.74 4.74 0 0 0 .01 1.01l.35.09A2 2 0 0 1 12 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.15-.55a2 2 0 0 1 1.43-2.48l.46-.12a4.73 4.73 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 17 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.3.13-.57.3-.82.5l.16.55Zm2.43 4.05a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const TextBoxSettingsRegular = ( /*#__PURE__*/createFluentIcon('TextBoxSettingsRegular', "1em", ["M6.5 6a.5.5 0 0 0 0 1h7a.5.5 0 0 0 0-1h-7ZM6 9.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm.5 2.5a.5.5 0 0 0 0 1h2.7c.1-.35.24-.68.4-1H6.5Zm-1 4h3.7c.1.35.24.68.4 1H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v4.1c-.32-.16-.65-.3-1-.4V5.5c0-.83-.67-1.5-1.5-1.5h-9C4.67 4 4 4.67 4 5.5v9c0 .83.67 1.5 1.5 1.5Zm6.57-4.56a2 2 0 0 1-1.44 2.48l-.46.12a4.74 4.74 0 0 0 .01 1.01l.35.09A2 2 0 0 1 12 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.15-.55a2 2 0 0 1 1.43-2.48l.46-.12a4.73 4.73 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 17 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.3.13-.57.3-.82.5l.16.55Zm2.43 4.06a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const TextBulletListFilled = ( /*#__PURE__*/createFluentIcon('TextBulletListFilled', "1em", ["M3.25 6a1.25 1.25 0 1 0 0-2.5 1.25 1.25 0 0 0 0 2.5ZM7 4.75c0-.41.34-.75.75-.75h9.5a.75.75 0 0 1 0 1.5h-9.5A.75.75 0 0 1 7 4.75ZM7.75 9a.75.75 0 0 0 0 1.5h9.5a.75.75 0 0 0 0-1.5h-9.5Zm0 5a.75.75 0 0 0 0 1.5h9.5a.75.75 0 0 0 0-1.5h-9.5ZM4.5 9.75a1.25 1.25 0 1 1-2.5 0 1.25 1.25 0 0 1 2.5 0ZM3.25 16a1.25 1.25 0 1 0 0-2.5 1.25 1.25 0 0 0 0 2.5Z"]));
export const TextBulletListRegular = ( /*#__PURE__*/createFluentIcon('TextBulletListRegular', "1em", ["M3 5.5a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm3-1c0-.28.22-.5.5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Zm0 5c0-.28.22-.5.5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Zm.5 4.5a.5.5 0 0 0 0 1h11a.5.5 0 0 0 0-1h-11Zm-2.5.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-1-4a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"]));
export const TextBulletList90Filled = ( /*#__PURE__*/createFluentIcon('TextBulletList90Filled', "1em", ["M6 16.75a1.25 1.25 0 1 0-2.5 0 1.25 1.25 0 0 0 2.5 0ZM4.75 13a.75.75 0 0 1-.75-.75v-9.5a.75.75 0 0 1 1.5 0v9.5c0 .41-.34.75-.75.75ZM9 12.25a.75.75 0 0 0 1.5 0v-9.5a.75.75 0 0 0-1.5 0v9.5Zm5 0a.75.75 0 0 0 1.5 0v-9.5a.75.75 0 0 0-1.5 0v9.5ZM9.75 15.5a1.25 1.25 0 1 1 0 2.5 1.25 1.25 0 0 1 0-2.5ZM16 16.75a1.25 1.25 0 1 0-2.5 0 1.25 1.25 0 0 0 2.5 0Z"]));
export const TextBulletList90Regular = ( /*#__PURE__*/createFluentIcon('TextBulletList90Regular', "1em", ["M5.5 17a1 1 0 1 0-2 0 1 1 0 0 0 2 0Zm-1-3a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 1 0v11a.5.5 0 0 1-.5.5Zm5 0a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 1 0v11a.5.5 0 0 1-.5.5Zm4.5-.5a.5.5 0 0 0 1 0v-11a.5.5 0 0 0-1 0v11Zm.5 2.5a1 1 0 1 1 0 2 1 1 0 0 1 0-2Zm-4 1a1 1 0 1 0-2 0 1 1 0 0 0 2 0Z"]));
export const TextBulletListAddFilled = ( /*#__PURE__*/createFluentIcon('TextBulletListAddFilled', "1em", ["M3.25 6a1.25 1.25 0 1 0 0-2.5 1.25 1.25 0 0 0 0 2.5ZM7 4.75c0-.41.34-.75.75-.75h9.5a.75.75 0 0 1 0 1.5h-9.5A.75.75 0 0 1 7 4.75ZM7.75 9a.75.75 0 0 0 0 1.5h5.46a5.48 5.48 0 0 1 4.39-.09.75.75 0 0 0-.35-1.41h-9.5Zm0 5h2.46c-.14.48-.21.98-.21 1.5H7.75a.75.75 0 0 1 0-1.5ZM4.5 9.75a1.25 1.25 0 1 1-2.5 0 1.25 1.25 0 0 1 2.5 0ZM3.25 16a1.25 1.25 0 1 0 0-2.5 1.25 1.25 0 0 0 0 2.5ZM20 15.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V15h-1.5a.5.5 0 0 0 0 1H15v1.5a.5.5 0 0 0 1 0V16h1.5a.5.5 0 0 0 0-1H16v-1.5Z"]));
export const TextBulletListAddRegular = ( /*#__PURE__*/createFluentIcon('TextBulletListAddRegular', "1em", ["M3 5.5a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm3-1c0-.28.22-.5.5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Zm0 5c0-.28.22-.5.5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Zm4.02 5.5c.03-.34.1-.68.19-1H6.5a.5.5 0 0 0 0 1h3.52ZM4 14.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-1-4a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm17 5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V15h-1.5a.5.5 0 0 0 0 1H15v1.5a.5.5 0 0 0 1 0V16h1.5a.5.5 0 0 0 0-1H16v-1.5Z"]));
export const TextBulletListCheckmarkFilled = ( /*#__PURE__*/createFluentIcon('TextBulletListCheckmarkFilled', "1em", ["M3.25 6a1.25 1.25 0 1 0 0-2.5 1.25 1.25 0 0 0 0 2.5ZM7 4.75c0-.41.34-.75.75-.75h9.5a.75.75 0 0 1 0 1.5h-9.5A.75.75 0 0 1 7 4.75ZM7.75 9a.75.75 0 0 0 0 1.5h5.46a5.48 5.48 0 0 1 4.39-.09.75.75 0 0 0-.35-1.41h-9.5Zm0 5h2.46c-.14.48-.21.98-.21 1.5H7.75a.75.75 0 0 1 0-1.5ZM4.5 9.75a1.25 1.25 0 1 1-2.5 0 1.25 1.25 0 0 1 2.5 0ZM3.25 16a1.25 1.25 0 1 0 0-2.5 1.25 1.25 0 0 0 0 2.5ZM20 15.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.85-1.85-2.65 2.64-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l3-3a.5.5 0 0 0-.7-.7Z"]));
export const TextBulletListCheckmarkRegular = ( /*#__PURE__*/createFluentIcon('TextBulletListCheckmarkRegular', "1em", ["M3 5.5a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm3-1c0-.28.22-.5.5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Zm0 5c0-.28.22-.5.5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Zm4.02 5.5c.03-.34.1-.68.19-1H6.5a.5.5 0 0 0 0 1h3.52ZM4 14.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-1-4a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm17 5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-5.5.8-.65-.65a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l3-3a.5.5 0 0 0-.7-.7l-2.65 2.64Z"]));
export const TextBulletListDismissFilled = ( /*#__PURE__*/createFluentIcon('TextBulletListDismissFilled', "1em", ["M3.25 6a1.25 1.25 0 1 0 0-2.5 1.25 1.25 0 0 0 0 2.5ZM7 4.75c0-.41.34-.75.75-.75h9.5a.75.75 0 0 1 0 1.5h-9.5A.75.75 0 0 1 7 4.75ZM7.75 9a.75.75 0 0 0 0 1.5h5.46a5.48 5.48 0 0 1 4.39-.09.75.75 0 0 0-.35-1.41h-9.5Zm0 5h2.46c-.14.48-.21.98-.21 1.5H7.75a.75.75 0 0 1 0-1.5ZM4.5 9.75a1.25 1.25 0 1 1-2.5 0 1.25 1.25 0 0 1 2.5 0ZM3.25 16a1.25 1.25 0 1 0 0-2.5 1.25 1.25 0 0 0 0 2.5ZM20 15.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-3.8 0 1.15-1.15a.5.5 0 0 0-.7-.7l-1.15 1.14-1.15-1.14a.5.5 0 0 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 0 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 0 0 .7-.7l-1.14-1.15Z"]));
export const TextBulletListDismissRegular = ( /*#__PURE__*/createFluentIcon('TextBulletListDismissRegular', "1em", ["M3 5.5a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm3-1c0-.28.22-.5.5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Zm0 5c0-.28.22-.5.5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Zm4.02 5.5c.03-.34.1-.68.19-1H6.5a.5.5 0 0 0 0 1h3.52ZM4 14.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-1-4a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm17 5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-3.8 0 1.15-1.15a.5.5 0 0 0-.7-.7l-1.15 1.14-1.15-1.14a.5.5 0 0 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 0 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 0 0 .7-.7l-1.14-1.15Z"]));
export const TextBulletListLtrFilled = ( /*#__PURE__*/createFluentIcon('TextBulletListLtrFilled', "1em", ["M3.25 6a1.25 1.25 0 1 0 0-2.5 1.25 1.25 0 0 0 0 2.5ZM7 4.75c0-.41.34-.75.75-.75h9.5a.75.75 0 0 1 0 1.5h-9.5A.75.75 0 0 1 7 4.75ZM7.75 9a.75.75 0 0 0 0 1.5h9.5a.75.75 0 0 0 0-1.5h-9.5Zm0 5a.75.75 0 0 0 0 1.5h9.5a.75.75 0 0 0 0-1.5h-9.5ZM4.5 9.75a1.25 1.25 0 1 1-2.5 0 1.25 1.25 0 0 1 2.5 0ZM3.25 16a1.25 1.25 0 1 0 0-2.5 1.25 1.25 0 0 0 0 2.5Z"]));
export const TextBulletListLtrRegular = ( /*#__PURE__*/createFluentIcon('TextBulletListLtrRegular', "1em", ["M3 5.5a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm3-1c0-.28.22-.5.5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Zm0 5c0-.28.22-.5.5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Zm.5 4.5a.5.5 0 0 0 0 1h11a.5.5 0 0 0 0-1h-11Zm-2.5.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-1-4a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"]));
export const TextBulletListLtr90Filled = ( /*#__PURE__*/createFluentIcon('TextBulletListLtr90Filled', "1em", ["M14 3.25a1.25 1.25 0 1 0 2.5 0 1.25 1.25 0 0 0-2.5 0ZM15.25 7c.41 0 .75.34.75.75v9.5a.75.75 0 0 1-1.5 0v-9.5c0-.41.34-.75.75-.75ZM11 7.75a.75.75 0 0 0-1.5 0v9.5a.75.75 0 0 0 1.5 0v-9.5Zm-5 0a.75.75 0 0 0-1.5 0v9.5a.75.75 0 0 0 1.5 0v-9.5Zm4.25-3.25a1.25 1.25 0 1 1 0-2.5 1.25 1.25 0 0 1 0 2.5ZM4 3.25a1.25 1.25 0 1 0 2.5 0 1.25 1.25 0 0 0-2.5 0Z"]));
export const TextBulletListLtr90Regular = ( /*#__PURE__*/createFluentIcon('TextBulletListLtr90Regular', "1em", ["M14.5 3a1 1 0 1 0 2 0 1 1 0 0 0-2 0Zm1 3c.28 0 .5.22.5.5v11a.5.5 0 0 1-1 0v-11c0-.28.22-.5.5-.5Zm-5 0c.28 0 .5.22.5.5v11a.5.5 0 0 1-1 0v-11c0-.28.22-.5.5-.5ZM6 6.5a.5.5 0 0 0-1 0v11a.5.5 0 0 0 1 0v-11ZM5.5 4a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm4-1a1 1 0 1 0 2 0 1 1 0 0 0-2 0Z"]));
export const TextBulletListRtlFilled = ( /*#__PURE__*/createFluentIcon('TextBulletListRtlFilled', "1em", ["M16.75 6a1.25 1.25 0 1 1 0-2.5 1.25 1.25 0 0 1 0 2.5ZM13 4.75a.75.75 0 0 0-.75-.75h-9.5a.75.75 0 0 0 0 1.5h9.5c.41 0 .75-.34.75-.75ZM12.25 9a.75.75 0 0 1 0 1.5h-9.5a.75.75 0 0 1 0-1.5h9.5Zm0 5a.75.75 0 0 1 0 1.5h-9.5a.75.75 0 0 1 0-1.5h9.5Zm3.25-4.25a1.25 1.25 0 1 0 2.5 0 1.25 1.25 0 0 0-2.5 0ZM16.75 16a1.25 1.25 0 1 1 0-2.5 1.25 1.25 0 0 1 0 2.5Z"]));
export const TextBulletListRtlRegular = ( /*#__PURE__*/createFluentIcon('TextBulletListRtlRegular', "1em", ["M17 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm-3-1a.5.5 0 0 0-.5-.5h-11a.5.5 0 0 0 0 1h11a.5.5 0 0 0 .5-.5Zm0 5a.5.5 0 0 0-.5-.5h-11a.5.5 0 0 0 0 1h11a.5.5 0 0 0 .5-.5Zm-.5 4.5a.5.5 0 0 1 0 1h-11a.5.5 0 0 1 0-1h11Zm2.5.5a1 1 0 1 0 2 0 1 1 0 0 0-2 0Zm1-4a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const TextBulletListRtl90Filled = ( /*#__PURE__*/createFluentIcon('TextBulletListRtl90Filled', "1em", ["M6 16.75a1.25 1.25 0 1 0-2.5 0 1.25 1.25 0 0 0 2.5 0ZM4.75 13a.75.75 0 0 1-.75-.75v-9.5a.75.75 0 0 1 1.5 0v9.5c0 .41-.34.75-.75.75ZM9 12.25a.75.75 0 0 0 1.5 0v-9.5a.75.75 0 0 0-1.5 0v9.5Zm5 0a.75.75 0 0 0 1.5 0v-9.5a.75.75 0 0 0-1.5 0v9.5ZM9.75 15.5a1.25 1.25 0 1 1 0 2.5 1.25 1.25 0 0 1 0-2.5ZM16 16.75a1.25 1.25 0 1 0-2.5 0 1.25 1.25 0 0 0 2.5 0Z"]));
export const TextBulletListRtl90Regular = ( /*#__PURE__*/createFluentIcon('TextBulletListRtl90Regular', "1em", ["M5.5 17a1 1 0 1 0-2 0 1 1 0 0 0 2 0Zm-1-3a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 1 0v11a.5.5 0 0 1-.5.5Zm5 0a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 1 0v11a.5.5 0 0 1-.5.5Zm4.5-.5a.5.5 0 0 0 1 0v-11a.5.5 0 0 0-1 0v11Zm.5 2.5a1 1 0 1 1 0 2 1 1 0 0 1 0-2Zm-4 1a1 1 0 1 0-2 0 1 1 0 0 0 2 0Z"]));
export const TextBulletListSquareColor = ( /*#__PURE__*/createFluentIcon('TextBulletListSquareColor', "1em", `<path d="M5.75 3h8.5A2.75 2.75 0 0 1 17 5.75v8.5A2.75 2.75 0 0 1 14.25 17h-8.5A2.75 2.75 0 0 1 3 14.25v-8.5A2.75 2.75 0 0 1 5.75 3Z" fill="url(#ic_fluent_text_bullet_list_square_20_color__a)"/><path d="M6.75 8a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM6.75 14a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM9 7.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm.5 2.5a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4ZM9 13.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z" fill="url(#ic_fluent_text_bullet_list_square_20_color__b)"/><defs><linearGradient id="ic_fluent_text_bullet_list_square_20_color__a" x1="3.5" y1="5.63" x2="13.16" y2="15.66" gradientUnits="userSpaceOnUse"><stop stop-color="#0FAFFF"/><stop offset="1" stop-color="#2764E7"/></linearGradient><linearGradient id="ic_fluent_text_bullet_list_square_20_color__b" x1="7.54" y1="7.08" x2="12.8" y2="20.67" gradientUnits="userSpaceOnUse"><stop stop-color="#fff"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient></defs>`, { color: true }));
export const TextBulletListSquareFilled = ( /*#__PURE__*/createFluentIcon('TextBulletListSquareFilled', "1em", ["M3 5.75A2.75 2.75 0 0 1 5.75 3h8.5A2.75 2.75 0 0 1 17 5.75v8.5A2.75 2.75 0 0 1 14.25 17h-8.5A2.75 2.75 0 0 1 3 14.25v-8.5ZM6.75 8a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0ZM6.75 14a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM9 7.5c0 .28.22.5.5.5h4a.5.5 0 0 0 0-1h-4a.5.5 0 0 0-.5.5Zm.5 2.5a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4ZM9 13.5c0 .28.22.5.5.5h4a.5.5 0 0 0 0-1h-4a.5.5 0 0 0-.5.5Z"]));
export const TextBulletListSquareRegular = ( /*#__PURE__*/createFluentIcon('TextBulletListSquareRegular', "1em", ["M6.75 8a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM6.75 14a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM9 7.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm.5 2.5a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4ZM9 13.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5ZM5.75 3h8.5A2.75 2.75 0 0 1 17 5.75v8.5A2.75 2.75 0 0 1 14.25 17h-8.5A2.75 2.75 0 0 1 3 14.25v-8.5A2.75 2.75 0 0 1 5.75 3ZM4 5.75v8.5c0 .97.78 1.75 1.75 1.75h8.5c.97 0 1.75-.78 1.75-1.75v-8.5C16 4.78 15.22 4 14.25 4h-8.5C4.78 4 4 4.78 4 5.75Z"]));
export const TextBulletListSquareClockFilled = ( /*#__PURE__*/createFluentIcon('TextBulletListSquareClockFilled', "1em", ["M5.75 3A2.75 2.75 0 0 0 3 5.75v8.5A2.75 2.75 0 0 0 5.75 17H9.6a5.48 5.48 0 0 1 .66-6H9.5a.5.5 0 0 1 0-1h1.84A5.47 5.47 0 0 1 17 9.6V5.75A2.75 2.75 0 0 0 14.25 3h-8.5ZM7.5 7.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM6.75 9.5a.75.75 0 1 1 0 1.5.75.75 0 0 1 0-1.5Zm.75 3.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM9.5 8a.5.5 0 0 1 0-1h4a.5.5 0 0 1 0 1h-4Zm5 11a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm-.5-6.5a.5.5 0 0 1 1 0V14h1a.5.5 0 0 1 0 1h-1.5a.5.5 0 0 1-.5-.5v-2Z"]));
export const TextBulletListSquareClockRegular = ( /*#__PURE__*/createFluentIcon('TextBulletListSquareClockRegular', "1em", ["M5.75 3h8.5A2.75 2.75 0 0 1 17 5.75V9.6c-.32-.16-.65-.3-1-.4V5.76C16 4.78 15.22 4 14.25 4h-8.5C4.78 4 4 4.78 4 5.75v8.5c0 .97.78 1.75 1.75 1.75h3.46c.1.35.23.68.39 1H5.75A2.75 2.75 0 0 1 3 14.25v-8.5A2.75 2.75 0 0 1 5.75 3Zm3.75 7h1.84c-.4.28-.77.62-1.08 1H9.5a.5.5 0 0 1 0-1ZM6.75 8a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm0 3a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM9 7.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm10 7a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM14.5 12a.5.5 0 0 0-.5.5v2c0 .28.22.5.5.5H16a.5.5 0 0 0 0-1h-1v-1.5a.5.5 0 0 0-.5-.5Z"]));
export const TextBulletListSquareEditFilled = ( /*#__PURE__*/createFluentIcon('TextBulletListSquareEditFilled', "1em", ["M3 5.75A2.75 2.75 0 0 1 5.75 3h8.5A2.75 2.75 0 0 1 17 5.75V9c-.69.03-1.37.31-1.9.84L11.94 13H9.5a.5.5 0 0 0 0 1h1.44l-.67.67c-.4.41-.7.92-.84 1.49l-.21.84H5.75A2.75 2.75 0 0 1 3 14.25v-8.5ZM6.75 8a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0ZM6.75 14a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM9 7.5c0 .28.22.5.5.5h4a.5.5 0 0 0 0-1h-4a.5.5 0 0 0-.5.5Zm.5 2.5a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Zm1.48 5.38 4.83-4.83a1.87 1.87 0 1 1 2.64 2.64l-4.83 4.83a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.07l.37-1.5c.1-.39.3-.74.58-1.02Z"]));
export const TextBulletListSquareEditRegular = ( /*#__PURE__*/createFluentIcon('TextBulletListSquareEditRegular', "1em", ["M5.75 3h8.5A2.75 2.75 0 0 1 17 5.75V9c-.34.02-.68.1-1 .23V5.75C16 4.78 15.22 4 14.25 4h-8.5C4.78 4 4 4.78 4 5.75v8.5c0 .97.78 1.75 1.75 1.75h3.72l-.04.16-.21.84H5.75A2.75 2.75 0 0 1 3 14.25v-8.5A2.75 2.75 0 0 1 5.75 3ZM9.5 13h2.44l-1 1H9.5a.5.5 0 0 1 0-1Zm-2-5.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM6.75 11a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm0 3a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM9.5 7a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Zm0 3a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Zm1.48 5.38 4.83-4.83a1.87 1.87 0 1 1 2.64 2.64l-4.83 4.83a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.07l.37-1.5c.1-.39.3-.74.58-1.02Z"]));
export const TextBulletListSquarePersonFilled = ( /*#__PURE__*/createFluentIcon('TextBulletListSquarePersonFilled', "1em", ["M3 5.75A2.75 2.75 0 0 1 5.75 3h8.5A2.75 2.75 0 0 1 17 5.75V9.4a2.99 2.99 0 0 0-3.74.6H9.5a.5.5 0 0 0 0 1h3.17a3 3 0 0 0 0 2H9.5a.5.5 0 0 0 0 1h3.76l.01.01A2.5 2.5 0 0 0 11.04 17H5.75A2.75 2.75 0 0 1 3 14.25v-8.5ZM6.75 8a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0ZM6.75 14a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM9 7.5c0 .28.22.5.5.5h4a.5.5 0 0 0 0-1h-4a.5.5 0 0 0-.5.5Zm8.5 4.5a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm1.5 4.5c0 1.25-1 2.5-3.5 2.5S12 17.75 12 16.5c0-.83.67-1.5 1.5-1.5h4c.83 0 1.5.67 1.5 1.5Z"]));
export const TextBulletListSquarePersonRegular = ( /*#__PURE__*/createFluentIcon('TextBulletListSquarePersonRegular', "1em", ["M5.75 3h8.5A2.75 2.75 0 0 1 17 5.75V9.4c-.3-.17-.64-.3-1-.36V5.75C16 4.78 15.22 4 14.25 4h-8.5C4.78 4 4 4.78 4 5.75v8.5c0 .97.78 1.75 1.75 1.75h5.3a2.51 2.51 0 0 0-.01 1H5.75A2.75 2.75 0 0 1 3 14.25v-8.5A2.75 2.75 0 0 1 5.75 3Zm3.75 7h3.76a3 3 0 0 0-.59 1H9.5a.5.5 0 0 1 0-1Zm0 3h3.17a3 3 0 0 0 .6 1H9.5a.5.5 0 0 1 0-1Zm-2-5.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM6.75 11a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm0 3a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM9.5 7a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Zm8 5a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm1.5 4.5c0 1.25-1 2.5-3.5 2.5S12 17.75 12 16.5c0-.83.67-1.5 1.5-1.5h4c.83 0 1.5.67 1.5 1.5Z"]));
export const TextBulletListSquareSearchFilled = ( /*#__PURE__*/createFluentIcon('TextBulletListSquareSearchFilled', "1em", ["M3 5.75A2.75 2.75 0 0 1 5.75 3h8.5A2.75 2.75 0 0 1 17 5.75v8.5A2.75 2.75 0 0 1 14.25 17h-4.13l-1.56-1.56c.21-.44.36-.93.41-1.44h4.53a.5.5 0 0 0 0-1H8.97A4.5 4.5 0 0 0 3 9.26V5.75ZM6.75 8a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM9 7.5c0 .28.22.5.5.5h4a.5.5 0 0 0 0-1h-4a.5.5 0 0 0-.5.5Zm.5 2.5a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Zm-5 7c.79 0 1.51-.26 2.1-.7l2.55 2.55a.5.5 0 1 0 .7-.7L7.3 15.6A3.5 3.5 0 1 0 4.5 17Zm0-1a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5Z"]));
export const TextBulletListSquareSearchRegular = ( /*#__PURE__*/createFluentIcon('TextBulletListSquareSearchRegular', "1em", ["M5.75 3h8.5A2.75 2.75 0 0 1 17 5.75v8.5A2.75 2.75 0 0 1 14.25 17h-4.13l-1-1h5.13c.97 0 1.75-.78 1.75-1.75v-8.5C16 4.78 15.22 4 14.25 4h-8.5C4.78 4 4 4.78 4 5.75v3.28c-.35.04-.68.11-1 .23V5.75A2.75 2.75 0 0 1 5.75 3ZM9.5 14a.5.5 0 0 1 0-1h4a.5.5 0 0 1 0 1h-4Zm-2-6.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm2-.25a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Zm0 3a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Zm-5 7c.79 0 1.51-.26 2.1-.7l2.55 2.55a.5.5 0 1 0 .7-.7L7.3 15.6A3.5 3.5 0 1 0 4.5 17Zm0-1a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5Z"]));
export const TextBulletListSquareSettingsFilled = ( /*#__PURE__*/createFluentIcon('TextBulletListSquareSettingsFilled', "1em", ["M3 5.75A2.75 2.75 0 0 1 5.75 3h8.5A2.75 2.75 0 0 1 17 5.75V9.6a5.48 5.48 0 0 0-5.66.4H9.5a.5.5 0 0 0 0 1h.76a5.48 5.48 0 0 0-.66 6H5.75A2.75 2.75 0 0 1 3 14.25v-8.5ZM6.75 8a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0ZM6.75 14a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM9 7.5c0 .28.22.5.5.5h4a.5.5 0 0 0 0-1h-4a.5.5 0 0 0-.5.5Zm3.07 3.94a2 2 0 0 1-1.43 2.48l-.47.12a4.7 4.7 0 0 0 .01 1.01l.35.09A2 2 0 0 1 12 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.15-.55a2 2 0 0 1 1.43-2.48l.46-.12a4.73 4.73 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 17 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.3.13-.57.3-.82.5l.16.55Zm2.43 4.06a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const TextBulletListSquareSettingsRegular = ( /*#__PURE__*/createFluentIcon('TextBulletListSquareSettingsRegular', "1em", ["M5.75 3h8.5A2.75 2.75 0 0 1 17 5.75V9.6c-.32-.16-.65-.3-1-.4V5.76C16 4.78 15.22 4 14.25 4h-8.5C4.78 4 4 4.78 4 5.75v8.5c0 .97.78 1.75 1.75 1.75h3.46c.1.35.23.68.39 1H5.75A2.75 2.75 0 0 1 3 14.25v-8.5A2.75 2.75 0 0 1 5.75 3Zm3.75 7h1.84c-.4.28-.77.62-1.08 1H9.5a.5.5 0 0 1 0-1ZM6.75 8a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm0 3a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM9 7.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm3.07 3.94a2 2 0 0 1-1.43 2.48l-.47.12a4.7 4.7 0 0 0 .01 1.01l.35.09A2 2 0 0 1 12 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.15-.55a2 2 0 0 1 1.43-2.48l.46-.12a4.73 4.73 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 17 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.3.13-.57.3-.82.5l.16.55Zm2.43 4.06a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const TextBulletListSquareShieldFilled = ( /*#__PURE__*/createFluentIcon('TextBulletListSquareShieldFilled', "1em", ["M14.12 9.96c.2-.19.56-.19.76 0 .5.49 1.48 1.26 2.68 1.41.24.04.44.22.44.44v2.11c0 2.84-2.78 3.87-3.39 4.06a.37.37 0 0 1-.22 0c-.6-.19-3.39-1.22-3.39-4.06v-2.1c0-.23.2-.41.44-.45a5.07 5.07 0 0 0 2.68-1.4ZM14.25 3A2.75 2.75 0 0 1 17 5.75v4.44c-.49-.2-.92-.5-1.24-.78l-.19-.17-.11-.1a1.58 1.58 0 0 0-1.92 0l-.11.1a5.1 5.1 0 0 1-1.03.76H9.5a.5.5 0 0 0 0 1h.76c-.13.18-.22.4-.25.66l-.01.15V13h-.5a.5.5 0 0 0 0 1h.5c.02 1.28.5 2.27 1.1 3H5.76A2.75 2.75 0 0 1 3 14.25v-8.5A2.75 2.75 0 0 1 5.75 3h8.5Zm-7.5 9.5a.75.75 0 1 0 0 1.5.75.75 0 0 0 0-1.5Zm0-3a.75.75 0 1 0 0 1.5.75.75 0 0 0 0-1.5Zm0-3a.75.75 0 1 0 0 1.5.75.75 0 0 0 0-1.5ZM9.5 7a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Z"]));
export const TextBulletListSquareShieldRegular = ( /*#__PURE__*/createFluentIcon('TextBulletListSquareShieldRegular', "1em", ["M14.12 9.96c.2-.19.56-.19.76 0 .5.49 1.48 1.26 2.68 1.41.24.04.44.22.44.44v2.11c0 2.84-2.78 3.87-3.39 4.06a.37.37 0 0 1-.22 0c-.6-.19-3.39-1.22-3.39-4.06v-2.1c0-.23.2-.41.44-.45a5.07 5.07 0 0 0 2.68-1.4ZM14.25 3A2.75 2.75 0 0 1 17 5.75v4.44a4.32 4.32 0 0 1-1-.58V5.75C16 4.78 15.22 4 14.25 4h-8.5C4.78 4 4 4.78 4 5.75v8.5c0 .97.78 1.75 1.75 1.75h4.71c.18.38.4.7.65 1H5.75A2.75 2.75 0 0 1 3 14.25v-8.5A2.75 2.75 0 0 1 5.75 3h8.5Zm-7.5 9.5a.75.75 0 1 1 0 1.5.75.75 0 0 1 0-1.5ZM10 13.92V14h-.5a.5.5 0 0 1 0-1h.5v.92ZM6.75 9.5a.75.75 0 1 1 0 1.5.75.75 0 0 1 0-1.5Zm5.65.5c-.28.16-.6.29-.93.36l-.27.04c-.34.07-.7.28-.94.6H9.5a.5.5 0 0 1 0-1h2.9ZM6.75 6.5a.75.75 0 1 1 0 1.5.75.75 0 0 1 0-1.5Zm6.75.5a.5.5 0 0 1 0 1h-4a.5.5 0 0 1 0-1h4Z"]));
export const TextBulletListSquareSparkleColor = ( /*#__PURE__*/createFluentIcon('TextBulletListSquareSparkleColor', "1em", `<path d="M5.75 3h8.5A2.75 2.75 0 0 1 17 5.75v8.5A2.75 2.75 0 0 1 14.25 17h-8.5A2.75 2.75 0 0 1 3 14.25v-8.5A2.75 2.75 0 0 1 5.75 3Z" fill="url(#ic_fluent_text_bullet_list_square_sparkle_20_color__a)"/><path d="M6.75 8a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM6.75 14a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM9 7.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm.5 2.5a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4ZM9 13.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z" fill="url(#ic_fluent_text_bullet_list_square_sparkle_20_color__b)"/><path d="M5.75 3h8.5A2.75 2.75 0 0 1 17 5.75v8.5A2.75 2.75 0 0 1 14.25 17h-8.5A2.75 2.75 0 0 1 3 14.25v-8.5A2.75 2.75 0 0 1 5.75 3Z" fill="url(#ic_fluent_text_bullet_list_square_sparkle_20_color__c)"/><path d="M5.75 3h8.5A2.75 2.75 0 0 1 17 5.75v8.5A2.75 2.75 0 0 1 14.25 17h-8.5A2.75 2.75 0 0 1 3 14.25v-8.5A2.75 2.75 0 0 1 5.75 3Z" fill="url(#ic_fluent_text_bullet_list_square_sparkle_20_color__d)"/><path d="M5.75 3h8.5A2.75 2.75 0 0 1 17 5.75v8.5A2.75 2.75 0 0 1 14.25 17h-8.5A2.75 2.75 0 0 1 3 14.25v-8.5A2.75 2.75 0 0 1 5.75 3Z" fill="url(#ic_fluent_text_bullet_list_square_sparkle_20_color__e)"/><path d="M5.75 3h8.5A2.75 2.75 0 0 1 17 5.75v8.5A2.75 2.75 0 0 1 14.25 17h-8.5A2.75 2.75 0 0 1 3 14.25v-8.5A2.75 2.75 0 0 1 5.75 3Z" fill="url(#ic_fluent_text_bullet_list_square_sparkle_20_color__f)"/><path d="m18.78 8.21-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02Z" fill="url(#ic_fluent_text_bullet_list_square_sparkle_20_color__g)"/><path d="m13.88.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.23 2.23 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Z" fill="url(#ic_fluent_text_bullet_list_square_sparkle_20_color__h)"/><defs><radialGradient id="ic_fluent_text_bullet_list_square_sparkle_20_color__c" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(.03125 3.75 -1.87278 .0156 16.47 9.44)"><stop stop-color="#4A43CB"/><stop offset="1" stop-color="#4A43CB" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_text_bullet_list_square_sparkle_20_color__d" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(-.0625 4.65625 -2.32538 -.03121 13.53 4.13)"><stop stop-color="#4A43CB"/><stop offset="1" stop-color="#4A43CB" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_text_bullet_list_square_sparkle_20_color__e" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(-4.40625 0 0 -2.20052 13.53 4.13)"><stop stop-color="#4A43CB"/><stop offset="1" stop-color="#4A43CB" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_text_bullet_list_square_sparkle_20_color__f" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(-3.1875 0 0 -1.59187 16.56 9.13)"><stop stop-color="#4A43CB"/><stop offset="1" stop-color="#4A43CB" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_text_bullet_list_square_sparkle_20_color__g" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(12.82142 25.58036 -19.91881 9.98373 5.38 -12.81)"><stop offset=".72" stop-color="#FFCD0F"/><stop offset=".99" stop-color="#E67505"/></radialGradient><radialGradient id="ic_fluent_text_bullet_list_square_sparkle_20_color__h" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(61.2 15.56 -7.7) scale(30.098 23.4366)"><stop offset=".7" stop-color="#FFCD0F"/><stop offset=".99" stop-color="#E67505"/></radialGradient><linearGradient id="ic_fluent_text_bullet_list_square_sparkle_20_color__a" x1="3.5" y1="5.63" x2="13.16" y2="15.66" gradientUnits="userSpaceOnUse"><stop stop-color="#0FAFFF"/><stop offset="1" stop-color="#2764E7"/></linearGradient><linearGradient id="ic_fluent_text_bullet_list_square_sparkle_20_color__b" x1="7.54" y1="7.08" x2="12.8" y2="20.67" gradientUnits="userSpaceOnUse"><stop stop-color="#fff"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient></defs>`, { color: true }));
export const TextBulletListSquareSparkleFilled = ( /*#__PURE__*/createFluentIcon('TextBulletListSquareSparkleFilled', "1em", ["m13.88.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.23 2.23 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Zm4.9 7.93-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02Zm-3.02 3.56a1.4 1.4 0 0 1-.48-.62l-.26-.8a.52.52 0 0 0-.14-.22.64.64 0 0 0-.22-.14l-.77-.25c-.27-.1-.49-.26-.65-.48A1.31 1.31 0 0 1 13.1 8H9.5a.5.5 0 0 1 0-1h2.64l-.35-1.04a1.27 1.27 0 0 0-.29-.47 1.3 1.3 0 0 0-.47-.3l-1.06-.34A1.41 1.41 0 0 1 9 3.5c0-.18.03-.34.09-.5H5.75A2.75 2.75 0 0 0 3 5.75v8.5A2.75 2.75 0 0 0 5.75 17h8.5A2.75 2.75 0 0 0 17 14.25v-2.33c-.16.06-.33.08-.5.08-.27 0-.53-.08-.74-.23ZM7.5 7.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM6.75 9.5a.75.75 0 1 1 0 1.5.75.75 0 0 1 0-1.5Zm.75 3.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM9 10.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm.5 3.5a.5.5 0 0 1 0-1h4a.5.5 0 0 1 0 1h-4Z"]));
export const TextBulletListSquareSparkleRegular = ( /*#__PURE__*/createFluentIcon('TextBulletListSquareSparkleRegular', "1em", ["m13.88.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.23 2.23 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Zm4.9 7.93-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02ZM16 11.91c.16.06.33.09.5.09.17 0 .34-.02.5-.08v2.33A2.75 2.75 0 0 1 14.25 17h-8.5A2.75 2.75 0 0 1 3 14.25v-8.5A2.75 2.75 0 0 1 5.75 3h3.34a1.42 1.42 0 0 0 0 1H5.75C4.78 4 4 4.78 4 5.75v8.5c0 .97.78 1.75 1.75 1.75h8.5c.97 0 1.75-.78 1.75-1.75V11.9ZM12.14 7l.01.05c.1.25.25.48.52.7.14.1.3.16.45.2L13.1 8H9.5a.5.5 0 0 1 0-1h2.64ZM6.75 8a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm0 3a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM9 10.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm0 3c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z"]));
export const TextBulletListSquareToolboxFilled = ( /*#__PURE__*/createFluentIcon('TextBulletListSquareToolboxFilled', "1em", ["M3 5.75A2.75 2.75 0 0 1 5.75 3h8.5A2.75 2.75 0 0 1 17 5.75V9.5c-.42-.31-.94-.5-1.5-.5h-2c-.82 0-1.54.4-2 1h-2a.5.5 0 0 0 0 1h1.55v.04A2.5 2.5 0 0 0 9 13.5V17H5.75A2.75 2.75 0 0 1 3 14.25v-8.5ZM6.75 8a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0ZM6.75 14a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM9 7.5c0 .28.22.5.5.5h4a.5.5 0 0 0 0-1h-4a.5.5 0 0 0-.5.5Zm3 4.5v-.5c0-.83.67-1.5 1.5-1.5h2c.83 0 1.5.67 1.5 1.5v.5h.5c.83 0 1.5.67 1.5 1.5V15h-2v-.5a.5.5 0 0 0-1 0v.5h-3v-.5a.5.5 0 0 0-1 0v.5h-2v-1.5c0-.83.67-1.5 1.5-1.5h.5Zm1-.5v.5h3v-.5a.5.5 0 0 0-.5-.5h-2a.5.5 0 0 0-.5.5Zm4 4.5h2v1.5c0 .83-.67 1.5-1.5 1.5h-6a1.5 1.5 0 0 1-1.5-1.5V16h2v.5a.5.5 0 0 0 1 0V16h3v.5a.5.5 0 0 0 1 0V16Z"]));
export const TextBulletListSquareToolboxRegular = ( /*#__PURE__*/createFluentIcon('TextBulletListSquareToolboxRegular', "1em", ["M5.75 3h8.5A2.75 2.75 0 0 1 17 5.75V9.5c-.3-.22-.63-.38-1-.45v-3.3C16 4.78 15.22 4 14.25 4h-8.5C4.78 4 4 4.78 4 5.75v8.5c0 .97.78 1.75 1.75 1.75H9v1H5.75A2.75 2.75 0 0 1 3 14.25v-8.5A2.75 2.75 0 0 1 5.75 3Zm3.75 7h2c-.22.3-.38.63-.45 1H9.5a.5.5 0 0 1 0-1Zm-2-2.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM6.75 11a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm0 3a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM9.5 7a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Zm2.5 5v-.5c0-.83.67-1.5 1.5-1.5h2c.83 0 1.5.67 1.5 1.5v.5h.5c.83 0 1.5.67 1.5 1.5V15h-2v-.5a.5.5 0 0 0-1 0v.5h-3v-.5a.5.5 0 0 0-1 0v.5h-2v-1.5c0-.83.67-1.5 1.5-1.5h.5Zm1-.5v.5h3v-.5a.5.5 0 0 0-.5-.5h-2a.5.5 0 0 0-.5.5Zm4 4.5h2v1.5c0 .83-.67 1.5-1.5 1.5h-6a1.5 1.5 0 0 1-1.5-1.5V16h2v.5a.5.5 0 0 0 1 0V16h3v.5a.5.5 0 0 0 1 0V16Z"]));
export const TextBulletListSquareWarningFilled = ( /*#__PURE__*/createFluentIcon('TextBulletListSquareWarningFilled', "1em", ["M3 5.75A2.75 2.75 0 0 1 5.75 3h8.5A2.75 2.75 0 0 1 17 5.75v5.77l-.7-1.41a2 2 0 0 0-3.53-.11H9.5a.5.5 0 0 0 0 1h2.77l-1 2H9.5a.5.5 0 0 0 0 1h1.27l-1.5 3H5.75A2.75 2.75 0 0 1 3 14.25v-8.5ZM6.75 8a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0ZM6.75 14a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM9 7.5c0 .28.22.5.5.5h4a.5.5 0 0 0 0-1h-4a.5.5 0 0 0-.5.5Zm4.6 3.05a1 1 0 0 1 1.8 0l3.5 7A1 1 0 0 1 18 19h-7a1 1 0 0 1-.9-1.45l3.5-7ZM15 12.5a.5.5 0 1 0-1 0v3a.5.5 0 1 0 1 0v-3Zm-.5 5.5a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1Z"]));
export const TextBulletListSquareWarningRegular = ( /*#__PURE__*/createFluentIcon('TextBulletListSquareWarningRegular', "1em", ["M6.75 8a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM6.75 14a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM9 7.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm.5 2.5a.5.5 0 0 0 0 1h2.77l.44-.9.06-.1H9.5Zm0 3h1.77l-.5 1H9.5a.5.5 0 0 1 0-1Zm-3.75 3h4.02l-.5 1H5.75A2.75 2.75 0 0 1 3 14.25v-8.5A2.75 2.75 0 0 1 5.75 3h8.5A2.75 2.75 0 0 1 17 5.75v5.77l-.7-1.41a2.05 2.05 0 0 0-.3-.44V5.75C16 4.78 15.22 4 14.25 4h-8.5C4.78 4 4 4.78 4 5.75v8.5c0 .97.78 1.75 1.75 1.75Zm7.85-5.45a1 1 0 0 1 1.8 0l3.5 7A1 1 0 0 1 18 19h-7a1 1 0 0 1-.9-1.45l3.5-7ZM15 12.5a.5.5 0 1 0-1 0v3a.5.5 0 1 0 1 0v-3Zm-.5 5.5a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1Z"]));
export const TextBulletListTreeFilled = ( /*#__PURE__*/createFluentIcon('TextBulletListTreeFilled', "1em", ["M3.25 6a1.25 1.25 0 1 0 0-2.5 1.25 1.25 0 0 0 0 2.5ZM7 4.75c0-.41.34-.75.75-.75h9.5a.75.75 0 0 1 0 1.5h-9.5A.75.75 0 0 1 7 4.75ZM7.75 9a.75.75 0 0 0 0 1.5h9.5a.75.75 0 0 0 0-1.5h-9.5Zm4 5a.75.75 0 0 0 0 1.5h5.5a.75.75 0 0 0 0-1.5h-5.5ZM4.5 9.75a1.25 1.25 0 1 1-2.5 0 1.25 1.25 0 0 1 2.5 0ZM7.25 16a1.25 1.25 0 1 0 0-2.5 1.25 1.25 0 0 0 0 2.5Z"]));
export const TextBulletListTreeRegular = ( /*#__PURE__*/createFluentIcon('TextBulletListTreeRegular', "1em", ["M3 5.5a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm3-1c0-.28.22-.5.5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Zm0 5c0-.28.22-.5.5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Zm4.5 4.5a.5.5 0 0 0 0 1h7a.5.5 0 0 0 0-1h-7Zm-2.5.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-5-4a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"]));
export const TextCaseLowercaseFilled = ( /*#__PURE__*/createFluentIcon('TextCaseLowercaseFilled', "1em", ["M11.75 3.25c.41 0 .75.34.75.75v4.66C13 8.24 13.6 8 14.25 8c1.66 0 3 1.57 3 3.5s-1.34 3.5-3 3.5c-.65 0-1.26-.24-1.75-.66v.16a.75.75 0 0 1-1.5 0V4c0-.41.33-.75.75-.75Zm2.5 10.25c.62 0 1.5-.67 1.5-2s-.88-2-1.5-2-1.5.67-1.5 2 .88 2 1.5 2Zm-8.6-4.56a2.8 2.8 0 0 0-1.07.23.75.75 0 0 1-.67-1.34 4.26 4.26 0 0 1 1.69-.4c.62-.02 1.34.08 1.98.4C9 8.54 9 9.95 9 10.46v4.04a.75.75 0 0 1-1.5.06c-.87.53-1.89.85-2.94.57a2.61 2.61 0 0 1-.73-4.75c.78-.52 1.7-.66 2.53-.61a6 6 0 0 1 1.1.16.97.97 0 0 0-.55-.76c-.35-.18-.8-.25-1.26-.23ZM7.5 11.5a4.5 4.5 0 0 0-1.22-.24c-.63-.03-1.2.09-1.62.36-.92.62-.64 1.8.28 2.06.75.2 1.67-.19 2.56-1V11.5Z"]));
export const TextCaseLowercaseRegular = ( /*#__PURE__*/createFluentIcon('TextCaseLowercaseRegular', "1em", ["M11.5 3.5c.28 0 .5.22.5.5v4.9c.53-.56 1.23-.9 2-.9 1.66 0 3 1.57 3 3.5S15.66 15 14 15c-.77 0-1.47-.34-2-.9v.4a.5.5 0 0 1-1 0V4c0-.28.22-.5.5-.5ZM14 14c.97 0 2-.97 2-2.5S14.97 9 14 9s-2 .97-2 2.5 1.03 2.5 2 2.5ZM5.9 8.69c-.5.02-.92.13-1.18.26a.5.5 0 1 1-.44-.9c.4-.2.98-.34 1.58-.36.6-.03 1.27.07 1.86.36C9 8.7 9 9.96 9 10.46v4.04a.5.5 0 0 1-1 0v-.41c-.91.66-2.01 1.1-3.13.8a2.36 2.36 0 0 1-.65-4.3c.72-.48 1.59-.61 2.38-.57.49.02.97.11 1.4.25-.02-.48-.12-1.02-.72-1.32-.4-.2-.9-.28-1.39-.26ZM8 11.33c-.4-.17-.92-.29-1.45-.32-.66-.03-1.3.09-1.77.4-1.12.75-.77 2.21.35 2.5.9.25 1.94-.24 2.87-1.12v-1.46Z"]));
export const TextCaseTitleFilled = ( /*#__PURE__*/createFluentIcon('TextCaseTitleFilled', "1em", ["M12.5 3.25c.41 0 .75.34.75.75v4.66c.5-.42 1.1-.66 1.75-.66 1.66 0 3 1.57 3 3.5S16.66 15 15 15c-.65 0-1.26-.24-1.75-.66v.16a.75.75 0 0 1-1.5 0V4c0-.41.34-.75.75-.75ZM15 13.5c.62 0 1.5-.67 1.5-2s-.88-2-1.5-2-1.5.67-1.5 2 .88 2 1.5 2ZM6.5 3.25c.31 0 .59.2.7.5l3.64 10.5a.75.75 0 1 1-1.41.5l-.78-2.25H4.06l-.86 2.27a.75.75 0 0 1-1.4-.54l3.98-10.5c.12-.3.4-.48.71-.48ZM4.62 11h3.5L6.45 6.2 4.63 11Z"]));
export const TextCaseTitleRegular = ( /*#__PURE__*/createFluentIcon('TextCaseTitleRegular', "1em", ["M12.5 3.5c.28 0 .5.22.5.5v4.9c.53-.56 1.23-.9 2-.9 1.66 0 3 1.57 3 3.5S16.66 15 15 15c-.77 0-1.47-.34-2-.9v.4a.5.5 0 0 1-1 0V4c0-.28.22-.5.5-.5ZM15 14c.97 0 2-.97 2-2.5S15.97 9 15 9s-2 .97-2 2.5 1.03 2.5 2 2.5ZM6.96 3.84a.5.5 0 0 0-.94-.02L3.29 11h-.02v.05l-1.24 3.27a.5.5 0 0 0 .94.36L3.98 12h4.76l.92 2.66a.5.5 0 1 0 .95-.32L6.96 3.84ZM4.36 11l2.1-5.54L8.4 11H4.36Z"]));
export const TextCaseUppercaseFilled = ( /*#__PURE__*/createFluentIcon('TextCaseUppercaseFilled', "1em", ["M6.5 3.25c.31 0 .59.2.7.5l3.64 10.5a.75.75 0 1 1-1.41.5l-.78-2.25H4.06l-.86 2.27a.75.75 0 0 1-1.4-.54l3.98-10.5c.12-.3.4-.48.71-.48ZM4.62 11h3.5L6.45 6.2 4.63 11ZM12 3.5a.75.75 0 0 0-.75.75V14.5c0 .41.34.75.75.75h2.75a3.5 3.5 0 0 0 1.71-6.55 3.12 3.12 0 0 0-2.34-5.2H12Zm3.75 3.13c0 .9-.73 1.62-1.63 1.62h-1.37V5h1.38c.9 0 1.62.73 1.62 1.63Zm-1 7.12h-2v-4h2a2 2 0 1 1 0 4Z"]));
export const TextCaseUppercaseRegular = ( /*#__PURE__*/createFluentIcon('TextCaseUppercaseRegular', "1em", ["M6.96 3.84a.5.5 0 0 0-.94-.02L3.29 11h-.02v.05l-1.24 3.27a.5.5 0 0 0 .94.36L3.98 12h4.76l.92 2.66a.5.5 0 1 0 .95-.32L6.96 3.84ZM4.36 11l2.1-5.54L8.4 11H4.36Zm7.14-7.25a.5.5 0 0 0-.5.5V14.5c0 .28.22.5.5.5h2.75a3.25 3.25 0 0 0 1.3-6.23 2.87 2.87 0 0 0-1.93-5.02H11.5Zm4 2.88c0 1.03-.84 1.87-1.88 1.87H12V4.75h1.63c1.03 0 1.87.84 1.87 1.88ZM14.25 14H12V9.5h2.25a2.25 2.25 0 0 1 0 4.5Z"]));
export const TextChangeCaseFilled = ( /*#__PURE__*/createFluentIcon('TextChangeCaseFilled', "1em", ["M13.5 3.25c.3 0 .59.2.7.5l3.64 10.5a.75.75 0 0 1-1.41.5l-.78-2.25h-4.59l-.86 2.27a.75.75 0 1 1-1.4-.54l3.98-10.5c.11-.3.4-.48.71-.48ZM11.62 11h3.5l-1.68-4.8-1.82 4.8ZM4.9 8.94a2.8 2.8 0 0 0-1.07.23.75.75 0 0 1-.67-1.34 4.26 4.26 0 0 1 1.69-.4c.62-.02 1.34.08 1.98.4 1.42.71 1.42 2.12 1.42 2.63v4.04a.75.75 0 0 1-1.5.06c-.87.53-1.89.85-2.94.57a2.61 2.61 0 0 1-.73-4.75c.78-.52 1.7-.66 2.53-.61a6 6 0 0 1 1.1.16.97.97 0 0 0-.55-.76c-.35-.18-.8-.25-1.26-.23Zm1.85 2.56a4.51 4.51 0 0 0-1.22-.24c-.63-.03-1.2.09-1.62.36-.92.62-.64 1.8.28 2.06.75.2 1.67-.19 2.56-1V11.5Z"]));
export const TextChangeCaseRegular = ( /*#__PURE__*/createFluentIcon('TextChangeCaseRegular', "1em", ["M13.5 3.5c.2 0 .39.14.46.34l3.65 10.5a.5.5 0 0 1-.95.32L15.74 12h-4.76l-1.01 2.68a.5.5 0 0 1-.93.01l.24-1.03 1-2.6V11h.01l2.73-7.18a.5.5 0 0 1 .47-.32Zm-.04 1.96L11.36 11h4.03l-1.93-5.54ZM4.9 8.7c-.48.02-.9.13-1.17.26a.5.5 0 0 1-.44-.9c.4-.2.98-.34 1.58-.36.6-.03 1.27.07 1.86.36C8 8.7 8 9.96 8 10.46v4.04a.5.5 0 0 1-1 0v-.41c-.91.66-2.01 1.1-3.13.8a2.36 2.36 0 0 1-.65-4.3c.72-.48 1.59-.61 2.38-.57.49.02.97.11 1.4.25-.02-.48-.12-1.02-.72-1.32-.4-.2-.9-.28-1.39-.26ZM7 11.33c-.4-.17-.92-.29-1.45-.32-.66-.03-1.3.09-1.77.4-1.12.75-.77 2.21.35 2.5.9.25 1.94-.24 2.87-1.12v-1.46Z"]));
export const TextClearFormattingFilled = ( /*#__PURE__*/createFluentIcon('TextClearFormattingFilled', "1em", ["M6 2c.2 0 .4.13.47.32l3.5 8.95a.5.5 0 0 1-.94.37L8.01 9H4l-1.04 2.68a.5.5 0 1 1-.94-.36l3.5-9A.5.5 0 0 1 6 2Zm0 1.88L4.4 8H7.6l-1.6-4.12ZM11.5 2c.28 0 .5.22.5.5v3.52a2.48 2.48 0 0 1 2.26-1.3c.89 0 1.6.34 2.15 1 .55.66.82 1.54.82 2.64l-.01.42-.05-.05a2.49 2.49 0 0 0-1.15-.65 2.86 2.86 0 0 0-.53-1.62c-.36-.47-.86-.7-1.48-.7-.6 0-1.09.24-1.47.72-.3.37-.47.83-.54 1.37v1.03c.05.43.18.8.37 1.12L11 11.37V2.5c0-.28.22-.5.5-.5Zm4.97 7.44 2.1 2.1a1.5 1.5 0 0 1-.01 2.12l-3.6 3.6-4.21-4.22 3.6-3.6a1.5 1.5 0 0 1 2.12 0Zm-2.22 8.52-4.21-4.21-.6.6a1.5 1.5 0 0 0 0 2.12l2.1 2.1c.3.3.71.45 1.12.43h4.09a.5.5 0 1 0 0-1h-2.53l.03-.04Z"]));
export const TextClearFormattingRegular = ( /*#__PURE__*/createFluentIcon('TextClearFormattingRegular', "1em", ["M6 2c.2 0 .4.13.47.32l3.5 8.95a.5.5 0 0 1-.94.37L8.01 9H4l-1.04 2.68a.5.5 0 1 1-.94-.36l3.5-9A.5.5 0 0 1 6 2Zm0 1.88L4.4 8H7.6l-1.6-4.12ZM11.5 2c.28 0 .5.22.5.5v3.52a2.48 2.48 0 0 1 2.26-1.3c.89 0 1.6.34 2.15 1 .55.66.82 1.54.82 2.64l-.01.42-.05-.05a2.49 2.49 0 0 0-1.15-.65 2.86 2.86 0 0 0-.53-1.62c-.36-.47-.86-.7-1.48-.7-.6 0-1.09.24-1.47.72-.3.37-.47.83-.54 1.37v1.03c.05.43.18.8.37 1.12L11 11.37V2.5c0-.28.22-.5.5-.5ZM9.44 16.47a1.5 1.5 0 0 1 0-2.13l4.9-4.9a1.5 1.5 0 0 1 2.13 0l2.1 2.1a1.5 1.5 0 0 1-.01 2.12L14.22 18h2.53a.5.5 0 1 1 0 1h-4.1a1.5 1.5 0 0 1-1.12-.44l-2.1-2.1Zm5.61-6.32-3.6 3.6 2.8 2.8 3.6-3.6a.5.5 0 0 0 0-.7l-2.1-2.1a.5.5 0 0 0-.7 0Zm-1.5 7.1-2.8-2.8-.6.6a.5.5 0 0 0 0 .7l2.1 2.1c.19.2.5.2.7 0l.6-.6Z"]));
export const TextCollapseFilled = ( /*#__PURE__*/createFluentIcon('TextCollapseFilled', "1em", ["M5 3.5c0-.41.34-.75.75-.75h11.5a.75.75 0 0 1 0 1.5H5.75A.75.75 0 0 1 5 3.5Zm0 12c0-.41.34-.75.75-.75h11.5a.75.75 0 0 1 0 1.5H5.75A.75.75 0 0 1 5 15.5Zm6.75-8.75a.75.75 0 0 0 0 1.5h5.5a.75.75 0 0 0 0-1.5h-5.5ZM11 11.5c0-.41.34-.75.75-.75h5.5a.75.75 0 0 1 0 1.5h-5.5a.75.75 0 0 1-.75-.75Zm-2-2a3.5 3.5 0 1 1-7 0 3.5 3.5 0 0 1 7 0Zm-6 0c0 .28.22.5.5.5h4a.5.5 0 0 0 0-1h-4a.5.5 0 0 0-.5.5Z"]));
export const TextCollapseRegular = ( /*#__PURE__*/createFluentIcon('TextCollapseRegular', "1em", ["M5 3.5c0-.28.22-.5.5-.5h12a.5.5 0 0 1 0 1h-12a.5.5 0 0 1-.5-.5Zm0 12c0-.28.22-.5.5-.5h12a.5.5 0 0 1 0 1h-12a.5.5 0 0 1-.5-.5Zm6-8c0-.28.22-.5.5-.5h6a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5Zm0 4c0-.28.22-.5.5-.5h6a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5Zm-2-2a3.5 3.5 0 1 1-7 0 3.5 3.5 0 0 1 7 0ZM3.5 9a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Z"]));
export const TextColorFilled = ( /*#__PURE__*/createFluentIcon('TextColorFilled', "1em", `<path d="M10.46 2.31a.5.5 0 0 0-.92 0l-3 7.5a.5.5 0 1 0 .92.38L8.54 7.5h2.92l1.08 2.69a.5.5 0 1 0 .92-.38l-3-7.5ZM10 3.85l1.06 2.65H8.94L10 3.85ZM4.5 12c-.83 0-1.5.67-1.5 1.5v3c0 .83.67 1.5 1.5 1.5h11c.83 0 1.5-.67 1.5-1.5v-3c0-.83-.67-1.5-1.5-1.5h-11Z" fill="#212121"/>`, { color: true }));
export const TextColorRegular = ( /*#__PURE__*/createFluentIcon('TextColorRegular', "1em", `<path d="M10.46 2.31a.5.5 0 0 0-.92 0l-3 7.5a.5.5 0 1 0 .92.38L8.54 7.5h2.92l1.08 2.69a.5.5 0 1 0 .92-.38l-3-7.5ZM10 3.85l1.06 2.65H8.94L10 3.85ZM4.5 12c-.83 0-1.5.67-1.5 1.5v3c0 .83.67 1.5 1.5 1.5h11c.83 0 1.5-.67 1.5-1.5v-3c0-.83-.67-1.5-1.5-1.5h-11ZM4 13.5c0-.28.22-.5.5-.5h11c.28 0 .5.22.5.5v3a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-3Z" fill="#212121"/>`, { color: true }));
export const TextColorAccentFilled = ( /*#__PURE__*/createFluentIcon('TextColorAccentFilled', "1em", `<path d="M3.5 13.13c0-.35.24-.63.54-.63h11.92c.3 0 .54.28.54.63v3.74c0 .35-.24.63-.54.63H4.04c-.3 0-.54-.28-.54-.63v-3.75Z" fill="#212121"/>`, { color: true }));
export const TextColumnOneFilled = ( /*#__PURE__*/createFluentIcon('TextColumnOneFilled', "1em", ["M15 5.75a.75.75 0 0 0-.75-.75h-8.5a.75.75 0 0 0 0 1.5h8.5c.41 0 .75-.34.75-.75Zm0 3a.75.75 0 0 0-.75-.75h-8.5a.75.75 0 0 0 0 1.5h8.5c.41 0 .75-.34.75-.75Zm0 3a.75.75 0 0 0-.75-.75h-8.5a.75.75 0 0 0 0 1.5h8.5c.41 0 .75-.34.75-.75Zm0 3a.75.75 0 0 0-.75-.75h-8.5a.75.75 0 0 0 0 1.5h8.5c.41 0 .75-.34.75-.75Z"]));
export const TextColumnOneRegular = ( /*#__PURE__*/createFluentIcon('TextColumnOneRegular', "1em", ["M15 5.5a.5.5 0 0 0-.5-.5h-9a.5.5 0 0 0 0 1h9a.5.5 0 0 0 .5-.5Zm0 3a.5.5 0 0 0-.5-.5h-9a.5.5 0 0 0 0 1h9a.5.5 0 0 0 .5-.5Zm0 3a.5.5 0 0 0-.5-.5h-9a.5.5 0 0 0 0 1h9a.5.5 0 0 0 .5-.5Zm0 3a.5.5 0 0 0-.5-.5h-9a.5.5 0 0 0 0 1h9a.5.5 0 0 0 .5-.5Z"]));
export const TextColumnOneNarrowFilled = ( /*#__PURE__*/createFluentIcon('TextColumnOneNarrowFilled', "1em", ["M7.75 5a.75.75 0 0 0 0 1.5h4.5a.75.75 0 0 0 0-1.5h-4.5Zm0 3a.75.75 0 0 0 0 1.5h4.5a.75.75 0 0 0 0-1.5h-4.5ZM7 11.75c0-.41.34-.75.75-.75h4.5a.75.75 0 0 1 0 1.5h-4.5a.75.75 0 0 1-.75-.75ZM7.75 14a.75.75 0 0 0 0 1.5h4.5a.75.75 0 0 0 0-1.5h-4.5Z"]));
export const TextColumnOneNarrowRegular = ( /*#__PURE__*/createFluentIcon('TextColumnOneNarrowRegular', "1em", ["M7.5 5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5Zm0 3a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5ZM7 11.5c0-.28.22-.5.5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5Zm.5 2.5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5Z"]));
export const TextColumnOneSemiNarrowFilled = ( /*#__PURE__*/createFluentIcon('TextColumnOneSemiNarrowFilled', "1em", ["M6.75 5a.75.75 0 0 0 0 1.5h6.5a.75.75 0 0 0 0-1.5h-6.5Zm0 3a.75.75 0 0 0 0 1.5h6.5a.75.75 0 0 0 0-1.5h-6.5ZM6 11.75c0-.41.34-.75.75-.75h6.5a.75.75 0 0 1 0 1.5h-6.5a.75.75 0 0 1-.75-.75ZM6.75 14a.75.75 0 0 0 0 1.5h6.5a.75.75 0 0 0 0-1.5h-6.5Z"]));
export const TextColumnOneSemiNarrowRegular = ( /*#__PURE__*/createFluentIcon('TextColumnOneSemiNarrowRegular', "1em", ["M6.5 5a.5.5 0 0 0 0 1h7a.5.5 0 0 0 0-1h-7Zm0 3a.5.5 0 0 0 0 1h7a.5.5 0 0 0 0-1h-7ZM6 11.5c0-.28.22-.5.5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5Zm.5 2.5a.5.5 0 0 0 0 1h7a.5.5 0 0 0 0-1h-7Z"]));
export const TextColumnOneWideFilled = ( /*#__PURE__*/createFluentIcon('TextColumnOneWideFilled', "1em", ["M3.75 5a.75.75 0 0 0 0 1.5h12.5a.75.75 0 0 0 0-1.5H3.75Zm0 3a.75.75 0 0 0 0 1.5h12.5a.75.75 0 0 0 0-1.5H3.75ZM3 11.75c0-.41.34-.75.75-.75h12.5a.75.75 0 0 1 0 1.5H3.75a.75.75 0 0 1-.75-.75ZM3.75 14a.75.75 0 0 0 0 1.5h12.5a.75.75 0 0 0 0-1.5H3.75Z"]));
export const TextColumnOneWideRegular = ( /*#__PURE__*/createFluentIcon('TextColumnOneWideRegular', "1em", ["M3.5 5a.5.5 0 0 0 0 1h13a.5.5 0 0 0 0-1h-13Zm0 3a.5.5 0 0 0 0 1h13a.5.5 0 0 0 0-1h-13ZM3 11.5c0-.28.22-.5.5-.5h13a.5.5 0 0 1 0 1h-13a.5.5 0 0 1-.5-.5Zm.5 2.5a.5.5 0 0 0 0 1h13a.5.5 0 0 0 0-1h-13Z"]));
export const TextColumnOneWideLightningFilled = ( /*#__PURE__*/createFluentIcon('TextColumnOneWideLightningFilled', "1em", ["M3 5.75c0-.41.34-.75.75-.75h12.5a.75.75 0 0 1 0 1.5H3.75A.75.75 0 0 1 3 5.75Zm0 3c0-.41.34-.75.75-.75h12.5a.75.75 0 0 1 0 1.5H3.75A.75.75 0 0 1 3 8.75ZM3.75 11a.75.75 0 0 0 0 1.5h7.8l.62-1.5H3.75Zm7.17 3-.63 1.5H3.75a.75.75 0 0 1 0-1.5h7.17Zm.58 3.01h1.75l-.59 2.37c-.12.48.46.82.83.48l4.87-4.55a.75.75 0 0 0-.51-1.3h-1.1l.78-2.35a.5.5 0 0 0-.47-.66h-3.48a.5.5 0 0 0-.46.3l-2.08 5.02c-.14.33.1.7.46.7Z"]));
export const TextColumnOneWideLightningRegular = ( /*#__PURE__*/createFluentIcon('TextColumnOneWideLightningRegular', "1em", ["M3.5 5a.5.5 0 0 0 0 1h13a.5.5 0 0 0 0-1h-13Zm0 3a.5.5 0 0 0 0 1h13a.5.5 0 0 0 0-1h-13Zm0 7h7l.42-1H3.5a.5.5 0 0 0 0 1Zm8.67-4-.42 1H3.5a.5.5 0 0 1 0-1h8.67Zm-.67 6.01h1.75l-.59 2.37c-.12.48.46.82.83.48l4.87-4.55a.75.75 0 0 0-.51-1.3h-1.1l.78-2.35a.5.5 0 0 0-.47-.66h-3.48a.5.5 0 0 0-.46.3l-2.08 5.02c-.14.33.1.7.46.7Z"]));
export const TextColumnThreeFilled = ( /*#__PURE__*/createFluentIcon('TextColumnThreeFilled', "1em", ["M12 5.75a.75.75 0 0 0-.75-.75h-2.5a.75.75 0 0 0 0 1.5h2.5c.41 0 .75-.34.75-.75Zm5 0a.75.75 0 0 0-.75-.75h-2.5a.75.75 0 0 0 0 1.5h2.5c.41 0 .75-.34.75-.75Zm-10 0A.75.75 0 0 0 6.25 5h-2.5a.75.75 0 0 0 0 1.5h2.5c.41 0 .75-.34.75-.75Zm5 3a.75.75 0 0 0-.75-.75h-2.5a.75.75 0 0 0 0 1.5h2.5c.41 0 .75-.34.75-.75Zm5 0a.75.75 0 0 0-.75-.75h-2.5a.75.75 0 0 0 0 1.5h2.5c.41 0 .75-.34.75-.75Zm-10 0A.75.75 0 0 0 6.25 8h-2.5a.75.75 0 0 0 0 1.5h2.5c.41 0 .75-.34.75-.75Zm5 3a.75.75 0 0 0-.75-.75h-2.5a.75.75 0 0 0 0 1.5h2.5c.41 0 .75-.34.75-.75Zm5 0a.75.75 0 0 0-.75-.75h-2.5a.75.75 0 0 0 0 1.5h2.5c.41 0 .75-.34.75-.75Zm-10 0a.75.75 0 0 0-.75-.75h-2.5a.75.75 0 0 0 0 1.5h2.5c.41 0 .75-.34.75-.75Zm5 3a.75.75 0 0 0-.75-.75h-2.5a.75.75 0 0 0 0 1.5h2.5c.41 0 .75-.34.75-.75Zm5 0a.75.75 0 0 0-.75-.75h-2.5a.75.75 0 0 0 0 1.5h2.5c.41 0 .75-.34.75-.75Zm-10 0a.75.75 0 0 0-.75-.75h-2.5a.75.75 0 0 0 0 1.5h2.5c.41 0 .75-.34.75-.75Z"]));
export const TextColumnThreeRegular = ( /*#__PURE__*/createFluentIcon('TextColumnThreeRegular', "1em", ["M12 5.5a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 .5-.5Zm5 0a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 .5-.5Zm-10 0a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 .5-.5Zm5 3a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 .5-.5Zm5 0a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 .5-.5Zm-10 0a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 .5-.5Zm5 3a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 .5-.5Zm5 0a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 .5-.5Zm-10 0a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 .5-.5Zm5 3a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 .5-.5Zm5 0a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 .5-.5Zm-10 0a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 .5-.5Z"]));
export const TextColumnTwoFilled = ( /*#__PURE__*/createFluentIcon('TextColumnTwoFilled', "1em", ["M17 5.75a.75.75 0 0 0-.75-.75h-4.5a.75.75 0 0 0 0 1.5h4.5c.41 0 .75-.34.75-.75Zm-8 0A.75.75 0 0 0 8.25 5h-4.5a.75.75 0 0 0 0 1.5h4.5c.41 0 .75-.34.75-.75Zm8 3a.75.75 0 0 0-.75-.75h-4.5a.75.75 0 0 0 0 1.5h4.5c.41 0 .75-.34.75-.75Zm-8 0A.75.75 0 0 0 8.25 8h-4.5a.75.75 0 0 0 0 1.5h4.5c.41 0 .75-.34.75-.75Zm8 3a.75.75 0 0 0-.75-.75h-4.5a.75.75 0 0 0 0 1.5h4.5c.41 0 .75-.34.75-.75Zm-8 0a.75.75 0 0 0-.75-.75h-4.5a.75.75 0 0 0 0 1.5h4.5c.41 0 .75-.34.75-.75Zm8 3a.75.75 0 0 0-.75-.75h-4.5a.75.75 0 0 0 0 1.5h4.5c.41 0 .75-.34.75-.75Zm-8 0a.75.75 0 0 0-.75-.75h-4.5a.75.75 0 0 0 0 1.5h4.5c.41 0 .75-.34.75-.75Z"]));
export const TextColumnTwoRegular = ( /*#__PURE__*/createFluentIcon('TextColumnTwoRegular', "1em", ["M17 5.5a.5.5 0 0 0-.5-.5h-5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 .5-.5Zm-8 0a.5.5 0 0 0-.5-.5h-5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 .5-.5Zm8 3a.5.5 0 0 0-.5-.5h-5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 .5-.5Zm-8 0a.5.5 0 0 0-.5-.5h-5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 .5-.5Zm8 3a.5.5 0 0 0-.5-.5h-5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 .5-.5Zm-8 0a.5.5 0 0 0-.5-.5h-5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 .5-.5Zm8 3a.5.5 0 0 0-.5-.5h-5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 .5-.5Zm-8 0a.5.5 0 0 0-.5-.5h-5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 .5-.5Z"]));
export const TextColumnTwoLeftFilled = ( /*#__PURE__*/createFluentIcon('TextColumnTwoLeftFilled', "1em", ["M3 5.75c0-.41.34-.75.75-.75h2.5a.75.75 0 0 1 0 1.5h-2.5A.75.75 0 0 1 3 5.75Zm6 0c0-.41.34-.75.75-.75h6.5a.75.75 0 0 1 0 1.5h-6.5A.75.75 0 0 1 9 5.75Zm-6 3c0-.41.34-.75.75-.75h2.5a.75.75 0 0 1 0 1.5h-2.5A.75.75 0 0 1 3 8.75Zm6 0c0-.41.34-.75.75-.75h6.5a.75.75 0 0 1 0 1.5h-6.5A.75.75 0 0 1 9 8.75Zm-6 3c0-.41.34-.75.75-.75h2.5a.75.75 0 0 1 0 1.5h-2.5a.75.75 0 0 1-.75-.75Zm6 0c0-.41.34-.75.75-.75h6.5a.75.75 0 0 1 0 1.5h-6.5a.75.75 0 0 1-.75-.75Zm-6 3c0-.41.34-.75.75-.75h2.5a.75.75 0 0 1 0 1.5h-2.5a.75.75 0 0 1-.75-.75Zm6 0c0-.41.34-.75.75-.75h6.5a.75.75 0 0 1 0 1.5h-6.5a.75.75 0 0 1-.75-.75Z"]));
export const TextColumnTwoLeftRegular = ( /*#__PURE__*/createFluentIcon('TextColumnTwoLeftRegular', "1em", ["M3 5.5c0-.28.22-.5.5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5Zm6 0c0-.28.22-.5.5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5Zm-6 3c0-.28.22-.5.5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5Zm6 0c0-.28.22-.5.5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5Zm-6 3c0-.28.22-.5.5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5Zm6 0c0-.28.22-.5.5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5Zm-6 3c0-.28.22-.5.5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5Zm6 0c0-.28.22-.5.5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5Z"]));
export const TextColumnTwoRightFilled = ( /*#__PURE__*/createFluentIcon('TextColumnTwoRightFilled', "1em", ["M17 5.75a.75.75 0 0 0-.75-.75h-2.5a.75.75 0 0 0 0 1.5h2.5c.41 0 .75-.34.75-.75Zm-6 0a.75.75 0 0 0-.75-.75h-6.5a.75.75 0 0 0 0 1.5h6.5c.41 0 .75-.34.75-.75Zm6 3a.75.75 0 0 0-.75-.75h-2.5a.75.75 0 0 0 0 1.5h2.5c.41 0 .75-.34.75-.75Zm-6 0a.75.75 0 0 0-.75-.75h-6.5a.75.75 0 0 0 0 1.5h6.5c.41 0 .75-.34.75-.75Zm6 3a.75.75 0 0 0-.75-.75h-2.5a.75.75 0 0 0 0 1.5h2.5c.41 0 .75-.34.75-.75Zm-6 0a.75.75 0 0 0-.75-.75h-6.5a.75.75 0 0 0 0 1.5h6.5c.41 0 .75-.34.75-.75Zm6 3a.75.75 0 0 0-.75-.75h-2.5a.75.75 0 0 0 0 1.5h2.5c.41 0 .75-.34.75-.75Zm-6 0a.75.75 0 0 0-.75-.75h-6.5a.75.75 0 0 0 0 1.5h6.5c.41 0 .75-.34.75-.75Z"]));
export const TextColumnTwoRightRegular = ( /*#__PURE__*/createFluentIcon('TextColumnTwoRightRegular', "1em", ["M17 5.5a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 .5-.5Zm-6 0a.5.5 0 0 0-.5-.5h-7a.5.5 0 0 0 0 1h7a.5.5 0 0 0 .5-.5Zm6 3a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 .5-.5Zm-6 0a.5.5 0 0 0-.5-.5h-7a.5.5 0 0 0 0 1h7a.5.5 0 0 0 .5-.5Zm6 3a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 .5-.5Zm-6 0a.5.5 0 0 0-.5-.5h-7a.5.5 0 0 0 0 1h7a.5.5 0 0 0 .5-.5Zm6 3a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 .5-.5Zm-6 0a.5.5 0 0 0-.5-.5h-7a.5.5 0 0 0 0 1h7a.5.5 0 0 0 .5-.5Z"]));
export const TextColumnWideFilled = ( /*#__PURE__*/createFluentIcon('TextColumnWideFilled', "1em", ["M3.75 5a.75.75 0 0 0 0 1.5h12.5a.75.75 0 0 0 0-1.5H3.75Zm0 3a.75.75 0 0 0 0 1.5h12.5a.75.75 0 0 0 0-1.5H3.75ZM3 11.75c0-.41.34-.75.75-.75h12.5a.75.75 0 0 1 0 1.5H3.75a.75.75 0 0 1-.75-.75ZM3.75 14a.75.75 0 0 0 0 1.5h12.5a.75.75 0 0 0 0-1.5H3.75Z"]));
export const TextColumnWideRegular = ( /*#__PURE__*/createFluentIcon('TextColumnWideRegular', "1em", ["M3.5 5a.5.5 0 0 0 0 1h13a.5.5 0 0 0 0-1h-13Zm0 3a.5.5 0 0 0 0 1h13a.5.5 0 0 0 0-1h-13ZM3 11.5c0-.28.22-.5.5-.5h13a.5.5 0 0 1 0 1h-13a.5.5 0 0 1-.5-.5Zm.5 2.5a.5.5 0 0 0 0 1h13a.5.5 0 0 0 0-1h-13Z"]));
export const TextContinuousFilled = ( /*#__PURE__*/createFluentIcon('TextContinuousFilled', "1em", ["M2 5.5c0-.41.34-.75.75-.75h14.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 5.5Zm0 9c0-.41.34-.75.75-.75h14.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 14.5Zm2.78-5.03-1.5-1.5a.75.75 0 0 0-1.06 1.06l.97.97-.97.97a.75.75 0 1 0 1.06 1.06l1.5-1.5c.3-.3.3-.77 0-1.06ZM7 8.5c0-.41.34-.75.75-.75h9.5a.75.75 0 0 1 0 1.5h-9.5A.75.75 0 0 1 7 8.5Zm.75 2.25a.75.75 0 0 0 0 1.5h9.5a.75.75 0 0 0 0-1.5h-9.5Z"]));
export const TextContinuousRegular = ( /*#__PURE__*/createFluentIcon('TextContinuousRegular', "1em", ["M2 5.5c0-.28.22-.5.5-.5h15a.5.5 0 0 1 0 1h-15a.5.5 0 0 1-.5-.5Zm0 9c0-.28.22-.5.5-.5h15a.5.5 0 0 1 0 1h-15a.5.5 0 0 1-.5-.5Zm1.35-6.35a.5.5 0 1 0-.7.7L3.79 10l-1.14 1.15a.5.5 0 0 0 .7.7l1.5-1.5a.5.5 0 0 0 0-.7l-1.5-1.5ZM7.5 8h10a.5.5 0 0 1 0 1h-10a.5.5 0 0 1 0-1Zm0 3a.5.5 0 0 0 0 1h10a.5.5 0 0 0 0-1h-10Z"]));
export const TextDensityFilled = ( /*#__PURE__*/createFluentIcon('TextDensityFilled', "1em", ["M10.5 2c.28 0 .5.22.5.5v15a.5.5 0 0 1-1 0v-15c0-.28.22-.5.5-.5ZM9 5H2.5a.5.5 0 0 0 0 1H9V5Zm0 3H2.5a.5.5 0 0 0 0 1H9V8Zm0 3H2.5a.5.5 0 0 0 0 1H9v-1Zm0 3H2.5a.5.5 0 0 0 0 1H9v-1Zm7.5 0H12v-3h4.5a1.5 1.5 0 0 1 0 3Zm0-5H12V6h4.5a1.5 1.5 0 0 1 0 3Z"]));
export const TextDensityRegular = ( /*#__PURE__*/createFluentIcon('TextDensityRegular', "1em", ["M10.5 2c.28 0 .5.22.5.5v15a.5.5 0 0 1-1 0v-15c0-.28.22-.5.5-.5ZM9 5H2.5a.5.5 0 0 0 0 1H9V5Zm0 3H2.5a.5.5 0 0 0 0 1H9V8Zm0 3H2.5a.5.5 0 0 0 0 1H9v-1Zm0 3H2.5a.5.5 0 0 0 0 1H9v-1Zm7.5 0H12v-1h4.5a.5.5 0 0 0 0-1H12v-1h4.5a1.5 1.5 0 0 1 0 3Zm0-5H12V8h4.5a.5.5 0 0 0 0-1H12V6h4.5a1.5 1.5 0 0 1 0 3Z"]));
export const TextDescriptionFilled = ( /*#__PURE__*/createFluentIcon('TextDescriptionFilled', "1em", ["M2.75 4.5a.75.75 0 0 0 0 1.5h14.5a.75.75 0 0 0 0-1.5H2.75Zm0 3a.75.75 0 0 0 0 1.5h14.5a.75.75 0 0 0 0-1.5H2.75ZM2 11.25c0-.41.34-.75.75-.75h14.5a.75.75 0 0 1 0 1.5H2.75a.75.75 0 0 1-.75-.75Zm.75 2.25a.75.75 0 0 0 0 1.5h9.5a.75.75 0 0 0 0-1.5h-9.5Z"], { flipInRtl: true }));
export const TextDescriptionRegular = ( /*#__PURE__*/createFluentIcon('TextDescriptionRegular', "1em", ["M2.5 5a.5.5 0 0 0 0 1h15a.5.5 0 0 0 0-1h-15Zm0 3a.5.5 0 0 0 0 1h15a.5.5 0 0 0 0-1h-15ZM2 11.5c0-.28.22-.5.5-.5h15a.5.5 0 0 1 0 1h-15a.5.5 0 0 1-.5-.5Zm.5 2.5a.5.5 0 0 0 0 1h10a.5.5 0 0 0 0-1h-10Z"], { flipInRtl: true }));
export const TextDescriptionLtrFilled = ( /*#__PURE__*/createFluentIcon('TextDescriptionLtrFilled', "1em", ["M2.75 4.5a.75.75 0 0 0 0 1.5h14.5a.75.75 0 0 0 0-1.5H2.75Zm0 3a.75.75 0 0 0 0 1.5h14.5a.75.75 0 0 0 0-1.5H2.75ZM2 11.25c0-.41.34-.75.75-.75h14.5a.75.75 0 0 1 0 1.5H2.75a.75.75 0 0 1-.75-.75Zm.75 2.25a.75.75 0 0 0 0 1.5h9.5a.75.75 0 0 0 0-1.5h-9.5Z"]));
export const TextDescriptionLtrRegular = ( /*#__PURE__*/createFluentIcon('TextDescriptionLtrRegular', "1em", ["M2.5 5a.5.5 0 0 0 0 1h15a.5.5 0 0 0 0-1h-15Zm0 3a.5.5 0 0 0 0 1h15a.5.5 0 0 0 0-1h-15ZM2 11.5c0-.28.22-.5.5-.5h15a.5.5 0 0 1 0 1h-15a.5.5 0 0 1-.5-.5Zm.5 2.5a.5.5 0 0 0 0 1h10a.5.5 0 0 0 0-1h-10Z"]));
export const TextDescriptionRtlFilled = ( /*#__PURE__*/createFluentIcon('TextDescriptionRtlFilled', "1em", ["M17.25 4.5a.75.75 0 0 1 0 1.5H2.75a.75.75 0 0 1 0-1.5h14.5Zm0 3a.75.75 0 0 1 0 1.5H2.75a.75.75 0 0 1 0-1.5h14.5Zm.75 3.75a.75.75 0 0 0-.75-.75H2.75a.75.75 0 0 0 0 1.5h14.5c.41 0 .75-.34.75-.75Zm-.75 2.25a.75.75 0 0 1 0 1.5h-9.5a.75.75 0 0 1 0-1.5h9.5Z"]));
export const TextDescriptionRtlRegular = ( /*#__PURE__*/createFluentIcon('TextDescriptionRtlRegular', "1em", ["M17.5 5a.5.5 0 0 1 0 1h-15a.5.5 0 0 1 0-1h15Zm0 3a.5.5 0 0 1 0 1h-15a.5.5 0 0 1 0-1h15Zm.5 3.5a.5.5 0 0 0-.5-.5h-15a.5.5 0 0 0 0 1h15a.5.5 0 0 0 .5-.5Zm-.5 2.5a.5.5 0 0 1 0 1h-10a.5.5 0 0 1 0-1h10Z"]));
export const TextDirectionHorizontalLeftFilled = ( /*#__PURE__*/createFluentIcon('TextDirectionHorizontalLeftFilled', "1em", ["M13.5 3c-.3 0-.58.19-.7.47l-3 7.5a.75.75 0 0 0 1.4.56L12 9.5h3l.8 2.03a.75.75 0 0 0 1.4-.56l-3-7.5a.75.75 0 0 0-.7-.47Zm0 2.77L14.4 8h-1.8l.9-2.23ZM5.22 4.22a.75.75 0 0 1 1.06 1.06L5.56 6h3.69a.75.75 0 0 1 0 1.5H5.56l.72.72a.75.75 0 0 1-1.06 1.06l-2-2a.75.75 0 0 1 0-1.06l2-2Zm0 7.5a.75.75 0 0 1 1.06 1.06l-.72.72h10.69a.75.75 0 0 1 0 1.5H5.56l.72.72a.75.75 0 1 1-1.06 1.06l-2-2a.75.75 0 0 1 0-1.06l2-2Z"]));
export const TextDirectionHorizontalLeftRegular = ( /*#__PURE__*/createFluentIcon('TextDirectionHorizontalLeftRegular', "1em", ["M13.5 3a.5.5 0 0 0-.47.32l-3 8a.5.5 0 0 0 .94.36l1-2.68h3.06l1 2.68a.5.5 0 0 0 .94-.36l-3-8A.5.5 0 0 0 13.5 3Zm0 1.92L14.65 8h-2.3l1.15-3.08Zm-8.35-.77a.5.5 0 1 1 .7.7L4.71 6H9.5a.5.5 0 0 1 0 1H4.7l1.15 1.15a.5.5 0 1 1-.7.7l-2-2a.5.5 0 0 1 0-.7l2-2Zm0 8a.5.5 0 0 1 .7.7L4.71 14H16.5a.5.5 0 0 1 0 1H4.7l1.15 1.15a.5.5 0 0 1-.7.7l-2-2a.5.5 0 0 1 0-.7l2-2Z"]));
export const TextDirectionHorizontalLtrFilled = ( /*#__PURE__*/createFluentIcon('TextDirectionHorizontalLtrFilled', "1em", ["M6.5 3c.3 0 .58.19.7.47l3 7.5a.75.75 0 0 1-1.4.56L8 9.5H5l-.8 2.03a.75.75 0 0 1-1.4-.56l3-7.5A.75.75 0 0 1 6.5 3Zm0 2.77L5.6 8h1.8l-.9-2.23Zm8.28-1.55a.75.75 0 1 0-1.06 1.06l.72.72h-3.69a.75.75 0 0 0 0 1.5h3.69l-.72.72a.75.75 0 0 0 1.06 1.06l2-2c.3-.3.3-.77 0-1.06l-2-2Zm0 7.5a.75.75 0 1 0-1.06 1.06l.72.72H3.75a.75.75 0 0 0 0 1.5h10.69l-.72.72a.75.75 0 1 0 1.06 1.06l2-2c.3-.3.3-.77 0-1.06l-2-2Z"]));
export const TextDirectionHorizontalLtrRegular = ( /*#__PURE__*/createFluentIcon('TextDirectionHorizontalLtrRegular', "1em", ["M6.5 3c.2 0 .4.13.47.32l3 8a.5.5 0 0 1-.94.36L8.03 9H4.97l-1 2.68a.5.5 0 0 1-.94-.36l3-8A.5.5 0 0 1 6.5 3Zm0 1.92L5.35 8h2.3L6.5 4.92Zm8.35-.77a.5.5 0 1 0-.7.7L15.29 6H10.5a.5.5 0 0 0 0 1h4.8l-1.15 1.15a.5.5 0 1 0 .7.7l2-2a.5.5 0 0 0 0-.7l-2-2Zm0 8a.5.5 0 0 0-.7.7L15.29 14H3.5a.5.5 0 0 0 0 1h11.8l-1.15 1.15a.5.5 0 0 0 .7.7l2-2a.5.5 0 0 0 0-.7l-2-2Z"]));
export const TextDirectionHorizontalRightFilled = ( /*#__PURE__*/createFluentIcon('TextDirectionHorizontalRightFilled', "1em", ["M6.5 3c.3 0 .58.19.7.47l3 7.5a.75.75 0 0 1-1.4.56L8 9.5H5l-.8 2.03a.75.75 0 0 1-1.4-.56l3-7.5A.75.75 0 0 1 6.5 3Zm0 2.77L5.6 8h1.8l-.9-2.23Zm8.28-1.55a.75.75 0 1 0-1.06 1.06l.72.72h-3.69a.75.75 0 0 0 0 1.5h3.69l-.72.72a.75.75 0 0 0 1.06 1.06l2-2c.3-.3.3-.77 0-1.06l-2-2Zm0 7.5a.75.75 0 1 0-1.06 1.06l.72.72H3.75a.75.75 0 0 0 0 1.5h10.69l-.72.72a.75.75 0 1 0 1.06 1.06l2-2c.3-.3.3-.77 0-1.06l-2-2Z"]));
export const TextDirectionHorizontalRightRegular = ( /*#__PURE__*/createFluentIcon('TextDirectionHorizontalRightRegular', "1em", ["M6.5 3c.2 0 .4.13.47.32l3 8a.5.5 0 0 1-.94.36L8.03 9H4.97l-1 2.68a.5.5 0 0 1-.94-.36l3-8A.5.5 0 0 1 6.5 3Zm0 1.92L5.35 8h2.3L6.5 4.92Zm8.35-.77a.5.5 0 1 0-.7.7L15.29 6H10.5a.5.5 0 0 0 0 1h4.8l-1.15 1.15a.5.5 0 1 0 .7.7l2-2a.5.5 0 0 0 0-.7l-2-2Zm0 8a.5.5 0 0 0-.7.7L15.29 14H3.5a.5.5 0 0 0 0 1h11.8l-1.15 1.15a.5.5 0 0 0 .7.7l2-2a.5.5 0 0 0 0-.7l-2-2Z"]));
export const TextDirectionHorizontalRtlFilled = ( /*#__PURE__*/createFluentIcon('TextDirectionHorizontalRtlFilled', "1em", ["M13.5 3c-.3 0-.58.19-.7.47l-3 7.5a.75.75 0 0 0 1.4.56L12 9.5h3l.8 2.03a.75.75 0 0 0 1.4-.56l-3-7.5a.75.75 0 0 0-.7-.47Zm0 2.77L14.4 8h-1.8l.9-2.23ZM5.22 4.22a.75.75 0 0 1 1.06 1.06L5.56 6h3.69a.75.75 0 0 1 0 1.5H5.56l.72.72a.75.75 0 0 1-1.06 1.06l-2-2a.75.75 0 0 1 0-1.06l2-2Zm0 7.5a.75.75 0 0 1 1.06 1.06l-.72.72h10.69a.75.75 0 0 1 0 1.5H5.56l.72.72a.75.75 0 1 1-1.06 1.06l-2-2a.75.75 0 0 1 0-1.06l2-2Z"]));
export const TextDirectionHorizontalRtlRegular = ( /*#__PURE__*/createFluentIcon('TextDirectionHorizontalRtlRegular', "1em", ["M13.5 3a.5.5 0 0 0-.47.32l-3 8a.5.5 0 0 0 .94.36l1-2.68h3.06l1 2.68a.5.5 0 0 0 .94-.36l-3-8A.5.5 0 0 0 13.5 3Zm0 1.92L14.65 8h-2.3l1.15-3.08Zm-8.35-.77a.5.5 0 1 1 .7.7L4.71 6H9.5a.5.5 0 0 1 0 1H4.7l1.15 1.15a.5.5 0 1 1-.7.7l-2-2a.5.5 0 0 1 0-.7l2-2Zm0 8a.5.5 0 0 1 .7.7L4.71 14H16.5a.5.5 0 0 1 0 1H4.7l1.15 1.15a.5.5 0 0 1-.7.7l-2-2a.5.5 0 0 1 0-.7l2-2Z"]));
export const TextDirectionRotate270RightFilled = ( /*#__PURE__*/createFluentIcon('TextDirectionRotate270RightFilled', "1em", ["M4.22 5.22a.75.75 0 0 0 1.06 1.06L6 5.56v3.69a.75.75 0 0 0 1.5 0V5.56l.72.72a.75.75 0 0 0 1.06-1.06l-2-2a.75.75 0 0 0-1.06 0l-2 2Zm7.5 0a.75.75 0 1 0 1.06 1.06l.72-.72v10.69a.75.75 0 1 0 1.5 0V5.56l.72.72a.75.75 0 0 0 1.06-1.06l-2-2a.75.75 0 0 0-1.06 0l-2 2ZM3 13.5c0-.3.19-.58.47-.7l7.5-3a.75.75 0 1 1 .56 1.4L9.5 12v3l2.03.8a.75.75 0 0 1-.56 1.4l-7.5-3a.75.75 0 0 1-.47-.7Zm2.77 0 2.23.9v-1.8l-2.23.9Z"]));
export const TextDirectionRotate270RightRegular = ( /*#__PURE__*/createFluentIcon('TextDirectionRotate270RightRegular', "1em", ["M8.85 5.15a.5.5 0 1 1-.7.7L7 4.71V9.5a.5.5 0 0 1-1 0V4.7L4.85 5.86a.5.5 0 1 1-.7-.7l2-2c.2-.2.5-.2.7 0l2 2Zm8 0a.5.5 0 1 1-.7.7L15 4.71V16.5a.5.5 0 0 1-1 0V4.7l-1.15 1.15a.5.5 0 1 1-.7-.7l2-2c.2-.2.5-.2.7 0l2 2ZM3 13.5c0-.2.13-.4.32-.47l8-3a.5.5 0 0 1 .36.94l-2.68 1v3.06l2.68 1a.5.5 0 0 1-.36.94l-8-3A.5.5 0 0 1 3 13.5Zm1.92 0L8 14.65v-2.3L4.92 13.5Z"]));
export const TextDirectionRotate315RightFilled = ( /*#__PURE__*/createFluentIcon('TextDirectionRotate315RightFilled', "1em", ["M8 2.75c0-.41.34-.75.75-.75h2.5c.41 0 .75.34.75.75v2.5a.75.75 0 0 1-1.5 0v-.69L8.28 6.78a.75.75 0 1 1-1.06-1.06L9.44 3.5h-.7A.75.75 0 0 1 8 2.75ZM3.09 6.58a.75.75 0 0 0-1.01 1l4 8a.75.75 0 0 0 1.34-.67l-1.09-2.18 1.9-1.9 2.18 1.1a.75.75 0 1 0 .68-1.35l-8-4Zm3.73 3.54-1.2 1.2-1.2-2.4 2.4 1.2ZM14.75 8a.75.75 0 0 0 0 1.5h.69l-7.22 7.22a.75.75 0 1 0 1.06 1.06l7.22-7.22v.69a.75.75 0 0 0 1.5 0v-2.5a.75.75 0 0 0-.75-.75h-2.5Z"]));
export const TextDirectionRotate315RightRegular = ( /*#__PURE__*/createFluentIcon('TextDirectionRotate315RightRegular', "1em", ["M8.5 2a.5.5 0 0 0 0 1h1.8L7.14 6.15a.5.5 0 1 0 .7.7L11 3.71V5.5a.5.5 0 1 0 1 0v-3a.5.5 0 0 0-.5-.5h-3ZM2.72 7.05a.5.5 0 0 0-.67.67l4 8a.5.5 0 1 0 .9-.45l-1.17-2.34 2.15-2.15 2.35 1.17a.5.5 0 1 0 .44-.9l-8-4ZM7 10.3 5.3 12 3.62 8.62l3.37 1.68ZM14.5 8a.5.5 0 0 0 0 1h1.8l-8.15 8.15a.5.5 0 0 0 .7.7L17 9.71v1.79a.5.5 0 1 0 1 0v-3a.5.5 0 0 0-.5-.5h-3Z"]));
export const TextDirectionRotate45RightFilled = ( /*#__PURE__*/createFluentIcon('TextDirectionRotate45RightFilled', "1em", ["M17.25 8c.41 0 .75.34.75.75v2.5c0 .41-.34.75-.75.75h-2.5a.75.75 0 1 1 0-1.5h.69l-2.22-2.22a.75.75 0 0 1 1.06-1.06l2.22 2.22v-.7c0-.4.34-.74.75-.74Zm-3.83-4.91a.75.75 0 0 0-1-1.01l-8 4a.75.75 0 1 0 .67 1.34l2.18-1.1 1.9 1.91-1.1 2.18a.75.75 0 1 0 1.35.68l4-8ZM9.88 6.82l-1.2-1.2 2.4-1.2-1.2 2.4ZM12 14.75a.75.75 0 0 0-1.5 0v.69L3.28 8.22a.75.75 0 1 0-1.06 1.06l7.22 7.22h-.69a.75.75 0 0 0 0 1.5h2.5c.41 0 .75-.34.75-.75v-2.5Z"]));
export const TextDirectionRotate45RightRegular = ( /*#__PURE__*/createFluentIcon('TextDirectionRotate45RightRegular', "1em", ["M18 8.5a.5.5 0 0 0-1 0v1.8l-3.15-3.15a.5.5 0 1 0-.7.7L16.29 11H14.5a.5.5 0 1 0 0 1h3a.5.5 0 0 0 .5-.5v-3Zm-5.05-5.78a.5.5 0 0 0-.67-.67l-8 4a.5.5 0 0 0 .45.9l2.34-1.18 2.15 2.16-1.17 2.35a.5.5 0 1 0 .9.44l4-8ZM9.7 7 8 5.3l3.37-1.68L9.7 6.99Zm2.3 7.5a.5.5 0 0 0-1 0v1.8L2.85 8.15a.5.5 0 1 0-.7.7L10.29 17H8.5a.5.5 0 1 0 0 1h3a.5.5 0 0 0 .5-.5v-3Z"]));
export const TextDirectionRotate90LeftFilled = ( /*#__PURE__*/createFluentIcon('TextDirectionRotate90LeftFilled', "1em", ["M17 13.5c0 .3-.19.58-.47.7l-7.5 3a.75.75 0 0 1-.56-1.4l2.03-.8v-3l-2.03-.8a.75.75 0 0 1 .56-1.4l7.5 3c.28.12.47.4.47.7Zm-2.77 0L12 12.6v1.8l2.23-.9ZM5 16.25a.75.75 0 0 0 1.5 0V5.56l.72.72a.75.75 0 0 0 1.06-1.06l-2-2a.75.75 0 0 0-1.06 0l-2 2a.75.75 0 0 0 1.06 1.06L5 5.56v10.69Zm8-7a.75.75 0 0 0 1.5 0V5.56l.72.72a.75.75 0 1 0 1.06-1.06l-2-2a.75.75 0 0 0-1.06 0l-2 2a.75.75 0 0 0 1.06 1.06l.72-.72v3.69Z"]));
export const TextDirectionRotate90LeftRegular = ( /*#__PURE__*/createFluentIcon('TextDirectionRotate90LeftRegular', "1em", ["M17 13.5c0 .2-.13.4-.32.47l-8 3a.5.5 0 1 1-.36-.94l2.68-1v-3.06l-2.68-1a.5.5 0 1 1 .36-.94l8 3c.2.07.32.26.32.47Zm-1.92 0L12 12.35v2.3l3.08-1.15ZM5 16.5a.5.5 0 1 0 1 0V4.7l1.15 1.15a.5.5 0 0 0 .7-.7l-2-2A.5.5 0 0 0 5.5 3a.5.5 0 0 0-.35.15l-2 2a.5.5 0 1 0 .7.7L5 4.71V16.5Zm8-7a.5.5 0 0 0 1 0V4.7l1.15 1.15a.5.5 0 0 0 .7-.7l-2-2a.5.5 0 0 0-.7 0l-2 2a.5.5 0 0 0 .7.7L13 4.71V9.5Z"]));
export const TextDirectionRotate90LtrFilled = ( /*#__PURE__*/createFluentIcon('TextDirectionRotate90LtrFilled', "1em", ["M17 6.5c0-.3-.19-.58-.47-.7l-7.5-3a.75.75 0 0 0-.56 1.4l2.03.8v3l-2.03.8a.75.75 0 1 0 .56 1.4l7.5-3a.75.75 0 0 0 .47-.7Zm-2.77 0L12 7.4V5.6l2.23.9ZM5 3.75a.75.75 0 0 1 1.5 0v10.69l.72-.72a.75.75 0 1 1 1.06 1.06l-2 2c-.3.3-.77.3-1.06 0l-2-2a.75.75 0 0 1 1.06-1.06l.72.72V3.75Zm8 7a.75.75 0 0 1 1.5 0v3.69l.72-.72a.75.75 0 1 1 1.06 1.06l-2 2a.75.75 0 0 1-1.06 0l-2-2a.75.75 0 0 1 1.06-1.06l.72.72v-3.69Z"]));
export const TextDirectionRotate90LtrRegular = ( /*#__PURE__*/createFluentIcon('TextDirectionRotate90LtrRegular', "1em", ["M17 6.5a.5.5 0 0 0-.32-.47l-8-3a.5.5 0 1 0-.36.94l2.68 1v3.06l-2.68 1a.5.5 0 0 0 .36.94l8-3A.5.5 0 0 0 17 6.5Zm-1.92 0L12 7.65v-2.3l3.08 1.15ZM5 3.5a.5.5 0 0 1 1 0v11.8l1.15-1.15a.5.5 0 1 1 .7.7l-2 2a.5.5 0 0 1-.35.15.5.5 0 0 1-.35-.15l-2-2a.5.5 0 1 1 .7-.7L5 15.29V3.5Zm8 7a.5.5 0 0 1 1 0v4.8l1.15-1.15a.5.5 0 0 1 .7.7l-2 2a.5.5 0 0 1-.7 0l-2-2a.5.5 0 0 1 .7-.7L13 15.29V10.5Z"]));
export const TextDirectionRotate90RightFilled = ( /*#__PURE__*/createFluentIcon('TextDirectionRotate90RightFilled', "1em", ["M17 6.5c0-.3-.19-.58-.47-.7l-7.5-3a.75.75 0 0 0-.56 1.4l2.03.8v3l-2.03.8a.75.75 0 1 0 .56 1.4l7.5-3a.75.75 0 0 0 .47-.7Zm-2.77 0L12 7.4V5.6l2.23.9ZM5 3.75a.75.75 0 0 1 1.5 0v10.69l.72-.72a.75.75 0 1 1 1.06 1.06l-2 2c-.3.3-.77.3-1.06 0l-2-2a.75.75 0 0 1 1.06-1.06l.72.72V3.75Zm8 7a.75.75 0 0 1 1.5 0v3.69l.72-.72a.75.75 0 1 1 1.06 1.06l-2 2a.75.75 0 0 1-1.06 0l-2-2a.75.75 0 0 1 1.06-1.06l.72.72v-3.69Z"]));
export const TextDirectionRotate90RightRegular = ( /*#__PURE__*/createFluentIcon('TextDirectionRotate90RightRegular', "1em", ["M17 6.5a.5.5 0 0 0-.32-.47l-8-3a.5.5 0 1 0-.36.94l2.68 1v3.06l-2.68 1a.5.5 0 0 0 .36.94l8-3A.5.5 0 0 0 17 6.5Zm-1.92 0L12 7.65v-2.3l3.08 1.15ZM5 3.5a.5.5 0 0 1 1 0v11.8l1.15-1.15a.5.5 0 1 1 .7.7l-2 2a.5.5 0 0 1-.35.15.5.5 0 0 1-.35-.15l-2-2a.5.5 0 1 1 .7-.7L5 15.29V3.5Zm8 7a.5.5 0 0 1 1 0v4.8l1.15-1.15a.5.5 0 0 1 .7.7l-2 2a.5.5 0 0 1-.7 0l-2-2a.5.5 0 0 1 .7-.7L13 15.29V10.5Z"]));
export const TextDirectionRotate90RtlFilled = ( /*#__PURE__*/createFluentIcon('TextDirectionRotate90RtlFilled', "1em", ["M17 13.5c0 .3-.19.58-.47.7l-7.5 3a.75.75 0 0 1-.56-1.4l2.03-.8v-3l-2.03-.8a.75.75 0 0 1 .56-1.4l7.5 3c.28.12.47.4.47.7Zm-2.77 0L12 12.6v1.8l2.23-.9ZM5 16.25a.75.75 0 0 0 1.5 0V5.56l.72.72a.75.75 0 0 0 1.06-1.06l-2-2a.75.75 0 0 0-1.06 0l-2 2a.75.75 0 0 0 1.06 1.06L5 5.56v10.69Zm8-7a.75.75 0 0 0 1.5 0V5.56l.72.72a.75.75 0 1 0 1.06-1.06l-2-2a.75.75 0 0 0-1.06 0l-2 2a.75.75 0 0 0 1.06 1.06l.72-.72v3.69Z"]));
export const TextDirectionRotate90RtlRegular = ( /*#__PURE__*/createFluentIcon('TextDirectionRotate90RtlRegular', "1em", ["M17 13.5c0 .2-.13.4-.32.47l-8 3a.5.5 0 1 1-.36-.94l2.68-1v-3.06l-2.68-1a.5.5 0 1 1 .36-.94l8 3c.2.07.32.26.32.47Zm-1.92 0L12 12.35v2.3l3.08-1.15ZM5 16.5a.5.5 0 1 0 1 0V4.7l1.15 1.15a.5.5 0 0 0 .7-.7l-2-2A.5.5 0 0 0 5.5 3a.5.5 0 0 0-.35.15l-2 2a.5.5 0 1 0 .7.7L5 4.71V16.5Zm8-7a.5.5 0 0 0 1 0V4.7l1.15 1.15a.5.5 0 0 0 .7-.7l-2-2a.5.5 0 0 0-.7 0l-2 2a.5.5 0 0 0 .7.7L13 4.71V9.5Z"]));
export const TextDirectionVerticalFilled = ( /*#__PURE__*/createFluentIcon('TextDirectionVerticalFilled', "1em", ["M5 3.75a.75.75 0 0 1 1.5 0v10.69l.72-.72a.75.75 0 0 1 1.06 1.06l-2 2c-.3.3-.77.3-1.06 0l-2-2a.75.75 0 1 1 1.06-1.06l.72.72V3.75Zm8 9a.75.75 0 0 1 1.5 0v1.69l.72-.72a.75.75 0 1 1 1.06 1.06l-2 2a.75.75 0 0 1-1.06 0l-2-2a.76.76 0 0 1 0-1.07c.3-.3.77-.28 1.06.01l.72.72v-1.69ZM13.5 3c.3 0 .58.19.7.47l3 7.5a.75.75 0 0 1-1.4.56L15 9.5h-3l-.8 2.03a.75.75 0 0 1-1.4-.56l3-7.5a.75.75 0 0 1 .7-.47Zm0 2.77L12.6 8h1.8l-.9-2.23Z"]));
export const TextDirectionVerticalRegular = ( /*#__PURE__*/createFluentIcon('TextDirectionVerticalRegular', "1em", ["M5 3.5a.5.5 0 0 1 1 0v11.8l1.15-1.15a.5.5 0 0 1 .7.7l-2 2a.5.5 0 0 1-.35.15.5.5 0 0 1-.35-.15l-2-2a.5.5 0 0 1 .7-.7L5 15.29V3.5Zm8 9a.5.5 0 0 1 1 0v2.8l1.15-1.15a.5.5 0 0 1 .7.7l-2 2a.5.5 0 0 1-.7 0l-2-2a.5.5 0 0 1 .7-.7L13 15.29V12.5Zm.5-9.5a.5.5 0 0 0-.47.32l-3 8a.5.5 0 0 0 .94.36l1-2.68h3.06l1 2.68a.5.5 0 0 0 .94-.36l-3-8A.5.5 0 0 0 13.5 3Zm0 1.92L14.65 8h-2.3l1.15-3.08Z"]));
export const TextEditStyleColor = ( /*#__PURE__*/createFluentIcon('TextEditStyleColor', "1em", `<path fill-rule="evenodd" clip-rule="evenodd" d="M5.3 2.23c.12-.3.39-.47.66-.48h.08c.27.01.54.17.66.48l3.5 9.01.03.1v.02c.07.35-.11.7-.46.84h-.01l-.1.04h-.02a.75.75 0 0 1-.84-.47l-.98-2.52H4.18l-.98 2.52c-.07.18-.2.31-.35.4a.75.75 0 0 1-.5.07l-.11-.03h-.01a.75.75 0 0 1-.47-.85v-.01l.04-.11 3.5-9.01Zm-.75 5.5h2.9L6 4 4.55 7.73Z" fill="url(#ic_fluent_text_edit_style_20_color__a)"/><path d="m10.3 16.94 5.58-5.61-3.2-3.21-5.6 5.61.53 2.69 2.69.52Z" fill="url(#ic_fluent_text_edit_style_20_color__b)"/><path d="M9.87 17.17c.2-.08.4-.2.55-.35 0 0-.97.1-2.14-1.08-1.17-1.16-1.08-2.13-1.08-2.13l-.1.12a1.5 1.5 0 0 0-.29.57l-.79 3.07-.01.08a.5.5 0 0 0 .62.53l3.08-.76.16-.05Z" fill="url(#ic_fluent_text_edit_style_20_color__c)"/><path d="M9.87 17.17c.2-.08.4-.2.55-.35 0 0-.97.1-2.14-1.08-1.17-1.16-1.08-2.13-1.08-2.13l-.1.12a1.5 1.5 0 0 0-.29.57l-.79 3.07-.01.08a.5.5 0 0 0 .62.53l3.08-.76.16-.05Z" fill="url(#ic_fluent_text_edit_style_20_color__d)"/><path d="M9.87 17.17c.2-.08.4-.2.55-.35 0 0-.97.1-2.14-1.08-1.17-1.16-1.08-2.13-1.08-2.13l-.1.12a1.5 1.5 0 0 0-.29.57l-.79 3.07-.01.08a.5.5 0 0 0 .62.53l3.08-.76.16-.05Z" fill="url(#ic_fluent_text_edit_style_20_color__e)"/><path d="M17.16 6.58a2.26 2.26 0 0 0-3.07.12l-1.57 1.57 3.2 3.21 1.57-1.56.12-.13c.73-.85.73-2.1 0-2.96l-.12-.13-.13-.12Z" fill="url(#ic_fluent_text_edit_style_20_color__f)"/><path d="m15.35 11.86 1.24-1.24s-.96.1-2.14-1.07c-1.18-1.19-1.07-2.14-1.07-2.14l-1.24 1.24s-.08.98 1.09 2.15c1.17 1.16 2.12 1.06 2.12 1.06Z" fill="url(#ic_fluent_text_edit_style_20_color__g)"/><defs><linearGradient id="ic_fluent_text_edit_style_20_color__a" x1="1.75" y1="2.37" x2="4.6" y2="13.84" gradientUnits="userSpaceOnUse"><stop stop-color="#0FAFFF"/><stop offset=".68" stop-color="#0078D4"/><stop offset=".84" stop-color="#0057AA"/><stop offset="1" stop-color="#0057AA"/></linearGradient><linearGradient id="ic_fluent_text_edit_style_20_color__b" x1="9.51" y1="10.25" x2="13.77" y2="14.51" gradientUnits="userSpaceOnUse"><stop stop-color="#FFA43D"/><stop offset="1" stop-color="#FB5937"/></linearGradient><linearGradient id="ic_fluent_text_edit_style_20_color__c" x1="5.9" y1="14.7" x2="8.73" y2="17.53" gradientUnits="userSpaceOnUse"><stop offset=".26" stop-color="#FFD394"/><stop offset="1" stop-color="#FF921F"/></linearGradient><linearGradient id="ic_fluent_text_edit_style_20_color__d" x1="8.72" y1="16.25" x2="7.11" y2="14.5" gradientUnits="userSpaceOnUse"><stop stop-color="#AC80FF"/><stop offset="1" stop-color="#CEB0FF"/></linearGradient><linearGradient id="ic_fluent_text_edit_style_20_color__e" x1="5.37" y1="14.83" x2="8.53" y2="17.99" gradientUnits="userSpaceOnUse"><stop offset=".26" stop-color="#FFD394"/><stop offset="1" stop-color="#FF921F"/></linearGradient><linearGradient id="ic_fluent_text_edit_style_20_color__f" x1="16.82" y1="7.17" x2="14.81" y2="9.06" gradientUnits="userSpaceOnUse"><stop stop-color="#F97DBD"/><stop offset="1" stop-color="#DD3CE2"/></linearGradient><linearGradient id="ic_fluent_text_edit_style_20_color__g" x1="14.45" y1="10.46" x2="11.31" y2="9.1" gradientUnits="userSpaceOnUse"><stop stop-color="#FF921F"/><stop offset="1" stop-color="#FFE994"/></linearGradient></defs>`, { color: true }));
export const TextEditStyleFilled = ( /*#__PURE__*/createFluentIcon('TextEditStyleFilled', "1em", ["M14.09 6.7a2.26 2.26 0 0 1 3.07-.12l.13.12.12.13c.73.85.73 2.1 0 2.96l-.12.13-6.87 6.9a1.5 1.5 0 0 1-.55.35l-.16.05-3.08.76a.5.5 0 0 1-.62-.53l.01-.08.8-3.07c.05-.21.15-.4.28-.57l.1-.12 6.89-6.9ZM6.42 2.23l.05.08 2.98 7.63-.77.78L8 9H4l-1.03 2.68a.5.5 0 0 1-.56.3l-.1-.02a.5.5 0 0 1-.3-.56l.02-.08 3.5-9a.5.5 0 0 1 .9-.1ZM6 3.87 4.4 8H7.6l-1.6-4.13Z"]));
export const TextEditStyleRegular = ( /*#__PURE__*/createFluentIcon('TextEditStyleRegular', "1em", ["M14.09 6.7a2.26 2.26 0 0 1 3.07-.12l.13.12.12.13c.73.85.73 2.1 0 2.96l-.12.13-6.87 6.9a1.5 1.5 0 0 1-.55.35l-.16.05-3.08.76a.5.5 0 0 1-.62-.53l.01-.08.8-3.07c.05-.21.15-.4.28-.57l.1-.12 6.89-6.9Zm2.5.7a1.26 1.26 0 0 0-1.7-.08l-.1.09-6.88 6.9a.5.5 0 0 0-.1.15l-.03.08-.58 2.27 2.27-.56a.5.5 0 0 0 .12-.05l.05-.03.07-.06 6.87-6.9c.5-.5.5-1.3 0-1.8ZM6.41 2.24l.05.08 2.98 7.63-.77.78L8 9H4l-1.03 2.68a.5.5 0 0 1-.56.3l-.1-.02a.5.5 0 0 1-.3-.56l.02-.08 3.5-9a.5.5 0 0 1 .9-.1ZM6 3.87 4.4 8H7.6l-1.6-4.13Z"]));
export const TextEffectsFilled = ( /*#__PURE__*/createFluentIcon('TextEffectsFilled', "1em", ["M12.09 3.9a2.25 2.25 0 0 0-4.18 0L4.9 11.37a2.2 2.2 0 0 0-.04.1l-1.2 2.95a2.25 2.25 0 0 0 4.18 1.68l.64-1.59h3.04l.64 1.6a2.25 2.25 0 1 0 4.18-1.7l-1.2-2.95a2.27 2.27 0 0 0-.04-.1L12.1 3.92Zm-1.4.57 3.04 7.48v.03l1.22 2.99a.75.75 0 0 1-1.4.56L12.54 13H7.47l-1.02 2.53a.75.75 0 0 1-1.4-.56l1.21-2.99.02-.03L9.3 4.47a.75.75 0 0 1 1.39 0Zm1.23 7.03H8.08L10 6.75l1.92 4.75Z"]));
export const TextEffectsRegular = ( /*#__PURE__*/createFluentIcon('TextEffectsRegular', "1em", ["M11.62 4.1a1.75 1.75 0 0 0-3.24 0l-3.02 7.46-.03.07-1.2 2.96a1.75 1.75 0 0 0 3.24 1.32L8.14 14h3.72l.77 1.9a1.75 1.75 0 0 0 3.24-1.3l-1.2-2.97a1.73 1.73 0 0 0-.03-.07l-3.02-7.47Zm-1.18 6.4L10 9.41l-.44 1.09h.88Zm.26-6.03 3.03 7.48v.03l1.22 2.99a.75.75 0 0 1-1.4.56L12.54 13H7.47l-1.02 2.53a.75.75 0 0 1-1.4-.56l1.21-2.99.02-.03L9.3 4.47a.75.75 0 0 1 1.39 0Zm1.22 7.03H8.08L10 6.75l1.92 4.75Z"]));
export const TextEffectsSparkleFilled = ( /*#__PURE__*/createFluentIcon('TextEffectsSparkleFilled', "1em", ["m13.88.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.23 2.23 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Zm4.9 7.93-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02Zm-9.47-5.6c-.62.2-1.14.67-1.4 1.3L4.9 11.36l-.04.1-1.2 2.95a2.25 2.25 0 0 0 4.18 1.68l.64-1.59h3.04l.64 1.6a2.25 2.25 0 0 0 4.18-1.7l-1.2-2.95a2.27 2.27 0 0 0-.04-.1l-.57-1.4-.64-.21c-.27-.1-.49-.26-.65-.48a1.3 1.3 0 0 1-.13-1.29c-.53-.11-.97-.43-1.34-.85l1.96 4.83v.03l1.22 2.99a.75.75 0 0 1-1.4.56L12.54 13H7.47l-1.02 2.53a.75.75 0 0 1-1.4-.56l1.21-2.99.02-.03L9.3 4.47l.02-.06A1.4 1.4 0 0 1 9 3.5a1.4 1.4 0 0 1 .31-.9ZM8.08 11.5h3.84L10 6.75 8.08 11.5Z"]));
export const TextEffectsSparkleRegular = ( /*#__PURE__*/createFluentIcon('TextEffectsSparkleRegular', "1em", ["m13.88.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.23 2.23 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Zm4.9 7.93-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02ZM8.38 4.1c.13-.32.35-.6.63-.78a1.46 1.46 0 0 0 .25 1l.07.1a.76.76 0 0 0-.02.06l-3.03 7.48-.02.03-1.2 2.99a.75.75 0 0 0 1.39.56L7.47 13h5.06l1.03 2.53a.75.75 0 0 0 1.39-.56l-1.21-2.99-.02-.03-1.95-4.83c.37.42.8.74 1.35.85a1.3 1.3 0 0 0 .77 1.77h.02l.73 1.82.03.07 1.2 2.96a1.75 1.75 0 0 1-3.24 1.32L11.86 14H8.14l-.77 1.9a1.75 1.75 0 1 1-3.24-1.3l1.2-2.97.03-.07 3.02-7.47Zm3.54 7.41H8.08L10 6.75l1.92 4.75Z"]));
export const TextExpandFilled = ( /*#__PURE__*/createFluentIcon('TextExpandFilled', "1em", ["M4.75 3.5a.75.75 0 0 0 0 1.5h12.5a.75.75 0 0 0 0-1.5H4.75ZM4 16.25c0-.41.34-.75.75-.75h12.5a.75.75 0 0 1 0 1.5H4.75a.75.75 0 0 1-.75-.75Zm7-4c0-.41.34-.75.75-.75h5.5a.75.75 0 0 1 0 1.5h-5.5a.75.75 0 0 1-.75-.75Zm0-4c0-.41.34-.75.75-.75h5.5a.75.75 0 0 1 0 1.5h-5.5a.75.75 0 0 1-.75-.75ZM5.5 14a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7ZM6 8.5V10h1.5a.5.5 0 0 1 0 1H6v1.5a.5.5 0 0 1-1 0V11H3.5a.5.5 0 0 1 0-1H5V8.5a.5.5 0 0 1 1 0Z"]));
export const TextExpandRegular = ( /*#__PURE__*/createFluentIcon('TextExpandRegular', "1em", ["M4 4.5c0-.28.22-.5.5-.5h13a.5.5 0 0 1 0 1h-13a.5.5 0 0 1-.5-.5Zm0 12c0-.28.22-.5.5-.5h13a.5.5 0 0 1 0 1h-13a.5.5 0 0 1-.5-.5Zm6-4c0-.28.22-.5.5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5Zm0-4c0-.28.22-.5.5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5ZM5.5 14a3.5 3.5 0 1 1 0-7 3.5 3.5 0 0 1 0 7ZM6 8.5a.5.5 0 0 0-1 0V10H3.5a.5.5 0 0 0 0 1H5v1.5a.5.5 0 0 0 1 0V11h1.5a.5.5 0 0 0 0-1H6V8.5Z"]));
export const TextFieldFilled = ( /*#__PURE__*/createFluentIcon('TextFieldFilled', "1em", ["M2 6a3 3 0 0 1 3-3h10a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H5a3 3 0 0 1-3-3V6Zm4-.5v1a.5.5 0 0 0 1 0V6h2.5v8H9a.5.5 0 0 0 0 1h2a.5.5 0 0 0 0-1h-.5V6H13v.5a.5.5 0 0 0 1 0v-1a.5.5 0 0 0-.5-.5h-7a.5.5 0 0 0-.5.5Z"]));
export const TextFieldRegular = ( /*#__PURE__*/createFluentIcon('TextFieldRegular', "1em", ["M10.5 6H13v.5a.5.5 0 0 0 1 0v-1a.5.5 0 0 0-.5-.5h-7a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 1 0V6h2.5v8H9a.5.5 0 0 0 0 1h2a.5.5 0 0 0 0-1h-.5V6ZM2 6a3 3 0 0 1 3-3h10a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H5a3 3 0 0 1-3-3V6Zm3-2a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h10a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2H5Z"]));
export const TextFirstLineFilled = ( /*#__PURE__*/createFluentIcon('TextFirstLineFilled', "1em", ["M15.72 2.22a.75.75 0 1 1 1.06 1.06l-.97.97.97.97a.75.75 0 0 1-1.06 1.06l-1.5-1.5a.75.75 0 0 1 0-1.06l1.5-1.5ZM3.75 3.5h7.5a.75.75 0 0 1 0 1.5h-7.5a.75.75 0 0 1 0-1.5Zm12.5 10a.75.75 0 0 1 0 1.5H3.75a.75.75 0 0 1 0-1.5h12.5ZM3.75 10h12.5a.75.75 0 0 0 0-1.5H3.75a.75.75 0 0 0 0 1.5Z"]));
export const TextFirstLineRegular = ( /*#__PURE__*/createFluentIcon('TextFirstLineRegular', "1em", ["M16.65 3.15a.5.5 0 0 1 .7.7L16.21 5l1.14 1.15a.5.5 0 0 1-.7.7l-1.5-1.5a.5.5 0 0 1 0-.7l1.5-1.5ZM12.5 4a.5.5 0 0 1 0 1h-10a.5.5 0 0 1 0-1h10Zm5 10a.5.5 0 0 1 0 1h-15a.5.5 0 0 1 0-1h15Zm.5-4.5a.5.5 0 0 0-.5-.5h-15a.5.5 0 0 0 0 1h15a.5.5 0 0 0 .5-.5Z"]));
export const TextFontFilled = ( /*#__PURE__*/createFluentIcon('TextFontFilled', "1em", ["M6 2c.31 0 .59.2.7.48l2.27 5.94.05.13.03.1-.79 2.12-.48-1.27H4.22l-.77 2.02a.75.75 0 0 1-1.4-.53l3.25-8.5A.75.75 0 0 1 6 2ZM4.8 8h2.4L6 4.85 4.8 8Zm7.9-2.51a.75.75 0 0 0-1.4 0L7.2 16.5h-.44a.75.75 0 0 0 0 1.5h2.5a.75.75 0 1 0 0-1.5h-.47l.75-2h4.92l.75 2h-.46a.75.75 0 0 0 0 1.5h2.5a.75.75 0 0 0 0-1.5h-.44L12.7 5.49Zm1.2 7.5h-3.8L12 7.9l1.9 5.1Z"]));
export const TextFontRegular = ( /*#__PURE__*/createFluentIcon('TextFontRegular', "1em", ["M6 2c.2 0 .4.13.47.32L8.9 8.57v.02l.18.44-.53 1.4-.46-1.17H3.91l-.94 2.42a.5.5 0 1 1-.94-.36L3.1 8.59v-.02l2.43-6.25A.5.5 0 0 1 6 2ZM4.3 8.26h3.4L6 3.88 4.3 8.26Zm8.17-2.94a.5.5 0 0 0-.94 0L7.15 17H6.5a.5.5 0 0 0 0 1h2a.5.5 0 0 0 0-1h-.28l1.13-3h5.37l1.15 3h-.37a.5.5 0 1 0 0 1h2a.5.5 0 1 0 0-1h-.56L12.47 5.32ZM14.34 13H9.72l2.29-6.09L14.34 13Z"]));
export const TextFontInfoFilled = ( /*#__PURE__*/createFluentIcon('TextFontInfoFilled', "1em", ["M8.2 3.75a.75.75 0 0 0-1.42-.02L2.8 14.23a.75.75 0 1 0 1.4.54l.86-2.27H8.1c.1-.53.27-1.03.51-1.5H5.63l1.82-4.8 1.48 4.24c.32-.47.7-.9 1.15-1.25L8.2 3.75Zm5.3 7.13a.62.62 0 1 0 0 1.24.62.62 0 0 0 0-1.24Zm0 5.12a.5.5 0 0 0 .5-.5v-2a.5.5 0 0 0-1 0v2c0 .28.22.5.5.5Zm0-7a4.5 4.5 0 1 0 0 9 4.5 4.5 0 0 0 0-9Zm0 8a3.5 3.5 0 1 1 0-7 3.5 3.5 0 0 1 0 7Z"]));
